/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import com.thoughtworks.selenium.webdriven.commands.AlertOverride;
import com.thoughtworks.selenium.webdriven.commands.KeyState;
import java.util.logging.Logger;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Type
extends SeleneseCommand<Void> {
    private static final Logger log = Logger.getLogger(Type.class.getName());
    private final AlertOverride alertOverride;
    private final JavascriptLibrary js;
    private final ElementFinder finder;
    private final KeyState state;
    private final String type;

    public Type(AlertOverride alertOverride, JavascriptLibrary js, ElementFinder finder, KeyState state) {
        this.alertOverride = alertOverride;
        this.js = js;
        this.finder = finder;
        this.state = state;
        this.type = "return (" + js.getSeleniumScript("type.js") + ").apply(null, arguments);";
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String value) {
        this.alertOverride.replaceAlertMethod(driver);
        if (this.state.controlKeyDown || this.state.altKeyDown || this.state.metaKeyDown) {
            throw new SeleniumException("type not supported immediately after call to controlKeyDown() or altKeyDown() or metaKeyDown()");
        }
        String valueToUse = this.state.shiftKeyDown ? value.toUpperCase() : value;
        WebElement element = this.finder.findElement(driver, locator);
        String tagName = element.getTagName();
        String elementType = element.getAttribute("type");
        if ("input".equals(tagName.toLowerCase()) && elementType != null && "file".equals(elementType.toLowerCase())) {
            log.warning("You should be using attachFile to set the value of a file input element");
            element.sendKeys(valueToUse);
            return null;
        }
        if (!"input".equals(tagName.toLowerCase())) {
            if (driver instanceof JavascriptExecutor) {
                ((JavascriptExecutor)((Object)driver)).executeScript("arguments[0].value = '';", element);
            }
            element.sendKeys(valueToUse);
            return null;
        }
        if (driver instanceof JavascriptExecutor) {
            this.js.executeScript(driver, this.type, element, valueToUse);
        } else {
            element.clear();
            element.sendKeys(valueToUse);
        }
        return null;
    }
}

