/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.SeleniumServerHelper;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestRunnerSelenium;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.log.Logger;
import com.thoughtworks.selenium.Selenium;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TestShowcaseHelper
extends ConfiguredBase {
    private static final String OPEN_FOR_TESTING = "?autotest=showcase";
    private static final String MAX_REPORT_LENGTH = "&autotest_report_limit=";
    private static Logger log = new Logger(TestShowcaseHelper.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";

    protected static void testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] seleniumScripts, ShowcaseSpecifier showcase, TestRunnerHelper.TestCallback callback) {
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        seleniumServerHelper.startSeleniumServer();
        String testRootPath = config.getTestRoot(showcase);
        Map<String, List<String>> scripts = showcase.getSeleniumHTMLScripts(testRootPath, seleniumScripts);
        int port = SeleniumServerHelper.getInstance().getSeleniumPort();
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, config.getHttpBaseURL(showcase));
        selenium.start();
        RuntimeException fatalException = null;
        try {
            if (runUsualTests) {
                TestShowcaseHelper.testShowcaseExampleTree(browser, callback, (Selenium)selenium, scripts, showcase, runSelenium);
            } else if (runSelenium) {
                TestShowcaseHelper.loadExampleTree((Selenium)selenium, showcase);
                ArrayList<String> tests = new ArrayList<String>(scripts.keySet());
                for (String id : tests) {
                    if (!showcase.shouldTestExampleTreeNode((Selenium)selenium, id)) continue;
                    List<String> fileList = scripts.get(id);
                    TestShowcaseHelper.testSeleniumHTMLScripts(fileList, browser, callback, seleniumServerHelper, testRootPath, showcase, id);
                }
            }
        }
        catch (RuntimeException e) {
            fatalException = e;
        }
        if (((TestRunnerLauncher)config).onAwsServer()) {
            selenium.grab();
        }
        selenium.stop();
        seleniumServerHelper.stopSeleniumServer();
        if (fatalException != null) {
            log.error((Object)"Test framework aborted due to exception!");
            Utils.dumpStringToFile(tmpDir + "/awstest.exception.txt", ExceptionUtils.getStackTrace((Throwable)fatalException));
            throw fatalException;
        }
    }

    private static String loadExampleTree(Selenium selenium, ShowcaseSpecifier showcase) {
        String url = config.getHttpBaseURL(showcase) + config.getShowcaseFile(showcase) + OPEN_FOR_TESTING;
        int length = Utils.getMaximumReportLength();
        if (length > 0) {
            url = url + MAX_REPORT_LENGTH + length;
        }
        selenium.open(url);
        TestRunnerHelper.waitForElementPresent(selenium, showcase.getExampleTreeScLocator(), config.getSeleniumTimeout());
        return showcase.getExampleTreeObject();
    }

    private static void testShowcaseExampleTree(String browser, TestRunnerHelper.TestCallback callback, Selenium selenium, Map<String, List<String>> scripts, ShowcaseSpecifier showcase, boolean runSelenium) {
        boolean saveMessages = config.shouldSaveMessages();
        String testRootPath = config.getTestRoot(showcase);
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        int nRows = Integer.parseInt(selenium.getEval(TestShowcaseHelper.loadExampleTree(selenium, showcase) + ".getTotalRows()"));
        for (int row = 0; row < nRows; ++row) {
            List<String> fileList;
            TestSpecifier ts;
            String exampleTree = showcase.getExampleTreeObject();
            if (saveMessages) {
                Utils.clearDeveloperConsoleMessages(selenium);
            }
            selenium.getEval(exampleTree + ".scrollToRow(" + row + ");");
            selenium.getEval(exampleTree + ".redraw();");
            showcase.clearExampleResultsViewer(selenium);
            showcase.clearRPCManagerState(selenium);
            if (!showcase.shouldTestExampleTreeNode(selenium, row) || null == (ts = showcase.generateTestSpecifier(selenium, row))) continue;
            boolean runRcTests = runSelenium;
            if (showcase.isExampleTreeNodeANormalExample(selenium, row)) {
                TestCaseResults tcr = TestRunnerHelper.test(ts, browser, selenium, showcase, false);
                runRcTests &= tcr.allTestsSuccessful();
                callback.onTestResults(tcr);
                if (showcase.mustReloadExampleTree(tcr)) {
                    TestShowcaseHelper.loadExampleTree(selenium, showcase);
                }
            }
            String sampleId = ts.getTestId();
            if (!runRcTests || null == (fileList = scripts.get(sampleId))) continue;
            TestShowcaseHelper.testSeleniumHTMLScripts(fileList, browser, callback, seleniumServerHelper, testRootPath, showcase, sampleId);
        }
    }

    protected static void testSeleniumHTMLScripts(List testFiles, String browser, TestRunnerHelper.TestCallback callback, SeleniumServerHelper seleniumServerHelper, String testRootPath, ShowcaseSpecifier showcase, String smartClientId) {
        for (Object object : testFiles) {
            try {
                TestCaseResults tcr = TestRunnerHelper.testRctest(config.getHttpBaseURL(showcase), testRootPath, (String)object, browser, seleniumServerHelper, showcase, smartClientId);
                callback.onTestResults(tcr);
            }
            catch (IOException e) {
                log.error((Object)("Problems with selenium test: " + object), (Throwable)e);
            }
        }
    }
}

