/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCFileItem;
import com.isomorphic.servlet.ISCFileItemFactory;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.SessionByteCounter;
import com.isomorphic.util.DataTools;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISCHttpServletRequest
extends HttpServletRequestWrapper {
    private static Logger log = new Logger(ISCHttpServletRequest.class.getName());
    private static Config config = Config.getGlobal();
    boolean requestParsed = false;
    Map stringParams;
    Map allParams;
    Map fileParams;
    Map queryParams;
    Map<String, List<ISCFileItem>> fileParamsMulti;
    boolean requestIsMultipart;
    List fileItemParts;
    Exception parseException;
    Principal principal;
    boolean principalHasBeenSet = false;
    protected RequestContext context;
    protected IAuthenticator authenticator;

    public ISCHttpServletRequest(HttpServletRequest request) throws Exception {
        super(request);
        this.resetState();
    }

    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        if (request != this.getRequest()) {
            this.resetState();
        }
    }

    public void resetState() {
        this.requestParsed = false;
        this.fileParamsMulti = null;
        this.queryParams = null;
        this.fileParams = null;
        this.allParams = null;
        this.stringParams = null;
        this.fileItemParts = new ArrayList();
        this.requestIsMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)this.getHttpServletRequest());
    }

    public Map getQueryParams() {
        if (this.queryParams == null) {
            try {
                this.queryParams = ServletTools.parseQueryString(this.getHttpServletRequest().getQueryString());
            }
            catch (Exception e) {
                log.error((Object)"caught exception parsing queryParams", e);
                this.queryParams = new HashMap();
            }
        }
        return new HashMap(this.queryParams);
    }

    public String getQueryParameter(String paramName) {
        return (String)this.getQueryParams().get(paramName);
    }

    public Map getParams() throws Exception {
        if (this.allParams == null) {
            this.allParams = DataTools.mapUnion(this.getFileParams(), this.getStringParams());
        }
        return new HashMap(this.allParams);
    }

    public Map getStringParams() throws Exception {
        if (this.stringParams == null) {
            this.parseRequest();
            this.stringParams = ServletTools.paramsToMap((ServletRequest)this.getHttpServletRequest());
            for (FileItem item : this.fileItemParts) {
                if (!item.isFormField()) continue;
                String fieldName = item.getFieldName();
                String value = null;
                try {
                    value = item.getString("UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    log.warn("Can't parse field '" + fieldName + " using UTF-8 encoding, trying default");
                    value = item.getString();
                }
                this.stringParams.put(fieldName, value);
            }
        }
        return new HashMap(this.stringParams);
    }

    public Map getFileParams() throws Exception {
        return this.getFileParams(null);
    }

    public Map getFileParams(List errors) throws Exception {
        if (this.fileParams == null) {
            this.parseRequest(errors);
            this.fileParams = new HashMap();
            for (FileItem item : this.fileItemParts) {
                if (item.isFormField()) continue;
                this.fileParams.put(item.getFieldName(), item);
            }
        }
        return new HashMap(this.fileParams);
    }

    public Map<String, List<ISCFileItem>> getFileParamsMulti(List errors) throws Exception {
        if (this.fileParamsMulti == null) {
            this.parseRequest(errors);
            this.fileParamsMulti = new HashMap<String, List<ISCFileItem>>();
            for (FileItem item : this.fileItemParts) {
                if (item.isFormField()) continue;
                List<ISCFileItem> itemList = this.fileParamsMulti.get(item.getFieldName());
                if (itemList == null) {
                    itemList = new ArrayList<ISCFileItem>();
                    this.fileParamsMulti.put(item.getFieldName(), itemList);
                }
                itemList.add((ISCFileItem)item);
            }
        }
        return new HashMap<String, List<ISCFileItem>>(this.fileParamsMulti);
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public boolean isMultipart() {
        return this.requestIsMultipart;
    }

    public void parseRequest() throws Exception {
        this.parseRequest(null);
    }

    public void parseRequest(List errors) throws Exception {
        if (!this.isMultipart()) {
            return;
        }
        if (this.requestParsed) {
            if (errors != null && errors.size() > 0) {
                for (ISCFileItem fileItem : this.fileItemParts) {
                    List allErrors = fileItem.getErrors();
                    if (allErrors == null) {
                        allErrors = errors;
                    } else {
                        allErrors.addAll(errors);
                    }
                    fileItem.setErrors(allErrors);
                }
            }
            return;
        }
        long contentLength = this.getHttpServletRequest().getContentLength();
        Map queryParams = ServletTools.parseQueryString(this.getHttpServletRequest().getQueryString());
        String formID = (String)queryParams.get("formID");
        SessionByteCounter byteCounter = new SessionByteCounter(this.getHttpServletRequest(), contentLength, formID, errors);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new ISCFileItemFactory(byteCounter));
        upload.setHeaderEncoding("UTF-8");
        String maxFileSize = config.getString("fileUpload.maxFileSize", "-1");
        String maxTotalSize = config.getString("fileUpload.maxSize", "-1");
        upload.setSizeMax(Long.parseLong(maxTotalSize));
        upload.setFileSizeMax(Long.parseLong(maxFileSize));
        try {
            this.fileItemParts = upload.parseRequest(this.getHttpServletRequest());
            this.requestParsed = true;
        }
        catch (Exception fue) {
            this.parseException = fue;
        }
    }

    public boolean isAborted() {
        return this.parseException != null;
    }

    public Exception getAbortReason() {
        return this.parseException;
    }

    public ISCFileItem getUploadedFile(String fieldName) throws Exception {
        return this.getUploadedFile(fieldName, null);
    }

    public ISCFileItem getUploadedFile(String fieldName, List errors) throws Exception {
        if (!this.isMultipart()) {
            return null;
        }
        List<ISCFileItem> list = this.getUploadedFiles(fieldName, errors);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<ISCFileItem> getUploadedFiles(String fieldName) throws Exception {
        return this.getUploadedFiles(fieldName, null);
    }

    public List<ISCFileItem> getUploadedFiles(String fieldName, List errors) throws Exception {
        if (!this.isMultipart()) {
            return null;
        }
        Map<String, List<ISCFileItem>> map = this.getFileParamsMulti(errors);
        return map.get(fieldName);
    }

    public String getParameter(String name) {
        Object param = null;
        try {
            param = this.getStringParams().get(name);
        }
        catch (Exception e) {
            log.error((Object)"getParameter()", e);
            return null;
        }
        if (param == null) {
            return this.getHttpServletRequest().getParameter(name);
        }
        if (param instanceof String) {
            return param;
        }
        log.warning("Parameter " + name + " is multivalued, but is being fetched as single-valued");
        return (String)((List)param).get(0);
    }

    public Enumeration getParameterNames() {
        try {
            return new Hashtable(this.getStringParams()).keys();
        }
        catch (Exception e) {
            log.error((Object)"getParameterNames()", e);
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Object params = this.getStringParams().get(name);
            if (params == null) {
                return null;
            }
            if (params instanceof List) {
                return DataTools.listToStringArray((List)params);
            }
            String[] result = new String[]{params.toString()};
            return result;
        }
        catch (Exception e) {
            log.error((Object)"getParameterValues()", e);
            return null;
        }
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
        this.principalHasBeenSet = true;
    }

    public Principal getUserPrincipal() {
        if (this.principalHasBeenSet) {
            return this.principal;
        }
        if (this.authenticator != null && this.context != null) {
            try {
                return this.authenticator.getUser(this.context);
            }
            catch (Exception e) {
                return null;
            }
        }
        return super.getUserPrincipal();
    }

    public String getRemoteUser() {
        if (this.principalHasBeenSet) {
            return this.principal.getName();
        }
        if (this.authenticator != null && this.context != null) {
            try {
                return this.authenticator.getUser(this.context).getName();
            }
            catch (Exception e) {
                return null;
            }
        }
        return super.getRemoteUser();
    }

    public void setPrincipalContext(RequestContext context, IAuthenticator authenticator) {
        this.context = context;
        this.authenticator = authenticator;
    }
}

