/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IDoNotAdapt;
import com.isomorphic.util.LocaleMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSField
extends HashMap
implements IDoNotAdapt {
    public static final String STRING_IN_BROWSER = "stringInBrowser";

    public DSField(Map fieldData) {
        this(fieldData, null);
    }

    public DSField(Map fieldData, BasicDataSource ds) {
        BasicDataSource superDS;
        DSField superField;
        boolean hidden;
        DataTools.mapMerge(fieldData, this);
        boolean ignore = this.getBoolean("ignore");
        if (ignore && !(hidden = this.getBoolean("hidden"))) {
            this.put("hidden", Boolean.TRUE);
        }
        if (this.get("tableName") != null && this.get("canEdit") == null) {
            this.put("canEdit", Boolean.FALSE);
        }
        if (this.get("type") == null && ds.getSuper() != null && (superField = (superDS = ds.getSuper()).getField(this.getName())) != null && superField.getType() != null && !DataTools.getBoolean(superField, "unknownType")) {
            this.put("type", superField.getType());
            this.put("typeInherited", true);
        }
        if (this.get("type") != null) {
            this.put("typeExplicitlyDeclared", true);
        }
        if (ds != null) {
            try {
                String typeName = (String)fieldData.get("type");
                Map typeDef = BasicDataSource.getBuiltinType(typeName);
                if (typeDef != null) {
                    if (this.get("hidden") == null && typeDef.get("hidden") != null) {
                        this.put("hidden", typeDef.get("hidden"));
                    }
                    if (this.get("canView") == null && typeDef.get("canView") != null) {
                        this.put("canView", typeDef.get("canView"));
                    }
                    if (this.get("canSave") == null && typeDef.get("canSave") != null) {
                        this.put("canSave", typeDef.get("canSave"));
                    }
                    if (this.get("canEdit") == null && typeDef.get("canEdit") != null) {
                        this.put("canEdit", typeDef.get("canEdit"));
                    }
                    if (this.get("sqlStorageStrategy") == null && typeDef.get("sqlStorageStrategy") != null) {
                        this.put("sqlStorageStrategy", typeDef.get("sqlStorageStrategy"));
                    }
                    if (this.getType().equals("boolean") && this.get("sqlStorageStrategy") == null) {
                        if (ds.getConfig().get("defaultBooleanStorageStrategy") != null) {
                            this.put("sqlStorageStrategy", ds.getConfig().get("defaultBooleanStorageStrategy"));
                        } else if (Config.getProperty("sql.defaultBooleanStorageStrategy") != null) {
                            this.put("sqlStorageStrategy", (String)Config.getProperty("sql.defaultBooleanStorageStrategy"));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setIsBinary(ds);
    }

    private void setIsBinary(DataSource ds) {
        boolean isBinary = false;
        if (ds != null) {
            try {
                isBinary = ds.simpleTypeInheritsFrom(this.getType(), "binary");
            }
            catch (Exception exception) {}
        } else {
            isBinary = DataSource.simpleTypeInheritsFromBuiltInType(this.getType(), "binary");
        }
        if (isBinary) {
            this.put("isBinary", true);
        }
    }

    public boolean typeIsDefaulted() {
        return !Boolean.TRUE.equals(this.get("typeExplicitlyDeclared")) && !Boolean.TRUE.equals(this.get("typeInherited"));
    }

    public boolean getBoolean(String key) {
        return DataTools.getBoolean(this, key);
    }

    public boolean getBoolean(String key, boolean dft) {
        Object value = this.get(key);
        if (value == null) {
            return dft;
        }
        return this.getBoolean(key);
    }

    public String getName() {
        return (String)this.get("name");
    }

    public boolean isMultiple() {
        return this.getBoolean("multiple");
    }

    protected boolean canFallbackToSingle() {
        return this.getBoolean("fallbackToSingle");
    }

    public boolean isDerived() {
        return this.getBoolean("derived");
    }

    public boolean isRequired() {
        return this.getBoolean("required");
    }

    public String getType() {
        return (String)this.get("type");
    }

    public Long getLength() {
        if (this.get("length") == null) {
            return null;
        }
        return new Long(DataTools.getLong(this, "length"));
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(Locale locale) {
        Object title = this.get("title");
        if (title instanceof LocaleMessage) {
            return ((LocaleMessage)title).getMessage(locale);
        }
        return title == null ? null : title.toString();
    }

    public String getTitleKey() {
        Object title = this.get("title");
        if (title instanceof LocaleMessage) {
            return ((LocaleMessage)title).getKey();
        }
        return null;
    }

    public boolean isPrimaryKey() {
        return this.getBoolean("primaryKey");
    }

    public boolean isAutoGenerated() {
        if ("sequence".equals(this.getType())) {
            return true;
        }
        return this.getBoolean("autoGenerated");
    }

    public String getForeignKey() {
        return (String)this.get("foreignKey");
    }

    public void setForeignKey(String fk) {
        this.put("foreignKey", fk);
    }

    public String getNativeName() {
        return (String)(this.get("nativeName") != null ? this.get("nativeName") : this.get("fieldName"));
    }

    public String getUniqueProperty() {
        return (String)this.get("uniqueProperty");
    }

    public boolean isPropertiesOnly() {
        return this.getBoolean("propertiesOnly");
    }

    public String getValueXPath() {
        return (String)this.get("valueXPath");
    }

    public String getValueWriteXPath() {
        return (String)this.get("valueWriteXPath");
    }

    public boolean isBinary() {
        return this.getBoolean("isBinary", false);
    }

    public String getProperty(String property) {
        return (String)this.get(property);
    }

    public Object getObjectProperty(String property) {
        return this.get(property);
    }

    public List getListProperty(String property) {
        return (List)this.get(property);
    }

    public Map getMapProperty(String property) {
        return (Map)this.get(property);
    }

    public List getValidators() {
        return (List)this.get("validators");
    }

    public String getIncludeFrom() {
        return this.getProperty("includeFrom");
    }

    public IncludeFromDefinition getIncludeFromDefinition(DSRequest dsRequest) {
        String text = (String)this.get("includeFrom");
        if (text == null) {
            return null;
        }
        IncludeFromDefinition work = new IncludeFromDefinition(this, text, dsRequest);
        if (work.getDataSource() == null || work.getIncludedField() == null) {
            return null;
        }
        return work;
    }

    public String getBeanPropertyName() {
        String propertyName = this.getValueXPath();
        if (propertyName != null) {
            propertyName = propertyName.trim();
            while (propertyName.startsWith("/")) {
                propertyName = propertyName.substring(1);
            }
            propertyName = propertyName.replace('/', '.');
            return propertyName;
        }
        return this.getName();
    }

    public boolean shouldEncodeInResponse() {
        return this.isBinary() && this.getBoolean("encodeInResponse", false);
    }

    public boolean canView() {
        return DataTools.getBoolean(this, "canView", true);
    }

    public boolean isInapplicable() {
        return DataTools.getBoolean(this, "inapplicable", false);
    }

    public int getJoinType() {
        if ("outer".equals(this.get("joinType"))) {
            return 1;
        }
        return 0;
    }

    public boolean ignore() {
        return DataTools.getBoolean(this, "ignore", false);
    }

    public String getNativeFK() {
        return (String)this.get("nativeFK");
    }

    public String getMimeType() {
        return (String)this.get("mimeType");
    }

    public void setMimeType(String mimeType) {
        this.put("mimeType", mimeType);
    }

    public Boolean shouldIgnoreTextMatchStyle() {
        return DataTools.getBooleanObject(this, "ignoreTextMatchStyle");
    }

    public void setIgnoreTextMatchStyle(Boolean value) {
        this.put("ignoreTextMatchStyle", value);
    }

    public boolean isLenientXPath() {
        return DataTools.getBoolean(this, "lenientXPath", false);
    }

    public Map<String, Object> getValueMap() {
        Object values = this.get("valueMap");
        if (values == null) {
            return null;
        }
        if (values instanceof Map) {
            return (Map)values;
        }
        List valueList = (List)values;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object value : valueList) {
            map.put(value.toString(), value);
        }
        return map;
    }

    public String getMultipleStorage() {
        return this.getProperty("multipleStorage");
    }

    public String getMultipleStorageSeparator() {
        return this.getProperty("multipleStorageSeparator");
    }

    public String getMultipleValueSeparator() {
        String separator = this.getProperty("multipleValueSeparator");
        return separator != null ? separator : ", ";
    }

    public boolean shouldStoreMilliseconds() {
        return DataTools.getBoolean(this, "storeMilliseconds", false);
    }

    public static final class Type {
        public static final String TEXT = "text";
        public static final String BOOLEAN = "boolean";
        public static final String INTEGER = "integer";
        public static final String FLOAT = "float";
        public static final String DATE = "date";
        public static final String DATETIME = "datetime";
        public static final String TIME = "time";
        public static final String ENUM = "enum";
        public static final String INT_ENUM = "intEnum";
        public static final String SEQUENCE = "sequence";
        public static final String LINK = "link";
        public static final String IMAGE = "image";
        public static final String BINARY = "binary";
        public static final String IMAGE_FILE = "imageFile";
        public static final String MODIFIER = "modifier";
        public static final String MODIFIER_TIMESTAMP = "modifierTimestamp";
        public static final String CREATOR = "creator";
        public static final String CREATOR_TIMESTAMP = "creatorTimestamp";
    }
}

