/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.mail;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.MailMessage;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;

public class TemplatedMailMessage
extends MailMessage {
    String configRoot = null;
    private static Logger log = new Logger(TemplatedMailMessage.class.getName());
    private Map contextMap;
    private String messageTemplate;
    private String templateFile;
    private boolean parseMessage = true;
    private boolean mergeVariables = true;
    private String contentType;
    private String encoding;

    public void setContextMap(Map value) {
        this.contextMap = value;
    }

    public Map getContextMap() {
        return this.contextMap;
    }

    public void setMessageTemplate(String value) {
        this.messageTemplate = value;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setTemplateFile(String value) {
        this.templateFile = value;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public void setParseMessage(boolean value) {
        this.parseMessage = value;
    }

    public boolean getParseMessage() {
        return this.parseMessage;
    }

    public void setMergeVariables(boolean value) {
        this.mergeVariables = value;
    }

    public boolean getMergeVariables() {
        return this.mergeVariables;
    }

    public void setContentType(String value) {
        this.contentType = value;
    }

    public String getContentType() throws MessagingException {
        if (this.contentType != null) {
            return this.contentType;
        }
        return super.getContentType();
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return super.getEncoding();
    }

    public TemplatedMailMessage() {
        this(null);
    }

    public TemplatedMailMessage(String configRoot) {
        this.configRoot = configRoot;
    }

    public void addRecipient(String recipient) {
        this.addRecipient(recipient, Message.RecipientType.TO);
    }

    public void setRecipient(String recipient) {
        this.addRecipient(recipient);
    }

    public void addRecipients(List recipients) {
        this.addRecipients(recipients, Message.RecipientType.TO);
    }

    public void buildMessage(Map templateMap, String template) throws Exception {
        if (template != null) {
            if (this.configRoot != null) {
                log.debug("Using prefix: " + this.configRoot);
                Config configTemplateMap = config.getSubtree(this.configRoot);
                templateMap = DataTools.orderedMapUnion(templateMap, (Map)((Object)configTemplateMap));
            }
            if (log == null) {
                System.out.println("log is null");
            } else {
                log.debug((Object)"Template map", templateMap);
            }
            String templateRoot = config.getPath("mail.templateRoot");
            if (templateRoot != null) {
                String templateFile = templateRoot + "/";
                if (template != null) {
                    templateFile = templateFile + template;
                } else if (this.configRoot != null) {
                    templateFile = templateFile + config.getPath(this.configRoot + ".template");
                }
                log.info((Object)"Template filename", templateFile);
                String mess = TemplatedMailMessage.mergeTemplate(templateFile, templateMap);
                super.parse(mess);
            } else {
                log.warn("Template filename not found - mail.templateRoot not set");
            }
        }
        super.buildMessage();
    }

    public void buildMessage(Map templateMap, List templates) throws Exception {
        if (this.configRoot != null) {
            log.debug("Using prefix: " + this.configRoot);
            Config configTemplateMap = config.getSubtree(this.configRoot);
            templateMap = DataTools.orderedMapUnion(templateMap, (Map)((Object)configTemplateMap));
        }
        log.debug((Object)"Template map", templateMap);
        String templateDir = config.getPath("mail.templateRoot") + "/";
        StringBuffer contents = new StringBuffer();
        Iterator e = templates.iterator();
        while (e.hasNext()) {
            String templateFile = templateDir + (String)e.next();
            log.debug((Object)"Template filename", templateFile);
            contents.append(TemplatedMailMessage.mergeTemplate(templateFile, templateMap));
        }
        log.info("Message assembled from templates:" + templates);
        super.parse(contents.toString());
    }

    public void buildMessage(List templateMaps, List templates) throws Exception {
        if (templateMaps.size() != templates.size()) {
            throw new IOException("Number of template maps does not match number of template files");
        }
        String templateDir = config.getPath("mail.templateRoot") + "/";
        StringBuffer contents = new StringBuffer();
        Config configTemplateMap = null;
        if (this.configRoot != null) {
            log.debug("Using prefix: " + this.configRoot);
            configTemplateMap = config.getSubtree(this.configRoot);
        }
        Iterator mapEnum = templateMaps.iterator();
        Iterator fileEnum = templates.iterator();
        while (mapEnum.hasNext()) {
            Map templateMap = (Map)mapEnum.next();
            templateMap = DataTools.orderedMapUnion(templateMap, (Map)((Object)configTemplateMap));
            log.debug((Object)"Template map", templateMap);
            String templateFile = templateDir + (String)fileEnum.next();
            log.debug((Object)"Template filename", templateFile);
            contents.append(TemplatedMailMessage.mergeTemplate(templateFile, templateMap));
        }
        log.info("Message assembled from templates:" + templates);
        super.parse(contents.toString());
    }

    void processMessageText() throws Exception {
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
        }
        if (this.messageTemplate != null && this.templateFile != null) {
            log.warn("Both messageTemplate and templateFile are set, ignoring templateFile");
        }
        if (this.messageTemplate != null) {
            this.parse(TemplatedMailMessage.mergeTemplateString(this.messageTemplate, this.contextMap));
        } else if (this.templateFile != null) {
            String templateFile = this.templateFile;
            String templateDir = config.getPath("mail.templateRoot");
            if (templateDir != null) {
                templateFile = templateDir + "/" + templateFile;
            }
            this.parse(TemplatedMailMessage.mergeTemplate(templateFile, this.contextMap));
        } else if (this.body == null) {
            this.setBody("");
        }
        if (this.contextMap == null) {
            return;
        }
        if (this.sender != null) {
            this.sender = Velocity.evaluateAsString(this.sender, this.contextMap);
        }
        if (this.subject != null) {
            this.subject = Velocity.evaluateAsString(this.subject, this.contextMap);
        }
        HashMap temp = new HashMap();
        for (String key : this.recipients.keySet()) {
            Object newKeyObj = Velocity.evaluate(key, this.contextMap);
            if (newKeyObj instanceof List) {
                Iterator i2 = ((List)newKeyObj).iterator();
                while (i2.hasNext()) {
                    String[] newKeys = i2.next().toString().split(",");
                    for (int j = 0; j < newKeys.length; ++j) {
                        temp.put(newKeys[j], this.recipients.get(key));
                    }
                }
                continue;
            }
            String[] newKeys = newKeyObj.toString().split(",");
            for (int j = 0; j < newKeys.length; ++j) {
                temp.put(newKeys[j], this.recipients.get(key));
            }
        }
        this.recipients = temp;
        ArrayList<String> tempList = new ArrayList<String>();
        Iterator i = this.replyTo.iterator();
        while (i.hasNext()) {
            tempList.add(Velocity.evaluateAsString((String)i.next(), this.contextMap));
        }
        this.replyTo = tempList;
    }

    public static void send(Map templateMap, String template) throws Exception {
        TemplatedMailMessage.send(null, templateMap, template);
    }

    public static void send(String configRoot, Map templateMap, String template) throws Exception {
        try {
            TemplatedMailMessage msg = new TemplatedMailMessage(configRoot);
            msg.buildMessage(templateMap, template);
            msg.send();
        }
        catch (Exception e) {
            log.error("Unable to send templated mail " + template + " with templateMap" + templateMap.toString());
            throw e;
        }
    }

    public static void send(Map templateMap, List templates) throws Exception {
        TemplatedMailMessage.send(null, templateMap, templates);
    }

    public static void send(String configRoot, Map templateMap, List templates) throws Exception {
        try {
            TemplatedMailMessage msg = new TemplatedMailMessage(configRoot);
            msg.buildMessage(templateMap, templates);
            msg.send();
        }
        catch (Exception ioe) {
            log.error("Unable to send templated mail " + templates.toString() + " with templateMap" + templateMap.toString());
            throw ioe;
        }
    }

    public static void send(List templateMaps, List templates) throws Exception {
        TemplatedMailMessage.send(null, templateMaps, templates);
    }

    public static void send(String configRoot, List templateMaps, List templates) throws Exception {
        try {
            TemplatedMailMessage msg = new TemplatedMailMessage(configRoot);
            msg.buildMessage(templateMaps, templates);
            msg.send();
        }
        catch (Exception ioe) {
            log.error("Unable to send templated mail " + templates.toString() + " with templateMap" + templateMaps.toString());
            throw ioe;
        }
    }

    public static void sendSystemMail(Map templateMap, String template) throws Exception {
        TemplatedMailMessage.sendSystemMail(null, templateMap, template);
    }

    public static void sendSystemMail(String configRoot, Map templateMap, String template) throws Exception {
        templateMap.put("from", config.getString("mail.systemFromAddress"));
        templateMap.put("helpdeskAddress", config.getString("mail.helpdeskAddress"));
        templateMap.put("URLPrefix", config.getString("mail.URLPrefix"));
        DataTools.putAllNotPresent(templateMap, (Map)((Object)config.getSubtree("mail.params")));
        TemplatedMailMessage.send(configRoot, templateMap, template);
    }

    public static void sendSystemMail(Map templateMap, List templates) throws Exception {
        TemplatedMailMessage.sendSystemMail(null, templateMap, templates);
    }

    public static void sendSystemMail(String configRoot, Map templateMap, List templates) throws Exception {
        templateMap.put("from", config.getString("mail.systemFromAddress"));
        templateMap.put("helpdeskAddress", config.getString("mail.helpdeskAddress"));
        templateMap.put("URLPrefix", config.getString("mail.URLPrefix"));
        TemplatedMailMessage.send(configRoot, templateMap, templates);
    }

    public static void sendSystemMail(List templateMaps, List templates) throws Exception {
        TemplatedMailMessage.sendSystemMail(null, templateMaps, templates);
    }

    public static void sendSystemMail(String configRoot, List templateMaps, List templates) throws Exception {
        for (Map map : templateMaps) {
            map.put("from", config.getString("mail.systemFromAddress"));
            map.put("helpdeskAddress", config.getString("mail.helpdeskAddress"));
            map.put("URLPrefix", config.getString("mail.URLPrefix"));
        }
        TemplatedMailMessage.send(configRoot, templateMaps, templates);
    }

    public static String mergeTemplate(String templateFile, Map contextMap) throws Exception {
        return Velocity.evaluateTemplateFileAsString(templateFile, contextMap);
    }

    public static String mergeTemplateString(String template, Map contextMap) throws Exception {
        return Velocity.evaluateAsString(template, contextMap);
    }
}

