/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.interfaces.ICompression;
import com.isomorphic.interfaces.IInstanceSingleton;
import com.isomorphic.log.Logger;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class Compression
implements ICompression,
IInstanceSingleton {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Compression.class.getName());
    static ByteArrayOutputStream whiteSpace = null;
    public static int whiteSpaceBufSize = 2049;

    private static ByteArrayOutputStream getWhiteSpaceBuffer() {
        if (whiteSpace == null) {
            whiteSpace = new ByteArrayOutputStream();
            for (int i = 0; i < whiteSpaceBufSize; ++i) {
                whiteSpace.write(32);
            }
            whiteSpace.write(10);
        }
        return whiteSpace;
    }

    private static boolean mimeTypeRequiresPadding(String mimeType) {
        return mimeType != null && (mimeType.indexOf("javascript") != -1 || mimeType.indexOf("ecmascript") != -1);
    }

    public ByteArrayOutputStream compressBuffer(ByteArrayOutputStream wrapBuf, String mimeType) throws Exception {
        return this.compressBuffer(wrapBuf.toByteArray(), mimeType);
    }

    public ByteArrayOutputStream compressBuffer(ByteArrayOutputStream wrapBuf, boolean addPadding) throws Exception {
        return this.compressBuffer(wrapBuf.toByteArray(), addPadding);
    }

    public ByteArrayOutputStream compressBuffer(byte[] buf, String mimeType) throws Exception {
        return this.compressBuffer(buf, Compression.mimeTypeRequiresPadding(mimeType));
    }

    public ByteArrayOutputStream compressBuffer(byte[] buf, boolean addPadding) throws Exception {
        GZIPOutputStream gzipOut;
        int wrapBufSize;
        int gzipBufSize = wrapBufSize = buf.length;
        if (addPadding) {
            gzipBufSize += whiteSpaceBufSize;
        }
        ByteArrayOutputStream compressedBuf = new ByteArrayOutputStream(gzipBufSize / 4);
        GZIPOutputStream gZIPOutputStream = gzipOut = gzipBufSize <= 0 ? new GZIPOutputStream(compressedBuf) : new GZIPOutputStream((OutputStream)compressedBuf, gzipBufSize);
        if (addPadding) {
            Compression.getWhiteSpaceBuffer().writeTo(gzipOut);
        }
        gzipOut.write(buf);
        gzipOut.flush();
        gzipOut.close();
        compressedBuf.flush();
        if (config.getBoolean((Object)"compression.dumpCompressionBuffer", false)) {
            log.info("Compressed buffer: start -->" + (addPadding ? Compression.getWhiteSpaceBuffer().toString() : "") + new String(buf) + "<-- end");
        }
        return compressedBuf;
    }

    public OutputStream getPrimedGZIPOutputStream(OutputStream out, String mimeType) throws Exception {
        return this.getPrimedGZIPOutputStream(out, Compression.mimeTypeRequiresPadding(mimeType));
    }

    public OutputStream getPrimedGZIPOutputStream(OutputStream out, boolean addPadding) throws Exception {
        GZIPOutputStream gzipOut = new GZIPOutputStream(out);
        if (addPadding) {
            Compression.getWhiteSpaceBuffer().writeTo(gzipOut);
        }
        return gzipOut;
    }

    public ByteArrayOutputStream compressStream(InputStream in, String mimeType) throws Exception {
        return this.compressStream(in, Compression.mimeTypeRequiresPadding(mimeType));
    }

    public ByteArrayOutputStream compressStream(InputStream in, boolean addPadding) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtil.copyStreams(in, out);
        return this.compressBuffer(out, addPadding);
    }

    public Object staticInstance() throws Exception {
        return new Compression();
    }
}

