/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util.date;

import com.isomorphic.util.date.RelativeDateRangePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelativeDateShortcut {
    NOW("$now", "+0MS"),
    TODAY("$today"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "+0D";
            }
            return "-0D";
        }
    }
    ,
    START_OF_TODAY("$startOfToday", "-0D"),
    END_OF_TODAY("$endOfToday", "+0D"),
    YESTERDAY("$yesterday"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "-1d[+0D]";
            }
            return "-1D";
        }
    }
    ,
    START_OF_YESTERDAY("$startOfYesterday", "-1D"),
    END_OF_YESTERDAY("$endOfYesterday", "-1d[+0D]"),
    TOMORROW("$tomorrow"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "+1D";
            }
            return "+1d[-0D]";
        }
    }
    ,
    START_OF_TOMORROW("$startOfTomorrow", "+1d[-0D]"),
    END_OF_TOMORROW("$endOfTomorrow", "+1D"),
    WEEK_AGO("$weekAgo"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "-1w[+0D]";
            }
            return "-1w[-0D]";
        }
    }
    ,
    WEEK_FROM_NOW("$weekFromNow"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "+1w[+0D]";
            }
            return "+1w[-0D]";
        }
    }
    ,
    START_OF_WEEK("$startOfWeek", "-0W"),
    END_OF_WEEK("$endOfWeek", "+0W"),
    MONTH_AGO("$monthAgo"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "-1m[+0D]";
            }
            return "-1m[-0D]";
        }
    }
    ,
    MONTH_FROM_NOW("$monthFromNow"){

        public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
            if (RelativeDateRangePosition.END.equals((Object)relativeDataRangePosition)) {
                return "+1m[+0D]";
            }
            return "+1m[-0D]";
        }
    }
    ,
    START_OF_MONTH("$startOfMonth", "-0M"),
    END_OF_MONTH("$endOfMonth", "+0M"),
    START_OF_YEAR("$startOfYear", "-0Y"),
    END_OF_YEAR("$endOfYear", "+0Y");

    private final String shortcut;
    private final String defaultValue;

    private RelativeDateShortcut(String shortcut) {
        this(shortcut, "");
    }

    private RelativeDateShortcut(String shortcut, String defaultValue) {
        this.shortcut = shortcut;
        this.defaultValue = defaultValue;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public String toRelativeDateString(RelativeDateRangePosition relativeDataRangePosition) {
        return this.defaultValue;
    }

    public static RelativeDateShortcut parseShortcut(String shortcut) {
        for (RelativeDateShortcut relativeDateShortcut : RelativeDateShortcut.values()) {
            if (!relativeDateShortcut.shortcut.equals(shortcut)) continue;
            return relativeDateShortcut;
        }
        return null;
    }
}

