/*
 Isomorphic SmartClient web presentation layer
 Online documentation data
 Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
*/


var docItems = {
    "attr:ImgButton.showRollOverIcon":{
        ref:"attr:ImgButton.showRollOverIcon",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showRollOverIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image on mouse rollover.",
        groups:[
            "buttonIcon"
        ],
        definingClass:"class:ImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.eventAutoArrange":{
        ref:"attr:Calendar.eventAutoArrange",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"eventAutoArrange",
        flags:"IR",
        description:"If set to true, enables the auto-arrangement of events that share time in the calendar.  The\n default is true.",
        groups:[
            "calendarEvent"
        ],
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SectionStackSection.showClippedTitleOnHover":{
        ref:"attr:SectionStackSection.showClippedTitleOnHover",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showClippedTitleOnHover",
        flags:"IRW",
        description:"If true and the title is clipped, then a hover containing the full title of this section header\n is enabled.",
        groups:[
            "hovers"
        ],
        definingClass:"object:SectionStackSection",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataSource.setCacheAllData":{
        ref:"method:DataSource.setCacheAllData",
        deprecated:null,
        name:"setCacheAllData",
        flags:"",
        description:" Call this method to switch cacheAllData on or off after initialization.  Passing a \n <code>shouldCache</code> value of false clears any existing client-side cache,\n cancels any outstanding requests for a full cache and issues any other pending requests\n normally.\n \n",
        groups:[
            "clientData"
        ],
        definingClass:"class:DataSource",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"shouldCache",
                description:"New value for ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')}",
                optional:false,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataBoundComponent.fieldEditorWindow":{
        ref:"attr:DataBoundComponent.fieldEditorWindow",
        defaultValue:"null",
        valueType:"AutoChild Window",
        deprecated:null,
        name:"fieldEditorWindow",
        flags:"R",
        description:"The ${isc.DocUtils.linkForRef('class:Window')} used to edit calculated fields for this component.",
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Canvas.hover":{
        ref:"method:Canvas.hover",
        deprecated:null,
        name:"hover",
        flags:"",
        description:" If <code>canHover</code> is true for this widget, the <code>hover</code> string method will\n be fired when the user hovers over this canvas. If this method returns false, it will\n suppress the default behavior of showing a hover canvas if <code>this.showHover</code>\n is true.\n",
        groups:[
            "hovers"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"false to cancel the hover event.",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"attr:Canvas.canHover",
                description:null
            }
        ]
    },
    "method:FormItem.doubleClick":{
        ref:"method:FormItem.doubleClick",
        deprecated:null,
        name:"doubleClick",
        flags:"",
        description:" Called when this FormItem is double-clicked.\n\n",
        groups:[
            "eventHandling"
        ],
        definingClass:"class:FormItem",
        returns:{
            description:"Return false to cancel the doubleClick event. This will prevent the event from   bubbling up, suppressing\n   ${isc.DocUtils.linkForRef('method:Canvas.doubleClick','doubleClick')} on the form containing this item.",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"form",
                description:"the managing DynamicForm instance",
                optional:false,
                type:"DynamicForm"
            },
            {
                defaultValue:null,
                name:"item",
                description:"the form item itself (also available as \"this\")",
                optional:false,
                type:"FormItem"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.removedCSSText":{
        ref:"attr:ListGrid.removedCSSText",
        defaultValue:"\"text-decoration:line-through;\"",
        valueType:"string",
        deprecated:null,
        name:"removedCSSText",
        flags:"IRWA",
        description:"Custom CSS text to be applied to records that have been\n ${isc.DocUtils.linkForRef('method:ListGrid.markRecordRemoved','marked for removal')}.\n <P>\n This CSS text will be applied on top of standard disabled styling for the cell.",
        groups:[
            "appearance"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:EditPane.hideGroupBorderOnDrag":{
        ref:"attr:EditPane.hideGroupBorderOnDrag",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"hideGroupBorderOnDrag",
        flags:"IR",
        description:"Should the group selection box shown when ${isc.DocUtils.linkForRef('attr:EditContext.canGroupSelect','canGroupSelect')}\n is true be hidden during drag?\n <P>\n Treated as <code>true</code> if not explicitly set to false.",
        definingClass:"class:EditPane",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FilterBuilder.clauseStack":{
        ref:"attr:FilterBuilder.clauseStack",
        defaultValue:"null",
        valueType:"AutoChild VStack",
        deprecated:null,
        name:"clauseStack",
        flags:"IR",
        description:"VStack of all clauses that are part of this FilterBuilder",
        definingClass:"class:FilterBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawCurve.controlPoint2":{
        ref:"attr:DrawCurve.controlPoint2",
        defaultValue:"[0,100]",
        valueType:"Point",
        deprecated:null,
        name:"controlPoint2",
        flags:"IRW",
        description:"Second cubic bezier control point.",
        definingClass:"class:DrawCurve",
        type:"attr",
        setter:[
            "setControlPoint2"
        ],
        seeAlso:[
        ]
    },
    "attr:DrawCurve.controlPoint1":{
        ref:"attr:DrawCurve.controlPoint1",
        defaultValue:"[100,0]",
        valueType:"Point",
        deprecated:null,
        name:"controlPoint1",
        flags:"IRW",
        description:"First cubic bezier control point.",
        definingClass:"class:DrawCurve",
        type:"attr",
        setter:[
            "setControlPoint1"
        ],
        seeAlso:[
        ]
    },
    "method:DrawPath.resizeBy":{
        ref:"method:DrawPath.resizeBy",
        deprecated:null,
        name:"resizeBy",
        flags:"",
        description:" Resize by the specified delta\n",
        definingClass:"class:DrawPath",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dX",
                description:"number of pixels to resize by horizontally",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"dY",
                description:"number of pixels to resize by vertically",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:EventCanvas.showGripper":{
        ref:"attr:EventCanvas.showGripper",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"showGripper",
        flags:"IRW",
        description:"When set to true, shows the ${isc.DocUtils.linkForRef('attr:EventCanvas.gripper','gripper')} component, which snaps,\n centered, to the top edge of the eventCanvas and can be used to move it with the mouse.",
        definingClass:"class:EventCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Scrollbar.showCorner":{
        ref:"attr:Scrollbar.showCorner",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showCorner",
        flags:"IRA",
        description:"If true, displays a corner piece at the bottom end of a vertical scrollbar, or the\n right end of a horizontal scrollbar. This is typically set only when both horizontal\n and vertical scrollbars are displayed and about the same corner.",
        groups:[
            "corner"
        ],
        definingClass:"class:Scrollbar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:EditProxy.showSelectedAppearance":{
        ref:"method:EditProxy.showSelectedAppearance",
        deprecated:null,
        name:"showSelectedAppearance",
        flags:"",
        description:" This method applies the ${isc.DocUtils.linkForRef('attr:EditProxy.selectedAppearance','selectedAppearance')} to the selected component\n or resets it to the non-selected appearance. Override this method to create a custom\n appearance.\n\n",
        definingClass:"class:EditProxy",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"show",
                description:"true to show component as selected, false otherwise",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:CubeGrid.sortDirection":{
        ref:"attr:CubeGrid.sortDirection",
        defaultValue:"\"ascending\"",
        valueType:"SortDirection",
        deprecated:null,
        name:"sortDirection",
        flags:"IRW",
        description:"Direction of sorting if sortedFacet or sortedFacetValues is specified.",
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RangeSlider.startValue":{
        ref:"attr:RangeSlider.startValue",
        defaultValue:"0",
        valueType:"float",
        deprecated:null,
        name:"startValue",
        flags:"IRW",
        description:"The beginning of the selected range.",
        definingClass:"class:RangeSlider",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:List.add":{
        ref:"method:List.add",
        deprecated:null,
        name:"add",
        flags:"",
        description:" Add an object to this list, at the end\n\n",
        groups:[
            "modification"
        ],
        definingClass:"interface:List",
        returns:{
            description:"pointer to the object passed in",
            type:"any"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"object",
                description:"object to add",
                optional:false,
                type:"any"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Canvas.resizeBy":{
        deprecated:null,
        flags:"",
        description:"          Resizes the widget, adding deltaX to its width and deltaY to its height (moves the right\n          and/or bottom sides of the widget).\n",
        groups:[
            "sizing"
        ],
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"deltaX",
                description:"amount to resize horizontally (may be negative)",
                optional:true,
                type:"number"
            },
            {
                defaultValue:null,
                name:"deltaY",
                description:"amount to resize vertically (may be negative)",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.resizeBy",
        examples:[
            "${isc.DocUtils.linkForExampleId('resize')}"
        ],
        name:"resizeBy",
        definingClass:"class:Canvas",
        returns:{
            description:"whether the component actually changed size",
            type:"Boolean"
        }
    },
    "method:Canvas.destroy":{
        ref:"method:Canvas.destroy",
        deprecated:null,
        name:"destroy",
        flags:"A",
        description:" Permanently destroy a Canvas and all of it's children / members, recursively.\n <P>\n Like ${isc.DocUtils.linkForRef('method:Canvas.clear')}, calling <code>destroy()</code> removes all HTML for the component;\n unlike clear(), a destroyed Canvas is permanently unusable: it cannot be draw()'n again,\n cannot be referenced by its global ID, and is eligible for garbage collection (assuming\n that application code is not holding a reference to the Canvas).\n <P>\n Any attempt to call a method on a destroyed Canvas will generally result in an error.  If your\n application is forced to hold onto Canvas's that might be destroy()d without warning, you can\n avoid errors by checking for the ${isc.DocUtils.linkForRef('attr:Canvas.destroyed')} property.  If you override certain Canvas\n methods, your code may be called while a Canvas is being destroy()d; in this case you can avoid\n extra work (and possibly errors) by checking for the ${isc.DocUtils.linkForRef('attr:Canvas.destroying')} property.\n <P>\n Note that <code>destroy()</code> should not be called directly in event handling code for this\n canvas. For this reason, wherever possible we recommend using ${isc.DocUtils.linkForRef('method:Canvas.markForDestroy')}\n instead of calling this method directly.\n\n",
        definingClass:"class:Canvas",
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.markForDestroy",
                description:null
            },
            {
                ref:"group:memoryLeaks",
                description:null
            }
        ]
    },
    "attr:JSONEncoder.circularReferenceMarker":{
        ref:"attr:JSONEncoder.circularReferenceMarker",
        defaultValue:"\"$$BACKREF$$\"",
        valueType:"String",
        deprecated:null,
        name:"circularReferenceMarker",
        flags:"IR",
        description:"The string marker used to represent circular references.  See ${isc.DocUtils.linkForRef('attr:JSONEncoder.circularReferenceMode')}.",
        definingClass:"class:JSONEncoder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.showErrorIcons":{
        ref:"attr:ListGrid.showErrorIcons",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"showErrorIcons",
        flags:"IRW",
        description:"If this grid is editable, and an edit has caused validation failure for some cell,\n  should we show an icon to indicate validation failure?",
        groups:[
            "errorIcon"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.canEdit":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Can this field be edited?  May be overridden by setting the 'canEdit' property at the\n listGrid level. If not explicitly set and this grid is bound to a dataSource, the\n ${isc.DocUtils.linkForRef('attr:ListGrid.canEditFieldAttribute')} may be used to set default editability at the field level.\n <p>\n For more dynamic control over whether fields can be edited, see\n ${isc.DocUtils.linkForRef('method:ListGrid.canEditCell')}.\n\n ",
        groups:[
            "editing"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGrid.canEdit",
                description:null
            },
            {
                ref:"attr:ListGrid.recordEditProperty",
                description:null
            },
            {
                ref:"method:ListGrid.canEditCell",
                description:null
            }
        ],
        ref:"attr:ListGridField.canEdit",
        examples:[
            "${isc.DocUtils.linkForExampleId('disableEditing')}"
        ],
        valueType:"boolean",
        name:"canEdit",
        definingClass:"object:ListGridField"
    },
    "attr:Gauge.maxValue":{
        ref:"attr:Gauge.maxValue",
        defaultValue:"100",
        valueType:"float",
        deprecated:null,
        name:"maxValue",
        flags:"IRW",
        description:"The maximum dial value.",
        definingClass:"class:Gauge",
        type:"attr",
        setter:[
            "setMaxValue"
        ],
        seeAlso:[
        ]
    },
    "attr:RestDataSource.updateDataURL":{
        ref:"attr:RestDataSource.updateDataURL",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"updateDataURL",
        flags:"IR",
        description:"Custom ${isc.DocUtils.linkForRef('attr:DataSource.dataURL','dataURL')} for ${isc.DocUtils.linkForRef('class:DSRequest','DSRequests')} with\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType','operationType')} \"update\".\n <p>\n See ${isc.DocUtils.linkForRef('attr:RestDataSource.dataURL')} to configure a single URL for all requests, which is\n required to support ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue')}.",
        definingClass:"class:RestDataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:RelativeDateItem.getAbsoluteDate":{
        ref:"classMethod:RelativeDateItem.getAbsoluteDate",
        deprecated:null,
        name:"getAbsoluteDate",
        flags:"",
        description:"  Converts a ${isc.DocUtils.linkForRef('object:RelativeDate')}, ${isc.DocUtils.linkForRef('type:RelativeDateShortcut')} or ${isc.DocUtils.linkForRef('type:RelativeDateString')} \n to a concrete Date.\n",
        definingClass:"class:RelativeDateItem",
        returns:{
            description:"resulting absolute date value",
            type:"Date"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"relativeDate",
                description:"the relative date to convert",
                optional:false,
                type:"RelativeDate"
            },
            {
                defaultValue:null,
                name:"baseDate",
                description:"base value for conversion.  Defaults to today",
                optional:true,
                type:"Date"
            }
        ],
        seeAlso:[
        ]
    },
    "group:fields":{
        ref:"group:fields",
        refs:[
            "type:DSInheritanceMode",
            "attr:DataSource.fields",
            "attr:DataSource.inheritsFrom",
            "attr:DataSource.inheritanceMode",
            "attr:DataSource.useFlatFields",
            "attr:DataSource.showLocalFieldsOnly",
            "attr:DataSource.useParentFieldOrder",
            "attr:DataSource.schemaBean",
            "attr:DataSource.idClassName"
        ],
        deprecated:null,
        name:"fields",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "method:Calendar.scrollToTime":{
        ref:"method:Calendar.scrollToTime",
        deprecated:null,
        name:"scrollToTime",
        flags:"",
        description:" Scroll the calendar Day or Week views to the specified time.\n",
        definingClass:"class:Calendar",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"time",
                description:"any parsable time-string",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Date.toUSShortDateTime":{
        ref:"method:Date.toUSShortDateTime",
        deprecated:null,
        name:"toUSShortDateTime",
        flags:"",
        description:"  Return this date in the format: <code>MM/DD/YYYY HH:MM</code>\n\n",
        groups:[
            "dateFormatting"
        ],
        definingClass:"class:Date",
        returns:{
            description:"formatted date string",
            type:"string"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.initRequiresAuthentication":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Whether a user must be authenticated in order to initialize to this field.  If this property is \n set and the user is not authenticated, the SmartClient Server will not allow this field to\n be initialized.",
        groups:[
            "fieldLevelAuth",
            "declarativeSecurity"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSourceField.editRequiresAuthentication",
                description:null
            }
        ],
        ref:"attr:DataSourceField.initRequiresAuthentication",
        valueType:"boolean",
        name:"initRequiresAuthentication",
        definingClass:"class:DataSourceField",
        requiresModules:[
            "SCServer"
        ]
    },
    "class:IndicatorCanvas":{
        classAttrs:[
        ],
        ref:"class:IndicatorCanvas",
        methods:[
        ],
        deprecated:null,
        name:"IndicatorCanvas",
        description:"A subclass of ${isc.DocUtils.linkForRef('class:EventCanvas','EventCanvas')}, used to render \n ${isc.DocUtils.linkForRef('attr:Calendar.indicators','indicator lines')} at important points in \n ${isc.DocUtils.linkForRef('class:CalendarView','calendar views')}.\n <P>\n An IndicatorCanvas is a non-interactive, semi-transparent canvas that highlights a portion of a \n calendar view, by rendering across all lanes and behind normal ${isc.DocUtils.linkForRef('attr:Calendar.data','events')}.\n <P>\n By default, the canvas shows no label but does show a hover.\n <P>\n Default styling is specified at the ${isc.DocUtils.linkForRef('attr:Calendar.indicatorStyleName','calendar level')} \n and can be overridden for ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName','individual indicators')}.",
        treeLocation:[
            "Client Reference/Calendar"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ]
    },
    "classMethod:SimpleType.setDefaultSummaryFunction":{
        ref:"classMethod:SimpleType.setDefaultSummaryFunction",
        deprecated:null,
        name:"setDefaultSummaryFunction",
        flags:"",
        description:" Set up a default summary function for some field type.\n <P>\n Note that the following default summary functions are set up when SmartClient initializes:\n <br>- <code>\"integer\"</code> defaults to <code>\"sum\"</code>\n <br>- <code>\"float\"</code> defaults to <code>\"sum\"</code>.\n\n",
        definingClass:"class:SimpleType",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"typeName",
                description:"type name",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"summaryFunction",
                description:"summary function to set as the default for   this data type.",
                optional:false,
                type:"SummaryFunction"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:MetricSettings.fixedFacetValue":{
        ref:"attr:MetricSettings.fixedFacetValue",
        defaultValue:"null",
        valueType:"String | Number",
        deprecated:null,
        name:"fixedFacetValue",
        flags:"IR",
        description:"For a ${isc.DocUtils.linkForRef('attr:MetricSettings.multiFacet','single-facet')} chart of an extra value axis, this property provides a constant facet value\n for the second facet.  By varying the value of the other facet in multi-facet data, the chart\n obtains the series of values to plot.  The default facet value is the first facet value of the second facet.",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DynamicForm.getValidatedValues":{
        ref:"method:DynamicForm.getValidatedValues",
        deprecated:null,
        name:"getValidatedValues",
        flags:"",
        description:" Call ${isc.DocUtils.linkForRef('method:DynamicForm.validate')} to check for validation errors. If no errors are found,\n return the current values for this form, otherwise return null.\n",
        groups:[
            "errors"
        ],
        definingClass:"class:DynamicForm",
        returns:{
            description:"current values or null if validation failed.",
            type:"object|null"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGrid.valueIconWidth":{
        ref:"attr:ListGrid.valueIconWidth",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"valueIconWidth",
        flags:"IRW",
        description:"Width for value icons for this listGrid.\n Overrides ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconSize')}.\n Can be overridden at the field level",
        groups:[
            "imageColumns"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:Log.timeMethod":{
        ref:"classMethod:Log.timeMethod",
        deprecated:null,
        name:"timeMethod",
        flags:"",
        description:" \n  Observe a method on an object, logging execution time whenever the method is called.\n  <P>\n  Call a second time with identical arguments to disable tracing.\n\n",
        groups:[
            "debug"
        ],
        definingClass:"class:Log",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"object",
                description:"object to observe",
                optional:false,
                type:"object"
            },
            {
                defaultValue:null,
                name:"methodName",
                description:"name of the method to observe",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:IconMenuButton.menu":{
        ref:"attr:IconMenuButton.menu",
        defaultValue:"null",
        valueType:"Menu",
        deprecated:null,
        name:"menu",
        flags:"IRW",
        description:"The menu to show when the ${isc.DocUtils.linkForRef('attr:IconButton.menuIconSrc','menu-icon')} is clicked.\n <P>\n For a menu button with no menu (menu: null) the up/down arrow image can\n be suppressed by setting\n ${isc.DocUtils.linkForRef('attr:MenuButton.showMenuButtonImage','showMenuButtonImage')}: <code>false</code>.",
        definingClass:"class:IconMenuButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:GroupingMessages.upcomingTomorrowTitle":{
        ref:"classAttr:GroupingMessages.upcomingTomorrowTitle",
        defaultValue:"\"Tomorrow\"",
        valueType:"String",
        deprecated:null,
        name:"upcomingTomorrowTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs tomorrow,\n relative to the current date.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:GroupingMessages",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:TabSet.canReorderTabs":{
        ref:"attr:TabSet.canReorderTabs",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"canReorderTabs",
        flags:"IR",
        description:"If true, tabs can be reordered by dragging on them.\n <P>\n To disallow drag-reorder of a specific tab, see ${isc.DocUtils.linkForRef('attr:Tab.canReorder')}.",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:TabSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.weekView":{
        ref:"attr:Calendar.weekView",
        defaultValue:"null",
        valueType:"AutoChild CalendarView",
        deprecated:null,
        name:"weekView",
        flags:"R",
        description:"${isc.DocUtils.linkForRef('class:CalendarView')} used to display events that pertain to a given week.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Gauge.getNumSectors":{
        ref:"method:Gauge.getNumSectors",
        deprecated:null,
        name:"getNumSectors",
        flags:"",
        description:" Gets the number of sectors.\n\n",
        definingClass:"class:Gauge",
        returns:{
            description:"the number of sectors on this gauge.",
            type:"int"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:SectionStack.getVisibleSections":{
        ref:"method:SectionStack.getVisibleSections",
        deprecated:null,
        name:"getVisibleSections",
        flags:"",
        description:"\n Returns the list of currently visible sections.  The list items are section names.\n\n",
        definingClass:"class:SectionStack",
        returns:{
            description:"list of visible sections",
            type:"List"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGridField.groupingMode":{
        ref:"attr:ListGridField.groupingMode",
        defaultValue:"null",
        valueType:"identifier",
        deprecated:null,
        name:"groupingMode",
        flags:"IR",
        description:"For a field that allows multiple ${isc.DocUtils.linkForRef('attr:ListGridField.groupingModes','grouping modes')},\n the current grouping mode.\n <P>\n This property is set when a user chooses a particular grouping mode, and may be set on\n ListGrid creation to affect the initial grouping.",
        groups:[
            "grouping"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Layout.animateMemberTime":{
        ref:"attr:Layout.animateMemberTime",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"animateMemberTime",
        flags:"IRWA",
        description:"If specified this is the duration of show/hide animations when members are being shown\n or hidden due to being added / removed from this layout.",
        groups:[
            "animation"
        ],
        definingClass:"class:Layout",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:EdgedCanvas.customEdges":{
        ref:"attr:EdgedCanvas.customEdges",
        defaultValue:"null",
        valueType:"Array of String",
        deprecated:null,
        name:"customEdges",
        flags:"IR",
        description:"Array of side names (\"T\", \"B\", \"L\", \"R\") specifying which sides of the decorated\n component should show edges.  For example: <pre>\n      customEdges : [\"T\", \"B\"]\n </pre>\n .. would show edges only on the top and bottom of a component.\n <P>\n The default of <code>null</code> means edges will be shown on all sides.",
        groups:[
            "imageEdges"
        ],
        definingClass:"class:EdgedCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.ignoreTextMatchStyle":{
        serverDS:"allowed",
        ref:"attr:DataSourceField.ignoreTextMatchStyle",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"ignoreTextMatchStyle",
        flags:"IRW",
        description:"<b>NOTE: </b>Only applicable to ${isc.DocUtils.linkForRef('attr:DataSource.clientOnly','clientOnly')} DataSources and the\n built-in ${isc.DocUtils.linkForRef('group:sqlDataSource','SQL')}, ${isc.DocUtils.linkForRef('group:jpaIntegration','JPA')} and \n ${isc.DocUtils.linkForRef('group:hibernateIntegration','Hibernate')} DataSources available in Pro, Power and \n Enterprise versions of SmartClient.\n <p>\n Use this flag to inhibit the normal use of ${isc.DocUtils.linkForRef('type:TextMatchStyle')} for this field.  A \n field with this flag set will always be tested for exact equality in generated queries, \n even for filter-style queries where normal behavior would be to use a substring match or \n similar.\n <p>\n Whether or not the exact match is case-sensitive is determined by the DataSource's \n ${isc.DocUtils.linkForRef('attr:DataSource.ignoreTextMatchStyleCaseSensitive','ignoreTextMatchStyleCaseSensitive')}\n setting.",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TimeItem.setSecondValues":{
        ref:"method:TimeItem.setSecondValues",
        deprecated:null,
        name:"setSecondValues",
        flags:"A",
        description:" Sets the array of valid ${isc.DocUtils.linkForRef('attr:TimeItem.secondValues','second values')} to use when\n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.\n <P>Used for limiting available valid Second values, or when using the TimeItem to record\n duration, rather than time per-se.\n <P> See ${isc.DocUtils.linkForRef('attr:TimeItem.secondMinValue','secondMinValue')}, \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMaxValue','secondMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondIncrement','secondIncrement')} for another method of controlling the \n content in the second picker.\n",
        definingClass:"class:TimeItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"values",
                description:"array of available Second values",
                optional:false,
                type:"Array of Number"
            }
        ],
        seeAlso:[
        ]
    },
    "method:SelectItem.fetchData":{
        ref:"method:SelectItem.fetchData",
        deprecated:null,
        name:"fetchData",
        flags:"",
        description:" Only applies to databound items (see ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource')}).<br>\n Performs a fetch type operation on this item's DataSource to retrieve the set of valid\n options for the item, based on the current ${isc.DocUtils.linkForRef('attr:PickList.pickListCriteria')}.\n",
        definingClass:"class:SelectItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"callback",
                description:"Callback to fire when the fetch completes. Callback will               fire with 4 parameters:<ul>\n  <li><code>item</code> a pointer to the form item\n  <li><code>dsResponse</code> the ${isc.DocUtils.linkForRef('class:DSResponse')} returned by the server\n  <li><code>data</code> the raw data returned by the server\n  <li><code>dsRequest</code> the ${isc.DocUtils.linkForRef('class:DSRequest')} sent to the server\n  </ul>",
                optional:true,
                type:"DSCallback"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"properties to apply to the              dsRequest for this fetch.",
                optional:true,
                type:"DSRequest properties"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:CubeGrid.canDragSelect":{
        ref:"attr:CubeGrid.canDragSelect",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"canDragSelect",
        flags:"IR",
        description:"For ${isc.DocUtils.linkForRef('classAttr:Browser.isTouch','touch browsers')}, <code>canDragSelect</code> defaults to false\n so that touch scrolling can be used to navigate scrollable CubeGrids.  In all other\n browsers it defaults to true.\n <p>\n <strong>NOTE:</strong> If <code>canDragSelect</code> is enabled, it may be desirable to disable\n ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','touch scrolling')} so that touch-dragging cells of the CubeGrid\n selects them rather than starting a scroll. If ${isc.DocUtils.linkForRef('attr:Canvas.disableTouchScrollingForDrag')}\n is set to <code>true</code>, then touch scrolling will be disabled automatically.\n However, for ${isc.DocUtils.linkForRef('group:accessibility','accessibility')} reasons, it is recommended to\n leave touch scrolling enabled and provide an alternative set of controls that can be\n used to perform drag-selection.",
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Canvas.addSnapAlignCandidate":{
        ref:"method:Canvas.addSnapAlignCandidate",
        deprecated:null,
        name:"addSnapAlignCandidate",
        flags:"",
        description:" Add a candidate to ${isc.DocUtils.linkForRef('attr:Canvas.snapAlignCandidates')}.  Duplicates are automatically avoided.\n\n",
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newCandidate",
                description:null,
                optional:false,
                type:"Canvas"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataBoundComponent.initialCriteria":{
        ref:"attr:DataBoundComponent.initialCriteria",
        defaultValue:"null",
        valueType:"Criteria",
        deprecated:null,
        name:"initialCriteria",
        flags:"IR",
        description:"Criteria to be used when ${isc.DocUtils.linkForRef('attr:DataBoundComponent.autoFetchData')} is set.",
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.showCellHovers":{
        ref:"attr:Calendar.showCellHovers",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showCellHovers",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('attr:Calendar.showViewHovers','showViewHovers')} is true, dictates whether to display\n hover prompts when the mouse rolls over the normal cells in the body of CalendarViews.\n <P>\n The content of the hover is determined by a call to \n ${isc.DocUtils.linkForRef('method:Calendar.getCellHoverHTML')}, which can be overridden to return custom results; by \n default, it returns the cell's date as a string.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FieldPicker.sampleValueTitle":{
        ref:"attr:FieldPicker.sampleValueTitle",
        defaultValue:"\"Sample Value\"",
        valueType:"String",
        deprecated:null,
        name:"sampleValueTitle",
        flags:"IR",
        description:"The title displayed for the sample value property of the current fields",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FieldPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:IconButton.showTitle":{
        ref:"attr:IconButton.showTitle",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"showTitle",
        flags:"IRW",
        description:"showTitle is not applicable to this class - use ${isc.DocUtils.linkForRef('attr:IconButton.showButtonTitle')}\n instead.",
        definingClass:"class:IconButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:StretchImgButton.selected":{
        defaultValue:"false",
        deprecated:null,
        flags:"IRW",
        description:"Whether this component is selected.  For some components, selection affects appearance.",
        groups:[
            "state"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:StretchImgButton.selected",
        valueType:"Boolean",
        name:"selected",
        definingClass:"class:StretchImgButton",
        setter:[
            "setSelected"
        ]
    },
    "method:ColorPicker.setSaturation":{
        ref:"method:ColorPicker.setSaturation",
        deprecated:null,
        name:"setSaturation",
        flags:"",
        description:" Sets the Saturation of the selected color\n",
        definingClass:"class:ColorPicker",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newValue",
                description:"An integer between 0 and 240",
                optional:false,
                type:"Number"
            }
        ],
        seeAlso:[
            {
                ref:"method:ColorPicker.getSaturation",
                description:null
            }
        ]
    },
    "method:Window.minimize":{
        ref:"method:Window.minimize",
        deprecated:null,
        name:"minimize",
        flags:"",
        description:" Minimize the window. Fired when the user clicks the minimize button if \n ${isc.DocUtils.linkForRef('attr:Window.showMinimizeButton','this.showMinimizeButton')} is true.<br>\n Default implementation shrinks the window to just the height of the header bar, hiding the\n body. If ${isc.DocUtils.linkForRef('attr:Window.animateMinimize','animateMinimize')} is true, the resize will be animated.\n A restore button will be displayed in place of the minimize button when the window is \n minimized.\n",
        definingClass:"class:Window",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:DateChooser.nextMonthIconRTL":{
        ref:"attr:DateChooser.nextMonthIconRTL",
        defaultValue:"null",
        valueType:"URL",
        deprecated:null,
        name:"nextMonthIconRTL",
        flags:"IRW",
        description:"Icon for the next month button",
        definingClass:"class:DateChooser",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.canEditCell":{
        ref:"method:ListGrid.canEditCell",
        deprecated:null,
        name:"canEditCell",
        flags:"A",
        description:" Can this cell be edited?\n <P>\n The default implementation of <code>canEditCell()</code> respects the various property\n settings affecting editability:\n <ul><li>${isc.DocUtils.linkForRef('attr:ListGridField.canEdit','field.canEdit')} can be set to disable editing\n          for a field</li>\n     <li>If the grid is bound to a dataSource, the ${isc.DocUtils.linkForRef('attr:ListGrid.canEditFieldAttribute')} value on the\n         dataSource field may enable / disable editing</li>\n     <li>a record with the ${isc.DocUtils.linkForRef('attr:ListGrid.recordEditProperty','recordEditProperty')} set to\n         false is not editable</li>\n     <li>disabled records are not editable</li>\n </ul>\n You can override this method to control editability on a cell-by-cell basis.  For example,\n if you had a grid that allows editing of \"orders\", and you had a field \"shipDate\" that is\n normally editable, but should not be editable if the order is already \"complete\", you might\n implement <code>canEditCell()</code> as follows:\n <P>\n <pre>\n   isc.ListGrid.create({\n       ...\n       canEditCell : function (rowNum, colNum) {\n           var record = this.getRecord(rowNum),\n               fieldName = this.getFieldName(colNum);\n           if (fieldName == \"shipDate\" &&\n               record.orderStatus == \"complete\")\n           {\n               return false;\n           }\n           // use default rules for all other fields\n           return this.Super(\"canEditCell\", arguments);\n       }\n   });\n </pre>\n     \n <P>\n Notes on providing custom implementations:\n <ul>\n <li> In order to allow complete control over editing, <code>canEditCell()</code> is called\n very frequently.  If you see delays on row to row navigation, check that your implementation\n is efficient\n <li> If you change the editability of a cell on the fly, for example, during\n ${isc.DocUtils.linkForRef('method:ListGrid.editorExit')} on another cell, call refreshCell() to show or hide the editor\n <li> If this ListGrid allows new records to be created, <code>canEditCell()</code> may be\n called when there is no record available, in which case getRecord() will return null.  The\n values input so far by the user are available via ${isc.DocUtils.linkForRef('method:ListGrid.getEditValues')}.\n </ul>\n \n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"Whether to allow editing this cell",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number for the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of the cell",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "method:GridRenderer.cellOver":{
        ref:"method:GridRenderer.cellOver",
        deprecated:null,
        name:"cellOver",
        flags:"A",
        description:" Called when the mouse pointer enters a cell\n\n",
        groups:[
            "events"
        ],
        definingClass:"class:GridRenderer",
        returns:{
            description:"whether to cancel the event",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"record",
                description:"cell record as returned by getCellRecord",
                optional:false,
                type:"ListGridRecord"
            },
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number for the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of the cell",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.valueIconSize":{
        ref:"attr:ListGrid.valueIconSize",
        defaultValue:"16",
        valueType:"number",
        deprecated:null,
        name:"valueIconSize",
        flags:"IRW",
        description:"Default width and height of value icons for this ListGrid.\n Can be overridden at the listGrid level via explicit ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.valueIconHeight')}, or at the field level via ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')},\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')} and {ListGridField.valueIconHeight}",
        groups:[
            "imageColumns"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGrid.valueIconWidth",
                description:null
            },
            {
                ref:"attr:ListGrid.valueIconHeight",
                description:null
            },
            {
                ref:"attr:ListGridField.valueIconSize",
                description:null
            }
        ]
    },
    "attr:DataSourceField.escapeHTML":{
        serverDS:"allowed",
        ref:"attr:DataSourceField.escapeHTML",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"escapeHTML",
        flags:"IR",
        description:"When data values are displayed in DataBound components, by default strings will be interpreted\n as HTML by the browser in most cases.\n <P>\n If set, this property will be picked up by components bound to this dataSource, notifying them\n that any HTML characters should be escaped when displaying values for this field.",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.escapeHTML",
                description:null
            }
        ]
    },
    "attr:ListGrid.showPartialSelection":{
        ref:"attr:ListGrid.showPartialSelection",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showPartialSelection",
        flags:"IRW",
        description:"Should partially selected parents (in a Tree data set) be shown with special icon?\n This has an impact in grouped grids where ${isc.DocUtils.linkForRef('attr:ListGrid.canSelectGroups')} is true. The\n partial icon will show up for the group header node when a group is partially\n selected.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.deselectAllCells":{
        ref:"method:CubeGrid.deselectAllCells",
        deprecated:null,
        name:"deselectAllCells",
        flags:"",
        description:" Deselect all cells.\n\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CubeGrid",
        type:"method",
        seeAlso:[
        ]
    },
    "method:TileGrid.getTileIndex":{
        ref:"method:TileGrid.getTileIndex",
        deprecated:null,
        name:"getTileIndex",
        flags:"",
        description:" Returns the index of the specified tile.\n",
        definingClass:"class:TileGrid",
        returns:{
            description:"index of the tile in this tileGrid. Will return -1 if the specified tile is not displayed within this grid.",
            type:"int"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"tile",
                description:"Tile you want to get the index for",
                optional:false,
                type:"Canvas"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:StatefulCanvas.overCanvasConstructor":{
        ref:"attr:StatefulCanvas.overCanvasConstructor",
        defaultValue:"\"Canvas\"",
        valueType:"String",
        deprecated:null,
        name:"overCanvasConstructor",
        flags:"IRWA",
        description:"Constructor class name for this widget's ${isc.DocUtils.linkForRef('attr:StatefulCanvas.overCanvas','overCanvas')}",
        definingClass:"class:StatefulCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:PortalLayout.removePortlet":{
        ref:"method:PortalLayout.removePortlet",
        deprecated:null,
        name:"removePortlet",
        flags:"",
        description:" Removes a ${isc.DocUtils.linkForRef('class:Portlet')} which is currently rendered in this PortalLayout.\n Portlet will not be destroyed by default - if this is desired the calling code should\n do this explicitly.\n",
        definingClass:"class:PortalLayout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"portlet",
                description:"portlet to remove",
                optional:false,
                type:"Portlet"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:StretchImgButton.labelLengthPad":{
        ref:"attr:StretchImgButton.labelLengthPad",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"labelLengthPad",
        flags:"IRW",
        description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",
        definingClass:"class:StretchImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DateChooser.fiscalYearHeaderStyle":{
        ref:"attr:DateChooser.fiscalYearHeaderStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"fiscalYearHeaderStyle",
        flags:"IRW",
        description:"Base CSS style applied to the header of the \n ${isc.DocUtils.linkForRef('attr:DateChooser.showFiscalYearChooser','fiscal year column')} in the \n ${isc.DocUtils.linkForRef('attr:DateChooser.dateGrid','calendar view')}.",
        definingClass:"class:DateChooser",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tree.isFolderProperty":{
        ref:"attr:Tree.isFolderProperty",
        defaultValue:"\"isFolder\"",
        valueType:"String",
        deprecated:null,
        name:"isFolderProperty",
        flags:"IRW",
        description:"Name of property that defines whether a node is a folder.  By default this is set to\n ${isc.DocUtils.linkForRef('attr:TreeNode.isFolder')}.",
        definingClass:"class:Tree",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TreeNode.isFolder",
                description:null
            }
        ]
    },
    "method:ResultTree.setCriteria":{
        ref:"method:ResultTree.setCriteria",
        deprecated:null,
        name:"setCriteria",
        flags:"",
        description:" Set the filter criteria to use when fetching rows.\n <P>\n Depending on the result of ${isc.DocUtils.linkForRef('method:ResultTree.compareCriteria')} and setting for\n ${isc.DocUtils.linkForRef('attr:ResultTree.fetchMode')}, setting criteria may cause a trip to the server to get a new\n set of nodes, or may simply cause already-fetched nodes to be re-filtered according to the\n new criteria.\n <P>\n For a basic overview on when server fetches are generally performed, see\n ${isc.DocUtils.linkForRef('attr:ResultTree.fetchMode')}.\n However, this is not the final determination of when server fetches occur. Criteria can\n be split into local criteria and server criteria by specifying ${isc.DocUtils.linkForRef('attr:ResultTree.serverFilterFields')}.\n Thus, even when using fetchMode:\"local\" a new server fetch will occur if the server\n criteria changes. For details on how the criteria is split, see\n ${isc.DocUtils.linkForRef('method:DataSource.splitCriteria')}.\n <P>\n Note: if criteria is being split to retrieve server criteria portion and the criteria\n is an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}, the criteria must consist of a single \"and\" operator\n and one or more simple criteria below it. No other logical operators may be used. In\n other words, the ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} provided must be exactly representable by a\n simple criteria.\n\n",
        definingClass:"class:ResultTree",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newCriteria",
                description:"the filter criteria",
                optional:false,
                type:"Criteria"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:RPCManager.sendProxied":{
        ref:"classMethod:RPCManager.sendProxied",
        deprecated:null,
        name:"sendProxied",
        flags:"",
        description:" Send an HTTP request to a remote host, potentially through the HttpProxy servlet installed\n on the SmartClient Server.\n <P>\n This API allows contacting services which are hosted on servers other than the origin server\n if the HttpProxy servlet is enabled on the SmartClient Server.\n <P>\n The HttpProxy will be used if the ${isc.DocUtils.linkForRef('attr:RPCRequest.actionURL')} starts with \"http\" and uses a\n hostname other than \"localhost\" or <code>window.location.hostname</code>, or if the port\n number differs, or if <code>request.useHttpProxy</code> is explicitly set.  Otherwise the\n request goes to the origin server (the server that returned the current page).\n <P>\n The ${isc.DocUtils.linkForRef('class:RPCRequest')} properties that will be respected when relaying requests via the\n HttpProxy are: \n ${isc.DocUtils.linkForRef('attr:RPCRequest.actionURL','actionURL')}, ${isc.DocUtils.linkForRef('attr:RPCRequest.httpMethod','httpMethod')}, \n ${isc.DocUtils.linkForRef('attr:RPCRequest.params','params')}, ${isc.DocUtils.linkForRef('attr:RPCRequest.contentType','contentType')}, \n ${isc.DocUtils.linkForRef('attr:RPCRequest.httpHeaders','httpHeaders')}, and ${isc.DocUtils.linkForRef('attr:RPCRequest.data','data')}.  In this case\n \"data\", if set, will be used as the request body for an HTTP POST.\n <P>\n Higher-level APIs like ${isc.DocUtils.linkForRef('class:DataSource')} or ${isc.DocUtils.linkForRef('class:WebService')} call through this API, and so\n automatically use the HttpProxy if ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')} or\n ${isc.DocUtils.linkForRef('method:WebService.setLocation','webService.location')} is set to a foreign server.\n <P>\n This API is only suitable for direct use when loading unstructured data that will not be\n shown in a ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}.  For a WSDL-described web service, use\n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadWSDL')} instead.  For other web services, use a ${isc.DocUtils.linkForRef('class:DataSource')} with\n ${isc.DocUtils.linkForRef('attr:DataSource.dataURL','dataURL')}, and use ${isc.DocUtils.linkForRef('method:DataSource.transformRequest')} and\n ${isc.DocUtils.linkForRef('method:DataSource.transformResponse')} as necessary to form requests for the service and\n transform responses for display.\n\n",
        definingClass:"class:RPCManager",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"request",
                description:"rpcRequest to be routed through the HttpProxy",
                optional:false,
                type:"RPCRequest Properties"
            }
        ],
        seeAlso:[
        ],
        requiresModules:[
            "SCServer"
        ]
    },
    "class:FacetChartEditProxy":{
        classAttrs:[
        ],
        methods:[
            "method:FacetChartEditProxy.getInlineEditText",
            "method:FacetChartEditProxy.setInlineEditText"
        ],
        deprecated:null,
        description:"${isc.DocUtils.linkForRef('class:EditProxy')} that handles ${isc.DocUtils.linkForRef('class:FacetChart','FacetCharts')} when editMode is enabled.",
        groups:[
            "devTools"
        ],
        treeLocation:[
            "Client Reference/Tools/EditProxy"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:FacetChartEditProxy.dataSeparatorChar",
            "attr:FacetChartEditProxy.dataDisplaySeparatorChar",
            "attr:FacetChartEditProxy.dataEscapeChar"
        ],
        ref:"class:FacetChartEditProxy",
        name:"FacetChartEditProxy"
    },
    "class:CellSelection":{
        classAttrs:[
        ],
        ref:"class:CellSelection",
        methods:[
            "method:CellSelection.cellIsSelected",
            "method:CellSelection.anySelected",
            "method:CellSelection.getSelectedCells",
            "method:CellSelection.getSelectedRecord",
            "method:CellSelection.selectionChanged",
            "method:CellSelection.selectCell",
            "method:CellSelection.deselectCell",
            "method:CellSelection.selectCellList",
            "method:CellSelection.deselectCellList",
            "method:CellSelection.selectSingleCell"
        ],
        deprecated:null,
        name:"CellSelection",
        description:"Maintains a representation of selection over a 2-dimensional grid of objects.<br>\n  Automatically created to manage cell-selection on ${isc.DocUtils.linkForRef('class:CubeGrid')} widgets.",
        treeLocation:[
            "Client Reference/System/Selection"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ]
    },
    "method:ListGrid.getDisplayValue":{
        ref:"method:ListGrid.getDisplayValue",
        deprecated:null,
        name:"getDisplayValue",
        flags:"",
        description:" Given a field with a specified ${isc.DocUtils.linkForRef('attr:ListGridField.valueMap')} or ${isc.DocUtils.linkForRef('attr:ListGridField.displayField')}\n this method will return the display value for any underlying data value.\n",
        definingClass:"class:ListGrid",
        returns:{
            description:"Display value associated with the specified valueFieldValue",
            type:"string"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldID",
                description:"Field or field identifier with valueMap",
                optional:false,
                type:"string || number || ListGridField"
            },
            {
                defaultValue:null,
                name:"valueFieldValue",
                description:"Data value for this field",
                optional:false,
                type:"any"
            }
        ],
        seeAlso:[
        ]
    },
    "method:RichTextEditor.getValue":{
        ref:"method:RichTextEditor.getValue",
        deprecated:null,
        name:"getValue",
        flags:"",
        description:" Retrieves the current value of the edit area.\n",
        definingClass:"class:RichTextEditor",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ValuesManager.fetchOperation":{
        ref:"attr:ValuesManager.fetchOperation",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"fetchOperation",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:DSRequest.operationId','operationId')} to use when performing fetch operations.",
        groups:[
            "operations"
        ],
        definingClass:"class:ValuesManager",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:NavPanel.currentItem":{
        ref:"attr:NavPanel.currentItem",
        defaultValue:"null",
        valueType:"NavItem",
        deprecated:null,
        name:"currentItem",
        flags:"IRW",
        description:"The current ${isc.DocUtils.linkForRef('object:NavItem')} whose ${isc.DocUtils.linkForRef('attr:NavItem.pane','pane')} is showing in the\n ${isc.DocUtils.linkForRef('attr:NavPanel.navDeck','navDeck')}.  This must be an item of this <code>NavPanel</code> if\n set.",
        definingClass:"class:NavPanel",
        type:"attr",
        setter:[
            "setCurrentItem"
        ],
        seeAlso:[
        ]
    },
    "attr:LoginDialog.registrationItem":{
        ref:"attr:LoginDialog.registrationItem",
        defaultValue:"null",
        valueType:"AutoChild LinkItem",
        deprecated:null,
        name:"registrationItem",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('class:LinkItem')} to page requesting new user registration in ${isc.DocUtils.linkForRef('attr:LoginDialog.loginForm')}.\n <p>To handle user clicks on this link, implement ${isc.DocUtils.linkForRef('method:LoginDialog.register')}.\n <p>To handle a user click as a physical link to another page, set\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue','defaultValue')} via loginDialog.registrationItemProperties:\n <code>\n registrationItemProperties: {\n     defaultValue: \"register.html\"\n },\n </code>",
        definingClass:"class:LoginDialog",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:LoginDialog.showRegistrationLink",
                description:null
            },
            {
                ref:"attr:LoginDialog.registrationItemTitle",
                description:null
            }
        ]
    },
    "attr:AdvancedHiliteEditor.saveButtonTitle":{
        ref:"attr:AdvancedHiliteEditor.saveButtonTitle",
        defaultValue:"\"Save\"",
        valueType:"string",
        deprecated:null,
        name:"saveButtonTitle",
        flags:"IR",
        description:"The title text for the ${isc.DocUtils.linkForRef('attr:AdvancedHiliteEditor.saveButton','saveButton')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:AdvancedHiliteEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MiniDateRangeItem.fromDateOnlyPrefix":{
        ref:"attr:MiniDateRangeItem.fromDateOnlyPrefix",
        defaultValue:"\"Since\"",
        valueType:"string",
        deprecated:null,
        name:"fromDateOnlyPrefix",
        flags:"IR",
        description:"The text to prepend to the formatted date when only a ${isc.DocUtils.linkForRef('attr:MiniDateRangeItem.fromDate','fromDate')} is supplied.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MiniDateRangeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:Dialog":{
        exampleConfig:"Dialog.xml",
        classAttrs:[
            "classAttr:Dialog.OK_BUTTON_TITLE",
            "classAttr:Dialog.APPLY_BUTTON_TITLE",
            "classAttr:Dialog.YES_BUTTON_TITLE",
            "classAttr:Dialog.NO_BUTTON_TITLE",
            "classAttr:Dialog.CANCEL_BUTTON_TITLE",
            "classAttr:Dialog.DONE_BUTTON_TITLE",
            "classAttr:Dialog.CONFIRM_TITLE",
            "classAttr:Dialog.SAY_TITLE",
            "classAttr:Dialog.WARN_TITLE",
            "classAttr:Dialog.ASK_TITLE",
            "classAttr:Dialog.ASK_FOR_VALUE_TITLE",
            "classAttr:Dialog.Prompt",
            "classAttr:Dialog.Warn",
            "classAttr:Dialog.Ask"
        ],
        methods:[
            "method:Dialog.setButtons",
            "method:Dialog.setToolbarButtons",
            "method:Dialog.saveData",
            "method:Dialog.closeClick",
            "method:Dialog.cancelClick",
            "method:Dialog.okClick",
            "method:Dialog.applyClick",
            "method:Dialog.yesClick",
            "method:Dialog.noClick",
            "method:Dialog.doneClick",
            "method:Dialog.buttonClick"
        ],
        deprecated:null,
        description:"Dialogs are a specialized version of ${isc.DocUtils.linkForRef('class:Window')} used for small windows that contain just a text\n message or a text mesage with some standard buttons.\n <P>\n Many typical modal dialogs such as alerts and confirmations are built into the system with convenience\n APIs - see ${isc.DocUtils.linkForRef('classMethod:isc.say')}, ${isc.DocUtils.linkForRef('classMethod:isc.warn')} and ${isc.DocUtils.linkForRef('classMethod:isc.askForValue')}.\n <P>\n Dialogs can be modal or non-modal according to ${isc.DocUtils.linkForRef('attr:Window.isModal','isModal')}.\n <P>\n NOTE: If you are building a dialog that will involve more than just buttons and a message, consider\n starting from the ${isc.DocUtils.linkForRef('class:Window')} class instead, where arbitrary components can be added to the body\n area via ${isc.DocUtils.linkForRef('method:Window.addItem')}.\n This is an example of creating a custom dialog:\n \n <pre>\n  isc.Dialog.create({\n      message : \"Please choose whether to proceed\",\n      icon:\"[SKIN]ask.png\",\n      buttons : [\n          isc.Button.create({ title:\"OK\" }),\n          isc.Button.create({ title:\"Cancel\" })\n      ],\n      buttonClick : function (button, index) {\n          this.hide();\n      }\n  });\n </pre>\n \n ",
        treeLocation:[
            "Client Reference/Control"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:Dialog.defaultWidth",
            "attr:Dialog.styleName",
            "attr:Dialog.message",
            "attr:Dialog.messageStyle",
            "attr:Dialog.messageLabel",
            "attr:Dialog.messageIcon",
            "attr:Dialog.messageStack",
            "attr:Dialog.icon",
            "attr:Dialog.iconSize",
            "attr:Dialog.showToolbar",
            "attr:Dialog.autoFocus",
            "attr:Dialog.toolbar",
            "attr:Dialog.buttons",
            "attr:Dialog.toolbarButtons",
            "attr:Dialog.askIcon",
            "attr:Dialog.sayIcon",
            "attr:Dialog.warnIcon",
            "attr:Dialog.confirmIcon"
        ],
        ref:"class:Dialog",
        name:"Dialog"
    },
    "attr:ListPropertiesPane.startNumberFieldTitle":{
        ref:"attr:ListPropertiesPane.startNumberFieldTitle",
        defaultValue:"\"Start at\"",
        valueType:"String",
        deprecated:null,
        name:"startNumberFieldTitle",
        flags:"IR",
        description:"The ${isc.DocUtils.linkForRef('attr:FormItem.title','title')} of the ${isc.DocUtils.linkForRef('attr:ListPropertiesPane.startNumberField','startNumberField')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ListPropertiesPane",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:EditTree.showSelectedLabel":{
        ref:"attr:EditTree.showSelectedLabel",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"showSelectedLabel",
        flags:"IR",
        description:"Should the selection outline show a label for selected components? A component may\n also be highlighted with the selection outline and label to indicate the target of\n a drop. To suppress showing a label at any time set this property to <code>false</code>.\n <P>\n To suppress labels during selection but still show them when targeted for a drop,\n see ${isc.DocUtils.linkForRef('attr:EditContext.showSelectedLabelOnSelect')}.\n <P>\n NOTE: A selected component label is only supported when ${isc.DocUtils.linkForRef('attr:EditProxy.selectedAppearance')}\n is \"outlineEdges\".",
        definingClass:"class:EditTree",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ImgButton.setIcon":{
        ref:"method:ImgButton.setIcon",
        deprecated:null,
        name:"setIcon",
        flags:"",
        description:" Change the icon being shown next to the title text.\n",
        groups:[
            "buttonIcon"
        ],
        definingClass:"class:ImgButton",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"icon",
                description:"URL of new icon",
                optional:false,
                type:"URL"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DatabaseBrowser.excludeSubstring":{
        ref:"attr:DatabaseBrowser.excludeSubstring",
        defaultValue:"null",
        valueType:"String | List of String",
        deprecated:null,
        name:"excludeSubstring",
        flags:"IR",
        description:"If set, specifies a substring which must NOT exist in a table name for it to be included in\n this DatabaseBrowser.  If this property is set to a List of strings, table names are\n excluded if they match any one of the strings.  The comparison is case-insensitive.\n <p>\n For example, <code>excludeSubstring: [\"E\", \"qry\"]</code> would exclude all the following \n table names: \"table\", \"QryTbl\", \"QRY\", \"ORDERS\"\n <p>\n Note that if you specify both include and exclude criteria and they conflict (ie,\n according to the criteria you set, a table should be both included and excluded), \n exclude wins.",
        definingClass:"class:DatabaseBrowser",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Applet.altHTML":{
        ref:"attr:Applet.altHTML",
        defaultValue:"null",
        valueType:"HTML",
        deprecated:null,
        name:"altHTML",
        flags:"IR",
        description:"This text is displayed if the browser does not understand the tag used for the applet html\n  element.",
        definingClass:"class:Applet",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Applet.alt",
                description:null
            },
            {
                ref:"attr:Applet.useTag",
                description:null
            }
        ]
    },
    "classAttr:FileLoader.defaultModules":{
        ref:"classAttr:FileLoader.defaultModules",
        defaultValue:"\"Core,Foundation,Containers,Grids,Forms,DataBinding\"",
        valueType:"String",
        deprecated:null,
        name:"defaultModules",
        flags:"RW",
        description:"Default list of modules for\n ${isc.DocUtils.linkForRef('classMethod:FileLoader.loadISC')}/${isc.DocUtils.linkForRef('classMethod:FileLoader.cacheISC')} to use if none are\n provided by the user.",
        definingClass:"class:FileLoader",
        type:"classAttr",
        seeAlso:[
            {
                ref:"classMethod:FileLoader.cacheISC",
                description:null
            },
            {
                ref:"classMethod:FileLoader.loadISC",
                description:null
            }
        ]
    },
    "method:HTMLFlow.contentLoaded":{
        ref:"method:HTMLFlow.contentLoaded",
        deprecated:null,
        name:"contentLoaded",
        flags:"",
        description:" StringMethod fired when content is completely loaded in this htmlFlow. Has no default \n implementation. May be observed or overridden as a notification type method to fire custom\n logic when loading completes.\n <P>\n Notes:\n <ul><li>A call to ${isc.DocUtils.linkForRef('method:Canvas.setContents','this.setContents()')} \n  will cause this notification to be fired when\n  the contents have been set. If ${isc.DocUtils.linkForRef('attr:HTMLFlow.evalScriptBlocks')} is true, and the HTML passed\n  into <code>setContents()</code> contains any <code>&lt;script src=... &gt;</code>\n  tags, this callback will be fired asynchronously once the scripts have been loaded\n  from the server and executed, as well as having the widget content updated</li>\n <li>When using ${isc.DocUtils.linkForRef('attr:HTMLFlow.contentsURL')}, this does not apply to htmlFlows with\n  ${isc.DocUtils.linkForRef('attr:HTMLFlow.contentsType','contentsType')} set to <code>\"page\"</code></li></ul>\n\n",
        groups:[
            "contentLoading"
        ],
        definingClass:"class:HTMLFlow",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:StretchImgButton.showFocus":{
        ref:"attr:StretchImgButton.showFocus",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:"as of SmartClient version 6.1 in favor of ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocused')}",
        name:"showFocus",
        flags:"IRW",
        description:"Should we visibly change state when the canvas receives focus?  Note that by default the\n <code>over</code> state is used to indicate focus.",
        groups:[
            "state"
        ],
        definingClass:"class:StretchImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CubeGrid.facetLabelHoverStyle":{
        ref:"attr:CubeGrid.facetLabelHoverStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"facetLabelHoverStyle",
        flags:"IRWA",
        description:"Allows the developer to override the css class applied to  hover tips shown for\n facet labels.  If unspecified, and <code>this.hoverStyle</code> is not null, that \n css class will be applied to facet label hovers instead.",
        groups:[
            "hoverTips"
        ],
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Canvas.hoverStyle",
                description:null
            }
        ]
    },
    "type:BackgroundRepeat":{
        ref:"type:BackgroundRepeat",
        values:[
            {
                description:"Tile the background image horizontally and vertically.",
                value:"Canvas.REPEAT"
            },
            {
                description:"Don't tile the background image at all.",
                value:"Canvas.NO_REPEAT"
            },
            {
                description:"Repeat the background image horizontally but not vertically.",
                value:"Canvas.REPEAT_X"
            },
            {
                description:"Repeat the background image vertically but not horizontally.",
                value:"Canvas.REPEAT_Y"
            }
        ],
        deprecated:null,
        name:"BackgroundRepeat",
        description:"Possible values for ${isc.DocUtils.linkForRef('attr:Canvas.backgroundRepeat')}.",
        groups:[
            "appearance"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:ColorPicker.setHtmlColor":{
        ref:"method:ColorPicker.setHtmlColor",
        deprecated:null,
        name:"setHtmlColor",
        flags:"",
        description:" Changes the selected color to the one represented by the supplied HTML color \n string. Note that the method only accepts the parameter if it represents a \n valid color (otherwise it is simply ignored).\n",
        definingClass:"class:ColorPicker",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newValue",
                description:"A string in HTML color representation format (#RRGGBB)",
                optional:false,
                type:"text"
            }
        ],
        seeAlso:[
            {
                ref:"method:ColorPicker.getHtmlColor",
                description:null
            }
        ]
    },
    "attr:OperationBinding.spoofResponses":{
        serverDS:"allowed",
        defaultValue:"false",
        deprecated:null,
        flags:"IR",
        description:"For a DataSource contacting a ${isc.DocUtils.linkForRef('attr:DataSource.serviceNamespace','WSDL web service')}, setting\n this flag means the DataSource doesn't actually attempt to contact the server but generates\n a sample response instead, based on the XML Schema of the response message embedded in the\n WSDL.\n <P>\n The spoofed response will include all complexType elements and will fill in appropriate\n values by type for all simpleType elements, although the spoofed data will not conform to\n all xs:restriction declarations (eg xs:pattern).\n <P>\n Note that if your WSDL does not fully describe the response format (some WSDL services just\n have a placeholder &lt;xs:any&gt; element), SmartClient can only produce a partial\n response.  To use a hand-generated sample response, just save an XML file to disk and use\n the ${isc.DocUtils.linkForRef('attr:OperationBinding.dataURL')} setting to point to it.",
        groups:[
            "clientDataIntegration"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:OperationBinding.spoofResponses",
        valueType:"boolean",
        name:"spoofResponses",
        definingClass:"class:OperationBinding"
    },
    "attr:SelectItem.openOnDownArrow":{
        ref:"attr:SelectItem.openOnDownArrow",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"openOnDownArrow",
        flags:"IRW",
        description:"Causes the PickList to open when the down arrow is pressed, default false.  \n <P>\n For native OS widgets, the down arrow changes the value of a select on Windows, but \n opens the select on Macs.  This setting is not recommended unless you are certain that \n all users of your applications will expect the Mac convention.",
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TileLayout.overflow":{
        ref:"attr:TileLayout.overflow",
        defaultValue:"\"auto\"",
        valueType:"Overflow",
        deprecated:null,
        name:"overflow",
        flags:"IRW",
        description:"Normal ${isc.DocUtils.linkForRef('type:Overflow')} settings can be used on TileLayouts, for example, an\n overflow:auto TileLayout will scroll if members exceed its specified size, whereas an\n overflow:visible TileLayout will grow to accommodate members.",
        groups:[
            "sizing"
        ],
        definingClass:"class:TileLayout",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RelativeDateItem.monthsFromNowTitle":{
        ref:"attr:RelativeDateItem.monthsFromNowTitle",
        defaultValue:"\"N months from now\"",
        valueType:"string",
        deprecated:null,
        name:"monthsFromNowTitle",
        flags:"IR",
        description:"The title to show for future periods when the ${isc.DocUtils.linkForRef('type:TimeUnit')} is \"month\".",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:RelativeDateItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:FacetChart.polynomialDegreeRegressionLinesContextMenuItemTitle":{
        ref:"classAttr:FacetChart.polynomialDegreeRegressionLinesContextMenuItemTitle",
        defaultValue:"\"Polynomial Degree...\"",
        valueType:"HTML",
        deprecated:null,
        name:"polynomialDegreeRegressionLinesContextMenuItemTitle",
        flags:"IRW",
        description:"Title for the <code>\"Polynomial Degree...\"</code> option of the <code>\"Regression Lines\"</code>\n option in the context menu for scatter plots.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FacetChart",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "classMethod:AutoTest.getObject":{
        ref:"classMethod:AutoTest.getObject",
        deprecated:null,
        name:"getObject",
        flags:"",
        description:" Given an ${isc.DocUtils.linkForRef('type:AutoTestLocator')}, return the live SmartClient object it refers to, if any.\n",
        groups:[
            "autoTest"
        ],
        definingClass:"class:AutoTest",
        returns:{
            description:"target object, or null if  unable to resolve the locator to a live object.",
            type:"Canvas or FormItem or SectionStackSection"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"locator",
                description:"Locator String previously returned by        ${isc.DocUtils.linkForRef('classMethod:AutoTest.getLocator')}",
                optional:false,
                type:"AutoTestLocator"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:EditNode.editProxyProperties":{
        ref:"attr:EditNode.editProxyProperties",
        defaultValue:"null",
        valueType:"EditProxy Properties",
        deprecated:null,
        name:"editProxyProperties",
        flags:"IR",
        description:"Properties to be applied to the\n ${isc.DocUtils.linkForRef('attr:EditNode.liveObject','liveObject')}.${isc.DocUtils.linkForRef('attr:Canvas.editProxy','editProxy')} when created.\n <p>\n Note that the <code>editProxy</code> is created the first time a component is placed into\n editMode, so any <code>editProxyProperties</code> must be set before then.",
        definingClass:"object:EditNode",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MathFunction.jsFunction":{
        ref:"attr:MathFunction.jsFunction",
        defaultValue:"null",
        valueType:"Function",
        deprecated:null,
        name:"jsFunction",
        flags:"IR",
        description:"Javascript method to perform the calculation associated with this function",
        groups:[
            "formulaFields"
        ],
        definingClass:"class:MathFunction",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawImage.getBoundingBox":{
        ref:"method:DrawImage.getBoundingBox",
        deprecated:null,
        name:"getBoundingBox",
        flags:"",
        description:" Returns the top, left, top+width, left+height\n\n",
        definingClass:"class:DrawImage",
        returns:{
            description:"x1, y1, x2, y2 coordinates",
            type:"Array[] of double"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGridField.type":{
        ref:"attr:ListGridField.type",
        defaultValue:"\"text\"",
        valueType:"ListGridFieldType",
        deprecated:null,
        name:"type",
        flags:"IR",
        description:"ListGrids picks a renderer for the view and edit mode of a field based on this attribute.\n  See ${isc.DocUtils.linkForRef('type:ListGridFieldType')} for a summary of how types are rendered.",
        groups:[
            "appearance"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"type:ListGridFieldType",
                description:null
            },
            {
                ref:"type:FieldType",
                description:null
            }
        ]
    },
    "attr:DataSourceField.customSelectExpression":{
        serverDS:"only",
        ref:"attr:DataSourceField.customSelectExpression",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"customSelectExpression",
        flags:"IR",
        description:"This property indicates that this field represents a custom expression that should be \n embedded in the generated SQL instead of a reference to this field.  For example, if \n you have a field <code>partialName</code> where this value is set to \n <code>SUBSTR(surname, 2)</code>, the generated SQL would look similar to this:\n <pre>\n   SELECT ... SUBSTR(surname, 2) AS partialName ...\n </pre>\n Note that adding \"AS partialName\" as shown above is required - this is how the framework\n identifies the expression as producing a value for this particular DataSourceField when\n results are received from the database.\n <p>\n Fields with <code>customSelectExpression</code> set can be used for sorting and filtering in\n the normal way, but they are only applicable to update-type operations if you also provide a\n corresponding ${isc.DocUtils.linkForRef('attr:DataSourceField.customUpdateExpression','customUpdateExpression')} and/or \n ${isc.DocUtils.linkForRef('attr:DataSourceField.customInsertExpression','customInsertExpression')}.  See the documentation \n for those methods for the rules of how they are applied.\n <p>\n You can use Velocity expressions in your <code>customSelectExpression</code>s, and the \n ${isc.DocUtils.linkForRef('group:velocitySupport','usual context variables')} are available.  Note that the results\n of Velocity evaluations are automatically quoted and escaped by default; this behavior can\n be switched off - see ${isc.DocUtils.linkForRef('attr:DataSourceField.autoQuoteCustomExpressions','autoQuoteCustomExpressions')}, and \n particularly note the warnings about its use.\n <p>\n Note that this property only applies to users of the SmartClient server using dataSources of\n type \"sql\".",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSourceField.customUpdateExpression",
                description:null
            },
            {
                ref:"attr:DataSourceField.customInsertExpression",
                description:null
            },
            {
                ref:"attr:DataSourceField.customCriteriaExpression",
                description:null
            },
            {
                ref:"attr:DataSourceField.autoQuoteCustomExpressions",
                description:null
            }
        ]
    },
    "attr:SummaryBuilder.testRecord":{
        ref:"attr:SummaryBuilder.testRecord",
        defaultValue:"null",
        valueType:"Record",
        deprecated:null,
        name:"testRecord",
        flags:"IRA",
        description:"Record to use when showing sample output for the format string.\n <P>\n If not specified, the selected record in the component that launched the SummaryBuilder will\n be used, or if there's no selection, the first visible row, or with no component, a dummy\n data row derived automatically from the provided DataSource.",
        groups:[
            "formulaFields"
        ],
        definingClass:"class:SummaryBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Tree.add":{
        ref:"method:Tree.add",
        deprecated:null,
        name:"add",
        flags:"",
        description:"\n Add a single node under the specified parent.  See ${isc.DocUtils.linkForRef('class:ResultTree','\"Modifying ResultTrees\"')}\n when working with a <code>ResultTree</code> for limitations.\n\n",
        definingClass:"class:Tree",
        returns:{
            description:"The added node. Will return null if the node was not added (typically    because the specified <code>parent</code> could not be found in the tree).",
            type:"TreeNode or null"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"node",
                description:"node to add",
                optional:false,
                type:"TreeNode"
            },
            {
                defaultValue:null,
                name:"parent",
                description:"Parent of the node being added.  You can pass                                          in either the ${isc.DocUtils.linkForRef('object:TreeNode')} itself, or a path to\n\t                                        the node (as a String), in which case a\n\t                                        ${isc.DocUtils.linkForRef('method:Tree.find')} is performed to find\n\t                                        the node.",
                optional:false,
                type:"String or TreeNode"
            },
            {
                defaultValue:null,
                name:"position",
                description:"Position of the new node in the children list. If not\t                                specified, the node will be added at the end of the list.",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
            {
                ref:"group:sharingNodes",
                description:null
            },
            {
                ref:"method:Tree.addList",
                description:null
            }
        ]
    },
    "attr:Canvas.groupTitle":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"The title/label for the grouping. Only applicable when ${isc.DocUtils.linkForRef('attr:Canvas.isGroup','isGroup')} is set to true.",
        groups:[
            "appearance"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Canvas.groupTitle",
        valueType:"HTMLString",
        name:"groupTitle",
        definingClass:"class:Canvas",
        setter:[
            "setGroupTitle"
        ]
    },
    "attr:FormulaBuilder.instructions":{
        ref:"attr:FormulaBuilder.instructions",
        defaultValue:"null",
        valueType:"AutoChild Label",
        deprecated:null,
        name:"instructions",
        flags:"IR",
        description:"Label displaying the instruction text above the fieldKey grid.",
        definingClass:"class:FormulaBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Button.showDisabled":{
        defaultValue:"true",
        deprecated:null,
        flags:"IRW",
        description:"Should we visibly change state when disabled?",
        groups:[
            "state"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Button.showDisabled",
        examples:[
            "${isc.DocUtils.linkForExampleId('buttonStates')}"
        ],
        valueType:"Boolean",
        name:"showDisabled",
        definingClass:"class:Button"
    },
    "attr:TimeItem.displayFormat":{
        ref:"attr:TimeItem.displayFormat",
        defaultValue:"null",
        valueType:"TimeDisplayFormat",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('attr:TimeItem.timeFormatter')}",
        name:"displayFormat",
        flags:"IRW",
        description:"What format should this item's time string be presented in?\n <p>\n This attribute does not have an effect if a native HTML5 time input is being used.\n See ${isc.DocUtils.linkForRef('attr:TimeItem.browserInputType')}.",
        definingClass:"class:TimeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RPCRequest.callback":{
        ref:"attr:RPCRequest.callback",
        defaultValue:"null",
        valueType:"RPCCallback",
        deprecated:null,
        name:"callback",
        flags:"IRW",
        description:"If you expect to receive a response to your RPC request, you can specify a callback that\n will be called with an instance or RPCResponse class as sent by the server.  Queuing does\n not affect callbacks in any way - your specified callback will be invoked for each\n RPCRequest that contained a callback regardless of whether the request was sent as part of a\n queue or not.\n <P>\n Note that if the request encounters an error (such as 500 server error), by default the\n callback will <b>not</b> be fired, instead, ${isc.DocUtils.linkForRef('classMethod:RPCManager.handleError')} is called to\n invoke the default system-wide error handling.  Set ${isc.DocUtils.linkForRef('attr:RPCRequest.willHandleError')}:true to have your\n callback invoked regardless of whether there are errors, however, make sure your callback\n properly handles malformed responses when ${isc.DocUtils.linkForRef('attr:RPCResponse.status')} is non-zero.  See the\n ${isc.DocUtils.linkForRef('group:errorHandling','error handling overview')} for more details.",
        groups:[
            "errorHandling"
        ],
        definingClass:"class:RPCRequest",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:MultiSortPanel.sortChanged":{
        ref:"method:MultiSortPanel.sortChanged",
        deprecated:null,
        name:"sortChanged",
        flags:"",
        description:" Fired whenever the sort configuration changes.  The single parameter is an array of\n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s that represent the list of sort-levels as they appear after \n whatever change has occurred.\n\n",
        definingClass:"class:MultiSortPanel",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"sortLevels",
                description:"The current sort configuration, after any changes",
                optional:false,
                type:"Array of SortSpecifier"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:FilterBuilder.topOperatorOptions":{
        ref:"attr:FilterBuilder.topOperatorOptions",
        defaultValue:"[\"and\", \"or\", \"not\"]",
        valueType:"Array of OperatorId",
        deprecated:null,
        name:"topOperatorOptions",
        flags:"IR",
        description:"Logical operators to allow for ${isc.DocUtils.linkForRef('type:TopOperatorAppearance')}s of \"radio\" and \"bracket\".\n <P> Note that this list may be further limited according to the \n ${isc.DocUtils.linkForRef('method:DataSource.getTypeOperatorMap','available operators')} returned by the \n ${isc.DocUtils.linkForRef('class:DataSource')}.",
        definingClass:"class:FilterBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DynamicForm.checkForValidationErrors":{
        ref:"method:DynamicForm.checkForValidationErrors",
        deprecated:null,
        name:"checkForValidationErrors",
        flags:"",
        description:" Performs silent validation of the current form values, like ${isc.DocUtils.linkForRef('method:DynamicForm.valuesAreValid')}.  In\n contrast to ${isc.DocUtils.linkForRef('method:DynamicForm.valuesAreValid')}, this method allows checking for server-side errors, and\n finding out what the errors are.  \n <P>\n The callback must be passed unless server-side validation is being skipped, and If passed,\n it always fires, errors or not, firing synchronously if server validation is skipped.\n\n",
        groups:[
            "validation"
        ],
        definingClass:"class:DynamicForm",
        returns:{
            description:"null if server-side validation is required, or no errors are present; otherwise, an object mapping field\n names to the associated errors, for those fields that failed validation.",
            type:"Map | null"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"callback",
                description:"callback to invoke after validation is complete",
                optional:false,
                type:"ValidationStatusCallback"
            },
            {
                defaultValue:null,
                name:"validateHiddenFields",
                description:"should validators be processed for non-visible fields         such as dataSource fields with no associated item or fields with visibility set to\n         <code>\"hidden\"</code>",
                optional:true,
                type:"boolean"
            },
            {
                defaultValue:null,
                name:"skipServerValidation",
                description:"whether to skip doing server-side validation",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Lane.name":{
        ref:"attr:Lane.name",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"name",
        flags:"IR",
        description:"To determine whether a CalendarEvent should be placed in this lane, the value of this \n attribute is compared with the ${isc.DocUtils.linkForRef('attr:Calendar.laneNameField')} property on the CalendarEvent.",
        definingClass:"object:Lane",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Palette.generateNames":{
        ref:"attr:Palette.generateNames",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"generateNames",
        flags:"IR",
        description:"Whether created components should have their \"ID\" or \"name\" property automatically set\n to a unique value based on the component's type, eg, \"ListGrid0\".",
        groups:[
            "devTools"
        ],
        definingClass:"interface:Palette",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:ClassFactory.overwriteClass":{
        ref:"classMethod:ClassFactory.overwriteClass",
        deprecated:null,
        name:"overwriteClass",
        flags:"",
        description:"\n Intentionally clobber an existing SmartClient Class, if it already exists.  Works \n identically to ${isc.DocUtils.linkForRef('classMethod:ClassFactory.defineClass')}, except that no warning is logged to the\n console.\n\n",
        definingClass:"object:ClassFactory",
        type:"classMethod",
        seeAlso:[
        ]
    },
    "attr:ListGrid.imageSize":{
        ref:"attr:ListGrid.imageSize",
        defaultValue:"16",
        valueType:"number",
        deprecated:null,
        name:"imageSize",
        flags:"IRW",
        description:"Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a\n per-field basis via ${isc.DocUtils.linkForRef('attr:ListGridField.imageSize')} or\n ${isc.DocUtils.linkForRef('attr:ListGridField.imageWidth')}/${isc.DocUtils.linkForRef('attr:ListGridField.imageHeight')}",
        groups:[
            "imageColumns"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.pointSizeLogBase":{
        ref:"attr:FacetChart.pointSizeLogBase",
        defaultValue:"10",
        valueType:"integer",
        deprecated:null,
        name:"pointSizeLogBase",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('attr:FacetChart.logScalePointSize')} is true, base value for logarithmic point size metric values.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ToolStrip.formWrapperDefaults":{
        ref:"attr:ToolStrip.formWrapperDefaults",
        defaultValue:"...",
        valueType:"Object",
        deprecated:null,
        name:"formWrapperDefaults",
        flags:"IR",
        description:"Default properties to apply to ${isc.DocUtils.linkForRef('attr:ToolStrip.formWrapper')} components. Default object\n is as follows:\n <pre>\n { showTitle:false,\n   numCols:1,\n   overflow:\"visible\",\n   width:1, height:1 }\n </pre>",
        definingClass:"class:ToolStrip",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DateChooser.headerStyle":{
        ref:"attr:DateChooser.headerStyle",
        defaultValue:"\"dateChooserButtonDisabled\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"headerStyle",
        flags:"IRW",
        description:"CSS style applied to the day-of-week headers. By default this applies to all days of the \n week. To apply a separate style to weekend headers, set \n ${isc.DocUtils.linkForRef('attr:DateChooser.weekendHeaderStyle')}",
        definingClass:"class:DateChooser",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TileGrid.tile":{
        ref:"attr:TileGrid.tile",
        getter:[
            "getTile"
        ],
        defaultValue:"null",
        valueType:"MultiAutoChild SimpleTile",
        deprecated:null,
        name:"tile",
        flags:"IR",
        description:"A TileGrid automatically creates one tile per record in the dataset, via the\n ${isc.DocUtils.linkForRef('type:AutoChild')} pattern.\n <P>\n By default, the ${isc.DocUtils.linkForRef('class:SimpleTile')} class will be used, and will contain content as rendered\n by a ${isc.DocUtils.linkForRef('class:DetailViewer')}, based on the provided ${isc.DocUtils.linkForRef('attr:TileGrid.fields')} (or on the default\n set of fields).\n <P>\n \n To create a completely different appearance, override ${isc.DocUtils.linkForRef('attr:TileGrid.tileConstructor')} with the name\n of the custom SmartClient class to use for each tile.  For example, subclass\n ${isc.DocUtils.linkForRef('class:SimpleTile')} and override ${isc.DocUtils.linkForRef('method:Canvas.getInnerHTML','getInnerHTML()')}, returning custom\n HTML for each tile.\n <pre>\n     isc.defineClass(\"MyCustomTile\", \"SimpleTile\").addProperties({\n        getInnerHTML : function () {\n           return this.Super(\"getInnerHTML\", arguments) +\n                this.getRecord().width + \" x \" + this.getRecord().height;\n        }\n     });\n\n     isc.TileGrid.create({\n        tileConstructor:\"MyCustomTile\"\n     });\n </pre>\n <P>\n Note that you can also override tile behaviors on a per-record basis, via\n ${isc.DocUtils.linkForRef('attr:TileRecord.tileConstructor')} and ${isc.DocUtils.linkForRef('attr:TileRecord.tileProperties')}.\n \n ",
        definingClass:"class:TileGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:GridRenderer.instantScrollTrackRedraw":{
        ref:"attr:GridRenderer.instantScrollTrackRedraw",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"instantScrollTrackRedraw",
        flags:"IRW",
        description:"If true, if the user clicks on the scroll buttons at the end of the track or clicks once on\n the scroll track, there will be an instant redraw of the grid content so that the user\n doesn't see any blank space.  For drag scrolling or other types of scrolling, the\n ${isc.DocUtils.linkForRef('attr:GridRenderer.scrollRedrawDelay')} applies.",
        groups:[
            "performance"
        ],
        definingClass:"class:GridRenderer",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tree.separateFolders":{
        ref:"attr:Tree.separateFolders",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"separateFolders",
        flags:"IRW",
        description:"Should folders be sorted separately from leaves or should nodes be ordered according to\n their sort field value regardless of whether the node is a leaf or folder?",
        definingClass:"class:Tree",
        type:"attr",
        setter:[
            "setSeparateFolders"
        ],
        seeAlso:[
            {
                ref:"attr:Tree.sortFoldersBeforeLeaves",
                description:null
            }
        ]
    },
    "method:EditTree.removeNode":{
        ref:"method:EditTree.removeNode",
        deprecated:null,
        name:"removeNode",
        flags:"",
        description:" Removes ${isc.DocUtils.linkForRef('object:EditNode','EditNode')} from the EditContext. The editNode\n liveObject is not destroyed.\n",
        definingClass:"class:EditTree",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"editNode",
                description:"node to be removed",
                optional:false,
                type:"EditNode"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.fetchData":{
        ref:"method:ListGrid.fetchData",
        examples:[
            "${isc.DocUtils.linkForExampleId('databoundFetch')}"
        ],
        deprecated:null,
        name:"fetchData",
        flags:"",
        description:" Retrieves data from the DataSource that matches the specified criteria.\n <p>\n When <code>fetchData()</code> is first called, if data has not already been provided via\n ${isc.DocUtils.linkForRef('method:ListGrid.setData','setData()')}, this method will create a ${isc.DocUtils.linkForRef('class:ResultSet')}, which will be\n configured based on component settings such as ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fetchOperation')}\n and ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dataPageSize')}, as well as the general purpose\n ${isc.DocUtils.linkForRef('attr:ListGrid.dataProperties')}.  The created ResultSet will automatically send a DSRequest\n to retrieve data from ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource','listGrid.dataSource')}, and from then on will  \n automatically manage paging through large datasets, as well as performing filtering and\n sorting operations inside the browser when possible - see the ${isc.DocUtils.linkForRef('class:ResultSet')} docs for\n details.\n <p>\n <b>NOTE:</b> do not use <b>both</b> ${isc.DocUtils.linkForRef('attr:DataBoundComponent.autoFetchData','autoFetchData:true')} <b>and</b> a\n call to <code>fetchData()</code> - this may result in two DSRequests to fetch data.  Use\n either ${isc.DocUtils.linkForRef('attr:DataBoundComponent.autoFetchData','autoFetchData')} and ${isc.DocUtils.linkForRef('type:Criteria')} <b>or</b> a manual call to fetchData()\n passing criteria.\n <p>\n Whether a ResultSet was automatically created or provided via ${isc.DocUtils.linkForRef('method:ListGrid.setData','setData()')}, subsequent\n calls to fetchData() will simply call ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria')}.\n <p>\n Changes to criteria may or may not result in a DSRequest to the server due to\n ${isc.DocUtils.linkForRef('attr:ResultSet.useClientFiltering','client-side filtering')}.  You can call\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.willFetchData','willFetchData(criteria)')} to determine if new criteria will result in a\n server fetch.\n <P>\n If you need to force data to be re-fetched, you can call\n ${isc.DocUtils.linkForRef('method:ListGrid.invalidateCache','invalidateCache()')} and new data will automatically be fetched\n from the server using the current criteria and sort direction.  <b>NOTE:</b> when using\n <code>invalidateCache()</code> there is no need to <b>also</b> call <code>fetchData()</code>\n and in fact this could produce unexpected results.\n <p>\n This method takes an optional callback parameter (set to a ${isc.DocUtils.linkForRef('type:DSCallback')}) to fire when\n the fetch completes. Note that this callback will not fire if no server fetch is performed.\n In this case the data is updated synchronously, so as soon as this method completes you\n can interact with the new data. If necessary, you can use\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.willFetchData','willFetchData()')} to determine whether or not a server\n fetch will occur when <code>fetchData()</code> is called with new criteria.\n <p>\n In addition to the callback parameter for this method, developers can use \n ${isc.DocUtils.linkForRef('method:ListGrid.dataArrived','dataArrived()')} to be notified every time data is loaded.\n <p>\n By default, this method assumes a ${isc.DocUtils.linkForRef('type:TextMatchStyle')} of \"exact\"; that can be overridden\n by supplying a different value in the requestProperties parameter. \n See ${isc.DocUtils.linkForRef('method:DataBoundComponent.willFetchData')};\n\n",
        groups:[
            "dataBoundComponentMethods"
        ],
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"Search criteria. If a ${isc.DocUtils.linkForRef('class:DynamicForm')} is passed                                          in as this argument instead of a raw criteria \n                                          object, will be derived by calling\n                                          ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}",
                optional:true,
                type:"Criteria"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"callback to invoke when a fetch is complete. Fires                                          only if server contact was required",
                optional:true,
                type:"DSCallback"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"additional properties to set on the DSRequest                                          that will be issued",
                optional:true,
                type:"DSRequest"
            }
        ],
        seeAlso:[
            {
                ref:"method:ListGrid.refreshData",
                description:null
            }
        ]
    },
    "method:DrawLabelEditProxy.setInlineEditText":{
        ref:"method:DrawLabelEditProxy.setInlineEditText",
        deprecated:null,
        name:"setInlineEditText",
        flags:"",
        description:" Save the new value into the component's state. Called by the\n ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditForm')} to commit the change.\n <p>\n Updates the component's <code>contents</code>.\n\n",
        definingClass:"class:DrawLabelEditProxy",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newValue",
                description:"the new component contents",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "method:LoginDialog.lostPassword":{
        ref:"method:LoginDialog.lostPassword",
        deprecated:null,
        name:"lostPassword",
        flags:"",
        description:" Called if the user clicks on the ${isc.DocUtils.linkForRef('attr:LoginDialog.lostPasswordItem','\"Lost Password\"')} link\n on the login form. Implement this method to allow the user to request the password\n be resent or reset.\n",
        definingClass:"class:LoginDialog",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"values",
                description:"Current values of form fields",
                optional:false,
                type:"Object"
            },
            {
                defaultValue:null,
                name:"form",
                description:"Form on which the link was clicked",
                optional:false,
                type:"DynamicForm"
            }
        ],
        seeAlso:[
        ]
    },
    "method:TileGrid.getTitleField":{
        ref:"method:TileGrid.getTitleField",
        deprecated:null,
        name:"getTitleField",
        flags:"",
        description:" Method to return the fieldName which represents the \"title\" for records in this\n Component.<br>\n If this.titleField is explicitly specified it will always be used.\n Otherwise, default implementation will check ${isc.DocUtils.linkForRef('attr:DataSource.titleField')} for databound\n compounds.<br>\n For non databound components returns the first defined field name of <code>\"title\"</code>,\n <code>\"name\"</code>, or <code>\"id\"</code> where the field is visible. If we don't find any\n field-names that match these titles, the first field in the component will be used instead.\n",
        definingClass:"class:TileGrid",
        returns:{
            description:"fieldName for title field for this component.",
            type:"string"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:TabSet.setTabIcon":{
        ref:"method:TabSet.setTabIcon",
        deprecated:null,
        name:"setTabIcon",
        flags:"A",
        description:" Changes the icon for a tab\n",
        definingClass:"class:TabSet",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"tab",
                description:"tab to update",
                optional:false,
                type:"Tab | number | ID | name"
            },
            {
                defaultValue:null,
                name:"icon",
                description:"new icon",
                optional:false,
                type:"SCImgURL"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DSResponse.fromOfflineCache":{
        ref:"attr:DSResponse.fromOfflineCache",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"fromOfflineCache",
        flags:"R",
        description:"If set, indicates that this response came from the offline cache, not the server.  This \n flag is the only reliable way for application code to determine the source of a response.",
        groups:[
            "offlineGroup"
        ],
        definingClass:"class:DSResponse",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:MultiComboBoxItem.showValue":{
        ref:"method:MultiComboBoxItem.showValue",
        deprecated:null,
        name:"showValue",
        flags:"",
        description:" This method will be called whenever this FormItem's value is being set via a programmatic\n call to e.g: ${isc.DocUtils.linkForRef('method:DynamicForm.setValues')} or ${isc.DocUtils.linkForRef('method:FormItem.setValue')} and may be\n overridden by CanvasItems intended to support displaying data values to update the\n embedded Canvas to reflect the value passed in.\n <p>\n The value of a MultiComboBoxItem to the form is an array of valueField values corresponding\n to the selected combo box options.\n",
        definingClass:"class:MultiComboBoxItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"displayValue",
                description:"new display value for the item.  This is the value after applying   any custom formatter or valueMap",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"dataValue",
                description:"underlying data value for the item",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"form",
                description:"the dynamicForm in which this item is contained",
                optional:false,
                type:"DynamicForm"
            },
            {
                defaultValue:null,
                name:"item",
                description:"the live form item instance",
                optional:false,
                type:"CanvasItem"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataSourceField.valueXPath":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"XPath expression used to retrieve the field's value.\n <P>\n This XPath expression will be evaluated in the scope of the record objects selected by \n the ${isc.DocUtils.linkForRef('attr:DataSource.recordXPath')}.  For XML data \n (${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','dataFormat:\"xml\"')}) this means a call to\n ${isc.DocUtils.linkForRef('classMethod:XMLTools.selectString')} passing the selected XML element.  For JSON data\n (${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','dataFormat:\"json\"')}), this means a call to \n ${isc.DocUtils.linkForRef('classMethod:XMLTools.selectObjects')} passing the selected JSON object.\n <P>\n In the absence of a <code>valueXPath</code>, for JSON data the value for the field will\n be the value of the same-named property in the record object selected by\n ${isc.DocUtils.linkForRef('attr:DataSource.recordXPath','recordXPath')}.  \n <P>\n For XML data, the value will be the attribute or subelement named after the field name.\n For example, for a field \"author\" on a record element &lt;book&gt;, the following structures\n require no valueXPath:\n <pre>\n    &lt;book author=\"Mark Jones\"/&gt;\n\n    &lt;book&gt;\n        &lt;author&gt;Mark Jones&lt;/author&gt;\n    &lt;/book&gt;\n </pre>\n <P>\n If <code>valueXPath</code> is not required for your field because of the default handling\n described above, don't specify it, as it's slightly slower.\n <p>\n To learn about XPath, try the following search:\n <a href=\"http://www.google.com/search?q=xpath+tutorial\" target=\"_blank\"\n >http://www.google.com/search?q=xpath+tutorial</a>\n <P>\n <B>Using valueXPath with the SmartClient server</B>\n <p>\n If you're using the SmartClient server to return data via the DSResponse object (or\n indirectly doing so using DataSource DMI), the valueXPath you specify on the DataSource\n fields will be applied to the data you return via the \n <a href='http://commons.apache.org/jxpath/' target='_blank'>JXPath</a> library.\n <P>\n If you are returning Java Beans as your DSResponse data, normally each dataSource field\n receives the value of the same-named Java Bean property, that is, a field \"zipCode\" is\n populated by looking for \"getZipCode()\" on the objects passed as DSResponse data.  You can\n use <code>valueXPath</code> to retrieve properties from subobjects, so long as a chain of\n getter methods exists that corresponds to the valueXPath.  For example, a valueXPath of\n \"address/zipCode\" expects to call \"getAddress()\" on the bean(s) passed to\n DSResponse.setData(), followed by \"getZipCode()\" on whatever object \"getAddress()\" returns.\n <P>\n When you are saving data, the inbound DSRequest values, available as a Java Map, will use \n just dataSource field names as Map keys, not the valueXPath used to derive them.  However,\n to achieve bidirectional valueXPath binding, you can use the server-side method\n dataSource.setProperties() to use the valueXPath when setting properties on your server\n object model.  When applied as a setter, an XPath like \"address/zipCode\" attempts\n \"getAddress()\" followed by \"setZipCode()\" on the returned object.  JXPath also has some\n ability to auto-create intervening objects if they are missing, such as auto-creating an\n \"address\" subobject when applying \"address/zipCode\" as a valueXPath.\n <P>\n See the\n <a href='http://jakarta.apache.org/commons/jxpath/' target='_blank'>JXPath</a> library documentation for\n complete details, including other types of server object models supported, such as\n server-side XML.",
        groups:[
            "clientDataIntegration"
        ],
        type:"attr",
        seeAlso:[
            "DataSource.setProperties() (Java API)",
            "DSResponse.setData() (Java API)"
        ],
        ref:"attr:DataSourceField.valueXPath",
        examples:[
            "${isc.DocUtils.linkForExampleId('xpathBinding')}"
        ],
        valueType:"XPathExpression",
        name:"valueXPath",
        definingClass:"class:DataSourceField"
    },
    "attr:Task.outputFieldList":{
        ref:"attr:Task.outputFieldList",
        defaultValue:"null",
        valueType:"Array of String",
        deprecated:null,
        name:"outputFieldList",
        flags:"IR",
        description:"List of multiple fields from the ${isc.DocUtils.linkForRef('attr:Process.state','process state')} which this task will\n write to. See ${isc.DocUtils.linkForRef('group:taskIO')}.  \n <P>\n If ${isc.DocUtils.linkForRef('attr:Task.outputField')} is also specified, it will be implicitly added to the\n <code>outputFieldList</code> if it is not already present.",
        definingClass:"class:Task",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TabSet.addTab":{
        ref:"method:TabSet.addTab",
        examples:[
            "${isc.DocUtils.linkForExampleId('tabsAddAndRemove')}"
        ],
        deprecated:null,
        name:"addTab",
        flags:"A",
        description:" Add a tab\n",
        definingClass:"class:TabSet",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"tab",
                description:"new tab",
                optional:false,
                type:"Tab"
            },
            {
                defaultValue:null,
                name:"position",
                description:"position where tab should be added",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
            {
                ref:"method:TabSet.addTabs",
                description:null
            }
        ]
    },
    "method:Slider.setFlipValues":{
        ref:"method:Slider.setFlipValues",
        deprecated:null,
        name:"setFlipValues",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.flipValues')} property of the slider\n\n",
        definingClass:"class:Slider",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"flipValues",
                description:"flip slider values?",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataSourceField.joinSuffix":{
        ref:"attr:DataSourceField.joinSuffix",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"joinSuffix",
        flags:"IR",
        description:"Defines suffix after concatenated values if field is used with \n ${isc.DocUtils.linkForRef('group:serverSummaries','Server summaries')} feature and the \n ${isc.DocUtils.linkForRef('type:SummaryFunction','summary function')} is \"concat\".",
        groups:[
            "serverSummaries"
        ],
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSourceField.joinPrefix",
                description:null
            },
            {
                ref:"attr:DataSourceField.joinString",
                description:null
            },
            {
                ref:"type:SummaryFunction",
                description:null
            }
        ]
    },
    "attr:DateItem.maskDateSeparator":{
        ref:"attr:DateItem.maskDateSeparator",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"maskDateSeparator",
        flags:"IA",
        description:"If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} and ${isc.DocUtils.linkForRef('attr:DateItem.useMask')} are both <code>true</code>\n this value is the separator between date components. If unset ${isc.DocUtils.linkForRef('method:Date.getDefaultDateSeparator')}\n will be used.",
        groups:[
            "basics"
        ],
        definingClass:"class:DateItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DSResponse.data":{
        ref:"attr:DSResponse.data",
        defaultValue:"null",
        valueType:"Array of Record | RecordList",
        deprecated:null,
        name:"data",
        flags:"IR",
        description:"For \"fetch\" operations, this is the array of Records fetched.  For \"update\", \"add\", and\n \"remove\" operations, this is typically an array containing a single Record representing\n the record that was updated, added, or removed.",
        groups:[
            "dsResponse"
        ],
        definingClass:"class:DSResponse",
        type:"attr",
        seeAlso:[
        ]
    },
    "interface:Palette":{
        classAttrs:[
        ],
        methods:[
            "method:Palette.setDefaultEditContext",
            "method:Palette.makeEditNode"
        ],
        deprecated:null,
        description:"An interface that provides the ability to create components from a ${isc.DocUtils.linkForRef('object:PaletteNode')}.",
        groups:[
            "devTools"
        ],
        treeLocation:[
            "Client Reference/Tools"
        ],
        type:"interface",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:Palette.defaultEditContext",
            "attr:Palette.generateNames"
        ],
        ref:"interface:Palette",
        name:"Palette"
    },
    "attr:CalendarEvent.eventWindowStyle":{
        ref:"attr:CalendarEvent.eventWindowStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName')}",
        name:"eventWindowStyle",
        flags:"IR",
        description:"CSS style series to use for the draggable event window that represents this event.  If\n specified, overrides ${isc.DocUtils.linkForRef('attr:Calendar.eventWindowStyle')} for this specific event.\n <P>\n The name of this field within the CalendarEvent can be changed via\n ${isc.DocUtils.linkForRef('attr:Calendar.eventWindowStyleField')}",
        definingClass:"object:CalendarEvent",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:Validator.mustBeLaterThan":{
        ref:"classAttr:Validator.mustBeLaterThan",
        defaultValue:"\"Must be later than ${min}\"",
        valueType:"string",
        deprecated:null,
        name:"mustBeLaterThan",
        flags:"IRA",
        description:"Default error message to display when standard <code>dateRange</code> type validator\n returns false because the value passed in is greater than the specified maximum date.\n <p>This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Validator",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:ListGrid.getCriteria":{
        ref:"method:ListGrid.getCriteria",
        deprecated:null,
        name:"getCriteria",
        flags:"",
        description:" Retrieves a copy of the current criteria for this component (may be null).\n <P>\n Note: if ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is true, the criteria returned by this method may not\n match the values currently displayed in the filter editor, since the user may have entered\n values which have not yet been applied to our data. ${isc.DocUtils.linkForRef('method:ListGrid.getFilterEditorCriteria')}\n may be used to retrieve the current criteria displayed in the filterEditor.\n",
        groups:[
            "dataBoundComponentMethods"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"current filter criteria",
            type:"Criteria"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:RangeSlider.minValue":{
        ref:"attr:RangeSlider.minValue",
        defaultValue:"0",
        valueType:"float",
        deprecated:null,
        name:"minValue",
        flags:"IRW",
        description:"Set the minimum value (left/top of slider).",
        definingClass:"class:RangeSlider",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ToolStrip.formWrapperProperties":{
        ref:"attr:ToolStrip.formWrapperProperties",
        defaultValue:"null",
        valueType:"Object",
        deprecated:null,
        name:"formWrapperProperties",
        flags:"IR",
        description:"Properties to apply to ${isc.DocUtils.linkForRef('attr:ToolStrip.formWrapper')} components.",
        definingClass:"class:ToolStrip",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:allowedOperations":{
        ref:"group:allowedOperations",
        refs:[
            "attr:Calendar.canCreateEvents",
            "attr:Calendar.canEditEvents",
            "attr:Calendar.canDeleteEvents",
            "attr:Calendar.canRemoveEvents",
            "attr:Calendar.canDragEvents"
        ],
        deprecated:null,
        name:"allowedOperations",
        description:null,
        type:"group",
        title:"Allowed Operations",
        seeAlso:[
        ]
    },
    "method:Calendar.getDateFromPoint":{
        ref:"method:Calendar.getDateFromPoint",
        deprecated:null,
        name:"getDateFromPoint",
        flags:"",
        description:" Returns a Date instance representing the point at the passed offsets into the body of the \n current view.\n <P>\n If snapOffsets is passed as false, returns the date representing the \n exact position of the passed offsets.  If unset or passed as true, returns the date at the \n nearest eventSnapGap to the left, for ${isc.DocUtils.linkForRef('class:Timeline')}s, or above for ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day')} \n and ${isc.DocUtils.linkForRef('attr:Calendar.weekView','week')} views.\n <P>\n If neither x nor y offsets are passed, assumes them from the last mouse event.\n <P>\n If the cell at the eventual offsets is not a date-cell, returns null.\n <P>\n Note that, for the ${isc.DocUtils.linkForRef('attr:Calendar.monthView','month view')}, this method is functionally equivalent to \n ${isc.DocUtils.linkForRef('method:Calendar.getCellDate')}, which determines the date associated with a cell, without the additional \n offset precision offered here.\n\n",
        definingClass:"class:Calendar",
        returns:{
            description:"the date, if any, associated with the passed co-ords in the current view",
            type:"Date"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"x",
                description:"the x offset into the body of the selected view - non-functional for                       the ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day view')}.  If this param and \"y\" are both unset, \n                      assumes both offsets from the last mouse event.",
                optional:true,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"y",
                description:"the y offset into the body of the selected view - non-functional for the                            ${isc.DocUtils.linkForRef('attr:Calendar.timelineView','timeline view')}.  If this param and \"x\" are \n                            both unset, assumes both offsets from the last mouse event.",
                optional:true,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"snapOffsets",
                description:"whether to snap the offsets to the nearest eventSnapGap - if                                 unset, the default is true",
                optional:true,
                type:"Boolean"
            },
            {
                defaultValue:null,
                name:"view",
                description:"the view to use - or the selected view if not passed",
                optional:true,
                type:"CalendarView"
            }
        ],
        seeAlso:[
        ]
    },
    "class:RecordEditor":{
        classAttrs:[
        ],
        ref:"class:RecordEditor",
        methods:[
            "method:RecordEditor.performAction"
        ],
        deprecated:null,
        name:"RecordEditor",
        description:"Component for editing a single record.<br>\n  RecordEditors are implemented as a subclass of ListGrid, showing no header and a single \n  row always drawn in the editable state, allowing the user to modify the values at any time.\n  The ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButton')} is automatically shown as a way for the user to act \n  upon the edited values.\n  <P>\n  The RecordEditor class exists as a helper class for ListGrids, used to provide\n  an interface for editing criteria when ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor','filterEditor')} \n  is set to true.",
        treeLocation:[
            "Client Reference/Grids/ListGrid"
        ],
        type:"class",
        seeAlso:[
            {
                ref:"attr:ListGrid.showFilterEditor",
                description:null
            },
            {
                ref:"attr:ListGrid.filterEditor",
                description:null
            }
        ],
        classMethods:[
        ],
        attrs:[
            "attr:RecordEditor.baseStyle",
            "attr:RecordEditor.skinImgDir",
            "attr:RecordEditor.filterImg",
            "attr:RecordEditor.actionButton",
            "attr:RecordEditor.actionButtonProperties",
            "attr:RecordEditor.actionButtonStyle"
        ]
    },
    "classAttr:LoginDialog.PASSWORD_TITLE":{
        ref:"classAttr:LoginDialog.PASSWORD_TITLE",
        defaultValue:"\"Password\"",
        valueType:"HTML",
        deprecated:null,
        name:"PASSWORD_TITLE",
        flags:"IRW",
        description:"Default title for the ${isc.DocUtils.linkForRef('attr:LoginDialog.passwordItem','\"passwordItem\"')} field in the\n dialog displayed by ${isc.DocUtils.linkForRef('classMethod:isc.showLoginDialog')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:LoginDialog",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:DataSource.auditDataSourceID":{
        serverDS:"only",
        ref:"attr:DataSource.auditDataSourceID",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"auditDataSourceID",
        flags:"IR",
        description:"For DataSources with ${isc.DocUtils.linkForRef('attr:DataSource.audit','auditing enabled')}, optionally specifies the ID of the audit\n DataSource.  If this property is not specified, the ID of the audit DataSource will\n be <code>audit_[OriginalDSID] </code>",
        definingClass:"class:DataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.skinImgDir":{
        ref:"attr:ListGrid.skinImgDir",
        defaultValue:"\"images/ListGrid/\"",
        valueType:"URL",
        deprecated:null,
        name:"skinImgDir",
        flags:"IRWA",
        description:"Where do 'skin' images (those provided with the class) live?",
        groups:[
            "appearance",
            "images"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Slider.setThumbThinWidth":{
        ref:"method:Slider.setThumbThinWidth",
        deprecated:null,
        name:"setThumbThinWidth",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.thumbThinWidth')} property of the slider\n\n",
        definingClass:"class:Slider",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newWidth",
                description:"new thumbThinWidth",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "method:SectionStack.collapseSection":{
        ref:"method:SectionStack.collapseSection",
        examples:[
            "${isc.DocUtils.linkForExampleId('sectionsExpandCollapse')}"
        ],
        deprecated:null,
        name:"collapseSection",
        flags:"",
        description:" \n Collapse a section or sections.  This action hides all the items assigned to the\n section.  Calling this method is equivalent to the user clicking on the SectionHeader of\n an expanded section.\n This method is called when the user clicks on SectionHeaders\n to expand / collapse sections and so may be overridden to act as a notification method\n for the user expanding or collapsing sections.\n\n",
        definingClass:"class:SectionStack",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"sections",
                description:"Section(s) to collapse.  For this parameter, you can pass the position \n                      of the section in the SectionStack, the name of the section, or a\n                      List of section positions / names",
                optional:false,
                type:"int | String | Array of int | Array of String"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"callback to fire when the section has been collapsed",
                optional:true,
                type:"CollapseSectionCallback"
            }
        ],
        seeAlso:[
            {
                ref:"method:SectionStack.hideSection",
                description:null
            }
        ]
    },
    "attr:TreeGrid.indentRecordComponents":{
        ref:"attr:TreeGrid.indentRecordComponents",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"indentRecordComponents",
        flags:"IRW",
        description:"For record components placed \"within\" the ${isc.DocUtils.linkForRef('attr:TreeGridField.treeField','treeField')}\n column, should the component be indented to the position where a title would normally\n show?\n <P>\n For more general placement of embedded components, see\n ${isc.DocUtils.linkForRef('method:ListGrid.addEmbeddedComponent','addEmbeddedComponent')}.",
        definingClass:"class:TreeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.snapAlignEdgeLineStyle":{
        ref:"attr:Canvas.snapAlignEdgeLineStyle",
        defaultValue:"\"1px solid #555555\"",
        valueType:"String",
        deprecated:null,
        name:"snapAlignEdgeLineStyle",
        flags:"IR",
        description:"CSS border declaration used for the line shown to indicate snapping to a edge line when\n ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapAlign')} is set.",
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ColorPicker.greenFieldPrompt":{
        ref:"attr:ColorPicker.greenFieldPrompt",
        defaultValue:"\"The Green component of the selected color\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"greenFieldPrompt",
        flags:"IR",
        description:"The text to show when the mouse hovers over the 'Green' field in the complex chooser.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Window.setHeaderStyle":{
        ref:"method:Window.setHeaderStyle",
        deprecated:null,
        name:"setHeaderStyle",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:Window.headerStyle','headerStyle')}.\n",
        definingClass:"class:Window",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newHeaderStyle",
                description:"new ${isc.DocUtils.linkForRef('attr:Canvas.styleName','styleName')} for the ${isc.DocUtils.linkForRef('attr:Window.header','header')}.",
                optional:false,
                type:"CSSStyleName"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.removeFieldProperties":{
        ref:"attr:ListGrid.removeFieldProperties",
        defaultValue:"null",
        valueType:"ListGridField properties",
        deprecated:null,
        name:"removeFieldProperties",
        flags:"IR",
        description:"Configuration properties for the \"remove field\" displayed when\n ${isc.DocUtils.linkForRef('attr:ListGrid.canRemoveRecords')} is enabled.\n These configuration settings will be overlaid\n on top of the ${isc.DocUtils.linkForRef('attr:ListGrid.removeFieldDefaults')}.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.showStatisticsOverData":{
        ref:"attr:FacetChart.showStatisticsOverData",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showStatisticsOverData",
        flags:"IR",
        description:"If set, the ${isc.DocUtils.linkForRef('attr:FacetChart.showExpectedValueLine','mean line')},\n ${isc.DocUtils.linkForRef('attr:FacetChart.showStandardDeviationLines','standard deviation lines')},\n ${isc.DocUtils.linkForRef('attr:FacetChart.bandedStandardDeviations','standard deviation bands')},\n and ${isc.DocUtils.linkForRef('attr:FacetChart.showRegressionLine','regression curves')} are drawn on top of the data rather\n than underneath.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Facet.proportionalTitle":{
        ref:"attr:Facet.proportionalTitle",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"proportionalTitle",
        flags:"IR",
        description:"For ${isc.DocUtils.linkForRef('class:FacetChart','FacetCharts')} only, this property specifies the value axis\n label when a FacetChart is in ${isc.DocUtils.linkForRef('attr:FacetChart.proportional','proportional rendering mode')}\n and has this facet as its ${isc.DocUtils.linkForRef('method:FacetChart.getLegendFacet','legend facet')}.  If the\n <code>proportionalTitle</code> is not specified then\n ${isc.DocUtils.linkForRef('attr:FacetChart.proportionalAxisLabel')} is used as the default title.",
        definingClass:"class:Facet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSource.addGlobalId":{
        ref:"attr:DataSource.addGlobalId",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"addGlobalId",
        flags:"IRA",
        description:"Whether to make this DataSource available as a global variable for convenience.",
        groups:[
            "identity"
        ],
        definingClass:"class:DataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tab.canEditTitle":{
        ref:"attr:Tab.canEditTitle",
        examples:[
            "${isc.DocUtils.linkForExampleId('userEditableTitles')}"
        ],
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"canEditTitle",
        flags:"IRW",
        description:"If specified, overrides the ${isc.DocUtils.linkForRef('attr:TabSet.canEditTabTitles')} setting, for this one tab\n only.\n <p>\n Note that the TabSet's ${isc.DocUtils.linkForRef('attr:TabSet.titleEditEvent','titleEditEvent')} must be set to a\n supported ${isc.DocUtils.linkForRef('type:TabTitleEditEvent')} in order for users to be able to edit this tab's\n title.",
        definingClass:"object:Tab",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TabSet.canEditTabTitles",
                description:null
            }
        ]
    },
    "attr:BatchUploader.uploadEncoding":{
        ref:"attr:BatchUploader.uploadEncoding",
        defaultValue:"\"UTF-8\"",
        valueType:"String",
        deprecated:null,
        name:"uploadEncoding",
        flags:"IRW",
        description:"The encoding to use when importing files.  The default is \"UTF-8\".",
        definingClass:"class:BatchUploader",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.scrollToCell":{
        ref:"method:ListGrid.scrollToCell",
        deprecated:null,
        name:"scrollToCell",
        flags:"A",
        description:" Will scroll the listGrid body such that the specified cell is visible close to the\n center of the viewport.\n <P>\n This method has no effect if the cell is already visible in the viewport.\n <P>\n When scrolling vertically, this will cause data to be automatically loaded\n if ${isc.DocUtils.linkForRef('attr:ListGrid.dataFetchMode','paging is active')} and you scroll into an area of\n the data that isn't loaded.  Only rows around the target row will be\n loaded, not all intervening rows.  See also ${isc.DocUtils.linkForRef('class:ResultSet')}.\n <P>\n Scrolling into an undrawn area will cause the body area of the grid to\n redraw, but this won't happen synchronously unless you explicitly call\n redraw().  Scrolling into an area of the data that is not yet loaded\n will never synchronously draw new rows, even if you call redraw() -\n wait for ${isc.DocUtils.linkForRef('method:ListGrid.dataArrived')} to be notified when new rows have been\n loaded.\n <P>\n Calling this method with a row index larger than the\n current dataset will clamp to the end of the dataset (similarly horizontal\n scrolling will clamp to the last column).\n <P>\n If a call to this method is made while data is still loading, such\n that the last row of the dataset is not yet known the grid will attempt to compensate\n by scrolling the record into view when data arrives, if it is valid.\n For better control over scrolling, developers should consider\n calling <code>scrollToRow()</code> or <code>scrollToCell</code>\n from ${isc.DocUtils.linkForRef('method:ListGrid.dataArrived')} if data is still loading.\n <P>\n With mixed-height rows it will only reliably work if virtualScrolling\n is enabled.\n\n",
        groups:[
            "scrolling"
        ],
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"Row index of the cell to scroll into view",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"Column index of the cell to scroll into view",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"xPosition",
                description:"Horizontal position of scrolled cell (optional)",
                optional:true,
                type:"Alignment"
            },
            {
                defaultValue:null,
                name:"yPosition",
                description:"Vertical position of scrolled cell (optional)",
                optional:true,
                type:"VerticalAlignment"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:VisualBuilder.customComponentsURL":{
        ref:"attr:VisualBuilder.customComponentsURL",
        defaultValue:"\"customComponents.xml\"",
        valueType:"String",
        deprecated:null,
        name:"customComponentsURL",
        flags:"IR",
        description:"Relative URL to Visual Builder's customComponents.xml configuration file. The \n default value makes the framework look wherever Visual Builder itself was loaded from",
        definingClass:"class:VisualBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FormItem.hoverWidth":{
        ref:"attr:FormItem.hoverWidth",
        defaultValue:"null",
        valueType:"measure",
        deprecated:null,
        name:"hoverWidth",
        flags:"IRW",
        description:"Option to specify a width for any hover shown for this item.",
        groups:[
            "Hovers"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DynamicForm.itemHoverWidth",
                description:null
            }
        ]
    },
    "classAttr:MultiComboBoxItem.defaultHint":{
        ref:"classAttr:MultiComboBoxItem.defaultHint",
        defaultValue:"\"Enter values\"",
        valueType:"string",
        deprecated:null,
        name:"defaultHint",
        flags:"R",
        description:"The default hint string.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiComboBoxItem",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:ResultSet.getSort":{
        ref:"method:ResultSet.getSort",
        deprecated:null,
        name:"getSort",
        flags:"",
        description:" Return the current sort-specification for this ResultSet as an Array of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n \n",
        definingClass:"class:ResultSet",
        returns:{
            description:"the list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s currently applied to   this ResultSet",
            type:"Array of SortSpecifier"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ImgButton.iconAlign":{
        ref:"attr:ImgButton.iconAlign",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"iconAlign",
        flags:"IR",
        description:"If this button is showing an icon should it be right or left aligned?",
        groups:[
            "buttonIcon"
        ],
        definingClass:"class:ImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:jsStringTag":{
        ref:"group:jsStringTag",
        refs:[
        ],
        deprecated:null,
        name:"jsStringTag",
        description:"<i>produces:</i>JavaScript\n <p>\n This tag takes everything in its body and outputs a correctly-escaped JavaScript string.\n This is useful for capturing HTML for display in a Canvas or Label, for example.\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>var</b><br>\n <i>value format</i>: Any legal JavaScript variable name\n <i>default value</i>: NONE\n <p>\n If specified, the escaped string is assigned to a newly created variable of the specified\n name.  e.g: var foo = \"bar\";\n <p>\n <b>filename</b><br>\n <i>value format</i>: webRoot-relative path to file\n <i>default value</i>: NONE\n <p>\n If specified, the resulting string content is loaded from the specified file instead of\n from the tag body.",
        treeLocation:[
            "Java Server Reference/SmartClient JSP Tags"
        ],
        type:"group",
        title:"&lt;isomorphic:jsString&gt;",
        seeAlso:[
        ],
        requiresModules:[
            "SCServer"
        ]
    },
    "classAttr:Canvas.loadingImageSize":{
        ref:"classAttr:Canvas.loadingImageSize",
        defaultValue:"16",
        valueType:"integer",
        deprecated:null,
        name:"loadingImageSize",
        flags:"RWA",
        description:"Specifies the width and height of ${isc.DocUtils.linkForRef('classAttr:Canvas.loadingImageSrc')}.",
        groups:[
            "animation"
        ],
        definingClass:"class:Canvas",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:Slider.trackSrc":{
        ref:"attr:Slider.trackSrc",
        defaultValue:"\"track.gif\"",
        valueType:"String",
        deprecated:null,
        name:"trackSrc",
        flags:"IRW",
        description:"The base filename for the slider track images.\n The filenames for the track icons are assembled from this base filename and the state of the\n slider, as follows:<br>\n Assume the trackSrc is set to <code>{baseName}.{extension}</code><br>\n The full set of images to be displayed is:<br>\n For horizontal sliders:\n <ul>\n <li><code>h{baseName}_start.{extension}</code>: start (left edge) of the track for a slider\n     that is enabled.\n <li><code>h{baseName}_stretch.{extension}</code>:  the track for an enabled slider; this may\n     be centered, tiled, or stretched.\n <li><code>h{baseName}_end.{extension}</code>:  end (right edge) of the track for a slider\n     that is enabled.\n <li><code>h{baseName}_Disabled_start.{extension}</code>: start (left edge) of the track for a slider\n     that is disabled.\n <li><code>h{baseName}_Disabled_stretch.{extension}</code>:  the track for a disabled slider; this\n     may be centered, tiled, or stretched.\n <li><code>h{baseName}_Disabled_end.{extension}</code>:  end (right edge) of the track for a slider\n     that is disabled.\n </ul>\n For vertical sliders:\n <ul>\n <li><code>v{baseName}_start.{extension}</code>: start (bottom edge) of the track for a slider\n     that is enabled.\n <li><code>v{baseName}_stretch.{extension}</code>:  the track for an enabled slider; this may\n     be centered, tiled, or stretched.\n <li><code>v{baseName}_end.{extension}</code>:  end (top edge) of the track for a slider\n     that is enabled.\n <li><code>v{baseName}_Disabled_start.{extension}</code>: start (bottom edge) of the track for a slider\n     that is disabled.\n <li><code>v{baseName}_Disabled_stretch.{extension}</code>:  the track for a disabled slider; this\n     may be centered, tiled, or stretched.\n <li><code>v{baseName}_end.{extension}</code>:  end (top edge) of the track for a slider\n     that is disabled.\n </ul>",
        definingClass:"class:Slider",
        type:"attr",
        setter:[
            "setTrackSrc"
        ],
        seeAlso:[
            {
                ref:"attr:Slider.trackImageType",
                description:null
            }
        ]
    },
    "attr:Canvas.mouseStillDownInitialDelay":{
        ref:"attr:Canvas.mouseStillDownInitialDelay",
        defaultValue:"400",
        valueType:"int",
        deprecated:null,
        name:"mouseStillDownInitialDelay",
        flags:"IRWA",
        description:"Amount of time (in milliseconds) before mouseStillDown events start to be fired\n repeatedly for this canvas. See ${isc.DocUtils.linkForRef('method:Canvas.mouseStillDown')} for details.",
        groups:[
            "events"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:StatefulCanvas.setBaseStyle":{
        ref:"method:StatefulCanvas.setBaseStyle",
        deprecated:null,
        name:"setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        definingClass:"class:StatefulCanvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"style",
                description:"new base style",
                optional:false,
                type:"CSSStyleName"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:Time.PMIndicator":{
        ref:"classAttr:Time.PMIndicator",
        defaultValue:"\" pm\"",
        valueType:"string",
        deprecated:null,
        name:"PMIndicator",
        flags:"RWA",
        description:"String appended to times to indicate am (when not using 24 hour format).",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Time",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:Calendar.eventClick":{
        ref:"method:Calendar.eventClick",
        deprecated:null,
        name:"eventClick",
        flags:"",
        description:" Called whenever an event is clicked on in the day, week or month views.\n <P>\n By default a dialog appears showing details for the event, and offering the ability to\n edit events which are editable.  Return false to cancel the default action. This is a good\n place to, for example, show a completely customized event dialog instead of the default one.\n\n",
        definingClass:"class:Calendar",
        returns:{
            description:"false to cancel the default action",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"event",
                description:"event that was clicked on",
                optional:false,
                type:"CalendarEvent"
            },
            {
                defaultValue:null,
                name:"viewName",
                description:"view where the event's canvas was clicked",
                optional:false,
                type:"ViewName"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ValuesManager.getValuesAsCriteria":{
        ref:"method:ValuesManager.getValuesAsCriteria",
        deprecated:null,
        name:"getValuesAsCriteria",
        flags:"",
        description:" Retrieves the combined ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria','criteria values')} \n for all member forms.\n <P>\n As with the DynamicForm getValuesAsCriteria, this method may return\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} or simple ${isc.DocUtils.linkForRef('type:Criteria')} depending on whether\n the <code>advanced</code> parameter was passed, whether the ${isc.DocUtils.linkForRef('attr:ValuesManager.operator')}\n is set to <code>\"or\"</code> rather than <code>\"and\"</code>, and whether any member\n forms return ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.\n <P>\n Note that developers can also use ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria')} to combine\n sub-criteria from various sources, including member forms of a ValuesManager, into\n a combined criteria object.\n\n",
        groups:[
            "criteriaEditing"
        ],
        definingClass:"class:ValuesManager",
        returns:{
            description:"a ${isc.DocUtils.linkForRef('type:Criteria')} object, or ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}",
            type:"Criteria or AdvancedCriteria"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"advanced",
                description:"if true, return an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object even if the   form item values could be represented in a simple ${isc.DocUtils.linkForRef('object:Criterion')} object.",
                optional:false,
                type:"boolean"
            },
            {
                defaultValue:null,
                name:"textMatchStyle",
                description:"This parameter may be passed to indicate whether   the criteria are to be applied to a substring match (filter) or exact match (fetch).\n   When advanced criteria are returned this parameter will cause the appropriate\n   <code>operator</code> to be generated for individual fields' criterion clauses.",
                optional:true,
                type:"TextMatchStyle"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TextAreaItem.enforceLength":{
        ref:"attr:TextAreaItem.enforceLength",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"enforceLength",
        flags:"IRW",
        description:"If a ${isc.DocUtils.linkForRef('attr:TextAreaItem.length')} is specified for this item, should user input be limited\n to the specified length? If set to true, user input and values passed to \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','setValue()')} will be trimmed to the specified length. Otherwise values\n exceeding the specified length will raise an error on validation.\n <P>\n Note that having this value set to true limits user interactivity in some ways.\n For example users would be unable to paste a longer string into the field for\n editing without seeing it be truncated. Given how text areas are typically\n used to edit longer values than non-wrapping ${isc.DocUtils.linkForRef('class:TextItem')}s, this value is\n false by default for textAreaItems.",
        definingClass:"class:TextAreaItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:DrawLabelEditProxy":{
        classAttrs:[
        ],
        methods:[
            "method:DrawLabelEditProxy.getInlineEditText",
            "method:DrawLabelEditProxy.setInlineEditText"
        ],
        deprecated:null,
        description:"${isc.DocUtils.linkForRef('class:EditProxy')} that handles ${isc.DocUtils.linkForRef('class:DrawLabel','DrawLabels')} when editMode is enabled.",
        groups:[
            "devTools"
        ],
        treeLocation:[
            "Client Reference/Tools/EditProxy"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ],
        ref:"class:DrawLabelEditProxy",
        name:"DrawLabelEditProxy"
    },
    "method:GridRenderer.getCellStartRow":{
        ref:"method:GridRenderer.getCellStartRow",
        deprecated:null,
        name:"getCellStartRow",
        flags:"",
        description:" When using ${isc.DocUtils.linkForRef('method:GridRenderer.getRowSpan','row spanning')}, returns the row number where a row-spanning cell\n starts.\n <P>\n For example, if row 2 col 0 spans 3 cells, <code>getCellStartRow()</code> for row 2 col 0,\n row 3 col 0, row 4 col 0 will all return 2, because that's the row when spanning starts.\n\n",
        definingClass:"class:GridRenderer",
        returns:{
            description:"row number where spanning starts",
            type:"int"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number of cell for which the start row should be returned",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of cell for which the start row should be returned",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ToolStrip.groupTitleOrientation":{
        ref:"attr:ToolStrip.groupTitleOrientation",
        defaultValue:"\"top\"",
        valueType:"VerticalAlignment",
        deprecated:null,
        name:"groupTitleOrientation",
        flags:"IR",
        description:"If set, this attribute affects the orientation of the titles in \n ${isc.DocUtils.linkForRef('class:ToolStripGroup','ToolStripGroups')}.  You can override this at the \n ${isc.DocUtils.linkForRef('attr:ToolStripGroup.titleAlign','individual ToolStripGroup')} level.",
        definingClass:"class:ToolStrip",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:MiniDateRangeItem.setAutoValidate":{
        ref:"method:MiniDateRangeItem.setAutoValidate",
        deprecated:null,
        name:"setAutoValidate",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:MiniDateRangeItem.autoValidate')}\n",
        definingClass:"class:MiniDateRangeItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"autoValidate",
                description:"New auto-validate setting.",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Date.toEuropeanShortDate":{
        ref:"method:Date.toEuropeanShortDate",
        deprecated:null,
        name:"toEuropeanShortDate",
        flags:"",
        description:"\t\t\tReturn this date in the format: <code>DD/MM/YYYY</code>\n",
        groups:[
            "dateFormatting"
        ],
        definingClass:"class:Date",
        returns:{
            description:"formatted date string",
            type:"string"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:Deck.panes":{
        ref:"attr:Deck.panes",
        defaultValue:"null",
        valueType:"Array of Canvas",
        deprecated:null,
        name:"panes",
        flags:"IRW",
        description:"Set of mutually exclusive panes displayed in this <code>Deck</code>.\n <p>\n If ${isc.DocUtils.linkForRef('attr:Deck.currentPane')} is not set, when the <code>Deck</code> is first drawn, the\n first pane in this array becomes the <code>currentPane</code>.",
        definingClass:"class:Deck",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:sorting":{
        ref:"group:sorting",
        refs:[
            "type:SortArrow",
            "type:SortDirection",
            "method:ResultSet.sortByProperty",
            "method:List.sortByProperty",
            "method:ListGridField.sortNormalizer",
            "method:ListGrid.headerClick",
            "method:ListGrid.sorterContextClick",
            "method:ListGrid.sorterClick",
            "method:ListGrid.unsort",
            "method:ListGrid.resort",
            "method:ListGrid.sort",
            "method:ListGrid.getSortField",
            "method:ListGrid.toggleSort",
            "method:ListGrid.getSort",
            "method:Array.sortByProperty",
            "method:Array.unsort",
            "classMethod:Array.compareAscending",
            "classMethod:Array.compareDescending",
            "attr:PickList.sortField",
            "attr:PickList.initialSort",
            "attr:SelectItem.sortField",
            "attr:SelectItem.initialSort",
            "attr:ComboBoxItem.sortField",
            "attr:ComboBoxItem.initialSort",
            "attr:ListGridField.canSort",
            "attr:ListGridField.sortDirection",
            "attr:ListGrid.sortByGroupFirst",
            "attr:ListGrid.groupSortDirection",
            "attr:ListGrid.sortBinaryByFileName",
            "attr:ListGrid.canSort",
            "attr:ListGrid.selectHeaderOnSort",
            "attr:ListGrid.sortFieldNum",
            "attr:ListGrid.sortField",
            "attr:ListGrid.sortDirection",
            "attr:ListGrid.showSortArrow",
            "attr:ListGrid.initialSort"
        ],
        deprecated:null,
        name:"sorting",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:ColorPicker.lumWidth":{
        ref:"attr:ColorPicker.lumWidth",
        defaultValue:"15",
        valueType:"number",
        deprecated:null,
        name:"lumWidth",
        flags:"IR",
        description:"Width of the Luminosity bar",
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:StretchImg.gripImgSuffix":{
        ref:"attr:StretchImg.gripImgSuffix",
        defaultValue:"\"grip\"",
        valueType:"string",
        deprecated:null,
        name:"gripImgSuffix",
        flags:"IRA",
        description:"Suffix used the 'grip' image if ${isc.DocUtils.linkForRef('attr:StretchImg.showGrip')} is true.",
        groups:[
            "grip"
        ],
        definingClass:"class:StretchImg",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DetailViewer.emptyMessageHTML":{
        ref:"method:DetailViewer.emptyMessageHTML",
        deprecated:null,
        name:"emptyMessageHTML",
        flags:"A",
        description:" Return the message to show if the component has no data. Default implementation returns a \n centered ${isc.DocUtils.linkForRef('attr:DetailViewer.emptyMessage')} or \"&amp;nbsp;\" if showEmptyMessage is false.  If\n the component has no data because the browser is offline, we instead display the \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.offlineMessage')} or \"&amp;nbsp;\" if showOfflineMessage is false\n",
        definingClass:"class:DetailViewer",
        returns:{
            description:"HTML output",
            type:"string"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:Canvas.keyPress":{
        ref:"method:Canvas.keyPress",
        examples:[
            "${isc.DocUtils.linkForExampleId('keyboardEvents')}"
        ],
        deprecated:null,
        name:"keyPress",
        flags:"A",
        description:"\n Executed when a key is pressed and released on a focusable widget (${isc.DocUtils.linkForRef('attr:Canvas.canFocus')}:\n true).\n <P>\n Use ${isc.DocUtils.linkForRef('classMethod:EventHandler.getKey')} to find out the ${isc.DocUtils.linkForRef('type:KeyName','keyName')} of the key that\n was pressed, and use ${isc.DocUtils.linkForRef('classMethod:EventHandler.shiftKeyDown')} and related functions to determine\n whether modifier keys were down.\n\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"false to suppress native behavior in response to the keyPress, and prevent                   this event from bubbling to this widget's parent, or true or undefined to bubble.",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"attr:Canvas.canFocus",
                description:null
            }
        ]
    },
    "method:DrawPane.zoom":{
        ref:"method:DrawPane.zoom",
        deprecated:null,
        name:"zoom",
        flags:"",
        description:" Synonym of ${isc.DocUtils.linkForRef('method:DrawPane.setZoomLevel')}.\n",
        definingClass:"class:DrawPane",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"zoomLevel",
                description:"Desired zoom level as a float where <code>1.0</code> is equivalent to 100% magnification. Must be greater than 0.",
                optional:false,
                type:"float"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ColorPicker.moreButtonTitle":{
        ref:"attr:ColorPicker.moreButtonTitle",
        defaultValue:"\"More &gt;&gt;\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"moreButtonTitle",
        flags:"IR",
        description:"The title for the button that switches to a more complex view.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:FormItem.getValueIconStyle":{
        ref:"method:FormItem.getValueIconStyle",
        deprecated:null,
        name:"getValueIconStyle",
        flags:"A",
        description:" Except when ${isc.DocUtils.linkForRef('group:printing','printing')} and ${isc.DocUtils.linkForRef('method:FormItem.getPrintValueIconStyle','getPrintValueIconStyle()')}\n is implemented, this method is called to obtain the base CSS style to use on the\n ${isc.DocUtils.linkForRef('method:FormItem.getValueIcon','value icon')} for the item's current value.\n <p>\n If not <code>null</code>, the base style is suffixed with the state of the value icon\n (\"\", \"Over\", \"Down\", \"Disabled\").\n\n",
        definingClass:"class:FormItem",
        returns:{
            description:"CSS style to use, or <code>null</code> if no style should be used.",
            type:"CSSStyleName"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"value",
                description:"value of this item.",
                optional:false,
                type:"any"
            }
        ],
        seeAlso:[
            {
                ref:"method:FormItem.getPrintValueIconStyle",
                description:null
            }
        ]
    },
    "attr:ListGrid.enumCriteriaAsInitialValues":{
        ref:"attr:ListGrid.enumCriteriaAsInitialValues",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"enumCriteriaAsInitialValues",
        flags:"IR",
        description:"In a ListGrid that has a DataSource and has filter criteria that include values for\n fields declared as ${isc.DocUtils.linkForRef('type:FieldType','type \"enum\"')} in the DataSource, by default a newly\n edited row will use those filter criteria as initial values.\n <P>\n For example, if a ListGrid is showing all Accounts that have status:\"Active\" and a new row\n is created, the new row will default to status:\"Active\" unless this flag is set to false.",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:EBay.setUseProduction":{
        ref:"method:EBay.setUseProduction",
        deprecated:null,
        name:"setUseProduction",
        flags:"",
        description:"\n You can use web services in sandbox or production mode.  By default, this web service\n will work in sandbox mode.  Call this method with a true value to switch to production\n mode.\n\n",
        definingClass:"class:EBay",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"useProduction",
                description:"true to use production, false to use sandbox",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ComboBoxItem.formatOnBlur":{
        ref:"attr:ComboBoxItem.formatOnBlur",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"formatOnBlur",
        flags:"IRW",
        description:"With <code>formatOnBlur</code> enabled, this comboBoxItem will format its value\n according to the rules described in ${isc.DocUtils.linkForRef('method:FormItem.mapValueToDisplay')} as long as the \n item does not have focus.  Once the user puts focus into the item\n the formatter will be removed. This provides a simple way for developers to\n show a nicely formatted display value in a freeform text field, without the need\n for an explicit ${isc.DocUtils.linkForRef('method:FormItem.formatEditorValue')} \n and ${isc.DocUtils.linkForRef('method:FormItem.parseEditorValue')} pair.\n <P>\n Note that this attribute is not compatible with ${isc.DocUtils.linkForRef('attr:ComboBoxItem.completeOnTab')}",
        definingClass:"class:ComboBoxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:panelPlacement":{
        ref:"group:panelPlacement",
        refs:[
            "attr:SelectItem.pickListPlacement",
            "attr:SelectItem.pickerExitButton",
            "attr:SelectItem.pickerExitButtonTitle",
            "attr:SelectItem.pickerClearButton",
            "attr:SelectItem.pickerClearButtonTitle",
            "attr:SelectItem.pickerNavigationBar",
            "attr:ComboBoxItem.pickListPlacement",
            "attr:ComboBoxItem.pickerSearchField",
            "attr:ComboBoxItem.pickerSearchFieldHint",
            "attr:ComboBoxItem.pickerSearchForm",
            "attr:ComboBoxItem.pickerExitButton",
            "attr:ComboBoxItem.pickerExitButtonTitle",
            "attr:ComboBoxItem.pickerSaveButton",
            "attr:ComboBoxItem.pickerSaveButtonTitle",
            "attr:ComboBoxItem.pickerClearButton",
            "attr:ComboBoxItem.pickerClearButtonTitle",
            "attr:ComboBoxItem.pickerNavigationBar"
        ],
        deprecated:null,
        name:"panelPlacement",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:TileGrid.drawAllMaxTiles":{
        ref:"attr:TileGrid.drawAllMaxTiles",
        defaultValue:"25",
        valueType:"integer",
        deprecated:null,
        name:"drawAllMaxTiles",
        flags:"IRWA",
        description:"If drawing all tiles would cause no more than <code>drawAllMaxTiles</code> tiles to be\n rendered, the full dataset will instead be drawn even if ${isc.DocUtils.linkForRef('attr:TileGrid.showAllRecords')}\n is false and incremental rendering would have otherwise been used.\n <P>\n The <code>drawAllMaxTiles</code> setting prevents incremental rendering from being used in\n situations where it's really unnecessary, such as a 25 record dataset which happens to be\n in a grid with a viewport showing only 15 or so tiles.  Incremental rendering causes a brief\n \"flash\" during scrolling as the visible portion of the dataset is redrawn, and a better \n scrolling experience can be obtained in this situation by drawing the entire dataset up\n front, which in this example would have negligible effect on initial draw time.\n <P>\n <code>drawAllMaxTiles:0</code> disables this features.  You may want to disable this feature\n if performance is an issue and:\n <ul>\n <li> you very frequently redraw a grid\n <li> you do a lot of computation when rendering each tile\n <li> you are showing many grids on one screen and the user won't scroll most of them\n </ul>",
        groups:[
            "performance"
        ],
        definingClass:"class:TileGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TileGrid.tileConstructor",
                description:null
            }
        ]
    },
    "classAttr:Validator.notABoolean":{
        ref:"classAttr:Validator.notABoolean",
        defaultValue:"\"Must be a true/false value\"",
        valueType:"string",
        deprecated:null,
        name:"notABoolean",
        flags:"IRA",
        description:"Default error message to display when standard <code>isBoolean</code> type validator\n  returns false.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Validator",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:SelectItemEditProxy.setInlineEditText":{
        ref:"method:SelectItemEditProxy.setInlineEditText",
        deprecated:null,
        name:"setInlineEditText",
        flags:"",
        description:" Save the new value into the component's state. Called by the\n ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditForm')} to commit the change.\n <p>\n Updates the component's valueMap and current value.\n\n",
        definingClass:"class:SelectItemEditProxy",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newValue",
                description:"the new component valueMap",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DrawDiamond.left":{
        ref:"attr:DrawDiamond.left",
        defaultValue:"0",
        valueType:"int",
        deprecated:null,
        name:"left",
        flags:"IRW",
        description:"Left coordinate of the diamond. This is the X coordinate of the western point of the\n diamond.",
        definingClass:"class:DrawDiamond",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.getCellFacetValues":{
        ref:"method:CubeGrid.getCellFacetValues",
        deprecated:null,
        name:"getCellFacetValues",
        flags:"",
        description:" Given a cell coordinate within this CubeGrid return a ${isc.DocUtils.linkForRef('object:FacetValueMap')}\n indicating the facet values for the cell.\n",
        definingClass:"class:CubeGrid",
        returns:{
            description:"facet values for the specified cell. Returns null if the specified cell    is not present in the grid.",
            type:"FacetValueMap"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row index of the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column index of the cell",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Slider.minValueLabel":{
        ref:"attr:Slider.minValueLabel",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"minValueLabel",
        flags:"IRW",
        description:"The text displayed in the label for the minimum value of the slider. If left as null, then\n slider.minValue will be displayed.",
        definingClass:"class:Slider",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Slider.showRange",
                description:null
            },
            {
                ref:"attr:Slider.minValue",
                description:null
            }
        ]
    },
    "attr:DynamicForm.dataFetchMode":{
        ref:"attr:DynamicForm.dataFetchMode",
        defaultValue:"\"paged\"",
        valueType:"FetchMode",
        deprecated:null,
        name:"dataFetchMode",
        flags:"IRW",
        description:"How to fetch and manage records retrieve from the server.  See ${isc.DocUtils.linkForRef('type:FetchMode')}.\n <P>\n This setting only applies to the ${isc.DocUtils.linkForRef('class:ResultSet')} automatically created by calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')}.  If a pre-existing ResultSet is passed to setData() instead, it's\n existing setting for ${isc.DocUtils.linkForRef('attr:ResultSet.fetchMode')} applies.",
        groups:[
            "databinding"
        ],
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:GridRenderer.rowOver":{
        ref:"method:GridRenderer.rowOver",
        deprecated:null,
        name:"rowOver",
        flags:"A",
        description:" Called when the mouse pointer enters a row\n\n",
        groups:[
            "events"
        ],
        definingClass:"class:GridRenderer",
        returns:{
            description:"whether to cancel the event",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"record",
                description:"cell record as returned by getCellRecord",
                optional:false,
                type:"ListGridRecord"
            },
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number for the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of the cell",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "group:Hovers":{
        ref:"group:Hovers",
        refs:[
            "method:DynamicForm.itemHoverHTML",
            "method:DynamicForm.titleHoverHTML",
            "method:DynamicForm.valueHoverHTML",
            "method:FormItem.stopHover",
            "method:FormItem.itemHover",
            "method:FormItem.titleHover",
            "method:FormItem.valueHover",
            "method:FormItem.titleHoverHTML",
            "method:FormItem.valueHoverHTML",
            "method:FormItem.itemHoverHTML",
            "method:RadioGroupItem.valueHoverHTML",
            "attr:DynamicForm.itemHoverDelay",
            "attr:DynamicForm.itemHoverWidth",
            "attr:DynamicForm.itemHoverHeight",
            "attr:DynamicForm.itemHoverAlign",
            "attr:DynamicForm.itemHoverVAlign",
            "attr:DynamicForm.itemHoverStyle",
            "attr:DynamicForm.itemHoverOpacity",
            "attr:FormItem.hoverDelay",
            "attr:FormItem.hoverWidth",
            "attr:FormItem.hoverHeight",
            "attr:FormItem.hoverAlign",
            "attr:FormItem.hoverVAlign",
            "attr:FormItem.hoverStyle",
            "attr:FormItem.hoverOpacity",
            "attr:FormItem.showClippedTitleOnHover",
            "attr:FormItem.showClippedValueOnHover"
        ],
        deprecated:null,
        name:"Hovers",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.summaryValueTitle":{
        ref:"attr:DataSourceField.summaryValueTitle",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"summaryValueTitle",
        flags:"IR",
        description:"Title to show in a ${isc.DocUtils.linkForRef('type:SummaryFunction','Summary of type \"title\"')} for this field. If unspecified\n <code>title</code> summaries will show the ${isc.DocUtils.linkForRef('attr:DataSourceField.title')} for the field.",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.showDragHovers":{
        ref:"attr:Calendar.showDragHovers",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showDragHovers",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:Calendar.showViewHovers','showViewHovers')} is true, dictates whether to display\n hover prompts when an event is being dragged with the mouse.\n <P>\n The content of the hover is determined by a call to \n ${isc.DocUtils.linkForRef('method:Calendar.getDragHoverHTML')}, which can be overridden to return custom results; by \n default, it returns the date range of the drag canvas as a string.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:Page.isLoaded":{
        ref:"classMethod:Page.isLoaded",
        deprecated:null,
        name:"isLoaded",
        flags:"",
        description:"\t\tHas the page finished loading?\n\n",
        definingClass:"class:Page",
        returns:{
            description:"true == page is done loading",
            type:"Boolean"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "group:subset":{
        ref:"group:subset",
        refs:[
            "method:Array.getUniqueItems"
        ],
        deprecated:null,
        name:"subset",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "group:menuItemEvents":{
        ref:"group:menuItemEvents",
        refs:[
            "method:MenuItem.click"
        ],
        deprecated:null,
        name:"menuItemEvents",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:EditProxy.selectedAppearance":{
        ref:"attr:EditProxy.selectedAppearance",
        defaultValue:"null",
        valueType:"SelectedAppearance",
        deprecated:null,
        name:"selectedAppearance",
        flags:"IR",
        description:"Appearance that is applied to selected component. Default value is determined from\n ${isc.DocUtils.linkForRef('attr:EditContext.selectedAppearance')}.\n <P>\n When value is <code>null</code> the appearance is determined by:\n <ul>\n <li>If multiple selection is enabled, \"tintMask\" is used</li>\n <li>Otherwise, \"outlineMask\" is used \n </ul>",
        definingClass:"class:EditProxy",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:EditProxy.selectedBorder",
                description:null
            },
            {
                ref:"attr:EditProxy.selectedTintColor",
                description:null
            },
            {
                ref:"attr:EditProxy.selectedTintOpacity",
                description:null
            }
        ]
    },
    "attr:Button.iconSize":{
        ref:"attr:Button.iconSize",
        defaultValue:"16",
        valueType:"int",
        deprecated:null,
        name:"iconSize",
        flags:"IR",
        description:"Size in pixels of the icon image.\n <P>\n The ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconWidth','iconWidth')} and ${isc.DocUtils.linkForRef('attr:StatefulCanvas.iconHeight','iconHeight')}\n properties can be used to configure width and height separately.\n <P>\n Note: When configuring the properties of a <code>StatefulCanvas</code> (or derivative)\n ${isc.DocUtils.linkForRef('type:AutoChild','AutoChild')}, it is best to set the <code>iconWidth</code> and <code>iconHeight</code>\n to the same value rather than setting an <code>iconSize</code>. This is because certain\n skins or customizations thereto might set the <code>iconWidth</code> and <code>iconHeight</code>,\n making the customization of the AutoChild's <code>iconSize</code> ineffective.",
        groups:[
            "buttonIcon"
        ],
        definingClass:"class:Button",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:StretchImgButton.hiliteAccessKey":{
        ref:"attr:StretchImgButton.hiliteAccessKey",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"hiliteAccessKey",
        flags:"IRW",
        description:"If set to true, if the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.title','title')} of this button contains the\n specified ${isc.DocUtils.linkForRef('attr:Canvas.accessKey','accessKey')}, when the title is displayed to the user\n it will be modified to include HTML to underline the accessKey.<br>\n Note that this property may cause titles that include HTML (rather than simple strings)\n to be inappropriately modified, so should be disabled if your title string includes\n HTML characters.",
        definingClass:"class:StretchImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Progressbar.breadth":{
        getter:[
            "getBreadth"
        ],
        defaultValue:"20",
        deprecated:null,
        flags:"IRW",
        description:"Thickness of the progressbar in pixels. This is effectively width for a vertical\n progressbar, or height for a horizontal progressbar.\n <P>\n This property must be set instead of setting <code>width</code> or <code>height</code>.",
        groups:[
            "appearance"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Progressbar.breadth",
        valueType:"number",
        name:"breadth",
        definingClass:"class:Progressbar",
        setter:[
            "setBreadth"
        ]
    },
    "method:HiliteRule.getHilite":{
        ref:"method:HiliteRule.getHilite",
        deprecated:null,
        name:"getHilite",
        flags:"",
        description:" Return the hilite definition being edited, including criteria and hilite properties.\n\n",
        definingClass:"class:HiliteRule",
        returns:{
            description:"the hilite",
            type:"Hilite"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:MultiSortDialog.initialSort":{
        ref:"attr:MultiSortDialog.initialSort",
        defaultValue:"null",
        valueType:"Array of SortSpecifier",
        deprecated:null,
        name:"initialSort",
        flags:"IR",
        description:"The initial sort configuration to show in the \n ${isc.DocUtils.linkForRef('attr:MultiSortPanel.optionsGrid','optionsGrid')}.\n <P>\n Note, this is a passthrough property which, when set, is passed through to the \n ${isc.DocUtils.linkForRef('class:MultiSortPanel','MultiSortPanel')} contained in this dialog.",
        definingClass:"class:MultiSortDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGridField.getGridSummary":{
        ref:"method:ListGridField.getGridSummary",
        deprecated:null,
        name:"getGridSummary",
        flags:"A",
        description:" If ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} is true, and this method is specified it will be\n called to generate the summary value to be displayed in the grid summary row. Note that\n this is called instead of making use of the ${isc.DocUtils.linkForRef('attr:ListGridField.summaryFunction')}.\n <P>\n As with ${isc.DocUtils.linkForRef('method:ListGrid.getGridSummary')} this method may return an array of results -\n in this case each result will show up in a separate row in the ${isc.DocUtils.linkForRef('attr:ListGrid.summaryRow')}\n grid.\n <P>\n If this grid is grouped, and ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} is true, this method\n will be passed a third parameter - an array of group-level summaries.\n",
        definingClass:"object:ListGridField",
        returns:{
            description:"summary value to display.",
            type:"any"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"records",
                description:"records for which a summary is being generated",
                optional:false,
                type:"Array of ListGridRecord"
            },
            {
                defaultValue:null,
                name:"field",
                description:"pointer to the field for which summary value is being generated",
                optional:false,
                type:"ListGridField"
            },
            {
                defaultValue:null,
                name:"groupSummaries",
                description:"If this grid is grouped and  ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} is specified, this parameter contains an array of already-\n  calculated summary values for each group in the grid. Each element in this array will\n  be an object containing calculated summary values for each field in the grid, as well as\n  a specified groupValue and groupName, allowing the developer to determine which group this\n  summary value comes from",
                optional:true,
                type:"Array of objects"
            }
        ],
        seeAlso:[
        ]
    },
    "method:MultiSortDialog.getNumLevels":{
        ref:"method:MultiSortDialog.getNumLevels",
        deprecated:null,
        name:"getNumLevels",
        flags:"",
        description:" Return the number of levels of sorting that have been configured.\n\n",
        definingClass:"class:MultiSortDialog",
        returns:{
            description:"The number of levels of sorting that have been configured",
            type:"number"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:DataBoundComponent.getTitleField":{
        ref:"method:DataBoundComponent.getTitleField",
        deprecated:null,
        name:"getTitleField",
        flags:"",
        description:" Method to return the fieldName which represents the \"title\" for records in this\n Component.<br>\n If this.titleField is explicitly specified it will always be used.\n Otherwise, default implementation will check ${isc.DocUtils.linkForRef('attr:DataSource.titleField')} for databound\n compounds.<br>\n For non databound components returns the first defined field name of <code>\"title\"</code>,\n <code>\"name\"</code>, or <code>\"id\"</code> where the field is visible. If we don't find any\n field-names that match these titles, the first field in the component will be used instead.\n",
        definingClass:"interface:DataBoundComponent",
        returns:{
            description:"fieldName for title field for this component.",
            type:"string"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:DynamicForm.rejectInvalidValueOnChange":{
        ref:"attr:DynamicForm.rejectInvalidValueOnChange",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"rejectInvalidValueOnChange",
        flags:"IRWA",
        description:"If validateOnChange is true, and validation fails for an item on change, with no suggested\n value, should we revert to the previous value, or continue to display the bad value entered\n by the user. May be set at the item or form level.",
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:ClassFactory.getClass":{
        ref:"classMethod:ClassFactory.getClass",
        deprecated:null,
        name:"getClass",
        flags:"",
        description:"\n\tGiven a class name, return a pointer to the Class object for that class\n\n",
        definingClass:"object:ClassFactory",
        returns:{
            description:"Class object, or null if not found",
            type:"Class"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"className",
                description:"name of a class",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TreeNode.canDrag":{
        ref:"attr:TreeNode.canDrag",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"canDrag",
        flags:"IRA",
        description:"Governs whether this node can be dragged. Only has an effect if this node is displayed in\n a ${isc.DocUtils.linkForRef('class:TreeGrid')} where ${isc.DocUtils.linkForRef('attr:TreeGrid.canDragRecordsOut')}, ${isc.DocUtils.linkForRef('attr:TreeGrid.canReorderRecords')}\n or ${isc.DocUtils.linkForRef('attr:TreeGrid.canReparentNodes')} is <code>true</code>.",
        definingClass:"object:TreeNode",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.useBackMask":{
        ref:"attr:Canvas.useBackMask",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"useBackMask",
        flags:"IRWA",
        description:"In earlier versions of Internet Explorer (pre IE9), a native limitation\n exists  whereby if HTML elements are\n overlapping on the page, certain elements can appear to \"burn through\"\n elements in the same position with a higher z-index.\n Specific cases in which this have been observed include Applets,\n &lt;IFRAME&gt; elements, and for\n older versions of IE, native &lt;SELECT&gt; items.\n <P>\n The backMask is a workaround for this issue. If <code>useBackMask</code> is\n set to <code>true</code>, the component will render an empty &lt;IFRAME&gt; element\n behind the canvas, which prevents this effect in all known cases.\n <P>\n Has no effect in other browsers.",
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:FacetChart.allChartTypes":{
        ref:"classAttr:FacetChart.allChartTypes",
        defaultValue:"[\"Area\", \"Bar\", \"Bubble\", \"Column\", \"Doughnut\", \"Line\", \"Pie\", \"Radar\", \"Scatter\"]",
        valueType:"Array of ChartType",
        deprecated:null,
        name:"allChartTypes",
        flags:"R",
        description:"All ${isc.DocUtils.linkForRef('type:ChartType','ChartTypes')} that are supported by this class.\n Should be defined by concrete implementations of the charting interface.",
        definingClass:"class:FacetChart",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:Canvas.editProxyConstructor":{
        ref:"attr:Canvas.editProxyConstructor",
        defaultValue:"\"CanvasEditProxy\"",
        valueType:"SCClassName",
        deprecated:null,
        name:"editProxyConstructor",
        flags:"IR",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.enabled":{
        defaultValue:"\"unset\"",
        deprecated:"As of SmartClient version 5.5 this property has been deprecated. The   ${isc.DocUtils.linkForRef('attr:Canvas.disabled')} property will be used to govern enabled/disabled state instead\n  if <code>this.enabled</code> has not been changed from its default value.",
        flags:"IRWA",
        description:"If set to true, this widget will be enabled, if set to false, or null, this\n widget will be disabled.",
        groups:[
            "enable"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Canvas.enabled",
        valueType:"boolean",
        name:"enabled",
        definingClass:"class:Canvas",
        setter:[
            "setEnabled"
        ]
    },
    "attr:DrawItem.showTitleLabelBackground":{
        ref:"attr:DrawItem.showTitleLabelBackground",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"showTitleLabelBackground",
        flags:"IRA",
        description:"If the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabel','titleLabel')} is showing, should the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabelBackground','titleLabelBackground')}\n be created and placed behind the <code>titleLabel</code>?\n <p>\n This defaults to true for ${isc.DocUtils.linkForRef('class:DrawSector')}s and shapes that are not commonly filled\n (e.g. ${isc.DocUtils.linkForRef('class:DrawLine')}s).",
        definingClass:"class:DrawItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:SpinnerItem.getPreviousValue":{
        ref:"method:SpinnerItem.getPreviousValue",
        deprecated:null,
        name:"getPreviousValue",
        flags:"A",
        description:" When ${isc.DocUtils.linkForRef('attr:SpinnerItem.min','min')} and ${isc.DocUtils.linkForRef('attr:SpinnerItem.max','max')} are both null or unspecified,\n this method is called to get the previous lower value from the currentValue. The default\n implementation returns (currentValue&nbsp;<b>+</b>&nbsp;step) because the step parameter\n is based on <em>the opposite</em> of ${isc.DocUtils.linkForRef('attr:SpinnerItem.step','this.step')}.\n <p>\n To indicate that the given currentValue is the minimum value, return currentValue again.\n <p>\n Implementations should expect to be passed any value for currentValue. Also, if\n ${isc.DocUtils.linkForRef('attr:SpinnerItem.step')} is non-negative, getPreviousValue() must induce a\n <a href='http://en.wikipedia.org/wiki/Monotonic_function' target='_blank'>monotonically decreasing (non-increasing) function</a>;\n otherwise, getPreviousValue() must induce a monotonically increasing function.\n",
        definingClass:"class:SpinnerItem",
        returns:{
            description:"the next higher value",
            type:"number"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"currentValue",
                description:"the current value of this SpinnerItem",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"step",
                description:"a suggested step value based on the opposite of ${isc.DocUtils.linkForRef('attr:SpinnerItem.step','this.step')} and how long the user has been continuously decreasing the value.",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
            {
                ref:"method:SpinnerItem.getNextValue",
                description:null
            }
        ]
    },
    "method:ListGrid.setFieldTitle":{
        ref:"method:ListGrid.setFieldTitle",
        deprecated:null,
        name:"setFieldTitle",
        flags:"",
        description:" Change the title of a field after the grid is created.\n\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldNum",
                description:"name of the field, or index.",
                optional:false,
                type:"int | String"
            },
            {
                defaultValue:null,
                name:"title",
                description:"new title",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "class:Gauge":{
        classAttrs:[
        ],
        methods:[
            "method:Gauge.setMinValue",
            "method:Gauge.setDialRadius",
            "method:Gauge.setPivotPoint",
            "method:Gauge.setMaxValue",
            "method:Gauge.setValue",
            "method:Gauge.setNumMajorTicks",
            "method:Gauge.setNumMinorTicks",
            "method:Gauge.setLabelPrefix",
            "method:Gauge.setLabelSuffix",
            "method:Gauge.setDrawnClockwise",
            "method:Gauge.formatLabelContents",
            "method:Gauge.reformatLabelContents",
            "method:Gauge.getNumSectors",
            "method:Gauge.getSectorValue",
            "method:Gauge.getDefaultFillColor",
            "method:Gauge.getSectorFillColor",
            "method:Gauge.setSectorFillColor",
            "method:Gauge.getSectorLabelContents",
            "method:Gauge.setSectors",
            "method:Gauge.addSector",
            "method:Gauge.removeSector"
        ],
        deprecated:null,
        description:"The Gauge widget class implements a graphical speedometer-style gauge for displaying\n a measurement by means of a needle on a dial. The dial is divided into sectors, each having\n its own color and value.\n <P>\n <b>NOTE:</b> you must load the Drawing ${isc.DocUtils.linkForRef('group:loadingOptionalModules','Optional Module')}\n before you can use Gauge.",
        treeLocation:[
            "Client Reference/Drawing"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:Gauge.pivotPointHeight",
            "attr:Gauge.pivotShape",
            "attr:Gauge.needle",
            "attr:Gauge.valueLabel",
            "attr:Gauge.tickLine",
            "attr:Gauge.sectorShape",
            "attr:Gauge.dialRadius",
            "attr:Gauge.fontSize",
            "attr:Gauge.borderWidth",
            "attr:Gauge.borderColor",
            "attr:Gauge.sectorColors",
            "attr:Gauge.minValue",
            "attr:Gauge.maxValue",
            "attr:Gauge.value",
            "attr:Gauge.numMajorTicks",
            "attr:Gauge.numMinorTicks",
            "attr:Gauge.labelPrefix",
            "attr:Gauge.labelSuffix",
            "attr:Gauge.drawnClockwise",
            "attr:Gauge.sectors",
            "attr:Gauge.pivotPoint"
        ],
        inheritsFrom:"DrawPane",
        ref:"class:Gauge",
        examples:[
            "${isc.DocUtils.linkForExampleId('Gauge')}"
        ],
        name:"Gauge"
    },
    "method:DrawItem.setMoveKnobOffset":{
        ref:"method:DrawItem.setMoveKnobOffset",
        examples:[
            "${isc.DocUtils.linkForExampleId('drawKnobs')}"
        ],
        deprecated:null,
        name:"setMoveKnobOffset",
        flags:"A",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:DrawItem.moveKnobOffset')}.\n",
        definingClass:"class:DrawItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newMoveKnobOffset",
                description:"the new move knob offset. This is a 2-element array of [left offset, top offset]. If null, then <code>[0,0]</code>\n  is assumed.",
                optional:true,
                type:"Array[] of int"
            }
        ],
        seeAlso:[
        ]
    },
    "method:MenuBar.setButtons":{
        ref:"method:MenuBar.setButtons",
        deprecated:null,
        name:"setButtons",
        flags:"",
        description:" Invalid to call on Menubar, use ${isc.DocUtils.linkForRef('method:MenuBar.setMenus')} instead.\n",
        definingClass:"class:MenuBar",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newButtons",
                description:"invalid; do not call",
                optional:true,
                type:"Array of Button Properties"
            }
        ],
        seeAlso:[
        ]
    },
    "method:SectionStack.sectionForItem":{
        ref:"method:SectionStack.sectionForItem",
        deprecated:null,
        name:"sectionForItem",
        flags:"",
        description:" \n Search for a section that contains passed item.\n\n",
        definingClass:"class:SectionStack",
        returns:{
            description:"section that contains passed item.",
            type:"SectionStackSection"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"item",
                description:"item to show",
                optional:false,
                type:"Canvas"
            }
        ],
        seeAlso:[
            {
                ref:"method:SectionStack.expandSection",
                description:null
            }
        ]
    },
    "attr:DynamicForm.showErrorText":{
        ref:"attr:DynamicForm.showErrorText",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showErrorText",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed when they are displayed inline in the form (next to the form item where there\n is a validation error).  To instead display all errors at the top of the form, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors','showInlineErrors')}:false.\n <P>\n <code>showErrorIcons</code>, <code>showErrorText</code> and <code>showErrorStyle</code>\n are all boolean properties, and can be set on a DynamicForm to control the behavior\n form-wide, or set on individual FormItems.  \n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implementation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).  \n <P>\n In addition to this, <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')} for a \n discussion for how error styling is calculated.",
        groups:[
            "validation"
        ],
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Canvas.animateResize":{
        ref:"method:Canvas.animateResize",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateResize')}"
        ],
        deprecated:null,
        name:"animateResize",
        flags:"",
        description:" Animate a resize of this canvas from its current size to the specified size\n",
        groups:[
            "animation"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"width",
                description:"new width (or null for unchanged)",
                optional:false,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"height",
                description:"new height (or null for unchanged)",
                optional:false,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"When the resize completes this callback will be fired. Single                              'earlyFinish' parameter will be passed if the animation was\n                              cut short by a call to finishAnimation",
                optional:true,
                type:"AnimationCallback"
            },
            {
                defaultValue:null,
                name:"duration",
                description:"Duration in ms of the animated resize",
                optional:true,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"acceleration",
                description:"Optional acceleration effect to apply to the resize",
                optional:true,
                type:"AnimationAcceleration"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:SpacerItem.showTitle":{
        ref:"attr:SpacerItem.showTitle",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showTitle",
        flags:"IRW",
        description:"we never show a separate title cell for spacers",
        groups:[
            "appearance"
        ],
        definingClass:"class:SpacerItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.logScale":{
        ref:"attr:MetricSettings.logScale",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"logScale",
        flags:"IR",
        description:"Whether to use logarithmic scaling for values.\n <P>\n Logarithmic scale charts show an equivalent percentage increase as equivalent distance\n on the chart.  That is, 10 and 100 are the same distance apart as 100 and 1000 (each\n being a 10 times or 1000% increase).",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSource.cacheAllData":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Set this property to true to have a DataSource fetch all of its data client-side on the \n first fetch request.  However, unlike a ${isc.DocUtils.linkForRef('attr:DataSource.clientOnly','clientOnly')} DataSource, this DataSource \n will still save changes normally, sending remote requests.\n <P>\n You can manually set this attribute after initialization by calling \n ${isc.DocUtils.linkForRef('method:DataSource.setCacheAllData')}; setting ${isc.DocUtils.linkForRef('attr:DataSource.autoCacheAllData')}:true causes a DataSource to \n automatically switch to <code>cacheAllData:true</code> when a fetch results in the\n entire dataset being brought client-side.\n <P>\n To cause automatic cache updates, you can set ${isc.DocUtils.linkForRef('attr:DataSource.cacheMaxAge')} to a number of seconds\n and once data has been client-side for that length of time, the next fetch causes the\n cache to be dropped and a new cache retrieved.\n <P>\n Note that multiple ${isc.DocUtils.linkForRef('attr:DataSource.operationBindings')} of type \"fetch\" which return distinct\n results will not work with <code>cacheAllData</code>: only one cache is created and is\n used for all fetch operations, regardless of whether ${isc.DocUtils.linkForRef('attr:DSRequest.operationId')} has\n been set.  However, \"fetch\" operationBindings used as a\n ${isc.DocUtils.linkForRef('attr:OperationBinding.cacheSyncOperation')} will work normally, so long as they return\n all data fields that are returned by the default \"fetch\" operation, so that the cache\n can be updated.\n <P>\n To specify which operationId to use for fetching all data, use\n ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllOperationId','cacheAllOperationId')}.\n <p>\n To use the cache only for requests that have the <code>cacheAllOperationId</code>,\n allowing any other operationId (or absence of an operationId) to contact the server as\n normal, set ${isc.DocUtils.linkForRef('attr:DataSource.cacheAcrossOperationIds','cacheAcrossOperationIds')}.",
        groups:[
            "clientData"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DataSource.cacheAllData",
        valueType:"Boolean",
        name:"cacheAllData",
        definingClass:"class:DataSource",
        setter:[
            "setCacheAllData"
        ]
    },
    "method:ListGrid.setHeaderSpanHeaderTitle":{
        ref:"method:ListGrid.setHeaderSpanHeaderTitle",
        deprecated:null,
        name:"setHeaderSpanHeaderTitle",
        flags:"",
        description:" Update the headerTitle of a ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpan')} dynamically.\n\n",
        groups:[
            "headerSpan"
        ],
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"name",
                description:"name of the headerSpan, as specified via ${isc.DocUtils.linkForRef('attr:HeaderSpan.name')}.",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"newTitle",
                description:"new headerTitle for the headerSpan",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TabSet.simpleTabButtonConstructor":{
        ref:"attr:TabSet.simpleTabButtonConstructor",
        defaultValue:"SimpleTabButton",
        valueType:"Class",
        deprecated:null,
        name:"simpleTabButtonConstructor",
        flags:"IRA",
        description:"Tab button constructor if ${isc.DocUtils.linkForRef('attr:TabSet.useSimpleTabs')} is true.",
        definingClass:"class:TabSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:FilterBuilder.search":{
        ref:"method:FilterBuilder.search",
        deprecated:null,
        name:"search",
        flags:"",
        description:" A StringMethod that is automatically invoked if ${isc.DocUtils.linkForRef('attr:FilterBuilder.saveOnEnter')} is set \n and the user presses Enter whilst in a text-item in any clause or subclause.\n\n",
        definingClass:"class:FilterBuilder",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"The criteria represented by the filterBuilder",
                optional:false,
                type:"AdvancedCriteria"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.alternateRecordStyles":{
        defaultValue:"false",
        deprecated:null,
        flags:"IRW",
        description:"Whether alternating rows should be drawn in alternating styles, in order to create a \"ledger\"\n effect for easier reading.  If enabled, the cell style for alternate rows will have \"Dark\"\n appended to it.",
        groups:[
            "cellStyling"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.alternateRecordStyles",
        examples:[
            "${isc.DocUtils.linkForExampleId('gridCells')}"
        ],
        valueType:"Boolean",
        name:"alternateRecordStyles",
        definingClass:"class:ListGrid",
        setter:[
            "setAlternateRecordStyles"
        ]
    },
    "class:BlurbItem":{
        classAttrs:[
        ],
        ref:"class:BlurbItem",
        methods:[
        ],
        deprecated:null,
        name:"BlurbItem",
        description:"FormItem intended for inserting blurbs of instructional HTML into DynamicForms.\n <p>\n Set the <code>defaultValue</code> of this item to the HTML you want to embed in the form.",
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:BlurbItem.editProxyConstructor",
            "attr:BlurbItem.showTitle",
            "attr:BlurbItem.colSpan",
            "attr:BlurbItem.textBoxStyle",
            "attr:BlurbItem.canSelectText",
            "attr:BlurbItem.wrap",
            "attr:BlurbItem.clipValue"
        ]
    },
    "attr:ListGridField.defaultFilterValue":{
        ref:"attr:ListGridField.defaultFilterValue",
        defaultValue:"null",
        valueType:"any",
        deprecated:null,
        name:"defaultFilterValue",
        flags:"IRWA",
        description:"If this ListGrid is showing a filter row, this property can be used to apply a default\n value to show in the filter editor for this field.",
        groups:[
            "filterEditor"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:TitleRotationMode":{
        ref:"type:TitleRotationMode",
        values:[
            {
                description:"the <code>titleLabel</code> is never rotated with the item.",
                value:"\"neverRotate\""
            },
            {
                description:"the <code>titleLabel</code> is rotated exactly to match the item's rotation (see ${isc.DocUtils.linkForRef('attr:DrawItem.rotation')}).",
                value:"\"withItem\""
            },
            {
                description:"the <code>titleLabel</code> is rotated exactly to match the item's rotation, except that at certain rotations, the <code>titleLabel</code> is flipped\n by 180&deg; so that the title text is never upside down.",
                value:"\"withItemAlwaysUp\""
            },
            {
                description:"(applies only to ${isc.DocUtils.linkForRef('class:DrawLine')} and ${isc.DocUtils.linkForRef('class:DrawLinePath')}) the <code>titleLabel</code> is rotated to match the line or center segment.\n <p>\n If used on a <code>DrawItem</code> that is not a <code>DrawLine</code> or <code>DrawLinePath</code>,\n then the effect is the same as\n \"withItem\".\n ",
                value:"\"withLine\""
            },
            {
                description:"(applies only to ${isc.DocUtils.linkForRef('class:DrawLine')} and ${isc.DocUtils.linkForRef('class:DrawLinePath')}) the <code>titleLabel</code> is rotated to match the line or center segment, except that\n at certain rotations, the <code>titleLabel</code> is flipped by 180&deg; so that the\n title text is never upside down.\n <p>\n If used on a <code>DrawItem</code> that is not a <code>DrawLine</code> or <code>DrawLinePath</code>,\n then the effect is the same as\n \"withItemAlwaysUp\".\n ",
                value:"\"withLineAlwaysUp\""
            }
        ],
        deprecated:null,
        name:"TitleRotationMode",
        description:"The different ways in which the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabel','titleLabel')} of a ${isc.DocUtils.linkForRef('class:DrawItem')}\n can be rotated with the item.\n <p>\n <strong>NOTE:</strong> The effect of the\n \"withItemAlwaysUp\" and \"withLineAlwaysUp\"\n \n settings is not affected by the global rotation, if any (see ${isc.DocUtils.linkForRef('attr:DrawPane.rotation')}).",
        type:"type",
        seeAlso:[
        ]
    },
    "attr:Flashlet.src":{
        ref:"attr:Flashlet.src",
        defaultValue:"null",
        valueType:"URL",
        deprecated:null,
        name:"src",
        flags:"IR",
        description:"Location from which to load the Flashlet.",
        definingClass:"class:Flashlet",
        type:"attr",
        setter:[
            "setSrc"
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.setFastCellUpdates":{
        ref:"method:ListGrid.setFastCellUpdates",
        deprecated:null,
        name:"setFastCellUpdates",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:GridRenderer.fastCellUpdates')}. Has no effect in browsers other than\n Internet Explorer.\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fastCellUpdates",
                description:"whether to enable fastCellUpdates.",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:Class.map":{
        ref:"classMethod:Class.map",
        deprecated:null,
        name:"map",
        flags:"",
        description:"\n Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.\n\n",
        definingClass:"class:Class",
        returns:{
            description:"Array of results, one per element in the passed \"items\" Array",
            type:"Array"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"methodName",
                description:"Name of the method on this instance which should be called on each element of the Array",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"items",
                description:"Array of items to call the method on",
                optional:false,
                type:"Array"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:EventHandler.leftButtonDown":{
        ref:"classMethod:EventHandler.leftButtonDown",
        deprecated:null,
        name:"leftButtonDown",
        flags:"",
        description:"\t\t\tReturns true if the left mouse button is being pressed.\n\n",
        groups:[
            "mouseEvents"
        ],
        definingClass:"class:EventHandler",
        returns:{
            description:"true == left button is down, false == up",
            type:"Boolean"
        },
        type:"classMethod",
        platformNotes:"Mac:\t\tMacintosh platform generally has only one mouse button - ISC considers it to be the \"left\"\n\t\tmouse button, so this method will return true if the mouse is down on a single-button mouse Mac.",
        seeAlso:[
            {
                ref:"classMethod:EventHandler.middleButtonDown",
                description:null
            },
            {
                ref:"classMethod:EventHandler.rightButtonDown",
                description:null
            }
        ]
    },
    "method:ValuesManager.setErrors":{
        ref:"method:ValuesManager.setErrors",
        deprecated:null,
        name:"setErrors",
        flags:"A",
        description:" Sets validation errors for this valuesManager to the specified set of errors.\n Errors should be of the format:<br>\n <code>{field1:errors, field2:errors}</code><br>\n where each <code>errors</code> object is either a single error message string or an\n array of error messages.<br>\n If <code>showErrors</code> is passed in, error messages will be displayed in the \n appropriate member form items. For fields with no visible form item, \n ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')} will be fired instead.<br>\n Note that if <code>showErrors</code> is false, errors may be shown at any time via\n a call to ${isc.DocUtils.linkForRef('method:ValuesManager.showErrors')}.\n\n",
        groups:[
            "errors"
        ],
        definingClass:"class:ValuesManager",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"errors",
                description:"list of errors as an object with the field names as keys",
                optional:false,
                type:"object"
            },
            {
                defaultValue:null,
                name:"showErrors",
                description:"If true display errors now.",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.headerMenuButtonConstructor":{
        ref:"attr:ListGrid.headerMenuButtonConstructor",
        defaultValue:"null",
        valueType:"className",
        deprecated:null,
        name:"headerMenuButtonConstructor",
        flags:"IRA",
        description:"Constructor for the  ${isc.DocUtils.linkForRef('attr:ListGrid.headerMenuButton')}. If unset a standard \"Button\" will\n be rendered out. Note that this property may be overridden by different skins.",
        groups:[
            "headerMenuButton"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:Window":{
        exampleConfig:"Window.xml",
        classAttrs:[
        ],
        methods:[
            "method:Window.setHeaderStyle",
            "method:Window.setShowCloseButton",
            "method:Window.setShowMinimizeButton",
            "method:Window.setShowMaximizeButton",
            "method:Window.setShowHeaderIcon",
            "method:Window.setTitle",
            "method:Window.setStatus",
            "method:Window.setSrc",
            "method:Window.setBodyStyle",
            "method:Window.setBodyColor",
            "method:Window.setHiliteBodyColor",
            "method:Window.addItem",
            "method:Window.removeItem",
            "method:Window.addItems",
            "method:Window.removeItems",
            "method:Window.addMember",
            "method:Window.addMembers",
            "method:Window.setAutoSize",
            "method:Window.shouldDismissOnEscape",
            "method:Window.centerInPage",
            "method:Window.flash",
            "method:Window.minimize",
            "method:Window.restore",
            "method:Window.maximize",
            "method:Window.closeClick",
            "method:Window.close"
        ],
        deprecated:null,
        description:"A general purpose Window class for implementing dialogs, portlets, alerts, prompts, wizards\n and desktop-like windowing interfaces.\n <P>\n Windows can contain arbitrary SmartClient components, configured via the ${isc.DocUtils.linkForRef('attr:Window.items')}\n property.  Windows may be ${isc.DocUtils.linkForRef('attr:Window.isModal','modal')} or non-modal.\n <P>\n Windows provide a series of highly configurable and skinnable ${isc.DocUtils.linkForRef('type:AutoChild','autoChildren')}\n including a header, various header controls, footer, and corner resizer.\n <P>\n The more specialized ${isc.DocUtils.linkForRef('class:Dialog')} subclass of Window has additional functionality targetted\n at simple prompts and confirmations, such as buttons with default actions, and single-method\n ${isc.DocUtils.linkForRef('classMethod:isc.warn','shortcuts')} for common application dialogs.",
        treeLocation:[
            "Client Reference/Layout"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:Window.editProxyConstructor",
            "attr:Window.canDragReposition",
            "attr:Window.keepInParentRect",
            "attr:Window.canDragResize",
            "attr:Window.useBackMask",
            "attr:Window.opacity",
            "attr:Window.isModal",
            "attr:Window.modalMask",
            "attr:Window.showModalMask",
            "attr:Window.modalMaskOpacity",
            "attr:Window.modalMaskStyle",
            "attr:Window.autoCenter",
            "attr:Window.dismissOnOutsideClick",
            "attr:Window.dismissOnEscape",
            "attr:Window.body",
            "attr:Window.showBody",
            "attr:Window.bodyStyle",
            "attr:Window.printBodyStyle",
            "attr:Window.bodyColor",
            "attr:Window.hiliteBodyColor",
            "attr:Window.items",
            "attr:Window.src",
            "attr:Window.contentsType",
            "attr:Window.bodyConstructor",
            "attr:Window.bodyDefaults",
            "attr:Window.contentLayout",
            "attr:Window.autoSize",
            "attr:Window.header",
            "attr:Window.showHeader",
            "attr:Window.headerBackground",
            "attr:Window.showHeaderBackground",
            "attr:Window.headerStyle",
            "attr:Window.printHeaderStyle",
            "attr:Window.headerSrc",
            "attr:Window.headerControls",
            "attr:Window.hiliteHeaderStyle",
            "attr:Window.hiliteHeaderSrc",
            "attr:Window.headerLabel",
            "attr:Window.showTitle",
            "attr:Window.title",
            "attr:Window.headerLabelDefaults",
            "attr:Window.headerIcon",
            "attr:Window.showHeaderIcon",
            "attr:Window.headerIconDefaults",
            "attr:Window.canFocusInHeaderButtons",
            "attr:Window.closeButton",
            "attr:Window.showCloseButton",
            "attr:Window.minimizeButton",
            "attr:Window.showMinimizeButton",
            "attr:Window.minimized",
            "attr:Window.defaultMinimizeHeight",
            "attr:Window.minimizeHeight",
            "attr:Window.animateMinimize",
            "attr:Window.minimizeTime",
            "attr:Window.minimizeAcceleration",
            "attr:Window.restoreButton",
            "attr:Window.maximized",
            "attr:Window.maximizeButton",
            "attr:Window.showMaximizeButton",
            "attr:Window.footer",
            "attr:Window.showFooter",
            "attr:Window.footerHeight",
            "attr:Window.footerControls",
            "attr:Window.statusBar",
            "attr:Window.showStatusBar",
            "attr:Window.resizer",
            "attr:Window.showResizer",
            "attr:Window.placement",
            "attr:Window.showEdges",
            "attr:Window.showShadow",
            "attr:Window.fillSpaceStyleName",
            "attr:Window.bringToFrontOnMouseUp",
            "attr:Window.status"
        ],
        ref:"class:Window",
        name:"Window"
    },
    "attr:ListGrid.instantScrollTrackRedraw":{
        ref:"attr:ListGrid.instantScrollTrackRedraw",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"instantScrollTrackRedraw",
        flags:"IRW",
        description:"If true, if the user clicks on the scroll buttons at the end of the track or clicks once on\n the scroll track, there will be an instant redraw of the grid content so that the user\n doesn't see any blank space.  For drag scrolling or other types of scrolling, the\n ${isc.DocUtils.linkForRef('attr:ListGrid.scrollRedrawDelay')} applies.",
        groups:[
            "performance"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.canAcceptDroppedRecords":{
        defaultValue:"false",
        deprecated:null,
        flags:"IRW",
        description:"Indicates whether records can be dropped into this listGrid.",
        groups:[
            "dragging"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridRecord.canDrag",
                description:null
            },
            {
                ref:"attr:ListGridRecord.canAcceptDrop",
                description:null
            }
        ],
        ref:"attr:ListGrid.canAcceptDroppedRecords",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragListMove')}"
        ],
        valueType:"Boolean",
        name:"canAcceptDroppedRecords",
        definingClass:"class:ListGrid"
    },
    "attr:FacetChart.zoomStartPosition":{
        ref:"attr:FacetChart.zoomStartPosition",
        defaultValue:"null",
        valueType:"ZoomStartPosition",
        deprecated:null,
        name:"zoomStartPosition",
        flags:"IR",
        description:"For a ${isc.DocUtils.linkForRef('attr:FacetChart.canZoom','zoomed chart')}, determines what portion of the overall dataset should be\n initially shown in the main chart.\n <P>\n Default is to show the end of the dataset if the X axis shows time and includes today's date,\n otherwise to show the start of the dataset.\n <P>\n Set this property to override this default, or use ${isc.DocUtils.linkForRef('attr:FacetChart.zoomStartValue')} and\n ${isc.DocUtils.linkForRef('attr:FacetChart.zoomEndValue')} to start with a particular range.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SectionStack.canResizeSections":{
        ref:"attr:SectionStack.canResizeSections",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"canResizeSections",
        flags:"IRA",
        description:"Whether sections can be drag resized by the user dragging the section header.\n <P>\n Note that, with <code>canResizeSections:true</code>, not all sections can be resized:\n sections that contain only ${isc.DocUtils.linkForRef('attr:Button.autoFit','autofitting')} components or that are\n marked with ${isc.DocUtils.linkForRef('attr:SectionStackSection.resizeable','section.resizeable:false')} will not be\n resizeable.",
        definingClass:"class:SectionStack",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.proportionalAxisLabel":{
        ref:"attr:MetricSettings.proportionalAxisLabel",
        defaultValue:"\"Percent\"",
        valueType:"String",
        deprecated:null,
        name:"proportionalAxisLabel",
        flags:"IR",
        description:"Default title for the value axis label when the chart is in\n ${isc.DocUtils.linkForRef('attr:MetricSettings.proportional','proportional rendering mode')}.  This title will be used unless the\n ${isc.DocUtils.linkForRef('method:FacetChart.getLegendFacet','legend facet')} defines a\n ${isc.DocUtils.linkForRef('attr:Facet.proportionalTitle','proportionalTitle')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:PickList.fetchDelay":{
        ref:"attr:PickList.fetchDelay",
        defaultValue:"200",
        valueType:"number",
        deprecated:null,
        name:"fetchDelay",
        flags:"IRWA",
        description:"For a ComboBox or other pickList that accepts user-entered criteria, how many\n milliseconds to wait after the last user keystroke before fetching data from the server.\n The default setting will initiate a fetch if the user stops typing or pauses briefly.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.facetValuesSelected":{
        ref:"method:CubeGrid.facetValuesSelected",
        deprecated:null,
        name:"facetValuesSelected",
        flags:"",
        description:" Return whether the header indicated by the set of facetValues is selected.\n\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CubeGrid",
        returns:{
            description:"true if the header is selected",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetValues",
                description:"facetValues to test",
                optional:false,
                type:"FacetValueMap"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:SVG.pluginsPage":{
        ref:"attr:SVG.pluginsPage",
        defaultValue:"see below",
        valueType:"URL",
        deprecated:null,
        name:"pluginsPage",
        flags:"IR",
        description:"This attribute specifies the page the user should go to to get the plugin required to view\n  this SVG.\n  <p>\n  The default pluginsPage is: \"http://www.adobe.com/svg/viewer/install/\"\n  <p>",
        definingClass:"class:SVG",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:ProcessValueType":{
        ref:"type:ProcessValueType",
        values:[
            {
                description:"values that are not already strings are converted via toString()",
                value:"\"string\""
            },
            {
                description:"the strings \"true\" and \"false\" become boolean true and false.  All other                 Strings non-empty String values are true, all numbers are true except 0, and\n                 all other non-null values are true",
                value:"\"boolean\""
            },
            {
                description:"values are converted via toString() and parsing as a decimal number.                 Invalid values trigger a transition to the ${isc.DocUtils.linkForRef('attr:StateTask.failureElement')}",
                value:"\"decimal\""
            },
            {
                description:"values are converted via toString(), parsing as a number, and rounding to                 nearest integer.  Invalid values trigger a transition to the\n                 ${isc.DocUtils.linkForRef('attr:StateTask.failureElement')}",
                value:"\"integer\""
            },
            {
                description:"any input which is not already a Record or Map becomes null",
                value:"\"record\""
            },
            {
                description:"generic array type - will convert value to an array of the same type as the               existing value",
                value:"\"array\""
            }
        ],
        deprecated:null,
        name:"ProcessValueType",
        description:null,
        type:"type",
        seeAlso:[
        ]
    },
    "method:ListGrid.isRowNumberField":{
        ref:"method:ListGrid.isRowNumberField",
        deprecated:null,
        name:"isRowNumberField",
        flags:"",
        description:" Identifies whether the passed-in field is the specially generated\n ${isc.DocUtils.linkForRef('attr:ListGrid.rowNumberField','rowNumberField')} used when ${isc.DocUtils.linkForRef('attr:ListGrid.showRowNumbers')} is\n true.  Use this method in your custom event handlers to avoid inappropriately\n performing actions when the rowNumberField is clicked on.\n\n",
        groups:[
            "rowNumberField"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"whether the provided field is the rowNumberField",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"field",
                description:"field to test",
                optional:false,
                type:"ListGridField"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:Operators.greaterThanTitle":{
        ref:"classAttr:Operators.greaterThanTitle",
        defaultValue:"\"greater than\"",
        valueType:"String",
        deprecated:null,
        name:"greaterThanTitle",
        flags:"IR",
        description:"Title for the \"greaterThan\" operator",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Operators",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:DateRangeItem.setCriterion":{
        ref:"method:DateRangeItem.setCriterion",
        deprecated:null,
        name:"setCriterion",
        flags:"",
        description:" Applies the specified criterion to this item for editing. Applies any specified \n \"greaterOrEqual\" operator criterion or sub-criterion to our ${isc.DocUtils.linkForRef('attr:DateRangeItem.fromField','fromField')} and any\n specified \"lessOrEqual\" operator criterion or sub-criterion to our ${isc.DocUtils.linkForRef('attr:DateRangeItem.toField','toField')}.\n <P>\n Note that a single \"equals\" criterion can also be passed.  See \n ${isc.DocUtils.linkForRef('method:DateRangeItem.canEditCriterion','canEditCriterion()')} for more detail.\n",
        groups:[
            "criteriaEditing"
        ],
        definingClass:"class:DateRangeItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criterion",
                description:"criterion to edit",
                optional:false,
                type:"Criterion"
            }
        ],
        seeAlso:[
        ]
    },
    "type:RecordSummaryFunction":{
        ref:"type:RecordSummaryFunction",
        values:[
            {
                description:"Iterates through each field, picking up the numeric field values from the record and summing them.",
                value:"sum"
            },
            {
                description:"Iterates through each field, picking up the numeric field values from the record and calculating the mean value.",
                value:"avg"
            },
            {
                description:"Iterates through each field, picking up the numeric field values from the record and calculating the maximum value.",
                value:"max"
            },
            {
                description:"Iterates through each field, picking up the numeric field values from the record and calculating the minimum value.",
                value:"min"
            },
            {
                description:"Iterates through each field, picking up the numeric field values from the record and multiplying them together.",
                value:"multiplier"
            }
        ],
        deprecated:null,
        name:"RecordSummaryFunction",
        description:"Function to produce a summary value based on field values within a record.\n Example usage is record-level summaries in \n ${isc.DocUtils.linkForRef('type:ListGridFieldType','\"summary\" type ListGrid fields')}.\n <P>\n SummaryFunctions may be specified in one of 2 ways:<ul>\n <li>as an explicit function or executable\n ${isc.DocUtils.linkForRef('group:stringMethods','StringMethod')}. Takes 3 parameters:\n <br><code>record</code> the record for which the value is being calculated\n <br><code>fields</code> Array of listGridFields from which summaries should be calculated\n <br><code>summaryField</code> pointer to the summary type field on which the summary function\n is being run.</li>\n <li>As a registered RecordSummaryFunction identifier</li></ul>\n Note that ${isc.DocUtils.linkForRef('classMethod:DataSource.registerRecordSummaryFunction')} may be used to expand the\n set of registered RecordSummaryFunctions.",
        type:"type",
        seeAlso:[
        ]
    },
    "method:EditPane.getSaveData":{
        ref:"method:EditPane.getSaveData",
        deprecated:null,
        name:"getSaveData",
        flags:"",
        description:" Returns an Array of ${isc.DocUtils.linkForRef('object:PaletteNode')}s representing all current ${isc.DocUtils.linkForRef('object:EditNode')}s in this\n pane, suitable for saving and restoring via passing each paletteNode to ${isc.DocUtils.linkForRef('method:EditContext.addNode','addNode()')}.\n",
        definingClass:"class:EditPane",
        returns:{
            description:"paletteNodes suitable for saving for subsequent restoration",
            type:"Array of PaletteNode"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:EditContext.serializeAllEditNodes",
                description:null
            },
            {
                ref:"method:EditContext.serializeAllEditNodesAsJSON",
                description:null
            }
        ]
    },
    "attr:ListGrid.nullGroupTitle":{
        ref:"attr:ListGrid.nullGroupTitle",
        defaultValue:"'-none-'",
        valueType:"String",
        deprecated:null,
        name:"nullGroupTitle",
        flags:"IRW",
        description:"Default alias to use for groups with no value",
        groups:[
            "grouping"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ]
    },
    "attr:DataSourceField.timeFormatter":{
        ref:"attr:DataSourceField.timeFormatter",
        defaultValue:"null",
        valueType:"TimeDisplayFormat",
        deprecated:null,
        name:"timeFormatter",
        flags:"IRWA",
        description:"Preferred time-format to apply to date type values within this field.  If this property is\n specified on a field displayed within a dataBound component such as a ${isc.DocUtils.linkForRef('class:ListGrid')} or\n ${isc.DocUtils.linkForRef('class:DynamicForm')}, any dates displayed in this field will be formatted as times using the\n appropriate format.\n <P>\n This is most commonly only applied to fields specified as type <code>\"time\"</code> though\n if no explicit ${isc.DocUtils.linkForRef('attr:FormItem.dateFormatter')} is specified it will be respected for other \n fields as well.\n <P>\n See ${isc.DocUtils.linkForRef('attr:ListGridField.timeFormatter')} and ${isc.DocUtils.linkForRef('attr:FormItem.timeFormatter')} for more information.",
        groups:[
            "appearance"
        ],
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TileGrid.transferDragData":{
        ref:"method:TileGrid.transferDragData",
        deprecated:null,
        name:"transferDragData",
        flags:"",
        description:"\n During a drag-and-drop interaction, this method is called to transfer a set of records that\n were dropped onto some other component.  This method is called after the set of records has\n been copied to the other component.  Whether or not this component's data is modified is \n determined by the value of ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dragDataAction')}.\n <P>\n With a <code>dragDataAction</code> of \"move\", a databound component will issue \"remove\"\n dsRequests against its DataSource to actually remove the data, via\n ${isc.DocUtils.linkForRef('method:DataSource.removeData')}.\n\n",
        definingClass:"class:TileGrid",
        returns:{
            description:"Array of objects that were dragged out of this ListGrid.",
            type:"Array"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:DataBoundComponent.getDragData",
                description:null
            },
            {
                ref:"method:ListGrid.willAcceptDrop",
                description:null
            }
        ]
    },
    "attr:ToolbarItem.buttons":{
        ref:"attr:ToolbarItem.buttons",
        defaultValue:"null",
        valueType:"Array of StatefulCanvas",
        deprecated:null,
        name:"buttons",
        flags:"IRW",
        description:"List of buttons for the toolbar.\n  Each buttons should be specified as a simple JS object with properties to apply to the\n  button to be displayed. Note that any <code>click</code> stringMethod applied to the\n  button will be passed 2 parameters: <code>form</code> and <code>item</code>.",
        groups:[
            "items"
        ],
        definingClass:"class:ToolbarItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DetailViewerField.name":{
        ref:"attr:DetailViewerField.name",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"name",
        flags:"IR",
        description:"Name property used to identify the field, and determines which attribute from\n records will be displayed in this field.\n <P>\n Must be unique within the DetailViewer as well as a valid JavaScript identifier,\n as specified by ECMA-262 Section 7.6 (the ${isc.DocUtils.linkForRef('classMethod:String.isValidID')}\n  function can be used to test whether\n a name is a valid JavaScript identifier).\n <P>\n The attribute of the records to display in this field may also be set by\n ${isc.DocUtils.linkForRef('attr:DetailViewerField.displayField')}.",
        definingClass:"object:DetailViewerField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.wrap":{
        ref:"attr:ListGridField.wrap",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"wrap",
        flags:"IRW",
        description:"Should the field title wrap if there is not enough space horizontally to accommodate it.\n If unset, default behavior is derived from ${isc.DocUtils.linkForRef('attr:ListGrid.wrapHeaderTitles')}.  (This is a\n soft-wrap - if set the title will wrap at word boundaries.)\n <P>\n <b>Notes:</b><ul>\n <li>If autofitting is active, ${isc.DocUtils.linkForRef('attr:ListGridField.width')} and ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')} can be set\n to control the minimum field width - see the links for details.\n <li>This feature is incompatible with ${isc.DocUtils.linkForRef('attr:ListGrid.clipHeaderTitles')}, and\n <code>clipHeaderTitles</code> will be disabled for wrapping fields.</ul>",
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.sortEditorSpanTitleSeparator":{
        ref:"attr:ListGrid.sortEditorSpanTitleSeparator",
        defaultValue:"\" - \"",
        valueType:"String",
        deprecated:null,
        name:"sortEditorSpanTitleSeparator",
        flags:"IRW",
        description:"If this grid has specified ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')}, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderSpanTitlesInSortEditor','showHeaderSpanTitlesInSortEditor')} is true, this\n string will be inserted between the headerSpan title(s) and the field title in the field\n chooser grid on the ${isc.DocUtils.linkForRef('class:MultiSortDialog','multi-sort editor')}",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CubeGrid.colHeaderBaseStyle":{
        ref:"attr:CubeGrid.colHeaderBaseStyle",
        defaultValue:"colHeader",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"colHeaderBaseStyle",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('attr:Button.baseStyle','baseStyle')} for the buttons in this grid's column headers.\n <P>\n Exception: The innermost column\n header will always be styled using ${isc.DocUtils.linkForRef('attr:CubeGrid.innerHeaderBaseStyle')}.",
        groups:[
            "appearance"
        ],
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:access":{
        ref:"group:access",
        refs:[
            "method:ResultSet.getLength",
            "method:ResultSet.indexOf",
            "method:ResultSet.get",
            "method:ResultSet.getRange",
            "method:ResultSet.findAll",
            "method:ResultSet.find",
            "method:ResultSet.findIndex",
            "method:ResultSet.findNextIndex",
            "method:List.get",
            "method:List.getLength",
            "method:List.isEmpty",
            "method:List.first",
            "method:List.last",
            "method:List.indexOf",
            "method:List.lastIndexOf",
            "method:List.findIndex",
            "method:List.findNextIndex",
            "method:List.find",
            "method:List.findAll",
            "method:List.contains",
            "method:List.containsAll",
            "method:List.equals",
            "method:List.getItems",
            "method:List.getRange",
            "method:List.duplicate",
            "method:Tree.indexOf",
            "method:Tree.lastIndexOf",
            "method:Array.get",
            "method:Array.getLength",
            "method:Array.isEmpty",
            "method:Array.first",
            "method:Array.last",
            "method:Array.indexOf",
            "method:Array.lastIndexOf",
            "method:Array.contains",
            "method:Array.containsAll",
            "method:Array.equals",
            "method:Array.getItems",
            "method:Array.getRange",
            "method:Array.duplicate",
            "method:Array.findIndex",
            "method:Array.findNextIndex",
            "method:Array.find",
            "method:Array.findAll"
        ],
        deprecated:null,
        name:"access",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "method:PortalLayout.setCanResizeRows":{
        ref:"method:PortalLayout.setCanResizeRows",
        deprecated:"Use ${isc.DocUtils.linkForRef('method:PortalLayout.setCanResizePortlets','setCanResizePortlets()')} instead.",
        name:"setCanResizeRows",
        flags:"",
        description:" Set whether vertical drag-resize of portlets within columns is allowed, and\n update any drawn columns to reflect this.\n",
        definingClass:"class:PortalLayout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"canResize",
                description:"Whether drag-resize of portlets within columns is allowed",
                optional:false,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataSource.cacheData":{
        getter:[
            "getCacheData"
        ],
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"For a ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')} or client-only DataSource, a set of records to use as a dataset, \n specified as an Array of JavaScript Objects representing records.",
        groups:[
            "clientData"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DataSource.cacheData",
        valueType:"Array of Record",
        name:"cacheData",
        definingClass:"class:DataSource",
        setter:[
            "setCacheData"
        ]
    },
    "method:ListGrid.getFieldState":{
        ref:"method:ListGrid.getFieldState",
        deprecated:null,
        name:"getFieldState",
        flags:"",
        description:" Returns a snapshot of the current presentation of this listGrid's fields as\n a ${isc.DocUtils.linkForRef('type:ListGridFieldState')} object.\n <P>\n This object can later be passed to ${isc.DocUtils.linkForRef('method:ListGrid.setFieldState')} to reset this grid's\n fields to the current state.\n <P>\n Note that the information stored includes the current width and visibility of each of this\n grid's fields, as well as any ${isc.DocUtils.linkForRef('attr:ListGrid.canAddFormulaFields','formula')} or\n ${isc.DocUtils.linkForRef('attr:ListGrid.canAddSummaryFields','summary fields')} added by the user.\n\n",
        groups:[
            "viewState"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"current state of this grid's fields.",
            type:"ListGridFieldState"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:ListGrid.setFieldState",
                description:null
            }
        ]
    },
    "method:HiliteRule.remove":{
        ref:"method:HiliteRule.remove",
        deprecated:null,
        name:"remove",
        flags:"",
        description:" Remove this HiliteRule.  Default implementation calls markForDestroy(). \n\n",
        definingClass:"class:HiliteRule",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:FormulaBuilder.sampleHeaderTitle":{
        ref:"attr:FormulaBuilder.sampleHeaderTitle",
        defaultValue:"\"Sample:\"",
        valueType:"string",
        deprecated:null,
        name:"sampleHeaderTitle",
        flags:"IRWA",
        description:"The default title for the \"Sample\" panel, which displays a sample result for the formula.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FormulaBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RPCRequest.downloadToNewWindow":{
        ref:"attr:RPCRequest.downloadToNewWindow",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"downloadToNewWindow",
        flags:"IRWA",
        description:"When ${isc.DocUtils.linkForRef('attr:RPCRequest.downloadResult','downloadResult')} is true, setting this attribute to\n true causes the content of the downloaded file to be displayed in a new browser window.",
        definingClass:"class:RPCRequest",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:MultipleAppearance":{
        ref:"type:MultipleAppearance",
        values:[
            {
                description:"a drop-down picklist that allows multiple choices by              clicking on a checkbox next to each item",
                value:"\"picklist\""
            },
            {
                description:"a grid that displays all items in-place. Multiple selection is               accomplished by ctrl-click or shift-click.",
                value:"\"grid\""
            }
        ],
        deprecated:null,
        name:"MultipleAppearance",
        description:"Appearance for a SelectItem that allows multiple selection",
        type:"type",
        seeAlso:[
        ]
    },
    "classMethod:Class.addClassProperties":{
        ref:"classMethod:Class.addClassProperties",
        deprecated:null,
        name:"addClassProperties",
        flags:"",
        description:"\n\tAdd static (Class-level) properties and methods to this object<br><br>\n\n\tThese properties can then be accessed as MyClass.property, or for functions, called as\n  MyClass.methodName()\n\n",
        definingClass:"class:Class",
        returns:{
            description:"the class after properties have been added to it",
            type:"object"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"arguments 0-N",
                description:"objects with properties to add (think named parameters).\t\t\t\t\t\t\t\t\t\tall the properties of each argument will be applied\n\t\t\t\t\t\t\t\t\t\tas class-level properties.",
                optional:true,
                type:"object"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:HTMLFlow.dynamicContents":{
        defaultValue:"false",
        deprecated:null,
        flags:"IRWA",
        description:"Dynamic contents allows the contents string to be treated as a simple, but powerful\n template.  When this attribute is set to true, expressions of the form &#36;{arbitrary JS\n here} are replaced by the result of the evaluation of the JS code inside the curly\n brackets.  This evaluation happens at draw time.  If you want to trigger a re-evaluation\n of the expressions in the contents string you can call markForRedraw() on the canvas.\n <p>\n You can use this feature to build some simple custom components. For example, let's say\n you want to show the value of a Slider in a Canvas somewhere on the screen.  You can do\n this by observing the valueChanged() method on the slider and calling setContents() on\n your canvas with the new string or you can set the contents of the canvas to something\n like:\n <p><code>\n \"The slider value is &#36;{sliderInstance.getValue()}.\"\n </code><p>\n Next you set dynamicContents: true on the canvas, observe valueChanged() on the slider\n and call canvas.markForRedraw() in that observation.  This approach is cleaner than\n setContents() when the Canvas is aggregating several values or dynamic expressions.\n Like so:\n <p>\n <pre>\n Slider.create({\n     ID: \"mySlider\"\n });\n\n Canvas.create({\n     ID: \"myCanvas\",\n     dynamicContents: true,\n     contents: \"The slider value is &#36;{mySlider.getValue()}.\"\n });\n\n myCanvas.observe(mySlider, \"valueChanged\",\n                  \"observer.markForRedraw()\");\n </pre>\n You can embed an arbitrary number of dynamic expressions in the contents string.  The\n search and replace is optimized for speed.\n <p>\n If an error occurs during the evaluation of one of the expressions, a warning is logged\n to the ISC Developer Console and the error string is embedded in place of the expected\n value in the Canvas.\n <p>\n The value of a function is its return value.  The value of any variable is the same as\n that returned by its toString() representation.\n <p>\n Inside the evaluation contentext, <code>this</code> points to the canvas instance that\n has the dynamicContents string as its contents - in other words the canvas instance on\n which the template is declared.",
        groups:[
            "contents"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:HTMLFlow.contents",
                description:null
            },
            {
                ref:"attr:Canvas.dynamicContentsVars",
                description:null
            }
        ],
        ref:"attr:HTMLFlow.dynamicContents",
        examples:[
            "${isc.DocUtils.linkForExampleId('dynamicContents')}"
        ],
        valueType:"Boolean",
        name:"dynamicContents",
        definingClass:"class:HTMLFlow"
    },
    "attr:CheckboxItem.partialSelectedDescription":{
        ref:"attr:CheckboxItem.partialSelectedDescription",
        defaultValue:"\"partially selected\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"partialSelectedDescription",
        flags:"IRA",
        description:"The description shown in a hover when ${isc.DocUtils.linkForRef('attr:FormItem.showOldValueInHover')} is enabled\n and a value represents the partial selected state.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:CheckboxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.clearEditValue":{
        ref:"method:CubeGrid.clearEditValue",
        deprecated:null,
        name:"clearEditValue",
        flags:"A",
        description:"\n  Clear a field value being tracked as an unsaved user edit for some cell.<P>\n  The saved record value will be displayed in the the appropriate cell instead.\n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:CubeGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"editValuesID",
                description:"Row number, primary keys object for the record,                                              or editValues object",
                optional:false,
                type:"number | object"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"Column number for the cell in question. Only required if the                              first parameter is a row number.",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "method:EditTree.serializeAllEditNodes":{
        ref:"method:EditTree.serializeAllEditNodes",
        deprecated:null,
        name:"serializeAllEditNodes",
        flags:"",
        description:" Serialize the tree of ${isc.DocUtils.linkForRef('object:EditNode','EditNodes')} to an XML representation\n of ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')}. The result can be supplied to \n ${isc.DocUtils.linkForRef('method:EditTree.addPaletteNodesFromXML','addPaletteNodesFromXML()')} to recreate\n the EditNodes.\n\n",
        definingClass:"class:EditTree",
        returns:{
            description:"an XML representation of PaletteNodes which can be used to                  recreate the tree of EditNodes.",
            type:"String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"settings",
                description:"Additional serialization settings",
                optional:true,
                type:"SerializationSettings"
            }
        ],
        seeAlso:[
            {
                ref:"method:EditTree.addPaletteNodesFromXML",
                description:null
            }
        ]
    },
    "method:FilterBuilder.getCriteria":{
        ref:"method:FilterBuilder.getCriteria",
        deprecated:null,
        name:"getCriteria",
        flags:"",
        description:" Get the criteria entered by the user.\n \n",
        definingClass:"class:FilterBuilder",
        returns:{
            description:null,
            type:"AdvancedCriteria"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"includeEmptyValues",
                description:"By default if a user has selected a field and operator   type, but has failed to enter a value for the field it will be skipped. This optional parameter\n   allows you to retrieve all criteria, including those with an empty <code>value</code> attribute.",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.expansionComponentPoolingMode":{
        ref:"attr:ListGrid.expansionComponentPoolingMode",
        defaultValue:"\"destroy\"",
        valueType:"ExpansionComponentPoolingMode",
        deprecated:null,
        name:"expansionComponentPoolingMode",
        flags:"IRWA",
        description:"The method of ${isc.DocUtils.linkForRef('type:RecordComponentPoolingMode','component-pooling')} to employ for\n ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords','expansionComponents')}.\n <P>\n The default mode is \"destroy\", which means that automatically created expansionComponents\n are destroyed when rows are collapsed.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawPath.points":{
        ref:"attr:DrawPath.points",
        defaultValue:"[[0,0], [100,100]]",
        valueType:"Array of Point",
        deprecated:null,
        name:"points",
        flags:"IRW",
        description:"Array of Points for the line, specified in the ${isc.DocUtils.linkForRef('class:DrawPane','local coordinate system')}.",
        definingClass:"class:DrawPath",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:EventCanvas.event":{
        ref:"attr:EventCanvas.event",
        defaultValue:"null",
        valueType:"CalendarEvent",
        deprecated:null,
        name:"event",
        flags:"IR",
        description:"The ${isc.DocUtils.linkForRef('object:CalendarEvent','event')} associated with this EventCanvas.",
        definingClass:"class:EventCanvas",
        type:"attr",
        setter:[
            "setEvent"
        ],
        seeAlso:[
        ]
    },
    "method:TileLayout.setTilesPerLine":{
        ref:"method:TileLayout.setTilesPerLine",
        deprecated:null,
        name:"setTilesPerLine",
        flags:"",
        description:" Sets the number of tiles per line.\n",
        groups:[
            "tileLayout"
        ],
        definingClass:"class:TileLayout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"tilesPerLine",
                description:"New ${isc.DocUtils.linkForRef('attr:TileLayout.tilesPerLine')} value",
                optional:false,
                type:"Integer"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Toolbar.addButtons":{
        ref:"method:Toolbar.addButtons",
        deprecated:null,
        name:"addButtons",
        flags:"",
        description:" Add a list of buttons to the toolbar\n",
        definingClass:"class:Toolbar",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"buttons",
                description:"list of button object initializers.",
                optional:true,
                type:"Array of objects"
            },
            {
                defaultValue:null,
                name:"position",
                description:"position to add the new buttons at",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:VisualBuilder.loadFileBuiltinIsEnabled":{
        ref:"attr:VisualBuilder.loadFileBuiltinIsEnabled",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"loadFileBuiltinIsEnabled",
        flags:"IR",
        description:"If set to true the built-in load file mechanism is enabled, allowing you to load files from\n offline storage or the server filesystem (if enabled)",
        definingClass:"class:VisualBuilder",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:VisualBuilder.filesystemDataSourceEnabled",
                description:null
            }
        ]
    },
    "attr:MiniDateRangeItem.shouldSaveValue":{
        ref:"attr:MiniDateRangeItem.shouldSaveValue",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"shouldSaveValue",
        flags:"IR",
        description:"Allow miniDateRangeItems' values to show up in the form's values array, or if \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} is called, for the criterion to be included\n in the returned AdvancedCriteria object",
        definingClass:"class:MiniDateRangeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TabSet.tabForPane":{
        ref:"method:TabSet.tabForPane",
        deprecated:null,
        name:"tabForPane",
        flags:"",
        description:"Search for a tab that contains a pane.\n",
        definingClass:"class:TabSet",
        returns:{
            description:"tab that contains passed pane",
            type:"Tab"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"pane",
                description:"pane to show",
                optional:false,
                type:"Canvas"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Canvas.isGroup":{
        ref:"attr:Canvas.isGroup",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"isGroup",
        flags:"IR",
        description:"Should a grouping frame be shown around this canvas.",
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Canvas.groupBorderCSS",
                description:null
            },
            {
                ref:"attr:Canvas.groupLabelStyleName",
                description:null
            },
            {
                ref:"attr:Canvas.groupLabelBackgroundColor",
                description:null
            }
        ]
    },
    "classMethod:NumberUtil.toUSString":{
        ref:"classMethod:NumberUtil.toUSString",
        deprecated:null,
        name:"toUSString",
        flags:"",
        description:"  Format the passed number as a US string.  Returns empty string if not passed a number.\n\n",
        definingClass:"class:NumberUtil",
        returns:{
            description:"formatted number or empty string if not passed a number",
            type:"string"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"number",
                description:"the number object to format",
                optional:false,
                type:"Number"
            },
            {
                defaultValue:null,
                name:"decimalPrecision",
                description:null,
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:Time.parseInput":{
        ref:"classMethod:Time.parseInput",
        deprecated:null,
        name:"parseInput",
        flags:"",
        description:" Converts a time-string such as <code>1:00pm</code> to a new Date object \n representing a logical time value (rather than a specific datetime\n value), typically for display in a ${isc.DocUtils.linkForRef('attr:DataSourceField.type','time type field')}. \n Accepts most formats of time string. The generated\n Date value will have year, month and date set to the epoch date (Jan 1 1970), and time \n elements set to the supplied hour, minute and second (in browser native local time).\n <P>\n See ${isc.DocUtils.linkForRef('group:dateFormatAndStorage')} for more information on date, time and datetime \n values in SmartClient.\n\n",
        definingClass:"class:Time",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"timeString",
                description:"time string to convert to a date",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"validTime",
                description:"If this method is passed a timeString in an unrecognized format,  return null rather than a date object with time set to 00:00:00",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "method:FormItem.setReadOnlyDisplay":{
        ref:"method:FormItem.setReadOnlyDisplay",
        deprecated:null,
        name:"setReadOnlyDisplay",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:FormItem.readOnlyDisplay')}.\n",
        definingClass:"class:FormItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"appearance",
                description:"new <code>readOnlyDisplay</code> value.",
                optional:false,
                type:"ReadOnlyDisplayAppearance"
            }
        ],
        seeAlso:[
        ]
    },
    "method:TextItem.getSelectionRange":{
        ref:"method:TextItem.getSelectionRange",
        deprecated:null,
        name:"getSelectionRange",
        flags:"",
        description:" For text-based items, this method returns the indices of the start/end of the current\n selection if the item currently has the focus. In browsers other than Internet Explorer 6-9,\n if this item does not have focus, then this method returns the indices of the start/end\n of the selection the last time that this item had focus. In IE 6-9, returns null if the\n item does not have focus.\n <P>\n In all browsers, clicking anywhere outside of the item causes the item to lose focus;\n hence, in IE 6-9, this method will not work in other components' event handlers for\n certain events. For example, within the ${isc.DocUtils.linkForRef('method:Canvas.click','click()')} handler of a button,\n this item will have already lost focus, so in IE 6-9, this method will return null\n if called within the button's click() handler. One cross-browser solution to this issue\n is to save the selection range for later in a ${isc.DocUtils.linkForRef('method:Canvas.mouseDown','mouseDown()')} or\n ${isc.DocUtils.linkForRef('method:Canvas.mouseOver','mouseOver()')} handler.\n <P>\n Notes:\n <UL>\n   <LI>In browsers other than IE 6-9, calling ${isc.DocUtils.linkForRef('method:FormItem.setValue','setValue()')}\n or otherwise changing the ${isc.DocUtils.linkForRef('method:TextItem.getEnteredValue','entered value')} invalidates the past\n selection range.</LI>\n   <LI>The returned indices are indices within the entered value rather than the item's\n value as returned by ${isc.DocUtils.linkForRef('method:FormItem.getValue','getValue()')}.\n The distinction is particularly important for ${isc.DocUtils.linkForRef('class:TextAreaItem')}s because browsers\n normalize the line endings in the <code>&lt;textarea&gt;</code> element's value.\n Internet Explorer 6, 7, and 8 convert line endings to \"\\r\\n\" while other browsers\n convert line endings to \"\\n\"\n <a href='http://www.w3.org/TR/html5/forms.html#concept-textarea-api-value' target='_blank'>as specified by the HTML5 standard</a>.</LI>\n </UL>\n",
        definingClass:"class:TextItem",
        returns:{
            description:"2 element array showing character index of the current or past selection's start and end points within this item's ${isc.DocUtils.linkForRef('method:TextItem.getEnteredValue','entered value')}.\n In IE 6-9, returns null if the item does not have focus.",
            type:"Array of int"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "classMethod:DateUtil.getDisplayMinutes":{
        ref:"classMethod:DateUtil.getDisplayMinutes",
        deprecated:null,
        name:"getDisplayMinutes",
        flags:"",
        description:" Returns the minutes value from the passed datetime, as it will be displayed to the user.  \n This might not be the same value as that returned by getMinutes() if a \n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','custom timezone')} \n has been applied.  Only necessary for datetimes - for logical dates and times, this\n method returns the same value as getMinutes().\n",
        definingClass:"class:DateUtil",
        returns:{
            description:"the minutes value from the passed datetime",
            type:"int"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"datetime",
                description:"datetime instance to work with",
                optional:false,
                type:"Date"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.sorterConstructor":{
        ref:"attr:ListGrid.sorterConstructor",
        defaultValue:"Button",
        valueType:"Class",
        deprecated:null,
        name:"sorterConstructor",
        flags:"IR",
        description:"Widget class for the corner sort button, if showing.  This button displays the current\n sort direction of the primary sort field (either the only sorted field or the first in a\n ${isc.DocUtils.linkForRef('attr:ListGrid.canMultiSort','multi-sort')} grid) and reverses the direction of that field\n when clicked.  For consistent appearance, this\n is usually set to match ${isc.DocUtils.linkForRef('attr:ListGrid.headerButtonConstructor')}",
        groups:[
            "gridHeader",
            "appearance"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.headerHoverVAlign":{
        ref:"attr:ListGrid.headerHoverVAlign",
        defaultValue:"null",
        valueType:"VerticalAlignment",
        deprecated:null,
        name:"headerHoverVAlign",
        flags:"IRW",
        description:"This property may be set to customize the vertical alignment for the\n hover shown on ${isc.DocUtils.linkForRef('method:ListGrid.headerHover')}.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Button.action":{
        ref:"method:Button.action",
        deprecated:null,
        name:"action",
        flags:"",
        description:" This property contains the default 'action' for the Button to fire when activated.\n",
        definingClass:"class:Button",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGridRecord._canEdit":{
        ref:"attr:ListGridRecord._canEdit",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"_canEdit",
        flags:"IR",
        description:"Default property name denoting whether this record can be edited. Property name may be\n modified for the grid via ${isc.DocUtils.linkForRef('attr:ListGrid.recordEditProperty')}.",
        groups:[
            "editing"
        ],
        definingClass:"object:ListGridRecord",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ImgSectionHeader.getSectionStack":{
        ref:"method:ImgSectionHeader.getSectionStack",
        deprecated:null,
        name:"getSectionStack",
        flags:"",
        description:" For a SectionHeader embedded in a SectionStack, this method will return \n a pointer to the ${isc.DocUtils.linkForRef('class:SectionStack')} in which this section header is\n embedded.\n",
        definingClass:"class:ImgSectionHeader",
        returns:{
            description:"Section Stack containing this section header",
            type:"SectionStack"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:ListGrid.editFailed":{
        ref:"method:ListGrid.editFailed",
        deprecated:null,
        name:"editFailed",
        flags:"",
        description:" Called when an attempt to save inline edits fails, due to a validation error or other\n server error.\n <P>\n The default implementation of editFailed does nothing for normal validation errors,\n which are displayed before editFailed() is called.  For any other errors, the default\n implementation will call ${isc.DocUtils.linkForRef('classMethod:RPCManager.handleError')}, which by default\n will result in a warning dialog.\n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"current index of the row we attempted to save",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"index of the column where the edit failed, if applicable",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"newValues",
                description:"new values that we attempted to save",
                optional:false,
                type:"Object | Record"
            },
            {
                defaultValue:null,
                name:"oldValues",
                description:"the complete original values from before the save occurred",
                optional:false,
                type:"Record"
            },
            {
                defaultValue:null,
                name:"editCompletionEvent",
                description:"Edit completion event that led to the save                                                  attempt",
                optional:false,
                type:"editCompletionEvent"
            },
            {
                defaultValue:null,
                name:"dsResponse",
                description:"DSResponse, for saves through a DataSource",
                optional:true,
                type:"DSResponse"
            }
        ],
        seeAlso:[
        ]
    },
    "group:unsavedRecords":{
        ref:"group:unsavedRecords",
        refs:[
        ],
        deprecated:null,
        name:"unsavedRecords",
        description:"APIs such as ${isc.DocUtils.linkForRef('method:ListGrid.startEditingNew','startEditingNew()')} or\n ${isc.DocUtils.linkForRef('attr:ListGrid.listEndEditAction','listEndEditAction:\"next\"')} allow editing records that have not\n been saved to the server.  These unsaved records are special in several ways:\n <ul>\n <li> there is no actual Record object in the dataset for them: <code>getRecord(rowNum)</code>\n will return null, instead, <code>getEditValues(rowNum)</code> allows access to field values for\n the unsaved record\n <li> rows for editing these records always appear at the end of the grid and do not sort with\n other rows\n <li> because unsaved records lack an actual Record object and lack a\n ${isc.DocUtils.linkForRef('attr:DataSourceField.primaryKey')} value, they have limited functionality: they cannot be\n selected, and do not support ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents')} and certain other features.\n </ul>\n <P>\n If you need to work with unsaved records and have all ListGrid features apply to them, this is\n usually a sign that you should re-think your UI for adding new records.  Consider the following\n approaches - which works best will depend on the application:\n <ul>\n <li> actually save a new record to persistent storage, then start editing it.  This has the\n advantage that the user will never lose data by exiting the application with unsaved\n records, which can be important if there is a lot of data entry before the record is ready to\n save (for example, a new issue report in an issue-tracking applications, or a new blog entry).\n This is also a good approach if the user may want to get a unique ID for the new record\n right away (again useful for a new issue report or blog entry).\n <P>\n If values for several fields are required before the record should be visible on other screens\n or to other users, you can add a field to the record to flag it as incomplete so that it is not\n shown on other screens.  Alternatively, require certain fields to be entered via an external\n form or dialog before the record is added to the grid.\n <P>\n Saving a new record and editing it can be done via ${isc.DocUtils.linkForRef('method:DataSource.addData')} followed by a call to\n ${isc.DocUtils.linkForRef('method:ListGrid.startEditing')} once the record has been saved.\n <li> edit new records via a separate ${isc.DocUtils.linkForRef('class:DynamicForm','form')} instead, possibly in a modal\n ${isc.DocUtils.linkForRef('class:Window')} - then unsaved records never need to be shown in the grid.  Similar to the\n approach above, this modal form might have only certain minimum fields to make a valid\n new record, then further editing could continue in the grid.\n <li> use a ${isc.DocUtils.linkForRef('attr:DataSource.clientOnly','clientOnly DataSource')} so that records can be saved\n immediately without contacting the server.  This is a good approach if several unsaved records\n need to be manipulated by multiple components before they are finally saved.\n <li> use ${isc.DocUtils.linkForRef('method:DataSource.updateCaches')} with an \"add\" DSResponse to cause a new record to be\n added to the grid due to ${isc.DocUtils.linkForRef('class:ResultSet','automatic cache synchronization')}.  At this point the\n grid will believe the record exists on the server and it will be treated like any other saved\n record.  This means your server code will need to handle the fact that the ListGrid will submit\n \"update\" DSRequests for any subsequent edits.\n </ul>\n <b>NOTE about validation:</b> by design, SmartClient assumes that any record that has been\n saved is valid and does not validate field values that appear in records loaded from the\n server.  This includes records added to a clientOnly DataSource via\n ${isc.DocUtils.linkForRef('method:DataSource.setCacheData')} as well as records added due to a call to\n ${isc.DocUtils.linkForRef('method:DataSource.updateCaches')}.\n <P>\n Usually the best approach is to avoid this situation by editing such records in a form or other\n control until they are valid rather than showing invalid records in a grid.  However, if such\n records need to be considered invalid, one approach is to take field values and add them as\n editValues via ${isc.DocUtils.linkForRef('method:ListGrid.setEditValues')}.  At this point the ListGrid will consider the\n values as user edits and will validate them.",
        type:"group",
        title:"Handling Unsaved Records",
        seeAlso:[
        ]
    },
    "attr:ColorPicker.modeToggleButton":{
        ref:"attr:ColorPicker.modeToggleButton",
        defaultValue:"null",
        valueType:"AutoChild IButton",
        deprecated:null,
        name:"modeToggleButton",
        flags:"R",
        description:"\"More\"/\"Less\" button for the ColorPicker",
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:IPickTreeItem":{
        classAttrs:[
        ],
        ref:"class:IPickTreeItem",
        methods:[
        ],
        deprecated:null,
        name:"IPickTreeItem",
        description:"Subclass of ${isc.DocUtils.linkForRef('class:PickTreeItem')} which shows an ${isc.DocUtils.linkForRef('class:IMenuButton')} rather than a\n simple ${isc.DocUtils.linkForRef('class:MenuButton')} as it's main button.",
        treeLocation:[
            "Client Reference/Forms/Form Items"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:IPickTreeItem.button"
        ]
    },
    "attr:TabSet.editProxyConstructor":{
        ref:"attr:TabSet.editProxyConstructor",
        defaultValue:"\"TabSetEditProxy\"",
        valueType:"SCClassName",
        deprecated:null,
        name:"editProxyConstructor",
        flags:"IR",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        definingClass:"class:TabSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.valueProperty":{
        ref:"attr:FacetChart.valueProperty",
        defaultValue:"\"_value\"",
        valueType:"String",
        deprecated:null,
        name:"valueProperty",
        flags:"IR",
        description:"Property in each record that holds a data value.\n <P>\n Not used if there is an inline facet, see ${isc.DocUtils.linkForRef('attr:Chart.data')}.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SectionStack.useGlobalSectionIDs":{
        ref:"attr:SectionStack.useGlobalSectionIDs",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"useGlobalSectionIDs",
        flags:"IR",
        description:"Should any specified ${isc.DocUtils.linkForRef('attr:SectionStackSection.ID')} be applied to the generated SectionHeader widget\n for the section as a widget ID? If set to false, SectionStackSection.ID will behave as a synonym for\n SectionStackSection.name.",
        definingClass:"class:SectionStack",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:GridRenderer.rowClick":{
        ref:"method:GridRenderer.rowClick",
        deprecated:null,
        name:"rowClick",
        flags:"A",
        description:" Called when a row receives a click event.\n\n",
        groups:[
            "events"
        ],
        definingClass:"class:GridRenderer",
        returns:{
            description:"whether to cancel the event",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"record",
                description:"Record object returned from getCellRecord()",
                optional:false,
                type:"ListGridRecord"
            },
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number for the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of the cell",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DrawLine.knobs":{
        ref:"attr:DrawLine.knobs",
        examples:[
            "${isc.DocUtils.linkForExampleId('editDrawPane')}",
            "${isc.DocUtils.linkForExampleId('drawKnobs')}"
        ],
        defaultValue:"null",
        valueType:"Array of KnobType",
        deprecated:null,
        name:"knobs",
        flags:"IR",
        description:"Array of control knobs to display for this item. Each ${isc.DocUtils.linkForRef('type:KnobType')} specified in this\n will turn on UI element(s) allowing the user to manipulate this DrawLine.  To update the\n set of knobs at runtime use ${isc.DocUtils.linkForRef('method:DrawItem.showKnobs')} and ${isc.DocUtils.linkForRef('method:DrawItem.hideKnobs')}.\n <p>\n DrawLine supports the\n \"startPoint\", \"endPoint\", and \"move\"\n \n knob types.",
        definingClass:"class:DrawLine",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ColorPicker.setBlue":{
        ref:"method:ColorPicker.setBlue",
        deprecated:null,
        name:"setBlue",
        flags:"",
        description:" Sets the Blue element of the selected color\n",
        definingClass:"class:ColorPicker",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newValue",
                description:"An integer between 0 and 255",
                optional:false,
                type:"Number"
            }
        ],
        seeAlso:[
            {
                ref:"method:ColorPicker.getBlue",
                description:null
            }
        ]
    },
    "attr:CanvasItem.canvasConstructor":{
        ref:"attr:CanvasItem.canvasConstructor",
        defaultValue:"\"Canvas\"",
        valueType:"String",
        deprecated:null,
        name:"canvasConstructor",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:CanvasItem.canvas','this.canvas')} is not specified as a canvas instance at init\n time, a canvas will be created instead. This property denotes the class of that widget\n (Should be set to the name of a subclass of Canvas).",
        definingClass:"class:CanvasItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.xAxisEndValue":{
        ref:"attr:MetricSettings.xAxisEndValue",
        defaultValue:"null",
        valueType:"Float",
        deprecated:null,
        name:"xAxisEndValue",
        flags:"IR",
        description:"Same as ${isc.DocUtils.linkForRef('attr:FacetChart.xAxisEndValue')} but affects only one metric.",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:DoubleItem":{
        classAttrs:[
        ],
        ref:"class:DoubleItem",
        methods:[
            "method:DoubleItem.getValueAsDouble"
        ],
        deprecated:null,
        name:"DoubleItem",
        description:"TextForm item for managing a text field that displays a decimal value.",
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ]
    },
    "attr:GridRenderer.totalRows":{
        ref:"attr:GridRenderer.totalRows",
        getter:[
            "getTotalRows"
        ],
        defaultValue:"0",
        valueType:"number",
        deprecated:null,
        name:"totalRows",
        flags:"IRW",
        description:"Total number of rows in the grid.<br><br>\n\n NOTE: in order to create a valid grid, you must either provide a totalRows value or implement\n getTotalRows()",
        definingClass:"class:GridRenderer",
        type:"attr",
        seeAlso:[
            {
                ref:"method:GridRenderer.getTotalRows",
                description:null
            }
        ]
    },
    "classMethod:Process.loadProcess":{
        ref:"classMethod:Process.loadProcess",
        deprecated:null,
        name:"loadProcess",
        flags:"",
        description:" Loads an XML process definition stored in XML from the server.\n <p>\n This method requires server-side support included in SmartClient Pro Edition or better.\n <p>\n Process files are stored as .proc.xml files in ${isc.DocUtils.linkForRef('group:componentXML','Component XML')}\n format, in the directory indicated by the <code>project.processes</code> setting in\n ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}\n (<code><i>webroot</i>/processes</code> by default).  To load a process\n saved in a file <i>processId</i>.proc.xml, pass just <i>processId</i> to this method.\n  \n",
        definingClass:"class:Process",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"processId",
                description:"process IDs to load",
                optional:false,
                type:"Identifier | Array of Identifier"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"called when the process is loaded with argument                            \"process\", the first process.  Other processes can be looked\n                            up via ${isc.DocUtils.linkForRef('classMethod:Process.getProcess')}.",
                optional:false,
                type:"ProcessCallback"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:isA.Instance":{
        ref:"classMethod:isA.Instance",
        deprecated:null,
        name:"Instance",
        flags:"",
        description:"\n\tIs <code>object</code> an instance of some class?\n\n",
        definingClass:"object:isA",
        returns:{
            description:"true == <code>object</code> is an instance of some class",
            type:"boolean"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"object",
                description:"object to test",
                optional:false,
                type:"object"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:OperationBinding.serverMethod":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"The name of the method to invoke on the ${isc.DocUtils.linkForRef('class:ServerObject')} for this operationBinding.\n <p>\n <b>NOTE:</b> If you have a ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','DataSource-level ServerObject')} and\n wish to override this operation so that it simply calls a different method on the same \n server object, it is sufficient to specify just this property on the operationBinding:\n there is no need to redefine the serverObject at the operationBinding level.",
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:OperationBinding.serverMethod",
        valueType:"string",
        name:"serverMethod",
        definingClass:"class:OperationBinding",
        requiresModules:[
            "SCServer"
        ]
    },
    "method:ListGrid.cancelEditing":{
        ref:"method:ListGrid.cancelEditing",
        deprecated:null,
        name:"cancelEditing",
        flags:"",
        description:"\n  Cancel the current edit without saving.\n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:DataBoundComponent.canAddSummaryFields":{
        ref:"attr:DataBoundComponent.canAddSummaryFields",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"canAddSummaryFields",
        flags:"IRW",
        description:"Adds an item to the header context menu allowing users to launch a dialog to define a new\n text field that can contain both user-defined text and the formatted values present in other \n fields, using the ${isc.DocUtils.linkForRef('class:SummaryBuilder')}.\n <P>\n User-added summary fields can be persisted via ${isc.DocUtils.linkForRef('method:ListGrid.getFieldState')} and \n ${isc.DocUtils.linkForRef('method:ListGrid.setFieldState')}.",
        groups:[
            "summaryFields"
        ],
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:PortalLayout.portletMinimized":{
        ref:"method:PortalLayout.portletMinimized",
        deprecated:null,
        name:"portletMinimized",
        flags:"",
        description:" Notification method called after a portlet has been minimized (whether by\n user action or programmatically).\n\n",
        definingClass:"class:PortalLayout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"portlet",
                description:"the Portlet which was minimized",
                optional:false,
                type:"Portlet"
            }
        ],
        seeAlso:[
            {
                ref:"method:PortalLayout.willMinimizePortlet",
                description:null
            }
        ]
    },
    "method:Canvas.getWidth":{
        ref:"method:Canvas.getWidth",
        deprecated:null,
        name:"getWidth",
        flags:"",
        description:" Return the width of this object, in pixels.\n",
        groups:[
            "sizing"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"width",
            type:"number"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "class:ImgSplitbar":{
        classAttrs:[
        ],
        ref:"class:ImgSplitbar",
        methods:[
        ],
        deprecated:null,
        name:"ImgSplitbar",
        description:"Resize bar for use in ${isc.DocUtils.linkForRef('attr:Layout.resizeBarClass','Layouts')}, based on the\n ${isc.DocUtils.linkForRef('class:Img')} class.  As with the ${isc.DocUtils.linkForRef('class:Splitbar')} class, \n widgets of this class can be displayed as a resize-bar for widgets \n in Layouts where showResizeBar is set to true. Provides a different appearance from\n the <code>Splitbar</code> class.\n <p>\n To specify the resizeBar class for some layout, use the ${isc.DocUtils.linkForRef('attr:Layout.resizeBarClass')}\n property.",
        treeLocation:[
            "Client Reference/Layout"
        ],
        type:"class",
        seeAlso:[
            {
                ref:"class:Layout",
                description:null
            },
            {
                ref:"class:Splitbar",
                description:null
            }
        ],
        classMethods:[
        ],
        attrs:[
            "attr:ImgSplitbar.target",
            "attr:ImgSplitbar.vertical",
            "attr:ImgSplitbar.canDrag",
            "attr:ImgSplitbar.canCollapse",
            "attr:ImgSplitbar.skinImgDir",
            "attr:ImgSplitbar.src",
            "attr:ImgSplitbar.hSrc",
            "attr:ImgSplitbar.vSrc"
        ]
    },
    "attr:TreeGrid.selectionProperty":{
        ref:"attr:TreeGrid.selectionProperty",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"selectionProperty",
        flags:"IRA",
        description:"If specified, the selection object for this list will use this property to mark records\n as selected.  In other words, if this attribute were set to <code>\"isSelected\"</code>\n any records in the listGrid data where <code>\"isSelected\"</code> is <code>true</code>\n will show up as selected in the grid. Similarly if records are selected within the grid\n after the grid has been created, this property will be set to true on the selected\n records.",
        groups:[
            "selection",
            "appearance"
        ],
        definingClass:"class:TreeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Canvas.setWidth":{
        ref:"method:Canvas.setWidth",
        deprecated:null,
        name:"setWidth",
        flags:"",
        description:" Resizes the widget horizontally to the specified width (moves the right side of the\n widget). The width parameter can be expressed as a percentage of viewport size or as\n the number of pixels.\n <P>\n NOTE: if you're setting multiple coordinates, use resizeTo() or setRect() instead\n\n",
        groups:[
            "sizing"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"width",
                description:"new width",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DrawItem.resizeTo":{
        ref:"method:DrawItem.resizeTo",
        deprecated:null,
        name:"resizeTo",
        flags:"",
        description:" Resize to the specified size\n",
        definingClass:"class:DrawItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"width",
                description:"new width",
                optional:false,
                type:"integer"
            },
            {
                defaultValue:null,
                name:"height",
                description:"new height",
                optional:false,
                type:"integer"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:Operators.iEndsWithTitle":{
        ref:"classAttr:Operators.iEndsWithTitle",
        defaultValue:"\"ends with\"",
        valueType:"String",
        deprecated:null,
        name:"iEndsWithTitle",
        flags:"IR",
        description:"Title for the \"iEndsWith\" operator",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Operators",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:SerializationSettings.indent":{
        ref:"attr:SerializationSettings.indent",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"indent",
        flags:"IR",
        description:"Overrides the default indention setting during serialization. XML defaults\n to indented and JSON defaults to non-indented.",
        definingClass:"object:SerializationSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tree.defaultNodeTitle":{
        ref:"attr:Tree.defaultNodeTitle",
        defaultValue:"\"Untitled\"",
        valueType:"string",
        deprecated:null,
        name:"defaultNodeTitle",
        flags:"IRW",
        description:"Title assigned to nodes without a ${isc.DocUtils.linkForRef('attr:Tree.titleProperty')} value or a\n ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} value.",
        definingClass:"class:Tree",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tab.disabled":{
        ref:"attr:Tab.disabled",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"disabled",
        flags:"IRW",
        description:"If specified, this tab will initially be rendered in a disabled state. To enable or\n disable tabs on the fly use the ${isc.DocUtils.linkForRef('method:TabSet.enableTab')}, and ${isc.DocUtils.linkForRef('method:TabSet.disableTab')}\n methods.",
        definingClass:"object:Tab",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Slider.maxValueLabel":{
        ref:"attr:Slider.maxValueLabel",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"maxValueLabel",
        flags:"IRW",
        description:"The text displayed in the label for the maximum value of the slider. If left as null, then\n slider.maxValue will be displayed.",
        definingClass:"class:Slider",
        type:"attr",
        setter:[
            "setMaxValueLabel"
        ],
        seeAlso:[
            {
                ref:"attr:Slider.showRange",
                description:null
            },
            {
                ref:"attr:Slider.maxValue",
                description:null
            }
        ]
    },
    "attr:PickListMenu.bodyStyleName":{
        ref:"attr:PickListMenu.bodyStyleName",
        defaultValue:"\"pickListMenuBody\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"bodyStyleName",
        flags:"IRW",
        description:"CSS style used for the body of this grid.  If applying a background-color to the body\n via a CSS style applied using this property, be sure to set\n ${isc.DocUtils.linkForRef('attr:ListGrid.bodyBackgroundColor')} to <code>null</code>.",
        groups:[
            "appearance"
        ],
        definingClass:"class:PickListMenu",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Menu.target":{
        ref:"attr:Menu.target",
        defaultValue:"null",
        valueType:"Canvas",
        deprecated:null,
        name:"target",
        flags:"IRW",
        description:"Optional target canvas for this menu.  Available as a parameter to dynamic menuItem configuration\n methods such as ${isc.DocUtils.linkForRef('method:MenuItem.checkIf')}.\n <P>\n Whenever a Menu is shown as a contextMenu by a widget due to ${isc.DocUtils.linkForRef('attr:Canvas.contextMenu')}\n being set, <code>menu.target</code> is automatically set to the widget that showed the\n contextMenu.\n <P>\n If this item has any ${isc.DocUtils.linkForRef('attr:MenuItem.submenu','submenus')} the <code>target</code> will be propagated down\n to these child menus.",
        definingClass:"class:Menu",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.setCanReorderRecords":{
        ref:"method:ListGrid.setCanReorderRecords",
        deprecated:null,
        name:"setCanReorderRecords",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:ListGrid.canReorderRecords')} attribute.\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"canReorderRecords",
                description:"new value for <code>this.canReorderRecords</code>",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:MultiGroupDialog.applyButtonTitle":{
        ref:"attr:MultiGroupDialog.applyButtonTitle",
        defaultValue:"\"Apply\"",
        valueType:"String",
        deprecated:null,
        name:"applyButtonTitle",
        flags:"IR",
        description:"The title-text to appear on the applyButton",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiGroupDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataSource.getFieldNames":{
        ref:"method:DataSource.getFieldNames",
        deprecated:null,
        name:"getFieldNames",
        flags:"",
        description:" Retrieves the list of fields declared on this DataSource.\n\n",
        definingClass:"class:DataSource",
        returns:{
            description:"names of all fields declared on this DataSource",
            type:"Array of String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"excludeHidden",
                description:"If true, returns only those fields that are                                 not marked as hidden",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.data":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"A list of ListGridRecord objects, specifying the data to be used to populate the\n ListGrid.  In ListGrids, the data array specifies rows.\n <p>\n When using a ${isc.DocUtils.linkForRef('class:DataSource')}, rather than directly providing <code>data</code>, you will\n typically call ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} instead, which will automatically establish\n <code>data</code> as a ${isc.DocUtils.linkForRef('class:ResultSet','ResultSet')} (see the ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')} docs for details).\n <p>\n If you call <code>fetchData</code>, any previously supplied <code>data</code> is\n discarded.  Also, it is not necessary to call <code>setData()</code> after calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')}.\n <p>\n When calling <code>setData()</code>, direct changes\n to the list using Framework APIs such as ${isc.DocUtils.linkForRef('method:List.add')} or \n ${isc.DocUtils.linkForRef('method:List.remove')} will be automatically observed and the\n ListGrid will redraw in response.  However, direct changes to individual Records will not\n be automatically observed and require calls to ${isc.DocUtils.linkForRef('method:ListGrid.refreshCell')} or \n ${isc.DocUtils.linkForRef('method:ListGrid.refreshRow')} to cause the ListGrid to visually update.  Calling methods such as\n ${isc.DocUtils.linkForRef('method:ListGrid.updateData')}, ${isc.DocUtils.linkForRef('method:ListGrid.removeData')} or ${isc.DocUtils.linkForRef('method:ListGrid.addData')} always causes\n automatic visual refresh.\n <p>\n Note that direct manipulation of the data object without using the ${isc.DocUtils.linkForRef('interface:List')} APIs (for\n example by directly assigning a new Record object to some index or calling non-Framework\n APIs such as pop(), shift(), etc.) will not be reflected in the grid automatically, but \n developers can call ${isc.DocUtils.linkForRef('method:List.dataChanged')} directly to notify the grid of changes.\n ",
        groups:[
            "data"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"object:ListGridRecord",
                description:null
            }
        ],
        ref:"attr:ListGrid.data",
        examples:[
            "${isc.DocUtils.linkForExampleId('inlineData')}",
            "${isc.DocUtils.linkForExampleId('localData')}"
        ],
        valueType:"List of ListGridRecord",
        name:"data",
        definingClass:"class:ListGrid",
        setter:[
            "setData"
        ]
    },
    "attr:Calendar.canRemoveEvents":{
        ref:"attr:Calendar.canRemoveEvents",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"canRemoveEvents",
        flags:"IR",
        description:"If true, users can remove existing events. Defaults to ${isc.DocUtils.linkForRef('attr:Calendar.canEditEvents')}.",
        groups:[
            "allowedOperations"
        ],
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataBoundComponent.autoFetchData":{
        ref:"attr:DataBoundComponent.autoFetchData",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"autoFetchData",
        flags:"IR",
        description:"If true, when this component is first drawn, automatically call <code>this.fetchData()</code>.\n Criteria for this fetch may be picked up from ${isc.DocUtils.linkForRef('attr:DataBoundComponent.initialCriteria')}, and textMatchStyle may\n be specified via ${isc.DocUtils.linkForRef('attr:ListGrid.autoFetchTextMatchStyle','autoFetchTextMatchStyle')}.\n <P>\n <span style='color:red'>NOTE:</span> if <code>autoFetchData</code> is set, calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} before draw will cause two requests to be issued, one from the manual\n call to fetchData() and one from the autoFetchData setting.  The second request will use\n only ${isc.DocUtils.linkForRef('attr:DataBoundComponent.initialCriteria')} and not any other criteria or settings from the first request.\n Generally, turn off autoFetchData if you are going to manually call ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} at any time.",
        groups:[
            "dataBoundComponentMethods"
        ],
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
            {
                ref:"method:ListGrid.fetchData",
                description:null
            }
        ]
    },
    "method:ListGrid.setSortState":{
        ref:"method:ListGrid.setSortState",
        deprecated:null,
        name:"setSortState",
        flags:"",
        description:" Reset this grid's sort state (sort field and direction or list of\n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s) to match the\n ${isc.DocUtils.linkForRef('type:ListGridSortState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to\n ${isc.DocUtils.linkForRef('method:ListGrid.getSortState')}.\n\n",
        groups:[
            "viewState"
        ],
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"sortState",
                description:"Object describing the desired sort state for the grid.",
                optional:false,
                type:"ListGridSortState"
            }
        ],
        seeAlso:[
            {
                ref:"method:ListGrid.getSortState",
                description:null
            }
        ]
    },
    "attr:TreeGrid.dragDataAction":{
        ref:"attr:TreeGrid.dragDataAction",
        defaultValue:"ListGrid.MOVE",
        valueType:"DragDataAction",
        deprecated:null,
        name:"dragDataAction",
        flags:"IRWA",
        description:"Specifies what to do with data dragged from this TreeGrid (into another component, or\n another node in this TreeGrid.  The default action is to move the data.  A setting of\n \"none\" is not recommended for trees because Trees maintain the node open state on the nodes\n themselves, and hence having multiple Tree objects share a reference to a node can have\n unintended consequences (such as opening a folder in one tree also triggering an open in\n another tree that shares the same node).\n <br><br>\n For DataBound trees (${isc.DocUtils.linkForRef('class:ResultTree')}), the expectation is that\n ${isc.DocUtils.linkForRef('method:TreeGrid.folderDrop')} will be overridden to perform whatever action took\n place as the result of the drag and drop interaction.",
        definingClass:"class:TreeGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"group:sharingNodes",
                description:null
            }
        ]
    },
    "attr:EventCanvas.headerWrap":{
        ref:"attr:EventCanvas.headerWrap",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"headerWrap",
        flags:"IRW",
        description:"Whether the ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header area')} should autosize vertically to \n display all contents.  If true, the header will wrap to multiple lines.  If false, the\n header will be sized according to the specified ${isc.DocUtils.linkForRef('attr:EventCanvas.headerHeight','height')},\n or to the full height of the canvas is ${isc.DocUtils.linkForRef('attr:EventCanvas.showBody','showBody')} is false.",
        groups:[
            "appearance"
        ],
        definingClass:"class:EventCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:XMLTools.loadXMLSchema":{
        ref:"classMethod:XMLTools.loadXMLSchema",
        examples:[
            "${isc.DocUtils.linkForExampleId('xmlSchemaImport')}"
        ],
        deprecated:null,
        name:"loadXMLSchema",
        flags:"A",
        description:" Load an XML file containing XML schema definitions and create DataSource and SimpleType\n objects to represent the schema.  You can use to loaded schema to bind ISC components,\n perform validation, create editing interfaces, and build other metadata-driven interfaces.\n You can also use ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','schema inheritance')} to overlay\n presentation-specific data (such as user-visible titles) on top of XML Schema.\n <p>\n In the loaded XML Schema, all &lt;xsd:complexType&gt; declarations become SmartClient\n DataSources, and all &lt;xsd:simpleType&gt; definitions become SmartClient\n ${isc.DocUtils.linkForRef('class:SimpleType','atomic type definitions')}.  \n <p>\n By default, named complexType definitions and named element definitions containing\n complexTypes become global DataSources, that is, they can be fetched with\n ${isc.DocUtils.linkForRef('classMethod:DataSource.getDataSource')}.  Inline complexType definitions get\n automatically generated names.\n <p>\n Named simpleType declarations become global ${isc.DocUtils.linkForRef('class:SimpleType','atomic types')}, that is,\n subsequently defined DataSources can use them for ${isc.DocUtils.linkForRef('attr:DataSourceField.type')}.  XML\n schema \"restrictions\" for simple types are automatically translated to\n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueMap')} or ${isc.DocUtils.linkForRef('attr:DataSourceField.validators')} as\n appropriate.\n <P>\n The created SchemaSet object is available in the callback as the single parameter\n \"schemaSet\", or can retrieved via <code>SchemaSet.get(schemaNamespace)</code>.\n <P>\n NOTE: unless you are building an application that dynamically loads XML Schema \n without prior knowledge, instead of calling loadXMLSchema(), you should either:\n <ul>\n <li> use the ${isc.DocUtils.linkForRef('group:loadXMLSchemaTag')} tag to eliminate the need for an asynchronous\n download of an XML Schema file as part of application startup, <b>OR</b>\n <li> use the \"WSDL\" tab in the Developer Console to obtain the XML Schema definition as a\n JavaScript file that can be loaded via a normal HTML &lt;SCRIPT SRC=&gt; tag and/or\n combined with other JavaScript files.  \n </ul>\n <P>\n NOTE: required fields: the XML Schema concept of \"required\" for an attribute or subelement, \n expressed via use=\"required\" (for an attribute) or minOccurs > 0 (for a subelement), is\n that the attribute or element must be present in the XML document <i>but can have any\n value</i>, including being empty or null.  The SmartClient notion of required means\n non-null.  You can express the SmartClient notion of required in XML Schema with the\n combination of minOccurs>0 and a minLength or length \"restriction\", and SmartClient \n will recognize the field as SmartClient-required, with all of the behaviors that implies\n (eg, specially styled form titles, automatic validation, etc).\n\n",
        groups:[
            "xmlSchema"
        ],
        definingClass:"class:XMLTools",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"schemaURL",
                description:"URL to load the schema from",
                optional:false,
                type:"URL"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"signature is callback(schemaSet)",
                optional:false,
                type:"Callback"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"additional properties to set on the RPCRequest                                         that will be issued",
                optional:true,
                type:"RPCRequest"
            },
            {
                defaultValue:null,
                name:"autoLoadImports",
                description:"if set, xsd:import statements will be processed                                  automatically to load dependent XSD files where a\n                                  \"location\" is specified.  The callback will not fire until\n                                  all dependencies have been loaded",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:Log.setPriority":{
        ref:"classMethod:Log.setPriority",
        deprecated:null,
        name:"setPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for this log category.\n <P>\n After calling setPriority, any messages logged to the given category whose priority is\n below the specified priority will not appear in the Log.\n\n",
        definingClass:"class:Log",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"category",
                description:"category name",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"priority",
                description:"priority level to set",
                optional:false,
                type:"LogPriority"
            },
            {
                defaultValue:null,
                name:"object",
                description:"Optional ISC class or instance - if passed the priority will be set for logging \n      occurring on the class or instance only.",
                optional:true,
                type:"Class or Instance object"
            }
        ],
        seeAlso:[
            {
                ref:"classMethod:Log.isEnabledFor",
                description:"to check whether a category would allow a log at a given priority"
            }
        ]
    },
    "attr:DetailViewer.timeFormatter":{
        ref:"attr:DetailViewer.timeFormatter",
        defaultValue:"null",
        valueType:"TimeDisplayFormat",
        deprecated:null,
        name:"timeFormatter",
        flags:"IRW",
        description:"Display format to use for fields specified as type 'time'.  May also be specified at \n the field level via ${isc.DocUtils.linkForRef('attr:DetailViewerField.timeFormatter')}.<br>\n If unset, time fields will be formatted based on the system wide \n ${isc.DocUtils.linkForRef('classMethod:Time.setNormalDisplayFormat')}",
        groups:[
            "appearance"
        ],
        definingClass:"class:DetailViewer",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Splitbar.capSize":{
        ref:"attr:Splitbar.capSize",
        defaultValue:"null",
        valueType:"integer",
        deprecated:null,
        name:"capSize",
        flags:"IR",
        description:"If the default items are used, capSize is the size in pixels of the first and last\n          images in this stretchImg.",
        groups:[
            "appearance"
        ],
        definingClass:"class:Splitbar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DetailViewerField.imageHeight":{
        ref:"attr:DetailViewerField.imageHeight",
        defaultValue:"null",
        valueType:"Integer | String",
        deprecated:null,
        name:"imageHeight",
        flags:"IRW",
        description:"Height of image shown for fieldTypes image in this field.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n height.  For example, if <code>field.imageHeight</code> is \"logoHeight\",\n <code>record.logoHeight</code> will control the height of the image.",
        groups:[
            "imageColumns"
        ],
        definingClass:"object:DetailViewerField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DetailViewerField.imageSize",
                description:null
            },
            {
                ref:"attr:DetailViewerField.imageWidth",
                description:null
            }
        ]
    },
    "method:FilterClause.getCriterion":{
        ref:"method:FilterClause.getCriterion",
        deprecated:null,
        name:"getCriterion",
        flags:"",
        description:" Return the criterion specified by this FilterClause.\n \n",
        definingClass:"class:FilterClause",
        returns:{
            description:"The single criterion for this FilterClause",
            type:"Criteria"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:FiscalCalendar.defaultDate":{
        ref:"attr:FiscalCalendar.defaultDate",
        defaultValue:"null",
        valueType:"integer",
        deprecated:null,
        name:"defaultDate",
        flags:"IRW",
        description:"The default one-based day-number in the ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultMonth','specified month')}\n to use for calculating fiscal dates when no ${isc.DocUtils.linkForRef('attr:FiscalCalendar.fiscalYears','fiscal years')}\n are provided. This value together\n with ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultMonth')} will be used as the start date for the\n fiscal years where no explicitly specified fiscalYear configuration is present.\n <br>\n See also ${isc.DocUtils.linkForRef('attr:FiscalCalendar.defaultYearMode')}.",
        definingClass:"object:FiscalCalendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.useSubselectForRowCount":{
        serverDS:"only",
        ref:"attr:OperationBinding.useSubselectForRowCount",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"useSubselectForRowCount",
        flags:"IRW",
        description:"Whether to use the subselect technique (see ${isc.DocUtils.linkForRef('attr:DataSource.useSubselectForRowCount')} for\n details) to derive a rowcount query for this operation.  If this property is not\n set, we fall back to the <code>useSubselectForRowCount</code> setting on the DataSource, \n and the defaults described in the documentation for that property.",
        definingClass:"class:OperationBinding",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSource.useSubselectForRowCount",
                description:null
            },
            {
                ref:"attr:OperationBinding.customSQL",
                description:null
            }
        ]
    },
    "attr:CalendarEvent.headerTextColor":{
        ref:"attr:CalendarEvent.headerTextColor",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"headerTextColor",
        flags:"IRW",
        description:"An optional text color for the header portion of ${isc.DocUtils.linkForRef('class:EventCanvas','canvases')}\n representing this event in the various ${isc.DocUtils.linkForRef('class:CalendarView','calendar views')}.\n <P>\n Note that the recommended approach for styling events is to set a\n ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName','custom CSS style')}, which allows more complete customization\n of both header and body portions.",
        definingClass:"object:CalendarEvent",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ValuesManager.getErrors":{
        ref:"method:ValuesManager.getErrors",
        deprecated:null,
        name:"getErrors",
        flags:"",
        description:" Returns the set of errors for this valuesManager.\n Errors will be returned as an object of the format <br>\n <code>{field1:errors, field2:errors}</code><br>\n Where each errors object is either a single error message or an array of error message\n strings.\n",
        groups:[
            "errors"
        ],
        definingClass:"class:ValuesManager",
        returns:{
            description:"Object containing mapping from field names to error strings. Returns null                  if there are no errors for this valuesManager.",
            type:"object"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:Selection.isSelected":{
        ref:"method:Selection.isSelected",
        deprecated:null,
        name:"isSelected",
        flags:"",
        description:" Return true if a particular item is selected\n\n",
        groups:[
            "selection"
        ],
        definingClass:"class:Selection",
        returns:{
            description:"true == object is selected, false == object is not selected",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"item",
                description:"object to check",
                optional:false,
                type:"object"
            }
        ],
        seeAlso:[
        ]
    },
    "class:HLayout":{
        exampleConfig:"HLayout.xml",
        classAttrs:[
        ],
        methods:[
        ],
        deprecated:null,
        description:"A subclass of Layout that applies a sizing policy along the horizontal axis, interpreting\n  percent and \"*\" sizes as proportions of the width of the layout. HLayouts will set any members\n  that do not have explicit heights to match the layout.",
        treeLocation:[
            "Client Reference/Layout"
        ],
        type:"class",
        seeAlso:[
            {
                ref:"attr:Layout.hPolicy",
                description:null
            }
        ],
        classMethods:[
        ],
        attrs:[
        ],
        ref:"class:HLayout",
        name:"HLayout"
    },
    "attr:ListGridField.headerTitle":{
        ref:"attr:ListGridField.headerTitle",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"headerTitle",
        flags:"IR",
        description:"Optional title for the header button for this field. If specified this will be\n displayed in the header button instead of ${isc.DocUtils.linkForRef('attr:ListGridField.title')} or\n ${isc.DocUtils.linkForRef('attr:ListGridField.name')}. Set to an empty string to suppress the title in the\n header button entirely.",
        groups:[
            "appearance"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.title",
                description:null
            }
        ]
    },
    "attr:OperationBinding.progressiveLoading":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Sets ${isc.DocUtils.linkForRef('attr:DataSource.progressiveLoading','progressive loading mode')} for this particular \n operation, overriding the DataSource-level setting.  Note that this setting applies only\n to fetch operations - it has no effect if specified on any other kind of operation.",
        groups:[
            "progressiveLoading"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSource.progressiveLoading",
                description:null
            }
        ],
        ref:"attr:OperationBinding.progressiveLoading",
        valueType:"boolean",
        name:"progressiveLoading",
        definingClass:"class:OperationBinding"
    },
    "method:Canvas.layoutChildren":{
        ref:"method:Canvas.layoutChildren",
        deprecated:null,
        name:"layoutChildren",
        flags:"A",
        description:"\n <code>layoutChildren()</code> is where a Canvas should implement a sizing policy for it's\n Canvas children.  Since <code>layoutChildren</code> calls parentResized() on its children,\n ${isc.DocUtils.linkForRef('method:Canvas.parentResized')} is a good place for a child to implement a layout policy that\n can be used within any parent.\n <P>\n Recommended practice for a Canvas that manages Canvas children is to create those children\n without any initial coordinate or size settings and do all sizing when layoutChildren() is\n called.\n <P>\n layoutChildren() is always called at least once before children are drawn, and is called\n automatically whenever the viewport size changes (which includes both resizing and\n introduction/removal of scrolling).  layoutChildren() can also be manually invoked in any\n other component-specific situation which changes the layout.\n <P>\n NOTE: layoutChildren() may be called before draw() if a widget is resized before draw(), so\n be sure to avoid errors such as assuming that any children you automatically create have\n already been created.\n <P>\n NOTE: auto-sizing: layoutChildren() is also called once during the initial draw(), before\n children are drawn, with a \"reason\" of \"initial draw\".  During this invocation of\n layoutChildren() it is legal to directly draw children (call child.draw()), which is\n otherwise never allowed.  This allows a Canvas to implement an auto-sizing layout policy by\n drawing some children before deciding on the sizes of remaining children, which is far more\n efficient than drawing all children and resizing some of them after they are drawn.\n",
        groups:[
            "sizing"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"reason",
                description:"reason why layoutChildren() is being called, passed when framework                        code invokes layoutChildren()",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Canvas.pageScrollUp":{
        ref:"method:Canvas.pageScrollUp",
        deprecated:null,
        name:"pageScrollUp",
        flags:"",
        description:" This method is the programmatic equivalent of the user pressing the \"Page Up\" key while \n this widget has the focus.  It scrolls the widget's content upwards by the viewport \n height, if the content can be scrolled that far upwards\n",
        definingClass:"class:Canvas",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:DynamicForm.fields":{
        getter:[
            "getFields"
        ],
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"An array of field objects, specifying the order, layout, and types of each field in the\n DynamicForm.\n <p>\n When both <code>dynamicForm.fields</code> and <code>dynamicForm.dataSource</code> are\n set, <code>dynamicForm.fields</code> acts as a set of overrides as explained in\n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}.\n <P>\n See ${isc.DocUtils.linkForRef('group:formLayout','Form Layout')} for information about how flags specified on\n the FormItems control how the form is laid out.",
        groups:[
            "items"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"class:FormItem",
                description:null
            }
        ],
        ref:"attr:DynamicForm.fields",
        valueType:"Array of FormItem Properties",
        name:"fields",
        definingClass:"class:DynamicForm",
        setter:[
            "setFields"
        ]
    },
    "method:DataSource.hasFile":{
        ref:"method:DataSource.hasFile",
        deprecated:null,
        name:"hasFile",
        flags:"",
        description:"\n Indicates whether a file exists in this DataSource. \n\n",
        groups:[
            "fileSource"
        ],
        definingClass:"class:DataSource",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fileSpec",
                description:"Either a FileSpec, or a String which                 will be parsed to determine the fileName, fileType and fileFormat.\n                 For instance, \"employees.ds.xml\" would be parsed as\n                 {fileName: \"employees\", fileType: \"ds\", fileFormat: \"xml\"}.\n                 If fileType or fileFormat are not provided, will indicate whether\n                 any file with the provided fileName exists.",
                optional:false,
                type:"FileSpec | String"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"${isc.DocUtils.linkForRef('method:Callbacks.HasFileCallback','Callback')} executed with the results.                  The <code>data</code> parameter is a boolean indicating\n                 whether the file is present.\n                 You can examine <code>${isc.DocUtils.linkForRef('attr:DSResponse.status','dsResponse.status')}</code>\n                 and <code>${isc.DocUtils.linkForRef('attr:DSResponse.data','dsResponse.data')}</code>\n                 for additional information about any error.",
                optional:false,
                type:"HasFileCallback"
            }
        ],
        seeAlso:[
        ],
        requiresModules:[
            "SCServer"
        ]
    },
    "attr:CubeGrid.facetLabelHoverHeight":{
        ref:"attr:CubeGrid.facetLabelHoverHeight",
        defaultValue:"null",
        valueType:"measure",
        deprecated:null,
        name:"facetLabelHoverHeight",
        flags:"IRWA",
        description:"If specified and <code>this.showHover</code> is true, this is the default height to apply\n to hover tips shown for facetLabels. If unset, the hover canvas will be sized to \n <code>this.hoverHeight</code> if specified instead.",
        groups:[
            "hoverTips"
        ],
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Canvas.hoverHeight",
                description:null
            }
        ]
    },
    "attr:TestFunctionResult.result":{
        ref:"attr:TestFunctionResult.result",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"result",
        flags:"IRW",
        description:"When a formula or summary format is valid, <i>result</i> contains the result returned by the\n generated function when it was executed.",
        groups:[
            "formulaFields"
        ],
        definingClass:"object:TestFunctionResult",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MultiSortPanel.addLevelButton":{
        ref:"attr:MultiSortPanel.addLevelButton",
        defaultValue:"null",
        valueType:"AutoChild IButton",
        deprecated:null,
        name:"addLevelButton",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing a mechanism for adding new levels\n to the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.addLevelButtonProperties</code> and \n <code>multiSortPanel.addLevelButtonDefaults</code>.",
        definingClass:"class:MultiSortPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FieldPicker.showFieldOrderButtons":{
        ref:"attr:FieldPicker.showFieldOrderButtons",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"showFieldOrderButtons",
        flags:"IR",
        description:"When set to false, hides the right-most set of buttons, used for re-ordering fields in the\n Visible Fields list.",
        definingClass:"class:FieldPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.getSelectedFacetValues":{
        ref:"method:CubeGrid.getSelectedFacetValues",
        deprecated:null,
        name:"getSelectedFacetValues",
        flags:"",
        description:" Returns an array of facetValues objects indicating the headers that are selected in the\n headerBar for this facet.  If facetId is not passed, returns selection for all\n facets.\n\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CubeGrid",
        returns:{
            description:"selected facetValues",
            type:"Array of FacetValueMap"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetId",
                description:"id for facet for which we are getting selected facetValues",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataSourceField.importStrategy":{
        serverDS:"only",
        ref:"attr:DataSourceField.importStrategy",
        defaultValue:"null",
        valueType:"FieldImportStrategy",
        deprecated:null,
        name:"importStrategy",
        flags:"IR",
        description:"Declares the <code>FieldImportStrategy</code> for this field.  The default setting of null \n has the same meaning as \"auto\".  Note, this attribute only has an effect if all of the \n following are true:<ul>\n <li>The field declares a ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')}</li>\n <li>The field declares a ${isc.DocUtils.linkForRef('attr:DataSourceField.displayField','displayField')}</li>\n <li>The displayField so declared is ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom','included from')} the \n same DataSource that the <code>foreignKey</code> declaration refers to</li>\n </ul>\n In any other circumstances, this attribute is ignored.\n <p>\n <code>importStrategy</code> is applied by the server-side \n <code>DataImport.importToRows()</code> method, which is in turn used by\n ${isc.DocUtils.linkForRef('class:BatchUploader')} and several other DataImport APIs such as \n <code>importToDataSource()</code>, <code>importDataSourceRecords()</code> and \n <code>importAndValidateDSRows()</code>.  See the server-side documentation for\n details of these APIs.  The actual data transformation is carried out by the \n server-side API <code>DataSource.transformImportValue()</code>; this method can \n be overridden to carry out any other transformation you may require.",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SelectItem.defaultToFirstOption":{
        ref:"attr:SelectItem.defaultToFirstOption",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"defaultToFirstOption",
        flags:"IRW",
        description:"Select the first option as the default value for this SelectItem. \n <P>\n If options are derived from a dataSource, the first value returned by the server will be\n used, otherwise the first value in the valueMap.  Note that setting this property to\n true will trigger a fetch at soon as the form is created, because the form will try to\n establish a default value at that time.\n <P>\n If enabled, this setting overrides ${isc.DocUtils.linkForRef('attr:SelectItem.defaultValue')} and\n ${isc.DocUtils.linkForRef('method:SelectItem.defaultDynamicValue')}.",
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.disabled":{
        getter:[
            "isDisabled"
        ],
        defaultValue:"false",
        deprecated:null,
        flags:"IRW",
        description:"If set to true, the widget will be disabled. A widget is only considered enabled\n if it is individually enabled and all parents above it in the containment hierarchy\n are enabled. This allows you to enable or disable all components of a complex\n nested widget by enabling or disabling the top-level parent only.",
        groups:[
            "enable"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Canvas.disabled",
        valueType:"boolean",
        name:"disabled",
        definingClass:"class:Canvas",
        setter:[
            "setDisabled"
        ]
    },
    "attr:FusionChart.dataColors":{
        ref:"attr:FusionChart.dataColors",
        defaultValue:"see below",
        valueType:"Array of CSSColor",
        deprecated:null,
        name:"dataColors",
        flags:"IR",
        description:"An array of colors to use for a series of visual elements representing data (eg columns,\n bars, pie slices), any of which may be adjacent to any other.\n <P>\n Colors are expressed as hexadecimal RRGGBB Strings <b>with no leading '#' character</b>.",
        definingClass:"class:FusionChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:memoryLeaks":{
        ref:"group:memoryLeaks",
        refs:[
        ],
        deprecated:null,
        name:"memoryLeaks",
        description:"Care must be taken to avoid memory leaks in your application:<ul>\n <li>Any ${isc.DocUtils.linkForRef('class:Canvas')} (including subclasses) that you're done using should be destroy()d to\n avoid memory leaks.  Since ${isc.DocUtils.linkForRef('method:Canvas.destroy','destroy()')} is recursive, you only need to\n call destroy() on the topmost component in any hierarchy of widgets you don't need.  This\n includes ${isc.DocUtils.linkForRef('class:DynamicForm')} automatically destroying ${isc.DocUtils.linkForRef('class:FormItem')}s and ${isc.DocUtils.linkForRef('class:DrawPane')}\n automatically destroying ${isc.DocUtils.linkForRef('class:DrawItem')}s.\n <li>Any ${isc.DocUtils.linkForRef('class:ValuesManager')}s that you are done using should be destroy()d to avoid memory\n leaks, and will never be automatically destroyed as a consequence of destroying any related\n Canvas.\n <li>${isc.DocUtils.linkForRef('class:ResultSet')} and ${isc.DocUtils.linkForRef('class:ResultTree')} instances that you <b>manually</b> create need to\n be destroy()d to avoid leaks.  ResultSet and ResultTree instances automatically created by\n ${isc.DocUtils.linkForRef('class:ListGrid')}s and ${isc.DocUtils.linkForRef('class:TreeGrid')}s (see ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')}) do not need to be\n destroy()d as they are automatically destroyed with the creating ListGrid or TreeGrid.\n \n <li>If your application creates an unbounded number of DataSources while it is running\n (this is very rare), DataSources that are given a ${isc.DocUtils.linkForRef('attr:DataSource.ID')} need to be destroy()d\n to avoid leaks.  Most applications do not need to worry about this, as they create a fixed set of\n DataSources, and ${isc.DocUtils.linkForRef('classMethod:DataSource.get')} will never cause a leak.\n <li>Any other kinds of SmartClient objects you create will be garbage collected normally.\n </ul>\n <p>\n <h3>Testing for memory leaks</h3>\n <p>\n Seeing the browser's memory use rise dramatically after a given operation does not demonstrate\n a memory leak.  It's normal for browser memory usage to fluctuate wildly, because the browser\n will generally not reclaim resources immediately, and in some cases will not reclaim resources\n until memory is nearly exhausted.  Some browsers will also build up pools of resources for\n later re-use.\n <p>\n The only way to demonstrate a real memory leak is to demonstrate <i>memory exhaustion</i>:\n showing that the browser memory usage rises until all memory is exhausted and errors begin\n to occur.  No other pattern of increasing memory usage - no matter how large - is considered\n evidence of a leak, because the browser may suddenly reclaim very large amounts of memory\n after memory usage rises to a certain trigger point.  Memory exhaustion is the <i>only</i>\n way to demonstrate a real memory leak.\n <p>\n Note that all debugging tools must be closed in order to demonstrate memory exhaustion\n because debugging tools may themselves consume large amounts of memory:\n <ul>\n <li>On the RPC tab of the SmartClient Developer Console, make sure that \"Track RPCs\" is\n     <strong>un</strong>checked and then close the SmartClient Developer Console window.\n <li>If using Chrome's or Safari's developer tools, make sure that the developer tools are\n     closed.\n <li>If using Firebug, close Firebug and restart Firefox, as Firebug may still be active\n     even though closed.\n <li>If using Internet Explorer's Developer Tools, close Developer Tools and restart IE, as\n     the Developer Tools may still be active even though closed.\n </ul>\n <p>\n To demonstrate memory exhaustion, you generally need to take whatever operation you suspect\n of leaking memory and cause it to be repeated thousands or hundreds of thousands of times -\n generally, by performing the same operation multiple times in a loop, or, for asynchronous\n operations like ${isc.DocUtils.linkForRef('class:DataSource')} saves, performing the operation again each time you receive\n notification of completion (via callbacks).\n <p>\n In Windows, you can speed up the process of demonstrating memory exhaustion by disabling\n paging of memory to disk, which causes Windows to use the physical memory of the system\n (RAM) only.  To disable paging, go to Advanced System Settings, and in the \"Virtual Memory\"\n section of the \"Performance\" settings, uncheck the \"Automatically manage paging file size\n for all drives\" checkbox and select \"No paging file\" (this process may differ slightly on\n different versions of Windows).  The system will need to be rebooted for these new settings\n to take effect.\n <p>\n Once paging is disabled, verify that you can still open the browser and load the application\n you intend to test.  There needs to be ample physical memory available for the application\n to use.  A rule of thumb is to have enough available memory for the browser's memory footprint\n to at least quadruple in size or at least 500 MB, which ever is greater.  If the system does\n not have enough physical memory, one option is to re-enable paging, but limit the maximum\n size of the page file to 500 MB.  Then begin the process of repeating the operation being\n tested for a memory leak.\n <p>\n If Windows shows a warning about low system memory, you have demonstrated memory exhaustion\n and therefore a memory leak.  If you are working with a minimal, ready-to-run test case,\n you may have found a framework bug or a browser bug that SmartClient can work around.  You\n should post your minimal test case to the <a href='http://forums.smartclient.com/' target='_blank'>SmartClient forums</a>\n for analysis by Isomorphic Support.\n <p>\n If you do not have a minimal test case and have simply shown that your application is leaking\n memory, consider the possible coding errors that could cause memory leaks (explained above),\n and work toward creating a minimal test case if you suspect a framework or browser bug is the\n underlying cause.",
        treeLocation:[
            "Concepts"
        ],
        type:"group",
        title:"Memory Leaks",
        seeAlso:[
            {
                ref:"method:Canvas.destroy",
                description:null
            },
            {
                ref:"method:DrawItem.destroy",
                description:null
            },
            {
                ref:"method:Class.destroy",
                description:null
            },
            {
                ref:"class:ValuesManager",
                description:null
            },
            {
                ref:"attr:DataSource.ID",
                description:null
            }
        ]
    },
    "method:Class.clearLogPriority":{
        ref:"method:Class.clearLogPriority",
        deprecated:null,
        name:"clearLogPriority",
        flags:"",
        description:" Clear this object's priority setting for a particular category, so that the category's \n effective priority returns to the specified priority for this category at the Log level\n (or <code>Log.defaultPriority</code> if not set).<br>\n To clear the Page-level priority setting for this log category use \n <code>isc.Log.clearPriority()</code> instead.\n\n",
        definingClass:"class:Class",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"category",
                description:"Category name. If not specified, all logging on this object                              will revert to default priority settings.",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
            {
                ref:"classMethod:Log.clearPriority",
                description:null
            }
        ]
    },
    "object:PortalPosition":{
        classAttrs:[
        ],
        ref:"object:PortalPosition",
        methods:[
        ],
        deprecated:null,
        name:"PortalPosition",
        description:"Represents the position of a ${isc.DocUtils.linkForRef('class:Portlet')} within a ${isc.DocUtils.linkForRef('class:PortalLayout')}, indicating the\n column, row, and position within the row.",
        treeLocation:[
            "Client Reference/Layout/PortalLayout"
        ],
        type:"object",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:PortalPosition.colNum",
            "attr:PortalPosition.rowNum",
            "attr:PortalPosition.position"
        ]
    },
    "attr:ListGrid.autoFitMaxRecords":{
        defaultValue:"50",
        deprecated:null,
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code> this\n property provides the maximum number of records for which the ListGrid will expand. If more\n records are present, scrolling will be introduced to reach them as normal.\n If unset, by default the ListGrid will expand to accommodate as many records as are present.",
        groups:[
            "autoFitData"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.autoFitMaxRecords",
        valueType:"number",
        name:"autoFitMaxRecords",
        definingClass:"class:ListGrid",
        setter:[
            "setAutoFitMaxRecords"
        ]
    },
    "attr:Calendar.invalidDateMessage":{
        ref:"attr:Calendar.invalidDateMessage",
        defaultValue:"\"From must be before To\"",
        valueType:"String",
        deprecated:null,
        name:"invalidDateMessage",
        flags:"IR",
        description:"The message to display in the ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor')} when the 'To' date is greater than\n the 'From' date and a save is attempted.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.expansionDetailField":{
        ref:"attr:ListGrid.expansionDetailField",
        defaultValue:"null",
        valueType:"MultiAutoChild HTMLFlow",
        deprecated:null,
        name:"expansionDetailField",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:HTMLFlow')} for displaying the contents of\n ${isc.DocUtils.linkForRef('attr:ListGrid.detailField','a specified field')} in a record's expanded section when\n ${isc.DocUtils.linkForRef('type:ExpansionMode','listGrid.expansionMode')} is <code>detailField</code>.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via\n <code>listGrid.expansionDetailFieldProperties</code> and\n <code>listGrid.expansionDetailFieldDefaults</code>.\n <P>\n Note, however, that this is a multi-instance component (potentially one per record),\n so it is created using ${isc.DocUtils.linkForRef('method:Class.createAutoChild','createAutoChild()')} not\n ${isc.DocUtils.linkForRef('method:Class.addAutoChild','addAutoChild()')}, and no default single instance is created by\n name on the grid.",
        groups:[
            "expansionField"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListPropertiesDialog.cancelButtonTitle":{
        ref:"attr:ListPropertiesDialog.cancelButtonTitle",
        defaultValue:"\"Cancel\"",
        valueType:"String",
        deprecated:null,
        name:"cancelButtonTitle",
        flags:"IR",
        description:"The title of the ${isc.DocUtils.linkForRef('attr:ListPropertiesDialog.cancelButton','Cancel button')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ListPropertiesDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Layout.setMembers":{
        ref:"method:Layout.setMembers",
        deprecated:null,
        name:"setMembers",
        flags:"",
        description:" Display a new set of members in this layout. Equivalent to calling removeMembers() then\n addMembers(). Note that the new members may include members already present, in which case\n they will be reordered / integrated with any other new members passed into this method.\n",
        definingClass:"class:Layout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"members",
                description:null,
                optional:false,
                type:"Array of Canvas"
            }
        ],
        seeAlso:[
        ]
    },
    "object:LinearGradient":{
        classAttrs:[
        ],
        methods:[
        ],
        deprecated:null,
        description:"Definition of a linear gradient between two points, (${isc.DocUtils.linkForRef('attr:LinearGradient.x1','x1')}, ${isc.DocUtils.linkForRef('attr:LinearGradient.y1','y1')})\n and (${isc.DocUtils.linkForRef('attr:LinearGradient.x2','x2')}, ${isc.DocUtils.linkForRef('attr:LinearGradient.y2','y2')}).",
        treeLocation:[
            "Client Reference/Drawing/Gradients"
        ],
        type:"object",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:LinearGradient.x1",
            "attr:LinearGradient.y1",
            "attr:LinearGradient.x2",
            "attr:LinearGradient.y2"
        ],
        inheritsFrom:"Gradient",
        ref:"object:LinearGradient",
        name:"LinearGradient"
    },
    "method:DrawItem.setFillOpacity":{
        ref:"method:DrawItem.setFillOpacity",
        deprecated:null,
        name:"setFillOpacity",
        flags:"",
        description:" Update fillOpacity for this drawItem.\n",
        definingClass:"class:DrawItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"opacity",
                description:"new opacity, as a number between 0 (transparent) and 1 (opaque).",
                optional:false,
                type:"float"
            }
        ],
        seeAlso:[
        ]
    },
    "class:FilterBuilder":{
        classAttrs:[
        ],
        ref:"class:FilterBuilder",
        methods:[
            "method:FilterBuilder.removeClause",
            "method:FilterBuilder.setTopOperator",
            "method:FilterBuilder.setTopOperatorAppearance",
            "method:FilterBuilder.addClause",
            "method:FilterBuilder.getChildFilters",
            "method:FilterBuilder.getFilterDescription",
            "method:FilterBuilder.validate",
            "method:FilterBuilder.getFieldOperators",
            "method:FilterBuilder.getValueFieldProperties",
            "method:FilterBuilder.getCriteria",
            "method:FilterBuilder.setCriteria",
            "method:FilterBuilder.clearCriteria",
            "method:FilterBuilder.addCriterion",
            "method:FilterBuilder.getEditorType",
            "method:FilterBuilder.getSelectedClauses",
            "method:FilterBuilder.search",
            "method:FilterBuilder.filterChanged"
        ],
        deprecated:null,
        name:"FilterBuilder",
        description:"A form that allows the user to input advanced search criteria, including operators on\n field values such as \"less than\", and sub-clauses using \"AND\" and \"OR\" operators.\n <P>\n A FilterBuilder produces an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object, which the ${isc.DocUtils.linkForRef('class:DataSource')}\n subsystem can use to filter datasets, including the ability to perform such filtering within\n the browser for datasets that are completely loaded.\n <P>\n The operators available for each field can be customized at the DataSource level via\n ${isc.DocUtils.linkForRef('attr:DataSourceField.validOperators')}, ${isc.DocUtils.linkForRef('method:DataSource.setTypeOperators')} and related\n APIs.",
        treeLocation:[
            "Client Reference/Forms"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
            "classMethod:FilterBuilder.getFilterDescription"
        ],
        attrs:[
            "attr:FilterBuilder.missingFieldPrompt",
            "attr:FilterBuilder.fieldDataSource",
            "attr:FilterBuilder.sortFields",
            "attr:FilterBuilder.fieldPicker",
            "attr:FilterBuilder.fieldPickerTitle",
            "attr:FilterBuilder.fieldPickerProperties",
            "attr:FilterBuilder.operatorPicker",
            "attr:FilterBuilder.operatorPickerProperties",
            "attr:FilterBuilder.operatorPickerTitle",
            "attr:FilterBuilder.fieldPickerWidth",
            "attr:FilterBuilder.operatorPickerWidth",
            "attr:FilterBuilder.valueItemWidth",
            "attr:FilterBuilder.dataSource",
            "attr:FilterBuilder.criteria",
            "attr:FilterBuilder.saveOnEnter",
            "attr:FilterBuilder.showFieldTitles",
            "attr:FilterBuilder.validateOnChange",
            "attr:FilterBuilder.showRemoveButton",
            "attr:FilterBuilder.removeButtonPrompt",
            "attr:FilterBuilder.removeButton",
            "attr:FilterBuilder.showAddButton",
            "attr:FilterBuilder.addButtonPrompt",
            "attr:FilterBuilder.addButton",
            "attr:FilterBuilder.allowEmpty",
            "attr:FilterBuilder.retainValuesAcrossFields",
            "attr:FilterBuilder.topOperatorOptions",
            "attr:FilterBuilder.topOperator",
            "attr:FilterBuilder.radioOptions",
            "attr:FilterBuilder.topOperatorAppearance",
            "attr:FilterBuilder.radioOperatorLayout",
            "attr:FilterBuilder.radioOperatorForm",
            "attr:FilterBuilder.modeSwitcher",
            "attr:FilterBuilder.radioOperatorTitle",
            "attr:FilterBuilder.showSelectionCheckbox",
            "attr:FilterBuilder.topOperatorForm",
            "attr:FilterBuilder.topOperatorItem",
            "attr:FilterBuilder.topOperatorItemWidth",
            "attr:FilterBuilder.topOperatorTitle",
            "attr:FilterBuilder.defaultSubClauseOperator",
            "attr:FilterBuilder.matchAllTitle",
            "attr:FilterBuilder.matchNoneTitle",
            "attr:FilterBuilder.matchAnyTitle",
            "attr:FilterBuilder.inlineAndTitle",
            "attr:FilterBuilder.inlineOrTitle",
            "attr:FilterBuilder.inlineAndNotTitle",
            "attr:FilterBuilder.modeSwitcherAdvancedMessage",
            "attr:FilterBuilder.modeSwitcherSimpleMessage",
            "attr:FilterBuilder.modeSwitcherFlattenWarningMessage",
            "attr:FilterBuilder.showModeSwitcher",
            "attr:FilterBuilder.clauseStack",
            "attr:FilterBuilder.rangeSeparator",
            "attr:FilterBuilder.showSubClauseButton",
            "attr:FilterBuilder.subClauseButtonTitle",
            "attr:FilterBuilder.subClauseButtonPrompt",
            "attr:FilterBuilder.subClauseButton",
            "attr:FilterBuilder.bracket"
        ]
    },
    "attr:TextAreaItem.browserAutoCorrect":{
        ref:"attr:TextAreaItem.browserAutoCorrect",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"browserAutoCorrect",
        flags:"IRA",
        description:"In Mobile Safari, should automatic correction be offered for text in the item's text box?\n If <code>null</code>, then Mobile Safari determines automatically whether to enable\n autocorrect.\n <p>\n When enabled, Mobile Safari displays \"autocorrect bubbles\" to suggest automatic corrections:<br>\n <img src=\"data:image/png;base64,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\" width=\"150\" height=\"45\" alt=\"Screenshot of Mobile Safari suggesting &quot;On my way!&quot; to replace &quot;omw&quot;\">",
        definingClass:"class:TextAreaItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Slider.setTrackImageType":{
        ref:"method:Slider.setTrackImageType",
        deprecated:null,
        name:"setTrackImageType",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.trackImageType')} property of the slider\n\n",
        definingClass:"class:Slider",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newType",
                description:"new trackImageType",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.getExportRowBGColor":{
        ref:"method:ListGrid.getExportRowBGColor",
        deprecated:null,
        name:"getExportRowBGColor",
        flags:"",
        description:" When exporting data to Excel/OpenOffice format using ${isc.DocUtils.linkForRef('method:ListGrid.exportData','exportData()')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData','exportClientData()')}, background color to use \n for the given rowNum.\n <p>\n See ${isc.DocUtils.linkForRef('group:exportBGColor')} for an overview.\n\n",
        groups:[
            "exportBackgroundColor"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"background color to use for the row, or null to use the default                    background color",
            type:"CSSColor"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"record",
                description:"the record object behind the row being exported",
                optional:false,
                type:"Record"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ServiceTask.dataSource":{
        ref:"attr:ServiceTask.dataSource",
        defaultValue:"null",
        valueType:"DataSource or identifier",
        deprecated:null,
        name:"dataSource",
        flags:"IR",
        description:"DataSource ID or DataSource instance to be used.",
        definingClass:"class:ServiceTask",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.validators":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Validators to be applied to this field.\n <p>\n Validators are applied whenever there is an attempt to save changes to a field.\n <p>\n For the available set of built-in validators, and how to define a custom validator, see the\n ${isc.DocUtils.linkForRef('class:Validator')} class.",
        groups:[
            "dataType",
            "validation"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"class:Validator",
                description:null
            }
        ],
        ref:"attr:DataSourceField.validators",
        valueType:"Array of Validator",
        name:"validators",
        definingClass:"class:DataSourceField"
    },
    "attr:CalendarEvent.textColor":{
        ref:"attr:CalendarEvent.textColor",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"textColor",
        flags:"IRW",
        description:"An optional text color for the body portion of ${isc.DocUtils.linkForRef('class:EventCanvas','canvases')}\n representing this event in the various ${isc.DocUtils.linkForRef('class:CalendarView','calendar views')}.\n <P>\n Note that the recommended approach for styling events is to set a\n ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName','custom CSS style')}, which allows more complete customization\n of both header and body portions.",
        definingClass:"object:CalendarEvent",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FormItem.locateItemBy":{
        ref:"attr:FormItem.locateItemBy",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"locateItemBy",
        flags:"IRWA",
        description:"When ${isc.DocUtils.linkForRef('classMethod:AutoTest.getElement')} is used to parse locator strings generated by\n ${isc.DocUtils.linkForRef('classMethod:AutoTest.getLocator')} for this form item, should the item be identified?\n If the locator has a specified ${isc.DocUtils.linkForRef('attr:FormItem.name')}, it is considered to definitely\n locate the item and no fallback approach will be used.\n <P>\n Otherwise, the following options are available:\n <ul>\n <li><code>\"title\"</code> use the title as an identifier within this form</li>\n <li><code>\"value\"</code> use the value of the item to identify it (often used\n  for items with a static defaultValue such as HeaderItems</li>\n <li><code>\"index\"</code> use the index within the form's items array.\n </ul><p>\n If unset, and the locator has no specified name, default behavior is to\n identify by title (if available), then value (if available), otherwise by index.",
        groups:[
            "autoTest"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
            {
                ref:"type:LocatorStrategy",
                description:null
            }
        ]
    },
    "method:Tree.getRoot":{
        ref:"method:Tree.getRoot",
        deprecated:null,
        name:"getRoot",
        flags:"",
        description:"\n Returns the root node of the tree.\n\n",
        definingClass:"class:Tree",
        returns:{
            description:"the root node",
            type:"TreeNode"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:JSONEncoder.prettyPrint":{
        ref:"attr:JSONEncoder.prettyPrint",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"prettyPrint",
        flags:"IR",
        description:"Whether to add indentation to the returned JSON string.  This makes the returned JSON much\n easier to read but adds size.  Note that when delivering JSON responses compressed, the size\n difference between prettyPrinted JSON and normal JSON is negligible.",
        definingClass:"class:JSONEncoder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.booleanImageWidth":{
        ref:"attr:ListGrid.booleanImageWidth",
        defaultValue:"16",
        valueType:"number",
        deprecated:null,
        name:"booleanImageWidth",
        flags:"IRWA",
        description:"Width for the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')}, ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')}\n and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanPartialImage')}.\n Note: If ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} is unset, the ${isc.DocUtils.linkForRef('attr:CheckboxItem.checkedImage')}\n will be used to indicate a true value in a boolean field. In this case this property is\n ignored in favor of ${isc.DocUtils.linkForRef('attr:CheckboxItem.valueIconWidth')}.",
        groups:[
            "imageColumns"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:FacetChart.getChartTop":{
        ref:"method:FacetChart.getChartTop",
        deprecated:null,
        name:"getChartTop",
        flags:"",
        description:" Get the top coordinate of the central chart area, where data elements appear. \n <P>\n This is only allowed to be called when ${isc.DocUtils.linkForRef('method:FacetChart.chartDrawn')} fires.\n\n",
        definingClass:"class:FacetChart",
        returns:{
            description:"The top coordinate of the central chart area",
            type:"float"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "class:FormItemEditProxy":{
        classAttrs:[
        ],
        methods:[
        ],
        deprecated:null,
        description:"${isc.DocUtils.linkForRef('class:EditProxy')} that handles ${isc.DocUtils.linkForRef('class:FormItem')}s when editMode is enabled.",
        groups:[
            "devTools"
        ],
        treeLocation:[
            "Client Reference/Tools/EditProxy"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:FormItemEditProxy.valueMapSeparatorChar",
            "attr:FormItemEditProxy.valueMapDisplaySeparatorChar",
            "attr:FormItemEditProxy.valueMapSelectedChar",
            "attr:FormItemEditProxy.valueMapEscapeChar"
        ],
        ref:"class:FormItemEditProxy",
        name:"FormItemEditProxy"
    },
    "attr:FileItem.showFileInline":{
        ref:"attr:FileItem.showFileInline",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showFileInline",
        flags:"IR",
        description:"Indicates whether to stream the image and display it\n inline or to display the View and Download icons.",
        definingClass:"class:FileItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawItem.sideResizeKnob":{
        ref:"attr:DrawItem.sideResizeKnob",
        defaultValue:"null",
        valueType:"MultiAutoChild DrawKnob",
        deprecated:null,
        name:"sideResizeKnob",
        flags:"IR",
        description:"If this item is showing \"resize\"\n \n ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','control knobs')}, this attribute specifies the MultiAutoChild for the\n ${isc.DocUtils.linkForRef('class:DrawKnob')} that allows a user to resize the DrawItem with help of knobs located at\n centers of edges of a bounding rectangle of current DrawItem. Default shape is red square.",
        definingClass:"class:DrawItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Gauge.setNumMinorTicks":{
        ref:"method:Gauge.setNumMinorTicks",
        deprecated:null,
        name:"setNumMinorTicks",
        flags:"",
        description:" Sets the number of minor tick lines.\n\n <p><b>NOTE:</b> To divide the dial into <i>n</i> regions, you will need <i>n</i> + 1 ticks.\n For example, if the minimum value is 0 and the maximum value is 100, then to place minor\n tick lines at 0, 1, 2, 3, 4, 5, ..., 99, 100, you need 101 (100 + 1) minor ticks.\n\n",
        definingClass:"class:Gauge",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"numMinorTicks",
                description:"the number of minor tick lines to draw. Must be either 0 or an integer greater than or equal to 2.",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Mail.contentType":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Used to override the content-type header applied to the email.  Primarily used to send \n HTML emails rather than plain text ones (use \"text/html\" to do this).",
        groups:[
            "mail"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Mail.contentType",
        valueType:"String",
        name:"contentType",
        definingClass:"class:Mail"
    },
    "attr:ListGrid.animateFolderMaxRows":{
        ref:"attr:ListGrid.animateFolderMaxRows",
        defaultValue:"null",
        valueType:"integer",
        deprecated:null,
        name:"animateFolderMaxRows",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.animateFolders')} is true for this grid, this number can be set to designate\n the maximum number of rows to animate at a time when opening / closing a folder.\n <P>\n For a ListGrid, this property applies when ${isc.DocUtils.linkForRef('attr:ListGrid.canGroupBy','grouping')} is enabled.",
        groups:[
            "animation"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"method:TreeGrid.getAnimateFolderMaxRows",
                description:null
            }
        ]
    },
    "attr:ListGridField.filterEditorType":{
        ref:"attr:ListGridField.filterEditorType",
        defaultValue:"null",
        valueType:"FormItem className",
        deprecated:null,
        name:"filterEditorType",
        flags:"IRWA",
        description:"If this ListGrid is showing a filter row, this property can be used to\n      specify the form item class to use for the filter form item associated with this\n      field\n      (Only used if this field is not canFilter:false).<br>\n      Note: If this is not specified, the edit-form item type may be derived from the\n      'editorType' property, typically inherited from datasource fields, or from the\n      'type' of the field (showing the appropriate form item for the data-type).",
        groups:[
            "filterEditor"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MiniDateRangeItem.fromDate":{
        ref:"attr:MiniDateRangeItem.fromDate",
        defaultValue:"today",
        valueType:"Date or RelativeDateString or TimeUnit",
        deprecated:null,
        name:"fromDate",
        flags:"IRW",
        description:"Initial value for the \"from\" date.",
        definingClass:"class:MiniDateRangeItem",
        type:"attr",
        setter:[
            "setFromDate"
        ],
        seeAlso:[
        ]
    },
    "attr:DataSourceField.exportTitle":{
        serverDS:"allowed",
        ref:"attr:DataSourceField.exportTitle",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"exportTitle",
        flags:"IR",
        description:"Optional different field-title used for exports.",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MenuButton.hiliteAccessKey":{
        ref:"attr:MenuButton.hiliteAccessKey",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"hiliteAccessKey",
        flags:"IR",
        description:"If this MenuButton has a specified ${isc.DocUtils.linkForRef('attr:Canvas.accessKey','accessKey')}, underline it\n in the title of the button by default",
        definingClass:"class:MenuButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.editProxy":{
        ref:"attr:Canvas.editProxy",
        defaultValue:"null",
        valueType:"AutoChild EditProxy",
        deprecated:null,
        name:"editProxy",
        flags:"IR",
        description:"An ${isc.DocUtils.linkForRef('class:EditProxy')} controls the behaviors of a component when it is placed into\n ${isc.DocUtils.linkForRef('group:devTools','editing mode')}.\n <p>\n The <code>editProxy</code> AutoChild is created when a component is first placed into\n edit mode via ${isc.DocUtils.linkForRef('method:Canvas.setEditMode')}.\n <p>\n <code>editProxy</code> properties can be supplied on a ${isc.DocUtils.linkForRef('object:PaletteNode')} or\n ${isc.DocUtils.linkForRef('object:EditNode')} as ${isc.DocUtils.linkForRef('attr:PaletteNode.editProxyProperties','editProxyProperties')}, but must\n be provided before the component is first placed into edit mode.\n <p>\n Most editable components use a custom EditProxy. See the documentation for\n each class' ${isc.DocUtils.linkForRef('attr:Canvas.editProxyConstructor','editProxyConstructor')} to determine\n the class.",
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
            {
                ref:"method:Canvas.setEditMode",
                description:null
            }
        ]
    },
    "attr:ServerObject.attributeScope":{
        serverDS:"only",
        ref:"attr:ServerObject.attributeScope",
        defaultValue:"null",
        valueType:"\"request\"|\"session\"|\"application\"",
        deprecated:null,
        name:"attributeScope",
        flags:"IR",
        description:"Specifies the scope in which the DMI instance is to be looked up.  Valid values are: \n <code>\"request\"</code>, <code>\"session\"</code>, and <code>\"application\"</code>.  If\n <code>attributeScope</code> is left out of the <code>ServerObject</code> definition, then\n all scopes are searched in the order in which they are listed above.\n <p>\n This attribute is consulted only when the value of ${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')} is\n <code>\"attribute\"</code>.",
        definingClass:"class:ServerObject",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ServerObject.attributeName",
                description:null
            },
            {
                ref:"attr:ServerObject.lookupStyle",
                description:null
            }
        ]
    },
    "attr:Canvas.dragTarget":{
        ref:"attr:Canvas.dragTarget",
        defaultValue:"null",
        valueType:"Canvas | String",
        deprecated:null,
        name:"dragTarget",
        flags:"IRWA",
        description:"A different widget that should be actually dragged when dragging initiates on this\n widget. One example of this is to have a child widget that drags its parent, as with a\n drag box. Because the parent automatically repositions its children, setting the drag\n target of the child to the parent and then dragging the child will result in both\n widgets being moved.<br>\n Valid dragTarget values are:<br>\n - <code>null</code> (default) [this widget is its own drag target]<br>\n - another widget, or widget ID<br>\n - <code>\"parent\"</code> drag target is this widget's\n    ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas','parentCanvas')}<br>\n - <code>\"top\"</code> drag target is this widget's\n    ${isc.DocUtils.linkForRef('attr:Canvas.topElement','topElement')}<br>",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
            {
                ref:"classMethod:EventHandler.getDragTarget",
                description:null
            }
        ]
    },
    "method:ListGrid.getSelectedRecords":{
        ref:"method:ListGrid.getSelectedRecords",
        deprecated:null,
        name:"getSelectedRecords",
        flags:"",
        description:" Returns all selected records in this grid.\n <p>\n <strong>NOTE:</strong> Records in the returned array should be treated as read-only and not\n modified.\n",
        groups:[
            "selection"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"array of selected records, which will be empty if no record is selected.",
            type:"Array of ListGridRecord"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"excludePartialSelections",
                description:"When true, partially selected records will not be returned.                                   Otherwise, both fully and partially selected records are\n                                   returned.",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TimeItem.hourItemProperties":{
        ref:"attr:TimeItem.hourItemProperties",
        defaultValue:"null",
        valueType:"SelectItem properties",
        deprecated:null,
        name:"hourItemProperties",
        flags:"IRA",
        description:"Custom properties to apply to this timeItem's generated \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourItem','hour picker')}.",
        definingClass:"class:TimeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:multipleField":{
        ref:"group:multipleField",
        refs:[
            "type:MultipleFieldStorage",
            "attr:DataSourceField.multipleValueSeparator",
            "attr:DataSourceField.multipleStorage",
            "attr:DataSourceField.multipleStorageSeparator",
            "attr:OperationBinding.transformMultipleFields",
            "attr:DataSource.transformMultipleFields"
        ],
        deprecated:null,
        name:"multipleField",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "method:ValuesManager.setSaveOperationType":{
        ref:"method:ValuesManager.setSaveOperationType",
        deprecated:null,
        name:"setSaveOperationType",
        flags:"",
        description:" Setter for the default ${isc.DocUtils.linkForRef('type:DSOperationType')} when ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} is called.\n Note that this property can also be set by calling ${isc.DocUtils.linkForRef('method:DynamicForm.editRecord')} or \n ${isc.DocUtils.linkForRef('method:DynamicForm.editNewRecord')}\n\n",
        definingClass:"class:ValuesManager",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"operationType",
                description:"Operation type to use as a default. Valid values are  <code>\"add\"</code> or <code>\"update\"</code>.",
                optional:false,
                type:"DSOperationType"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataSource.auditTypeFieldName":{
        serverDS:"only",
        ref:"attr:DataSource.auditTypeFieldName",
        defaultValue:"\"audit_operationType\"",
        valueType:"string",
        deprecated:null,
        name:"auditTypeFieldName",
        flags:"IR",
        description:"For DataSources with ${isc.DocUtils.linkForRef('attr:DataSource.audit','auditing enabled')}, specifies the field name used to store\n the ${isc.DocUtils.linkForRef('type:DSOperationType','operationType')} (in a field of type \"text\").  If empty\n string is specified as the field name, the audit DataSource will not store this field.",
        definingClass:"class:DataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.autoFetchData":{
        defaultValue:"false",
        deprecated:null,
        flags:"IR",
        description:"If true, when this component is first drawn, automatically call <code>this.fetchData()</code>.\n Criteria for this fetch may be picked up from ${isc.DocUtils.linkForRef('attr:Calendar.initialCriteria')}, and textMatchStyle may\n be specified via ${isc.DocUtils.linkForRef('attr:ListGrid.autoFetchTextMatchStyle','autoFetchTextMatchStyle')}.\n <P>\n <span style='color:red'>NOTE:</span> if <code>autoFetchData</code> is set, calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} before draw will cause two requests to be issued, one from the manual\n call to fetchData() and one from the autoFetchData setting.  The second request will use\n only ${isc.DocUtils.linkForRef('attr:Calendar.initialCriteria')} and not any other criteria or settings from the first request.\n Generally, turn off autoFetchData if you are going to manually call ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')} at any time.",
        groups:[
            "databinding"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"method:ListGrid.fetchData",
                description:null
            }
        ],
        ref:"attr:Calendar.autoFetchData",
        examples:[
            "${isc.DocUtils.linkForExampleId('fetchOperation')}"
        ],
        valueType:"boolean",
        name:"autoFetchData",
        definingClass:"class:Calendar"
    },
    "attr:DetailViewer.fieldPickerWindow":{
        ref:"attr:DetailViewer.fieldPickerWindow",
        defaultValue:"null",
        valueType:"AutoChild FieldPickerWindow",
        deprecated:null,
        name:"fieldPickerWindow",
        flags:"IR",
        description:"Instance of ${isc.DocUtils.linkForRef('class:FieldPickerWindow')} used if ${isc.DocUtils.linkForRef('attr:DetailViewer.canPickFields')} is set.",
        definingClass:"class:DetailViewer",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TimeItem.useTextField":{
        ref:"attr:TimeItem.useTextField",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"useTextField",
        flags:"IR",
        description:"Should we show the time in a text field, or as a number of SelectItems?",
        definingClass:"class:TimeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Menu.useKeys":{
        ref:"attr:Menu.useKeys",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"useKeys",
        flags:"IRW",
        description:"A boolean indicating whether this menu should use shortcut keys. Set useKeys to\n false in a menu's initialization block to explicitly disable shortcut keys.",
        definingClass:"class:Menu",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Canvas.getViewportWidth":{
        ref:"method:Canvas.getViewportWidth",
        deprecated:null,
        name:"getViewportWidth",
        flags:"A",
        description:"  Returns the width of the viewport onto the scrollable content.\n\n",
        groups:[
            "sizing"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"width of the viewport, in pixels",
            type:"number"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGridField.cellAlign":{
        ref:"attr:ListGridField.cellAlign",
        defaultValue:"null",
        valueType:"Alignment",
        deprecated:null,
        name:"cellAlign",
        flags:"IRW",
        description:"Horizontal alignment for cells in this field's column: \"left\", \"right\"\n or \"center\".<br>\n If null, alignment is derived from ${isc.DocUtils.linkForRef('attr:ListGridField.align')}. If this field is editable,\n the alignment of cells in the body will also be reflected in any editors for the field.",
        groups:[
            "appearance"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RichTextEditor.fontControls":{
        ref:"attr:RichTextEditor.fontControls",
        defaultValue:"[\"fontSelector\", \"fontSizeSelector\"]",
        valueType:"Array of ControlName",
        deprecated:null,
        name:"fontControls",
        flags:"IRA",
        description:"Default font control group. Consists of an array of ${isc.DocUtils.linkForRef('type:ControlName')}s and/or\n ${isc.DocUtils.linkForRef('class:Canvas')} instances. To display this group of controls for some RichTextEditor,\n include <code>\"fontControls\"</code> in the ${isc.DocUtils.linkForRef('attr:RichTextEditor.controlGroups')} array.",
        definingClass:"class:RichTextEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MultiSortDialog.title":{
        ref:"attr:MultiSortDialog.title",
        defaultValue:"\"Sort\"",
        valueType:"String",
        deprecated:null,
        name:"title",
        flags:"IR",
        description:"The title-text to appear in this Dialog's Header-bar.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiSortDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.sqlDateFormat":{
        serverDS:"only",
        ref:"attr:DataSourceField.sqlDateFormat",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"sqlDateFormat",
        flags:"IR",
        description:"For fields of type \"date\", \"time\", and \"datetime\" that specify an\n ${isc.DocUtils.linkForRef('attr:DataSourceField.sqlStorageStrategy','sqlStorageStrategy')} of \"number\" or \"text\", this\n property allows you to specify the format SmartClient should use to map to/from the \n underlying value stored in the database.  The string provided must be a valid \n <a href=http://download.oracle.com/javase/1.4.2/docs/api/java/text/SimpleDateFormat.html>\n SimpleDateFormat pattern string</a>.\n <P>\n For fields of type \"datetime\" and \"time\" that specify an\n ${isc.DocUtils.linkForRef('attr:DataSourceField.sqlStorageStrategy','sqlStorageStrategy')} of \"number\", two special\n sqlDateFormat values are supported:\n <ul>\n   <li>\"epoch\" - The datetime or time value is stored as the number of full seconds that have\n       elapsed since January 1, 1970, 00:00:00 GMT.</li>\n   <li>\"epochms\" - The datetime or time value is stored as the number of milliseconds that\n       have elapsed since January 1, 1970, 00:00:00 GMT.  Millisecond precision is preserved\n       through database roundtrips with this setting</li>\n </ul>\n <P>\n This property and the \"number\" and \"text\" strategies for date/datetime fields are provided\n to allow transparent two-way mapping of legacy date values that are stored in numeric or\n text columns respectively rather than a true \"date\" column.  You would not ordinarily use them\n in the absence of a legacy database.\n <P>\n Note that this property only applies to users of SmartClient server and data sources of\n type \"sql\".",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ValuesManager.hasErrors":{
        ref:"method:ValuesManager.hasErrors",
        deprecated:null,
        name:"hasErrors",
        flags:"",
        description:" Are there any errors associated with any fields in this valuesManager?\n",
        groups:[
            "errors"
        ],
        definingClass:"class:ValuesManager",
        returns:{
            description:"returns true if there are any outstanding validation errors, false                   otherwise.",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:TabSet.closeTabIcon":{
        ref:"attr:TabSet.closeTabIcon",
        defaultValue:"[SKIN]/TabSet/close.png",
        valueType:"SCImgURL",
        deprecated:null,
        name:"closeTabIcon",
        flags:"IR",
        description:"Default src for the close icon for tabs to display if ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')} is true.",
        definingClass:"class:TabSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ImgButton.showTitle":{
        ref:"attr:ImgButton.showTitle",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showTitle",
        flags:"IRWA",
        description:"Determines whether any specified ${isc.DocUtils.linkForRef('method:StatefulCanvas.getTitle','title')} will be \n displayed for this component.<br>\n Applies to Image-based components only, where the title will be rendered out in a label\n floating over the component",
        definingClass:"class:ImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:GridRenderer.emptyMessageStyle":{
        ref:"attr:GridRenderer.emptyMessageStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"emptyMessageStyle",
        flags:"IRW",
        description:"The CSS style name applied to the emptyMessage string if displayed.",
        groups:[
            "emptyMessage"
        ],
        definingClass:"class:GridRenderer",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.padding":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Set the CSS padding of this component, in pixels.  Padding provides space between the\n border and the component's contents.\n <P>\n This property sets the same thickness of padding on every side.  Differing per-side\n padding can be set in a CSS style and applied via ${isc.DocUtils.linkForRef('attr:Canvas.styleName')}.\n <P>\n Note that CSS padding does not affect the placement of ${isc.DocUtils.linkForRef('attr:Canvas.children')}.  To\n provide a blank area around children, either use ${isc.DocUtils.linkForRef('attr:Canvas.margin','CSS margins')} or use\n a ${isc.DocUtils.linkForRef('class:Layout')} as the parent instead, and use properties such as\n ${isc.DocUtils.linkForRef('attr:Layout.layoutMargin')} to create blank space.",
        groups:[
            "appearance"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Canvas.padding",
        valueType:"number",
        name:"padding",
        definingClass:"class:Canvas",
        setter:[
            "setPadding"
        ]
    },
    "attr:FacetChart.showDoughnut":{
        ref:"attr:FacetChart.showDoughnut",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showDoughnut",
        flags:"IR",
        description:"Whether to show a \"doughnut hole\" in the middle of pie charts.  Defaults to whether\n chartType is set to \"Doughnut\" (shown) vs \"Pie\" (not shown) but can be forced on or off\n via <code>showDoughnut</code>.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:UserTask.targetVM":{
        ref:"attr:UserTask.targetVM",
        defaultValue:"null",
        valueType:"ValuesManager or String",
        deprecated:null,
        name:"targetVM",
        flags:"IR",
        description:"Optional ValuesManager which will receive task inputs and provide task outputs.  Use\n ${isc.DocUtils.linkForRef('attr:UserTask.targetForm')} instead of you want to use a DynamicForm.",
        definingClass:"class:UserTask",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:FileLoader.loadISC":{
        ref:"classMethod:FileLoader.loadISC",
        deprecated:null,
        name:"loadISC",
        flags:"",
        description:"\n Loads the specified SmartClient modules and skin in defer mode.  Calling this method is\n equivalent to using the <code>loadISC</code> JSP tag with <code>defer=\"true\"</code>.\n\n",
        definingClass:"class:FileLoader",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"skin",
                description:"Name of the skin to load.  If not specified, the skin specified by the                        default ${isc.DocUtils.linkForRef('classAttr:FileLoader.defaultSkin')} will be used.\n                        Instead of a skin name, you can specify a skinDir - this works just\n                        like ${isc.DocUtils.linkForRef('classMethod:Page.setSkinDir')} - the skin assumed to be a skinDir if\n                        there's at least one forward slash (/) in the name.",
                optional:true,
                type:"String"
            },
            {
                defaultValue:null,
                name:"modules",
                description:"List of modules to load.  If not specified, the list of modules                                   specified by the default\n                                   ${isc.DocUtils.linkForRef('classAttr:FileLoader.defaultModules')} will be used.  You\n                                   can specify modules as e.g: \"Core,Foundation\" or as [\"Core\",\n                                   \"Foundation\"]",
                optional:true,
                type:"String or Array"
            },
            {
                defaultValue:null,
                name:"onload",
                description:"Optional code to execute when all specified modules and                                      skin have loaded.",
                optional:true,
                type:"String or Function"
            }
        ],
        seeAlso:[
            {
                ref:"classAttr:FileLoader.addVersionToLoadTags",
                description:null
            },
            {
                ref:"classAttr:FileLoader.versionParamName",
                description:null
            },
            {
                ref:"classMethod:Page.setAddVersionToSkinCSS",
                description:null
            }
        ]
    },
    "method:DataSource.removeData":{
        ref:"method:DataSource.removeData",
        deprecated:null,
        name:"removeData",
        flags:"",
        description:" Perform a \"remove\" DataSource operation against this DataSource, to delete an existing\n DataSource record.\n\n",
        groups:[
            "operations"
        ],
        definingClass:"class:DataSource",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"data",
                description:"primary key values of record to delete, (or complete record)",
                optional:false,
                type:"Record | PrimaryKeys"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"callback to invoke on completion",
                optional:true,
                type:"DSCallback"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"additional properties to set on                                                       the DSRequest that will be issued",
                optional:true,
                type:"DSRequest Properties"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DrawItem.showResizeOutline":{
        ref:"attr:DrawItem.showResizeOutline",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"showResizeOutline",
        flags:"IRW",
        description:"If this item is showing \"resize\"\n \n ${isc.DocUtils.linkForRef('attr:DrawItem.knobs','control knobs')} will the resize outline be shown or not.",
        definingClass:"class:DrawItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DrawItem.resizeOutline",
                description:null
            }
        ]
    },
    "attr:DateChooser.alternateStyleSuffix":{
        ref:"attr:DateChooser.alternateStyleSuffix",
        defaultValue:"\"Dark\"",
        valueType:"string",
        deprecated:null,
        name:"alternateStyleSuffix",
        flags:"IRW",
        description:"The text appended to the style name when using ${isc.DocUtils.linkForRef('attr:DateChooser.alternateWeekStyles')}.",
        definingClass:"class:DateChooser",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TileGrid.addData":{
        ref:"method:TileGrid.addData",
        examples:[
            "${isc.DocUtils.linkForExampleId('databoundAdd')}"
        ],
        deprecated:null,
        name:"addData",
        flags:"",
        description:" Perform a DataSource \"add\" operation to add new records to this component's DataSource.\n\n",
        groups:[
            "dataBoundComponentMethods"
        ],
        definingClass:"class:TileGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newRecord",
                description:"new record",
                optional:false,
                type:"Record"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"method to call on operation completion",
                optional:true,
                type:"DSCallback"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"additional properties to set on the DSRequest                                          that will be issued",
                optional:true,
                type:"DSRequest Properties"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Canvas.linkHTML":{
        ref:"method:Canvas.linkHTML",
        deprecated:null,
        name:"linkHTML",
        flags:"A",
        description:" Generates the HTML for a standard link (anchor) element.\n\n",
        definingClass:"class:Canvas",
        returns:{
            description:"HTML for the link",
            type:"HTMLString"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"href",
                description:"URL for the link to point to",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"text",
                description:"HTML to display in the link element (defaults to the href)",
                optional:true,
                type:"HTMLString"
            },
            {
                defaultValue:null,
                name:"target",
                description:"Target window for the link (defaults to opening in a new, unnamed window)",
                optional:true,
                type:"string"
            },
            {
                defaultValue:null,
                name:"ID",
                description:"optional ID for the link element to be written out",
                optional:true,
                type:"string"
            },
            {
                defaultValue:null,
                name:"tabIndex",
                description:"optional tabIndex for the link",
                optional:true,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"accessKey",
                description:"optional accessKey for the link",
                optional:true,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "method:CubeGrid.cellIsSelected":{
        ref:"method:CubeGrid.cellIsSelected",
        deprecated:null,
        name:"cellIsSelected",
        flags:"",
        description:" Determine whether the cell passed in is selected in this cubeGrid.\n\n  <br><i>methodType</i> tester\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CubeGrid",
        returns:{
            description:"true if any cells are selected",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"cell",
                description:"cell to test",
                optional:false,
                type:"CellRecord"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Scrollbar.setScrollTarget":{
        ref:"method:Scrollbar.setScrollTarget",
        deprecated:null,
        name:"setScrollTarget",
        flags:"",
        description:"          Sets or clears the scrollbar's scrollTarget. If no argument is provided, then the\n          scrollTarget will be set to the scrollbar itself.\n\n",
        groups:[
            "scroll"
        ],
        definingClass:"class:Scrollbar",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newTarget",
                description:"target canvas to be scrolled",
                optional:true,
                type:"Canvas"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Canvas.dragType":{
        ref:"attr:Canvas.dragType",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"dragType",
        flags:"IRWA",
        description:"Sets a <code>dragType</code> for this widget used, to be compared to\n ${isc.DocUtils.linkForRef('attr:Canvas.dropTypes','dropTypes')} on possible drop target widgets.  See\n ${isc.DocUtils.linkForRef('attr:Canvas.dropTypes')} for a full explanation.",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DetailViewerField.imageWidth":{
        ref:"attr:DetailViewerField.imageWidth",
        defaultValue:"null",
        valueType:"Integer | String",
        deprecated:null,
        name:"imageWidth",
        flags:"IRW",
        description:"Width of images shown for fieldTypes image in this field.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n width.  For example, if <code>field.imageWidth</code> is \"logoWidth\",\n <code>record.logoWidth</code> will control the width of the image.",
        groups:[
            "imageColumns"
        ],
        definingClass:"object:DetailViewerField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DetailViewerField.imageSize",
                description:null
            },
            {
                ref:"attr:DetailViewerField.imageHeight",
                description:null
            }
        ]
    },
    "group:members":{
        ref:"group:members",
        refs:[
            "method:ValuesManager.getMembers",
            "method:ValuesManager.getMember",
            "method:ValuesManager.getMemberForField",
            "method:ValuesManager.addMember",
            "method:ValuesManager.addMembers",
            "method:ValuesManager.removeMember",
            "method:ValuesManager.removeMembers"
        ],
        deprecated:null,
        name:"members",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "method:ColumnTree.getData":{
        ref:"method:ColumnTree.getData",
        deprecated:null,
        name:"getData",
        flags:"",
        description:" Returns the ${isc.DocUtils.linkForRef('class:Tree')} object this ColumnTree is viewing\n\n",
        definingClass:"class:ColumnTree",
        type:"method",
        seeAlso:[
        ]
    },
    "class:ToolStripResizer":{
        classAttrs:[
        ],
        ref:"class:ToolStripResizer",
        methods:[
        ],
        deprecated:null,
        name:"ToolStripResizer",
        description:"Simple subclass of ImgSplitbar with appearance appropriate for a ToolStrip resizer.",
        treeLocation:[
            "Client Reference/Layout/ToolStrip"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:ToolStripResizer.skinImgDir",
            "attr:ToolStripResizer.vSrc",
            "attr:ToolStripResizer.hSrc"
        ]
    },
    "attr:DetailViewer.dataFetchMode":{
        ref:"attr:DetailViewer.dataFetchMode",
        defaultValue:"\"basic\"",
        valueType:"FetchMode",
        deprecated:null,
        name:"dataFetchMode",
        flags:"IRW",
        description:"DetailViewers do not yet support paging, and will fetch and render all available\n records.",
        groups:[
            "databinding"
        ],
        definingClass:"class:DetailViewer",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:GroupingMessages.upcomingNextMonthTitle":{
        ref:"classAttr:GroupingMessages.upcomingNextMonthTitle",
        defaultValue:"\"Next Month\"",
        valueType:"String",
        deprecated:null,
        name:"upcomingNextMonthTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs next \n month, relative to the current date.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:GroupingMessages",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:SelectItem.addUnknownValues":{
        ref:"attr:SelectItem.addUnknownValues",
        examples:[
            "${isc.DocUtils.linkForExampleId('formDependentSelectsLocal')}"
        ],
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"addUnknownValues",
        flags:"IRWA",
        description:"If this item's value is set (via ${isc.DocUtils.linkForRef('method:SelectItem.setValue')} or similar) to a value which\n is not present in the ${isc.DocUtils.linkForRef('type:ValueMap')}, should the value be rejected.\n <P>\n If set to <code>false</code> the setValue() call will have no effect if the value\n is not a valid option.\n <P>\n If set to <code>true</code> the item's value will be update to the new value, and\n the value will be added to the set of options displayed in the pick-list until the\n next call to ${isc.DocUtils.linkForRef('method:SelectItem.setValueMap')} or ${isc.DocUtils.linkForRef('method:SelectItem.setValue')}.\n <P>\n Exception: If the value is set to <code>null</code> but there is no null entry in the\n valueMap for this item, setting <code>addUnknownValues</code> to true will not cause\n a null option to show up at the top of the select item pickList. Whether an empty\n option is shown in the pickList is governed by ${isc.DocUtils.linkForRef('attr:SelectItem.allowEmptyValue')}\n instead.\n <P>\n Note that this property has no effect if the selectItem has a specified\n ${isc.DocUtils.linkForRef('attr:SelectItem.optionDataSource')}. If ${isc.DocUtils.linkForRef('method:SelectItem.setValue')} is called on a databound SelectItem\n and the new value does not match any loaded options, the value will be accepted,\n but not added to the options displayed in the pickList. Also note that if a\n ${isc.DocUtils.linkForRef('attr:SelectItem.displayField')} exists, a fetch will be performed in an attempt to retrieve\n a valid display value, as described under ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues')}.  \n If specified the ${isc.DocUtils.linkForRef('attr:FormItem.loadingDisplayValue')} will be displayed while the \n fetch is in progress, and then the real value (mapped to a display field value if\n a matching record was found) will be displayed when the fetch completes.",
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DynamicForm.originalValueMessage":{
        ref:"attr:DynamicForm.originalValueMessage",
        defaultValue:"\"Original value: $value\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"originalValueMessage",
        flags:"IRWA",
        description:"Default template HTML string when an item does not set its own ${isc.DocUtils.linkForRef('attr:FormItem.originalValueMessage')}.\n <p>\n Variables in the template are substituted as follows:\n <table border=\"1\">\n <tr>\n   <th>Variable</th>\n   <th>Substitution</th>\n </tr>\n <tr>\n   <td><code>$value</code></td>\n   <td>The item's old value as stored in the\n       object\n       returned by ${isc.DocUtils.linkForRef('method:DynamicForm.getOldValues')}.</td>\n </tr>\n <tr>\n   <td><code>$newValue</code></td>\n   <td>The item's new value.</td>\n </tr>\n </table>\n <p>\n For <code>$value</code> and <code>$newValue</code>, any formatters or stored/display value\n mapping will be applied.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:GroupingMessages.upcomingThisYearTitle":{
        ref:"classAttr:GroupingMessages.upcomingThisYearTitle",
        defaultValue:"\"This Year\"",
        valueType:"String",
        deprecated:null,
        name:"upcomingThisYearTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs in the\n same year as the current date.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:GroupingMessages",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:PrintCanvas.externalStylesheet":{
        ref:"attr:PrintCanvas.externalStylesheet",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"externalStylesheet",
        flags:"IRWA",
        description:"Setting this property will cause the specified stylesheet to be loaded in this print\n canvas's frame.\n The stylesheet should be specified as a URL to load.",
        definingClass:"class:PrintCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.eventEditorLayout":{
        ref:"attr:Calendar.eventEditorLayout",
        defaultValue:"null",
        valueType:"AutoChild Window",
        deprecated:null,
        name:"eventEditorLayout",
        flags:"R",
        description:"An ${isc.DocUtils.linkForRef('type:AutoChild')} of type ${isc.DocUtils.linkForRef('class:Window')} that displays the full \n ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor','event editor')}",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.regroup":{
        ref:"method:ListGrid.regroup",
        deprecated:null,
        name:"regroup",
        flags:"",
        description:" Programmatically regroup the grid according to the current grouping configuration.\n\n",
        definingClass:"class:ListGrid",
        type:"method",
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ]
    },
    "method:Gauge.setValue":{
        ref:"method:Gauge.setValue",
        deprecated:null,
        name:"setValue",
        flags:"",
        description:" Sets the value on the dial that the needle is displaying.\n\n",
        definingClass:"class:Gauge",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"value",
                description:"the new dial value. Must be between ${isc.DocUtils.linkForRef('attr:Gauge.minValue','minValue')} and ${isc.DocUtils.linkForRef('attr:Gauge.maxValue','maxValue')}.",
                optional:false,
                type:"float"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:Operators.startsWithPatternTitle":{
        ref:"classAttr:Operators.startsWithPatternTitle",
        defaultValue:"\"starts with pattern (exact case)\"",
        valueType:"String",
        deprecated:null,
        name:"startsWithPatternTitle",
        flags:"IR",
        description:"Title for the \"startsWithPattern\" operator",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Operators",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:AdvancedHiliteEditor.appearanceGroupTitle":{
        ref:"attr:AdvancedHiliteEditor.appearanceGroupTitle",
        defaultValue:"\"Appearance\"",
        valueType:"string",
        deprecated:null,
        name:"appearanceGroupTitle",
        flags:"IR",
        description:"The title for the Appearance group.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:AdvancedHiliteEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SelectItem.allowEmptyValue":{
        ref:"attr:SelectItem.allowEmptyValue",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"allowEmptyValue",
        flags:"IR",
        description:"If set to true, always show an empty option in this item's pickList, allowing the user\n to clear the value (even if there is no empty entry in the valueMap for the item).\n <P>\n The empty value will be displayed with the\n ${isc.DocUtils.linkForRef('attr:FormItem.emptyDisplayValue','emptyDisplayValue')}.\n <P>\n With a ${isc.DocUtils.linkForRef('attr:SelectItem.optionDataSource','databound selectItem')}, enabling\n <code>allowEmptyValue</code> disables data paging by default - all data matching the\n ${isc.DocUtils.linkForRef('attr:PickList.pickListCriteria','current criteria')} will be requested.  However, enabling\n ${isc.DocUtils.linkForRef('attr:SelectItem.separateSpecialValues')} allows data paging to be used if required.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:SelectItem.specialValues')} as a way of providing several different special values in\n addition to an empty value, such as \"Invalid\".  Note that setting\n <code>specialValues</code> disables the use of <code>allowEmptyValue</code> - see\n details of how to have an empty value while using <code>specialValues</code> in \n in ${isc.DocUtils.linkForRef('attr:SelectItem.specialValues','the <code>specialValues</code> documentation')}.",
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Calendar.removeIndicator":{
        ref:"method:Calendar.removeIndicator",
        deprecated:null,
        name:"removeIndicator",
        flags:"",
        description:" Removes a ${isc.DocUtils.linkForRef('attr:Calendar.indicators','indicator')} from the calendar.\n <P>\n Accepts either a ${isc.DocUtils.linkForRef('object:CalendarEvent','indicator object')} or a string that represents the \n ${isc.DocUtils.linkForRef('attr:CalendarEvent.name','name')} of anindicator.\n",
        definingClass:"class:Calendar",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"indicator",
                description:"either the actual CalendarEvent representing the                   indicator, or the name of the indicator to remove",
                optional:false,
                type:"CalendarEvent | String"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DSRequest.endRow":{
        ref:"attr:DSRequest.endRow",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"endRow",
        flags:"IR",
        description:"End row of requested results, used only with fetch operations.\n <p>\n Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at\n the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.",
        groups:[
            "paging"
        ],
        definingClass:"class:DSRequest",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.getFacetValue":{
        ref:"method:CubeGrid.getFacetValue",
        deprecated:null,
        name:"getFacetValue",
        flags:"",
        description:" Get a facet value definition by facetId and facetValueId.  Constant time.\n\n",
        definingClass:"class:CubeGrid",
        returns:{
            description:"the FacetValue if found, or null",
            type:"FacetValue"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetId",
                description:"the id of the facet to retrieve",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"facetValueId",
                description:"the id of the facet value to retrieve",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
            {
                ref:"class:FacetValue",
                description:null
            }
        ]
    },
    "attr:MetricSettings.stacked":{
        ref:"attr:MetricSettings.stacked",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"stacked",
        flags:"IRW",
        description:"If the ${isc.DocUtils.linkForRef('type:ChartType')} is \"Column\" then the metric settings may include\n a setting for ${isc.DocUtils.linkForRef('attr:FacetChart.stacked')}.\n <p>",
        definingClass:"object:MetricSettings",
        type:"attr",
        setter:[
            "setStacked"
        ],
        seeAlso:[
        ]
    },
    "method:ResultTree.invalidateCache":{
        ref:"method:ResultTree.invalidateCache",
        deprecated:null,
        name:"invalidateCache",
        flags:"A",
        description:" Manually invalidate this ResultTree's cache.\n <P>\n Generally a ResultTree will observe and incorporate updates to the DataSource that provides its\n records, but when this is not possible, <code>invalidateCache()</code> allows manual cache\n invalidation.\n <P>\n Components bound to this ResultTree will typically re-request the currently visible portion\n of the dataset, causing the ResultTree to re-fetch data from the server.\n",
        definingClass:"class:ResultTree",
        type:"method",
        seeAlso:[
        ]
    },
    "method:Dialog.applyClick":{
        ref:"method:Dialog.applyClick",
        deprecated:null,
        name:"applyClick",
        flags:"",
        description:" Handle a click on the 'apply' button of this Dialog.\n Default implementation is to call <code>saveData()</code>, but NOT close the Dialog.\n",
        groups:[
            "buttons"
        ],
        definingClass:"class:Dialog",
        type:"method",
        seeAlso:[
            {
                ref:"type:DialogButtons",
                description:null
            }
        ]
    },
    "attr:DrawGroup.useGroupRect":{
        ref:"attr:DrawGroup.useGroupRect",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"useGroupRect",
        flags:"IR",
        description:"When should this drawGroup receive event notifications?\n If set to <code>true</code>, the developer can specify an explicit \n ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','set of coordinates')}. Whenever the user interacts with this\n rectangle, the drawGroup will be notified and the appropriate event handlers will be\n fired. Note that rectangle need not contain all DrawItems within the group, and \n is manually managed by the developer.<br>\n If set to <code>false</code>, the ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','event rectangle')} \n coordinates are unused - instead\n as a user interacts with specific drawItems within this group, the appropriate event handler\n would be fired on the item, then the event would \"bubble\" to the\n drawGroup, firing the appropriate event handler at the group level as well.",
        definingClass:"class:DrawGroup",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.headerHoverStyle":{
        ref:"attr:ListGrid.headerHoverStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"headerHoverStyle",
        flags:"IRW",
        description:"This property may be set to customize the css style for the\n hover shown on ${isc.DocUtils.linkForRef('method:ListGrid.headerHover')}.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TextItem.browserAutoCapitalize":{
        ref:"attr:TextItem.browserAutoCapitalize",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"browserAutoCapitalize",
        flags:"IRA",
        description:null,
        definingClass:"class:TextItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.startDate":{
        ref:"attr:Calendar.startDate",
        defaultValue:"null",
        valueType:"Date",
        deprecated:null,
        name:"startDate",
        flags:"IR",
        description:"The start date of the calendar ${isc.DocUtils.linkForRef('class:Timeline','timeline view')}.  Has no effect in \n other views.  If not specified, defaults to a timeline starting from the beginning \n of the current ${isc.DocUtils.linkForRef('attr:Calendar.timelineGranularity','timelineGranularity')} and spanning\n ${isc.DocUtils.linkForRef('attr:Calendar.defaultTimelineColumnSpan','a default of 20')} columns of that granularity. \n <P>\n To set different start and ${isc.DocUtils.linkForRef('attr:Calendar.endDate','end')} dates after initial draw,\n see ${isc.DocUtils.linkForRef('method:Calendar.setTimelineRange','setTimelineRange')}.\n <P>\n Note that this attribute may be automatically altered if showing \n ${isc.DocUtils.linkForRef('attr:Calendar.headerLevels','header-levels')}, to fit to header boundaries.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.setShowRecordComponents":{
        ref:"method:ListGrid.setShowRecordComponents",
        deprecated:null,
        name:"setShowRecordComponents",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:ListGrid.showRecordComponents')} attribute\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"showRecordComponents",
                description:"new value for <code>this.showRecordComponents</code>",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "group:concat":{
        ref:"group:concat",
        refs:[
        ],
        deprecated:null,
        name:"concat",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:ResultSet.dropCacheOnUpdate":{
        ref:"attr:ResultSet.dropCacheOnUpdate",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"dropCacheOnUpdate",
        flags:"IRA",
        description:"Whether to discard all cached rows when a modification operation (add, update, remove)\n occurs on the ResultSet's DataSource.\n <P>\n A ResultSet that has a complete cache for the current filter criteria can potentially\n incorporate a newly created or updated row based on the data that the server returns\n when a modification operation completes.  However this is not always possible for\n ResultSets that show some types of joins, or when the server cannot easily return update\n data.  In this case set <code>dropCacheOnUpdate</code> to cause the cache to be\n discarded when an update occurs.\n <P>\n <code>dropCacheOnUpdate</code> can be set either directly on a ResultSet, or on a\n DataSource in order to affect all ResultSets on that DataSource.",
        groups:[
            "cacheSync"
        ],
        definingClass:"class:ResultSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ScriptTask.getInputRecord":{
        ref:"method:ScriptTask.getInputRecord",
        deprecated:null,
        name:"getInputRecord",
        flags:"",
        description:" Get all inputs to the task as specified by the \n ${isc.DocUtils.linkForRef('attr:Task.inputFieldList','inputFieldList')}, as a Record.\n",
        groups:[
            "taskIO"
        ],
        definingClass:"class:ScriptTask",
        returns:{
            description:"input data",
            type:"Record"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:CubeGrid.chartConfirmThreshold":{
        ref:"attr:CubeGrid.chartConfirmThreshold",
        defaultValue:"2000",
        valueType:"Number",
        deprecated:null,
        name:"chartConfirmThreshold",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('method:CubeGrid.makeChart')} is called with a chart specification that will show more than\n <code>chartConfirmThreshold</code> data elements, the user will be presented with a\n ${isc.DocUtils.linkForRef('classMethod:isc.confirm','confirmation dialog')}.\n <P>\n Set to 0 to disable this confirmation.",
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:EventCanvas.showRolloverControls":{
        ref:"attr:EventCanvas.showRolloverControls",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showRolloverControls",
        flags:"IRW",
        description:"When set to the default value of true, this attribute causes a set of components to be\n shown when the mouse rolls over this EventCanvas.  These components include the\n ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasCloseButton','close')} and \n ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextButton','context')} buttons, the latter's \n ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextMenu','context menu')} and the images used for \n drag-resizing.\n <P>\n Using rollover controls is more efficient that showing static buttons in each \n eventCanvas, so this is the default behavior.  See \n ${isc.DocUtils.linkForRef('attr:Calendar.useEventCanvasRolloverControls')} for the alternative.",
        definingClass:"class:EventCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.imageSize":{
        ref:"attr:ListGridField.imageSize",
        defaultValue:"16",
        valueType:"number",
        deprecated:null,
        name:"imageSize",
        flags:"IRW",
        description:"Size of images shown for fieldTypes image and imageFile in this field.\n This setting overrides the global ListGrid default ${isc.DocUtils.linkForRef('attr:ListGrid.imageSize')}.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n height.  For example, if <code>field.imageSize</code> is \"logoSize\",\n <code>record.logoSize</code> will control the size of the image.",
        groups:[
            "imageColumns"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.imageWidth",
                description:null
            },
            {
                ref:"attr:ListGridField.imageHeight",
                description:null
            }
        ]
    },
    "method:Tree.isOpen":{
        ref:"method:Tree.isOpen",
        deprecated:null,
        name:"isOpen",
        flags:"",
        description:"\n Whether a particular node is open or closed (works for leaves and folders).\n\n",
        definingClass:"class:Tree",
        returns:{
            description:"true if the node is open",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"node",
                description:"node in question",
                optional:false,
                type:"TreeNode"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:StaticTextItem.textBoxStyle":{
        ref:"attr:StaticTextItem.textBoxStyle",
        defaultValue:"\"staticTextItem\"",
        valueType:"FormItemBaseStyle",
        deprecated:null,
        name:"textBoxStyle",
        flags:"IRW",
        description:"Base CSS class for this item",
        groups:[
            "appearance"
        ],
        definingClass:"class:StaticTextItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:AdvancedHiliteEditor":{
        classAttrs:[
        ],
        ref:"class:AdvancedHiliteEditor",
        methods:[
            "method:AdvancedHiliteEditor.saveHilite",
            "method:AdvancedHiliteEditor.cancelEditing"
        ],
        deprecated:null,
        name:"AdvancedHiliteEditor",
        description:"A widget for editing a single, advanced ${isc.DocUtils.linkForRef('class:HiliteRule','hilite rule')} for use by  \n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','dataBoundComponents')}.  Where a simple hilite provides  \n configuration of a single criterion and either foreground or background color for  \n application to a single field, an advanced hilite can specify more complex criteria which can \n both test and affect multiple fields and allow both background and foreground colors to \n be specified in a single rule. \n <P>\n <i><b>Important Note:</b> this class should not be used directly - it is exposed purely for\n ${isc.DocUtils.linkForRef('group:i18nMessages','i18n reasons.')}</i>",
        treeLocation:[
            "Client Reference/Grids/ListGrid"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:AdvancedHiliteEditor.filterBuilder",
            "attr:AdvancedHiliteEditor.filterGroupTitle",
            "attr:AdvancedHiliteEditor.hiliteIcons",
            "attr:AdvancedHiliteEditor.hiliteForm",
            "attr:AdvancedHiliteEditor.appearanceGroupTitle",
            "attr:AdvancedHiliteEditor.targetFieldsItemTitle",
            "attr:AdvancedHiliteEditor.saveButton",
            "attr:AdvancedHiliteEditor.saveButtonTitle",
            "attr:AdvancedHiliteEditor.cancelButton",
            "attr:AdvancedHiliteEditor.cancelButtonTitle",
            "attr:AdvancedHiliteEditor.invalidHilitePrompt",
            "attr:AdvancedHiliteEditor.title",
            "attr:AdvancedHiliteEditor.callback"
        ]
    },
    "group:imageEdgeStyles":{
        ref:"group:imageEdgeStyles",
        refs:[
            "attr:EdgedCanvas.edgeStyleName",
            "attr:EdgedCanvas.addEdgeStyleSuffix"
        ],
        deprecated:null,
        name:"imageEdgeStyles",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:ListGrid.configureGroupingText":{
        ref:"attr:ListGrid.configureGroupingText",
        defaultValue:"\"Configure Grouping...\"",
        valueType:"string",
        deprecated:null,
        name:"configureGroupingText",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid,\n and multi-grouping is enabled, this attribute is used as the title for a menu item that opens\n a ${isc.DocUtils.linkForRef('class:MultiGroupDialog')} to configure the grouping for this grid.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.dataProtocol":{
        serverDS:"allowed",
        defaultValue:"\"getParams\"",
        deprecated:null,
        flags:"IR",
        description:"Controls the format in which inputs are sent to the dataURL.\n <p>\n When a DataSource operation such as fetchData() is invoked on this DataSource or a component\n bound to this DataSource, the data passed to the operation, if any, will be sent to the\n <code>dataURL</code>.  The <code>dataProtocol</code> property controls the format in\n which the data is sent: SOAP message, HTTP GET or POST of parameters, etc.\n <P>\n The <code>dataProtocol</code> property need not be set for a DataSource with a WebService\n ( ${isc.DocUtils.linkForRef('attr:DataSource.serviceNamespace')} is set), in this case, SOAP messaging is used by\n default.\n <P>\n Developers may completely bypass the SmartClient comm system by setting dataProtocol to\n <code>\"clientCustom\"</code>. In this case SmartClient will not attempt to send any data\n to the server after calling ${isc.DocUtils.linkForRef('method:DataSource.transformRequest')}. Instead the developer is\n expected to implement <code>transformRequest()</code> such that it performs the necessary\n data action outside of SmartClient, and then calls ${isc.DocUtils.linkForRef('method:DataSource.processResponse')}, \n passing in the ${isc.DocUtils.linkForRef('attr:DSRequest.requestId')} and an appropriate set of DSResponse properties to\n indicate the result of the action.\n <P>\n NOTE: when ${isc.DocUtils.linkForRef('attr:OperationBinding.dataFormat')} is \"iscServer\", <code>dataProtocol</code> is not consulted.\n Instead, SmartClient uses a proprietary wire format to communicate with the SmartClient\n server, and the server-side DSRequest and DSResponse objects should be used to access\n request data and form responses.",
        groups:[
            "clientDataIntegration"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"type:DSProtocol",
                description:null
            }
        ],
        ref:"attr:OperationBinding.dataProtocol",
        valueType:"DSProtocol",
        name:"dataProtocol",
        definingClass:"class:OperationBinding"
    },
    "attr:StatefulCanvas.radioGroup":{
        ref:"attr:StatefulCanvas.radioGroup",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"radioGroup",
        flags:"IRWA",
        description:"String identifier for this canvas's mutually exclusive selection group.",
        groups:[
            "state",
            "event handling"
        ],
        definingClass:"class:StatefulCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.getAllFields":{
        ref:"method:ListGrid.getAllFields",
        deprecated:null,
        name:"getAllFields",
        flags:"",
        description:" Get the complete array of fields for this ListGrid, including fields that are not currently\n visible or were specified implicitly via ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')}.\n <P>\n This list of fields is only valid once the ListGrid has been ${isc.DocUtils.linkForRef('method:Canvas.draw','drawn')} or once\n ${isc.DocUtils.linkForRef('method:ListGrid.setFields')} has been called explicitly.  If called earlier, only the list of directly\n specified fields will be returned (the Array passed to create()).\n <P>\n This Array should be treated as <b>read-only</b>.  To modify the set of visible fields, use\n ${isc.DocUtils.linkForRef('method:ListGrid.showField')}, ${isc.DocUtils.linkForRef('method:ListGrid.hideField')} and related APIs.  To update properties of individual\n fields, use ${isc.DocUtils.linkForRef('method:ListGrid.setFieldProperties')} or more specific APIs such as\n ${isc.DocUtils.linkForRef('method:ListGrid.setFieldTitle')}.\n\n",
        definingClass:"class:ListGrid",
        returns:{
            description:"Array of all fields in the ListGrid",
            type:"Array of ListGridField"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:TimeItem.showHourItem":{
        ref:"attr:TimeItem.showHourItem",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showHourItem",
        flags:"IRW",
        description:"Controls whether to display the ${isc.DocUtils.linkForRef('attr:TimeItem.hourItem')} when ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is false.",
        definingClass:"class:TimeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.canFreezeFields":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Whether an interface should be shown to allow user is allowed to dynamically \"freeze\" or\n \"unfreeze\" columns with respect to horizontally scrolling. If unset, this property defaults\n to <code>true</code> unless:<ul>\n <li>${isc.DocUtils.linkForRef('attr:ListGrid.fixedRecordHeights','this.fixedRecordHeights')} is <code>false</code></li>\n <li>${isc.DocUtils.linkForRef('attr:ListGrid.bodyOverflow','this.bodyOverflow')} is <code>\"visible\"</code></li>\n <li>${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData','this.autoFitData')} is set to <code>\"horizontal\"</code> or\n <code>\"both\"</code></li>\n <li>Any field has overflow set to <code>\"visible\"</code></li></ul>\n <P>\n Note that the <code>canFreezeFields</code> setting enables or disables the user\n interface for freezing and unfreezing fields only.  Fields can be programmatically\n frozen via setting ${isc.DocUtils.linkForRef('attr:ListGridField.frozen','field.frozen')} to true when the grid is\n created, or dynamically frozen and unfrozen via ${isc.DocUtils.linkForRef('method:ListGrid.freezeField')} and\n ${isc.DocUtils.linkForRef('method:ListGrid.unfreezeField')}.",
        groups:[
            "frozenFields"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.canFreezeFields",
        valueType:"boolean",
        name:"canFreezeFields",
        definingClass:"class:ListGrid",
        setter:[
            "setCanFreezeFields"
        ]
    },
    "method:TimeItem.selectValue":{
        ref:"method:TimeItem.selectValue",
        deprecated:null,
        name:"selectValue",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is true, falls through to standard\n ${isc.DocUtils.linkForRef('method:TextItem.selectValue','selectValue()')} implementation on this items freeform text entry field.\n Otherwise has no effect.\n",
        definingClass:"class:TimeItem",
        type:"method",
        seeAlso:[
        ]
    },
    "method:RichTextCanvas.applyListProperties":{
        ref:"method:RichTextCanvas.applyListProperties",
        deprecated:null,
        name:"applyListProperties",
        flags:"A",
        description:" Applies the given ${isc.DocUtils.linkForRef('object:ListProperties')} to the currently selected HTML list, if any.\n If there is no list selected, then this method does nothing.\n",
        definingClass:"class:RichTextCanvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"listProperties",
                description:"the list configuration to apply",
                optional:false,
                type:"ListProperties"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Calendar.indicatorStyleName":{
        ref:"attr:Calendar.indicatorStyleName",
        defaultValue:"\"indicatorCanvas\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"indicatorStyleName",
        flags:"IRW",
        description:"CSS style to apply to the ${isc.DocUtils.linkForRef('attr:Calendar.indicatorCanvas','canvases')} created for each\n specified ${isc.DocUtils.linkForRef('attr:Calendar.indicators','indicator')}.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SectionItem.sectionExpanded":{
        ref:"attr:SectionItem.sectionExpanded",
        examples:[
            "${isc.DocUtils.linkForExampleId('formSections')}"
        ],
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"sectionExpanded",
        flags:"IR",
        description:"Whether this form section should be initially collapsed. Can be set programmatically\n via ${isc.DocUtils.linkForRef('method:SectionItem.expandSection')} and ${isc.DocUtils.linkForRef('method:SectionItem.collapseSection')}.",
        definingClass:"class:SectionItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.focusInRow":{
        ref:"method:ListGrid.focusInRow",
        deprecated:null,
        name:"focusInRow",
        flags:"",
        description:" Puts keyboard focus into the specified row, showing a highlighted (roll-over style)\n appearance, and ensuring that arrow-key navigation will start from the specified row.\n <P>\n Only applies where ${isc.DocUtils.linkForRef('attr:ListGrid.canSelectCells')} is false.\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"row",
                description:"Index of target row",
                optional:false,
                type:"Integer"
            }
        ],
        seeAlso:[
            {
                ref:"method:ListGrid.focusInCell",
                description:null
            }
        ]
    },
    "attr:DataBoundComponent.badFormulaResultValue":{
        ref:"attr:DataBoundComponent.badFormulaResultValue",
        defaultValue:"\".\"",
        valueType:"String",
        deprecated:null,
        name:"badFormulaResultValue",
        flags:"IRW",
        description:"If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true),\n badFormulaResultValue is displayed instead.  The default value is \".\".",
        groups:[
            "formulaFields"
        ],
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:PageEvent":{
        ref:"type:PageEvent",
        values:[
            {
                description:"Fires repeatedly (every 10 ms by default) when the system is idle (i.e.,\n        not busy running other scripts) after the page is loaded.",
                value:"\"idle\""
            },
            {
                description:"Fires when the page has finished loading. It corresponds to the\n        browser 'load' event normally handled by window.onload.",
                value:"\"load\""
            },
            {
                description:"Fires when the page is exited or unloaded. It corresponds to the\n        browser 'unload' event normally handled by window.onunload.",
                value:"\"unload\""
            },
            {
                description:"Fires when the browser window is resized by the user. It corresponds\n        to the browser 'resize' event normally handled by window.onresize.",
                value:"\"resize\""
            },
            {
                description:"Fires when the left mouse button is pressed on the Page.",
                value:"\"mouseDown\""
            },
            {
                description:"Fires when the right mouse button is pressed on the Page.",
                value:"\"rightMouseDown\""
            },
            {
                description:"Fires when the mouse moves on the Page.",
                value:"\"mouseMove\""
            },
            {
                description:"Fires when the left mouse button released on the Page.",
                value:"\"mouseUp\""
            },
            {
                description:"Fires when the user clicks the mouse on the Page.",
                value:"\"click\""
            },
            {
                description:"Fires when the uesr double-clicks on the Page.",
                value:"\"doubleClick\""
            },
            {
                description:"Fires when the right mouse button is clicked on the page.  If your event handler\n        for this event returns false, the native browser context menu will be suppressed.<br>\n        Note: On the Macintosh platform, <code>Command+Click</code> may be used instead\n        of right-button click to trigger a context menu event.<br>\n        On the Opera browser, <code>Ctrl+Shift+Click</code> should be used instead of\n        right-button click.",
                value:"\"showContextMenu\""
            },
            {
                description:"Fires when a user presses a key on the keyboard.",
                value:"\"keyPress\""
            },
            {
                description:"Fires when the ${isc.DocUtils.linkForRef('classMethod:Page.getOrientation')} changes due        to browser-window resize or rotation of a mobile device.\n\n see classMethod:Page.setEvent()\n see classMethod:Page.clearEvent()",
                value:"\"orientationChange\""
            }
        ],
        deprecated:null,
        name:"PageEvent",
        description:"Events registerable via ${isc.DocUtils.linkForRef('classMethod:Page.setEvent')}",
        type:"type",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.decimalPrecision":{
        ref:"attr:MetricSettings.decimalPrecision",
        defaultValue:"2",
        valueType:"int",
        deprecated:null,
        name:"decimalPrecision",
        flags:"IR",
        description:"The ${isc.DocUtils.linkForRef('attr:FacetChart.decimalPrecision')} used to render the numeric labels of this metric axis.",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TreeGrid.connectorImage":{
        ref:"attr:TreeGrid.connectorImage",
        defaultValue:"\"[SKIN]connector.gif\"",
        valueType:"SCImgURL",
        deprecated:null,
        name:"connectorImage",
        flags:"IR",
        description:"The base filename for connector icons shown when ${isc.DocUtils.linkForRef('attr:TreeGrid.showConnectors')} is true.\n Connector icons are rendered into the title field of each row and show the dotted\n hierarchy lines between siblings of the same parent node. For each node, a connector icon\n may be shown:<ul>\n <li>As an opener icon for folder nodes, next to the folder icon</li>\n <li>In place of an opener icon for leaf nodes, next to the leaf icon</li>\n <li>As a standalone vertical continuation line in the indent to the left of the node, to show\n     a connection between some ancestor node's siblings (only relevant if\n     ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} is true).</li>\n </ul>\n Note that ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} governs whether connector lines will be\n displayed for all indent levels, or just for the innermost level of the tree.\n <P>\n The filenames for these icons are assembled from this base filename and the state of the\n node.  Assuming the connectorImage is set to <code>{baseName}.{extension}</code>, the\n full set of images to be displayed will be:\n <P>\n <code>{baseName}_ancestor[_rtl].{extension}</code> if ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')}\n  is true, this is the URL for the vertical continuation image to be displayed at the\n  appropriate indent levels for ancestor nodes with subsequent children.\n <P>\n For nodes with no children:\n <ul>\n <li><code>{baseName}_single[_rtl].{extension}</code>: Shown when there is no connector line\n  attached to the parent or previous sibling, and no connector line to the next sibling. For\n  ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors','showFullConnectors:true')} trees, there will always be a\n  connector leading to the parent or previous sibling if its present in the tree so this\n  icon can only be displayed for the first row.</li>\n <li><code>{baseName}_start[_rtl].{extension}</code>:  Shown when the there is no connector\n  line attached to the parent or previous sibling, but there is a connector to the next\n  sibling. As with <code>_single</code> this will only ever be used for the first row if\n  ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} is true</li>\n <li><code>{baseName}_end[_rtl].{extension}</code>:  Shown if we are not showing a connector \n  line attached to the next sibling of this node (but are showing a connection to the previous\n  sibling or parent).</li>\n <li><code>{baseName}_middle[_rtl].{extension}</code>:  Shown where the we have a connector\n  line leading to both the previous sibling (or parent) and the next sibling.\n </ul>\n For folders with children. Note that if ${isc.DocUtils.linkForRef('attr:TreeGrid.showFullConnectors')} is false, open\n folders will never show a connector to subsequent siblings:\n <ul>\n <li><code>{baseName}_opened_single[_rtl].{extension}</code> opened folder node with \n  children when no connector line is shown attaching to either the folder's previous sibling\n  or parent, or to any subsequent siblings.</li>\n <li><code>{baseName}_opened_start[_rtl].{extension}</code>:  opened folder with children\n  when the there is no connector line attached to the parent or previous sibling, but there \n  is a connector to the next sibling.</li>\n <li><code>{baseName}_opened_end[_rtl].{extension}</code>:  opened folder with children \n  if we are not showing a connector line attached to the next sibling of this node (but are\n  showing a connection to the previous sibling or parent).</li>\n <li><code>{baseName}_opened_middle[_rtl].{extension}</code>: opened folder with children \n  where the we have a connector line leading to both the previous sibling (or parent) and the\n  next sibling.\n </ul>\n <ul>\n <li><code>{baseName}_closed_single[_rtl].{extension}</code> closed folder node with \n  children when no connector line is shown attaching to either the folder's previous sibling\n  or parent, or to any subsequent siblings.</li>\n <li><code>{baseName}_closed_start[_rtl].{extension}</code>:  closed folder with children\n  when the there is no connector line attached to the parent or previous sibling, but there \n  is a connector to the next sibling.</li>\n <li><code>{baseName}_closed_end[_rtl].{extension}</code>:  closed folder with children \n  if we are not showing a connector line attached to the next sibling of this node (but are\n  showing a connection to the previous sibling or parent).</li>\n <li><code>{baseName}_closed_middle[_rtl].{extension}</code>: closed folder with children \n  where the we have a connector line leading to both the previous sibling (or parent) and the\n  next sibling.\n </ul>\n (Note '[_rtl]' means that \"_rtl\" will be attached if isRTL() is true for this widget).",
        groups:[
            "treeIcons"
        ],
        definingClass:"class:TreeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.matchGradations":{
        ref:"attr:MetricSettings.matchGradations",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"matchGradations",
        flags:"IR",
        description:"When this property is set to the metric of another MetricSettings object, the extra\n value axis and chart corresponding to these settings will use the same scale for the\n gradations as the extra value axis and chart of the other MetricSettings object.  The\n value of <code>matchGradations</code> can only be one of the metrics of the metric\n facet whose values will be displayed by the chart.",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FacetChart.extraAxisMetrics",
                description:null
            }
        ]
    },
    "group:iteration":{
        ref:"group:iteration",
        refs:[
            "method:ResultSet.getProperty",
            "method:List.getProperty",
            "method:Array.getProperty",
            "method:Array.map",
            "method:Array.setProperty",
            "method:Array.clearProperty"
        ],
        deprecated:null,
        name:"iteration",
        description:"Operations on entire Arrays at once",
        type:"group",
        title:"Iteration",
        seeAlso:[
        ]
    },
    "method:PortalLayout.setColumnWidth":{
        ref:"method:PortalLayout.setColumnWidth",
        deprecated:null,
        name:"setColumnWidth",
        flags:"",
        description:" Sets the width of a column in the PortalLayout.\n <p>\n Note that this sets the intrinsic width of the column. Columns may also\n automatically stretch and shrink to accomodate the width of\n ${isc.DocUtils.linkForRef('class:Portlet','Portlets')}.\n",
        definingClass:"class:PortalLayout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"colNumber",
                description:"Which column's width to set.",
                optional:false,
                type:"Integer"
            },
            {
                defaultValue:null,
                name:"width",
                description:"How wide to make the column",
                optional:false,
                type:"Number or String"
            }
        ],
        seeAlso:[
            {
                ref:"method:Canvas.setWidth",
                description:null
            }
        ]
    },
    "method:FormItem.keyUp":{
        ref:"method:FormItem.keyUp",
        deprecated:null,
        name:"keyUp",
        flags:"",
        description:" StringMethod fired in response to a keyup while focused in this form item.\n\n",
        groups:[
            "eventHandling"
        ],
        definingClass:"class:FormItem",
        returns:{
            description:"return false to attempt to cancel the event.  Note for general purpose                   APIs for managing whether user input is allowed, use ${isc.DocUtils.linkForRef('method:FormItem.change')} \n                   or ${isc.DocUtils.linkForRef('method:FormItem.transformInput')} instead.",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"item",
                description:"Item over which the keyup occurred",
                optional:false,
                type:"FormItem"
            },
            {
                defaultValue:null,
                name:"form",
                description:"Pointer to the item's form",
                optional:false,
                type:"DynamicForm"
            },
            {
                defaultValue:null,
                name:"keyName",
                description:"Name of the key pressed (Example: <code>\"A\"</code>, <code>\"Enter\"</code>)",
                optional:false,
                type:"KeyName"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DynamicForm.hideItem":{
        ref:"method:DynamicForm.hideItem",
        deprecated:null,
        name:"hideItem",
        flags:"",
        description:" Hide a form item via ${isc.DocUtils.linkForRef('method:FormItem.hide')}\n",
        groups:[
            "formValues"
        ],
        definingClass:"class:DynamicForm",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"itemName",
                description:"Name of the item to show",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:DrawPane.bezier":{
        ref:"classMethod:DrawPane.bezier",
        deprecated:null,
        name:"bezier",
        flags:"",
        description:" Computes a cubic Be&#769;zier curve polynomial:\n <code>\n B(t) = (1 - t)<sup>3</sup>P<sub>1</sub> + 3(1 - t)<sup>2</sup>tCP<sub>1</sub> + 3(1 - t)t<sup>2</sup>CP<sub>2</sub> + t<sup>3</sup>P<sub>2</sub>\n </code>\n",
        definingClass:"class:DrawPane",
        returns:{
            description:"the value of the polynomial <code>B(t)</code> at <code>t</code>",
            type:"double"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"p1",
                description:"starting point coordinate",
                optional:false,
                type:"double"
            },
            {
                defaultValue:null,
                name:"cp1",
                description:"first control point coordinate",
                optional:false,
                type:"double"
            },
            {
                defaultValue:null,
                name:"cp2",
                description:"second control point coordinate",
                optional:false,
                type:"double"
            },
            {
                defaultValue:null,
                name:"p2",
                description:"end point coordinate",
                optional:false,
                type:"double"
            },
            {
                defaultValue:null,
                name:"t",
                description:"the value of the parameter of the curve, between 0 and 1",
                optional:false,
                type:"double"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Tree.modelType":{
        ref:"attr:Tree.modelType",
        examples:[
            "${isc.DocUtils.linkForExampleId('nodeTitles')}"
        ],
        defaultValue:"\"children\"",
        valueType:"TreeModelType",
        deprecated:null,
        name:"modelType",
        flags:"IRWA",
        description:"Selects the model used to construct the tree representation.  See ${isc.DocUtils.linkForRef('type:TreeModelType')} for\n the available options and their implications.\n <P>\n If the \"parent\" modelType is used, you can provide the initial parent-linked data set to the\n tree via the ${isc.DocUtils.linkForRef('attr:Tree.data')} attribute.  If the \"children\" modelType is used, you can\n provide the initial tree structure to the Tree via the ${isc.DocUtils.linkForRef('attr:Tree.root')} attribute.",
        definingClass:"class:Tree",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Tree.data",
                description:null
            },
            {
                ref:"attr:Tree.root",
                description:null
            }
        ]
    },
    "attr:ColumnTree.customIconOpenProperty":{
        ref:"attr:ColumnTree.customIconOpenProperty",
        defaultValue:"\"showOpenIcon\"",
        valueType:"string",
        deprecated:null,
        name:"customIconOpenProperty",
        flags:"IRWA",
        description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.showOpenIcon','default node.showOpenIcon')} property.",
        groups:[
            "treeIcons"
        ],
        definingClass:"class:ColumnTree",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TreeGrid.customIconProperty",
                description:null
            },
            {
                ref:"attr:TreeGrid.showCustomIconOpen",
                description:null
            }
        ]
    },
    "attr:DataBoundComponent.fieldEditorWindowTitle":{
        ref:"attr:DataBoundComponent.fieldEditorWindowTitle",
        defaultValue:"\"${builderType} Editor [${fieldTitle}]\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"fieldEditorWindowTitle",
        flags:"IRWA",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fieldEditorWindow','Window')} used to edit calculated\n fields.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will\n be evaluated as JS code whenever the message is displayed.\n <P>\n Two dynamic variables are available - \"builderType\", either Formula or Summary, and \n \"fieldTitle\", which is the title of the calculated field being edited.",
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ComboBoxItem.pickListConstructor":{
        ref:"attr:ComboBoxItem.pickListConstructor",
        defaultValue:"\"PickListMenu\"",
        valueType:"SCClassName",
        deprecated:null,
        name:"pickListConstructor",
        flags:"IR",
        description:"The Class to use when creating the pickList for a FormItem.  Must be a subclass of the\n builtin default, ${isc.DocUtils.linkForRef('class:PickListMenu','PickListMenu')}.",
        definingClass:"class:ComboBoxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.headerHoverAlign":{
        ref:"attr:ListGrid.headerHoverAlign",
        defaultValue:"null",
        valueType:"Alignment",
        deprecated:null,
        name:"headerHoverAlign",
        flags:"IRW",
        description:"This property may be set to customize the alignment for the\n hover shown on ${isc.DocUtils.linkForRef('method:ListGrid.headerHover')}.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FormItem.alwaysFetchMissingValues":{
        ref:"attr:FormItem.alwaysFetchMissingValues",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"alwaysFetchMissingValues",
        flags:"IRWA",
        description:"If this form item has a specified ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')} and \n ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues')} is true, when the item value changes, a fetch will be\n performed against the optionDataSource to retrieve the related record \n if ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} is specified and the new item value is not present in any\n valueMap explicitly specified on the item.\n <P>\n Setting this property to true means that a fetch will occur against the optionDataSource \n to retrieve the related record even if ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} is unset, or the\n item has a valueMap which explicitly contains this field's value.\n <P>\n An example of a use case where this might be set would be if ${isc.DocUtils.linkForRef('method:FormItem.formatValue')}\n or ${isc.DocUtils.linkForRef('method:FormItem.formatEditorValue')} were written to display properties from the\n ${isc.DocUtils.linkForRef('method:FormItem.getSelectedRecord','selected record')}.\n <P>\n Note - for efficiency we cache the associated record once a fetch has been performed, meaning\n if the value changes, then reverts to a previously seen value, we do not kick\n off an additional fetch even if this property is true. If necessary this cache may be\n explicitly invalidated via a call to ${isc.DocUtils.linkForRef('method:FormItem.invalidateDisplayValueCache')}",
        groups:[
            "display_values"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Hilite.icon":{
        ref:"attr:Hilite.icon",
        defaultValue:"null",
        valueType:"SCImgURL",
        deprecated:null,
        name:"icon",
        flags:"IR",
        description:"URL of an icon to show when this hilite is applied to a cell.  Position of the icon \n is controlled by ${isc.DocUtils.linkForRef('attr:DataBoundComponent.hiliteIconPosition')} or \n ${isc.DocUtils.linkForRef('attr:ListGridField.hiliteIconPosition')}.",
        groups:[
            "hiliting"
        ],
        definingClass:"object:Hilite",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.useAutoGradients":{
        ref:"attr:FacetChart.useAutoGradients",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"useAutoGradients",
        flags:"IR",
        description:"Causes the chart to use the colors specified in ${isc.DocUtils.linkForRef('attr:FacetChart.dataColors')} but specify chart-specific \n gradients based on the primary data color per chart type.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataBoundComponent.dataField":{
        ref:"attr:DataBoundComponent.dataField",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"dataField",
        flags:"IR",
        description:"Name of the field that has the most pertinent numeric, date, or enum value, for use when a\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent')} needs to show a short summary of a record.\n <P>\n This attribute has the same function as ${isc.DocUtils.linkForRef('attr:DataSource.dataField')} but can be\n set for a component with no dataSource, or can be used to override the dataSource setting.",
        definingClass:"interface:DataBoundComponent",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MultiSortDialog.copyLevelButtonTitle":{
        ref:"attr:MultiSortDialog.copyLevelButtonTitle",
        defaultValue:"\"Copy Level\"",
        valueType:"String",
        deprecated:null,
        name:"copyLevelButtonTitle",
        flags:"IR",
        description:"The title-text to appear on the copyLevelButton\n <P>\n Note, this is a passthrough property which, when set, is passed through to the \n ${isc.DocUtils.linkForRef('class:MultiSortPanel','MultiSortPanel')} contained in this dialog.  You only need to\n consider the properties on the MultiSortPanel for i18n.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiSortDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.showDefaultContextMenu":{
        ref:"attr:ListGridField.showDefaultContextMenu",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showDefaultContextMenu",
        flags:"IRW",
        description:"When set to false, this field will not show a context menu in its header.",
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Calendar.getDateLabelText":{
        ref:"method:Calendar.getDateLabelText",
        deprecated:null,
        name:"getDateLabelText",
        flags:"",
        description:" Returns the text to display between the navigation buttons above the Calendar - indicates \n the visible date range.\n",
        definingClass:"class:Calendar",
        returns:{
            description:"a formatted date or date-range string appropriate to the passed view",
            type:"String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"viewName",
                description:"one of \"day\", \"week\", \"month\" or \"timeline\"",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"startDate",
                description:"the start of the visible date range",
                optional:false,
                type:"Date"
            },
            {
                defaultValue:null,
                name:"endDate",
                description:"the optional end of the visible date range",
                optional:true,
                type:"Date"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:PickList.filterLocally":{
        ref:"attr:PickList.filterLocally",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"filterLocally",
        flags:"IRA",
        description:"If <code>filterLocally</code> is set for this item, and this item is showing options \n from a dataSource, fetch the entire set of options from the server, and use these values\n to map the item value to the appropriate display value. Also use <code>\"local\"</code>\n type filtering on drop down list of options.\n <P>\n This means data will only be fetched once from the server, and then filtered on the\n client.\n <P>\n Note - when this property is set to <code>false</code>, filtering will still be \n performed on the client if a complete set of data for some criteria has been cached\n by a fetch, and a subsequent fetch has more restrictive criteria. To explicitly\n disable client-side filtering set the ${isc.DocUtils.linkForRef('attr:PickList.useClientFiltering')} property to false.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.filterLocally",
                description:null
            }
        ]
    },
    "type:LinePattern":{
        ref:"type:LinePattern",
        values:[
            {
                description:"Solid line",
                value:"\"solid\""
            },
            {
                description:"Dotted line",
                value:"\"dot\""
            },
            {
                description:"Dashed line",
                value:"\"dash\""
            },
            {
                description:"Dotted line, with more tightly spaced dots",
                value:"\"shortdot\""
            },
            {
                description:"Dashed line, with shorter, more tightly spaced dashes",
                value:"\"shortdash\""
            },
            {
                description:"Dashed line, with longer, more widely spaced dashes",
                value:"\"longdash\""
            }
        ],
        deprecated:null,
        name:"LinePattern",
        description:"Supported styles of drawing lines.",
        groups:[
            "line"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:DrawPane.getGradient":{
        ref:"method:DrawPane.getGradient",
        deprecated:null,
        name:"getGradient",
        flags:"",
        description:" Returns gradient for gradientID.\n\n",
        definingClass:"class:DrawPane",
        returns:{
            description:"the gradient or null if not found",
            type:"Gradient"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"gradientID",
                description:"ID of gradient to retrieve",
                optional:false,
                type:"identifier"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DynamicForm.requiredTitleSuffix":{
        ref:"attr:DynamicForm.requiredTitleSuffix",
        defaultValue:"\"&amp;nbsp;:&lt;/b&gt;\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"requiredTitleSuffix",
        flags:"IRW",
        description:"The string appended to the title of every required item in this form if\n ${isc.DocUtils.linkForRef('attr:DynamicForm.hiliteRequiredFields')} is true.",
        groups:[
            "formTitles"
        ],
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:AdvancedHiliteEditor.targetFieldsItemTitle":{
        ref:"attr:AdvancedHiliteEditor.targetFieldsItemTitle",
        defaultValue:"\"Target Field(s)\"",
        valueType:"string",
        deprecated:null,
        name:"targetFieldsItemTitle",
        flags:"IR",
        description:"The title for the Target Field(s) picker.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:AdvancedHiliteEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSource.serviceNamespace":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"For an XML DataSource, URN of the WebService to use to invoke operations.  This URN\n comes from the \"targetNamespace\" attribute of the &lt;wsdl:definitions&gt; element in a\n WSDL (Web Service Description Language) document, and serves as the unique identifier of\n the service.\n <P>\n Having loaded a WebService using ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadWSDL')}, setting\n <code>serviceNamespace</code> combined with specifying \n ${isc.DocUtils.linkForRef('class:OperationBinding','operationBindings')}\n that set ${isc.DocUtils.linkForRef('attr:OperationBinding.wsOperation')} will cause a DataSource to invoke web\n service operations to fulfill DataSource requests (${isc.DocUtils.linkForRef('class:DSRequest','DSRequests')}).\n <P>\n Setting <code>serviceNamespace</code> also defaults\n ${isc.DocUtils.linkForRef('attr:DataSource.dataURL','dataURL')} to the service's location,\n ${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','dataFormat')} to \"xml\" and\n ${isc.DocUtils.linkForRef('attr:OperationBinding.dataProtocol','dataProtocol')} to \"soap\".",
        groups:[
            "wsdlBinding",
            "clientDataIntegration"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DataSource.serviceNamespace",
        examples:[
            "${isc.DocUtils.linkForExampleId('wsdlBinding')}"
        ],
        valueType:"URN",
        name:"serviceNamespace",
        definingClass:"class:DataSource"
    },
    "method:DataBoundComponent.enableHiliting":{
        ref:"method:DataBoundComponent.enableHiliting",
        deprecated:null,
        name:"enableHiliting",
        flags:"",
        description:" Enable all hilites.\n\n",
        groups:[
            "hiliting"
        ],
        definingClass:"interface:DataBoundComponent",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"enable",
                description:"new enabled state to apply - if null, defaults to true",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Window.minimizeButton":{
        ref:"attr:Window.minimizeButton",
        defaultValue:"null",
        valueType:"AutoChild ImgButton",
        deprecated:null,
        name:"minimizeButton",
        flags:"R",
        description:"ImgButton shown in the header that will minimize this Window by calling ${isc.DocUtils.linkForRef('method:Window.minimize')}.",
        definingClass:"class:Window",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Dialog.warnIcon":{
        ref:"attr:Dialog.warnIcon",
        defaultValue:"\"[SKIN]warn.png\"",
        valueType:"SCImgURL",
        deprecated:null,
        name:"warnIcon",
        flags:"IR",
        description:"Icon to show in the ${isc.DocUtils.linkForRef('classMethod:isc.warn')}\n  dialog.",
        definingClass:"class:Dialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Process.sequences":{
        ref:"attr:Process.sequences",
        defaultValue:"null",
        valueType:"Array of ProcessSequence",
        deprecated:null,
        name:"sequences",
        flags:"IR",
        description:"Sequences of ProcessElements.  By defining a sequences of elements you can make the\n ${isc.DocUtils.linkForRef('attr:ProcessElement.nextElement')} implicit.\n <P>\n You do not have to explicitly create a ${isc.DocUtils.linkForRef('class:ProcessSequence')},\n you can instead use the shorthand:\n <pre>\n isc.Process.create({\n     startElement:\"firstSequence\", \n     sequences: [\n         { ID:\"something\", elements: [ ... ] },\n         { ID:\"somethingElse\", elements: [ ... ] },\n         ...\n     ]\n     ...\n });\n </pre>\n .. this is equivalent to ..\n <pre>\n isc.Process.create({\n     startElement:\"firstSequence\", \n     sequences: [\n         isc.ProcessSequence.create({ \n              ID:\"something\", \n              elements: [ ... ] \n         }),\n         isc.ProcessSequence.create({ \n              ID:\"somethingElement\", \n              elements: [ ... ] \n         }),\n         ...                           \n     ]\n     ...\n });\n </pre>\n \n ",
        definingClass:"class:Process",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TabSet.showTabContextMenu":{
        ref:"method:TabSet.showTabContextMenu",
        deprecated:null,
        name:"showTabContextMenu",
        flags:"",
        description:" Notification fired when the user right-clicks on a tab.\n Event may be cancelled by returning false\n",
        definingClass:"class:TabSet",
        returns:{
            description:"return false to cancel default right-click behavior",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"tabSet",
                description:"This tabset",
                optional:false,
                type:"TabSet"
            },
            {
                defaultValue:null,
                name:"tab",
                description:"the tab object that recieved the context click event",
                optional:false,
                type:"Tab"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:EventHandler.altKeyDown":{
        ref:"classMethod:EventHandler.altKeyDown",
        deprecated:null,
        name:"altKeyDown",
        flags:"",
        description:"\t\t\tReturn true if the alt (option) key is being held down.\n\t\t\tNote that this is only set reliably for keyboard events.\n\n",
        groups:[
            "keyboardEvents"
        ],
        definingClass:"class:EventHandler",
        returns:{
            description:"true == alt key is down",
            type:"Boolean"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "method:Canvas.dragResizeStart":{
        ref:"method:Canvas.dragResizeStart",
        deprecated:null,
        name:"dragResizeStart",
        flags:"A",
        description:"\n Executed when resize dragging first starts. No default implementation.\n Create this handler to set things up for the drag resize.\n\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"false to cancel the drag reposition action",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ]
    },
    "attr:SelectItem.pickerClearButtonTitle":{
        ref:"attr:SelectItem.pickerClearButtonTitle",
        defaultValue:"\"Clear\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"pickerClearButtonTitle",
        flags:"IR",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:SelectItem.pickerClearButton')}.",
        groups:[
            "i18nMessages",
            "panelPlacement"
        ],
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:GridRenderer.cellSelectionChanged":{
        ref:"method:GridRenderer.cellSelectionChanged",
        deprecated:null,
        name:"cellSelectionChanged",
        flags:"A",
        description:" Called when (cell-based) selection changes within this grid.\n\n",
        groups:[
            "selection"
        ],
        definingClass:"class:GridRenderer",
        returns:{
            description:"Returning false will prevent the GridRenderer styling from being updated                      to reflect the selection change.",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"cellList",
                description:"Array of cells whos selected state was modified.",
                optional:false,
                type:"array"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TableView.titleField":{
        ref:"attr:TableView.titleField",
        defaultValue:"\"title\"",
        valueType:"String",
        deprecated:null,
        name:"titleField",
        flags:"IRW",
        description:"Field to display for an individual record as the main title.",
        definingClass:"class:TableView",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:GridRenderer.autoFit":{
        ref:"attr:GridRenderer.autoFit",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"autoFit",
        flags:"IRWA",
        description:"If true, make columns only wide enough to fit content, ignoring any widths specified.\n Overrides fixedFieldWidths.",
        groups:[
            "sizing"
        ],
        definingClass:"class:GridRenderer",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:FormItem.isVisible":{
        ref:"method:FormItem.isVisible",
        deprecated:null,
        name:"isVisible",
        flags:"",
        description:" Return true if the form item is currently visible. Note that like the similar\n ${isc.DocUtils.linkForRef('method:Canvas.isVisible','Canvas API')}, it indicates visibility settings only and so\n will return true for an item that is not drawn.\n \n",
        groups:[
            "visibility"
        ],
        definingClass:"class:FormItem",
        returns:{
            description:"true if the form item is visible",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:Callbacks.ShowSectionCallback":{
        ref:"method:Callbacks.ShowSectionCallback",
        deprecated:null,
        name:"ShowSectionCallback",
        flags:"",
        description:" Callback to execute after the section has been shown.\n",
        definingClass:"class:Callbacks",
        type:"method",
        seeAlso:[
        ]
    },
    "object:KeyIdentifier":{
        classAttrs:[
        ],
        ref:"object:KeyIdentifier",
        methods:[
        ],
        deprecated:null,
        name:"KeyIdentifier",
        description:"Identifier for a key pressed by the user, optionally specifying whether the Shift, Control,\n and/or Alt keys should be held or not held when the key is pressed, used by various methods.",
        treeLocation:[
            "Client Reference/System/EventHandler"
        ],
        type:"object",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:KeyIdentifier.keyName",
            "attr:KeyIdentifier.shiftKey",
            "attr:KeyIdentifier.ctrlKey",
            "attr:KeyIdentifier.altKey"
        ]
    },
    "method:Canvas.isVisible":{
        ref:"method:Canvas.isVisible",
        deprecated:null,
        name:"isVisible",
        flags:"",
        description:" Returns true if the widget is visible, taking all parents into account, so that a widget\n which is not hidden might still report itself as not visible if it is within a hidden\n parent.\n <P>\n NOTE: Undrawn widgets will report themselves as visible if they would be visible if drawn.\n\n",
        groups:[
            "visibility"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"true if the widget is visible, false otherwise",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:StatefulCanvas.iconOrientation":{
        defaultValue:"\"left\"",
        deprecated:null,
        flags:"IR",
        description:"If this button is showing an icon should it appear to the left or right of the title?\n valid options are <code>\"left\"</code> and <code>\"right\"</code>.",
        groups:[
            "buttonIcon"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:StatefulCanvas.iconOrientation",
        valueType:"string",
        name:"iconOrientation",
        definingClass:"class:StatefulCanvas",
        setter:[
            "setIconOrientation"
        ]
    },
    "attr:ListGridField.optionFilterContext":{
        ref:"attr:ListGridField.optionFilterContext",
        defaultValue:"null",
        valueType:"DSRequest Properties",
        deprecated:null,
        name:"optionFilterContext",
        flags:"IR",
        description:"If this field has an optionDataSource specified and\n ${isc.DocUtils.linkForRef('attr:ListGridField.autoFetchDisplayMap','autoFetchDisplayMap')} is set, this attribute\n provides a way to customize the dataSource request issued to fetch the display map from\n the option dataSource.  This provides, among other capabilities, a way to trigger the\n server to return summary records.",
        groups:[
            "display_values"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"group:serverSummaries",
                description:null
            }
        ]
    },
    "class:ListPalette":{
        classAttrs:[
        ],
        methods:[
        ],
        deprecated:null,
        description:"A ListGrid that implements the ${isc.DocUtils.linkForRef('interface:Palette')} behavior, so it can be used as the source for \n drag and drop instantiation of components when combined with an ${isc.DocUtils.linkForRef('class:EditContext')} as \n the drop target.\n <P>\n Each ${isc.DocUtils.linkForRef('object:ListGridRecord')} can be a ${isc.DocUtils.linkForRef('object:PaletteNode')}.",
        groups:[
            "devTools"
        ],
        treeLocation:[
            "Client Reference/Tools/Palette"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ],
        ref:"class:ListPalette",
        name:"ListPalette",
        implementsInterfaces:[
            "Palette"
        ]
    },
    "attr:TextItem.escapeHTML":{
        ref:"attr:TextItem.escapeHTML",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"escapeHTML",
        flags:"IRW",
        description:"By default HTML characters will be escaped when ${isc.DocUtils.linkForRef('canEdit')} is false and \n ${isc.DocUtils.linkForRef('readOnlyDisplay')} is \"static\", so that the raw value of the field (for\n example <code>\"&lt;b&gt;AAA&lt;/b&gt;\"</code>) is displayed to the user rather than\n the interpreted HTML (for example <code>\"<b>AAA</b>\"</code>).  Setting\n <code>escapeHTML</code> false will instead force HTML values in a textItem to be\n interpreted by the browser in that situation.",
        groups:[
            "appearance"
        ],
        definingClass:"class:TextItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:PickList.textMatchStyle":{
        ref:"attr:PickList.textMatchStyle",
        defaultValue:"\"startsWith\"",
        valueType:"TextMatchStyle",
        deprecated:null,
        name:"textMatchStyle",
        flags:"IR",
        description:"When applying filter criteria to pickList data, what type of matching to use.\n <P>\n For a databound pickList (${isc.DocUtils.linkForRef('attr:PickList.optionDataSource')} set), <code>textMatchStyle</code> is\n sent to the server as ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')}.\n <P>\n For a non-databound pickList, <code>textMatchStyle</code> is applied by \n ${isc.DocUtils.linkForRef('method:PickList.filterClientPickListData','filterClientPickListData()')}.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.displaySort":{
        ref:"method:ListGrid.displaySort",
        deprecated:null,
        name:"displaySort",
        flags:"A",
        description:" Modify the grid UI to reflect the parameter sortSpecifiers.  For a single sortSpecifier, \n this consists of marking the field with a directional arrow in its header button (if it \n visible).\n <P>\n If multiple fields are sorted, those that are visible show a directional icon and a small\n ${isc.DocUtils.linkForRef('attr:ListGrid.sortNumeralStyle','sort-numeral')} indicating that field's index in the sort \n configuration.\n <P>\n See ${isc.DocUtils.linkForRef('method:ListGrid.addSort','addSort()')} and ${isc.DocUtils.linkForRef('method:ListGrid.toggleSort','toggleSort()')} APIs\n for information on making changes to the current sort configuration.\n <p>\n <b>NOTE:</b> This method is primarily used by ${isc.DocUtils.linkForRef('method:ListGrid.setSort')}; it is not intended \n to be called by user code, unless you are implementing a custom \n ${isc.DocUtils.linkForRef('method:ListGrid.setSortHandler','setSortHandler')}).  For the normal use case, calling this \n method directly will fail to execute vital pre-steps.  If you are not implementing a custom\n handler as described above, do not call this method directly - call <code>setSort()</code> \n instead.\n\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"sortSpecifiers",
                description:"Array of ${isc.DocUtils.linkForRef('object:SortSpecifier')} objects",
                optional:false,
                type:"Array of SortSpecifier"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Canvas.redraw":{
        ref:"method:Canvas.redraw",
        deprecated:null,
        name:"redraw",
        flags:"A",
        description:" Redraws the widget immediately with its current property values.\n\n Generally, if you want a Canvas to redraw, call markForRedraw() - this will cause the Canvas to\n be redrawn when current processing ends, so that a series of modifications made to a Canvas will\n cause it to redraw only once.\n\n Only call redraw() directly if you need immediate responsiveness, for example you are redrawing\n in response to continuous mouse motion.\n\n",
        groups:[
            "drawing"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:"\"no reason provided\"",
                name:"reason",
                description:"reason for performing the redraw",
                optional:true,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DataSourceField.requiredMessage":{
        ref:"attr:DataSourceField.requiredMessage",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"requiredMessage",
        flags:"IRW",
        description:"The required message when a field that has been marked as\n ${isc.DocUtils.linkForRef('attr:DataSourceField.required','required')} is not filled in by the user.\n <p>\n Note that this setting wins over ${isc.DocUtils.linkForRef('attr:DataSource.requiredMessage')} if both are set.",
        groups:[
            "formTitles"
        ],
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:find":{
        ref:"group:find",
        refs:[
            "method:ResultSet.findAll",
            "method:ResultSet.find",
            "method:ResultSet.findIndex",
            "method:ResultSet.findNextIndex",
            "method:List.findIndex",
            "method:List.findNextIndex",
            "method:List.find",
            "method:List.findAll",
            "method:Array.findIndex",
            "method:Array.findNextIndex",
            "method:Array.find",
            "method:Array.containsProperty",
            "method:Array.findAll"
        ],
        deprecated:null,
        name:"find",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:ColorItem.supportsTransparency":{
        ref:"attr:ColorItem.supportsTransparency",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"supportsTransparency",
        flags:"IRW",
        description:"Determines whether the ${isc.DocUtils.linkForRef('class:ColorPicker')} associated with this ColorItem allows the user \n to set transparency/opacity information whilst selecting a color. If false, no opacity\n slider is shown and all colors are 100% opaque.<p>\n <b>Note</b> ColorItems are representations of HTML color strings, they do not implicitly\n support transparency.  Setting supportsTransparency to true just allows the user to \n set opacity with the picker; if you actually want to capture that information,  you will\n also need to override ${isc.DocUtils.linkForRef('method:ColorItem.pickerColorSelected')}.",
        definingClass:"class:ColorItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RPCRequest.httpMethod":{
        ref:"attr:RPCRequest.httpMethod",
        defaultValue:"\"POST\"",
        valueType:"String",
        deprecated:null,
        name:"httpMethod",
        flags:"IRW",
        description:"Selects the HTTP method that will be used for the request.  Typical values are \"POST\" and\n \"GET\".\n <P>\n The more obscure \"PUT\", \"DELETE\" and \"HEAD\" methods are also valid, however, none of these\n are supported by the Safari browser previous to version 3.0.",
        definingClass:"class:RPCRequest",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.canDragRecordsOut":{
        defaultValue:"false",
        deprecated:null,
        flags:"IRW",
        description:"Indicates whether records can be dragged from this listGrid and dropped elsewhere.\n <p>\n <strong>NOTE:</strong> If <code>canDragRecordsOut</code> is initially enabled or might be\n dynamically enabled after the grid is created, it may be desirable to disable\n ${isc.DocUtils.linkForRef('attr:Canvas.useTouchScrolling','touch scrolling')} so that touch-dragging a record starts\n a drag operation rather than a scroll. If ${isc.DocUtils.linkForRef('attr:Canvas.disableTouchScrollingForDrag')}\n is set to <code>true</code>, then touch scrolling will be disabled automatically. However,\n for ${isc.DocUtils.linkForRef('group:accessibility','accessibility')} reasons, it is recommended to leave touch\n scrolling enabled and provide an alternative set of controls that can be used to perform\n drag and drop of records out of the grid.",
        groups:[
            "dragging"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridRecord.canDrag",
                description:null
            },
            {
                ref:"attr:ListGridRecord.canAcceptDrop",
                description:null
            }
        ],
        ref:"attr:ListGrid.canDragRecordsOut",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragListMove')}",
            "${isc.DocUtils.linkForExampleId('recordsAcrossWindows')}"
        ],
        valueType:"Boolean",
        name:"canDragRecordsOut",
        definingClass:"class:ListGrid"
    },
    "classAttr:Operators.endsWithTitle":{
        ref:"classAttr:Operators.endsWithTitle",
        defaultValue:"\"ends with (match case)\"",
        valueType:"String",
        deprecated:null,
        name:"endsWithTitle",
        flags:"IR",
        description:"Title for the \"endsWith\" operator",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Operators",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "type:EdgeName":{
        ref:"type:EdgeName",
        values:[
            {
                description:"top edge",
                value:"\"T\""
            },
            {
                description:"bottom edge",
                value:"\"B\""
            },
            {
                description:"left edge",
                value:"\"L\""
            },
            {
                description:"right edge",
                value:"\"R\""
            },
            {
                description:"top-left corner",
                value:"\"TL\""
            },
            {
                description:"top-right corner",
                value:"\"TR\""
            },
            {
                description:"bottom-left corner",
                value:"\"BL\""
            },
            {
                description:"bottom-right corner",
                value:"\"BR\""
            },
            {
                description:"center",
                value:"\"C\""
            }
        ],
        deprecated:null,
        name:"EdgeName",
        description:"An edge or corner of a rectange, or it's center.  Used in APIs such as\n ${isc.DocUtils.linkForRef('attr:Canvas.resizeFrom')} and ${isc.DocUtils.linkForRef('classMethod:Canvas.getEventEdge')}.",
        type:"type",
        seeAlso:[
        ]
    },
    "attr:Tree.dataSource":{
        ref:"attr:Tree.dataSource",
        defaultValue:"null",
        valueType:"DataSource | ID",
        deprecated:null,
        name:"dataSource",
        flags:"IR",
        description:"Specifies what ${isc.DocUtils.linkForRef('class:DataSource')} this tree is associated with.\n <P>\n A ${isc.DocUtils.linkForRef('class:DataSource')} is required when filtering a tree, even if it isn't a ${isc.DocUtils.linkForRef('class:ResultTree')},\n though it may be passed to ${isc.DocUtils.linkForRef('method:Tree.getFilteredTree')} rather than set on the tree itself.  If\n a ${isc.DocUtils.linkForRef('class:DataSource')} is specified it will also affect sorting, where relevant, such as if the\n tree is set as ${isc.DocUtils.linkForRef('attr:TreeGrid.data')}.",
        groups:[
            "treeFilter"
        ],
        definingClass:"class:Tree",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataBoundComponent.dataSource",
                description:null
            }
        ]
    },
    "attr:Calendar.allowDurationEvents":{
        ref:"attr:Calendar.allowDurationEvents",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"allowDurationEvents",
        flags:"IRW",
        description:"When set to true, allows events to be managed by duration, as well as by end date.  Values\n can be set for ${isc.DocUtils.linkForRef('attr:CalendarEvent.duration','duration')} and \n ${isc.DocUtils.linkForRef('attr:CalendarEvent.durationUnit','duration unit')} on each event, and are then maintained,\n instead of the end date, when alterations are made to the event via editors or dragging \n with the mouse.",
        groups:[
            "calendarEvent"
        ],
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
            {
                ref:"object:CalendarEvent",
                description:null
            }
        ]
    },
    "method:CubeGrid.getEditValues":{
        ref:"method:CubeGrid.getEditValues",
        deprecated:null,
        name:"getEditValues",
        flags:"",
        description:" Returns the current set of unsaved edits for a given row being edited.\n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:CubeGrid",
        returns:{
            description:"Current editValues object for the row.  This contains the current                     edit values in {fieldName1:value1, fieldName2:value2} format.",
            type:"object"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"valuesID",
                description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
                optional:false,
                type:"number | Object"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"colNum of the record being edited. Only required if valuesID                         is passed in as a rowNum.",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:MultiGroupPanel.levelUpButton":{
        ref:"attr:MultiGroupPanel.levelUpButton",
        defaultValue:"null",
        valueType:"AutoChild ImgButton",
        deprecated:null,
        name:"levelUpButton",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:ImgButton')} providing a mechanism for moving existing\n group-levels up in the group configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiGroupPanel.levelUpButtonProperties</code> and \n <code>multiGroupPanel.levelUpButtonDefaults</code>.",
        definingClass:"class:MultiGroupPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ServiceTask.criteria":{
        ref:"attr:ServiceTask.criteria",
        defaultValue:"null",
        valueType:"Criteria",
        deprecated:null,
        name:"criteria",
        flags:"IR",
        description:"Criteria (including AdvancedCriteria) to use for a \"fetch\" operation.\n <P>\n Data values in this criteria prefixed with \"$\" will be treated as dynamic expressions\n which can access the inputs to this task as $input - see\n ${isc.DocUtils.linkForRef('group:taskInputExpression')}.  Specifically, this means that for simple criteria,\n any property value that is a String and is prefixed with \"$\" will be assumed to be an\n expression, and for AdvancedCriteria, the same treatment will be applied to\n ${isc.DocUtils.linkForRef('attr:Criterion.value')}.\n <P>\n If any data value should not be treated as dynamic (for example, a \"$\" should be taken\n as literal), you can place it in ${isc.DocUtils.linkForRef('attr:ServiceTask.fixedCriteria')} instead.\n <P>\n Ignored for any operationType other than \"fetch\".  Update or delete operations should\n place the primary key to update in ${isc.DocUtils.linkForRef('attr:ServiceTask.values')}.",
        groups:[
            "taskIO"
        ],
        definingClass:"class:ServiceTask",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawItem.fillOpacity":{
        defaultValue:"1.0",
        deprecated:null,
        flags:"IRW",
        description:"Opacity of the fillColor, as a number between 0 (transparent) and 1 (opaque).",
        groups:[
            "fill"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DrawItem.fillOpacity",
        valueType:"float",
        name:"fillOpacity",
        definingClass:"class:DrawItem",
        setter:[
            "setFillOpacity"
        ]
    },
    "attr:NavPanel.currentItemId":{
        ref:"attr:NavPanel.currentItemId",
        defaultValue:"null",
        valueType:"identifier",
        deprecated:null,
        name:"currentItemId",
        flags:"IRW",
        description:"The ID of the current ${isc.DocUtils.linkForRef('object:NavItem')} whose ${isc.DocUtils.linkForRef('attr:NavItem.pane','pane')} is showing in the\n ${isc.DocUtils.linkForRef('attr:NavPanel.navDeck','navDeck')}.  The <code>NavItem</code> must be an item of this\n <code>NavPanel</code> if set.\n <p>\n The ID of a <code>NavItem</code> is the item's ${isc.DocUtils.linkForRef('attr:NavItem.id')} if set; otherwise, it\n is the ID of the item's ${isc.DocUtils.linkForRef('attr:NavItem.pane')}, though <code>currentItemId</code> may be\n initialized to either identifier.",
        definingClass:"class:NavPanel",
        type:"attr",
        setter:[
            "setCurrentItemId"
        ],
        seeAlso:[
        ]
    },
    "method:Canvas.disable":{
        ref:"method:Canvas.disable",
        deprecated:null,
        name:"disable",
        flags:"",
        description:" Disables this widget and any children and peers of this widget.\n",
        groups:[
            "enable"
        ],
        definingClass:"class:Canvas",
        type:"method",
        seeAlso:[
        ]
    },
    "classMethod:Page.unregisterKey":{
        ref:"classMethod:Page.unregisterKey",
        deprecated:null,
        name:"unregisterKey",
        flags:"",
        description:" Clears an action registered to fire on a specific a keyPress event via the ${isc.DocUtils.linkForRef('classMethod:Page.registerKey')}\n method. \n",
        groups:[
            "KeyRegistry"
        ],
        definingClass:"class:Page",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"actionID",
                description:"Name of key to clear registry entries for.",
                optional:false,
                type:"KeyName"
            },
            {
                defaultValue:null,
                name:"target",
                description:"target specified when the action was registered for the key.",
                optional:true,
                type:"object"
            }
        ],
        seeAlso:[
            {
                ref:"classMethod:Page.registerKey",
                description:null
            }
        ]
    },
    "attr:FacetChart.xAxisStartValue":{
        ref:"attr:FacetChart.xAxisStartValue",
        defaultValue:"null",
        valueType:"Float or Date",
        deprecated:null,
        name:"xAxisStartValue",
        flags:"IR",
        description:"For Bubble and Scatter charts only, the start value for the x-axis.\n <p>\n Defaults to 0, or to a value that makes good use of horizontal space based on\n ${isc.DocUtils.linkForRef('attr:FacetChart.minXDataSpreadPercent')}.\n <P>\n If the x-axis metric is date-valued, this value should be a date (typically\n applies to Scatter charts only).",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FacetChart.axisStartValue",
                description:null
            }
        ]
    },
    "method:Canvas.setBorder":{
        ref:"method:Canvas.setBorder",
        deprecated:null,
        name:"setBorder",
        flags:"",
        description:" Set the CSS border of this component, as a CSS string including border-width,\n border-style, and/or color (eg \"2px solid blue\").\n <P>\n This property applies the same border to all four sides of this component.  Different\n per-side borders can be set in a CSS style and applied via ${isc.DocUtils.linkForRef('attr:Canvas.styleName')}.\n\n",
        groups:[
            "appearance"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newBorder",
                description:"new border to set to (eg: \"2px solid black\")",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:CancelItem.title":{
        ref:"attr:CancelItem.title",
        defaultValue:"\"Cancel\"",
        valueType:"String",
        deprecated:null,
        name:"title",
        flags:"IRW",
        description:"CancelItems show a title of <code>\"Cancel\"</code> by default. May be overridden.",
        definingClass:"class:CancelItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:Time.AMIndicator":{
        ref:"classAttr:Time.AMIndicator",
        defaultValue:"\" am\"",
        valueType:"string",
        deprecated:null,
        name:"AMIndicator",
        flags:"RWA",
        description:"String appended to times to indicate am (when not using 24 hour format).",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Time",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:ListGrid.headerTitleClipped":{
        ref:"method:ListGrid.headerTitleClipped",
        deprecated:null,
        name:"headerTitleClipped",
        flags:"A",
        description:" Is the field title for the specified field clipped?\n\n",
        groups:[
            "gridHeader"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"whether the field title for the specified field is clipped",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldNum",
                description:"field number for the header button title to test",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
            {
                ref:"attr:ListGrid.clipHeaderTitles",
                description:null
            }
        ]
    },
    "attr:Portlet.canDrop":{
        ref:"attr:Portlet.canDrop",
        examples:[
            "${isc.DocUtils.linkForExampleId('repositionPortlets')}"
        ],
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"canDrop",
        flags:"IRW",
        description:"Portlets have canDrop set to true to enable drag/drop reposition within the portalLayout",
        definingClass:"class:Portlet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Dialog.icon":{
        ref:"attr:Dialog.icon",
        defaultValue:"null",
        valueType:"SCImgURL",
        deprecated:null,
        name:"icon",
        flags:"IR",
        description:"Icon to show in this dialog - see ${isc.DocUtils.linkForRef('attr:Dialog.message')}.",
        definingClass:"class:Dialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DetailViewerField.cellStyle":{
        ref:"attr:DetailViewerField.cellStyle",
        getter:[
            "getCellStyle"
        ],
        defaultValue:"null",
        valueType:"CSSClassName",
        deprecated:null,
        name:"cellStyle",
        flags:"IRW",
        description:"If specified, cells in this field will be rendered using this css className rather than\n ${isc.DocUtils.linkForRef('attr:DetailViewer.cellStyle')}",
        definingClass:"object:DetailViewerField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.width":{
        ref:"attr:ListGridField.width",
        defaultValue:"\"*\"",
        valueType:"Number or String",
        deprecated:null,
        name:"width",
        flags:"IRW",
        description:"The width of this field, specified as either an absolute number of pixels,\n a percentage of the remaining space like \"25%\", or \"*\" to split remaining space among\n all fields which have \"*\". <P>\n Caution: stretch sizes are currently ignored if the field is being autofitted\n (see ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths')}), unless ${isc.DocUtils.linkForRef('attr:ListGrid.showHeader')} is false.\n <P>\n Note: if autofitting is active for a field, the width will default to the numerical\n autofit width for that field (so it will not be stretched larger to fill available\n space).  Otherwise, if not autofitting, the width will default to \"*\" causing it to be\n automatically stretched.\n <P>\n The width may be defaulted to a numerical value based on ${isc.DocUtils.linkForRef('attr:DataSourceField.length')}\n if no ${isc.DocUtils.linkForRef('attr:ListGridField.valueMap')} is set, subject to the initial value of\n ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')}.  If you'd rather have the field stretched-sized to fit the\n available space, set its initial width to \"*\".\n <P>\n See also ${isc.DocUtils.linkForRef('attr:ListGrid.minFieldWidth')} to ensure no field goes below a minimum size.\n <P>\n Use ${isc.DocUtils.linkForRef('method:ListGrid.resizeField')} to programmatically change field width after creation.\n <P>\n Use ${isc.DocUtils.linkForRef('method:ListGrid.getFieldWidth')} to access the rendered field width after\n the ListGrid is drawn.",
        groups:[
            "appearance"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGrid.autoFitFieldWidths",
                description:null
            }
        ]
    },
    "attr:FormulaBuilder.invalidBlankPrompt":{
        ref:"attr:FormulaBuilder.invalidBlankPrompt",
        defaultValue:"\"Invalid blank ${builderType}\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"invalidBlankPrompt",
        flags:"IRWA",
        description:"When ${isc.DocUtils.linkForRef('method:FormulaBuilder.testFunction','testFunction')} reports an empty formula, \n this attribute provides the error-text to display in the\n ${isc.DocUtils.linkForRef('attr:FormulaBuilder.messageLabel','message-label')}.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will \n be evaluated as JS code when the message is displayed.\n <P>\n Only one dynamic variable, builderType, is available and represents the type of this \n builder, either Formula or Summary.\n <P>\n The default output is:<P>\n <code>\n <i>Invalid blank [Formula/Summary] </i>\n </code>",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FormulaBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ViewLoader.viewRPCProperties":{
        ref:"attr:ViewLoader.viewRPCProperties",
        defaultValue:"null",
        valueType:"RPCRequest Properties",
        deprecated:null,
        name:"viewRPCProperties",
        flags:"IRA",
        description:"RPCRequest properties to be sent with every RPCRequest issued by the ViewLoader.  Very\n advanced; could be used to, for example, set HTTP headers.",
        definingClass:"class:ViewLoader",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TabSet.titleEditorLeftOffset":{
        ref:"attr:TabSet.titleEditorLeftOffset",
        defaultValue:"null",
        valueType:"Integer",
        deprecated:null,
        name:"titleEditorLeftOffset",
        flags:"IRW",
        description:"If set, offsets the tab title editor further in from the left-hand edge of the tab, by\n the number of pixels set in this property.  Note that the editor is always offset to\n avoid overlapping the endcaps of the tab; this property is applied on top of that \n default offset.",
        definingClass:"class:TabSet",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TabSet.titleEditorRightOffset",
                description:null
            },
            {
                ref:"attr:TabSet.titleEditorTopOffset",
                description:null
            }
        ]
    },
    "method:CubeGrid.facetValueContextClick":{
        ref:"method:CubeGrid.facetValueContextClick",
        deprecated:null,
        name:"facetValueContextClick",
        flags:"",
        description:" StringMethod handler fired when context click occurs over a facetValue button in a header.\n\n",
        groups:[
            "events"
        ],
        definingClass:"class:CubeGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetValues",
                description:"FacetValueMap describing the appropriate header button",
                optional:false,
                type:"FacetValueMap"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:Log.traceMethod":{
        ref:"classMethod:Log.traceMethod",
        deprecated:null,
        name:"traceMethod",
        flags:"",
        description:"\n  Observe a method on an object, logging a stack trace whenever the method is called.\n  <P>\n  Call a second time with identical arguments to disable tracing.\n\n",
        groups:[
            "debug"
        ],
        definingClass:"class:Log",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"object",
                description:"object to observe",
                optional:false,
                type:"object"
            },
            {
                defaultValue:null,
                name:"methodName",
                description:"name of the method to observe",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ColorPicker.colorChanged":{
        ref:"method:ColorPicker.colorChanged",
        deprecated:null,
        name:"colorChanged",
        flags:"",
        description:" Override this method to be kept informed when the ColorPicker changes in real-time \n (for example, if you need to update your own GUI accordingly). Then use the \n getXxxx() methods (for example, ${isc.DocUtils.linkForRef('method:ColorPicker.getBlue','getBlue()')} or \n ${isc.DocUtils.linkForRef('method:ColorPicker.getLuminosity','getLuminosity()')})to obtain current state as required. \n",
        definingClass:"class:ColorPicker",
        type:"method",
        seeAlso:[
            {
                ref:"method:ColorPicker.colorSelected",
                description:null
            }
        ]
    },
    "attr:DataSourceField.xmlAttribute":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Indicates that ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')} should serialize this value as an XML\n attribute.\n <P>\n Note this does not need to be declared in order for DataSource records to be derived from\n XML data: a field will be populated with either an attribute or subelement with matching\n name.",
        groups:[
            "xmlSerialize",
            "componentSchema"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DataSourceField.xmlAttribute",
        valueType:"boolean",
        name:"xmlAttribute",
        definingClass:"class:DataSourceField"
    },
    "method:FormItem.setCriterion":{
        ref:"method:FormItem.setCriterion",
        deprecated:null,
        name:"setCriterion",
        flags:"A",
        description:" Update this form item to reflect a criterion object from within an AdvancedCriteria.\n Called by ${isc.DocUtils.linkForRef('method:DynamicForm.setValuesAsCriteria')} when ${isc.DocUtils.linkForRef('method:FormItem.canEditCriterion')}\n returns true for this item.\n <P>\n Default implementation simply calls ${isc.DocUtils.linkForRef('method:FormItem.setValue')} with the <code>value</code>\n of the criterion passed in\n",
        groups:[
            "criteriaEditing"
        ],
        definingClass:"class:FormItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criterion",
                description:"criterion to edit",
                optional:false,
                type:"Criterion"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.sortByGroupFirst":{
        getter:[
            "getSortByGroupFirst"
        ],
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"If set, whenever grouping is performed by an end user or by a programmatic call to \n ${isc.DocUtils.linkForRef('method:ListGrid.groupBy')}, data is implicitly sorted by all of the grouped columns, in the order \n they were passed to groupBy. Any user-configured sorting is applied after sorting by \n grouped columns.\n <p>\n Sorting by grouped fields will be in ascending or descending order according to whether \n the grid is currently sorted (by any field) in ascending or descending order, defaulting \n to ascending if the grid is not sorted. Implicit sorting by group can be forced to be \n always ascending or always descending by setting ${isc.DocUtils.linkForRef('attr:ListGrid.groupSortDirection')}.\n <p>\n The sorting is \"implicit\" in the sense that the sorting is not shown in the ListGrid \n headers, and not shown in the ${isc.DocUtils.linkForRef('class:MultiSortDialog')} if enabled.  An end user cannot \n currently remove the implicit sorting themselves (except by removing the grouping), \n though it is possible to override it by providing an explicit sort on the group's column.\n Clicking on the grouped field's header reveals the usual sort indicators with all\n the same semantics.\n <p>\n The correct way to remove implicit sorting programmatically is to call \n ${isc.DocUtils.linkForRef('method:ListGrid.setSortByGroupFirst','setSortByGroupFirst(false)')}.\n <p>\n Programmatic calls to ${isc.DocUtils.linkForRef('method:ListGrid.getSort')} will not include the implicit sort in \n the list of return sort specifiers, and calls to ${isc.DocUtils.linkForRef('method:ListGrid.setSort')} will implicitly add \n the sorting by grouped columns before the specified sort.\n <p>\n Note that directly calling ResultSet.getSort() will include the implicit sort \n information.",
        groups:[
            "sorting",
            "grouping"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.sortByGroupFirst",
        valueType:"Boolean",
        name:"sortByGroupFirst",
        definingClass:"class:ListGrid",
        setter:[
            "setSortByGroupFirst"
        ]
    },
    "classAttr:GroupingMessages.bySecondsTitle":{
        ref:"classAttr:GroupingMessages.bySecondsTitle",
        defaultValue:"\"by Seconds\"",
        valueType:"string",
        deprecated:null,
        name:"bySecondsTitle",
        flags:"IRW",
        description:"Title to use for the menu option which groups a time field by seconds.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:GroupingMessages",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:MultiGroupDialog.levelUpButton":{
        ref:"attr:MultiGroupDialog.levelUpButton",
        defaultValue:"null",
        valueType:"AutoChild ImgButton",
        deprecated:null,
        name:"levelUpButton",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:ImgButton')} providing a mechanism for moving existing\n group-levels up in the group configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiGroupPanel.levelUpButtonProperties</code> and \n <code>multiGroupPanel.levelUpButtonDefaults</code>.",
        definingClass:"class:MultiGroupDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DetailViewer.datetimeFormatter":{
        ref:"attr:DetailViewer.datetimeFormatter",
        defaultValue:"null",
        valueType:"DateDisplayFormat",
        deprecated:null,
        name:"datetimeFormatter",
        flags:"IRW",
        description:"Display format to use for fields specified as type 'datetime'.  Default is to use the\n system-wide default long (\"normal\") date time format, configured via\n ${isc.DocUtils.linkForRef('classMethod:Date.setNormalDatetimeDisplayFormat')}.  Specify any\n valid ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} to change the display format for datetimes used by this \n viewer.\n \n May be specified as a function. If specified as  a function, this function will\n be executed in the scope of the Date\n and should return the formatted string.\n \n <P>\n May also be specified at the field level via\n ${isc.DocUtils.linkForRef('attr:DetailViewerField.dateFormatter')}",
        groups:[
            "appearance"
        ],
        definingClass:"class:DetailViewer",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.dateFormatter",
                description:null
            }
        ]
    },
    "attr:PickList.emptyPickListHeight":{
        ref:"attr:PickList.emptyPickListHeight",
        defaultValue:"100",
        valueType:"number",
        deprecated:null,
        name:"emptyPickListHeight",
        flags:"IRW",
        description:"Height for an empty pick list (showing the empty message), if the pick list has no\n records and ${isc.DocUtils.linkForRef('attr:PickList.hideEmptyPickList')} is <code>false</code>.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CubeGrid.innerHeaderBaseStyle":{
        ref:"attr:CubeGrid.innerHeaderBaseStyle",
        defaultValue:"innerHeader",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"innerHeaderBaseStyle",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('attr:Button.baseStyle','baseStyle')} for the buttons in the innermost column header for \n this cubeGrid.",
        groups:[
            "appearance"
        ],
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ToolStripGroup.setShowTitle":{
        ref:"method:ToolStripGroup.setShowTitle",
        deprecated:null,
        name:"setShowTitle",
        flags:"",
        description:" This method forcibly shows or hides this group's \n ${isc.DocUtils.linkForRef('attr:ToolStripGroup.label','title label')} after initial draw.\n \n",
        definingClass:"class:ToolStripGroup",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"showTitle",
                description:"should the title be shown or hidden?",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "class:DrawLinePath":{
        classAttrs:[
        ],
        methods:[
            "method:DrawLinePath.getCenter",
            "method:DrawLinePath.setStartPoint",
            "method:DrawLinePath.setEndPoint",
            "method:DrawLinePath.setControlPoint1",
            "method:DrawLinePath.setControlPoint2",
            "method:DrawLinePath.getBoundingBox",
            "method:DrawLinePath.moveBy",
            "method:DrawLinePath.moveStartPointTo"
        ],
        deprecated:null,
        description:"DrawItem subclass to render a connector between two points. If the points are aligned\n  on one axis, this connector will draw as a straight line. If the points are offset on\n  both axes and there is enough space, the connector will by default draw short horizontal \n  segments from the start and end points, and a diagonal segment connecting the ends of these\n  'tail' segments.  Connector style and orientation defaults may be changed through\n  configuration.",
        treeLocation:[
            "Client Reference/Drawing/DrawItem"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:DrawLinePath.connectorStyle",
            "attr:DrawLinePath.connectorOrientation",
            "attr:DrawLinePath.knobs",
            "attr:DrawLinePath.titleRotationMode",
            "attr:DrawLinePath.showTitleLabelBackground",
            "attr:DrawLinePath.startPoint",
            "attr:DrawLinePath.endPoint",
            "attr:DrawLinePath.controlPoint1",
            "attr:DrawLinePath.controlPoint2",
            "attr:DrawLinePath.tailSize",
            "attr:DrawLinePath.startLeft",
            "attr:DrawLinePath.startTop",
            "attr:DrawLinePath.endLeft",
            "attr:DrawLinePath.endTop",
            "attr:DrawLinePath.endArrow"
        ],
        inheritsFrom:"DrawItem",
        ref:"class:DrawLinePath",
        name:"DrawLinePath"
    },
    "attr:FileItem.shouldSaveValue":{
        ref:"attr:FileItem.shouldSaveValue",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"shouldSaveValue",
        flags:"IR",
        description:"Should this item's value be saved in the form's values and hence returned from\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')}?\n <p>\n <code>shouldSaveValue:false</code> is used to mark formItems which do not correspond to\n the underlying data model and should not save a value into the form's\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','values')}.  Example includes visual separators, password re-type fields,\n or checkboxes used to show/hide other form items.\n <p>\n A <code>shouldSaveValue:false</code> item should be given a value either via\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue')} or by calling\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValue','form.setValue(item, value)')} or \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','formItem.setValue(value)')}.  Providing a value via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','form.values')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','form.setValues()')} \n will automatically switch the item to <code>shouldSaveValue:true</code>.\n <P>\n Note that <ul>\n <li>if an item is shouldSaveValue true, but has no name, a warning is logged, and \n     shouldSaveValue will be set to false.\n </li></ul>",
        groups:[
            "formValues"
        ],
        definingClass:"class:FileItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawLine.showTitleLabelBackground":{
        ref:"attr:DrawLine.showTitleLabelBackground",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"showTitleLabelBackground",
        flags:"IRA",
        description:"If the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabel','titleLabel')} is showing, should the ${isc.DocUtils.linkForRef('attr:DrawItem.titleLabelBackground','titleLabelBackground')}\n be created and placed behind the <code>titleLabel</code>?\n <p>\n This defaults to true for ${isc.DocUtils.linkForRef('class:DrawSector')}s and shapes that are not commonly filled\n (e.g. ${isc.DocUtils.linkForRef('class:DrawLine')}s).",
        definingClass:"class:DrawLine",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:EditTree.rootComponent":{
        ref:"attr:EditTree.rootComponent",
        defaultValue:"null",
        valueType:"PaletteNode",
        deprecated:null,
        name:"rootComponent",
        flags:"IR",
        description:"Root of data to edit.  Must contain the \"type\" property, with the name of a\n valid ${isc.DocUtils.linkForRef('class:DataSource','schema')} or nothing will be able to be dropped on this\n EditContext. A \"liveObject\" property representing the rootComponent is also\n suggested. Otherwise, a live object will be created from the palette node.\n <P>\n Can be retrieved at any time. Use ${isc.DocUtils.linkForRef('method:EditTree.getRootEditNode')} to retrieve the\n ${isc.DocUtils.linkForRef('object:EditNode')} created from the rootComponent.",
        groups:[
            "devTools"
        ],
        definingClass:"class:EditTree",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.dataGradients":{
        ref:"attr:MetricSettings.dataGradients",
        defaultValue:"see below",
        valueType:"Map Gradient",
        deprecated:null,
        name:"dataGradients",
        flags:"IR",
        description:"A dictionary of gradients to use for a series of visual elements representing data (eg columns,\n bars, pie slices), any of which may be adjacent to any other.",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:NavItem.customStyle":{
        ref:"attr:NavItem.customStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"customStyle",
        flags:"IR",
        description:"CSS style name used for this <code>NavItem</code>.  If set and this <code>NavItem</code>\n is a ${isc.DocUtils.linkForRef('attr:NavItem.isHeader','header')}, this overrides the <code>NavPanel</code>'s\n ${isc.DocUtils.linkForRef('attr:NavPanel.headerStyle')}.",
        definingClass:"object:NavItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:StretchImgButton.select":{
        ref:"method:StretchImgButton.select",
        deprecated:null,
        name:"select",
        flags:"",
        description:" Select this object.\n",
        groups:[
            "state"
        ],
        definingClass:"class:StretchImgButton",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:Toolbar.canReorderItems":{
        ref:"attr:Toolbar.canReorderItems",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"canReorderItems",
        flags:"IRWA",
        description:"If true, items can be reordered by dragging on them.",
        groups:[
            "dragndrop"
        ],
        definingClass:"class:Toolbar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ColorPicker.getRed":{
        ref:"method:ColorPicker.getRed",
        deprecated:null,
        name:"getRed",
        flags:"",
        description:" Returns the Red element of the currently-selected color, as an integer from 0-255\n",
        definingClass:"class:ColorPicker",
        returns:{
            description:"red color component",
            type:"int"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:ColorPicker.setRed",
                description:null
            }
        ]
    },
    "attr:MultiSortPanel.maxLevels":{
        ref:"attr:MultiSortPanel.maxLevels",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"maxLevels",
        flags:"IR",
        description:"The maximum number of levels of sorting that can be applied.  Since each sort-property or\n field-name can be used only once in a given multi-sort operation, if no maxLevels value\n or a value larger than the total number of available properties is specified, it will \n default to the total number of available properties.",
        definingClass:"class:MultiSortPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RestDataSource.disableQueuing":{
        ref:"attr:RestDataSource.disableQueuing",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"disableQueuing",
        flags:"IRW",
        description:"If set, disables ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','request queuing')} for this RestDataSource.",
        definingClass:"class:RestDataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:EventCanvas":{
        classAttrs:[
        ],
        ref:"class:EventCanvas",
        methods:[
            "method:EventCanvas.setEvent",
            "method:EventCanvas.getHeaderHTML",
            "method:EventCanvas.getBodyHTML",
            "method:EventCanvas.getInnerHTML"
        ],
        deprecated:null,
        name:"EventCanvas",
        description:"The EventCanvas component is a lightweight ${isc.DocUtils.linkForRef('class:VLayout','layout')} subclass for \n displaying a ${isc.DocUtils.linkForRef('object:CalendarEvent')} in a ${isc.DocUtils.linkForRef('class:CalendarView')}.\n <P>\n Each instance can be ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName','styled')}, and can render a single area,\n or separate ${isc.DocUtils.linkForRef('attr:EventCanvas.showHeader','header')} and ${isc.DocUtils.linkForRef('attr:EventCanvas.showBody','body')}\n areas, for the look of a Window.\n <P>\n The component's close and context buttons, and any necessary resizers, are\n shown on ${isc.DocUtils.linkForRef('attr:EventCanvas.showRolloverControls','rollover')}.",
        treeLocation:[
            "Client Reference/Calendar"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:EventCanvas.showHeader",
            "attr:EventCanvas.showBody",
            "attr:EventCanvas.vertical",
            "attr:EventCanvas.styleName",
            "attr:EventCanvas.event",
            "attr:EventCanvas.calendar",
            "attr:EventCanvas.calendarView",
            "attr:EventCanvas.showLabel",
            "attr:EventCanvas.label",
            "attr:EventCanvas.showGripper",
            "attr:EventCanvas.gripperIcon",
            "attr:EventCanvas.gripper",
            "attr:EventCanvas.headerWrap",
            "attr:EventCanvas.headerHeight",
            "attr:EventCanvas.headerStyle",
            "attr:EventCanvas.bodyStyle",
            "attr:EventCanvas.showRolloverControls"
        ]
    },
    "attr:CheckboxItem.valueMap":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Object defining how the checkbox \"checked\" state will be mapped to the field value.<br>\n Checkboxes only support 2 states. By default a checked checkbox will have\n value <code>true</code>, and an unchecked one will have value <code>false</code>\n (or <code>null</code> if there is no default value and the value has never been set).\n <p>\n A valueMap can modify this in 2 ways:<br>\n - If the desired checked/unchecked values can be resolved to <code>true</code> \n   and <code>false</code> directly in JavaScript, the valueMap may be specified as\n   a 2-element array containing these values. Examples of this would include<br>\n   <code>&nbsp;&nbsp;[0,1]</code>: \n   In this case an unchecked checkbox would have value <code>0</code> and a checked box\n   would have value <code>1</code><br>\n   <code>&nbsp;&nbsp;[null,\"Some String\"]</code>:\n   In this case an unchecked checkbox would have value <code>null</code> and a checked \n    box would have value <code>\"Some String\"</code><br>\n - More arbitrary data values can be resolved to checked / unchecked values via an\n   object mapping the arbitrary data values to display values of <code>true</code> and\n   <code>false</code>. For example:<br>\n   <code>&nbsp;&nbsp;{\"A\":false, \"B\":true}</code><br>\n    In this case an unchecked checkbox would have value \"A\", and a checked box \n    would have value \"B\"\n <p>\n Note: ValueMaps in other formats will be ignored by the CheckboxItem class. To update\n the valueMap at runtime, always use ${isc.DocUtils.linkForRef('method:CheckboxItem.setValueMap')}",
        groups:[
            "valueMap"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:CheckboxItem.valueMap",
        valueType:"object | Array",
        name:"valueMap",
        definingClass:"class:CheckboxItem",
        setter:[
            "setValueMap"
        ]
    },
    "attr:TableView.recordTitleStyle":{
        ref:"attr:TableView.recordTitleStyle",
        defaultValue:"\"recordTitle\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"recordTitleStyle",
        flags:"IRW",
        description:"Default style for title.",
        definingClass:"class:TableView",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawItem.dragStop":{
        ref:"method:DrawItem.dragStop",
        deprecated:null,
        name:"dragStop",
        flags:"",
        description:" Notification fired when the user stops dragging this DrawItem. Will only fire if ${isc.DocUtils.linkForRef('attr:DrawItem.canDrag','canDrag')}\n is true.\n <p>\n Note that if this item is part of a ${isc.DocUtils.linkForRef('class:DrawGroup')}, then the group's ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')}\n setting affects whether this item receives the notification. If useGroupRect is true, then\n this item will <em>not</em> receive the notification. Otherwise, the item receives the\n notification and notification bubbles up to the group.\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:DrawItem",
        returns:{
            description:"false to cancel drag interaction.",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ]
    },
    "group:fill":{
        ref:"group:fill",
        refs:[
            "attr:DrawItem.fillColor",
            "attr:DrawItem.fillGradient",
            "attr:DrawItem.fillOpacity"
        ],
        deprecated:null,
        name:"fill",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "class:TreeMenuButton":{
        classAttrs:[
        ],
        methods:[
        ],
        deprecated:null,
        description:"Button used to display a hierarchical Menu group for representing / selecting tree data.\n <P>\n <i><b>Important Note:</b> this class should not be used directly - it is exposed purely for\n ${isc.DocUtils.linkForRef('group:i18nMessages','i18n reasons.')}</i>",
        treeLocation:[
            "Client Reference/Control"
        ],
        type:"class",
        seeAlso:[
            {
                ref:"class:SelectionTreeMenu",
                description:null
            }
        ],
        classMethods:[
        ],
        attrs:[
            "attr:TreeMenuButton.title",
            "attr:TreeMenuButton.unselectedTitle",
            "attr:TreeMenuButton.emptyMenuMessage",
            "attr:TreeMenuButton.showPath",
            "attr:TreeMenuButton.pathSeparatorString",
            "attr:TreeMenuButton.selectedBaseStyle",
            "attr:TreeMenuButton.dataProperties",
            "attr:TreeMenuButton.treeMenuConstructor",
            "attr:TreeMenuButton.treeMenu"
        ],
        inheritsFrom:"MenuButton",
        ref:"class:TreeMenuButton",
        name:"TreeMenuButton"
    },
    "attr:EventCanvas.showHeader":{
        ref:"attr:EventCanvas.showHeader",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"showHeader",
        flags:"IRW",
        description:"Renders a header DIV above the main body of the event, an area of limited\n height, styled to stand out from the main ${isc.DocUtils.linkForRef('attr:EventCanvas.showBody','body')} of the \n event, and typically showing a ${isc.DocUtils.linkForRef('attr:CalendarEvent.name','name')} or title - like a Window.\n This header area can be styled via ${isc.DocUtils.linkForRef('attr:EventCanvas.headerStyle')} and the HTML it shows \n is retrieved from a call to ${isc.DocUtils.linkForRef('method:EventCanvas.getHeaderHTML','getHeaderHTML()')}.  \n The default is taken from ${isc.DocUtils.linkForRef('attr:Calendar.showEventHeaders')}.",
        definingClass:"class:EventCanvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:HashAlgorithm":{
        ref:"type:HashAlgorithm",
        values:[
            {
                description:"Message Digest algorithm 5",
                value:"\"MD5\""
            },
            {
                description:"Secure Hashing Algorithm (SHA-1)",
                value:"\"SHA\""
            }
        ],
        deprecated:null,
        name:"HashAlgorithm",
        description:"Algorithms to use when hashing field values (see ${isc.DocUtils.linkForRef('attr:DataSourceField.storeWithHash')})",
        type:"type",
        seeAlso:[
        ]
    },
    "method:Canvas.keyUp":{
        ref:"method:Canvas.keyUp",
        deprecated:null,
        name:"keyUp",
        flags:"A",
        description:"\n Executed when a key is released on a focusable widget (${isc.DocUtils.linkForRef('attr:Canvas.canFocus')}: true).\n <P>\n Use ${isc.DocUtils.linkForRef('classMethod:EventHandler.getKey')} to find out the ${isc.DocUtils.linkForRef('type:KeyName','keyName')} of the key that\n was pressed, and use ${isc.DocUtils.linkForRef('classMethod:EventHandler.shiftKeyDown')} and related functions to determine\n whether modifier keys were down.\n\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"attr:Canvas.canFocus",
                description:null
            }
        ]
    },
    "method:SectionStack.getExpandedSections":{
        ref:"method:SectionStack.getExpandedSections",
        deprecated:null,
        name:"getExpandedSections",
        flags:"",
        description:"\n Returns the list of currently expanded sections.  The list items are section IDs.\n\n",
        definingClass:"class:SectionStack",
        returns:{
            description:"list of currently expanded sections",
            type:"List"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:EditTree.addNode":{
        ref:"method:EditTree.addNode",
        deprecated:null,
        name:"addNode",
        flags:"",
        description:" Add a new ${isc.DocUtils.linkForRef('object:EditNode')} to the EditContext, under the specified parent. If the parentNode\n is not provided it will be determined from ${isc.DocUtils.linkForRef('attr:EditContext.defaultParent')}.\n <P>\n The EditContext will interrogate the parent and new nodes to determine what field \n within the parent allows a child of this type, and to find a method to add the newNode's \n liveObject to the parentNode's liveObject.  The new relationship will then be stored\n in the tree of EditNodes.\n <P>\n For example, when a Tab is dropped on a TabSet, the field TabSet.tabs is discovered as\n the correct target field via naming conventions, and the method TabSet.addTab() is likewise \n discovered as the correct method to add a Tab to a TabSet.\n\n",
        definingClass:"class:EditTree",
        returns:{
            description:"newNodenode added",
            type:"EditNode"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newNode",
                description:"new node to be added",
                optional:false,
                type:"EditNode"
            },
            {
                defaultValue:null,
                name:"parentNode",
                description:"parent to add the new node under.",
                optional:true,
                type:"EditNode"
            },
            {
                defaultValue:null,
                name:"index",
                description:"index within the parent's children array",
                optional:true,
                type:"integer"
            },
            {
                defaultValue:null,
                name:"parentProperty",
                description:"the property of the liveParent to which the new node should                                  be added, if not auto-discoverable from the schema",
                optional:true,
                type:"string"
            },
            {
                defaultValue:null,
                name:"skipParentComponentAdd",
                description:"whether to skip adding the liveObject to the liveParent                                           (default false)",
                optional:true,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Array.getItems":{
        ref:"method:Array.getItems",
        deprecated:null,
        name:"getItems",
        flags:"",
        description:" Return the items at a list of specified positions.\n\n",
        groups:[
            "access"
        ],
        definingClass:"object:Array",
        returns:{
            description:"subset of the array, in the same order as itemList",
            type:"array"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"itemList",
                description:"array of positions",
                optional:false,
                type:"List of Number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGridField.valueIcons":{
        ref:"attr:ListGridField.valueIcons",
        defaultValue:"null",
        valueType:"Map<String,String>",
        deprecated:null,
        name:"valueIcons",
        flags:"IRW",
        description:"This property is a mapping from data values for this field to ${isc.DocUtils.linkForRef('type:SCImgURL','urls')} for\n icons to display for those data values.  \n <p>\n For example, given a field named \"status\" with possible values\n \"Normal\", \"Slow\", \"Offline\", the follow definition would show various icons for that\n field:\n <P>\n \n <pre>\n fields : [\n     { name:\"status\",\n       valueIcons: {\n           Normal : \"greenIcon.png\",\n           Slow : \"yellowIcon.png\",\n           Offline : \"redIcon.png\"\n       }\n     },\n     ... other fields ...\n ]\n </pre>\n \n \n <p>\n If a simple value-to-URL mapping is not enough, you can override ${isc.DocUtils.linkForRef('method:ListGrid.getValueIcon')}\n to customize the behavior.  You can even specify an empty <code>valueIcons</code> map\n and use ${isc.DocUtils.linkForRef('method:ListGrid.getValueIcon')} to return arbitrary icons with no fixed mapping.\n <p>\n <code>valueIcons</code> can either be displayed alongside the normal value or can\n replace the normal field value so that only the icon is shown.  See\n ${isc.DocUtils.linkForRef('attr:ListGridField.showValueIconOnly')}.  When placed alongside the value, use\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconOrientation')} to control left- vs right-side placement.\n <P>\n If inline editing is enabled for this field, editors displayed for this field will also\n show valueIcons.  This may be overridden by explicitly setting\n ${isc.DocUtils.linkForRef('attr:ListGridField.editorValueIcons')}.\n <P>\n Note that the following attributes related to valueIcon styling will also be picked up\n by the editor from the ListGridField object unless explicitly specified via the\n equivalent <code>editor_</code> attributes:<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconHeight')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconSize')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconLeftPadding')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconRightPadding')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.imageURLPrefix')}<br>\n ${isc.DocUtils.linkForRef('attr:ListGridField.imageURLSuffix')}\n <P>\n If ${isc.DocUtils.linkForRef('method:ListGridField.valueIconClick')} is defined for the field, a pointer\n cursor will be shown when the user rolls over the valueIcon, and the valueIconClick\n method will execute when the user clicks the icon.",
        groups:[
            "imageColumns"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.expansionFieldImageWidth":{
        ref:"attr:ListGrid.expansionFieldImageWidth",
        defaultValue:"null",
        valueType:"integer",
        deprecated:null,
        name:"expansionFieldImageWidth",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} is set to <code>true</code>, this property\n may be set to govern the width of the expansion image displayed to indicate whether a row\n is expanded. If unset, the expansionField image will be sized to match the\n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanImageWidth')} for this grid.",
        groups:[
            "expansionField"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:EditPane.serializeEditNodesAsJSON":{
        ref:"method:EditPane.serializeEditNodesAsJSON",
        deprecated:null,
        name:"serializeEditNodesAsJSON",
        flags:"",
        description:" Serialize the provided ${isc.DocUtils.linkForRef('object:EditNode','EditNodes')} to a JSON\n representation of ${isc.DocUtils.linkForRef('object:PaletteNode','PaletteNodes')}. Note that the\n EditNodes must have been added to this EditContext. The result can be\n supplied to ${isc.DocUtils.linkForRef('method:EditPane.addPaletteNodesFromJSON','addPaletteNodesFromJSON()')} to\n recreate the EditNodes.\n\n",
        definingClass:"class:EditPane",
        returns:{
            description:"a JSON representtion of the provided EditNodes",
            type:"String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"nodes",
                description:"EditNodes to be serialized",
                optional:false,
                type:"Array of EditNode"
            },
            {
                defaultValue:null,
                name:"settings",
                description:"Additional serialization settings",
                optional:true,
                type:"SerializationSettings"
            }
        ],
        seeAlso:[
        ]
    },
    "method:SectionStack.getSections":{
        ref:"method:SectionStack.getSections",
        deprecated:null,
        name:"getSections",
        flags:"",
        description:"\n Returns a list of all ${isc.DocUtils.linkForRef('attr:SectionStackSection.name','section names')} in the order in which \n they appear in the SectionStack.\n\n",
        definingClass:"class:SectionStack",
        returns:{
            description:"list of all section names in the order in which they appear in the SectionStack.",
            type:"List"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGrid.hiliteIconRightPadding":{
        ref:"attr:ListGrid.hiliteIconRightPadding",
        defaultValue:"2",
        valueType:"number",
        deprecated:null,
        name:"hiliteIconRightPadding",
        flags:"IRW",
        description:"How much padding should there be on the right of ${isc.DocUtils.linkForRef('attr:ListGrid.hiliteIcons','hilite icons')} by default?\n Can be overridden at the field level",
        groups:[
            "hiliting"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:RegressionLineType":{
        ref:"type:RegressionLineType",
        values:[
            {
                description:"linear regression",
                value:"\"line\""
            },
            {
                description:"polynomial regression",
                value:"\"polynomial\""
            }
        ],
        deprecated:null,
        name:"RegressionLineType",
        description:"Supported regression algorithms for fitting the data points of a scatter plot.",
        type:"type",
        seeAlso:[
        ]
    },
    "attr:Menu.defaultWidth":{
        ref:"attr:Menu.defaultWidth",
        defaultValue:"150",
        valueType:"int",
        deprecated:null,
        name:"defaultWidth",
        flags:"IRW",
        description:"The default menu width.",
        groups:[
            "sizing"
        ],
        definingClass:"class:Menu",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FilterClause.operatorPickerTitle":{
        ref:"attr:FilterClause.operatorPickerTitle",
        defaultValue:"\"Operator\"",
        valueType:"String",
        deprecated:null,
        name:"operatorPickerTitle",
        flags:"IR",
        description:"The title for the operator-picker select-item.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FilterClause",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Portlet.closeClick":{
        ref:"method:Portlet.closeClick",
        deprecated:null,
        name:"closeClick",
        flags:"",
        description:" Handles a click on the close button of this portlet.  The default implementation\n calls ${isc.DocUtils.linkForRef('method:Portlet.close')}.\n <P>\n Override this method if you want\n other actions to be taken.\n \n Custom implementations may call <code>close()</code> to trigger the default behavior.\n",
        definingClass:"class:Portlet",
        type:"method",
        seeAlso:[
        ]
    },
    "group:monthViewEvents":{
        ref:"group:monthViewEvents",
        refs:[
            "method:Calendar.dayBodyClick",
            "method:Calendar.dayHeaderClick",
            "method:Calendar.eventChanged",
            "method:Calendar.eventRemoved",
            "method:Calendar.eventRemoveClick",
            "method:Calendar.eventMoved",
            "method:Calendar.eventResized"
        ],
        deprecated:null,
        name:"monthViewEvents",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:MultiSortDialog.addLevelButtonTitle":{
        ref:"attr:MultiSortDialog.addLevelButtonTitle",
        defaultValue:"\"Add Level\"",
        valueType:"String",
        deprecated:null,
        name:"addLevelButtonTitle",
        flags:"IR",
        description:"The title-text to appear on the addLevelButton.  \n <P>\n Note, this is a passthrough property which, when set, is passed through to the \n ${isc.DocUtils.linkForRef('class:MultiSortPanel','MultiSortPanel')} contained in this dialog.  You only need to\n consider the properties on the MultiSortPanel for i18n.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiSortDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:EventHandler.getDragRect":{
        ref:"classMethod:EventHandler.getDragRect",
        deprecated:null,
        name:"getDragRect",
        flags:"",
        description:" During a drag with ${isc.DocUtils.linkForRef('attr:Canvas.dragAppearance','dragAppearance')} of either \"target\" or\n \"outline\", returns the page-relative coordinates of whatever element is being dragged.\n <P>\n Calling this method allows you to write drag and drop logic that works identically even if\n <code>dragAppearance</code> is subsequently changed.\n\n",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:EventHandler",
        returns:{
            description:"global (page-relative) coordinates and size of the dragged element, as a                       4-element array [left,top,width,height], or null if not dragging",
            type:"Rect"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "method:Canvas.removePeer":{
        ref:"method:Canvas.removePeer",
        deprecated:null,
        name:"removePeer",
        flags:"",
        description:" Remove a peer from this Canvas\n",
        groups:[
            "containment"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"peer",
                description:"Peer to be removed from this canvas",
                optional:false,
                type:"Canvas"
            },
            {
                defaultValue:null,
                name:"name",
                description:"If this peer was assigned a name when added via addPeer(), it should                        be passed in here to ensure no reference is kept to the peer",
                optional:true,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.exportWrapHeaderTitles":{
        ref:"attr:ListGrid.exportWrapHeaderTitles",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"exportWrapHeaderTitles",
        flags:"IRW",
        description:"When exporting data to Excel/OpenOffice format using ${isc.DocUtils.linkForRef('method:ListGrid.exportData')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData')}, whether titles in the\n ${isc.DocUtils.linkForRef('attr:ListGrid.header','ListGrid header')} and ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')} should be\n allowed to wrap.\n <p>\n Excel will wrap at the column boundary automatically; for explicit control over wrapping,\n insert \"&lt;br&gt;\" tags into your titles.\n <p>\n See also ${isc.DocUtils.linkForRef('attr:ListGrid.exportFieldWidths')} for replicating the widths of fields in the exported\n spreadsheet.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:NavItem.id":{
        ref:"attr:NavItem.id",
        defaultValue:"null",
        valueType:"identifier",
        deprecated:null,
        name:"id",
        flags:"IR",
        description:"An optional ID for this <code>NavItem</code>.  If specified, this must be unique within\n the <code>NavPanel</code>.",
        definingClass:"object:NavItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tree.titleProperty":{
        ref:"attr:Tree.titleProperty",
        defaultValue:"\"title\"",
        valueType:"string",
        deprecated:null,
        name:"titleProperty",
        flags:"IRW",
        description:"Name of the property on a ${isc.DocUtils.linkForRef('object:TreeNode')} that holds the title of the node as it should be\n shown to the user.  Default value is \"title\".  See ${isc.DocUtils.linkForRef('attr:TreeNode.title')} for usage.",
        definingClass:"class:Tree",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ResultSet.findNextIndex":{
        ref:"method:ResultSet.findNextIndex",
        deprecated:null,
        name:"findNextIndex",
        flags:"",
        description:" Like ${isc.DocUtils.linkForRef('method:List.findNextIndex')}.  Checks only loaded rows and will not trigger a fetch.\n",
        groups:[
            "access",
            "find"
        ],
        definingClass:"class:ResultSet",
        returns:{
            description:"index of the first matching value or -1 if not found.",
            type:"int"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"startIndex",
                description:"first index to consider.",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"propertyName",
                description:"property to match; or, if a function is passed, the predicate function to call;\n or, if an object is passed, set of properties and values to match.",
                optional:false,
                type:"String or Function or Object or AdvancedCriteria"
            },
            {
                defaultValue:null,
                name:"value",
                description:"value to compare against (if <code>propertyName</code> is a string) or the value of <code>this</code> when the predicate function is invoked (if\n <code>propertyName</code> is a function)",
                optional:true,
                type:"any"
            },
            {
                defaultValue:null,
                name:"endIndex",
                description:"last index to consider (inclusive).",
                optional:true,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "group:debug":{
        ref:"group:debug",
        refs:[
            "method:Class.getCallTrace",
            "method:Class.getStackTrace",
            "method:Class.echoLeaf",
            "method:Class.echo",
            "method:Class.echoAll",
            "class:Log",
            "classMethod:Class.getCallTrace",
            "classMethod:Log.getCallTrace",
            "classMethod:Class.getStackTrace",
            "classMethod:Log.getStackTrace",
            "classMethod:Class.echoLeaf",
            "classMethod:Log.echoLeaf",
            "classMethod:Class.echo",
            "classMethod:Log.echo",
            "classMethod:Class.echoAll",
            "classMethod:Log.echoAll",
            "classMethod:Log.getMessages",
            "classMethod:Log.show",
            "classMethod:Log.traceLogMessage",
            "classMethod:Log.traceMethod",
            "classMethod:Log.timeMethod",
            "classMethod:isc.showConsole"
        ],
        deprecated:null,
        name:"debug",
        description:"Support for debugging and logging",
        type:"group",
        seeAlso:[
        ]
    },
    "attr:StatefulCanvas.icon":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Optional icon to be shown with the button title text.  \n <P>\n Specify as the partial URL to an image, relative to the imgDir of this component.",
        groups:[
            "buttonIcon"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:StatefulCanvas.icon",
        valueType:"SCImgURL",
        name:"icon",
        definingClass:"class:StatefulCanvas",
        setter:[
            "setIcon"
        ]
    },
    "attr:ListGrid.headerSpanVAlign":{
        ref:"attr:ListGrid.headerSpanVAlign",
        defaultValue:"\"center\"",
        valueType:"vAlign",
        deprecated:null,
        name:"headerSpanVAlign",
        flags:"IR",
        description:"Default alignment for ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')} with no\n ${isc.DocUtils.linkForRef('attr:HeaderSpan.valign')} specified.",
        groups:[
            "headerSpan"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TileGrid.getDragData":{
        ref:"method:TileGrid.getDragData",
        deprecated:null,
        name:"getDragData",
        flags:"",
        description:"\n During a drag-and-drop interaction, this method returns the set of records being dragged out\n of the component.  In the default implementation, this is the list of currently selected\n records.<p>\n \n This method is consulted by ${isc.DocUtils.linkForRef('method:ListGrid.willAcceptDrop')}.\n\n",
        groups:[
            "dragging",
            "data"
        ],
        definingClass:"class:TileGrid",
        returns:{
            description:"Array of ${isc.DocUtils.linkForRef('object:Record')}s that are currently selected.",
            type:"Array of Record"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"source",
                description:"source component from which the records will be transferred",
                optional:false,
                type:"DataBoundComponent"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TextItem.usePlaceholderForHint":{
        ref:"attr:TextItem.usePlaceholderForHint",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"usePlaceholderForHint",
        flags:"IRA",
        description:"If ${isc.DocUtils.linkForRef('attr:TextItem.showHintInField','showing the hint in field')} and if supported by the browser, should the HTML5\n <a href='http://www.whatwg.org/specs/web-apps/current-work/multipage/forms.html#attr-input-placeholder' target='_blank'><code>placeholder</code> attribute</a>\n be used to display the hint within the field? If set to <code>false</code>, then use of\n the <code>placeholder</code> attribute is disabled and an alternative technique to display\n the hint in-field is used instead.\n <p>\n The HTML5 <code>placeholder</code> attribute is supported in the following major browsers:\n <ul>\n <li>Chrome 4+</li>\n <li>Firefox 4+</li>\n <li>Internet Explorer 10+</li>\n <li>Safari 5+</li>\n <li>Opera 11.50+</li>\n <li>Android 2.1+ <code>WebView</code> (used by the stock Browser app and when\n     ${isc.DocUtils.linkForRef('group:phonegapIntegration','packaging with PhoneGap')})</li>\n <li>Mobile Safari for iOS 3.2+</li>\n </ul>\n <p>\n In browsers other than the above, in-field hints are implemented via a different technique.\n <p>\n Note that placeholder behavior is known to differ in Internet Explorer and certain old\n versions of the above browsers due to a recent change in the HTML5 specification regarding\n the <code>placeholder</code> attribute. Under the old rules, the placeholder is cleared\n when the element is focused. In the latest HTML5 spec as published by WHATWG, the placeholder\n is still displayed when the element is focused as long as the value is an empty string.\n <p>\n <h3>Styling the placeholder</h3>\n While there isn't a standard way to style the placeholder text, Chrome, Firefox,\n Internet Explorer, and Safari provide vendor-prefixed pseudo-classes and/or pseudo-elements\n that can be used in CSS selectors:\n <table border=\"1\">\n <tr>\n   <th>Browser</th>\n   <th>Pseudo-class or pseudo-element</th>\n </tr>\n <tr>\n   <td>Chrome, Safari</td>\n   <td><code>::-webkit-input-placeholder</code></td>\n </tr>\n <tr>\n   <td>Firefox 4 - 18</td>\n   <td><code>:-moz-placeholder</code></td>\n </tr>\n <tr>\n   <td>Firefox 19+</td>\n   <td><code>::-moz-placeholder</code></td>\n </tr>\n <tr>\n   <td>Internet Explorer</td>\n   <td><code>:-ms-input-placeholder</code></td>\n </tr>\n </table>\n <p>\n Note that unlike other browsers, Firefox 19+ applies opacity:0.4 to the placeholder text.\n See <a href='https://bugzilla.mozilla.org/show_bug.cgi?id=556145' target='_blank'>Bug 556145 - Placeholder text default style should use opacity instead of GrayText</a>\n <p>\n Because browsers are required to ignore the entire rule if a selector is invalid,\n separate rules are needed for each browser. For example:\n <pre>::-webkit-input-placeholder {\n    color: blue;\n    opacity: 1;\n&#125;\n:-moz-placeholder {\n    color: blue;\n    opacity: 1;\n&#125;\n::-moz-placeholder {\n    color: blue;\n    opacity: 1;\n&#125;\n:-ms-input-placeholder {\n    color: blue;\n    opacity: 1;\n&#125;</pre>\n <p>\n If using <a href='http://sass-lang.com' target='_blank'>Sass</a>, it may be useful to utilize Sass'\n <a href='http://sass-lang.com/documentation/file.SASS_REFERENCE.html#parent-selector' target='_blank'>parent selector feature</a>.\n For example:\n <pre>.myCustomItem,\n.myCustomItemRTL,\n.myCustomItemDisabled,\n.myCustomItemDisabledRTL,\n.myCustomItemError,\n.myCustomItemErrorRTL,\n.myCustomItemFocused,\n.myCustomItemFocusedRTL,\n.myCustomItemHint,\n.myCustomItemHintRTL,\n.myCustomItemDisabledHint,\n.myCustomItemDisabledHintRTL {\n    // ...\n\n    &amp;::-webkit-input-placeholder {\n        color: blue;\n        opacity: 1;\n    }\n    &amp;:-moz-placeholder {\n        color: blue;\n        opacity: 1;\n    }\n    &amp;::-moz-placeholder {\n        color: blue;\n        opacity: 1;\n    }\n    &amp;:-ms-input-placeholder {\n        color: blue;\n        opacity: 1;\n    }\n&#125;</pre>\n <p>\n If using <a href='http://compass-style.org' target='_blank'>Compass</a>, the\n <a href='http://compass-style.org/reference/compass/css3/user_interface/#mixin-input-placeholder' target='_blank'><code>input-placeholder</code> mixin</a>\n that was added in version 1.0 can further simplify the code to style the placeholder text\n For example:\n <pre>.myCustomItem,\n.myCustomItemRTL,\n.myCustomItemDisabled,\n.myCustomItemDisabledRTL,\n.myCustomItemError,\n.myCustomItemErrorRTL,\n.myCustomItemFocused,\n.myCustomItemFocusedRTL,\n.myCustomItemHint,\n.myCustomItemHintRTL,\n.myCustomItemDisabledHint,\n.myCustomItemDisabledHintRTL {\n    // ...\n\n    &#64;include input-placeholder {\n        color: blue;\n        opacity: 1;\n    }\n&#125;</pre>\n <h3>Accessibility concerns</h3>\n The HTML5 specification notes that a placeholder should not be used as a replacement\n for a title. The placeholder is intended to be a <em>short</em> hint that assists the user\n who is entering a value into the empty field. The placeholder can be mistaken by some\n users for a pre-filled value, particularly in Internet Explorer because the same color\n is used, and the placeholder text color may provide insufficient contrast, particularly\n in Firefox 19+ because of the default 0.4 opacity. Furthermore, not having a title reduces\n the hit area available for setting focus on the item.",
        groups:[
            "appearance"
        ],
        definingClass:"class:TextItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.hint",
                description:null
            }
        ]
    },
    "method:EditProxy.setCanSelectChildren":{
        ref:"method:EditProxy.setCanSelectChildren",
        deprecated:null,
        name:"setCanSelectChildren",
        flags:"A",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:EditProxy.canSelectChildren','canSelectChildren')}.\n",
        definingClass:"class:EditProxy",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"canSelect",
                description:"the new canSelectChildren",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Criterion.end":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"End value of a criterion with an operator of type <code>\"valueRange\"</code>.",
        groups:[
            "advancedFilter"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Criterion.end",
        valueType:"any",
        name:"end",
        definingClass:"object:Criterion"
    },
    "attr:Splitbar.src":{
        ref:"attr:Splitbar.src",
        defaultValue:"null",
        valueType:"SCImgURL",
        deprecated:null,
        name:"src",
        flags:"IR",
        description:"The base URL for the image. \n <P>\n The ${isc.DocUtils.linkForRef('type:State')} for the component will be combined with this URL using the\n same approach as described in ${isc.DocUtils.linkForRef('attr:Img.src')}.\n Then the image segment ${isc.DocUtils.linkForRef('attr:StretchItem.name','name')} as specified by each ${isc.DocUtils.linkForRef('object:StretchItem')}\n is added.\n <P>\n For example, for a stretchImg in \"Over\" state with a <code>src</code> of \"button.png\"\n and a segment name of \"stretch\", the resulting URL would be \"button_Over_stretch.png\".",
        groups:[
            "appearance"
        ],
        definingClass:"class:Splitbar",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:StretchImg.hSrc",
                description:null
            },
            {
                ref:"attr:StretchImg.vSrc",
                description:null
            }
        ]
    },
    "method:CellSelection.cellIsSelected":{
        ref:"method:CellSelection.cellIsSelected",
        deprecated:null,
        name:"cellIsSelected",
        flags:"",
        description:" Return true if a particular item is selected\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CellSelection",
        returns:{
            description:"true == object is selected                      false == object is not selected",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row index of the cell to check",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column index of the cell to check",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Button.showFocused":{
        ref:"attr:Button.showFocused",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showFocused",
        flags:"IRW",
        description:"Should we visibly change state when the canvas receives focus?  If\n ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is <code>true</code>, then <b><code>\"over\"</code></b>\n will be used to indicate focus. Otherwise a separate <b><code>\"focused\"</code></b> state\n will be used.",
        groups:[
            "state"
        ],
        definingClass:"class:Button",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.xAxisMetric":{
        ref:"attr:FacetChart.xAxisMetric",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"xAxisMetric",
        flags:"IR",
        description:"For scatter charts only, the \"id\" of the metric facet value to use for the x-axis.\n <p>\n The default x-axis metric is the second value of the metric facet.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SectionStackSection.controls":{
        ref:"attr:SectionStackSection.controls",
        examples:[
            "${isc.DocUtils.linkForExampleId('sectionControls')}"
        ],
        defaultValue:"null",
        valueType:"Array of Canvas",
        deprecated:null,
        name:"controls",
        flags:"IR",
        description:"Custom controls to be shown on top of this section header.\n <P>\n These controls are shown in the ${isc.DocUtils.linkForRef('attr:SectionHeader.controlsLayout')}.\n <P>\n Note that this is an init-time property. If you need to dynamically change what \n controls are displayed to the user, we would recommend embedding the\n controls in a Layout or similar container. \n This will allow you to show/hide or add/remove members at runtime\n by manipulating the existing control(s) set up at init time.",
        definingClass:"object:SectionStackSection",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ColorPicker.redFieldPrompt":{
        ref:"attr:ColorPicker.redFieldPrompt",
        defaultValue:"\"The Red component of the selected color\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"redFieldPrompt",
        flags:"IR",
        description:"The text to show when the mouse hovers over the 'Red' field in the complex chooser.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawItem.hideAllKnobs":{
        ref:"method:DrawItem.hideAllKnobs",
        deprecated:null,
        name:"hideAllKnobs",
        flags:"",
        description:" Hides all control knobs for this drawItem. Updates ${isc.DocUtils.linkForRef('attr:DrawItem.knobs')} to remove\n all knobTypes and clears any drawn knobs. \n",
        definingClass:"class:DrawItem",
        type:"method",
        seeAlso:[
        ]
    },
    "method:FacetChart.getDataLabelHoverHTML":{
        ref:"method:FacetChart.getDataLabelHoverHTML",
        examples:[
            "${isc.DocUtils.linkForExampleId('drillCharting')}"
        ],
        deprecated:null,
        name:"getDataLabelHoverHTML",
        flags:"",
        description:" Called when the mouse hovers over a data label, that is, a text label showing values from\n the first facet.  For example, the labels underneath the X-axis of a column chart,\n labelling each column.\n\n",
        definingClass:"class:FacetChart",
        returns:{
            description:"hover text to be shown.  Return null to avoid a hover being shown",
            type:"HTMLString"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetValue",
                description:"facetValue that was hovered",
                optional:false,
                type:"FacetValue"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:RPCManager.getQueueTransactionId":{
        ref:"classMethod:RPCManager.getQueueTransactionId",
        deprecated:null,
        name:"getQueueTransactionId",
        flags:"",
        description:" Returns the id of the current transaction (a queue of requests).\n <P>\n This method will return null if no requests are currently queued, even if\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue')} has been called.\n \n",
        definingClass:"class:RPCManager",
        returns:{
            description:"the transactionNum of the current transaction, or null",
            type:"Integer"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "attr:FormItem.errorCellClassName":{
        ref:"attr:FormItem.errorCellClassName",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:"As of SmartClient version 5.5 deprecated in favor of ${isc.DocUtils.linkForRef('attr:FormItem.cellStyle')}",
        name:"errorCellClassName",
        flags:"IR",
        description:"CSS class for a form item's cell when a validation error is showing.",
        groups:[
            "appearance"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:EventHandler.ctrlKeyDown":{
        ref:"classMethod:EventHandler.ctrlKeyDown",
        deprecated:null,
        name:"ctrlKeyDown",
        flags:"",
        description:"\t\t\tReturn true if the control key is being held down.\n\t\t\tNote that this is only set reliably for keyboard events.\n\n",
        groups:[
            "keyboardEvents"
        ],
        definingClass:"class:EventHandler",
        returns:{
            description:"true == control key is down",
            type:"Boolean"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "classMethod:Canvas.getSnapPosition":{
        ref:"classMethod:Canvas.getSnapPosition",
        deprecated:null,
        name:"getSnapPosition",
        flags:"",
        description:"  Return the position for <code>snapper</code> to be placed in order to \"snap to\" an edge or\n  corner of <code>target</code>, in the same sense as ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')}.\n  <p>\n  Default for <code>snapEdge</code> is the <b>opposite</b> edge or corner from\n  <code>snapTo</code>.  For example, <code>snapTo</code> of \"T\" (top) means <code>snapEdge</code>\n  will default to \"B\" (bottom), so the returned coordinates would place <code>snapper</code>\n  centered along the top edge of <code>target</code>.  A <code>snapTo</code> of \"TL\" (top left)\n  means <code>snapEdge</code> will default to \"BR\" (bottom right), so the returned coordinates\n  would place the bottom right of <code>snapper</code> at the top left corner of\n  <code>target</code>.\n  <p>\n  <code>target</code> can be passed as either a Canvas or 4-element Array giving the top, left,\n  width and height of the target.  \n  <code>snapper</code> can be passed as either a Canvas or a\n  two-element Array of the width and height of the rectangle to be placed.\n\n",
        definingClass:"class:Canvas",
        returns:{
            description:"the position for <code>snapper</code> to be placed in order to \"snap to\" an edge or  corner of <code>target</code>",
            type:"Point"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"target",
                description:"canvas to snap to",
                optional:false,
                type:"Canvas | Array of Integer"
            },
            {
                defaultValue:null,
                name:"snapTo",
                description:"edge against which to snap",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"snapper",
                description:"canvas being snapped",
                optional:false,
                type:"Canvas | Array of Integer"
            },
            {
                defaultValue:null,
                name:"snapEdge",
                description:"optional edge to snapTo. Default is the <b>opposite</b> edge or corner from  <code>snapTo</code>",
                optional:true,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "method:SectionStack.expandSection":{
        ref:"method:SectionStack.expandSection",
        examples:[
            "${isc.DocUtils.linkForExampleId('sectionsExpandCollapse')}"
        ],
        deprecated:null,
        name:"expandSection",
        flags:"",
        description:" \n Expands a section or sections.  This action shows all the items assigned to the section.\n If the section is currently hidden, it is shown first and then expanded.  Calling this\n method is equivalent to the user clicking on the SectionHeader of a collapsed section.\n This method is called when the user clicks on SectionHeaders\n to expand / collapse sections and so may be overridden to act as a notification method\n for the user expanding or collapsing sections.\n\n",
        definingClass:"class:SectionStack",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"sections",
                description:"Section(s) to expand.  For this parameter, you can pass the position \n                      of the section in the SectionStack, the name of the section, or a\n                      List of section names/positions.",
                optional:false,
                type:"int | String | Array of int | Array of String"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"callback to fire when the section has been expanded.",
                optional:true,
                type:"ExpandSectionCallback"
            }
        ],
        seeAlso:[
            {
                ref:"method:SectionStack.showSection",
                description:null
            },
            {
                ref:"attr:SectionStack.scrollSectionIntoView",
                description:null
            }
        ]
    },
    "attr:IconButton.valign":{
        ref:"attr:IconButton.valign",
        defaultValue:"null",
        valueType:"VerticalAlignment",
        deprecated:null,
        name:"valign",
        flags:"IRW",
        description:"Vertical alignment of this button's content.  If unset, \n ${isc.DocUtils.linkForRef('attr:IconButton.orientation','vertical buttons')} are top-aligned and horizontal\n buttons center-aligned by default.",
        groups:[
            "appearance"
        ],
        definingClass:"class:IconButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:Log.logWarn":{
        ref:"classMethod:Log.logWarn",
        deprecated:null,
        name:"logWarn",
        flags:"",
        description:" A common usage of ${isc.DocUtils.linkForRef('classMethod:Class.logWarn')} is to call the method directly on\n the Log class.\n",
        definingClass:"class:Log",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"message",
                description:"message to log",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"category",
                description:"category to log in",
                optional:true,
                type:"String"
            }
        ],
        seeAlso:[
            {
                ref:"classMethod:Log.logDebug",
                description:"for usage info"
            }
        ]
    },
    "method:ListGrid.getEditValue":{
        ref:"method:ListGrid.getEditValue",
        deprecated:null,
        name:"getEditValue",
        flags:"",
        description:"\n Returns the current temporary locally stored edit value for some field within a record\n being edited.\n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"edit value for the field in question",
            type:"any"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"index of the row for which the editValue should be returned",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"index of the field, or fieldName, for which value should be                              returned",
                optional:false,
                type:"number | string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Window.showResizer":{
        ref:"attr:Window.showResizer",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showResizer",
        flags:"IRW",
        description:"If true, show a button in the lower right corner that allows users to resize the Window.\n Note that the resizer will only be displayed if the footer is showing for the window\n (${isc.DocUtils.linkForRef('attr:Window.showFooter')}) and ${isc.DocUtils.linkForRef('attr:Window.canDragResize')} is true.",
        groups:[
            "appearance",
            "dragging"
        ],
        definingClass:"class:Window",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawItem.resizeBy":{
        ref:"method:DrawItem.resizeBy",
        deprecated:null,
        name:"resizeBy",
        flags:"",
        description:" Resize the shape by the specified deltas.\n",
        definingClass:"class:DrawItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dX",
                description:"number of pixels to resize by horizontally",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"dY",
                description:"number of pixels to resize by vertically",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Calendar.rowTitleFrequency":{
        ref:"attr:Calendar.rowTitleFrequency",
        defaultValue:"60",
        valueType:"Integer",
        deprecated:null,
        name:"rowTitleFrequency",
        flags:"IR",
        description:"A minute value that indicates which rows should show times in vertical views, like \n ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day')} and ${isc.DocUtils.linkForRef('attr:Calendar.weekView','week')}.  The default of 60 minutes \n shows titles on the first row of each hour.  The value provided must be a multiple of \n ${isc.DocUtils.linkForRef('attr:Calendar.minutesPerRow','minutesPerRow')} and be no larger than 60.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ComboBoxItem.specialValues":{
        ref:"attr:ComboBoxItem.specialValues",
        defaultValue:"null",
        valueType:"ValueMap",
        deprecated:null,
        name:"specialValues",
        flags:"IR",
        description:"A set of \"special\" values such as \"All\", \"None\" or \"Invalid\" that do not appear in the normal\n ${isc.DocUtils.linkForRef('type:ValueMap')} or in the data returned by the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.optionDataSource')}.\n <p>\n Like other uses of ${isc.DocUtils.linkForRef('type:ValueMap')}, either a list of values or a mapping from stored to\n display value can be provided.\n <p>\n These values can either be shown at the top of the list of values (in the order specified), or\n can be shown in a separate, non-scrolling region - the setting\n ${isc.DocUtils.linkForRef('attr:SelectItem.separateSpecialValues','separateSpecialValues')} controls this. Note that data \n paging can only be used if <code>separateSpecialValues</code> is enabled.\n <p>\n If <code>specialValues</code> are configured, ${isc.DocUtils.linkForRef('attr:SelectItem.allowEmptyValue','allowEmptyValue')} is ignored - an empty\n value, if desired, must be included in the <code>specialValues</code>.  To provide a\n <code>specialValue</code> which clears the value of the field, use the special constant\n ${isc.DocUtils.linkForRef('classAttr:PickList.emptyStoredValue')}.\n <p>\n <code>specialValues</code> can also be used to take a value that <i>does</i> appear in the\n normal data and redundantly display it at the top of the list to make it more accessible.  Note\n that in this case it is expected that the special value appears <i>both</i> at the top of the\n list <i>and</i> in it's normal position in the list, so this works best with\n ${isc.DocUtils.linkForRef('attr:SelectItem.separateSpecialValues','separateSpecialValues')} mode enabled.\n <p>\n Also, if an ${isc.DocUtils.linkForRef('attr:ComboBoxItem.optionDataSource')} is used, ${isc.DocUtils.linkForRef('attr:ComboBoxItem.specialValues')} that appear in the normal\n dataset <i>will</i> be updated by automatic ${isc.DocUtils.linkForRef('group:cacheSync','cache synchronization')} (if \n the ${isc.DocUtils.linkForRef('attr:ComboBoxItem.displayField')} is updated).  However when using a distinct ${isc.DocUtils.linkForRef('attr:ComboBoxItem.valueField')} and\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.displayField')}, you are required to provide ${isc.DocUtils.linkForRef('attr:ComboBoxItem.specialValues')} as a map (there is no\n support for ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues','fetchMissingValues')} automatically fetching appropriate display values).\n <P>\n Note that specialValues are not supported in conjunction with ${isc.DocUtils.linkForRef('class:MultiComboBoxItem')}. Whereas with\n ${isc.DocUtils.linkForRef('attr:SelectItem.multiple','selectItem.multiple:true')}, specialValues will never be normal values \n that may be selected. So, specialValues should have options such as \"Select All\", \"Select None\" and others.",
        definingClass:"class:ComboBoxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CheckboxItem.showUnsetImage":{
        ref:"attr:CheckboxItem.showUnsetImage",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showUnsetImage",
        flags:"IRA",
        description:"Determines what image to display when the value for this checkbox is unset.\n Set to true to display the ${isc.DocUtils.linkForRef('attr:CheckboxItem.unsetImage')} for null values, or false to\n use the ${isc.DocUtils.linkForRef('attr:CheckboxItem.uncheckedImage')} for both null and explicitly unchecked values.\n <P>\n If this attribute is not set, the ${isc.DocUtils.linkForRef('attr:CheckboxItem.unsetImage')} for null values if \n ${isc.DocUtils.linkForRef('attr:CheckboxItem.allowEmptyValue')} is true for this item, otherwise the unchecked\n image will be used.",
        definingClass:"class:CheckboxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FieldPicker.availableFieldsGrid":{
        ref:"attr:FieldPicker.availableFieldsGrid",
        defaultValue:"null",
        valueType:"AutoChild ListGrid",
        deprecated:null,
        name:"availableFieldsGrid",
        flags:"IR",
        description:"A ${isc.DocUtils.linkForRef('class:ListGrid','ListGrid')} showing the list of available fields.",
        definingClass:"class:FieldPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Calendar.getEventLane":{
        ref:"method:Calendar.getEventLane",
        deprecated:null,
        name:"getEventLane",
        flags:"",
        description:" Returns the ${isc.DocUtils.linkForRef('object:Lane','lane')} associated with the passed event, in the passed view\n",
        definingClass:"class:Calendar",
        returns:{
            description:"the lane associated with the passed event",
            type:"Lane"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"event",
                description:"the event to get the lane for",
                optional:false,
                type:"CalendarEvent"
            },
            {
                defaultValue:null,
                name:"view",
                description:"the view to get the lane object from",
                optional:true,
                type:"CalendarView"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ColorPicker.colorButtonSize":{
        ref:"attr:ColorPicker.colorButtonSize",
        defaultValue:"20",
        valueType:"number",
        deprecated:null,
        name:"colorButtonSize",
        flags:"IR",
        description:"Width and height of the basic color boxes (they are always square, and they are\n all the same size).",
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Layout.minMemberSize":{
        ref:"attr:Layout.minMemberSize",
        defaultValue:"1",
        valueType:"int",
        deprecated:null,
        name:"minMemberSize",
        flags:"IRW",
        description:"Minimum size, in pixels, below which flexible-sized members should never be shrunk, even\n if this requires the Layout to overflow.  \n <p>\n Does not apply to members given a fixed size in pixels - such members will never be\n shrunk below their specified size in general.",
        groups:[
            "layoutPolicy"
        ],
        definingClass:"class:Layout",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:compression":{
        ref:"group:compression",
        refs:[
        ],
        deprecated:null,
        name:"compression",
        description:"Compression helps reduce the sizes of various data fetched from the server.  Most modern web\n browsers can handle compressed responses of certain content types. The time it takes to\n decompress these responses on a client system is negligible compared to the time saved\n by reducing the number of bits on the wire, especially for slow connections.\n <p>\n If you're not using the SmartClient Java back-end, there are several compression solutions\n available, depending on your server of choice.  Microsoft's IIS has built-in compression\n capability, please check the reference manual for details.  If you're using Apache, you can\n use <a href='http://sourceforge.net/projects/mod-gzip/' target='_blank'>mod_gzip</a> or \n use <a href='http://httpd.apache.org/docs/2.0/mod/mod_deflate.html' target='_blank'>mod_deflate</a>.  Some\n servlet containers also natively support dynamic compression.\n <p>\n The SmartClient Java back-end supports three types of response compression:\n <ul>\n <li>Pre-compressed static content served via the ISC FileDownload servlet.\n <li>On-the-fly compression of arbitrary content using the CompressionFilter.\n <li>Automatic on-the-fly compression of DSRequest, RPCRequest and DataSourceLoader responses.\n </ul>\n <u>Serving pre-compressed files</u>\n <p>\n To serve pre-compressed static content via FileDownload, register the FileDownload servlet\n in your web.xml as follows:\n <pre>\n     &lt;servlet&gt;\n       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;\n       &lt;servlet-class&gt;com.isomorphic.servlet.FileDownload&lt;/servlet-class&gt;\n     &lt;/servlet&gt;\n </pre>\n Then map any resource that you want to serve compressed to the FileDownload servlet in your\n web.xml.  Typically, you'll want to serve all SmartClient modules compressed.  You can do so\n by adding the following servlet-mapping directive to your web.xml:\n <pre>\n     &lt;servlet-mapping&gt;\n       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;\n       &lt;url-pattern&gt;/isomorphic/system/modules/*&lt;/url-pattern&gt;\n     &lt;/servlet-mapping&gt;\n </pre>\n Finally, you'll need to create pre-compressed versions of your files alongside the\n uncompressed versions.  If you're using the FileAssembler mechanism, it can create\n pre-compressed files for you automatically.  For all other files, you can use any program\n that uses the gzip encoding.  The compressed file must have exactly the same filename as the\n uncompressed version, with a '.gz' extension.  Note that it's important that both the\n compressed and uncompressed versions be present alongside each other because there are cases\n where serving compressed content is not possible (for example HTTP 1.0 requests) - for those\n situations it's important that the uncompressed files be available to be served to the\n client.  The FileDownload filter automatically detects whether or not compression is\n possible.\n <p>\n <u>Dynamic Compression</u>\n <p>\n Dynamic Compression requires the optional Network Performance module.  To use Dynamic\n Compression, register the CompressionFilter filter in your web.xml as follows:\n <pre>\n     &lt;filter&gt;\n         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;\n         &lt;filter-class&gt;com.isomorphic.servlet.CompressionFilter&lt;/filter-class&gt;\n     &lt;/filter&gt;\n </pre>\n Then map any resource that you want dynamically compressed to this filter.  Note that the\n CompressionFilter knows the mime types that are compressible and will automatically ignore\n any stream that sets a content-encoding header, and it automatically figures out if the\n current request is an include or forward (and doesn't compress in that case), so it's safe\n to simply map it to all resources as follows:\n <pre>\n     &lt;filter-mapping&gt;\n         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;\n         &lt;url-pattern&gt;/*&lt;/url-pattern&gt;\n     &lt;/filter-mapping&gt;\n </pre>\n You can register the CompressionFilter anywhere in your filter chain, but be aware that\n if any filters in front wrap and inspect the HttpServletResponse output stream, they will\n be inspecting the compressed response.  Filters are typically applied in the order in which\n they are listed in web.xml and it is advised to keep them that way, otherwise it may result \n in unexpected behavior. For example, if CompressionFilter would be listed after the \n JSSyntaxScannerFilter, the last one would stop working, since it relies on uncompressed data.\n <p>\n <u>Automatic Compression of DSRequest, RPCRequest and DataSourceLoader responses</u>\n <p>\n By default, SmartClient Server compresses the responses to all ${isc.DocUtils.linkForRef('class:DSRequest')}s, \n ${isc.DocUtils.linkForRef('class:RPCRequest')}s and <code>DataSourceLoader</code> requests, whether or not the \n <code>CompressionFilter</code> is registered.  If you want to switch off this automatic \n compression, add the following line to your <code>server.properties</code> file:<pre>\n    servlet.compress: false\n </pre>\n <u>Compressible mime types and compatibility</u>\n <p>\n The FileDownload servlet and CompressionFilter filter can serve the following mime-types\n compressed: text/html, text/xml, application/x-javascript, text/javascript, text/ecmascript,\n image/svg+xml, application/javascript, application/json.  If your files are not being compressed, make sure your \n servlet container has a mime type mapping that identifies it as one of the above file types.\n <p>\n Compression for the mime types listed above is supported on all browsers supported by\n SmartClient.  There is one exception: compression of javascript files for IE versions older\n than IE6 Service Pack 2 requires that the CompressionFilter be registered to dynamically\n compress the page that loads these javascript files.",
        treeLocation:[
            "Optional Modules/Network Performance"
        ],
        type:"group",
        title:"Compression",
        seeAlso:[
        ]
    },
    "classAttr:Dialog.Prompt":{
        ref:"classAttr:Dialog.Prompt",
        defaultValue:"dialog instance properties",
        valueType:"Dialog Properties",
        deprecated:null,
        name:"Prompt",
        flags:"A",
        description:"The \"Prompt\" object on the dialog class is a singleton Dialog instance.\n  The Prompt is used to show text to the user in a modal fashion - it will expand to show\n  all the text that you put into it.\n  By default this Dialog has no end-user controls and is expected to be programmatically\n  dismissed.<br>\n  Common use-case: During server-interactions, the Prompt will be used to display a suitable\n  wait message, and suppress user input.<br><br>\n\n Notes:<br>\n  Because this is a singleton object, properties set on the Prompt directly will persist each\n  time it is shown.<br>\n  Developers should use the <code>showPrompt()</code> and <code>clearPrompt()</code> methods\n  to show and hide the prompt rather than manipulating the prompt directly.",
        groups:[
            "Prompting"
        ],
        definingClass:"class:Dialog",
        type:"classAttr",
        seeAlso:[
            {
                ref:"classMethod:isc.showPrompt",
                description:null
            },
            {
                ref:"classMethod:isc.clearPrompt",
                description:null
            }
        ]
    },
    "attr:DrawPane.drawingHeight":{
        ref:"attr:DrawPane.drawingHeight",
        examples:[
            "${isc.DocUtils.linkForExampleId('ZoomAndPan')}"
        ],
        defaultValue:"1000",
        valueType:"int",
        deprecated:null,
        name:"drawingHeight",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('attr:DrawPane.canDragScroll','canDragScroll')} is enabled, this is the height of the area\n in viewbox coordinates that can be accessed through drag-scrolling.",
        definingClass:"class:DrawPane",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:List.intersect":{
        ref:"method:List.intersect",
        deprecated:null,
        name:"intersect",
        flags:"",
        description:" Return the list of items that are in both this list and the passed-in list(s).\n\n",
        groups:[
            "arrayMath"
        ],
        definingClass:"interface:List",
        returns:{
            description:"intersection",
            type:"List"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"lists",
                description:"lists to intersect with",
                optional:false,
                type:"all List arguments"
            }
        ],
        seeAlso:[
        ]
    },
    "method:FormItem.enable":{
        ref:"method:FormItem.enable",
        deprecated:null,
        name:"enable",
        flags:"",
        description:" Set this item to be enabled at runtime.\n",
        groups:[
            "enable"
        ],
        definingClass:"class:FormItem",
        type:"method",
        seeAlso:[
            {
                ref:"attr:FormItem.disabled",
                description:null
            }
        ]
    },
    "group:i18n":{
        ref:"group:i18n",
        refs:[
        ],
        deprecated:null,
        name:"i18n",
        description:"<b><u>Internationalizing SmartClient Applications</u></b>\n <p>\n Internationalizing a SmartClient application involves creating locale-specific\n versions of all strings, images, and possibly colors.  In some cases, component layout may\n be affected as well (for example date field order differs between some locales).\n <p>\n <u><b>Character Encodings</b></u>\n <p>\n In order to deliver content in different languages to the browser and have it be displayed\n correctly, it is important that the browser and server agree on the character encoding being\n used to send the page.  \n <p>\n Generally speaking, you can use whatever character encoding you prefer, so long as\n you're consistent about serving your files to the browser with exactly the same encoding\n as was used to save the file to disk.  Keep in mind though that the character encoding you\n choose must be supported by all browsers you intend to support.  Isomorphic recommends that,\n where possible, you use the UTF-8 encoding.  Regardless of which character encoding you\n choose, keep in mind that for the browser to correctly display non-ASCII characters, you\n <b>must</b> explicitly set the character encoding of your page to match the encoding you\n used to save the file.  Browsers have built-in heuristics to guess the character encoding,\n but they can't be relied upon to work 100% of the time.\n <p>\n There are two ways to explicitly tell the browser what character\n encoding is being used for a given page.  One is to set the \"Content-Type\" HTTP header, for\n example:\n <pre>\n Content-Type: text/html; charset=UTF-8\n </pre>\n If you're using JSP on the back-end, you can set this header as follows:\n <pre>\n &lt;%@ page contentType=\"text/html; charset=UTF-8\"%&gt;\n </pre>\n Or using Java Servlet APIs in a Servlet as follows:\n <pre>\n response.setContentType(\"text/html; charset=UTF-8\");\n </pre>\n Note that the latter needs to be done before any content is written to the response output\n stream.\n <p>\n The other approach to setting the content encoding is to use an HTML META tag to embed it\n in the page itself (note that this applies to HTML documents only).  The META tag must go\n inside the &lt;HEAD&gt; HTML element - e.g. as follows:\n <pre>\n &lt;HEAD&gt;\n &lt;META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\"&gt;\n &lt;/HEAD&gt;\n </pre>\n In addition, for a .html or other static (non-.jsp) file, you must also ensure that the file\n itself is saved in UTF-8 encoding.  Advanced text editors (including the Eclipse IDE) can\n show you the encoding of a text file and allow you to change it.  In Eclipse this is in the\n Preferences area (search for \"Encoding\") and UTF-8 is <b>not the default</b> for .html\n files, and should be changed.\n <P>\n Isomorphic recommends that you follow <b>all</b> of the above approaches for maximum\n compatibility.  For example, if you omit the META tag approach, pages saved by the user\n using the browser save function may not render correctly when subsequently read from disk\n because HTTP headers are not available in that context.  Conversely, not providing the\n HTTP header or not saving the file in UTF-8 can result in application servers delivering the\n file in the encoding in which it is saved, or in their own default and incorrect content\n encoding.\n <p>\n If you're using a given character encoding pervasively in your pages, you can also configure\n your web server or application server to use that character encoding as the default for all\n pages of a given mime type or some other criteria (depending on the capability of your\n server) - for example on a per-directory basis.\n <p>\n For more information on character encodings, character sets, and working with HTML, please\n see W3C's tutorial here:\n <a href='http://www.w3.org/International/tutorials/tutorial-char-enc/' target='_blank'>http://www.w3.org/International/tutorials/tutorial-char-enc/</a>\n <p>\n <b>NOTE: Default Encoding</b>\n <p>\n As mentioned above, Isomorphic recommends the use of UTF-8 encoding.  However, it is \n not possible to configure some servlet engines to do this by default.  Both Tomcat and Jetty \n default to the ISO-8859-1 character set (commonly known as Latin-1), even if the Java VM \n specifies a different encoding (the Tomcat documentation claims that this behavior is a \n requirement of the Servlet specification).\n <p>\n To work around this, we change charset encoding to UTF-8 on every request/response that \n goes through two core Isomorphic servlets: <code>IDACall</code> and <code>DataSourceLoader</code>.\n If you need to change this, you can do so by adding <code>init-param</code> settings to your\n <code>web.xml</code> file.  Please see the Javadocs for those two servlets for examples of \n how to do this.\n <p>\n <u><b>Framework Message Localization</b></u>\n <p>\n SmartClient components include standard prompts and error messages in various cases, and all\n such messages support localization.\n <P>\n \n Language packs are included in the directory smartclientSDK/isomorphic/locales.  To load a\n language pack, simply include the desired locale via a\n standard HTML &lt;script src=&gt; tag, for example: \n <pre>\n    &lt;SCRIPT SRC=\"isomorphic/locales/frameworkMessages_pt.properties\"&gt;&lt;/SCRIPT&gt;\n </pre>\n .. to load the Portuguese locale. \n <p>\n Alternatively can use the <code>locale</code> attribute on the <code>loadISC</code> or\n <code>loadModules</code> jsp tags:\n <pre>\n   &lt;isomorphic:loadISC skin=\"Enterprise\" locale=\"pt\"/&gt; \n </pre>\n Or, if you have the ${isc.DocUtils.linkForRef('group:networkPerformance','Network Performance')}, you can use the\n ${isc.DocUtils.linkForRef('classMethod:FileLoader.loadLocale')}/${isc.DocUtils.linkForRef('classMethod:FileLoader.cacheLocale')} APIs:\n <pre>\n   isc.FileLoader.loadLocale(\"pt\");\n </pre>\n <p>\n To see various locales, have a look at the \n ${isc.DocUtils.linkForExampleId('changeLocales', 'Localization example')}.\n \n \n <P>\n If you find that the language pack you are using has any incorrect or missing translations,\n or you want to add a new language pack, please visit\n <a href='http://forums.smartclient.com/showthread.php?t=9987' target='_blank'>this forums thread</a> for\n instructions on how to contribute translations so that they will be added to future\n SmartClient builds.\n <P>\n You can alternatively maintain your own private additions or overrides to the default\n language packs.\n \n A complete list of standard messages is presented ${isc.DocUtils.linkForRef('group:i18nMessages','here')}.<br>\n To customize these messages, use ${isc.DocUtils.linkForRef('method:Class.addProperties')} or\n ${isc.DocUtils.linkForRef('classMethod:Class.addClassProperties')} to override default values at the instance or class level\n respectively.  For example, the class property\n ${isc.DocUtils.linkForRef('classAttr:RPCManager.timeoutErrorMessage')} is displayed to the user in a warning dialog\n when a SmartClient operation fails to complete.  This can be modified using the\n ${isc.DocUtils.linkForRef('classMethod:Class.addClassProperties')} method, as follows:\n <pre>\n isc.RPCManager.addClassProperties({timeoutErrorMessage:\"Custom Timeout Message\"});\n </pre>\n \n \n <p>\n <u><b>Application Message Localization</b></u>\n <p>\n \n Text such as button titles typically appears in the middle of JavaScript code:\n <pre>\n     isc.Button.create({ title: \"Click me!\"});\n </pre>\n If you are on the Java platform and your JavaScript code appears in a .jsp, you can use the\n JSTL Core package (Java Server Pages Standard Tag Library) to replace that static \"Click\n me!\" text with a localized reference.  This can be done as follows:\n <pre>\n     &lt;%@ taglib prefix=\"fmt\" uri=\"/WEB-INF/fmt.tld\" %&gt;\n     &lt;SCRIPT&gt;\n     isc.Button.create({ title: &lt;fmt:message key=\"buttonTitle\"&gt; });\n     &lt;/SCRIPT&gt;\n </pre>\n Assuming you've set the current Locale and provided a resource bundle with the relevant\n translated text, the above would create a button with a title that comes from the locale-specific\n bundle you provided.  For more information, see Sun's i18n tutorial:\n <a href='http://java.sun.com/docs/books/tutorial/i18n/' target='_blank'>http://java.sun.com/docs/books/tutorial/i18n/</a> and the JSTL home page:\n <a href='http://java.sun.com/products/jsp/jstl/' target='_blank'>http://java.sun.com/products/jsp/jstl/</a>.\n <P>\n Note that this approach does not imply that your JavaScript must appear in the midst of an\n HTML page.  A .jsp file can be used to return a pure JavaScript response via just removing\n the &lt;SCRIPT&gt; tags in the example above, and targetting the .jsp with a &lt;SCRIPT\n SRC=&gt; tag from another .jsp or .html file.\n <P>\n A second common technique is to load internationalized messages as a JavaScript Object\n mapping from a message name to the internationalized message.  For example, if your messages\n are stored in Java .properties format, you could load your .properties file as a standard Java\n <a href='http://docs.oracle.com/javase/6/docs/api/java/util/Properties.html' target='_blank'>Properties object</a>, \n and use the server-side com.isomorphic.js.JSTranslater.toJSVariable() API to output the\n properties as a JavaScript variable.\n <P>\n If the variable name chosen was 'i18nMessages', code to make use of the .properties data\n would look like:\n <pre>\n     isc.Button.create({ title: i18nMessages[\"buttonTitle\"] });\n </pre>\n <P>\n Approaches for non-Java platforms are similar, and generally any approach that works for\n HTML or JavaScript files works with SmartClient.  See the end of this section for pointers\n to additional resources.\n \n \n <p>\n <u><b>Localizing Server-side Error Messages</b></u>\n <p>\n If you are providing error messages from server-side code, use standard Java techniques to\n determine the locale (<code>servletRequest.getLocale()</code>) and load ResourceBundles.\n Note that if you are using ${isc.DocUtils.linkForRef('attr:Validator.serverObject','DMI validation')}, the\n HttpServletRequest is available via the standard ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} approach: just\n declare it as an additional parameter, and it is provided.\n <p>\n <u><b>Support for Right-to-Left (RTL) languages</b></u>\n <p>\n SmartClient includes support for RTL languages.  To enable, simply set\n <code>dir=\"rtl\"</code> on the HTML element:\n <pre>\n    &lt;HTML dir=\"rtl\"&gt;\n </pre>\n ListGrid columns, horizontal layouts, scrolling directions, etc will reverse order\n automatically.\n <p>\n Because RTL in some cases requires additional media files, RTL is only supported for the\n Enterprise, EnterpriseBlue and Graphite skins.\n <p>\n <u><b>DataSource and Component XML localization</b></u>\n <p>\n Please see the separate article on \n ${isc.DocUtils.linkForRef('group:dataSourceLocalization','DataSource and Component XML Localization')}\n <p>\n <u><b>Localized Number and Currency Formatting</b></u>\n <p>\n Please see the separate article on \n ${isc.DocUtils.linkForRef('group:localizedNumberFormatting','Localized Number Formatting')}\n <p>\n \n <u><b>Image, CSS localization</b></u>\n <p>\n Most SmartClient components use a mixture of text, CSS and images to render.  If you wish to\n provide locale-specific images or use locale-specific CSS, you can create localized copies\n of a SmartClient skin named after the locale and modify images as you see fit.  A skin is\n specified at load time using either the <code>skin</code> attribute of the\n <code>&lt;isomorphic:loadISC&gt;</code> tag or by loading the skin\n directly using a script tag like so: &lt;SCRIPT SRC=/isomorphic/skins/[skin]/load_skin.js&gt;.\n If you're using the <code>loadISC</code> tag, you can specify a locale-specific skin like so:\n <pre>\n &lt;isomorphic:loadISC skin=\"[localeName]\"/&gt;\n </pre>\n Or you can use a script tag like so:\n <pre>\n &lt;SCRIPT SRC=/isomorphic/skins/[localeName]/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n Where the <code>[localeName]</code> is the name of the current locale - you'll have this in the\n current page context as you'll need it to use the JSTL &lt;fmt:setLocale&gt; tag.\n <p>\n \n Resources:\n <p>\n <b><u>Java</u></b>\n <ul>\n <li>Sun's i18n tutorial: <a href='http://java.sun.com/docs/books/tutorial/i18n/' target='_blank'>http://java.sun.com/docs/books/tutorial/i18n/</a>\n <li>JSTL home page: <a href='http://java.sun.com/products/jsp/jstl/' target='_blank'>http://java.sun.com/products/jsp/jstl/</a>\n <li>Apache JSTL \"Getting Started\": \n     <a href='http://jakarta.apache.org/taglibs/doc/standard-doc/standard/GettingStarted.html' target='_blank'>http://jakarta.apache.org/taglibs/doc/standard-doc/standard/GettingStarted.html</a>\n <li>Apache taglibs: <a href='http://jakarta.apache.org/taglibs/' target='_blank'>http://jakarta.apache.org/taglibs/</a>\n </ul>\n <p>\n\n <b><u>.NET</u></b>\n <ul>\n <li>MSDN Developer Resource: \"Developing World-Ready Applications\":\n <a href='http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpguide/html/cpcondesigningglobalapplications.asp' target='_blank'>http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpguide/html/cpcondesigningglobalapplications.asp</a>\n </ul>\n\n <b><u>PHP</u></b>\n <ul>\n <li>PHP Gettext manual: <a href='http://us2.php.net/gettext' target='_blank'>http://us2.php.net/gettext</a>\n <li>O'Reilly Gettext tutorial: <a href='http://www.onlamp.com/pub/a/php/2002/06/13/php.html' target='_blank'>http://www.onlamp.com/pub/a/php/2002/06/13/php.html</a>\n </ul>\n <p>\n\n <b><u>Perl</u></b>\n <ul>\n <li>Perl, Unicode and i18n FAQ: <a href='http://rf.net/~james/perli18n.html' target='_blank'>http://rf.net/~james/perli18n.html</a>\n </ul>",
        treeLocation:[
            "Concepts"
        ],
        type:"group",
        title:"Internationalization and Localization",
        seeAlso:[
        ]
    },
    "attr:ListGridField.escapeHTML":{
        ref:"attr:ListGridField.escapeHTML",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"escapeHTML",
        flags:"IRW",
        description:"By default HTML values in ListGrid cells will be interpreted by the browser.\n Setting this flag to true will causes HTML characters to be escaped, meaning the\n raw value of the field (for example <code>\"&lt;b&gt;AAA&lt;/b&gt;\"</code>) is displayed\n to the user rather than the interpreted HTML (for example <code>\"<b>AAA</b>\"</code>)",
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ActiveXControl.classID":{
        ref:"attr:ActiveXControl.classID",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"classID",
        flags:"IR",
        description:"This sets the value of the classID property on the object.  This is meant to give you\n  complete control over the generated HTML.  In practice it may be more handy to set the uuid\n  property on this object and let the classID be generated from that.",
        definingClass:"class:ActiveXControl",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ActiveXControl.uuid",
                description:null
            }
        ]
    },
    "attr:SelectItem.filterLocally":{
        ref:"attr:SelectItem.filterLocally",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"filterLocally",
        flags:"IRA",
        description:"If <code>filterLocally</code> is set for this item, and this item is showing options \n from a dataSource, fetch the entire set of options from the server, and use these values\n to map the item value to the appropriate display value. Also use <code>\"local\"</code>\n type filtering on drop down list of options.\n <P>\n This means data will only be fetched once from the server, and then filtered on the\n client.\n <P>\n Note - when this property is set to <code>false</code>, filtering will still be \n performed on the client if a complete set of data for some criteria has been cached\n by a fetch, and a subsequent fetch has more restrictive criteria. To explicitly\n disable client-side filtering set the ${isc.DocUtils.linkForRef('attr:SelectItem.useClientFiltering')} property to false.",
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.filterLocally",
                description:null
            }
        ]
    },
    "method:FacetChart.chartDrawn":{
        ref:"method:FacetChart.chartDrawn",
        deprecated:null,
        name:"chartDrawn",
        flags:"",
        description:" Called when all elements of the chart (data lines / shapes, gradations, legend, labels etc)\n have completed drawing.  \n <P>\n See ${isc.DocUtils.linkForRef('method:FacetChart.chartBackgroundDrawn')} for usage information.\n\n",
        definingClass:"class:FacetChart",
        type:"method",
        seeAlso:[
        ]
    },
    "method:List.set":{
        ref:"method:List.set",
        deprecated:null,
        name:"set",
        flags:"",
        description:" Change the array element at a particular position.\n <P>\n set() can be used to expand the length of the list.\n\n",
        groups:[
            "modification"
        ],
        definingClass:"interface:List",
        returns:{
            description:"previous value at that position, or <code>undefined</code> if not found",
            type:"object"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"pos",
                description:"position in the list to change",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"obj",
                description:"new value for that position",
                optional:false,
                type:"object"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:SelectItem.hiliteTextColor":{
        ref:"attr:SelectItem.hiliteTextColor",
        defaultValue:"\"white\"",
        valueType:"string",
        deprecated:"As of SmartClient version 5.5, if ${isc.DocUtils.linkForRef('attr:SelectItem.showFocused')} is true,  styling will be updated for this form item on focus. The hiliting effect can therefore\n  be achieved via ${isc.DocUtils.linkForRef('attr:SelectItem.textBoxStyle')} and ${isc.DocUtils.linkForRef('attr:SelectItem.controlStyle')} \n  instead.",
        name:"hiliteTextColor",
        flags:"IRWA",
        description:"Text color to apply to the select item's selected value when the SelectItem \n receives focus, if <code>hiliteOnFocus</code> is true.",
        definingClass:"class:SelectItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:VisualBuilder.defaultApplicationMode":{
        ref:"attr:VisualBuilder.defaultApplicationMode",
        defaultValue:"\"edit\"",
        valueType:"ApplicationMode",
        deprecated:null,
        name:"defaultApplicationMode",
        flags:"IR",
        description:"The default application mode.  Note, this can be changed through the UI - see \n ${isc.DocUtils.linkForRef('attr:VisualBuilder.showModeSwitcher','showModeSwitcher')}",
        definingClass:"class:VisualBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:HeaderItem.startRow":{
        ref:"attr:HeaderItem.startRow",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"startRow",
        flags:"IRW",
        description:"these items are in a row by themselves by default",
        groups:[
            "appearance"
        ],
        definingClass:"class:HeaderItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Hilite.htmlAfter":{
        ref:"attr:Hilite.htmlAfter",
        defaultValue:"null",
        valueType:"HTML",
        deprecated:null,
        name:"htmlAfter",
        flags:"IR",
        description:"HTML to append to the end of cell values where this hilite is applied.",
        groups:[
            "hiliting"
        ],
        definingClass:"object:Hilite",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSource.showPrompt":{
        serverDS:"allowed",
        ref:"attr:DataSource.showPrompt",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showPrompt",
        flags:"IRW",
        description:"Whether RPCRequests sent by this DataSource should enable\n ${isc.DocUtils.linkForRef('attr:RPCRequest.showPrompt')} in order to block user interactions until the\n request completes.  \n <p>\n DataSource requests default to blocking UI interaction because, very often, if the user\n continues to interact with an application that is waiting for a server response, some\n kind of invalid or ambiguous situation can arise.\n <p>\n Examples include pressing a \"Save\" button a second time before the first save completes,\n making further edits while edits are still being saved, or trying to initiate editing on\n a grid that hasn't loaded data.\n <p>\n Defaulting to blocking the UI prevents these bad interactions, or alternatively, avoids\n the developer having to write repetitive code to block invalid interactions on every\n screen.\n <p>\n If an operation should ever be non-blocking, methods that initiate DataSource requests\n (such as ${isc.DocUtils.linkForRef('method:DataSource.fetchData')}) will generally have a\n <code>requestProperties</code> argument allowing <code>showPrompt</code> to be set to\n false for a specific request.",
        definingClass:"class:DataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Calendar.getWorkdayEnd":{
        ref:"method:Calendar.getWorkdayEnd",
        deprecated:null,
        name:"getWorkdayEnd",
        flags:"",
        description:" Returns the end of the working day on the passed date.  By default, this method returns\n the value of ${isc.DocUtils.linkForRef('attr:Calendar.workdayEnd','workdayEnd')}.\n",
        definingClass:"class:Calendar",
        returns:{
            description:"any parsable time-string",
            type:"String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"date",
                description:"a Date instance",
                optional:false,
                type:"Date"
            },
            {
                defaultValue:null,
                name:"laneName",
                description:"the name of the relevant lane - only passed for dayView with                             showDayLanes: true",
                optional:true,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Layout.stackZIndex":{
        ref:"attr:Layout.stackZIndex",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"stackZIndex",
        flags:"IR",
        description:"For use in conjunction with ${isc.DocUtils.linkForRef('attr:Layout.memberOverlap')}, controls the z-stacking order of\n members.\n <P>\n If set to \"lastOnTop\", members stack from the first member at bottom to the last member\n at top. If set to \"firstOnTop\", members stack from the last member at bottom to the\n first member at top.",
        definingClass:"class:Layout",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:SelectionStyle":{
        ref:"type:SelectionStyle",
        values:[
            {
                description:"don't select at all",
                value:"Selection.NONE"
            },
            {
                description:"select only one item at a time",
                value:"Selection.SINGLE"
            },
            {
                description:"select one or more items",
                value:"Selection.MULTIPLE"
            },
            {
                description:"select one or more items as a toggle \t\t\t\t\t\t\t\t  so you don't need to hold down control keys to select \n                                  more than one object",
                value:"Selection.SIMPLE"
            }
        ],
        deprecated:null,
        name:"SelectionStyle",
        description:"Different styles of selection that a list, etc. might support",
        groups:[
            "selection"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:DrawItem.moveBy":{
        ref:"method:DrawItem.moveBy",
        deprecated:null,
        name:"moveBy",
        flags:"",
        description:" Move the shape by the specified deltas for the left and top coordinate.\n\n",
        definingClass:"class:DrawItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dX",
                description:"change to left coordinate in pixels",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"dY",
                description:"change to top coordinate in pixels",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:RPCManager.cancelQueue":{
        ref:"classMethod:RPCManager.cancelQueue",
        deprecated:null,
        name:"cancelQueue",
        flags:"",
        description:" Cancel a queue of requests (also called a transaction).\n <P>\n If a transactionId is passed, that transaction will be cancelled, otherwise, the current \n (not yet sent) transaction is cancelled.  You can retrieve the id of the current \n transaction, if there is one, by calling \n ${isc.DocUtils.linkForRef('classMethod:RPCManager.getQueueTransactionId','getQueueTransactionId()')} before the\n transaction has been sent.\n <P>\n Note that cancelQueue() calls ${isc.DocUtils.linkForRef('classMethod:RPCManager.clearTransaction','clearTransaction()')}\n and attempts to abort the request.  However, note also that whilst cancelling a \n transaction that has already been sent will not necessarily stop the HTTP request that \n has been issued - this is only possible on some browsers and with some transports - it \n will reliably cause SmartClient to ignore any response returned by the server and not \n fire any callbacks that have been passed in.\n <P>\n Also, take into account that this method removes all queued requests from the current queue,\n but queueing is still active, so if you also want to disable queuing you should call\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','startQueue(false)')}.\n\n",
        definingClass:"class:RPCManager",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"transactionNum",
                description:"transactionId of the queue.",
                optional:true,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.sortFieldAscendingText":{
        ref:"attr:ListGrid.sortFieldAscendingText",
        defaultValue:"\"Sort Ascending\"",
        valueType:"string",
        deprecated:null,
        name:"sortFieldAscendingText",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, this\n attribute will be shown as the menu item title to sort a field in ascending order.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.requires":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Indicates that the specified ${isc.DocUtils.linkForRef('type:VelocityExpression')} must be true for a user to access\n this operationBinding.\n <P>\n As with ${isc.DocUtils.linkForRef('attr:OperationBinding.requiresRole')}, if there an operationBinding that is the\n default operationBinding for the operationType, its <code>requires</code> expression is\n assumed to apply to all other operationBindings of the same type unless they explicitly set\n <code>requires=\"\"</code>\n <P>\n ${isc.DocUtils.linkForRef('attr:DataSource.requires')}, if specified, applies before\n <code>operationBinding.requires</code> is evaluated.  In this case, both <code>requires</code>\n expressions must be true for the request to be accepted.",
        groups:[
            "auth",
            "declarativeSecurity"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:OperationBinding.requires",
        valueType:"VelocityExpression",
        name:"requires",
        definingClass:"class:OperationBinding"
    },
    "method:ListGridField.getRecordSummary":{
        ref:"method:ListGridField.getRecordSummary",
        deprecated:null,
        name:"getRecordSummary",
        flags:"A",
        description:" Only applies to ${isc.DocUtils.linkForRef('type:ListGridFieldType','summary-type')} fields. If specified, this\n method will be called to generate the record summary value to be displayed for each row\n in this field.  When this method is called, current values for other \n ${isc.DocUtils.linkForRef('type:ListGridFieldType','summary-type')} fields have not yet been stored on the record, but\n are accessible via ${isc.DocUtils.linkForRef('method:ListGrid.getRecordSummary')}.\n <P>\n Note that if specified, this is called instead of making use of the\n ${isc.DocUtils.linkForRef('attr:ListGridField.recordSummaryFunction')}.\n <P>\n If ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} or ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary')} is true, this\n field's value in the summary row[s] will still be calculated by calling this method.\n In this case, the record object passed in will contain summary values for each field.\n If custom handling is required for this case, it may be detected by checking the\n record object's ${isc.DocUtils.linkForRef('attr:ListGridRecord.isGroupSummary')} and ${isc.DocUtils.linkForRef('attr:ListGridRecord.isGridSummary')}\n attributes.\n",
        definingClass:"object:ListGridField",
        returns:{
            description:"summary value to display",
            type:"any"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"record",
                description:"record for which a summary is being generated",
                optional:false,
                type:"ListGridRecord"
            },
            {
                defaultValue:null,
                name:"field",
                description:"this field",
                optional:false,
                type:"ListGridField"
            },
            {
                defaultValue:null,
                name:"grid",
                description:"the grid",
                optional:false,
                type:"ListGrid"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.getFilterEditorCriteria":{
        ref:"method:ListGrid.getFilterEditorCriteria",
        deprecated:null,
        name:"getFilterEditorCriteria",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is true, this method will return the criteria currently\n displayed in the <code>filterEditor</code>. Note that these values may differ from the\n criteria returned by ${isc.DocUtils.linkForRef('method:ListGrid.getCriteria')} if the filter editor values have been modified\n without performing an actual filter.\n",
        definingClass:"class:ListGrid",
        returns:{
            description:"criteria currently displayed in the filterEditor",
            type:"Criteria or AdvancedCriteria"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"omitHiddenFields",
                description:"By default this method will include criteria applied to   fields, including criteria that are not actually visible/editable in the filterEditor for the\n   grid. Pass in this parameter to get only values for visible fields returned.",
                optional:true,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "group:clientOnlyDataSources":{
        ref:"group:clientOnlyDataSources",
        refs:[
            "attr:DataSource.clientOnly"
        ],
        deprecated:null,
        name:"clientOnlyDataSources",
        description:"For prototyping purposes, a \"client-only\" DataSource can be created that has no permanent\n storage and never contacts the server, instead using a set of test data to respond to\n requests in the same manner as a server-based DataSource might.\n <P>\n The client-side interface to a client-only DataSource is identical to a server-based\n DataSource, including asynchronous responses, so that a client-only DataSource can be\n replaced by a server-based DataSource without code changes.  The only difference is that\n changes to records belonging to the DataSource persist only until the page is reloaded.\n <p>\n Client-only DataSources allow you to create a complete prototype application in an .html\n file that does not require a server.\n <p>\n \n The <code>clientOnly</code> property is specified to create a client-only DataSource, and\n the <code>testData</code> property should contain the test dataset, as an Array of Objects,\n one per DataSource record.  For example:\n <pre>\n   isc.DataSource.create({\n       ID:\"supplyItem\",\n       fields: ...,\n       clientOnly:true,\n       testData:[\n          {itemName:\"Pencil\", cost:5.50},\n          ...\n       ]\n   });\n </pre>\n If you have existing test data in XML (see ${isc.DocUtils.linkForRef('group:dbConfigTool','Database Configuration')} for\n expected format) and your client-only DataSource is defined in a .jsp file,\n you can use the XML->JS translation engine to populate the DataSource with data from XML, like so:\n <pre>\n   isc.DataSource.create({\n     ID:\"solutions\",\n     fields: ...,\n     clientOnly : true,\n     testData : \n         &lt;isomorphic:XML filename=\"shared/ds/test_data/solutions.data.xml\"/&gt;\n   });\n </pre>\n Another useful practice is to specify both the clientOnly DataSource and its test data in\n XML, so that the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} can later be used to import the\n DataSource and its test data into a SQL Database.  An idiom for accomplishing this is:\n <pre>\n   &lt;isomorphic:loadDS name=\"solutions\"/&gt;\n   isc.DataSource.getDataSource(\"solutions\").addProperties({\n     clientOnly : true,\n     testData : \n        &lt;isomorphic:XML filename=\"shared/ds/test_data/solutions.data.xml\"/&gt;\n   });\n </pre>\n If you specify your DataSource as <code>clientOnly: true</code>, omit testData\n entirely, and provide either a ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')} or a <code>testFileName</code>, the\n \n \n DataSource will lazily make a one-time fetch against the specified data file the first time\n an operation is called on it.  From then on, the DataSource will work against the local\n cache created from this initial request.  This is a quick way to prototype against some test\n data that may eventually be returned from an arbitrary back-end.\n <P>\n Finally, it is possible to have a DataSource which initially fetches the entire dataset and\n performs all subsequent fetching locally, while still visiting the server to perform all \n other operations.  See ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')}.",
        treeLocation:[
            "Client Reference/Data Binding/DataSource"
        ],
        type:"group",
        title:"Client Only DataSources",
        seeAlso:[
        ]
    },
    "method:Calendar.getLane":{
        ref:"method:Calendar.getLane",
        deprecated:null,
        name:"getLane",
        flags:"",
        description:" Returns the ${isc.DocUtils.linkForRef('object:Lane','lane')} with the passed name, in the passed view\n",
        definingClass:"class:Calendar",
        returns:{
            description:"the lane with the passed name, or null if not found",
            type:"Lane"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"lane",
                description:"the name of the lane to return",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"view",
                description:"the view to get the lane object from",
                optional:true,
                type:"CalendarView"
            }
        ],
        seeAlso:[
        ]
    },
    "method:FormItem.getGridColNum":{
        ref:"method:FormItem.getGridColNum",
        deprecated:null,
        name:"getGridColNum",
        flags:"",
        description:" If this formItem is part of a ${isc.DocUtils.linkForRef('class:ListGrid')}'s \n ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','inline edit form')}, returns the number of the grid column this \n formItem is responsible for editing, but <b>only</b> if a row is currently being\n edited.  If the formItem is not part of a ListGrid inline edit for any reason, this \n method returns null.  Reasons for a formItem not being part of an inline edit include<ul>\n <li>The item is part of an ordinary DynamicForm, not an inline edit form</li>\n <li>There is no row in the grid currently being edited</li>\n <li>A row is being edited, but this formItem is not currently visible and is being \n excluded because of horizontal incremental rendering (where SmartClient avoids drawing\n grid columns that would not be visible without scrolling)</li>\n </ul>\n\n",
        definingClass:"class:FormItem",
        returns:{
            description:"The grid column number being edited by this formItem, or null, as                    described above",
            type:"Integer"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:TileLayout.layoutPolicy":{
        ref:"attr:TileLayout.layoutPolicy",
        defaultValue:"\"fit\"",
        valueType:"TileLayoutPolicy",
        deprecated:null,
        name:"layoutPolicy",
        flags:"IR",
        description:"Policy for laying out tiles.  See ${isc.DocUtils.linkForRef('type:TileLayoutPolicy')} for options.",
        groups:[
            "layoutPolicy"
        ],
        definingClass:"class:TileLayout",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DateItem.monthSelector":{
        ref:"attr:DateItem.monthSelector",
        defaultValue:"null",
        valueType:"AutoChild SelectItem",
        deprecated:null,
        name:"monthSelector",
        flags:"R",
        description:"Select item to hold the month part of the date.",
        groups:[
            "dateItemAppearance"
        ],
        definingClass:"class:DateItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ToolStrip.vertical":{
        ref:"attr:ToolStrip.vertical",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"vertical",
        flags:"IR",
        description:"Indicates whether the components are drawn horizontally from left to right (false), or\n vertically from top to bottom (true).",
        groups:[
            "appearance"
        ],
        definingClass:"class:ToolStrip",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.setAutoFitFieldWidths":{
        ref:"method:ListGrid.setAutoFitFieldWidths",
        deprecated:null,
        name:"setAutoFitFieldWidths",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths')}. Modifies the default auto-fit-width behavior\n for fields in this grid. Note that this may be overridden at the field level via\n ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')}.\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"autoFit",
                description:"New value for autoFitFieldWidths",
                optional:false,
                type:"boolean"
            },
            {
                defaultValue:null,
                name:"dontResetWidths",
                description:"If autoFitFieldWidths was true, and is being set to false,  should fields be resized to their originally specified size?\n  Pass in this parameter to suppress this behavior.",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "method:TabSet.getTabNumber":{
        ref:"method:TabSet.getTabNumber",
        deprecated:null,
        name:"getTabNumber",
        flags:"",
        description:" Get the index of a tab, from the tab, tab ID or tab name.  If passed a number, just returns it.\n",
        definingClass:"class:TabSet",
        returns:{
            description:"the index of the tab, or -1 if not found",
            type:"number"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"tab",
                description:null,
                optional:false,
                type:"number | ID | name | tab"
            }
        ],
        seeAlso:[
        ]
    },
    "class:GridRenderer":{
        classAttrs:[
        ],
        ref:"class:GridRenderer",
        methods:[
            "method:GridRenderer.setFastCellUpdates",
            "method:GridRenderer.cellValueIsClipped",
            "method:GridRenderer.getTotalRows",
            "method:GridRenderer.setColumnWidth",
            "method:GridRenderer.setColumnWidths",
            "method:GridRenderer.getCellStartRow",
            "method:GridRenderer.getCellRowSpan",
            "method:GridRenderer.getCellStyle",
            "method:GridRenderer.cellIsEnabled",
            "method:GridRenderer.refreshCellStyle",
            "method:GridRenderer.refreshCell",
            "method:GridRenderer.refreshRow",
            "method:GridRenderer.getCellPageRect",
            "method:GridRenderer.getColumnLeft",
            "method:GridRenderer.getColumnPageLeft",
            "method:GridRenderer.getColumnWidth",
            "method:GridRenderer.getRowTop",
            "method:GridRenderer.getRowPageTop",
            "method:GridRenderer.getEventRow",
            "method:GridRenderer.getEventColumn",
            "method:GridRenderer.getNearestRowToEvent",
            "method:GridRenderer.getNearestColToEvent",
            "method:GridRenderer.getVisibleRows",
            "method:GridRenderer.getDrawnRows",
            "method:GridRenderer.getCellRecord",
            "method:GridRenderer.getCellValue",
            "method:GridRenderer.findRowNum",
            "method:GridRenderer.findColNum",
            "method:GridRenderer.getBaseStyle",
            "method:GridRenderer.getCellCSSText",
            "method:GridRenderer.getRowHeight",
            "method:GridRenderer.getRowSpan",
            "method:GridRenderer.cellOut",
            "method:GridRenderer.cellOver",
            "method:GridRenderer.rowOut",
            "method:GridRenderer.rowOver",
            "method:GridRenderer.cellContextClick",
            "method:GridRenderer.rowContextClick",
            "method:GridRenderer.cellMouseDown",
            "method:GridRenderer.rowMouseDown",
            "method:GridRenderer.cellMouseUp",
            "method:GridRenderer.rowMouseUp",
            "method:GridRenderer.cellClick",
            "method:GridRenderer.cellDoubleClick",
            "method:GridRenderer.rowClick",
            "method:GridRenderer.rowDoubleClick",
            "method:GridRenderer.cellHover",
            "method:GridRenderer.cellValueHover",
            "method:GridRenderer.rowHover",
            "method:GridRenderer.cellHoverHTML",
            "method:GridRenderer.cellValueHoverHTML",
            "method:GridRenderer.getCellHoverComponent",
            "method:GridRenderer.selectionChanged",
            "method:GridRenderer.cellSelectionChanged",
            "method:GridRenderer.getCellFromDomElement"
        ],
        deprecated:null,
        name:"GridRenderer",
        description:"A flexible, high-speed table that offers consistent cross-platform sizing, clipping, and events.",
        treeLocation:[
            "Client Reference/Foundation"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:GridRenderer.totalRows",
            "attr:GridRenderer.showAllRows",
            "attr:GridRenderer.virtualScrolling",
            "attr:GridRenderer.showAllColumns",
            "attr:GridRenderer.drawAllMaxCells",
            "attr:GridRenderer.instantScrollTrackRedraw",
            "attr:GridRenderer.scrollRedrawDelay",
            "attr:GridRenderer.dragScrollRedrawDelay",
            "attr:GridRenderer.touchScrollRedrawDelay",
            "attr:GridRenderer.scrollWheelRedrawDelay",
            "attr:GridRenderer.drawAheadRatio",
            "attr:GridRenderer.quickDrawAheadRatio",
            "attr:GridRenderer.cellHeight",
            "attr:GridRenderer.fixedRowHeights",
            "attr:GridRenderer.fixedColumnWidths",
            "attr:GridRenderer.autoFit",
            "attr:GridRenderer.wrapCells",
            "attr:GridRenderer.cellPadding",
            "attr:GridRenderer.canSelectOnRightMouse",
            "attr:GridRenderer.canHover",
            "attr:GridRenderer.showHover",
            "attr:GridRenderer.showClippedValuesOnHover",
            "attr:GridRenderer.baseStyle",
            "attr:GridRenderer.alternateRowStyles",
            "attr:GridRenderer.alternateRowFrequency",
            "attr:GridRenderer.alternateColumnStyles",
            "attr:GridRenderer.alternateColumnFrequency",
            "attr:GridRenderer.emptyCellValue",
            "attr:GridRenderer.showEmptyMessage",
            "attr:GridRenderer.emptyMessage",
            "attr:GridRenderer.emptyMessageTableStyle",
            "attr:GridRenderer.emptyMessageStyle",
            "attr:GridRenderer.showOfflineMessage",
            "attr:GridRenderer.offlineMessageStyle",
            "attr:GridRenderer.offlineMessage",
            "attr:GridRenderer.fastCellUpdates",
            "attr:GridRenderer.snapToCells",
            "attr:GridRenderer.snapInsideBorder",
            "attr:GridRenderer.recordCustomStyleProperty",
            "attr:GridRenderer.showSelectedStyle"
        ]
    },
    "attr:OperationBinding.customJQL":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"<b>This feature is available with Power or better licenses only.</b> See\n <a href=http://smartclient.com/product>smartclient.com/product</a> for details.\n <p>\n For a dataSource of ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"jpa\", this\n property can be specified on an operationBinding to indicate that the server should run\n user-specified JQL (Java Persistence Query Language).\n <p>\n Note that inserting new records via JQL is often impractical, due to intentional restrictions\n in the language (it is only possible to perform an insert expressed in terms of a SELECT; the\n \"VALUES\" construct commonly used when inserting new rows singly is not supported).  If you are\n intending to use customJQL, we recommend that you avoid doing so for ${isc.DocUtils.linkForRef('class:OperationBinding')}s\n with ${isc.DocUtils.linkForRef('attr:OperationBinding.operationType','operationType')} \"add\", unless you have a special\n requirement such as a bulk insert; if you need custom queries to perform inserts\n on \"jpa\" dataSources, we recommend you use ${isc.DocUtils.linkForRef('attr:OperationBinding.customSQL','customSQL')},\n which is valid for \"jpa\" DataSources as well as \"sql\" dataSources.\n <p>\n For other operations on \"jpa\" dataSources, however, JQL has the advantage of\n being more portable across different database engines than is plain SQL.\n <p>\n Note that using customJQL affects paging implementation. If you use it, full data set is fetched\n from JPA and records that aren't in the requested range are dropped at the server side.",
        groups:[
            "customQuerying"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:OperationBinding.customSQL",
                description:null
            },
            {
                ref:"attr:OperationBinding.namedQuery",
                description:null
            },
            {
                ref:"attr:DataSourceField.customSQL",
                description:null
            }
        ],
        ref:"attr:OperationBinding.customJQL",
        valueType:"String",
        name:"customJQL",
        definingClass:"class:OperationBinding"
    },
    "attr:DetailViewerEditProxy.dataEscapeChar":{
        ref:"attr:DetailViewerEditProxy.dataEscapeChar",
        defaultValue:"\"\\\"",
        valueType:"String",
        deprecated:null,
        name:"dataEscapeChar",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:EditProxy.inlineEditEvent','inline editing')} for this viewer edits the\n ${isc.DocUtils.linkForRef('attr:DetailViewer.data')}, character that can be used to enter literal separator\n chars (such as the ${isc.DocUtils.linkForRef('attr:DetailViewerEditProxy.dataSeparatorChar','dataSeparatorChar')}) or literal\n leading or trailing whitespace.\n <p>\n Repeat this character twice to enter it literally.  For example, with the default\n of \"\\\", inputting \"\\\\\" would result in a literal backslash in the value.",
        definingClass:"class:DetailViewerEditProxy",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Calendar.getEventHeaderHTML":{
        ref:"method:Calendar.getEventHeaderHTML",
        deprecated:null,
        name:"getEventHeaderHTML",
        flags:"",
        description:" Returns the title text for the passed event, for display in the header area of an event \n canvas.  The default implementation returns the event's\n ${isc.DocUtils.linkForRef('attr:Calendar.nameField','name field')} for timelines, and that same value pre-pended with\n the event's ${isc.DocUtils.linkForRef('attr:Calendar.startDateField','start')} and ${isc.DocUtils.linkForRef('attr:Calendar.endDateField','end')} \n dates for day and week views.\n \n",
        definingClass:"class:Calendar",
        returns:{
            description:"the HTML to display in the header of an event canvas",
            type:"HTMLString"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"event",
                description:"the event to get the description text for",
                optional:false,
                type:"CalendarEvent"
            },
            {
                defaultValue:null,
                name:"view",
                description:"the view in which the event is being rendered",
                optional:true,
                type:"CalendarView"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.drawAreaChanged":{
        ref:"method:ListGrid.drawAreaChanged",
        deprecated:null,
        name:"drawAreaChanged",
        flags:"A",
        description:"  Notification method that fires when the drawArea changes due to scrolling.  Receives\n the previous drawArea co-ordinates as parameters.  Call ${isc.DocUtils.linkForRef('method:ListGrid.getDrawArea')} to\n get the new drawArea co-ordinates.\n <P>\n Note that if this grid is showing any ${isc.DocUtils.linkForRef('attr:ListGridField.frozen','frozen fields')}, they\n will not be included in the <code>oldStartCol</code>, <code>oldEndCol</code> range\n reported by this method. Frozen fields are assumed never to be scrolled out of view.\n\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"oldStartRow",
                description:"the startRow from before the drawArea changed",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"oldEndRow",
                description:"the endRow from before the drawArea changed",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"oldStartCol",
                description:"the startCol from before the drawArea changed",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"oldEndCol",
                description:"the endCol from before the drawArea changed",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.hiliteIconLeftPadding":{
        ref:"attr:ListGrid.hiliteIconLeftPadding",
        defaultValue:"2",
        valueType:"number",
        deprecated:null,
        name:"hiliteIconLeftPadding",
        flags:"IRW",
        description:"How much padding should there be on the left of ${isc.DocUtils.linkForRef('attr:ListGrid.hiliteIcons','hilite icons')} by default?\n Can be overridden at the field level",
        groups:[
            "hiliting"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Process.reset":{
        ref:"method:Process.reset",
        deprecated:null,
        name:"reset",
        flags:"",
        description:" Reset process to it's initial state, so process can be started again.\n",
        definingClass:"class:Process",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"state",
                description:"new state of the process",
                optional:false,
                type:"Record"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:OperationBinding.callbackParam":{
        serverDS:"allowed",
        defaultValue:"\"callback\"",
        deprecated:null,
        flags:"IR",
        description:"Applies only to dataFormat: \"json\".  Specifies the name of the query parameter that\n tells your JSON service what function to call as part of the response for this operation.\n <P>\n Typically set once for the DataSource as a whole via ${isc.DocUtils.linkForRef('attr:DataSource.callbackParam')}.",
        groups:[
            "clientDataIntegration"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSource.callbackParam",
                description:null
            }
        ],
        ref:"attr:OperationBinding.callbackParam",
        valueType:"String",
        name:"callbackParam",
        definingClass:"class:OperationBinding"
    },
    "method:Class.getCallTrace":{
        ref:"method:Class.getCallTrace",
        deprecated:null,
        name:"getCallTrace",
        flags:"",
        description:" Returns a one-line summary of the current method call, showing method name and passed\n arguments. \n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.getCallTrace(arguments)\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n <P>\n Note the <code>arguments</code> object is required in most cases for this method to function. In some\n browsers, it can be derived automatically, but developers looking to debug on multiple platforms\n should not rely on this.\n\n",
        groups:[
            "debug"
        ],
        definingClass:"class:Class",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"args",
                description:"arguments object from the call to trace. If ommitted, where supported,    arguments will be derived from the calling function, or if this is not supported, the method\n   will not function.",
                optional:true,
                type:"Arguments"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:RichTextEditor.indentPrompt":{
        ref:"attr:RichTextEditor.indentPrompt",
        defaultValue:"\"Increase indent\"",
        valueType:"String",
        deprecated:null,
        name:"indentPrompt",
        flags:"IRW",
        description:"The prompt for the built-in ${isc.DocUtils.linkForRef('type:ControlName','indent')} control.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:RichTextEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Menu.iconFieldProperties":{
        ref:"attr:Menu.iconFieldProperties",
        defaultValue:"null",
        valueType:"ListGridField properties",
        deprecated:null,
        name:"iconFieldProperties",
        flags:"IR",
        description:"Custom properties for the automatically generated icon column.\n <P>\n See ${isc.DocUtils.linkForRef('attr:Menu.showIcons')} for an overview of the icon column.",
        definingClass:"class:Menu",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataSource.splitCriteria":{
        ref:"method:DataSource.splitCriteria",
        deprecated:null,
        name:"splitCriteria",
        flags:"",
        description:" Split a criteria apart based on <code>fields</code>. A new simple criteria\n is returned with any criteria applicable to the specified fields. The passed\n <code>criteria</code> is then <u>modified</u> to remove these fields resulting in\n two distinct criteria.\n <P>\n Incoming criteria can be a simple or advanced criteria. For an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}\n only a single level of criteria with a top-level operator of \"and\" is supported.\n <P>\n To avoid modifying an original criteria, use ${isc.DocUtils.linkForRef('classMethod:DataSource.copyCriteria')} to\n make a copy to be passed in.\n\n",
        definingClass:"class:DataSource",
        returns:{
            description:"extracted criteria",
            type:"Criteria"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"criteria to be split. May be modified if criteria is                            extracted.",
                optional:false,
                type:"Criteria"
            },
            {
                defaultValue:null,
                name:"fields",
                description:"list of fields to extract from criteria",
                optional:false,
                type:"Array of String"
            }
        ],
        seeAlso:[
        ]
    },
    "group:jpaHibernateRelations":{
        ref:"group:jpaHibernateRelations",
        refs:[
        ],
        deprecated:null,
        name:"jpaHibernateRelations",
        description:"JPA and Hibernate allow relations to be declared between entities where there is no actual\n Java field for storing the ID of a related entity, even though such a column exists in the\n database.  For example:\n <pre>\n    &#64;ManyToOne\n    &#64;JoinColumn(name=\"countryId\", referencedColumnName=\"countryId\")\n    private Country country;\n </pre>\n JPADataSource and HibernateDataSource support this style of declaration and will\n automatically handle mapping between IDs and entities.\n <p>\n The example above and the following examples assume a DataSource \"country\" for a\n JPA/Hibernate entity \"Country\" with an Id field of \"countryId\", and a DataSource \"city\" for a\n JPA/Hibernate entity \"City\" with an Id field of \"cityId\".\n <p>\n <h3>Many-To-One Relations</h3>\n <p>\n An example of Many-To-One is that Many \"City\"s belong to One \"Country\".  In Java, each City\n bean has a field of type Country.  In the database, rows for cities and countries are linked\n by ID.\n <p>\n To specify a many-to-one relation, declare a DataSourceField named after the Java field that\n declares the relation (\"country\" above) with the property\n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} pointing to related DataSource's primary key:\n <pre>\n    &lt;field name=\"country\" foreignKey=\"country.countryId\"/&gt;\n </pre>\n When delivered to the browser, the value of the <code>country</code> field will be the ID of\n the related Country entity.  The <code>country</code> field can be treated as a normal text\n or integer field value, for example, you can use a ${isc.DocUtils.linkForRef('class:SelectItem')} that uses\n ${isc.DocUtils.linkForRef('attr:SelectItem.optionDataSource')} to allow selecting the ID of a different related\n entity.  Then, when the new ID is saved to the server, JPADataSource automatically looks up\n the related object and persists the new relation to JPA.\n <p>\n <b>NOTE:</b>: do not declare a \"type\" attribute for such a field - these fields provide\n specialized mapping between IDs and JPA/Hibernate entities, so don't really have a single\n concrete type.\n <p>\n If you want fields from a related entity to be included whenever your entity is fetched, for\n example, whenever a city is fetched you want the <code>countryName</code> fetched from the\n related <code>country</code> entity, use ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom')}.\n <p>\n <b>Automatic Criteria translation</b>\n <p>\n If criteria are submitted for a ManyToOne relation field containing an ID value, this will\n correctly return Records that are associated with the related object that has that ID.\n <p>\n For example, given a countryId of \"1\", you can fetch all city Records that are related to\n that countryId as follows:\n \n <pre>\n   isc.DataSource.get(\"city\").fetchData({ countryId: 1 }, <callback>);\n </pre>\n \n \n <p>\n <h3>One-to-Many Relations</h3>\n <p>\n An example of One-To-Many relation is that One \"Country\" has Many \"City\"'s.  Each \"Country\"\n has a list of cities within it, which may be declared as a Java bean property of Collection\n type (or List, Set, etc).\n <p>\n To specify a one-to-many relation, declare a DataSourceField that:\n <ul>\n <li> is named after the Java field that declares the OneToMany relation (whose type is a\n      Collection of the related entities)\n <li> declares its \"type\" to be the ID of the related DataSource\n <li> declares a ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} pointing to the related\n      DataSource's primaryKey field\n <li> sets multiple=\"true\"\n </ul>\n For example, for a Country bean that has a Collection of City beans:\n <pre>\n     &lt;field name=\"cities\" type=\"city\" multiple=\"true\" foreignKey=\"city.cityId\"/&gt;\n </pre>\n With this declaration, whenever Records are loaded from the Country DataSource, they will\n contain a list of City Records as subobjects, accessible via \n \n <span class=\"client\">countryRecord.cities</span>\n <p>\n If loading all related \"city\" records is desirable in some circumstances and not others, you\n can use ${isc.DocUtils.linkForRef('attr:OperationBinding.outputs')} to avoid loading \"city\" records for certain\n operations.\n <p>\n <h3>Many-To-Many Relations</h3>\n An example of Many-To-Many relation is that Students have multiple Courses and each Course has \n multiple Students. In Java each Student bean has a list of Courses and each Course bean has a \n list of Students. In database tables are linked using additional table holding references to \n both students and courses.\n <P>\n To set up Many-To-Many relation between data sources you need to set up One-To-Many relation on \n both sides.\n <P>\n For example students DataSourceField for CourseDS data source:\n <pre>\n     &lt;field name=\"students\" type=\"integer\" foreignKey=\"StudentDS.id\" multiple=\"true\" /&gt;\n </pre>\n and courses DataSourceField for StudentDS data source:\n <pre>\n     &lt;field name=\"courses\" type=\"integer\" foreignKey=\"CourseDS.id\" multiple=\"true\" /&gt;\n </pre>\n Note that type attribute can be safely omitted here.\n <P>\n <b>Note</b> that alternative type declaration to be ID of related data source (as in regular \n One-To-Many relation case) would work as expected, but is <b>not recommended</b> to use, cause \n it would result in getting lots of copies of same data. Smartclient server will prevent infinite \n loops, but still lots of unnecessary data will be sent to client.\n <P>\n <h3>Alternative: Many-To-One loading complete related object</h3>\n <p>\n For a Many-To-One relation, instead of loading just the ID of the related object, you can\n load the entire related object as a nested Record.  To do so, just declare the type of the\n field to be the ID of the related DataSource, rather than leaving type unset:\n <pre>\n     &lt;field name=\"country\" type=\"country\" foreignKey=\"country.countryId\"/&gt;\n </pre>\n The nested \"country\" Record will be available on a \"city\" record via \n \n cityRecord.country.\n Saving a City record that contains a nested Country record in the \"country\"\n attribute will result in the Country being updated in JPA/Hibernate.\n <P>\n This mode is not typically used, since loading just the ID of the related Country object is\n more efficient if many cities are being loaded, and the related Country object can always be\n loaded with a second fetchData() data, which can still be done in a single HTTP request via\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','queuing')}.\n <P>\n <h3>Alternative: One-To-Many loading related IDs</h3>\n <p>\n For a One-To-Many relation, instead of loading the complete list of related objects, you can\n load just a list of their IDs.  To do so, just omit the type declaration when declaring the\n relation:\n <pre>\n    &lt;field name=\"cities\" multiple=\"true\" foreignKey=\"city.cityId\"/&gt;\n </pre>\n When saving, if a replacement list of IDs is included in the Record, the appropriate\n JPA/Hibernate relationships will be updated.\n <P>\n This is very rarely used, and would typically only be used by client-side code that plans to\n programmatically work with the list of related IDs rather than display them in a UI\n component.\n <p>\n <h3><b>NOTE:</b> Bidirectional relations</h3>\n <p>\n When relations are declared, JPA and Hibernate consider only one of the two entities to be\n the \"owner\" of the relation, meaning essentially that the references that make up the\n relationship are stored with that entity.  When performing updates, make sure you update the\n entity that \"owns\" the relation.  All changes to relations on \"non-owning\" entities are\n silently discarded.\n <p>\n <h3>Search criteria on One-to-Many and Many-to-Many relations</h3>\n <p>\n The following ${isc.DocUtils.linkForRef('object:Operator','search operators')} are supported with the behaviors listed\n below.  For simple Criteria, criteria values are treated identically to the \"equals\"\n operator and the ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle','textMatchStyle')} is ignored.\n <P>\n Examples are given in terms of a \"country\" DataSource that has a one-to-many relation with a \"city\"\n DataSource through a relation field called \"cities\"\n <p>\n <table border=1 class=\"normal\">\n <tr>\n <td>Operator</td><td>Behavior</td>\n </tr>\n <tr>\n <td><code>isNull</code></td><td>matches country records which have no related cities</td>\n </tr>\n <tr>\n <td><code>notNull</code></td><td>matches country records which have at least one related city</td>\n </tr>\n <tr>\n <td><code>equals, notEqual</code></td><td>\n <code>criterion.value</code> should be a primaryKey value for the related\n city DataSource.  This criterion matches any country which\n contains the passed city (or for \"notEqual\", matches any country which\n <b>does not</b> contain the passed city.  \n </td>\n </tr>\n <tr>\n <td><code>inSet, notInSet</code></td><td>\n <code>criterion.value</code> should an array of primaryKey values for the\n related city DataSource.  This criterion matches any country which\n contains <b>any</b> of the passed cities (or for \"notInSet\", which\n contains <b>none</b> of the passed cities).</td>\n </tr>\n </table>\n The following is an example of a criterion for matching a \"country\" records which have related\n cities with primaryKey values 1, 2 or 3 (shown serialized as JSON):\n <pre>\n   {fieldName:\"cities\", operator:\"inSet\", value:[1,2,3]}\n </pre>\n As an alternative syntax, \"equals\", \"notEqual\", \"inSet\" and \"notInSet\" will also allow\n <code>criterion.value</code> to be specified as a list of Objects, each containing the\n primaryKey field and its value:\n <pre>\n      {fieldName:\"cities\",operator:\"inSet\",value:[{cityId:1},{cityId:2},cityId:3]}\n </pre>\n The operators explained above work the same way for Many-To-Many relation fields.\n <p>\n Any other operator applied to a relation field will cause a warning to be logged, and will be\n treated as though the criterion were not present (matches all records).",
        treeLocation:[
            "Concepts/Persistence Technologies"
        ],
        type:"group",
        title:"JPA &amp; Hibernate Relations",
        seeAlso:[
        ]
    },
    "attr:ListGrid.unspannedHeaderVAlign":{
        ref:"attr:ListGrid.unspannedHeaderVAlign",
        defaultValue:"null",
        valueType:"vAlign",
        deprecated:null,
        name:"unspannedHeaderVAlign",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpans')} are in use, this property sets the default\n vertical alignment for for fields which do <b>not</b> have a headerSpan.",
        groups:[
            "headerSpan"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:ListGrid.setUserSummary":{
        ref:"method:ListGrid.setUserSummary",
        deprecated:null,
        name:"setUserSummary",
        flags:"",
        description:" Updates the user summary of the supplied field.  This method is preferred over setting the\n field property directly since it allows any component dependencies to be updated.  If the\n summary is not passed or undefined, it is assumed it has already been updated and only the\n dependency propagation logic will run.<P>\n Known component dependencies are:<ul>\n <li>the cached record values of the summary for this field</ul>\n",
        definingClass:"class:ListGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"field",
                description:"field owning the userSummary",
                optional:false,
                type:"ListGridField | String"
            },
            {
                defaultValue:null,
                name:"userSummary",
                description:"optional summary to install",
                optional:true,
                type:"UserSummary"
            }
        ],
        seeAlso:[
            {
                ref:"attr:ListGridField.userSummary",
                description:null
            }
        ]
    },
    "method:DrawItem.getSvgString":{
        ref:"method:DrawItem.getSvgString",
        deprecated:null,
        name:"getSvgString",
        flags:"",
        description:" Generates a string containing the SVG source of this DrawItem.\n\n <p><b>NOTE:</b> The generated SVG source assumes that the default namespace is <code>http://www.w3.org/2000/svg</code>\n and that namespace prefix <code>xlink</code> refers to namespace name <code>http://www.w3.org/1999/xlink</code>.\n\n",
        definingClass:"class:DrawItem",
        type:"method",
        seeAlso:[
        ]
    },
    "class:EditPane":{
        classAttrs:[
        ],
        methods:[
            "method:EditPane.getEditContext",
            "method:EditPane.getSaveData",
            "method:EditPane.getRootEditNode",
            "method:EditPane.makeEditNode",
            "method:EditPane.addNode",
            "method:EditPane.addFromPaletteNode",
            "method:EditPane.addFromPaletteNodes",
            "method:EditPane.removeNode",
            "method:EditPane.reorderNode",
            "method:EditPane.removeAll",
            "method:EditPane.destroyAll",
            "method:EditPane.isNodeEditingOn",
            "method:EditPane.enableEditing",
            "method:EditPane.setNodeProperties",
            "method:EditPane.removeNodeProperties",
            "method:EditPane.getDefaultPalette",
            "method:EditPane.setDefaultPalette",
            "method:EditPane.addPaletteNodesFromXML",
            "method:EditPane.addPaletteNodesFromJSON",
            "method:EditPane.getPaletteNodesFromXML",
            "method:EditPane.addPaletteNodesFromJS",
            "method:EditPane.serializeAllEditNodes",
            "method:EditPane.serializeAllEditNodesAsJSON",
            "method:EditPane.serializeEditNodes",
            "method:EditPane.serializeEditNodesAsJSON"
        ],
        deprecated:null,
        description:"A container that allows drag and drop instantiation of visual components from a\n ${isc.DocUtils.linkForRef('interface:Palette')}, and direct manipulation of the position and size of those components.\n <P>\n Any drag onto an EditPane from a Palette will add an EditNode created from the dragged\n PaletteNode.\n <P>\n EditPane automatically creates an ${isc.DocUtils.linkForRef('class:EditContext')} and provides several APIs and\n settings that are passthroughs to the underlying EditContext for convenience.",
        groups:[
            "devTools"
        ],
        treeLocation:[
            "Client Reference/Tools/EditContext"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:EditPane.editContext",
            "attr:EditPane.editContextProperties",
            "attr:EditPane.autoEditNewNodes",
            "attr:EditPane.rootComponent",
            "attr:EditPane.defaultPalette",
            "attr:EditPane.extraPalettes",
            "attr:EditPane.persistCoordinates",
            "attr:EditPane.allowNestedDrops",
            "attr:EditPane.showSelectedLabel",
            "attr:EditPane.selectedBorder",
            "attr:EditPane.selectedLabelBackgroundColor",
            "attr:EditPane.canGroupSelect",
            "attr:EditPane.canDragGroup",
            "attr:EditPane.hideGroupBorderOnDrag"
        ],
        ref:"class:EditPane",
        name:"EditPane"
    },
    "attr:Menu.checkmarkImage":{
        ref:"attr:Menu.checkmarkImage",
        defaultValue:"{...}",
        valueType:"Img Properties",
        deprecated:null,
        name:"checkmarkImage",
        flags:"IR",
        description:"Default image to display for checkmarked items. See ${isc.DocUtils.linkForRef('object:ImgProperties')} for format.\n Valid src, width and height must be specified.",
        definingClass:"class:Menu",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SpinnerItem.unstackedPrintTextBoxStyle":{
        ref:"attr:SpinnerItem.unstackedPrintTextBoxStyle",
        defaultValue:"null",
        valueType:"FormItemBaseStyle",
        deprecated:null,
        name:"unstackedPrintTextBoxStyle",
        flags:"IR",
        description:"In ${isc.DocUtils.linkForRef('attr:SpinnerItem.writeStackedIcons','unstacked mode')}, the base CSS class name for the\n <code>SpinnerItem</code>'s text box element when printed. If unset, then ${isc.DocUtils.linkForRef('attr:SpinnerItem.unstackedTextBoxStyle')}\n is used.",
        groups:[
            "appearance"
        ],
        definingClass:"class:SpinnerItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:WSRequest.useFlatFields":{
        ref:"attr:WSRequest.useFlatFields",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"useFlatFields",
        flags:"IR",
        description:"When <code>useFlatFields</code> is set for a request to be sent to a WSDL web service, when\n creating the input XML message to send to the web service, properties in\n ${isc.DocUtils.linkForRef('attr:WSRequest.data','request.data')} will be used as the values for XML elements of the same name, at\n any level of nesting.\n <P>\n <code>useFlatFields</code> allows you to ignore gratuitous XML message structure, such as\n extra levels of nested elements, and provides some insulation against changes in the\n required structure of the input message.\n <P>\n For example, given this input message:\n <pre>\n &lt;FindServices&gt;\n     &lt;searchFor&gt;search text&lt;/searchFor&gt;\n     &lt;Options&gt;\n         &lt;caseSensitive&gt;false&lt;/caseSensitive&gt;\n     &lt;/Options&gt;\n     &lt;IncludeInSearch&gt;\n         &lt;serviceName&gt;true&lt;/serviceName&gt;\n         &lt;documentation&gt;true&lt;/documentation&gt;\n         &lt;keywords&gt;true&lt;/keywords&gt;\n     &lt;/IncludeInSearch&gt;\n &lt;/FindServices&gt;\n </pre>\n If <code>useFlatFields</code> were <b>not</b> set, in order to fill out this message\n correctly, <code>request.data</code> would need to be:\n <pre>{\n    searchFor: \"search text\",\n    Options : {\n        caseSensitive: false,\n    },\n    IncludeInSearch : {\n        serviceName: true,\n        documentation : true,\n        keywords : true\n    }\n }</pre>\n However if useFlatFields were set, <code>request.data</code> could be just:\n <pre>{\n    searchFor: \"search text\",\n    caseSensitive: false,\n    serviceName: true,\n    documentation : true,\n    keywords : true\n }</pre>\n <code>useFlatFields</code> is often set when the input data comes from a ${isc.DocUtils.linkForRef('class:DynamicForm')}\n to avoid the cumbersome and fragile process of mapping input fields to an XML structure.\n <P>\n ${isc.DocUtils.linkForRef('attr:OperationBinding.useFlatFields')} can also be set to cause <b>all</b> dsRequests of a\n particular type to <code>useFlatFields</code> automatically.\n <P>\n For ${isc.DocUtils.linkForRef('interface:DataBoundComponent','DataBoundComponents')}, \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.useFlatFields','component.useFlatFields')} can be set use \"flattened\"\n binding to fields of a WSDL message or XML Schema.\n <P>\n Note that <code>useFlatFields</code> is not generally recommended for use with XML input\n messages where multiple simple type fields exist with the same name, however if used in this\n way, the first field to use a given name wins.  \"first\" means the first field encountered in a\n depth first search.  \"wins\" means only the first field will be populated in the generated\n XML message.",
        groups:[
            "flatFields"
        ],
        definingClass:"class:WSRequest",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Hilite.canEdit":{
        ref:"attr:Hilite.canEdit",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"canEdit",
        flags:"IR",
        description:"Can highlight be edited from header context menu? Setting attribute to\n <code>false</code> prevents editing. A <code>null</code> or <code>true</code>\n value allows editing.",
        groups:[
            "hiliting"
        ],
        definingClass:"object:Hilite",
        type:"attr",
        seeAlso:[
        ]
    },
    "object:FacetValueMap":{
        classAttrs:[
        ],
        ref:"object:FacetValueMap",
        methods:[
        ],
        deprecated:null,
        name:"FacetValueMap",
        description:"\n A JavaScript Object where each property name is a facetId and each property value is a\n facetValueId for that facet.\n \n \n <P>\n The facetId &rarr; facetValueId mappings in a FacetValueMap describe a specific slice of the\n dataset.  If mappings are included for all facets, a FacetValueMap describes a unique\n cell.  If some facets are omitted, it describes a row, column, or set of rectangular\n areas, or equivalently, a particular row or column header (if all facetIds in the map are\n displayed on the same axis)\n <P>\n FacetValueMaps are used in various contexts to describe headers, datasets to be loaded,\n screen regions, etc.",
        treeLocation:[
            "Optional Modules/Analytics/CubeGrid"
        ],
        type:"object",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ]
    },
    "attr:FacetChart.pointColorLogBase":{
        ref:"attr:FacetChart.pointColorLogBase",
        defaultValue:"10",
        valueType:"integer",
        deprecated:null,
        name:"pointColorLogBase",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('attr:FacetChart.logScalePointColor')} is <code>true</code>, this property specifies the base\n value for logarithmic ${isc.DocUtils.linkForRef('attr:FacetChart.colorScaleMetric','color scale metric')} values.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SplitPane.showLeftButton":{
        ref:"attr:SplitPane.showLeftButton",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"showLeftButton",
        flags:"IRW",
        description:"Should the ${isc.DocUtils.linkForRef('attr:SplitPane.leftButton')} be shown in the \n ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigation bar')}?\n <p>\n When set to true, the ${isc.DocUtils.linkForRef('attr:SplitPane.leftButton')} is displayed to the left of the \n ${isc.DocUtils.linkForRef('attr:SplitPane.navigationTitle')}, and to the right of the ${isc.DocUtils.linkForRef('attr:SplitPane.backButton')},\n when ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode')} is not \"desktop\".\n <P>",
        definingClass:"class:SplitPane",
        type:"attr",
        setter:[
            "setShowLeftButton"
        ],
        seeAlso:[
            {
                ref:"attr:SplitPane.leftButton",
                description:null
            },
            {
                ref:"attr:SplitPane.backButton",
                description:null
            }
        ]
    },
    "method:ListGrid.getSummaryFieldValue":{
        ref:"method:ListGrid.getSummaryFieldValue",
        deprecated:null,
        name:"getSummaryFieldValue",
        flags:"",
        description:" Get the computed value of a ${isc.DocUtils.linkForRef('attr:ListGrid.canAddSummaryFields','summary field')}.\n",
        definingClass:"class:ListGrid",
        returns:{
            description:"formula result",
            type:"String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"field",
                description:"field that has a summary format",
                optional:false,
                type:"ListGridField"
            },
            {
                defaultValue:null,
                name:"record",
                description:"record to use to compute formula value",
                optional:false,
                type:"Record"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.filterEditorProperties":{
        ref:"attr:ListGrid.filterEditorProperties",
        defaultValue:"null",
        valueType:"RecordEditor properties",
        deprecated:null,
        name:"filterEditorProperties",
        flags:"IR",
        description:"Properties to apply to the automatically generated ${isc.DocUtils.linkForRef('attr:ListGrid.filterEditor')}\n if ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is true.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DynamicForm.showInlineErrors":{
        ref:"attr:DynamicForm.showInlineErrors",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showInlineErrors",
        flags:"IRW",
        description:"If true, field errors are written into the form next to the item(s) where the errors\n occurred.  Errors may appear as text or just an icon (via ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}:false).\n <P>\n If false, errors are written at the top of the form.\n <P>\n To do some other kind of error display, override ${isc.DocUtils.linkForRef('method:DynamicForm.showErrors')}.",
        groups:[
            "validation"
        ],
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.sortField":{
        getter:[
            "getSortField"
        ],
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Specifies the field by which this grid should be initially sorted. Can be set to either a\n ${isc.DocUtils.linkForRef('attr:ListGridField.name','field name')} or the index of the field in the fields Array.\n <P>\n ListGrids also support being initialized with multiple-field sort via\n ${isc.DocUtils.linkForRef('attr:ListGrid.initialSort')}. If initialSort is specified, it will be used in preference\n to this property.\n <P>\n To sort the grid after it has been initialized, use ${isc.DocUtils.linkForRef('method:ListGrid.sort')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.setSort')}. Details about the current sort of a live grid can be\n retrieved by calling ${isc.DocUtils.linkForRef('method:ListGrid.getSortField')} or ${isc.DocUtils.linkForRef('method:ListGrid.getSort')}",
        groups:[
            "sorting"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.sortField",
        examples:[
            "${isc.DocUtils.linkForExampleId('sort')}"
        ],
        valueType:"String | int",
        name:"sortField",
        definingClass:"class:ListGrid"
    },
    "group:gridHeader":{
        ref:"group:gridHeader",
        refs:[
            "method:ListGrid.setHeaderHeight",
            "method:ListGrid.setShowHeader",
            "method:ListGrid.headerTitleClipped",
            "method:ListGrid.headerHoverHTML",
            "method:ListGrid.headerClick",
            "method:ListGrid.headerDoubleClick",
            "method:ListGrid.displayHeaderContextMenu",
            "method:ListGrid.getHeaderContextMenuItems",
            "method:ListGrid.headerHover",
            "attr:ListGrid.header",
            "attr:ListGrid.headerContextMenu",
            "attr:ListGrid.spanContextMenu",
            "attr:ListGrid.headerHeight",
            "attr:ListGrid.showHeader",
            "attr:ListGrid.headerBarStyle",
            "attr:ListGrid.headerBackgroundColor",
            "attr:ListGrid.headerButtonConstructor",
            "attr:ListGrid.headerBaseStyle",
            "attr:ListGrid.headerTitleStyle",
            "attr:ListGrid.frozenHeaderBaseStyle",
            "attr:ListGrid.frozenHeaderTitleStyle",
            "attr:ListGrid.headerButtonDefaults",
            "attr:ListGrid.headerButtonProperties",
            "attr:ListGrid.clipHeaderTitles",
            "attr:ListGrid.sorterConstructor",
            "attr:ListGrid.sorterButtonTitle",
            "attr:ListGrid.sorterDefaults",
            "attr:ListGrid.sorterProperties",
            "attr:ListGrid.showHeaderContextMenu"
        ],
        deprecated:null,
        name:"gridHeader",
        description:"Properties and methods related to the ListGrid header. ListGrid headers are implemented\n as a ${isc.DocUtils.linkForRef('class:Toolbar')} of buttons shown at the top of the ListGrid\n (one button per column).<br>\n The toolbar header provides UI for interacting with the ListGrid fields directly (sorting,\n resizing, reordering columns, etc).",
        type:"group",
        seeAlso:[
        ]
    },
    "method:Canvas.setStyleName":{
        ref:"method:Canvas.setStyleName",
        examples:[
            "${isc.DocUtils.linkForExampleId('styles')}"
        ],
        deprecated:null,
        name:"setStyleName",
        flags:"",
        description:" Sets the CSS class for this widget\n",
        groups:[
            "appearance"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newStyle",
                description:"new CSS style name",
                optional:false,
                type:"CSSStyleName"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TextItem.selectOnFocus":{
        ref:"attr:TextItem.selectOnFocus",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"selectOnFocus",
        flags:"IRW",
        description:"Allows the ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus','selectOnFocus')} behavior to be configured on a\n per-FormItem basis.  Normally all items in a form default to the value of\n ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnFocus')}.",
        groups:[
            "focus"
        ],
        definingClass:"class:TextItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:IconButton.menuIconWidth":{
        ref:"attr:IconButton.menuIconWidth",
        defaultValue:"14",
        valueType:"Number",
        deprecated:null,
        name:"menuIconWidth",
        flags:"IRW",
        description:"The width of the icon for this button.",
        definingClass:"class:IconButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:LayoutPolicy":{
        ref:"type:LayoutPolicy",
        values:[
            {
                description:"Layout does not try to size members on the axis at all, merely stacking them (length\n  axis) and leaving them at default breadth.",
                value:"Layout.NONE"
            },
            {
                description:"Layout sizes members so that they fill the specified size of the layout.  The rules\n  are:\n  <ul>\n  <li> Any component given an initial pixel size, programmatically resized to a specific\n  pixel size, or drag resized by user action is left at that exact size\n  <li> Any component that ${isc.DocUtils.linkForRef('attr:Button.autoFit','autofits')} is given exactly the space it\n  needs, never forced to take up more.\n  <li> All other components split the remaining space equally, or according to their\n  relative percentages.\n  </ul>",
                value:"Layout.FILL"
            }
        ],
        deprecated:null,
        name:"LayoutPolicy",
        description:"Policy controlling how the Layout will manage member sizes on this axis.\n <P>\n Note that, by default, Layouts do <i>not</i> automatically expand the size of all members\n to match a member that overflows the layout on the breadth axis.  This means that a\n ${isc.DocUtils.linkForRef('class:DynamicForm')} or other component that can't shrink beyond a minimum width will \n \"stick out\" of the Layout, wider than any other member and wider than automatically\n generated components like resizeBars or sectionHeaders (in a ${isc.DocUtils.linkForRef('class:SectionStack')}).\n <P>\n This is by design: matching the size of overflowing members would cause expensive redraws\n of all members in the Layout, and with two or more members potentially overflowing, could\n turn minor browser size reporting bugs or minor glitches in custom components into\n infinite resizing loops.\n <P>\n If you run into this situation, you can either:<ul>\n <li>set the overflowing member to ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow')}: \"auto\", so that it\n scrolls if it needs more space\n <li>set the Layout as a whole to ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow')}:\"auto\", so that the\n whole Layout scrolls when the member overflows\n <li>define a ${isc.DocUtils.linkForRef('method:Canvas.resized','resized()')} handler to manually update the breadth\n of the layout\n </ul><P>\n For the last approach, given the VLayout <code>myLayout</code> and a member <code>\n myWideMember</code>, then we could define the following ${isc.DocUtils.linkForRef('method:Canvas.resized','resized()')} handler on <code>myLayout</code>:\n \n <pre>\n resized : function () {\n     var memberWidth = myWideMember.getVisibleWidth();\n     this.setWidth(Math.max(this.getWidth(), memberWidth + offset));\n }</pre>\n where <code>offset</code> reflects the difference in width (due to margins, padding,\n etc.) between the layout and its widest member.  In most cases, a fixed offset can\n be used, but it can also be computed via the calculation:\n <P>\n <pre>\n     myLayout.getWidth() - myLayout.getViewportWidth()\n </pre>\n in an override of ${isc.DocUtils.linkForRef('method:Canvas.draw','draw()')}\n for <code>myLayout</cOde>.  (That calculation is not always valid inside the \n ${isc.DocUtils.linkForRef('method:Canvas.resized','resized()')} handler itself.)\n <P>\n Note: the HLayout case is similar- just substitute height where width appears above.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:Layout.overflow')}.",
        type:"type",
        seeAlso:[
        ]
    },
    "classMethod:Class.setInstanceProperty":{
        ref:"classMethod:Class.setInstanceProperty",
        deprecated:null,
        name:"setInstanceProperty",
        flags:"",
        description:"\n\tSets a named property from the instance defaults for this object.\n\n",
        definingClass:"class:Class",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"property",
                description:"name of the property to return",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"value",
                description:"value to set to",
                optional:false,
                type:"any"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:DateUtil.getDisplayYear":{
        ref:"classMethod:DateUtil.getDisplayYear",
        deprecated:null,
        name:"getDisplayYear",
        flags:"",
        description:" Returns the full year from the passed datetime, as it will be displayed to the user.  \n This might not be the same value as that returned by getFullYear() if a \n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','custom timezone')}\n has been applied.  Only necessary for datetimes - for logical dates and times, this\n method returns the same value as getFullYear().\n",
        definingClass:"class:DateUtil",
        returns:{
            description:"the 4-digit display year from the passed datetime",
            type:"int"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"datetime",
                description:"datetime instance to work with",
                optional:false,
                type:"Date"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:Validator.mustBeGreaterThan":{
        ref:"classAttr:Validator.mustBeGreaterThan",
        defaultValue:"\"Must be at least ${min}\"",
        valueType:"string",
        deprecated:null,
        name:"mustBeGreaterThan",
        flags:"IRA",
        description:"Default error message to display when standard <code>integerRange</code> type validator\n  returns false because the value passed in is less than the specified minimum.\n <p>This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Validator",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.tableClause":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"<b>This feature is available with Power or better licenses only.</b> See \n <a href=http://smartclient.com/product>smartclient.com/product</a> for details.\n <p>\n For a dataSource of ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"sql\", this \n property can be specified on an operationBinding to provide the server with a bespoke\n table clause to use when constructing the SQL query to perform this operation.  The\n property should be a comma-separated list of tables and views, and you can use any\n special language constructs supported by the underlying database.  The server will \n insert the text of this property immediately after the \"FROM\" token.\n <p>\n See the documentation for ${isc.DocUtils.linkForRef('attr:OperationBinding.customSQL')} for usage examples",
        groups:[
            "customQuerying"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:OperationBinding.customSQL",
                description:null
            }
        ],
        ref:"attr:OperationBinding.tableClause",
        valueType:"String",
        name:"tableClause",
        definingClass:"class:OperationBinding"
    },
    "method:Portlet.close":{
        ref:"method:Portlet.close",
        deprecated:null,
        name:"close",
        flags:"",
        description:" <code>close()</code> method overridden to show \n ${isc.DocUtils.linkForRef('attr:Portlet.closeConfirmationMessage')} to the user before\n removing the portlet from the PortalLayout via ${isc.DocUtils.linkForRef('method:PortalLayout.removePortlet')}\n",
        definingClass:"class:Portlet",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.creatorOverrides":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Indicates that field-level declarative security rules are waived for rows that were \n created by the current user, as described in the discussion of \n ${isc.DocUtils.linkForRef('attr:DataSource.creatorOverrides','dataSource.creatorOverrides')}.  This setting overrides \n <code>dataSource.creatorOverrides</code>, for this operation only.",
        groups:[
            "fieldLevelAuth",
            "declarativeSecurity"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSourceField.editRequires",
                description:null
            },
            {
                ref:"attr:DataSourceField.viewRequires",
                description:null
            },
            {
                ref:"attr:DataSource.creatorOverrides",
                description:null
            }
        ],
        ref:"attr:OperationBinding.creatorOverrides",
        valueType:"boolean",
        name:"creatorOverrides",
        definingClass:"class:OperationBinding",
        requiresModules:[
            "SCServer"
        ]
    },
    "attr:NavigationBarViewState.alwaysShowLeftButtonTitle":{
        ref:"attr:NavigationBarViewState.alwaysShowLeftButtonTitle",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"alwaysShowLeftButtonTitle",
        flags:"IRW",
        description:"The new ${isc.DocUtils.linkForRef('attr:NavigationBar.alwaysShowLeftButtonTitle')} setting. If unset, the\n <code>alwaysShowLeftButtonTitle</code> setting is not changed.",
        definingClass:"object:NavigationBarViewState",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.beanClassName":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"A per-operationBinding setting for beanClassName, otherwise also settable at the top-level\n DataSource configuration.",
        groups:[
            "clientDataIntegration"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSource.beanClassName",
                description:null
            }
        ],
        ref:"attr:OperationBinding.beanClassName",
        valueType:"String",
        name:"beanClassName",
        definingClass:"class:OperationBinding"
    },
    "method:Canvas.enclosesRect":{
        ref:"method:Canvas.enclosesRect",
        deprecated:null,
        name:"enclosesRect",
        flags:"",
        description:" Returns true if the rectangle of this widget encloses the rectangle coordinates\n passed in, and false otherwise.\n",
        groups:[
            "positioning"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"true if this canvas encloses the rectangle passed in; false otherwise",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"left",
                description:"left coord of rect (or rect array)",
                optional:false,
                type:"number | array of number"
            },
            {
                defaultValue:null,
                name:"top",
                description:"top  coord of rect",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"width",
                description:"width  of rect",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"height",
                description:"height of rect",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:PickList.pickListFields":{
        ref:"attr:PickList.pickListFields",
        defaultValue:"null",
        valueType:"Array of ListGridField",
        deprecated:null,
        name:"pickListFields",
        flags:"IRA",
        description:"This property allows the developer to specify which field[s] will be displayed in the \n drop down list of options.\n <P>\n Only applies to databound pickLists (see ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource')}, or pickLists\n with custom data set up via the advanced ${isc.DocUtils.linkForRef('method:PickList.getClientPickListData')} method.\n <P>\n If this property is unset, we display the ${isc.DocUtils.linkForRef('attr:PickList.displayField')}, if specified, \n otherwise the ${isc.DocUtils.linkForRef('attr:PickList.valueField')}.\n <P>\n If there are multiple fields, column headers will be shown for each field, the\n height of which can be customized via the ${isc.DocUtils.linkForRef('attr:PickList.pickListHeaderHeight')} attribute.\n <P>\n Each field to display should be specified as a ${isc.DocUtils.linkForRef('object:ListGridField')} object. Note that\n unlike in ${isc.DocUtils.linkForRef('class:ListGrid','listGrids')}, dataSource fields marked as \n ${isc.DocUtils.linkForRef('attr:DataSourceField.hidden','hidden:true')} will be hidden by default in pickLists. To\n override this behavior, ensure that you specify an explicit value for \n ${isc.DocUtils.linkForRef('method:ListGridField.showIf','showIf')}.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:PickList.valueField",
                description:null
            },
            {
                ref:"attr:PickList.pickListHeaderHeight",
                description:null
            }
        ]
    },
    "group:orientation":{
        ref:"group:orientation",
        refs:[
            "type:Orientation"
        ],
        deprecated:null,
        name:"orientation",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:TileGrid.selectionType":{
        defaultValue:"Selection.MULTIPLE",
        deprecated:null,
        flags:"IRW",
        description:"Defines a tileGrid's clickable-selection behavior.",
        groups:[
            "selection",
            "appearance"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"type:SelectionStyle",
                description:null
            }
        ],
        ref:"attr:TileGrid.selectionType",
        examples:[
            "${isc.DocUtils.linkForExampleId('tilingEditing')}"
        ],
        valueType:"SelectionStyle",
        name:"selectionType",
        definingClass:"class:TileGrid"
    },
    "attr:PickList.fetchDisplayedFieldsOnly":{
        ref:"attr:PickList.fetchDisplayedFieldsOnly",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"fetchDisplayedFieldsOnly",
        flags:"IRA",
        description:"If this item has a specified <code>optionDataSource</code> and this property is\n <code>true</code>, the list of fields used by this pickList will be passed to\n the datasource as ${isc.DocUtils.linkForRef('attr:DSRequest.outputs')}. If the datasource supports this feature\n the returned fields will be limited to this list. A custom datasource will need to\n add code to implement field limiting.\n <P>\n This list of used fields consists of the values of ${isc.DocUtils.linkForRef('attr:FormItem.valueField','valueField')},\n ${isc.DocUtils.linkForRef('attr:FormItem.displayField','displayField')} and ${isc.DocUtils.linkForRef('attr:PickList.pickListFields','pickListFields')}.\n <P>\n NOTE: When enabled, ${isc.DocUtils.linkForRef('method:FormItem.getSelectedRecord','getSelectedRecord')} will only include the\n fetched fields.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Array.lastIndexOf":{
        ref:"method:Array.lastIndexOf",
        deprecated:null,
        name:"lastIndexOf",
        flags:"",
        description:" Return the position in the list of the last instance of the specified object.\n <p>\n If pos is specified, starts looking before that position.\n <p>\n Returns -1 if not found.\n\n",
        groups:[
            "access"
        ],
        definingClass:"object:Array",
        returns:{
            description:"position of the item, if found, -1 if not found",
            type:"number"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"obj",
                description:"object to look for",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"pos",
                description:"last index to consider",
                optional:true,
                type:"number"
            },
            {
                defaultValue:null,
                name:"endPos",
                description:"earliest index to consider",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DynamicForm.cancelParamValue":{
        ref:"attr:DynamicForm.cancelParamValue",
        defaultValue:"\"cancel\"",
        valueType:"String",
        deprecated:null,
        name:"cancelParamValue",
        flags:"IRW",
        description:"The value of the special field sent to the server as part of ${isc.DocUtils.linkForRef('method:DynamicForm.cancel')}",
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.lanes":{
        ref:"attr:Calendar.lanes",
        defaultValue:"null",
        valueType:"Array of Lane",
        deprecated:null,
        name:"lanes",
        flags:"IRW",
        description:"An array of ${isc.DocUtils.linkForRef('object:Lane')} definitions that represent the rows of the ${isc.DocUtils.linkForRef('attr:Calendar.timelineView')}, or\n the columns of the ${isc.DocUtils.linkForRef('attr:Calendar.dayView')} if ${isc.DocUtils.linkForRef('attr:Calendar.showDayLanes','showDayLanes')} is true.",
        definingClass:"class:Calendar",
        type:"attr",
        setter:[
            "setLanes"
        ],
        seeAlso:[
        ]
    },
    "method:FacetChart.getPointHoverHTML":{
        ref:"method:FacetChart.getPointHoverHTML",
        deprecated:null,
        name:"getPointHoverHTML",
        flags:"",
        description:" When ${isc.DocUtils.linkForRef('attr:FacetChart.showDataPoints')} is true and the mouse hovers over a point, this method is called\n and may return HTML to show in a hover.\n\n",
        definingClass:"class:FacetChart",
        returns:{
            description:"String of HTML to show in a hover",
            type:"HTMLString"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"value",
                description:"the value at the point",
                optional:false,
                type:"float"
            },
            {
                defaultValue:null,
                name:"record",
                description:"the record at the point",
                optional:false,
                type:"Record"
            },
            {
                defaultValue:null,
                name:"metricId",
                description:"the ID of the metric at the point",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DrawSector.moveBy":{
        ref:"method:DrawSector.moveBy",
        deprecated:null,
        name:"moveBy",
        flags:"",
        description:" Move the DrawSector by the specified amounts.\n",
        definingClass:"class:DrawSector",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"x",
                description:"number of pixels to move by horizontally",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"y",
                description:"number of pixels to move by vertically",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DrawGroup.dragStop":{
        ref:"method:DrawGroup.dragStop",
        deprecated:null,
        name:"dragStop",
        flags:"",
        description:" Notification fired when the user stops dragging this DrawGroup. Will only fire if ${isc.DocUtils.linkForRef('attr:DrawItem.canDrag','canDrag')}\n is true for this group.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is true, this notification will be triggered\n by the user interacting with the specified ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','group rectangle')} for the group.\n If ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is false, the notification will bubble up from interactions\n with individual items within the group.\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:DrawGroup",
        returns:{
            description:"false to cancel drag interaction.",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ]
    },
    "attr:ListGrid.selectionCanvas":{
        ref:"attr:ListGrid.selectionCanvas",
        defaultValue:"null",
        valueType:"AutoChild Canvas",
        deprecated:null,
        name:"selectionCanvas",
        flags:"RA",
        description:"AutoChild created and embedded in the grid if ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectionCanvas','showSelectionCanvas')}\n is <code>true</code> and the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType','selectionType')} is\n \"single\".\n \n This component will be created and displayed above the selected record whenever the\n selection changes.\n <p>\n NOTE: It is recommended to use the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionUnderCanvas','selectionUnderCanvas')}\n rather than the <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code>\n is stacked on top of the selected record and this may interfere with event handling in rare\n cases. If no interactive components are shown in the <code>selectionCanvas</code> and it\n simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used\n instead.\n <p>\n The <code>selectionCanvas</code> has the following read-only attributes set:<br>\n - <code>this.grid</code> - a pointer to the grid<br>\n - <code>this.record</code> - a pointer to the currently selected record in the grid",
        groups:[
            "rowEffects"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGrid.selectionUnderCanvas",
                description:null
            }
        ]
    },
    "group:exportBackgroundColor":{
        ref:"group:exportBackgroundColor",
        refs:[
            "method:ListGrid.getExportBGColor",
            "method:ListGrid.getExportRowBGColor",
            "method:ListGrid.getExportColumnBGColor",
            "attr:ListGrid.exportDefaultBGColor",
            "attr:ListGrid.exportAlternateRowBGColor"
        ],
        deprecated:null,
        name:"exportBackgroundColor",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "classMethod:Offline.goOnline":{
        ref:"classMethod:Offline.goOnline",
        deprecated:null,
        name:"goOnline",
        flags:"",
        description:" Explicitly sets this session into online mode.  This setting will override whatever \n state the browser reports.  This allows users to manually set an application into \n offline or online state.\n \n",
        definingClass:"class:Offline",
        type:"classMethod",
        seeAlso:[
            {
                ref:"classMethod:Offline.goOffline",
                description:null
            },
            {
                ref:"classMethod:Offline.useNativeOfflineDetection",
                description:null
            }
        ]
    },
    "attr:GridRenderer.showAllRows":{
        ref:"attr:GridRenderer.showAllRows",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"showAllRows",
        flags:"IRA",
        description:"Whether all rows should be drawn all at once, or only rows visible in the viewport.\n <P>\n Drawing all rows causes longer initial rendering time, but allows smoother vertical scrolling.\n With a very large number of rows, showAllRows will become too slow.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:GridRenderer.drawAheadRatio')} and ${isc.DocUtils.linkForRef('attr:GridRenderer.drawAllMaxCells')}.",
        groups:[
            "performance"
        ],
        definingClass:"class:GridRenderer",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataBoundComponent.findByKey":{
        ref:"method:DataBoundComponent.findByKey",
        deprecated:null,
        name:"findByKey",
        flags:"",
        description:" Attempt to find the record in the resultSet that has a primary key value that matches the \n passed in parameter value. Only the locally cached data will be searched. \n Checks only loaded rows and will not trigger a fetch. Returns null if there is no match, \n data is not loaded, or there is no ${isc.DocUtils.linkForRef('attr:ResultSet.dataSource','dataSource')}.\n <p>\n Note, if you pass a simple value to this method, it will be matched against the first \n primaryKey field.  For DataSources with a composite primary key (multiple primaryKey fields),\n pass\n a criteria object containing just your primaryKeys, like this: \n <code>{ firstPkField: \"value\", secondPkField: 25 }</code>.\n \n\n",
        definingClass:"interface:DataBoundComponent",
        returns:{
            description:"the record with a matching primary key field, or null if not found",
            type:"Record"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"keyValue",
                description:"primary key value to search for",
                optional:false,
                type:"Object"
            }
        ],
        seeAlso:[
        ]
    },
    "type:DragIntersectStyle":{
        ref:"type:DragIntersectStyle",
        values:[
            {
                description:"Look for drop targets that are under the current mouse cursor position.",
                value:"\"mouse\""
            },
            {
                description:"Look for drop targets by intersection of the entire rect of the drag               target with the droppable target.",
                value:"\"rect\""
            }
        ],
        deprecated:null,
        name:"DragIntersectStyle",
        description:"Different styles of determining intersection: with mouse or entire rect of target",
        groups:[
            "dragdrop"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:CubeGrid.addColumnFacet":{
        ref:"method:CubeGrid.addColumnFacet",
        deprecated:null,
        name:"addColumnFacet",
        flags:"",
        description:" Add a column facet to the view at index \"index\".  Handles the facet already being in the view\n (does a pivot).<br><br>\n\n The facet being added should currently have a fixed facet value (unless it's already part of the\n view), which will be removed from cubeGrid.fixedFacetValues.\n\n <br><i>methodType</i>  action\n",
        groups:[
            "facetLayout"
        ],
        definingClass:"class:CubeGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetId",
                description:"facetId to add.  Definition must have been provided at init time.",
                optional:false,
                type:"id"
            },
            {
                defaultValue:null,
                name:"index",
                description:"index to add the facet at.  0 = outermost (default innermost)",
                optional:true,
                type:"integer"
            }
        ],
        seeAlso:[
            {
                ref:"method:CubeGrid.removeFacet",
                description:null
            },
            {
                ref:"attr:CubeGrid.fixedFacetValues",
                description:null
            }
        ]
    },
    "attr:Calendar.eventCanvasContextMenu":{
        ref:"attr:Calendar.eventCanvasContextMenu",
        defaultValue:"null",
        valueType:"AutoChild Menu",
        deprecated:null,
        name:"eventCanvasContextMenu",
        flags:"R",
        description:"Context menu displayed when an ${isc.DocUtils.linkForRef('class:EventCanvas','event canvas')} is right-clicked, or\n when the rollover ${isc.DocUtils.linkForRef('attr:Calendar.eventCanvasContextButton','context button')} is clicked.  The \n context button, and the menu itself, will only be displayed if \n ${isc.DocUtils.linkForRef('method:Calendar.getEventCanvasMenuItems','getEventCanvasMenuItems')} returns \n an array of appropriate items for the event.",
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.noDropCursor":{
        ref:"attr:Canvas.noDropCursor",
        defaultValue:"Canvas.NOT_ALLOWED",
        valueType:"Cursor",
        deprecated:null,
        name:"noDropCursor",
        flags:"IRWA",
        description:"Specifies the cursor image to display when the user drags a droppable canvas\n      over this if it is not a valid drop target for the event and\n      ${isc.DocUtils.linkForRef('classAttr:EventHandler.showNoDropIndicator')} is true.",
        groups:[
            "cues"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DateItem.invalidDateStringMessage":{
        ref:"attr:DateItem.invalidDateStringMessage",
        defaultValue:"\"Invalid date\"",
        valueType:"string",
        deprecated:null,
        name:"invalidDateStringMessage",
        flags:"IRW",
        description:"Validation error message to display if the user enters an invalid date",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:DateItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.iconSpacing":{
        ref:"attr:ListGridField.iconSpacing",
        defaultValue:"6",
        valueType:"int",
        deprecated:null,
        name:"iconSpacing",
        flags:"IR",
        description:"Pixels between icon and title text.",
        groups:[
            "buttonIcon"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.icon",
                description:null
            }
        ]
    },
    "attr:RestDataSource.addDataURL":{
        ref:"attr:RestDataSource.addDataURL",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"addDataURL",
        flags:"IR",
        description:"Custom ${isc.DocUtils.linkForRef('attr:DataSource.dataURL','dataURL')} for ${isc.DocUtils.linkForRef('class:DSRequest','DSRequests')} with\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType','operationType')} \"add\".\n <p>\n See ${isc.DocUtils.linkForRef('attr:RestDataSource.dataURL')} to configure a single URL for all requests, which is\n required to support ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue')}.",
        definingClass:"class:RestDataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RelativeDateItem.minutesFromNowTitle":{
        ref:"attr:RelativeDateItem.minutesFromNowTitle",
        defaultValue:"\"N minutes from now\"",
        valueType:"string",
        deprecated:null,
        name:"minutesFromNowTitle",
        flags:"IR",
        description:"The title to show for future periods when the ${isc.DocUtils.linkForRef('type:TimeUnit')} is \"minute\".",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:RelativeDateItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DetailViewer.formatCellValue":{
        ref:"method:DetailViewer.formatCellValue",
        deprecated:null,
        name:"formatCellValue",
        flags:"",
        description:" Optional method to format the value to display for cells in this DetailViewer.\n Note that if ${isc.DocUtils.linkForRef('method:DetailViewerField.formatCellValue')} is specified this method will not\n be called for cells within that field.\n",
        definingClass:"class:DetailViewer",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"value",
                description:"the raw value of the cell (may be formatted by   ${isc.DocUtils.linkForRef('method:DetailViewerField.formatCellValue')}",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"record",
                description:"the record being displayed",
                optional:false,
                type:"detailViewerRecord"
            },
            {
                defaultValue:null,
                name:"field",
                description:"the field being displayed",
                optional:false,
                type:"detailViewerField"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Gauge.getSectorLabelContents":{
        ref:"method:Gauge.getSectorLabelContents",
        deprecated:null,
        name:"getSectorLabelContents",
        flags:"",
        description:" Gets the label contents of the label for the sector at sectorIndex.\n\n",
        definingClass:"class:Gauge",
        returns:{
            description:"the label contents of the sector's label.",
            type:"String"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"sectorIndex",
                description:"index of the target sector.",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "method:FacetChart.getChartCenter":{
        ref:"method:FacetChart.getChartCenter",
        deprecated:null,
        name:"getChartCenter",
        flags:"",
        description:" Returns the centerpoint for radar charts and pie charts.\n <P>\n Note that unstacked pie charts draw multiple pies, each with their own centers.\n <P>\n This is only allowed to be called when ${isc.DocUtils.linkForRef('method:FacetChart.chartDrawn')} fires.\n\n",
        definingClass:"class:FacetChart",
        returns:{
            description:"the centerpoint for radar charts and pie charts.",
            type:"Point"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:DrawItem.mouseUp":{
        ref:"method:DrawItem.mouseUp",
        examples:[
            "${isc.DocUtils.linkForExampleId('customMouseEvents')}"
        ],
        deprecated:null,
        name:"mouseUp",
        flags:"",
        description:" Notification fired when the user releases the left mouse button on this DrawItem.\n <p>\n Note that if this item is part of a ${isc.DocUtils.linkForRef('class:DrawGroup')}, then the group's ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')}\n setting affects whether this item receives the notification. If useGroupRect is true, then\n this item will <em>not</em> receive the notification. Otherwise, the item receives the\n notification and notification bubbles up to the group.\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:DrawItem",
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ]
    },
    "group:loadISCTag":{
        ref:"group:loadISCTag",
        refs:[
        ],
        deprecated:null,
        name:"loadISCTag",
        description:"<i>produces:</i> HTML\n <p>\n This tag sets window.isomorphicDir and loads a default set of SmartClient modules and a\n skin.  SmartClient modules are JavaScript files that need to be loaded via \n <code>&lt;SCRIPT SRC=/some/filename.js&gt;&lt;/SCRIPT&gt;</code>\n blocks as part of the loading HTML page.  The modules themselves are stored in the\n <code>[webroot]/isomorphic/system/modules</code> directory.  A skin defines the look and feel of your\n website and typically consists of at least one CSS file and some SmartClient UI Component\n default overrides.  Skins are located in <code>[webroot]/isomorphic/skins</code>.  Loading a skin\n consists of loading the corresponding <code>load_skin.js</code> - residing at top-level in\n each skin directory.\n <p>\n The default set of modules loaded by this tag are: <code>Core, Foundation, Containers,\n Grids, Forms, DataBinding</code>.  The default skin is the <code>SmartClient</code> skin.\n So, for example inserting this into your JSP:\n <pre>\n &lt;isomorphic:loadISC/&gt;\n </pre>\n Produces the following output:\n <pre>\n &lt;SCRIPT&gt;window.isomorphicDir='isomorphic/';&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Core.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Foundation.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Containers.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Grids.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Forms.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_DataBinding.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT src=isomorphic/skins/SmartClient/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>skin</b><br>\n <i>value format</i>: Name of skin to load.  See the <code>[webroot]/isomorphic/skins</code> directory\n for a list of available skins.  You can also create your own skin by copying an existing\n skin directory recursively, modifying anything you need, and using your new skin name as the\n value here.<br>\n <i>default value</i>: \"SmartClient\"\n <p>\n This selects a skin other than the default.  The value of this attribute is used as a path\n component to <code>load_skin.js</code>.  For example, specifying:\n <pre>\n &lt;isomorphic:loadISC skin=\"standard\"/&gt;\n </pre>\n Produces the following <code>load_skin.js</code> directive (in addition to all the standard\n module loads):\n <pre>\n &lt;SCRIPT src=isomorphic/skins/standard/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n <p>\n <b>skinDir</b><br>\n <i>value format</i>: path or URL up to and including the name of the skin<br>\n <i>default value</i>: automatically derived from the value of the <code>skin</code>\n attribute\n <p>\n This attribute is usable in lieu of the <code>skin</code> attribute and allows you to\n specify the full path or URL to the directory containing the load_skin.js for your skin.\n This allows you to move the directory containing the skin anywhere you want - including to a\n completely different server.\n <p>\n <b>includeModules</b><br>\n <i>value format</i>: Comma separated list of additional modules to load.  See the\n <code>[webroot]/isomorphic/system/modules</code> directory for a list of loadable modules.  The\n leading \"ISC_\" is optional, spaces after commas are also optional.<br>\n <i>default value</i>: NONE\n <p>\n This attribute allows you to specify SmartClient modules that you want to load in addition\n to the default set of modules. For example, specifying:\n <pre>\n &lt;isomorphic:loadISC includeModules=\"Analytics\"/&gt;\n </pre>\n Produces the following output:\n <pre>\n &lt;SCRIPT&gt;window.isomorphicDir='isomorphic/';&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Core.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Foundation.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Containers.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Grids.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Forms.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_DataBinding.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT SRC=isomorphic/system/modules/ISC_Analytics.js&gt;&lt;/SCRIPT&gt;\n &lt;SCRIPT src=isomorphic/skins/SmartClient/load_skin.js&gt;&lt;/SCRIPT&gt;\n </pre>\n Notice the addition of the line that loads <code>ISC_Analytics.js</code>.  SmartClient\n modules must be loaded in a particular order and may have dependencies on other modules.\n The <code>loadISC</code> automatically resolves any missing dependencies and includes them\n in the list of modules to load.  The list of modules to load is also automatically reordered\n as required by this tag, so you can specify just the modules you care about, in any order,\n and <code>loadISC</code> will do the right thing.\n <p>\n <b>modules</b><br>\n <i>value format</i>: Comma separated list of modules to load.  See the\n <code>[webroot]/isomorphic/system/modules</code> directory for a list of loadable modules.  The\n leading \"ISC_\" is optional, spaces after commas are also optional.<br>\n <i>default value</i>: \"Core, Foundation, Containers, Grids, Forms, DataBinding\"\n <p>\n Specifying this attribute overrides the default set of modules loaded by\n <code>loadISC</code>. This is useful if you don't need to load all of the default modules on\n a particular page.\n <p>\n <b>locale</b><br>\n <i>value format</i>: String - name of locale to load\n <i>default value</i>: null\n <p>\n Use this attribute to specify a locale to load.  The default value of null omits locale\n loading, which effectively means the framework default \"en\" locale is used.  Note that if\n you're using a mix of <code>loadISC</code> and <code>loadModules</code> tags, or multiple\n <code>loadModules</code> tags, the right place to specify this attribute is on the last\n <code>loadModules</code> tag.\n <p>\n <b>isomorphicURI</b><br>\n <i>value format</i>: absolute or relative (from current URI) path to the\n <code>isomorphic</code> directory (by default, located in webRoot).<br>\n <i>default value</i>: automatically derived\n <p>\n This value sets <code>window.isomorphicDir</code> and defines the base path to SmartClient\n modules from the currently executing JSP.  By default, this value is automatically derived\n and you don't need to override it.  Generally, an override is only required if you're\n pointing multiple web application deployments at one base URL for cache coherence reasons.\n <p>\n <b>defer</b><br>\n <i>value format</i>: boolean - acceptable values: \"true\" or \"false\"<br>\n <i>default value</i>: \"false\"\n <p>\n This attribute applies only if you're using the optional Network Performance component of\n SmartClient.  By default, the modules specified by the <code>loadISC</code> tag are loaded\n synchronously - that is, the browser waits for each module to download before rendering\n any HTML on the page.  Specifying <code>defer=\"true\"</code> makes the module load\n asynchronous.  In this mode, all the page content except the modules specified by\n <code>loadISC</code> is loaded and rendered first, and then the SmartClient modules are\n loaded.  The asynchronous mode makes it possible to render some content and allow the user\n to interact with the site immediately, while SmartClient modules load in the background.\n <p>\n Note that typically SmartClient modules are delivered compressed with cache headers, so the\n download delay really only affects first time users of your site, those whose cached\n versions have expired, or if you've upgraded your SmartClient module to a newer version that\n the user has cached.\n <p>\n Using this directive is equivalent to calling ${isc.DocUtils.linkForRef('classMethod:FileLoader.loadISC')}.\n <p>\n <b>cacheOnly</b><br>\n <i>value format</i>: boolean - acceptable values: \"true\" or \"false\"<br>\n <i>default value</i>: \"false\"\n <p>\n This attribute applies only if you're using the optional Network Performance component of\n SmartClient.  This works like <code>defer</code> (see above), except that the modules are\n only loaded into the browser cache, but not executed.  This means that when the specified\n modules download, they'll be added to the browser cache, but will not be available to the\n execution context of the page.  Actually executing the module code takes some processing\n time on the client, whereas simply caching it does not.  The typical use case for this\n directive is on some intermediary page before the user gets to a SmartClient-enabled page.\n For example, you could include a cacheOnly <code>loadISC</code> tag on a login page that\n does not use SmartClient components, but protects a SmartClient-enabled application.  While\n the user is typing in their credentials, the SmartClient modules will cache in the\n background, then once the user logs in and is sent to a SmartClient-enabled page, the\n modules are simply read from cache.\n <p>\n Using this directive is equivalent to calling ${isc.DocUtils.linkForRef('classMethod:FileLoader.cacheISC')}.\n <p>\n <b>onload</b><br>\n <i>value format</i>: String - any javascript code<br>\n <i>default value</i>: NONE\n <p>\n This attribute applies only if you're using the optional Network Performance component of\n SmartClient.  This attribute is usable in conjunction with <code>defer</code> and\n <code>cacheOnly</code> attributes.  This attribute allows you to specify a callback to\n execute when loading or caching of the specified modules has completed.  You can use this\n to, for example, replace portions of the page with SmartClient components once SmartClient\n has loaded.\n <p>\n The value of this attribute is passed as the <code>onload</code> handler to the generated\n ${isc.DocUtils.linkForRef('classMethod:FileLoader.cacheISC')} or ${isc.DocUtils.linkForRef('classMethod:FileLoader.loadISC')} call as appropriate.\n <p>\n <b>useSimpleNames</b><br>\n <i>value format</i>: boolean - acceptable values: \"true\" or \"false\"<br>\n <i>default value</i>: \"true\"\n <p>\n Setting this attribute to false puts SmartClient in namespace mode.  See ${isc.DocUtils.linkForRef('class:isc')}\n for more info.",
        treeLocation:[
            "Java Server Reference/SmartClient JSP Tags"
        ],
        type:"group",
        title:"&lt;isomorphic:loadISC&gt;",
        seeAlso:[
        ],
        requiresModules:[
            "SCServer"
        ]
    },
    "classMethod:FilterBuilder.getFilterDescription":{
        ref:"classMethod:FilterBuilder.getFilterDescription",
        deprecated:null,
        name:"getFilterDescription",
        flags:"",
        description:" Returns a human-readable string describing the clauses in this advanced criteria or criterion.\n \n",
        definingClass:"class:FilterBuilder",
        returns:{
            description:"Human-readable string describing the clauses in the passed criteria",
            type:"String"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"Criteria to convert to a readable string",
                optional:false,
                type:"AdvancedCriteria or Criterion"
            },
            {
                defaultValue:null,
                name:"dataSource",
                description:"DataSource to provide definitions of operators",
                optional:false,
                type:"DataSource"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ToolStripGroup.controls":{
        ref:"attr:ToolStripGroup.controls",
        defaultValue:"null",
        valueType:"Array of Widget",
        deprecated:null,
        name:"controls",
        flags:"IRW",
        description:"The array of controls to show in this group.",
        definingClass:"class:ToolStripGroup",
        type:"attr",
        setter:[
            "setControls"
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.fieldIsEditable":{
        ref:"method:ListGrid.fieldIsEditable",
        deprecated:null,
        name:"fieldIsEditable",
        flags:"",
        description:" Can the field be edited?  This method looks at ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit')} for the grid as well as the\n ${isc.DocUtils.linkForRef('attr:ListGridField.canEdit')} value, to determine whether editing is actually allowed.\n For a detailed discussion, see the documentation at ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit')}.\n\n",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"whether field can be edited",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"field",
                description:"field object or identifier",
                optional:false,
                type:"ListGridField | number | string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.datetimeFormatter":{
        ref:"attr:ListGrid.datetimeFormatter",
        defaultValue:"null",
        valueType:"DateDisplayFormat",
        deprecated:null,
        name:"datetimeFormatter",
        flags:"IRW",
        description:"Display format to use for fields specified as type 'datetime'.  Default is to use the\n system-wide default date time format, configured via\n ${isc.DocUtils.linkForRef('classMethod:Date.setShortDatetimeDisplayFormat')}.  Specify any\n valid ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} to change the display format for datetimes used by this grid.\n \n May be specified as a function. If specified as  a function, this function will be executed in the scope of the Date\n and should return the formatted string.\n \n <P>\n May also be specified at the field level via\n ${isc.DocUtils.linkForRef('attr:ListGridField.dateFormatter')}\n <P>\n If this field is editable the dateFormatter will also be passed to the editor created\n to edit this field as ${isc.DocUtils.linkForRef('attr:DateItem.dateFormatter','dateFormatter')}.\n In this case you may also need to set ${isc.DocUtils.linkForRef('attr:ListGrid.dateInputFormat')}.",
        groups:[
            "appearance"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.dateFormatter",
                description:null
            }
        ]
    },
    "attr:FormItem.decimalPad":{
        serverDS:"allowed",
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"Applies only to fields of type \"float\" and enforces a minimum number of digits shown after\n the decimal point.\n <P>\n For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10\n if decimalPad is 2.\n <P>\n The original unpadded value is always shown when the value is edited.",
        groups:[
            "appearance"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:FormItem.decimalPad",
        valueType:"number",
        name:"decimalPad",
        definingClass:"class:FormItem"
    },
    "attr:MultiSortPanel.directionFieldTitle":{
        ref:"attr:MultiSortPanel.directionFieldTitle",
        defaultValue:"\"Order\"",
        valueType:"String",
        deprecated:null,
        name:"directionFieldTitle",
        flags:"IR",
        description:"The title-text to appear in the header of the \"direction\" field.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiSortPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SplitPane.showMiniNav":{
        ref:"attr:SplitPane.showMiniNav",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showMiniNav",
        flags:"IR",
        description:"If true, a ${isc.DocUtils.linkForRef('class:MiniNavControl')} will be shown:\n <ul>\n <li>In the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigationBar')} when the device mode is\n     \"handset\"\n     \n     and the ${isc.DocUtils.linkForRef('attr:SplitPane.currentPane','currentPane')} is\n     \"detail\".\n     \n <li>In the ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolStrip','detailToolStrip')} when the device mode is\n     \"tablet\"\n     \n     and the ${isc.DocUtils.linkForRef('attr:SplitPane.pageOrientation','pageOrientation')} is\n     \"portrait\".\n     \n </ul>\n <p>",
        definingClass:"class:SplitPane",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:SplitPane.detailNavigationControl",
                description:null
            }
        ]
    },
    "attr:ListGrid.autoFitExtraRecords":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code>\n this property specifies the number of additional records for which the grid\n will expand. If more\n records are present, scrolling will be introduced to reach them as normal.",
        groups:[
            "autoFitData"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.autoFitExtraRecords",
        valueType:"number",
        name:"autoFitExtraRecords",
        definingClass:"class:ListGrid",
        setter:[
            "setAutoFitExtraRecords"
        ]
    },
    "attr:MultiGroupPanel.propertyFieldTitle":{
        ref:"attr:MultiGroupPanel.propertyFieldTitle",
        defaultValue:"\"Column\"",
        valueType:"String",
        deprecated:null,
        name:"propertyFieldTitle",
        flags:"IR",
        description:"The title-text to appear in the header of the \"property\" field.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiGroupPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TabSet.paneContainerOverflow":{
        ref:"attr:TabSet.paneContainerOverflow",
        defaultValue:"Canvas.AUTO",
        valueType:"Overflow",
        deprecated:null,
        name:"paneContainerOverflow",
        flags:"IRWA",
        description:"Specifies the overflow of the pane container (the component that holds the pane contents\n for all tabs).  By default this is set to \"auto\", meaning the pane container will\n automatically introduce scrolling when the pane contents exceed the TabSet's specified\n size.\n <p>\n For other values and their meaning, see ${isc.DocUtils.linkForRef('type:Overflow')}",
        definingClass:"class:TabSet",
        type:"attr",
        setter:[
            "setPaneContainerOverflow"
        ],
        seeAlso:[
        ]
    },
    "attr:SectionStackSection.expanded":{
        ref:"attr:SectionStackSection.expanded",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"expanded",
        flags:"I",
        description:"Sections default to the collapsed state unless ${isc.DocUtils.linkForRef('attr:SectionStackSection.showHeader')} is\n set to <code>false</code> in which case they default to the expanded state.  This\n attribute allows you to explicitly control the expand/collapse state of the\n section by overriding the above default behavior.",
        definingClass:"object:SectionStackSection",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CellSelection.selectSingleCell":{
        ref:"method:CellSelection.selectSingleCell",
        deprecated:null,
        name:"selectSingleCell",
        flags:"",
        description:"   select a single cell and deselect everything else\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CellSelection",
        returns:{
            description:"true == selection actually changed, false == no change",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row index of cell to select",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column index of cell to select",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Selection.getSelection":{
        ref:"method:Selection.getSelection",
        deprecated:null,
        name:"getSelection",
        flags:"",
        description:" Return an ordered array of all of the selected items\n",
        groups:[
            "selection"
        ],
        definingClass:"class:Selection",
        returns:{
            description:"list of selected items",
            type:"array"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"excludePartialSelections",
                description:"When true, partially selected records will not be returned.                                   Otherwise, all fully and partially selected records are\n                                   returned.",
                optional:true,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Canvas.contextMenu":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRWA",
        description:"Context menu to show for this object, an instance of the Menu widget.\n <P>\n Note: if ${isc.DocUtils.linkForRef('method:Canvas.destroy')} is called on a canvas, any specified context menu is\n not automatically destroyed as well. This is in contrast to ${isc.DocUtils.linkForRef('class:MenuButton')}s which\n automatically destroy their specified ${isc.DocUtils.linkForRef('attr:MenuButton.menu')} by default. The behavior\n is intentional as context menus are commonly reused across components.",
        groups:[
            "cues"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"method:Canvas.showContextMenu",
                description:null
            }
        ],
        ref:"attr:Canvas.contextMenu",
        examples:[
            "${isc.DocUtils.linkForExampleId('contextMenus')}"
        ],
        valueType:"Menu",
        name:"contextMenu",
        definingClass:"class:Canvas"
    },
    "method:DynamicForm.clearFieldErrors":{
        ref:"method:DynamicForm.clearFieldErrors",
        deprecated:null,
        name:"clearFieldErrors",
        flags:"",
        description:" Clear any validation errors on the field passed in.\n",
        groups:[
            "errors"
        ],
        definingClass:"class:DynamicForm",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldName",
                description:"field to clear errors from",
                optional:false,
                type:"string"
            },
            {
                defaultValue:null,
                name:"show",
                description:"If true this method will fall through to ${isc.DocUtils.linkForRef('method:DynamicForm.showFieldErrors')}  to update the display",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:FormItem.valueIconWidth":{
        ref:"attr:FormItem.valueIconWidth",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"valueIconWidth",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.valueIcons')} is specified, use this property to specify a width for\n the value icon written out.",
        groups:[
            "valueIcons"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.valueIconHeight",
                description:null
            },
            {
                ref:"attr:FormItem.valueIconSize",
                description:null
            }
        ]
    },
    "method:EditPane.getDefaultPalette":{
        ref:"method:EditPane.getDefaultPalette",
        defaultValue:"null",
        valueType:"Palette",
        deprecated:null,
        name:"getDefaultPalette",
        flags:"",
        description:"${isc.DocUtils.linkForRef('interface:Palette')} to use when an ${isc.DocUtils.linkForRef('object:EditNode')} is being created directly by this EditContext,\n instead of being created due to a user interaction with a palette (eg dragging from\n a ${isc.DocUtils.linkForRef('class:TreePalette')}, or clicking on ${isc.DocUtils.linkForRef('class:MenuPalette')}).\n <P>\n If no defaultPalette is provided, the EditContext uses an automatically created\n ${isc.DocUtils.linkForRef('class:HiddenPalette')}.",
        definingClass:"class:EditPane",
        returns:{
            description:"the default Palette",
            type:"Palette"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:Palette.setDefaultEditContext":{
        ref:"method:Palette.setDefaultEditContext",
        deprecated:null,
        name:"setDefaultEditContext",
        flags:"",
        description:" Sets the default EditContext that this palette should use.  Palettes generally create components via\n drag and drop, but may also support creation via double-click or other UI idioms when a\n defaultEditContext is set.\n",
        definingClass:"interface:Palette",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"defaultEditContext",
                description:"the default EditContext used by this Palette",
                optional:false,
                type:"EditContext or EditTree or EditPane"
            }
        ],
        seeAlso:[
        ]
    },
    "method:FormItem.isDrawn":{
        ref:"method:FormItem.isDrawn",
        deprecated:null,
        name:"isDrawn",
        flags:"",
        description:" Returns true if this item has been written out into the DOM.\n\n",
        groups:[
            "drawing"
        ],
        definingClass:"class:FormItem",
        returns:{
            description:"whether this item is drawn",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "class:EventWindow":{
        classAttrs:[
        ],
        ref:"class:EventWindow",
        methods:[
        ],
        deprecated:"in favor of ${isc.DocUtils.linkForRef('class:EventCanvas')}",
        name:"EventWindow",
        description:"Subclass of Window used to display events within a ${isc.DocUtils.linkForRef('class:Calendar')}.  Customize via\n ${isc.DocUtils.linkForRef('attr:Calendar.eventWindow')}.",
        treeLocation:[
            "Client Reference/Calendar"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
        ]
    },
    "attr:CubeGrid.wrapFacetTitles":{
        ref:"attr:CubeGrid.wrapFacetTitles",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"wrapFacetTitles",
        flags:"IRW",
        description:"Whether to allow text wrapping on facet titles.",
        groups:[
            "gridLayout"
        ],
        definingClass:"class:CubeGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Window.bringToFrontOnMouseUp":{
        ref:"attr:Window.bringToFrontOnMouseUp",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"bringToFrontOnMouseUp",
        flags:"IRW",
        description:"Should this window automatically be shown at the top of the page's z-order and\n be brought to front via ${isc.DocUtils.linkForRef('method:Canvas.bringToFront')} whenever the user clicks it?\n <P>\n If ${isc.DocUtils.linkForRef('attr:Window.isModal')} is true for this window, this setting will have no effect - we\n always bring the window to the front on initial display and on mouseDown.\n By default we also do this for non-modal windows (which matches user expectation for\n most standard interfaces - think of switching between OS-level application windows), but \n this may be disabled for cases where it is not appropriate by setting this attribute to\n <code>false</code>",
        definingClass:"class:Window",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.headerBaseStyle":{
        ref:"attr:ListGrid.headerBaseStyle",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"headerBaseStyle",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('attr:Button.baseStyle')} to apply to the buttons in the header, and the sorter, for\n this ListGrid.\n Note that, depending on the ${isc.DocUtils.linkForRef('attr:ListGrid.headerButtonConstructor','Class')} of the header\n buttons, you may also need to set ${isc.DocUtils.linkForRef('attr:ListGrid.headerTitleStyle')}.",
        groups:[
            "gridHeader",
            "appearance"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:componentSchema":{
        ref:"group:componentSchema",
        refs:[
            "attr:DataSourceField.xmlAttribute",
            "attr:DataSourceField.childTagName",
            "attr:DataSourceField.propertiesOnly",
            "attr:DataSourceField.inapplicable",
            "attr:DataSourceField.group",
            "attr:DataSourceField.multiple"
        ],
        deprecated:null,
        name:"componentSchema",
        description:"A component schema is a special type of DataSource that describes a custom component.  \n <P>\n Declaring a component schema for your custom component allows you to:\n <ul>\n <li> use simpler XML when creating your custom component: avoid having to specify the\n <code>constructor</code> and <code>xsi:type</code> attributes as described under\n ${isc.DocUtils.linkForRef('group:componentXML')}\n <li> use your custom component within ${isc.DocUtils.linkForRef('group:visualBuilder')}\n </ul>\n <P>\n <b>Example of a Component Schema</b>\n <P>\n In its most basic form, a component schema for a custom subclass of ListGrid called\n \"MyListGrid\" looks like this:\n <pre>\n &lt;DataSource serverType=\"component\" ID=\"MyListGrid\" \n             inheritsFrom=\"ListGrid\" instanceConstructor=\"MyListGrid\"/&gt;\n </pre>\n With this definition saved as \"MyListGrid.ds.xml\" in the project dataSources directory\n ([webroot]/shared/ds/ by default), you can now create an instance of \n MyListGrid with just:\n <pre>\n &lt;MyListGrid width=\"500\"/&gt;\n </pre>\n Note: you may need to restart your servlet engine/J2EE container before this example will\n work.\n <P>\n The attributes set directly on the DataSource tag have special meaning for a component\n schema definition:\n <ul>\n <li>${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')}=\"component\" indicates this DataSource describes\n a component, as opposed to a SQL table or other data provider\n <li>${isc.DocUtils.linkForRef('attr:DataSource.ID','ID')} means the tagName that will be used to create your custom\n component.  This must match the first component of the filename. (ID=\"MyListGrid\" means the filename \n must be MyListGrid.ds.xml, and typically also matches the name of the class).\n <li>${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')}=\"ListGrid\" inherits the ListGrid property definitions via\n ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')}.  \n <li>instanceConstructor=\"MyListGrid\" indicates the \n SmartClient class that\n ${isc.DocUtils.linkForRef('classMethod:Class.create','create()')} should be called on to construct \n an instance.\n \n <li>showLocalFieldsOnly is a boolean that, when set to true, tells the ${isc.DocUtils.linkForRef('group:visualBuilder')}\n to show only the fields declared in this schema in the component editor.  Otherwise fields\n inherited via ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')} (all the way up the chain) are also included.\n <li>showSuperClassEvents is a boolean that, like showLocalFieldsOnly, optionally restricts\n the list of events shown in the Events tab of the ${isc.DocUtils.linkForRef('group:visualBuilder')} to those defined in\n this schema only.\n <li>showSuperClassActions is a boolean that optionally restricts the list of actions shown\n in the menu when you map a component Event to a component Action within ${isc.DocUtils.linkForRef('group:visualBuilder')}\n to those defined in this schema only.\n \n </ul>\n <P>\n <b>Declaring custom properties</b>\n <P>\n Custom properties are declared via ${isc.DocUtils.linkForRef('attr:DataSource.fields','fields')} as for an ordinary\n ${isc.DocUtils.linkForRef('class:DataSource')}.  As with ordinary DataSources, it is legal to redeclare inherited fields\n in order to modify properties such as ${isc.DocUtils.linkForRef('attr:DataSourceField.editorType','field.editorType')}.\n <P>\n The following DataSourceField properties have special significance when a component schema\n is used to process ${isc.DocUtils.linkForRef('group:componentXML','component XML')}:\n <ul>\n <li> ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field.type')} declares the type of the field, and hence the\n type of the JavaScript value your custom class will be \n initialized with.  In order to declare subcomponents, can be set to the name of another component \n (built-in or custom).  \n <li> ${isc.DocUtils.linkForRef('attr:DataSourceField.multiple','field.multiple')} declares that the field should always be\n array-valued even when only a single value is provided.  Also indicates that the field name\n should be used as a \"wrapper tag\" in the XML format for the component.\n <li> ${isc.DocUtils.linkForRef('attr:DataSourceField.propertiesOnly','field.propertiesOnly')}.  For fields that hold\n subcomponents, suppresses auto-construction to avoid ${isc.DocUtils.linkForRef('attr:Canvas.autoDraw','double drawing')}\n and to allow subcomponents to be modified by their parent component before they are created\n and drawn\n </ul>\n When a component is edited within Visual Builder, the DataSource properties that normally\n influence databound forms will influence the Component Editor (for example, field.title,\n field.editorType).  In addition, the following properties have special significance in\n component editing and component drag and drop:\n <ul>\n <li> ${isc.DocUtils.linkForRef('attr:DataSourceField.inapplicable','field.inapplicable')} indicates that an inherited\n field is inapplicable in this component.\n <li> ${isc.DocUtils.linkForRef('attr:DataSourceField.group','field.group')} indicates what group the property should be\n placed in when editing in Visual Builder.\n <li> ${isc.DocUtils.linkForRef('attr:DataSourceField.xmlAttribute','field.xmlAttribute')}: indicates this field should\n serialize as an XML attribute.  Note that when constructing the component from XML, either\n an attribute or a subelement will continue to be accepted as means of specifying the field\n value, so this property is primarily set in order to make code generated by Visual Builder\n maximally compact or to make it conform to externally set standards.\n </ul>\n <P>\n\n \n <b>Declaring Events and Actions</b>\n <P>\n Events and Actions are declared via a methods array.  In order for a method to be considered\n an event, it needs to have a method definition in the methods array (or be publicly\n documented in the SmartClient reference) and have been added to\n the class as a ${isc.DocUtils.linkForRef('group:stringMethods','StringMethod')} via ${isc.DocUtils.linkForRef('classMethod:Class.registerStringMethods')}.\n <p>\n In order for a method to be considered an action, it needs to have a method definition in\n the methods array and have the <code>action</code> property set to <code>true</code>.  For\n example, the following is a definition of the 'hide' action available on any Canvas, as\n copied from Canvas.ds.xml:\n <pre>\n     &lt;methods&gt;\n         &lt;method name=\"hide\" title=\"Hide\" action=\"true\"/&gt;\n     &lt;/methods&gt;\n </pre>\n For custom component actions, an array of expected parameters may be specified using the\n <code>params</code> attribute. Each entry in this array should have a specified type.\n By doing this, you allow the visual builder to pass parameters through to actions when setting \n up events that call actions (possibly on another component).\n For example if you had a component with a custom action that expected to be passed a single\n parameter of type ${isc.DocUtils.linkForRef('object:ListGridRecord')} you could define it as follows:\n <pre>\n     &lt;method name=\"showRecordDetails\" title=\"Show Record Details\" action=\"true\"&gt;\n         &lt;params&gt;\n             &lt;param type=\"ListGridRecord\"/&gt;\n         &lt;params&gt;\n     &lt;/method&gt;\n </pre>\n If a user working within the visualBuilder then added ListGrid to the page and used the \"+\" icon\n to associate the ${isc.DocUtils.linkForRef('method:ListGrid.recordClick','recordClick')} event with this custom method, the\n Visual Builder logic would automatically associate the parameters available in the fired event\n (in this case <code>recordClick</code>) with the expected parameters for the action to fire \n by type. So the <code>record</code> parameter of the event (known to be of type \n <code>ListGridRecord</code>) would be passed through to this custom <i>showRecordDetails</i>\n action as the first parameter.\n ",
        treeLocation:[
            "Concepts/Visual Builder"
        ],
        type:"group",
        title:"Component Schema",
        seeAlso:[
        ]
    },
    "attr:TileGrid.tileDragAppearance":{
        ref:"attr:TileGrid.tileDragAppearance",
        defaultValue:"EventHandler.TRACKER",
        valueType:"DragAppearance",
        deprecated:null,
        name:"tileDragAppearance",
        flags:"IRWA",
        description:"Visual appearance to show when the tile is being dragged.",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:TileGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Canvas.dragAppearance",
                description:null
            }
        ]
    },
    "attr:MenuBar.menus":{
        ref:"attr:MenuBar.menus",
        defaultValue:"null",
        valueType:"Array of Menu",
        deprecated:null,
        name:"menus",
        flags:"IRW",
        description:"An array of menu object initializers or instantiated menu objects. Buttons for each\n menu item will automatically be created. See the Menu Widget Class for fundamental\n menu properties and other properties.  Titles for the buttons are derived from the \n <code>title</code> property of each menu.",
        definingClass:"class:MenuBar",
        type:"attr",
        setter:[
            "setMenus"
        ],
        seeAlso:[
            {
                ref:"class:Menu",
                description:null
            }
        ]
    },
    "method:SplitPane.upClick":{
        ref:"method:SplitPane.upClick",
        deprecated:null,
        name:"upClick",
        flags:"",
        description:" Notification method fired when the ${isc.DocUtils.linkForRef('attr:SplitPane.showMiniNav','miniNav is showing')} and the\n up button on the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigationBar')}'s ${isc.DocUtils.linkForRef('class:MiniNavControl')} is\n clicked.\n\n",
        definingClass:"class:SplitPane",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:MultiComboBoxItem.pendingButtonStyle":{
        ref:"attr:MultiComboBoxItem.pendingButtonStyle",
        defaultValue:"\"buttonPending\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"pendingButtonStyle",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('attr:FormItem.showPending','showPending')} is <code>true</code>, the ${isc.DocUtils.linkForRef('attr:Button.baseStyle')}\n used on ${isc.DocUtils.linkForRef('attr:MultiComboBoxItem.button','buttons')} that are in the \"Pending\" visual state.\n <p>\n If unset, then the <code>baseStyle</code> of pending buttons is not changed.",
        definingClass:"class:MultiComboBoxItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:MultiComboBoxItem.deselectedButtonStyle",
                description:null
            }
        ]
    },
    "method:ButtonItem.setTitle":{
        ref:"method:ButtonItem.setTitle",
        deprecated:null,
        name:"setTitle",
        flags:"",
        description:" Set the title.\n",
        groups:[
            "appearance"
        ],
        definingClass:"class:ButtonItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"newTitle",
                description:"new title",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DynamicForm.method":{
        defaultValue:"DynamicForm.POST",
        deprecated:null,
        flags:"IRW",
        description:"The mechanism by which form data is sent to the action URL. See FormMethod type\n for details.\n <p>\n <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data\n directly to a URL.  Normal server contact is through \n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')}.",
        groups:[
            "submitting"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DynamicForm.method",
        valueType:"FormMethod",
        name:"method",
        definingClass:"class:DynamicForm",
        setter:[
            "setMethod"
        ]
    },
    "classAttr:FacetChart.chartTypeBubbleTitle":{
        ref:"classAttr:FacetChart.chartTypeBubbleTitle",
        defaultValue:"\"Bubble\"",
        valueType:"HTML",
        deprecated:null,
        name:"chartTypeBubbleTitle",
        flags:"IRW",
        description:"Title for the <code>\"Bubble\"</code> item in the <code>\"Chart Type\"</code> submenu in the\n context menu.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FacetChart",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:Chart.getFacetValue":{
        ref:"method:Chart.getFacetValue",
        deprecated:null,
        name:"getFacetValue",
        flags:"",
        description:" Get facet value definition by facetId and facetValueId.\n",
        definingClass:"interface:Chart",
        returns:{
            description:"the FacetValue if found, or null",
            type:"FacetValue"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetId",
                description:"the id of the facet to retrieve",
                optional:false,
                type:"String"
            },
            {
                defaultValue:null,
                name:"facetValueId",
                description:"the id of the facet value to retrieve",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
            {
                ref:"class:FacetValue",
                description:null
            }
        ]
    },
    "method:FacetChart.getMedian":{
        ref:"method:FacetChart.getMedian",
        deprecated:null,
        name:"getMedian",
        flags:"",
        description:" Calculate the median of the data over a single metric.\n See <a href=\"http://en.wikipedia.org/wiki/Median\">http://en.wikipedia.org/wiki/Median</a>.\n <p>\n The first argument, criteria, determines which metric is used to calculate the median.\n The criteria may be a String that is the \"id\" of some ${isc.DocUtils.linkForRef('class:FacetValue')} of\n the metric facet, or a ${isc.DocUtils.linkForRef('object:FacetValueMap')} that contains an entry for the metric facet,\n or null to use the ${isc.DocUtils.linkForRef('attr:FacetChart.valueProperty')}.  A FacetValueMap criteria may also be used to restrict\n the calculation to a slice of the data.\n",
        definingClass:"class:FacetChart",
        returns:{
            description:"the median of the data values",
            type:"Float"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"the \"id\" of a metric facet value, or a set of mappings describing the data over which to calculate, or null",
                optional:false,
                type:"String | FacetValueMap"
            }
        ],
        seeAlso:[
        ]
    },
    "method:CubeGrid.closeFacet":{
        ref:"method:CubeGrid.closeFacet",
        deprecated:null,
        name:"closeFacet",
        flags:"",
        description:"\n  Handler fired when facet is closed\n\n      <br><i>methodType</i> handler\n",
        groups:[
            "columnControls"
        ],
        definingClass:"class:CubeGrid",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"facetId",
                description:"ID of facet that was closed",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "type:TextMatchStyle":{
        ref:"type:TextMatchStyle",
        values:[
            {
                description:"case-insensitive exact match (\"foo\" matches \"foo\" and \"FoO\", but not \"FooBar\")",
                value:"\"exact\""
            },
            {
                description:"case-sensitive exact match (\"foo\" matches only \"foo\")",
                value:"\"exactCase\""
            },
            {
                description:"case-insenstive substring match (\"foo\" matches \"foobar\" and \"BarFoo\")",
                value:"\"substring\""
            },
            {
                description:"case-insensitive prefix match (\"foo\" matches \"FooBar\" but not \"BarFoo\") <p>\n textMatchStyle behavior is consistent across the client and all three of the built-in\n server DataSource implementations - SQL, Hibernate and JPA - to the maximum extent that is\n practical.  Known inconsistencies, some of which can be tweaked with configuration settings,\n are described below<ul>\n <li>textMatchStyle can be disabled for any individual field with the \n ${isc.DocUtils.linkForRef('attr:DataSourceField.ignoreTextMatchStyle')} declaration.  This behavior is consistent\n across client and server implementations, with the proviso that case-sensitive behavior \n is inherently inconsistent in the server-side implementations (see below for a more\n detailed discussion of this)</li>\n <li>textMatchStyle is forced to \"exactCase\" for ${isc.DocUtils.linkForRef('attr:DataSourceField.primaryKey','primaryKey')} \n fields on <code>update</code> and <code>remove</code> operations, unless\n ${isc.DocUtils.linkForRef('attr:OperationBinding.allowMultiUpdate')} is in force.  This means that a normal update\n or remove operation - which is constrained by a unique primaryKey value or combination, to \n affect only a single data row - will use an equality match on all primaryKey fields.  This\n is desirable because it makes index usage more likely.  Note that this means the key values\n \"foo\" and \"FOO\" are distinct, which is a change from previous behavior.  For most databases,\n this change will have no effect because most databases do not by default allow primaryKey \n values that only differ in case anyway - if a table has a row with a PK of \"foo\" and you \n try to insert a row with a PK of \"FOO\", most databases will fail with a constraint violation.\n However, if you are using a database hat allows key values that differ only in case, and you \n need to support this for some reason, you can switch the framework back to the previous \n behavior by setting property <code>allow.case.sensitive.pks</code> to <code>true</code> in\n your <code>server.properties</code> file.  Note, we do not recommend this; in fact, we do \n not recommend the use of text primaryKey fields at all.  Where you have control ,we would \n always recommend the use of automatically incrementing numeric sequence keys.</li>\n <li>textMatchStyle does not apply to boolean or temporal (date, datetime, time)\n ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field types')}.  Such fields are always checked for equality.  If \n you have a need for more complex matching, such as date-range checking, use AdvancedCriteria</li>\n <li>Critiera values for temporal fields <b>must</b> be real dates (Javascript <code>Date</code>\n objects on the client, instances of <code>java.util.Date</code> on the server).  Attempting\n to match against a string or any other type of value will result in an \"always fails\" \n clause being generated.  This behavior is how the client code has always worked, but is a \n change for the server-side DataSources, in the interests of consistency.  The previous\n behavior was:<ul>\n   <li>SQLDataSource used to attempt to match the date column to the criteria value provided;\n   if that value was an appropriately-formatted string, that attempt <i>might</i> have \n   worked, but it would be database-specific.  If you have an application that depends on \n   this old behavior, you can switch it back on by adding the following to your\n   <code>server.properties</code> file: \n   <code>sql.temporal.fields.require.date.criteria: false</code></li>\n   <li>HibernateDataSource and JPADataSource used to skip such clauses altogether, which \n   results in the opposite behavior (there is an implied \"always succeeds\" clause, because \n   the clause is not present in the query at all).  If you have an application that depends on \n   this old behavior, you can switch it back on by adding the following to your\n   <code>server.properties</code> file: \n   <code>jpa.temporal.fields.require.date.criteria: false</code> or \n   <code>hibernate.temporal.fields.require.date.criteria: false</code>, as appropriate</li>\n </ul></li>\n <li>textMatchStyle does not apply to fields used in the joins generated to satisfy \n ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom','includeFrom')} declarations or entity relations in\n Hibernate or JPA.  Again, such comparisons are always for equality</li>\n <li>textMatchStyle is applied to numeric fields <b>only</b> if the supplied criteria value\n is a string.  So for a numeric field \"myNumber\", we will match 10, 100, 110 and 1000 if a \n criteria value of \"10\" (the quoted string) is supplied, but we will only match 10 if a \n criteria value of 10 (the actual number) is supplied<ul>\n   <li>This is a change in behavior for the server-side DataSource implementations, in the \n   interests of consistency with the client behavior.  Previously, all three of the built-in\n   DataSource implementations applied textMatchStyle to numeric fields regardless of the \n   criteria value's type.  If you have an application that depends on this old behavior, \n   you can switch it back on by adding the following to your <code>server.properties</code>\n   file: <code>sql.substring.numeric.criteria: true</code> or \n   <code>hibernate.substring.numeric.criteria: true</code> or \n   <code>jpa.substring.numeric.criteria: true</code>, as appropriate</li>\n </ul></li>\n <li>\"exactCase\" matching cannot be made consistent across all database providers because \n each database has its own idea of whether case-sensitive matching should be the default, \n and how to switch it on and off (if that is even possible)<ul>\n   <li>Microsoft SQL Server must have case-sensitive matching enabled by setting a \n   case-sensitive collation when the database is created (there are more fine-grained \n   options, but we do not recommend them because of the scope for further inconsistency, \n   where \"exactCase\" works correctly on table A but not on table B).  See \n   <a href=http://msdn.microsoft.com/en-us/library/ms175835.aspx>MSDN</a> for details</li>\n   <li>HSQLDB has case sensitivity set with the <code>SET IGNORECASE</code> directive -\n   <a href=http://www.hsqldb.org/doc/guide/ch09.html#set_ignorecase-section>see here</a></li>\n   <li>MySQL is case-insensitive, but since it provides an easy way to do per-query,\n   case-sensitive matching in SQL, we work around it for that database, but <b>only</b> in\n   SQL DataSources</li>\n </ul></li>\n <li>If you are using Hibernate or JPA, whether \"exactCase\" works as expected depends \n entirely on the underlying database.  Unlike the SQL DataSource, where we have fine-grained\n control of the SQL that the database executes, we are constrained by what the ORM will \n allow.  This prevents us from compensating for database quirks, like we do with MySQL's\n case-insensitivity in the SQL DataSource</li>\n </ul>",
                value:"\"startsWith\""
            }
        ],
        deprecated:null,
        name:"TextMatchStyle",
        description:"For \"fetch\" operations, how simple search criteria should be interpreted for text fields \n (and to some extent numeric fields, see the notes below).  For greater flexibility, use \n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.",
        type:"type",
        seeAlso:[
        ]
    },
    "classMethod:XMLTools.loadXML":{
        ref:"classMethod:XMLTools.loadXML",
        deprecated:null,
        name:"loadXML",
        flags:"",
        description:" Load an XML document from the origin server or from a foreign server by relaying through the\n origin server.  An asynchronous callback provides both the XML document and raw text of the\n response.\n <P>\n Relaying through the origin server requires that the ISC HttpProxyServlet be installed and\n accessible.\n \n",
        definingClass:"class:XMLTools",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"URL",
                description:"URL to load the schema from",
                optional:false,
                type:"URL"
            },
            {
                defaultValue:null,
                name:"callback",
                description:"callback to fire when the XML is loaded.  Signature is                             callback(xmlDoc, xmlText)",
                optional:false,
                type:"callback"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"additional properties to set on the RPCRequest                                         that will be issued",
                optional:true,
                type:"RPCRequest"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:Canvas.position":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRWA",
        description:"Absolute or relative, corresponding to the \"absolute\" (with respect to parent) or\n \"relative\" (with respect to document flow) values for the CSS position attribute.\n <P>\n Setting <code>position:\"relative\"</code> enables SmartClient components to be embedded\n directly into the native HTML flow of a page, causing the component to be rendered\n within an existing DOM structure.\n This attribute should only be set to <code>\"relative\"</code> on a top level component\n (a component with no ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas')}).\n <P>\n There are 2 ways to embed relatively positioned canvases in the DOM - by default the\n component will be written out inline when it gets ${isc.DocUtils.linkForRef('method:Canvas.draw','drawn()n')}. For example\n to embed a canvas in an HTML table you could use this code:\n <pre>\n &lt;table&gt;\n   &lt;tr&gt;\n     &lt;td&gt;\n       &lt;script&gt;\n         isc.Canvas.create({autoDraw:true, backgroundColor:\"red\", position:\"relative\"});\n       &lt;/script&gt;\n     &lt;td&gt;\n   &lt;/tr&gt;\n &lt;/table&gt;\n </pre>\n Alternatively you can make use of the ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} attribute.\n <P>\n Relative positioning is intended as a short-term integration scenario while incrementally\n upgrading existing applications.\n Note that relative positioning is not used to manage layout within SmartClient components -\n instead the ${isc.DocUtils.linkForRef('class:Layout')} class would typically be used.\n For best consistency and flexibility across browsers, all SmartClient layout managers\n use absolute positioning.\n <P>\n For canvases with a specified ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')}, this attribute defaults to\n <code>\"relative\"</code>. In all other cases the default value will be\n <code>\"absolute\"</code>.",
        groups:[
            "positioning"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Canvas.position",
        examples:[
            "${isc.DocUtils.linkForExampleId('inlineComponents')}"
        ],
        valueType:"Positioning",
        name:"position",
        definingClass:"class:Canvas"
    },
    "method:DetailViewer.setViewState":{
        ref:"method:DetailViewer.setViewState",
        deprecated:null,
        name:"setViewState",
        flags:"",
        description:" Reset this detail viewer's view state to match the ${isc.DocUtils.linkForRef('type:DetailViewerViewState')} object passed in.<br>\n Used to restore previous state retrieved from the detail viewer by a call to \n ${isc.DocUtils.linkForRef('method:DetailViewer.getViewState')}.\n\n",
        groups:[
            "viewState"
        ],
        definingClass:"class:DetailViewer",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"viewState",
                description:"Object describing the desired view state for the detail viewer",
                optional:false,
                type:"DetailViewerViewState"
            }
        ],
        seeAlso:[
            {
                ref:"method:DetailViewer.getViewState",
                description:null
            }
        ]
    },
    "attr:BlurbItem.editProxyConstructor":{
        ref:"attr:BlurbItem.editProxyConstructor",
        defaultValue:"\"TextItemEditProxy\"",
        valueType:"SCClassName",
        deprecated:null,
        name:"editProxyConstructor",
        flags:"IR",
        description:"Default class used to construct the ${isc.DocUtils.linkForRef('class:EditProxy')} for this component\n when the component is ${isc.DocUtils.linkForRef('method:Canvas.setEditMode','first placed into edit mode')}.",
        definingClass:"class:BlurbItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CheckboxItem.checkedDescription":{
        ref:"attr:CheckboxItem.checkedDescription",
        defaultValue:"\"checked\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"checkedDescription",
        flags:"IRA",
        description:"The description shown in a hover when ${isc.DocUtils.linkForRef('attr:FormItem.showOldValueInHover')} is enabled\n and a value represents the checked state.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:CheckboxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.skinImgDir":{
        ref:"attr:Canvas.skinImgDir",
        defaultValue:"\"images/\"",
        valueType:"URL",
        deprecated:null,
        name:"skinImgDir",
        flags:"IRWA",
        description:"Default directory for skin images (those defined by the class), relative to the\n Page-wide ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','skinDir')}.",
        groups:[
            "images"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataSource.cloneDSResponse":{
        ref:"method:DataSource.cloneDSResponse",
        deprecated:null,
        name:"cloneDSResponse",
        flags:"A",
        description:" Creates a shallow copy of the given ${isc.DocUtils.linkForRef('class:DSResponse')}. All properties that would affect\n the processing of the response are copied into the resulting DSResponse so that the cloned\n response could substitute for the original response. The response's ${isc.DocUtils.linkForRef('attr:DSResponse.data','data')},\n if any, is shallow copied in the cloned response.\n",
        definingClass:"class:DataSource",
        returns:{
            description:"a clone of the given DSResponse object.",
            type:"DSResponse"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dsResponse",
                description:"the DSResponse to clone.",
                optional:false,
                type:"DSResponse"
            }
        ],
        seeAlso:[
            {
                ref:"method:DataSource.cloneDSRequest",
                description:null
            }
        ]
    },
    "classMethod:RPCManager.hasCurrentTransactionQueued":{
        ref:"classMethod:RPCManager.hasCurrentTransactionQueued",
        deprecated:null,
        name:"hasCurrentTransactionQueued",
        flags:"",
        description:" Returns true if there is a current transaction (queue of requests)\n <P>\n This method will return false if no requests are currently queued, even if\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue')} has been called.\n \n",
        definingClass:"class:RPCManager",
        returns:{
            description:"true if there is a current transaction",
            type:"Boolean"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "attr:NavigationBar.leftButtonTitle":{
        ref:"attr:NavigationBar.leftButtonTitle",
        defaultValue:"null",
        valueType:"HTMLString",
        deprecated:null,
        name:"leftButtonTitle",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:Button.title','Title')} for the ${isc.DocUtils.linkForRef('attr:NavigationBar.leftButton','leftButton')}.",
        definingClass:"class:NavigationBar",
        type:"attr",
        setter:[
            "setLeftButtonTitle"
        ],
        seeAlso:[
        ]
    },
    "attr:FormItem.supportsCutPasteEvents":{
        ref:"attr:FormItem.supportsCutPasteEvents",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"supportsCutPasteEvents",
        flags:"IR",
        description:"Does the current formItem support native cut and paste events?\n <P>\n This attribute only applies to freeform text entry fields such as ${isc.DocUtils.linkForRef('class:TextItem')} and\n ${isc.DocUtils.linkForRef('class:TextAreaItem')}, and only if ${isc.DocUtils.linkForRef('attr:FormItem.changeOnKeypress')} is true. \n If true, developers can detect the user editing the value \n via cut or paste interactions (triggered from keyboard shortcuts or the native \n browser menu options) using the ${isc.DocUtils.linkForRef('method:FormItem.isCutEvent')} and\n ${isc.DocUtils.linkForRef('method:FormItem.isPasteEvent')} methods. This allows custom cut/paste handling\n to be added to the various change notification flow methods including \n ${isc.DocUtils.linkForRef('method:FormItem.change')}, ${isc.DocUtils.linkForRef('method:FormItem.handleChange')} and\n ${isc.DocUtils.linkForRef('method:FormItem.transformInput')}.",
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:SQLPagingStrategy":{
        serverDS:"only",
        ref:"type:SQLPagingStrategy",
        values:[
            {
                description:"Specify the paging directly in the SQL query we generate.  The way this is done varies \n considerably from database to database: with some it is a straightforward built-in \n facility while others require arcane tricks or simply don't support the idea.  This is \n the most efficient method, where available.  Note that this strategy is not supported \n for operations that make use of a ${isc.DocUtils.linkForRef('attr:OperationBinding.customSQL','customSQL')} clause, \n because it depends upon being able to determine the size of the whole dataset without\n actually retrieving the whole dataset.  Ordinary operations do this by means of an \n automatically-generated \"row count query\", but we cannot generate such a query for a \n <code>customSQL</code> operation.",
                value:"\"sqlLimit\""
            },
            {
                description:"Implement the paging behavior by use of the <code>absolute()</code> method of the\n JDBC <code>ResultSet</code>.",
                value:"\"jdbcScroll\""
            },
            {
                description:"Implement the paging behavior by fetching the entire resultset from the database and\n dropping any unnecessary rows on the server before returning the data to the client.\n This approach is extremely inefficient, but also extremely straightforward; it is \n intended as a fallback option, for situations where the more sophisticated approaches\n cause problems (a JDBC driver that throws vague exceptions when <code>absolute()</code>\n is called, for example)",
                value:"\"dropAtServer\""
            },
            {
                description:"No paging behavior: we always return the entire resultset to the client.",
                value:"\"none\""
            }
        ],
        deprecated:null,
        name:"SQLPagingStrategy",
        description:"The technique SmartClient Server's SQL DataSource should use to select a \"page\" of data \n from a table.",
        type:"type",
        seeAlso:[
            {
                ref:"attr:DataSource.sqlPaging",
                description:null
            },
            {
                ref:"attr:OperationBinding.sqlPaging",
                description:null
            }
        ]
    },
    "attr:DataSourceField.nativeName":{
        serverDS:"only",
        ref:"attr:DataSourceField.nativeName",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"nativeName",
        flags:"IR",
        description:"Only applicable to \"sql\" dataSources. If set, this property indicates that the field is \n bound to the column named in the property.  It is used to bind a DataSourceField to a \n database column with a different name.\n <p>\n <code>nativeName</code> is useful for disambiguating in cases where you have customized \n SQL.  For example, assume you are joining two tables - call them <code>product</code> and\n <code>supplier</code> - that both contain a column called \"name\".  Only one field in the \n DataSource can be called \"name\"; to disambiguate, we need to specify both \n ${isc.DocUtils.linkForRef('attr:DataSourceField.tableName','tableName')} and <code>nativeName</code>.  A field declaration \n like this would be needed:<br>\n <pre>    &lt;field name=\"supplierName\" type=\"text\" tableName=\"supplier\" nativeName=\"name\" /></pre>\n <p>\n You may also wish to use this property to map legacy column names to more meaningful field\n names in the DataSource.  For example:<br>\n <pre>    &lt;field name=\"productName\" type=\"text\" nativeName=\"PRDNM\" /></pre>\n <p>\n Note that it is not allowed to have multiple fields with the same <code>nativeName</code> \n bound to the same database table.",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DataSourceField.tableName",
                description:null
            }
        ]
    },
    "method:Tree.setSeparateFolders":{
        ref:"method:Tree.setSeparateFolders",
        deprecated:null,
        name:"setSeparateFolders",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:Tree.separateFolders')}.\n",
        definingClass:"class:Tree",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"separateFolders",
                description:"new <code>separateFolders</code> value",
                optional:false,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DrawOval.setRadius":{
        ref:"method:DrawOval.setRadius",
        deprecated:null,
        name:"setRadius",
        flags:"",
        description:" Resize the drawOval by setting its radius, and retaining its current center point.\n Equivalent to <code>setRadii(radius, radius)</code>.\n",
        definingClass:"class:DrawOval",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"radius",
                description:"new radius. This will be applied on both axes, meaning calling this method will always result in the DrawOval being a circle.",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
            {
                ref:"method:DrawOval.setRadii",
                description:null
            }
        ]
    },
    "attr:ToolStrip.separatorClass":{
        ref:"attr:ToolStrip.separatorClass",
        defaultValue:"\"ToolStripSeparator\"",
        valueType:"String",
        deprecated:null,
        name:"separatorClass",
        flags:"IR",
        description:"Class to create when the string \"separator\" appears in ${isc.DocUtils.linkForRef('attr:ToolStrip.members')}.",
        definingClass:"class:ToolStrip",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:GroupingMessages.byQuarterTitle":{
        ref:"classAttr:GroupingMessages.byQuarterTitle",
        defaultValue:"\"by Quarter\"",
        valueType:"string",
        deprecated:null,
        name:"byQuarterTitle",
        flags:"IRW",
        description:"Title to use for the menu option which groups a date field by quarter, across all \n years.  For example, all values that are in Q4 of any year are grouped together.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:GroupingMessages",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:TileLayout.tileHMargin":{
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"Horizontal margin in between tiles.  See ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin')}.",
        groups:[
            "layoutMargin"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:TileLayout.tileHMargin",
        valueType:"int",
        name:"tileHMargin",
        definingClass:"class:TileLayout",
        setter:[
            "setTileHMargin"
        ]
    },
    "method:FilterBuilder.clearCriteria":{
        ref:"method:FilterBuilder.clearCriteria",
        deprecated:null,
        name:"clearCriteria",
        flags:"",
        description:" Clear all current criteria.\n",
        definingClass:"class:FilterBuilder",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:PaletteNode.defaults":{
        ref:"attr:PaletteNode.defaults",
        defaultValue:"null",
        valueType:"Properties",
        deprecated:null,
        name:"defaults",
        flags:"IR",
        description:"Defaults for the component to be created from this palette.  \n <p>\n For example, if ${isc.DocUtils.linkForRef('attr:PaletteNode.type')} is \"ListGrid\", properties valid to pass to\n ${isc.DocUtils.linkForRef('classMethod:Class.create','ListGrid.create()')}.\n <p>\n Note that event handlers or method overrides cannot be configured as <code>defaults</code>,\n as they cannot be serialized or restored.  Instead, create a subclass that implements the\n desired behaviors, and use that subclass as ${isc.DocUtils.linkForRef('attr:PaletteNode.type')}.  \n ",
        definingClass:"object:PaletteNode",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FormItem.inputFormat":{
        ref:"attr:FormItem.inputFormat",
        defaultValue:"null",
        valueType:"DateInputFormat",
        deprecated:null,
        name:"inputFormat",
        flags:"IRWA",
        description:"For fields of type <code>\"date\"</code>, if this is an editable field such as a\n ${isc.DocUtils.linkForRef('class:TextItem')}, this property \n allows you to specify the ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')} applied to the item.",
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.dateFormatter",
                description:null
            }
        ]
    },
    "attr:Canvas.childrenSnapResizeToGrid":{
        ref:"attr:Canvas.childrenSnapResizeToGrid",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"childrenSnapResizeToGrid",
        flags:"IRW",
        description:"If true, causes this canvas's children to snap to its grid when resizing.\n This behavior can be overridden on a per-child basis by setting the\n ${isc.DocUtils.linkForRef('attr:Canvas.snapToGrid','snapToGrid')} or\n ${isc.DocUtils.linkForRef('attr:Canvas.snapResizeToGrid','snapResizeToGrid')} value on the child.",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.showRowNumbers":{
        ref:"attr:ListGrid.showRowNumbers",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showRowNumbers",
        flags:"IRWA",
        description:"When set to true, shows an additional field at the beginning of the field-list\n (respecting RTL) that displays the current rowNum for each record.",
        groups:[
            "rowNumberField"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DateChooser.baseFiscalYearStyle":{
        ref:"attr:DateChooser.baseFiscalYearStyle",
        defaultValue:"\"dateChooserFiscalYearCell\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"baseFiscalYearStyle",
        flags:"IRW",
        description:"Base CSS style applied to cells in the ${isc.DocUtils.linkForRef('attr:DateChooser.showFiscalYearChooser','fiscal year column')}.\n <P>\n See ${isc.DocUtils.linkForRef('group:cellStyleSuffixes')} for details on how stateful suffixes are combined with the\n base style to generate stateful cell styles in Grids.",
        definingClass:"class:DateChooser",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DynamicForm.clearValue":{
        ref:"method:DynamicForm.clearValue",
        deprecated:null,
        name:"clearValue",
        flags:"",
        description:" Clears the value for some field via a call to ${isc.DocUtils.linkForRef('method:FormItem.clearValue')} if appropriate.\n If there is no item associated with the field name, the field will just be cleared within\n our stored set of values.\n",
        definingClass:"class:DynamicForm",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldName",
                description:"Name of the field being cleared. A ${isc.DocUtils.linkForRef('type:DataPath')} may be used for  clearing details of nested data structures.",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "group:debugModules":{
        ref:"group:debugModules",
        refs:[
        ],
        deprecated:null,
        name:"debugModules",
        description:"\n SmartClient comes with a debug / readable version of the SmartClient JS files that may\n be useful during development.\n \n <P><b>\n Note: These are useful only if you are interested in step-through debugging of\n framework JavaScript code using a JavaScript debugger, and we strongly discourage\n this as a primary approach to debugging: the SmartClient framework code provides many,\n many advanced features and is extremely sophisticated as a result.  Learning the\n internals of large parts of SmartClient is unnecessary and ineffective as a debugging\n approach, and the other approaches discussed in ${isc.DocUtils.linkForRef('group:debugging')}\n should be your primary approaches to troubleshooting.</b>\n \n <p>To use the debug modules, simply change each &lt;script&gt; tag's SRC to the URI of the\n debug version of the module. For example:\n <pre>&lt;script src=\"/isomorphic/system/modules/ISC_Core.js\"&gt;&lt;/script&gt;</pre>\n should be changed to:\n <pre>&lt;script src=\"/isomorphic/system/modules<b>-debug</b>/ISC_Core.js\"&gt;&lt;/script&gt;</pre>\n\n <p>Alternatively, the &lt;isomorphic:loadISC&gt; and &lt;isomorphic:loadModules&gt; tags\n support a <code>useDebugModules</code> attribute:\n <pre>&lt;isomorphic:loadISC skin=\"Enterprise\" useDebugModules=\"true\"/&gt;</pre>\n <p>\n Note that the debug modules are intended to help in debugging your own application,\n and not the SmartClient Feature Explorer.  The Feature Explorer is not present\n in modules-debug, and the non-debug version requires the other non-debug files.\n ",
        treeLocation:[
            "Concepts"
        ],
        type:"group",
        title:"Using the Debug Modules",
        seeAlso:[
            {
                ref:"group:debugging",
                description:null
            }
        ]
    },
    "attr:FieldPicker.removeItemTitle":{
        ref:"attr:FieldPicker.removeItemTitle",
        defaultValue:"\"Remove\"",
        valueType:"String",
        deprecated:null,
        name:"removeItemTitle",
        flags:"IR",
        description:"The title shown on the 'Visible Fields' grid's context menu item, whose click handler puts the \nselected item back in the 'Available Fields' collection.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FieldPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:RPCManager.queueSent":{
        ref:"classMethod:RPCManager.queueSent",
        deprecated:null,
        name:"queueSent",
        flags:"",
        description:"\n This method is called by the RPCManager every time it sends a queue of requests to the\n server (note that if you are not using queuing, the system simply sends queues\n containing just one request, so this API is valid regardless).<p>\n There is no default implementation of this method; it is simply an override point.  \n It is intended to be used by user code that needs to be notified when SmartClient sends \n requests to the server.  Note that the list of ${isc.DocUtils.linkForRef('class:RPCRequest')}s passed to this\n method is strictly <b>read-only</b>.\n\n",
        definingClass:"class:RPCManager",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"requests",
                description:"The queue of ${isc.DocUtils.linkForRef('class:RPCRequest')}s that was sent",
                optional:false,
                type:"List of RPCRequest"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.canSort":{
        ref:"attr:ListGrid.canSort",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"canSort",
        flags:"IRW",
        description:"Enables or disables interactive sorting behavior for this listGrid. Does not\n affect sorting by direct calls to the ${isc.DocUtils.linkForRef('method:ListGrid.sort','sort')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.setSort','setSort')} methods.",
        groups:[
            "sorting"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MenuItem.fetchSubmenus":{
        ref:"attr:MenuItem.fetchSubmenus",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"fetchSubmenus",
        flags:"IR",
        description:"If false, no submenus will be fetched for this MenuItem. This can be set globally via\n ${isc.DocUtils.linkForRef('attr:Menu.fetchSubmenus')}.",
        definingClass:"object:MenuItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.customSQL":{
        serverDS:"allowed",
        ref:"attr:DataSourceField.customSQL",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"customSQL",
        flags:"IR",
        description:"For a DataSource with ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"sql\" or \"hibernate\",\n indicates that this field should be omitted by default from all SQL or Hibernate operations,\n and will only be used with ${isc.DocUtils.linkForRef('group:customQuerying','custom queries')}.\n <P>\n Having marked a field as <code>customSQL</code> you can refer to it via\n $criteria.<i>fieldName</i> or $values.<i>fieldName</i> in customized queries.\n <P>\n The following are situations where you would <b>not</b> use <code>customSQL</code>:\n <ul>\n <li>simple joins where you want to enable users to see and search on a field from another\n table; consider ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom')} instead\n <li>fields where you want to calculate or transform values in SQL on load or save, but\n always perform the same calculation for each operationType; consider instead\n ${isc.DocUtils.linkForRef('attr:DataSourceField.sqlStorageStrategy')} for some common cases, or \n ${isc.DocUtils.linkForRef('attr:DataSourceField.customSelectExpression')}, ${isc.DocUtils.linkForRef('attr:DataSourceField.customUpdateExpression')} and\n ${isc.DocUtils.linkForRef('attr:DataSourceField.customInsertExpression')} for full customization\n <li>a special fetch is needed where the field needs to be excluded from the\n $defaultWhereClause so that it can be used in a custom &lt;whereClause&gt; - consider\n ${isc.DocUtils.linkForRef('attr:OperationBinding.excludeCriteriaFields')} instead\n </ul>\n <P>\n Use customSQL in situations like:\n <ul>\n <li>there are multiple variations of the \"fetch\" operation with different\n ${isc.DocUtils.linkForRef('attr:OperationBinding.operationId','operationIds')}, and the field is only used in some of them;\n in that case, consider using ${isc.DocUtils.linkForRef('attr:OperationBinding.customFields')} to selectively re-introduce\n SQL generation for the field only in operations where it's used.\n <li>the field represents hidden criteria on a field in another table where the field is\n never shown to the user\n <li>the field is a write-only value only saved in some operations\n <li>more than one data access strategy is in use (eg direct SQL for fetch and bean-based\n persistence accessed via DMI for saves) and certain fields are not available in SQL\n </ul>",
        definingClass:"class:DataSourceField",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:isA.RegularExpression":{
        ref:"classMethod:isA.RegularExpression",
        deprecated:null,
        name:"RegularExpression",
        flags:"",
        description:"\n\tIs <code>object</code> a Regular Expression (RegExp) object?\n\n",
        definingClass:"object:isA",
        returns:{
            description:"true == <code>object</code> is a Boolean",
            type:"boolean"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"object",
                description:"object to test",
                optional:false,
                type:"object"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:FormItem.showErrorStyle":{
        ref:"attr:FormItem.showErrorStyle",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showErrorStyle",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed when they are displayed inline in the form (next to the form item where there\n is a validation error).  To instead display all errors at the top of the form, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors','showInlineErrors')}:false.\n <P>\n <code>showErrorIcons</code>, <code>showErrorText</code> and <code>showErrorStyle</code>\n are all boolean properties, and can be set on a DynamicForm to control the behavior\n form-wide, or set on individual FormItems.  \n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implementation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:FormItem.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).  \n <P>\n In addition to this, <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')} for a \n discussion for how error styling is calculated.",
        groups:[
            "validation",
            "appearance"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.cellStyle",
                description:null
            }
        ]
    },
    "attr:Menu.initialCriteria":{
        ref:"attr:Menu.initialCriteria",
        defaultValue:"null",
        valueType:"Criteria",
        deprecated:null,
        name:"initialCriteria",
        flags:"IR",
        description:"Criteria to be used when fetching items for this Menu.  Note that \n ${isc.DocUtils.linkForRef('method:ListGrid.setCriteria','setCriteria')} is not supported in Menus.",
        groups:[
            "databinding"
        ],
        definingClass:"class:Menu",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:GridRenderer.showSelectedStyle":{
        ref:"attr:GridRenderer.showSelectedStyle",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"showSelectedStyle",
        flags:"IRW",
        description:"Should the \"Selected\" style be applied to selected records?",
        definingClass:"class:GridRenderer",
        type:"attr",
        seeAlso:[
            {
                ref:"method:GridRenderer.getCellStyle",
                description:null
            }
        ]
    },
    "group:phonegapIntegration":{
        ref:"group:phonegapIntegration",
        refs:[
        ],
        deprecated:null,
        name:"phonegapIntegration",
        description:"<P>\n PhoneGap documentation, quick start information, and programming guides are available at <a href='http://phonegap.com' target='_blank'>http://phonegap.com</a>.\n <P>\n PhoneGap exposes a Contacts API which allows one to find, create and remove contacts from the device's contacts database.\n Unlike Titanium, which provides many native UI components, PhoneGap relies on 3rd party frameworks for \n UI components. Additionally, PhoneGap provides no transitions or other animation effects normally \n accessible in native applications.\n <P>\n <em>In the following guide, the name \"MyMobileApp\" refers to a SmartClient mobile application.\n The instructions are intended to be general, and applicable to other apps by simply substituting\n the application name and the few other app-specific details.</em>\n\n <h3>Installing PhoneGap</h3>\n Beginning with PhoneGap 2.9.0, PhoneGap is an NPM (Node.js Packager Manager) package.\n You will need to install Node.js first in order to install PhoneGap. (<b>Tip for Mac users:</b>\n <a href='http://brew.sh' target='_blank'>Homebrew</a> is a simple and easy way\n to install the latest version of Node.js and npm: <code>brew install node</code>)\n\n <p>Once Node.js is installed, see <a href='http://phonegap.com/install/' target='_blank'>http://phonegap.com/install/</a> for\n instructions on installing PhoneGap.\n\n <h3>Creating the PhoneGap Project</h3>\n Use the <a href='http://docs.phonegap.com/en/edge/guide_cli_index.md.html' target='_blank'><code>phonegap</code> command line utility</a>\n to create a new folder containing the project files:\n\n <pre style=\"white-space:nowrap\">phonegap create --id com.mycompany.apps.MyMobileApp --name \"MyMobileApp\" path/to/project_folder</pre>\n\n <p>The project ID and name should be changed for your app.\n\n <h3>General Instructions</h3>\n Within the project folder, PhoneGap creates a special <code>www/</code> folder which contains\n the application JavaScript code and other assets. Within this folder, only <code>config.xml</code>\n is needed. All other files of the default \"Hello PhoneGap\" app can be deleted.\n\n <p>You will need to open the application's main HTML file in a text editor to make a few changes:\n <ul>\n   <li>Change the DOCTYPE to the HTML5 DOCTYPE: <code>&lt;!DOCTYPE html&gt;</code></li>\n   <li>Add a <code>&lt;script&gt;</code> tag to the <code>&lt;head&gt;</code> element to load <code>cordova.js</code>:\n       <pre>&lt;script type=\"text/javascript\" charset=\"UTF-8\" src=\"cordova.js\"&gt;&lt;/script&gt;</pre>\n\n       <p><b>NOTE:</b> The <code>www/</code> folder should not contain <code>cordova.js</code>.\n       In other words, don't try to copy <code>cordova.js</code> into the <code>www/</code> folder.\n       PhoneGap automatically adds the appropriate version of this script, which is different for\n       each platform.</li>\n   <li>Ensure that the following <code>&lt;meta&gt;</code> tags are used, also in the <code>&lt;head&gt;</code> element:\n       <pre>&lt;meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"&gt;\n&lt;meta name=\"format-detection\" content=\"telephone=no\"&gt;\n&lt;meta name=\"viewport\" content=\"initial-scale=1, width=device-width, user-scalable=no, minimum-scale=1, maximum-scale=1\"&gt;</pre></li>\n </ul>\n\n <p>After making those changes, you will need to defer starting the application until the\n    <code><a href='http://docs.phonegap.com/en/edge/cordova_events_events.md.html#deviceready' target='_blank'>deviceready</a></code> event has fired,\n    particularly if your application invokes any PhoneGap API function.\n\n        In SmartClient, deferring the application can be accomplished by wrapping all application code within a 'deviceready' listener:\n        <pre class=\"sourcefile\">&lt;script type=\"text/javascript\"&gt;\ndocument.addEventListener(\"deviceready\", function onDeviceReady() {\n    // application code goes here\n}, false);\n&lt;/script&gt;</pre>\n\n        \n\n <h3>iOS Platform (iPhone &amp; iPad)</h3>\n\n <ol>\n <li>Open <b>Terminal</b>, <code>cd</code> into the project folder, and run:\n <pre>phonegap build ios</pre></li>\n <li>Within the newly-created <code>platforms/ios/</code> folder, open the Xcode project <code>MyMobileApp.xcodeproj</code>.</li>\n <li>In Xcode, set the active scheme to <b>MyMobileApp &gt; iPhone Retina (4-inch) &gt; iOS 7.0</b> or some other simulator destination.\n     Then click the <b>Run</b> button. Xcode will start the iPhone Simulator and run the app.</li>\n <li>When you are finished testing the application in the simulator, click the <b>Stop</b> button.</li>\n </ol>\n\n <p>It is helpful to pay attention to the output window when testing the app within iOS Simulator.\n The output window contains all logs to <code><a href='https://developer.mozilla.org/en-US/docs/Web/API/console' target='_blank'>window.console</a></code> and messages from the Cordova\n framework itself. One common issue is <code>ERROR whitelist rejection: url='SOMEURL'</code>,\n which means that SOMEURL has not been added to <code>&lt;access origin=\"...\"/&gt;</code> in <code>config.xml</code>.\n Refer to the <a href='http://docs.phonegap.com/en/edge/guide_whitelist_index.md.html#Domain%20Whitelist%20Guide' target='_blank'>Domain Whitelist Guide</a>\n for more information.\n\n <p>Once you have completely tested the application within the simulator, you should test the app on\n real hardware. Refer to Apple's <a href='https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/Introduction/Introduction.html' target='_blank'>App Distribution Guide</a> for complete instructions on provisioning the app for testing devices, in particular, the section titled\n <a href='https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/TestingYouriOSApp/TestingYouriOSApp.html#//apple_ref/doc/uid/TP40012582-CH8-SW1' target='_blank'>Beta Testing Your iOS App</a>.\n\n <h3>Android Platform</h3>\n To begin targeting Android devices, follow the instructions on the\n <a href='http://docs.phonegap.com/en/edge/guide_platforms_android_index.md.html' target='_blank'>Android Platform Guide</a>.\n\n <p>It is helpful to monitor the LogCat view in Eclipse to verify that your application is working correctly.\n Common errors include:\n <ul>\n <li><code>Application Error The protocol is not supported. (gap://ready)</code>\n     <p>This means that the incorrect <code>cordova.js</code> script is being used. You\n     must use the <code>cordova.js</code> for Android.<!-- http://community.phonegap.com/nitobi/topics/error_starting_app_on_android -->\n     <p>Try updating the 'android' platform to fix the problem:\n     <pre>phonegap platform update android</pre>\n     </li>\n <li><code>Data exceeds UNCOMPRESS_DATA_MAX</code>\n     <p>In older versions of Android (pre-2.3.3), there is a 1 Megabyte limit on the size of individual\n        Android app assets. This error message means that one asset file exceeds this limit.\n        You should see a popup alert dialog containing the name of the problematic file, and then the app will crash.\n     <p>The \"Data exceeds UNCOMPRESS_DATA_MAX\" error can be seen if, for example, the SmartGWT.mobile application\n        was compiled in DETAILED or PRETTY mode.\n     </li>\n </ul>\n\n <h3>Samples</h3>\n \n <p>The SmartClient SDK package has a sample application called MyContacts which demonstrates how\n to work with the PhoneGap API in a SmartClient app. The main SmartClient code is located in\n <code>smartclientSDK/examples/phonegap/MyContacts</code>. An Xcode project used to package the app for iOS\n devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-iOS</code>. An Eclipse project used\n to package the app for Android devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-Android</code>.\n ",
        treeLocation:[
            "Concepts/Mobile Application Development"
        ],
        type:"group",
        title:"Integration with PhoneGap",
        seeAlso:[
        ]
    },
    "classAttr:Dialog.DONE_BUTTON_TITLE":{
        ref:"classAttr:Dialog.DONE_BUTTON_TITLE",
        defaultValue:"\"Done\"",
        valueType:"HTML",
        deprecated:null,
        name:"DONE_BUTTON_TITLE",
        flags:"IRW",
        description:"Title for the <code>\"Done\"</code> button.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Dialog",
        type:"classAttr",
        seeAlso:[
            {
                ref:"type:DialogButtons",
                description:null
            }
        ]
    },
    "method:ImgButton.action":{
        ref:"method:ImgButton.action",
        deprecated:null,
        name:"action",
        flags:"",
        description:" This property contains the default 'action' for the Button to fire when activated.\n",
        definingClass:"class:ImgButton",
        type:"method",
        seeAlso:[
        ]
    },
    "attr:SerializationSettings.serverless":{
        ref:"attr:SerializationSettings.serverless",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"serverless",
        flags:"IR",
        description:"When true specify DataSources in full rather than assuming they can be\n downloaded from the server.",
        definingClass:"object:SerializationSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "type:Visibility":{
        ref:"type:Visibility",
        values:[
            {
                description:"The widget visibility will match that of its parent (usually visible).",
                value:"Canvas.INHERIT"
            },
            {
                description:"The widget will always be visible whether its parent is or not.",
                value:"Canvas.VISIBLE"
            },
            {
                description:"The widget will always be hidden even when its parent is visible.",
                value:"Canvas.HIDDEN"
            }
        ],
        deprecated:null,
        name:"Visibility",
        description:null,
        groups:[
            "visibility"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:Button.setBaseStyle":{
        ref:"method:Button.setBaseStyle",
        deprecated:null,
        name:"setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        definingClass:"class:Button",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"style",
                description:"new base style",
                optional:false,
                type:"CSSStyleName"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DateRangeItem.relativeItemConstructor":{
        ref:"attr:DateRangeItem.relativeItemConstructor",
        defaultValue:"\"RelativeDateItem\"",
        valueType:"String",
        deprecated:null,
        name:"relativeItemConstructor",
        flags:"R",
        description:"The ${isc.DocUtils.linkForRef('class:FormItem')} class to create when ${isc.DocUtils.linkForRef('attr:DateRangeItem.allowRelativeDates')} is true.",
        definingClass:"class:DateRangeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CalendarView.eventStyleName":{
        ref:"attr:CalendarView.eventStyleName",
        defaultValue:"null",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"eventStyleName",
        flags:"IRW",
        description:"If specified, overrides ${isc.DocUtils.linkForRef('attr:Calendar.eventStyleName')} and dictates the CSS style to \n use for events rendered in this view.  Has no effect on events that already have a \n ${isc.DocUtils.linkForRef('attr:CalendarEvent.styleName','style specified')}.",
        groups:[
            "appearance"
        ],
        definingClass:"class:CalendarView",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DynamicForm.showErrorIcons":{
        ref:"attr:DynamicForm.showErrorIcons",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showErrorIcons",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed when they are displayed inline in the form (next to the form item where there\n is a validation error).  To instead display all errors at the top of the form, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors','showInlineErrors')}:false.\n <P>\n <code>showErrorIcons</code>, <code>showErrorText</code> and <code>showErrorStyle</code>\n are all boolean properties, and can be set on a DynamicForm to control the behavior\n form-wide, or set on individual FormItems.  \n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implementation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).  \n <P>\n In addition to this, <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')} for a \n discussion for how error styling is calculated.",
        groups:[
            "validation"
        ],
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ColorPicker.modeToggleButtonConstructor":{
        ref:"attr:ColorPicker.modeToggleButtonConstructor",
        defaultValue:"IButton",
        valueType:"Class",
        deprecated:null,
        name:"modeToggleButtonConstructor",
        flags:"IRWA",
        description:"The class of the mode toggle button. It is intended that you use either IButton or \n      Button - other classes are unlikely to work correctly.",
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.zoomChartSlider":{
        ref:"attr:FacetChart.zoomChartSlider",
        defaultValue:"null",
        valueType:"RangeSlider AutoChild",
        deprecated:null,
        name:"zoomChartSlider",
        flags:"IR",
        description:"Slider controls shown on the mini-chart which is created when ${isc.DocUtils.linkForRef('attr:FacetChart.canZoom')} is enabled.",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "object:Shadow":{
        classAttrs:[
        ],
        ref:"object:Shadow",
        methods:[
        ],
        deprecated:null,
        name:"Shadow",
        description:"A class used to define a shadow used in a Draw&lt;Shape&gt; Types.",
        treeLocation:[
            "Client Reference/Drawing"
        ],
        type:"object",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:Shadow.color",
            "attr:Shadow.blur",
            "attr:Shadow.offset"
        ]
    },
    "classMethod:EventHandler.shiftKeyDown":{
        ref:"classMethod:EventHandler.shiftKeyDown",
        deprecated:null,
        name:"shiftKeyDown",
        flags:"",
        description:"\t\t\tReturn true if the shift key is being held down.\n\t\t\tNote that this is only set reliably for keyboard events.\n\n",
        groups:[
            "keyboardEvents"
        ],
        definingClass:"class:EventHandler",
        returns:{
            description:"true == shift key is down",
            type:"Boolean"
        },
        type:"classMethod",
        seeAlso:[
        ]
    },
    "attr:Canvas.shouldPrint":{
        ref:"attr:Canvas.shouldPrint",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"shouldPrint",
        flags:"IRW",
        description:"Whether this canvas should be included in a printable view.\n <P>\n Default is to:\n <ul>\n <li> omit all peers (edges generated by showEdges:true, etc)\n <li> omit anything considered a \"control\", such as a button or menu (see\n ${isc.DocUtils.linkForRef('attr:PrintProperties.omitControls')})\n <li> include everything else not marked shouldPrint:false\n </ul>",
        groups:[
            "printing"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawOval.left":{
        ref:"attr:DrawOval.left",
        defaultValue:"0",
        valueType:"int",
        deprecated:null,
        name:"left",
        flags:"IRW",
        description:"Left coordinate in pixels relative to the ${isc.DocUtils.linkForRef('class:DrawPane','local coordinate system')}.",
        definingClass:"class:DrawOval",
        type:"attr",
        setter:[
            "setLeft"
        ],
        seeAlso:[
        ]
    },
    "attr:DateChooser.timeItem":{
        ref:"attr:DateChooser.timeItem",
        defaultValue:"null",
        valueType:"AutoChild TimeItem",
        deprecated:null,
        name:"timeItem",
        flags:"R",
        description:"${isc.DocUtils.linkForRef('class:TimeItem')} for editing the time portion of dates.  Visible by default for fields \n of type \"datetime\" and can be controlled by setting ${isc.DocUtils.linkForRef('attr:DateChooser.showTimeItem')}.",
        definingClass:"class:DateChooser",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Button.valign":{
        defaultValue:"Canvas.CENTER",
        deprecated:null,
        flags:"IRW",
        description:"Vertical alignment of this component's title.",
        groups:[
            "appearance"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Button.valign",
        valueType:"VerticalAlignment",
        name:"valign",
        definingClass:"class:Button",
        setter:[
            "setVAlign"
        ]
    },
    "type:TileLayoutPolicy":{
        ref:"type:TileLayoutPolicy",
        values:[
            {
                description:"Each line has the same number of tiles, based on ${isc.DocUtils.linkForRef('attr:TileLayout.tilesPerLine')} if set, otherwise,\n based on fitting as many tiles per line as possible consistent with\n ${isc.DocUtils.linkForRef('attr:TileLayout.tileSize','tileSize')} and ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin')}. \n <P>\n Tiles that do not specify a size will be sized to fill available space.",
                value:"\"fit\""
            },
            {
                description:"Tiles are laid out with varying numbers of tiles per line according to each tile's size,\n the ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin','tileMargin')}, and the available space.\n <P>\n Tiles are never resized by the TileLayout and ${isc.DocUtils.linkForRef('attr:TileLayout.tileSize')} is ignored.",
                value:"\"flow\""
            }
        ],
        deprecated:null,
        name:"TileLayoutPolicy",
        description:"Policy for laying out tiles. \n <P>\n Because a TileLayout can be either horizontally or vertically oriented, the general term\n \"line\" is used to mean either a row or column of tiles. \n <P>\n <b>NOTE</b>: for typical form layouts (a variety of input fields and buttons in a\n tabular layout with col-spanning and row-spanning support), use a ${isc.DocUtils.linkForRef('class:DynamicForm')} and\n see the ${isc.DocUtils.linkForRef('group:formLayout')} topic.",
        type:"type",
        seeAlso:[
        ]
    },
    "group:values":{
        ref:"group:values",
        refs:[
            "attr:FormItem.changeOnKeypress",
            "attr:TextItem.changeOnKeypress",
            "attr:TextAreaItem.changeOnKeypress",
            "attr:DetailViewer.valueAlign"
        ],
        deprecated:null,
        name:"values",
        description:"Manipulating the values stored in the form.",
        type:"group",
        seeAlso:[
        ]
    },
    "attr:ListGridField.required":{
        ref:"attr:ListGridField.required",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"required",
        flags:"IRW",
        description:"When the user edits cells in this field, is this value required to be non-empty\n in order for validation to pass.<br>\n Note: for databound listGrids, this property may be specified on the\n ${isc.DocUtils.linkForRef('class:DataSourceField')}, enabling both client and server side validation.",
        groups:[
            "gridValidation"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:ListGridField.validators",
                description:null
            }
        ]
    },
    "attr:HiliteEditor.cancelButton":{
        ref:"attr:HiliteEditor.cancelButton",
        defaultValue:"null",
        valueType:"AutoChild StatefulCanvas",
        deprecated:null,
        name:"cancelButton",
        flags:"IR",
        description:"AutoChild ${isc.DocUtils.linkForRef('class:ImgButton')} that cancels this editor without saving \n any changes, firing the ${isc.DocUtils.linkForRef('attr:HiliteEditor.callback','callback')} with a null\n parameter.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>hiliteEditor.cancelButtonProperties</code>.",
        definingClass:"class:HiliteEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:CubeGrid.getSelectedCells":{
        ref:"method:CubeGrid.getSelectedCells",
        deprecated:null,
        name:"getSelectedCells",
        flags:"",
        description:" Returns an array of the selected cell records.\n\n  <br><i>methodType</i> getter\n",
        groups:[
            "selection"
        ],
        definingClass:"class:CubeGrid",
        returns:{
            description:"array of the selected cell records",
            type:"Array of CellRecord"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:DrawRect.setCenter":{
        ref:"method:DrawRect.setCenter",
        deprecated:null,
        name:"setCenter",
        flags:"",
        description:" Move the drawRect such that it is centered over the specified coordinates.\n",
        definingClass:"class:DrawRect",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"left",
                description:"left coordinate for new center position",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"top",
                description:"top coordinate for new center postiion",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "method:ListGrid.headerHoverHTML":{
        ref:"method:ListGrid.headerHoverHTML",
        deprecated:null,
        name:"headerHoverHTML",
        flags:"A",
        description:" Returns the HTML that is displayed by the default ${isc.DocUtils.linkForRef('method:ListGrid.headerHover','headerHover')}\n handler. Return null or an empty string to cancel the hover.\n \n\n",
        groups:[
            "hovers",
            "gridHeader"
        ],
        definingClass:"class:ListGrid",
        returns:{
            description:"HTML to be displayed in the hover. If null or an empty string, then the hover is canceled.",
            type:"HTMLString"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldNum",
                description:"field number for the header that was hovered",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"defaultHTML",
                description:"the HTML that would have been displayed by default",
                optional:false,
                type:"HTMLString"
            }
        ],
        seeAlso:[
            {
                ref:"attr:ListGrid.showClippedHeaderTitlesOnHover",
                description:null
            },
            {
                ref:"attr:ListGrid.clipHeaderTitles",
                description:null
            }
        ]
    },
    "method:Canvas.removeChild":{
        ref:"method:Canvas.removeChild",
        deprecated:null,
        name:"removeChild",
        flags:"",
        description:" Remove a child from this parent.\n",
        groups:[
            "containment"
        ],
        definingClass:"class:Canvas",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"child",
                description:"Child canvas to remove from this parent.",
                optional:false,
                type:"Canvas"
            },
            {
                defaultValue:null,
                name:"name",
                description:"If the child canvas was assigned a name when added via addChild(), it                        should be passed in here to ensure no reference is kept to the child",
                optional:true,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TimeItem.secondMinValue":{
        ref:"attr:TimeItem.secondMinValue",
        defaultValue:"null",
        valueType:"Number",
        deprecated:null,
        name:"secondMinValue",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondValues','secondValues')} is unset, this attribute specifies the minimum\n value present in the second picker.\n <P>Used for specifying a limited set of valid Second values, or when using the \n TimeItem to record duration, rather than time per-se.  The default is zero in all cases.\n <P> See also ${isc.DocUtils.linkForRef('attr:TimeItem.secondMaxValue','secondMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondIncrement','secondIncrement')}.",
        definingClass:"class:TimeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MenuButton.menuButtonImageUp":{
        ref:"attr:MenuButton.menuButtonImageUp",
        defaultValue:"\"[SKIN]menu_button_up.gif\"",
        valueType:"SCImgURL",
        deprecated:null,
        name:"menuButtonImageUp",
        flags:"IRA",
        description:"Image for menu button indicating that the button expands a menu.  This image is shown\n for menus expanding up from the button.   Menu direction is controlled by\n ${isc.DocUtils.linkForRef('attr:MenuButton.showMenuBelow')}.",
        definingClass:"class:MenuButton",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:MenuButton.menuButtonImage",
                description:null
            }
        ]
    },
    "class:Process":{
        classAttrs:[
        ],
        ref:"class:Process",
        methods:[
            "method:Process.getElement",
            "method:Process.start",
            "method:Process.reset",
            "method:Process.setState",
            "method:Process.finished"
        ],
        deprecated:null,
        name:"Process",
        description:"A instance of Process represents a stateful process executing a series of Tasks, \n which may be:\n <ul>\n <li> user interactions\n <li> calls to DataSources (hence: any database or web service)\n <li> arbitrary code\n <li> other Processes\n </ul>\n A Process is <i>stateful</i> in the sense that it maintains ${isc.DocUtils.linkForRef('attr:Process.state','state')}\n across the different tasks that are executed.  This allows you to maintain context as you\n walk a user through a multi-step business process in your application, which may involve\n multiple operations on multiple entities.  Each Task that executes can use the Process state\n as inputs, and can output a result which is stored in the Process state - see\n ${isc.DocUtils.linkForRef('group:taskIO')}.\n <P>\n A Process can have multiple branches, choosing the next Task to execute based on\n ${isc.DocUtils.linkForRef('type:Criteria')} - see ${isc.DocUtils.linkForRef('class:XORGateway')} and ${isc.DocUtils.linkForRef('class:DecisionGateway')}.\n <P>\n Because a Process may return to a previous Task in various situations, the data model of a\n Process is strictly speaking a <i>graph</i> (a set of nodes connected by arbitary\n interlinks). However, most processes have sequences of several tasks in a row, and the\n definition format allows these to be represented as simple Arrays called \"sequences\",\n specified via ${isc.DocUtils.linkForRef('attr:Process.sequences')}.  This reduces the need to manually specify IDs and\n interlinks for Tasks that simply proceed to the next task in a sequence.\n <P>\n Processes follow all the standard rules for encoding as ${isc.DocUtils.linkForRef('group:componentXML')}, however,\n note that the &lt;Process&gt; tag allows any kind of ${isc.DocUtils.linkForRef('class:ProcessElement')} (tasks, gateways\n and sequences) to appear as a direct subelement of the &lt;Process&gt; tag without the need\n for an intervening &lt;elements&gt; or &lt;sequences&gt; tag.  The example below\n demonstrates this shorthand format.\n <pre>\n &lt;Process ID=\"<i>processId</i>\"&gt;\n     &lt;ServiceTask ID=\"<i>serviceTaskId</i>\" nextElement=\"<i>sequenceId</i>\" ..&gt;\n         &lt;inputFieldList&gt;\n             &lt;value&gt;order.countryName&lt;/value&gt;\n         &lt;/inputFieldList&gt;\n         &lt;outputFieldList&gt;\n             &lt;value&gt;order.countryName&lt;/value&gt;\n             &lt;value&gt;order.continent&lt;/value&gt;\n         &lt;outputFieldList&gt;\n     &lt;/ServiceTask&gt;\n     &lt;sequence ID=\"<i>sequenceId</i>\" &gt;\n         &lt;StateTask ../&gt;\n         &lt;StateTask ../&gt;\n         &lt;StateTask ../&gt;\n         &lt;StateTask nextElement=\"<i>userTaskId</i>\" ../&gt;\n     &lt;/sequence&gt;\n     &lt;UserTask ID=\"<i>userTaskId</id>\" ../&gt;\n     ...\n &lt;/Process&gt;\n </pre>\n <b>NOTE:</b> you must load the Workflow module\n ${isc.DocUtils.linkForRef('group:loadingOptionalModules','Optional Modules')} before you can use <code>Process</code>.",
        treeLocation:[
            "Client Reference/Workflow"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
            "classMethod:Process.loadProcess",
            "classMethod:Process.getProcess"
        ],
        attrs:[
            "attr:Process.sequences",
            "attr:Process.elements",
            "attr:Process.startElement",
            "attr:Process.wizard",
            "attr:Process.containerId",
            "attr:Process.setState",
            "attr:Process.state",
            "attr:Process.autoStart"
        ]
    },
    "attr:PickList.pickListBaseStyle":{
        ref:"attr:PickList.pickListBaseStyle",
        defaultValue:"\"pickListCell\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"pickListBaseStyle",
        flags:"IR",
        description:"Base Style for pickList cells.  See ${isc.DocUtils.linkForRef('group:cellStyleSuffixes')} for details on how\n stateful suffixes are combined with the pickListBaseStyle to generate stateful cell styles.\n <p>\n Note: if ${isc.DocUtils.linkForRef('attr:PickList.pickListTallBaseStyle')} is specified, this property will be used as the\n ${isc.DocUtils.linkForRef('attr:ListGrid.normalBaseStyle','normalBaseStyle')} and that property will be applied\n to cells that do not match the default cell height, or if ${isc.DocUtils.linkForRef('attr:ListGrid.fastCellUpdates')}\n is true for the pickList in Internet Explorer.",
        definingClass:"interface:PickList",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.editorValueIconHeight":{
        ref:"attr:ListGridField.editorValueIconHeight",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"editorValueIconHeight",
        flags:"IRW",
        description:"When some cell in this field is being edited, setting this property will specify the\n height for value icons in the cell's editor. If unset, the editor's valueIcon width and\n height will be determined in the same way as it would be for a static cell.",
        groups:[
            "imageColumns"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.sortFieldNum":{
        defaultValue:"null",
        deprecated:"as of version 7.0 in favor of ${isc.DocUtils.linkForRef('attr:ListGrid.sortField')}",
        flags:"IRW",
        description:"Specifies the number of the field by which to sort this listGrid. Column numbers\n start at 0 for the left-most column.",
        groups:[
            "sorting"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:ListGrid.sortFieldNum",
        examples:[
            "${isc.DocUtils.linkForExampleId('sort')}"
        ],
        valueType:"number",
        name:"sortFieldNum",
        definingClass:"class:ListGrid"
    },
    "method:DrawShape.moveBy":{
        ref:"method:DrawShape.moveBy",
        deprecated:null,
        name:"moveBy",
        flags:"",
        description:" Move the drawShape by the specified delta\n",
        definingClass:"class:DrawShape",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dX",
                description:"number of pixels to move horizontally",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"dY",
                description:"number of pixels to move vertically",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:Log.messageCount":{
        ref:"classAttr:Log.messageCount",
        defaultValue:"1000",
        valueType:"int",
        deprecated:null,
        name:"messageCount",
        flags:"IR",
        description:"Maximum number of logged messages to retain in memory.\n <p>\n Note that if the Developer Console is open, it will accumulate an unbounded number of\n messages in the \"Log Messages\" area.  <code>messageCount</code> only affects the number\n of messages held in memory in the main application's browser window or tab.",
        definingClass:"class:Log",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "attr:Snapbar.showRollOverGrip":{
        ref:"attr:Snapbar.showRollOverGrip",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showRollOverGrip",
        flags:"IRA",
        description:"If ${isc.DocUtils.linkForRef('attr:StretchImg.showGrip')} is true, this property determines whether to show the\n 'Over' state on the grip image when the user rolls over on this widget. \n Has no effect if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showRollOver')} is false.",
        groups:[
            "grip"
        ],
        definingClass:"class:Snapbar",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ToolbarItem.colSpan":{
        ref:"attr:ToolbarItem.colSpan",
        defaultValue:"true",
        valueType:"boolean",
        deprecated:null,
        name:"colSpan",
        flags:"IRW",
        description:"these items span all columns",
        groups:[
            "appearance"
        ],
        definingClass:"class:ToolbarItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FacetChart.dataLineProperties":{
        ref:"attr:FacetChart.dataLineProperties",
        defaultValue:"null",
        valueType:"DrawLine Properties",
        deprecated:null,
        name:"dataLineProperties",
        flags:"IR",
        description:"Properties for lines that show data (as opposed to gradations or borders around the data\n area).",
        definingClass:"class:FacetChart",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:CalendarEvent.canEditLane":{
        ref:"attr:CalendarEvent.canEditLane",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"canEditLane",
        flags:"IRW",
        description:"Boolean indicating whether this event can be moved between lanes.  Can also be set at the\n ${isc.DocUtils.linkForRef('attr:Calendar.canEditLane','calendar level')}.\n <P>\n The name of this field within the CalendarEvent can be changed via \n ${isc.DocUtils.linkForRef('attr:Calendar.canEditLaneField')}.",
        definingClass:"object:CalendarEvent",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:PickTreeItem.setEmptyDisplayValue":{
        ref:"method:PickTreeItem.setEmptyDisplayValue",
        deprecated:null,
        name:"setEmptyDisplayValue",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:PickTreeItem.emptyDisplayValue')}.\n",
        groups:[
            "display_values"
        ],
        definingClass:"class:PickTreeItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"emptyDisplayValue",
                description:null,
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ListGrid.alwaysShowEditors":{
        ref:"attr:ListGrid.alwaysShowEditors",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"alwaysShowEditors",
        flags:"IR",
        description:"When this attribute is set, editors will be rendered into every row of the grid rather than\n showing up in a single record at a time.\n This attribute is only valid when ${isc.DocUtils.linkForRef('attr:ListGrid.editByCell')} is false",
        groups:[
            "editing"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tree.parentIdField":{
        ref:"attr:Tree.parentIdField",
        examples:[
            "${isc.DocUtils.linkForExampleId('nodeTitles')}"
        ],
        defaultValue:"\"parentId\"",
        valueType:"string",
        deprecated:null,
        name:"parentIdField",
        flags:"IRA",
        description:"For trees with modelType \"parent\", this property specifies the name of the property\n that contains the unique parent ID of a node.  Default value is \"parentId\".  See\n ${isc.DocUtils.linkForRef('attr:TreeNode.parentId')} for usage.",
        definingClass:"class:Tree",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TreeNode.parentId",
                description:null
            }
        ]
    },
    "method:Canvas.markForDestroy":{
        ref:"method:Canvas.markForDestroy",
        deprecated:null,
        name:"markForDestroy",
        flags:"",
        description:" ${isc.DocUtils.linkForRef('method:Canvas.destroy','destroy()')} this canvas on a timeout. This method should be used instead of\n calling <code>canvas.destroy()</code> directly unless there's a reason a the canvas needs to be\n destroyed synchronously. By using a timeout, this method ensures the <code>destroy()</code> will\n occur after the current thread of execution completes. This allows you to easily mark canvases\n for destruction while they're handling events, which must complete before the canvas can be\n destroyed.\n",
        definingClass:"class:Canvas",
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.destroy",
                description:null
            }
        ]
    },
    "method:FacetValue.formatCellValue":{
        ref:"method:FacetValue.formatCellValue",
        deprecated:null,
        name:"formatCellValue",
        flags:"",
        description:" Formatter to apply to values displayed for cells under this facetValue.\n <P>\n Can only be set on the ${isc.DocUtils.linkForRef('attr:CubeGrid.metricFacetId','metric facet')} or, if no metric facet\n is specified, on the innermost column facet.\n <P>\n If a single, grid-wide formatting style is desired, implement\n ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue','grid.formatCellValue()')} instead.\n <P>\n <b>Note:</b>  This method is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.\n\n",
        definingClass:"class:FacetValue",
        returns:{
            description:"formatted value to display in the cell.",
            type:"string"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"value",
                description:"raw value for the cell being",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"record",
                description:"record object for the cell.   Note: If this is a new cell that has not been saved, in an \n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter.",
                optional:false,
                type:"CellRecord"
            },
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number for the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number for the cell.",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DetailViewerField.imageSize":{
        ref:"attr:DetailViewerField.imageSize",
        defaultValue:"null",
        valueType:"Integer | String",
        deprecated:null,
        name:"imageSize",
        flags:"IRW",
        description:"Size of images shown for fieldTypes image in this field.\n <P>\n If set to a String, assumed to be a property on each record that specifies the image\n height.  For example, if <code>field.imageSize</code> is \"logoSize\",\n <code>record.logoSize</code> will control the size of the image.",
        groups:[
            "imageColumns"
        ],
        definingClass:"object:DetailViewerField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DetailViewerField.imageWidth",
                description:null
            },
            {
                ref:"attr:DetailViewerField.imageHeight",
                description:null
            }
        ]
    },
    "attr:Canvas.parentElement":{
        ref:"attr:Canvas.parentElement",
        defaultValue:"null",
        valueType:"Canvas",
        deprecated:"As of Smartclient version 9.1, deprecated in favor of ${isc.DocUtils.linkForRef('attr:Canvas.parentCanvas')}             and ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas')}",
        name:"parentElement",
        flags:"IRA",
        description:"This Canvas's immediate parent, if any.\n <BR>\n Can be initialized, but any subsequent manipulation should be via\n ${isc.DocUtils.linkForRef('method:Canvas.addChild','addChild()')} and ${isc.DocUtils.linkForRef('method:Canvas.removeChild','removeChild()')} calls\n on the parent.",
        groups:[
            "containment"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Calendar.eventDescriptionFieldTitle":{
        ref:"attr:Calendar.eventDescriptionFieldTitle",
        defaultValue:"\"Description\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"eventDescriptionFieldTitle",
        flags:"IR",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:Calendar.descriptionField')} field in the quick \n ${isc.DocUtils.linkForRef('attr:Calendar.eventDialog','event dialog')} and the detailed \n ${isc.DocUtils.linkForRef('attr:Calendar.eventEditor','editor')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:Calendar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawOval.getRadiusX":{
        ref:"method:DrawOval.getRadiusX",
        deprecated:null,
        name:"getRadiusX",
        flags:"",
        description:" Returns the horizontal radius of the DrawOval.\n",
        definingClass:"class:DrawOval",
        returns:{
            description:"the horizontal radius.",
            type:"int"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:DrawOval.setRadii",
                description:null
            }
        ]
    },
    "method:ListGridField.defaultDynamicValue":{
        ref:"method:ListGridField.defaultDynamicValue",
        deprecated:null,
        name:"defaultDynamicValue",
        flags:"",
        description:" If this field ${isc.DocUtils.linkForRef('attr:ListGridField.canEdit','can be edited')}, this property can be used to\n set a dynamic default value which will show up in editors for this field.\n Will be applied to the editor for the field as ${isc.DocUtils.linkForRef('method:FormItem.defaultDynamicValue')}\n\n",
        groups:[
            "editing"
        ],
        definingClass:"object:ListGridField",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"item",
                description:"The editor for the cell itself (also available as \"this\").                              Note that in addition to the standard FormItem APIs available\n                              on the editor, it also has:<br>\n                              - a pointer back to the containing listGrid\n                              [<code>item.grid</code>]<br>\n                              - the colNum being edited [<code>item.colNum</code>]<br>\n                              - the rowNum being edited [<code>item.rowNum</code>]",
                optional:false,
                type:"FormItem"
            },
            {
                defaultValue:null,
                name:"form",
                description:"the managing DynamicForm instance",
                optional:false,
                type:"DynamicForm"
            },
            {
                defaultValue:null,
                name:"values",
                description:"the current set of values for the form as a whole",
                optional:false,
                type:"Object"
            }
        ],
        seeAlso:[
        ]
    },
    "method:GridRenderer.rowHover":{
        ref:"method:GridRenderer.rowHover",
        deprecated:null,
        name:"rowHover",
        flags:"A",
        description:" Called when the mouse hovers over a row if this.canHover is true. \n  Returning false will suppress the hover text from being shown if this.showHover is true.\n\n",
        groups:[
            "events"
        ],
        definingClass:"class:GridRenderer",
        returns:{
            description:"whether to cancel the event (default behavior of showing the hover)",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"record",
                description:"cell record as returned by getCellRecord",
                optional:false,
                type:"ListGridRecord"
            },
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number for the cell",
                optional:false,
                type:"number"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of the cell",
                optional:false,
                type:"number"
            }
        ],
        seeAlso:[
            {
                ref:"attr:GridRenderer.canHover",
                description:null
            }
        ]
    },
    "attr:Canvas.printChildrenAbsolutelyPositioned":{
        ref:"attr:Canvas.printChildrenAbsolutelyPositioned",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"printChildrenAbsolutelyPositioned",
        flags:"IRWA",
        description:"Should this canvas print its children absolutely positioned when generating\n ${isc.DocUtils.linkForRef('classMethod:Canvas.getPrintHTML','printable HTML')}.\n <P>\n By default explicitly specified absolute positioning and sizing is ignored when generating\n print HTML. This is done intentionally: there is no way for the framework to predict how\n explicit sizes will translate to a the printed page and if HTML for printing includes\n the same absolute positioning and sizing as is displayed within an application it is very\n common to encounter undesirable effects, such as seeing tables get broken over several\n pages horizontally when there is enough room to print them on a single page of paper.\n <P>\n In some cases, however, a developer may wish to have explicit sizing and positioning\n respected within the print-view.\n Setting this attribute to <code>true</code> will cause this to occur.",
        groups:[
            "printing"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MultiSortPanel.initialSort":{
        ref:"attr:MultiSortPanel.initialSort",
        defaultValue:"null",
        valueType:"Array of SortSpecifier",
        deprecated:null,
        name:"initialSort",
        flags:"IR",
        description:"The initial sort configuration to show in the \n ${isc.DocUtils.linkForRef('attr:MultiSortPanel.optionsGrid','optionsGrid')}.",
        definingClass:"class:MultiSortPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Tab.icon":{
        ref:"attr:Tab.icon",
        examples:[
            "${isc.DocUtils.linkForExampleId('tabsOrientation')}"
        ],
        defaultValue:"null",
        valueType:"SCImgURL",
        deprecated:null,
        name:"icon",
        flags:"IRW",
        description:"If specified, this tab will show an icon next to the tab title.  \n <p>\n <b>NOTE:</b> if you enable ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs','closeable tabs')},\n <code>tab.icon</code> is used for the close icon.  ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')} describes\n a workaround to enable both a <code>closeIcon</code> and a second icon to be shown.\n <p>\n Use ${isc.DocUtils.linkForRef('method:TabSet.tabIconClick')} to add an event handler specifically for clicks on the icon.\n <p>\n If a tab ${isc.DocUtils.linkForRef('attr:Tab.disabled','becomes disabled')}, a different icon will be loaded by adding\n a suffix to the image name (see ${isc.DocUtils.linkForRef('attr:Button.icon')}).\n <p>\n You should specify a size for the icon via ${isc.DocUtils.linkForRef('attr:Tab.iconSize')} or ${isc.DocUtils.linkForRef('attr:Tab.iconWidth')}\n and ${isc.DocUtils.linkForRef('attr:Tab.iconHeight')}. Without an explicitly specified size, tabs may be drawn\n overlapping or with gaps the first time a page is loaded, because the icon is not cached\n and therefore its size isn't known.",
        definingClass:"object:Tab",
        type:"attr",
        seeAlso:[
            {
                ref:"method:TabSet.tabIconClick",
                description:null
            }
        ]
    },
    "attr:Scrollbar.allowThumbDownState":{
        ref:"attr:Scrollbar.allowThumbDownState",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"allowThumbDownState",
        flags:"IRA",
        description:"If true, the thumb's appearance changes when it's clicked on.",
        groups:[
            "thumb"
        ],
        definingClass:"class:Scrollbar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawOval.getRadiusY":{
        ref:"method:DrawOval.getRadiusY",
        deprecated:null,
        name:"getRadiusY",
        flags:"",
        description:" Returns the vertical radius of the DrawOval.\n",
        definingClass:"class:DrawOval",
        returns:{
            description:"the vertical radius.",
            type:"int"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:DrawOval.setRadii",
                description:null
            }
        ]
    },
    "attr:OperationBinding.canSyncCache":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"For an operation of type \"add\" or \"update\", a SQLDataSource will normally obtain\n data to return to the client by performing the \"cacheSyncOperation\": a SELECT statement that\n retrieves the modified record by primary key.  This accommodates sequence columns, columns\n with default values, database triggers and other database features that may modify data\n after insertion or update.\n <P>\n Certain major SQL customizations can prevent the SQLDataSource from authoritatively\n determining the primary key used in the SQL statement, such that re-selecting the saved\n record may fail.  By default, when <code>canSyncCache</code> has not been explicitly\n set, in the following cases it is assumed that the normal cacheSyncOperation cannot be used:\n <ul>\n <li> &lt;customSQL&gt; has been used to define an entirely custom query\n <li> a custom &lt;whereClause&gt; has been defined for an \"update\" or \"remove\" operation\n <li> a custom &lt;valuesClause&gt; has been defined for an \"add\" operation\n </ul>\n If any of these cases apply or if <code>canSyncCache</code> has been set false, the server\n will skip the cacheSyncOperation and return a DSResponse where\n ${isc.DocUtils.linkForRef('attr:DSResponse.invalidateCache')} has been set to true to notify client-side components that\n they may need to refresh their entire cache.\n <P>\n Alternatively, if the default re-selection behavior will not work but a customized SQL\n query would work, you can define that SQL operation as another operationBinding and use\n ${isc.DocUtils.linkForRef('attr:OperationBinding.cacheSyncOperation')} to declare that it should be used.  Setting\n <code>cacheSyncOperation</code> implicitly sets <code>canCacheSync</code> to true.\n <P>\n This property is only applicable to DataSources of type \"sql\".",
        groups:[
            "customQuerying"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:OperationBinding.useForCacheSync",
                description:null
            },
            {
                ref:"attr:OperationBinding.cacheSyncOperation",
                description:null
            }
        ],
        ref:"attr:OperationBinding.canSyncCache",
        valueType:"Boolean",
        name:"canSyncCache",
        definingClass:"class:OperationBinding"
    },
    "attr:MultiComboBoxItem.valueLayout":{
        ref:"attr:MultiComboBoxItem.valueLayout",
        defaultValue:"null",
        valueType:"MultiAutoChild Layout",
        deprecated:null,
        name:"valueLayout",
        flags:"RA",
        description:"The layout used to arrange the ${isc.DocUtils.linkForRef('attr:MultiComboBoxItem.comboForm','comboForm')} and the buttons\n representing the values of the MultiComboBoxItem. Note that the constructor cannot be changed\n (setting a valueLayoutConstructor has no effect) because the exact layout class used depends\n on the current ${isc.DocUtils.linkForRef('attr:MultiComboBoxItem.layoutStyle','layout style')}.",
        definingClass:"class:MultiComboBoxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DrawItem.setShadow":{
        ref:"method:DrawItem.setShadow",
        deprecated:null,
        name:"setShadow",
        flags:"",
        description:" Update shadow for this drawItem.\n",
        definingClass:"class:DrawItem",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"shadow",
                description:"new shadow",
                optional:false,
                type:"Shadow"
            }
        ],
        seeAlso:[
        ]
    },
    "method:PortalLayout.setColumnOverflow":{
        ref:"method:PortalLayout.setColumnOverflow",
        examples:[
            "${isc.DocUtils.linkForExampleId('portalLayoutColumnHeight')}"
        ],
        deprecated:null,
        name:"setColumnOverflow",
        flags:"",
        description:" Sets ${isc.DocUtils.linkForRef('attr:PortalLayout.columnOverflow')} and updates existing columns to reflect the new setting.\n",
        definingClass:"class:PortalLayout",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"overflow",
                description:"Overflow setting for columns",
                optional:false,
                type:"Overflow"
            }
        ],
        seeAlso:[
            {
                ref:"attr:PortalLayout.columnOverflow",
                description:null
            }
        ]
    },
    "attr:DetailViewerField.linkTextProperty":{
        ref:"attr:DetailViewerField.linkTextProperty",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"linkTextProperty",
        flags:"IRW",
        description:"Name of the property in a DetailViewerRecord that holds the HTML to display for values\n of this field if the field type is set to \"link\".",
        definingClass:"object:DetailViewerField",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DetailViewerField.type",
                description:null
            },
            {
                ref:"attr:DetailViewerRecord.linkText",
                description:null
            },
            {
                ref:"attr:DetailViewerField.linkText",
                description:null
            },
            {
                ref:"attr:DetailViewer.linkTextProperty",
                description:null
            }
        ]
    },
    "attr:MultiGroupDialog.levelUpButtonTitle":{
        ref:"attr:MultiGroupDialog.levelUpButtonTitle",
        defaultValue:"\"Move Level Up\"",
        valueType:"String",
        deprecated:null,
        name:"levelUpButtonTitle",
        flags:"IR",
        description:"The hover-prompt for the Level Up button.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiGroupDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:SpinnerItem.min":{
        ref:"attr:SpinnerItem.min",
        examples:[
            "${isc.DocUtils.linkForExampleId('spinnerItem')}"
        ],
        defaultValue:"null",
        valueType:"Double",
        deprecated:null,
        name:"min",
        flags:"IRW",
        description:"Minimum valid value for this item. If this and ${isc.DocUtils.linkForRef('attr:SpinnerItem.max','max')} are both\n null or unspecified, then\n \n ${isc.DocUtils.linkForRef('method:SpinnerItem.getNextValue')} and ${isc.DocUtils.linkForRef('method:SpinnerItem.getPreviousValue')}\n are used to increase or decrease the value and these methods\n \n are also used to determine the minimum value.",
        definingClass:"class:SpinnerItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Tree.getLoadState":{
        ref:"method:Tree.getLoadState",
        deprecated:null,
        name:"getLoadState",
        flags:"",
        description:" What is the loadState of a given folder?\n\n",
        groups:[
            "loadState"
        ],
        definingClass:"class:Tree",
        returns:{
            description:"state of the node",
            type:"LoadState"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"node",
                description:"folder in question",
                optional:false,
                type:"TreeNode"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:SectionItem.canTabToHeader":{
        ref:"attr:SectionItem.canTabToHeader",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"canTabToHeader",
        flags:"IR",
        description:"If true, the header for this Section will be included in the page's tab\n order for accessibility.\n May also be set at the ${isc.DocUtils.linkForRef('class:DynamicForm')} level via \n ${isc.DocUtils.linkForRef('attr:DynamicForm.canTabToSectionHeaders')}.\n <P>\n See ${isc.DocUtils.linkForRef('group:accessibility')}.",
        definingClass:"class:SectionItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:TableView.formatRecord":{
        ref:"method:TableView.formatRecord",
        deprecated:null,
        name:"formatRecord",
        flags:"",
        description:" Formatter to apply to record display.\n\n",
        definingClass:"class:TableView",
        returns:{
            description:"formatted record contents",
            type:"HTML"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"record",
                description:"record to format",
                optional:false,
                type:"ListGridRecord"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:TabSet.showPaneContainerEdges":{
        ref:"attr:TabSet.showPaneContainerEdges",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showPaneContainerEdges",
        flags:"IRWA",
        description:"Should the paneContainer for this tabset show ${isc.DocUtils.linkForRef('attr:Canvas.showEdges','edges')}.",
        definingClass:"class:TabSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ServiceTask.fixedCriteria":{
        ref:"attr:ServiceTask.fixedCriteria",
        defaultValue:"null",
        valueType:"Criteria",
        deprecated:null,
        name:"fixedCriteria",
        flags:"IR",
        description:"Criteria to be submitted as part of the DSRequest, regardless of inputs to the task.\n Will be combined with the data from the ${isc.DocUtils.linkForRef('attr:Task.inputField')} or with\n ${isc.DocUtils.linkForRef('attr:ServiceTask.criteria')} if specified, via ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria')}.",
        definingClass:"class:ServiceTask",
        type:"attr",
        seeAlso:[
        ]
    },
    "group:focus":{
        ref:"group:focus",
        refs:[
            "classAttr:Canvas.TAB_INDEX_FLOOR",
            "method:DynamicForm.getFocusItem",
            "method:DynamicForm.focus",
            "method:DynamicForm.focusInItem",
            "method:FormItem.getCanFocus",
            "method:FormItem.focusInItem",
            "method:FormItem.blurItem",
            "method:Canvas.focus",
            "method:Canvas.blur",
            "method:Canvas.containsFocus",
            "method:Canvas.setAccessKey",
            "method:Canvas.setTabIndex",
            "method:Canvas.focusInNextTabElement",
            "method:Canvas.focusInPreviousTabElement",
            "method:Canvas.focusChanged",
            "attr:Window.canFocusInHeaderButtons",
            "attr:DynamicForm.autoFocus",
            "attr:DynamicForm.autoFocusOnError",
            "attr:DynamicForm.selectOnFocus",
            "attr:DynamicForm.selectOnClick",
            "attr:DynamicForm.canFocus",
            "attr:FormItem.canFocus",
            "attr:FormItem.accessKey",
            "attr:FormItem.tabIndex",
            "attr:FormItem.globalTabIndex",
            "attr:FormItem.selectOnFocus",
            "attr:FormItem.selectOnClick",
            "attr:TextItem.selectOnFocus",
            "attr:TextItem.selectOnClick",
            "attr:TextAreaItem.selectOnFocus",
            "attr:TextAreaItem.selectOnClick",
            "attr:Canvas.canFocus",
            "attr:Canvas.tabIndex",
            "attr:Canvas.accessKey"
        ],
        deprecated:null,
        name:"focus",
        description:"Focus is the ability to become the target of keyboard input events.\n <P>\n A widget normally receives focus by being clicked on or tabbed to.",
        type:"group",
        title:"Focus",
        seeAlso:[
        ]
    },
    "attr:ListGridField.showHover":{
        ref:"attr:ListGridField.showHover",
        examples:[
            "${isc.DocUtils.linkForExampleId('valueHoverTips')}"
        ],
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"showHover",
        flags:"IRW",
        description:"Whether to show hovers for this field.  The default hover will be the contents of the\n cell the user is hovering over, and can be customized via\n ${isc.DocUtils.linkForRef('method:ListGridField.hoverHTML','field.hoverHTML()')}.\n <P>\n ${isc.DocUtils.linkForRef('attr:ListGrid.canHover')} can be set to true to cause hovers to be shown for all fields\n by default.  In this case, <code>field.showHover</code> can be set to false to suppress\n hovers for an individual field.\n <P>\n All hovers can be disabled, regardless of other settings, by setting\n ${isc.DocUtils.linkForRef('attr:ListGrid.showHover')} to false.",
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:EventHandler.setDragTrackerImage":{
        ref:"classMethod:EventHandler.setDragTrackerImage",
        deprecated:null,
        name:"setDragTrackerImage",
        flags:"",
        description:" This API may be called to set the native HTML5 drag tracker image. The <code>x</code> and\n <code>y</code> parameters may be specified to affect the placement of the drag tracker image\n relative to the mouse cursor. The size of the drag tracker image is the intrinsic size of the\n image. Browsers may apply certain visual effects (such as a slight transparency) to this image.\n <p>\n Can only be called during the ${isc.DocUtils.linkForRef('method:Canvas.dragStart')} event (or methods called during the\n handling of that event).\n <p>\n <b>NOTES:</b>\n <ul>\n <li>Not supported in Opera 12.x or Safari.</li>\n <li>For best results, this image should be preloaded. Otherwise, the image might not appear\n for the first drag using this image.</li>\n <li>This API does not work in Chrome or Firefox on Windows 7 if the \"Use visual styles on windows and buttons\"\n setting is turned off.</li>\n </ul>\n",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:EventHandler",
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"src",
                description:"image source",
                optional:false,
                type:"SCImgURL"
            },
            {
                defaultValue:null,
                name:"x",
                description:"offset-x from the mouse cursor",
                optional:true,
                type:"int"
            },
            {
                defaultValue:null,
                name:"y",
                description:"offset-y from the mouse cursor",
                optional:true,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "classAttr:LoginDialog.LOGIN_BUTTON_TITLE":{
        ref:"classAttr:LoginDialog.LOGIN_BUTTON_TITLE",
        defaultValue:"\"Log in\"",
        valueType:"HTML",
        deprecated:null,
        name:"LOGIN_BUTTON_TITLE",
        flags:"IRW",
        description:"Default title for login button in the dialog displayed by\n ${isc.DocUtils.linkForRef('classMethod:isc.showLoginDialog')}.",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:LoginDialog",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:CalendarView.isDayView":{
        ref:"method:CalendarView.isDayView",
        deprecated:null,
        name:"isDayView",
        flags:"",
        description:" Returns true if this is the ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day view')}, false otherwise.\n",
        definingClass:"class:CalendarView",
        returns:{
            description:"true if this is a Day view",
            type:"boolean"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:MultiGroupPanel.addLevelButtonTitle":{
        ref:"attr:MultiGroupPanel.addLevelButtonTitle",
        defaultValue:"\"Add Level\"",
        valueType:"String",
        deprecated:null,
        name:"addLevelButtonTitle",
        flags:"IR",
        description:"The title-text to appear on the addLevelButton",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:MultiGroupPanel",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataSource.getTypeOperatorMap":{
        ref:"method:DataSource.getTypeOperatorMap",
        deprecated:null,
        name:"getTypeOperatorMap",
        flags:"",
        description:" Get the list of ${isc.DocUtils.linkForRef('object:Operator')}s available for this ${isc.DocUtils.linkForRef('type:FieldType')}, as a ${isc.DocUtils.linkForRef('type:ValueMap')} from\n ${isc.DocUtils.linkForRef('type:OperatorId')} to the ${isc.DocUtils.linkForRef('attr:Operator.title')} specified for the ${isc.DocUtils.linkForRef('object:Operator')}, or\n the corresponding property in ${isc.DocUtils.linkForRef('class:Operators')} if ${isc.DocUtils.linkForRef('attr:Operator.titleProperty')} is set.\n <P>\n This valueMap is suitable for use in a UI for building queries, similar to the\n ${isc.DocUtils.linkForRef('class:FilterBuilder')}, and optionally omits operators marked ${isc.DocUtils.linkForRef('attr:Operator.hidden')}:true.\n <p>\n It is also possible to have this function return only operators of a given \n ${isc.DocUtils.linkForRef('type:OperatorValueType')}, or everything except operators of that type. This is useful, \n for example, if you want to return all the logical operators (like \"and\"), or everything \n except the logical operators.\n\n",
        groups:[
            "advancedFilter"
        ],
        definingClass:"class:DataSource",
        returns:{
            description:"mapping from ${isc.DocUtils.linkForRef('type:OperatorId')} to title, as described above",
            type:"ValueMap"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"type",
                description:"Type to obtain operator map for. Defaults to \"text\" if not passed.",
                optional:true,
                type:"FieldType"
            },
            {
                defaultValue:null,
                name:"includeHidden",
                description:"whether to include Operators marked hidden:true",
                optional:true,
                type:"boolean"
            },
            {
                defaultValue:null,
                name:"valueType",
                description:"If passed, returns only operators of this ${isc.DocUtils.linkForRef('type:OperatorValueType')}",
                optional:true,
                type:"OperatorValueType"
            },
            {
                defaultValue:null,
                name:"omitValueType",
                description:"If set, reverses the meaning of the <code>valueType</code>         parameter, so operators of that ${isc.DocUtils.linkForRef('type:OperatorValueType')} are the only ones omitted",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
            {
                ref:"method:DataSource.getFieldOperatorMap",
                description:null
            }
        ]
    },
    "attr:RestDataSource.jsonRecordXPath":{
        ref:"attr:RestDataSource.jsonRecordXPath",
        defaultValue:"\"/response/data\"",
        valueType:"string",
        deprecated:null,
        name:"jsonRecordXPath",
        flags:"IR",
        description:"<code>recordXPath</code> mapping to the data node of json returned by the server.\n Applies if this.dataFormat is set to <code>\"json\"</code><br>\n The default value will pick up data from a response structured as follows:<br>\n <pre>\n {response:\n  {status:0,\n   data:[\n      {field1:\"value\", field2:\"value\"},\n      {field1:\"value\", field2:\"value\"}\n   ]\n }\n </pre>",
        definingClass:"class:RestDataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataBoundComponent.editFormulaField":{
        ref:"method:DataBoundComponent.editFormulaField",
        deprecated:null,
        name:"editFormulaField",
        flags:"",
        description:" Method to display a ${isc.DocUtils.linkForRef('class:FormulaBuilder')} to edit a formula Field.  If the function is called\n without a parameter, a new field will be created when the formula is saved.\n\n",
        groups:[
            "formulaFields"
        ],
        definingClass:"interface:DataBoundComponent",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"field",
                description:"Field to edit or null to add a new formula field",
                optional:false,
                type:"Field"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DrawRect.resizeBy":{
        ref:"method:DrawRect.resizeBy",
        deprecated:null,
        name:"resizeBy",
        flags:"",
        description:" Resize by the specified delta\n",
        definingClass:"class:DrawRect",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dX",
                description:"number of pixels to resize by horizontally",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"dY",
                description:"number of pixels to resize by vertically",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "method:MiniDateRangeItem.hasAdvancedCriteria":{
        ref:"method:MiniDateRangeItem.hasAdvancedCriteria",
        deprecated:null,
        name:"hasAdvancedCriteria",
        flags:"",
        description:" Overridden to return true: dateRangeItems always generate AdvancedCriteria.\n",
        groups:[
            "criteriaEditing"
        ],
        definingClass:"class:MiniDateRangeItem",
        returns:{
            description:"true",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:FormItemEventInfo.overItem":{
        ref:"attr:FormItemEventInfo.overItem",
        defaultValue:"null",
        valueType:"Boolean",
        deprecated:null,
        name:"overItem",
        flags:"R",
        description:"True if the event occurred over the main body of the item (for example the text-box), rather\n than over the title or within the form item's cell in the DynamicForm but outside the\n text box area.",
        definingClass:"object:FormItemEventInfo",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FormulaBuilder.instructionsTextStart":{
        ref:"attr:FormulaBuilder.instructionsTextStart",
        defaultValue:"\"The following fields are available for use in this ${builderType}\"",
        valueType:"HTMLString",
        deprecated:null,
        name:"instructionsTextStart",
        flags:"IRWA",
        description:"The text to display as a preamble to the instruction text that appears in the \n ${isc.DocUtils.linkForRef('attr:FormulaBuilder.instructions','instructions label')}.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will \n be evaluated as JS code when the message is displayed.\n <P>\n Only one dynamic variable, builderType, is available and represents the type of this\n builder - either Formula or Summary.\n <P>\n Default value returns <P>\n <code>\n <i>The following fields are available for use in this [Formula/Summary]</i>\n </code>",
        groups:[
            "i18nMessages"
        ],
        definingClass:"class:FormulaBuilder",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:MetricSettings.axisStartValue":{
        ref:"attr:MetricSettings.axisStartValue",
        defaultValue:"null",
        valueType:"Float",
        deprecated:null,
        name:"axisStartValue",
        flags:"IR",
        description:"Same as ${isc.DocUtils.linkForRef('attr:FacetChart.axisStartValue')} but affects only one metric.",
        definingClass:"object:MetricSettings",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:SelectItem.getSelectedRecords":{
        ref:"method:SelectItem.getSelectedRecords",
        deprecated:null,
        name:"getSelectedRecords",
        flags:"",
        description:" For a SelectItem with an ${isc.DocUtils.linkForRef('attr:SelectItem.optionDataSource')} and allowing multiple selection\n (${isc.DocUtils.linkForRef('attr:SelectItem.multiple','via multiple:true')}), returns the list of currently selected records, or\n null if none are selected.\n \n",
        definingClass:"class:SelectItem",
        returns:{
            description:"the list of selected records, or null if none are selected",
            type:"Array of ListGridRecord"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ListGrid.maxExpandedRecords":{
        ref:"attr:ListGrid.maxExpandedRecords",
        defaultValue:"null",
        valueType:"integer",
        deprecated:null,
        name:"maxExpandedRecords",
        flags:"IRWA",
        description:"When ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} and ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandMultipleRecords')} are\n both true, this property dictates the number of\n records which can be expanded simultaneously.  If the expanded record count hits the\n value of this property, further attempts to expand records will result in a popup\n warning (see ${isc.DocUtils.linkForRef('attr:ListGrid.maxExpandedRecordsPrompt')}) and expansion will be cancelled.\n <P>\n The default value is null, meaning there is no limit on the number of expanded records.",
        groups:[
            "expansionField"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ImgSectionHeader.iconAlign":{
        ref:"attr:ImgSectionHeader.iconAlign",
        defaultValue:"null",
        valueType:"string",
        deprecated:null,
        name:"iconAlign",
        flags:"IR",
        description:"If this button is showing an icon should it be right or left aligned?",
        groups:[
            "buttonIcon"
        ],
        definingClass:"class:ImgSectionHeader",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:SplitPane.setShowRightButton":{
        ref:"method:SplitPane.setShowRightButton",
        deprecated:null,
        name:"setShowRightButton",
        flags:"",
        description:" Show or hide the ${isc.DocUtils.linkForRef('attr:NavigationBar.rightButton','rightButton')} of the\n ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigationBar')}.\n\n",
        definingClass:"class:SplitPane",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"visible",
                description:"if <code>true</code>, the button will be shown, otherwise hidden.",
                optional:false,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Number.toCurrencyString":{
        ref:"method:Number.toCurrencyString",
        deprecated:"Moved to a static method on NumberUtil to avoid the possibility of collision               with other libraries on the native Number object",
        name:"toCurrencyString",
        flags:"",
        description:" Return this number as a currency-formatted string.\n\n",
        groups:[
            "stringProcessing"
        ],
        definingClass:"object:Number",
        returns:{
            description:"Currency-formatted string version of the number",
            type:"string"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"currencyChar",
                description:"Currency symbol, can be set to an empty string.                                 If unset <code>\"$\"</code> will be used.",
                optional:true,
                type:"string"
            },
            {
                defaultValue:null,
                name:"decimalChar",
                description:"Decimal separator symbol. If unset <code>\".\"</code> will be used.",
                optional:true,
                type:"string"
            },
            {
                defaultValue:null,
                name:"padDecimal",
                description:"Should decimal portion be padded out to two digits? True                               by default.",
                optional:true,
                type:"boolean"
            },
            {
                defaultValue:null,
                name:"currencyCharLast",
                description:"Should currency symbol come at the end of the string?                                      If unspecified, currency symbol will be shown at the \n                                      beginning of the string.",
                optional:true,
                type:"boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "group:headerMenuButton":{
        ref:"group:headerMenuButton",
        refs:[
            "attr:ListGrid.showHeaderMenuButton",
            "attr:ListGrid.leaveHeaderMenuButtonSpace",
            "attr:ListGridField.leaveHeaderMenuButtonSpace",
            "attr:ListGrid.headerMenuButtonConstructor",
            "attr:ListGrid.headerMenuButton",
            "attr:ListGrid.headerMenuButtonIcon",
            "attr:ListGrid.headerMenuButtonIconWidth",
            "attr:ListGrid.headerMenuButtonIconHeight",
            "attr:ListGrid.headerMenuButtonWidth",
            "attr:ListGrid.headerMenuButtonHeight"
        ],
        deprecated:null,
        name:"headerMenuButton",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "attr:TimeItem.showMillisecondItem":{
        ref:"attr:TimeItem.showMillisecondItem",
        defaultValue:"false",
        valueType:"Boolean",
        deprecated:null,
        name:"showMillisecondItem",
        flags:"IRW",
        description:"Controls whether to display the ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondItem')} when ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} is false.",
        definingClass:"class:TimeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Canvas.shouldSnapOnDrop":{
        ref:"method:Canvas.shouldSnapOnDrop",
        deprecated:null,
        name:"shouldSnapOnDrop",
        flags:"A",
        description:" Override this method to give programmatic control over whether or not the parameter\n <code>dragTarget</code> should snap to this object's grid when dropped.  Note that this only applies\n if snap-to-grid is enabled on either <code>dragTarget</code> or this object.  See\n ${isc.DocUtils.linkForRef('attr:Canvas.snapToGrid')} and ${isc.DocUtils.linkForRef('attr:Canvas.childrenSnapToGrid')}.\n <P>\n The default implementation simply returns true.\n\n",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"true if <code>dragTarget</code> should snap to this object's grid; otherwise false",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"dragTarget",
                description:"The object about to be dropped",
                optional:false,
                type:"isc.Canvas"
            }
        ],
        seeAlso:[
        ]
    },
    "method:DrawGroup.scaleBy":{
        ref:"method:DrawGroup.scaleBy",
        deprecated:null,
        name:"scaleBy",
        flags:"",
        description:" Scale all drawItem[] shapes by the x, y multipliers\n",
        definingClass:"class:DrawGroup",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"x",
                description:"scale in the x direction",
                optional:false,
                type:"float"
            },
            {
                defaultValue:null,
                name:"y",
                description:"scale in the y direction",
                optional:false,
                type:"float"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:DrawItem.proportionalResizeModifiers":{
        ref:"attr:DrawItem.proportionalResizeModifiers",
        defaultValue:"[\"Shift\"]",
        valueType:"Array of KeyName",
        deprecated:null,
        name:"proportionalResizeModifiers",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:DrawItem.proportionalResizing')} is set to \"modifier\"\n \n or \"modifierOff\"\n \n then proportional resizing of the DrawItem is activated or deactivated, respectively,\n whenever at least one key in this set of modifier keys is pressed.\n <p>\n The keys allowed in this set are:  \"Alt\", \"Ctrl\", and \"Shift\".  If this set\n of keys is empty then proportional resizing is always used if\n <code>proportionalResizing</code> is \"modifier\"\n  and is never used if\n <code>proportionalResizing</code> is \"modifierOff\"\n .",
        definingClass:"class:DrawItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DateItem.displayFormat":{
        ref:"attr:DateItem.displayFormat",
        defaultValue:"null",
        valueType:"DateDisplayFormat",
        deprecated:"Use ${isc.DocUtils.linkForRef('attr:DateItem.dateFormatter')} instead.",
        name:"displayFormat",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is <code>true</code> this property can be used to \n customize the format in which dates are displayed.<br>\n Should be set to a standard ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} or\n a function which will return a formatted date string.\n <P>\n If unset, the standard shortDate format as set up via ${isc.DocUtils.linkForRef('classMethod:Date.setShortDisplayFormat')}\n will be used.\n <P>\n <B>NOTE: you may need to update the ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')} to ensure the\n DateItem is able to parse user-entered date strings back into Dates</B>\n <p>\n This attribute does not have an effect if a native HTML5 date input is being used.\n See ${isc.DocUtils.linkForRef('attr:DateItem.browserInputType')}.",
        definingClass:"class:DateItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:DateItem.inputFormat",
                description:null
            }
        ]
    },
    "attr:Hilite.criteria":{
        ref:"attr:Hilite.criteria",
        defaultValue:"null",
        valueType:"Criteria or AdvancedCriteria",
        deprecated:null,
        name:"criteria",
        flags:"IR",
        description:"Criteria defining what records this hilite should apply to.",
        groups:[
            "hiliting"
        ],
        definingClass:"object:Hilite",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FileItem.displayItem":{
        ref:"attr:FileItem.displayItem",
        defaultValue:"null",
        valueType:"AutoChild StaticTextItem",
        deprecated:null,
        name:"displayItem",
        flags:"RA",
        description:"The ${isc.DocUtils.linkForRef('class:StaticTextItem')} created automatically and displayed in the \n ${isc.DocUtils.linkForRef('attr:FileItem.displayForm')} when ${isc.DocUtils.linkForRef('attr:FormItem.canEdit','canEdit')} is false and the field type is\n \"blob\".\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>fileItem.displayItemDefaults</code> and\n <code>fileItem.displayItemProperties</code>. \n <P>",
        groups:[
            "upload"
        ],
        definingClass:"class:FileItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:OperationBinding.namedQuery":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"<b>This feature is available with Power or better licenses only.</b> See\n <a href=http://smartclient.com/product>smartclient.com/product</a> for details.\n <p>\n For a dataSource of ${isc.DocUtils.linkForRef('attr:DataSource.serverType','serverType')} \"jpa\" or \"hibernate\", this\n property can be specified on an operationBinding to indicate that the server should execute\n a named query which has already been defined on an entity.\n <pre>\n    &#64;Entity\n    &#64;Table (name=\"Countries\")\n    &#64;NamedQuery(name = \"Country.withPopulationLessThan\", query = \"SELECT country FROM Country country WHERE country.population &lt; :population\")\n    public class Country { ... }\n </pre>\n\n <pre>\n    &lt;operationBindings&gt;\n        &lt;operationBinding operationType=\"custom\" operationId=\"withPopulationLessThan\" namedQuery=\"Country.withPopulationLessThan\"/&gt;\n    &lt;/operationBindings&gt;</pre>\n <p>\n Substitution values can be used in order to build more dynamic named queries. When calling\n ${isc.DocUtils.linkForRef('method:DataSource.performCustomOperation')} the values are passed in using the data argument.\n <p>\n <b>Note</b> that value substitution for named queries is slightly different to other custom queries.\n Because of the way the persistence API works the JQL query written in the &#64;NamedQuery annotation\n can only contain basic parameter names such as \"population\". Therefore the value substitution\n becomes a simple name based mapping.\n <p>\n <h3>Examples</h3>\n <b>Using Simple Criteria</b><br />\n <br />\n An example using a simple criteria for the above defined Country entity. In this case the named\n query parameter \":population\" will be swapped out for the value of the criteria objects \"population\"\n field.\n <pre>\n    var criteria = {\n        population: 596000\n    };\n\n    countryDataSource.performCustomOperation(\"withPopulationLessThan\", criteria);\n </pre>\n <p>\n <b>Using Advanced Criteria</b><br />\n <br />\n If an advanced criteria is detected, access to all \"fieldName\" variables and their values will\n be provided but still using simple name based mapping. In the below case only the deep-first\n occurrence of the \"population\" fieldName will available. The operator is effectively ignored.\n <pre>\n    var criteria = {\n        _constructor: \"AdvancedCriteria\",\n        operator:\"or\",\n        criteria:[\n            {\n                fieldName:\"population\",\n                operator:\"lessThan\",\n                value: 12000\n            },\n            {\n                fieldName:\"name\",\n                operator:\"equals\",\n                value: \"Sweden\"\n            },\n            {\n                _constructor: \"AdvancedCriteria\",\n                operator:\"and\",\n                criteria:[\n                    {\n                        fieldName:\"population\",\n                        operator:\"lessThan\",\n                        value: 0\n                    }\n                ]\n            }\n        ]\n    };\n\n    countryDataSource.performCustomOperation(\"withPopulationLessThan\", criteria);\n </pre>\n <p>\n <b>Note</b><br />\n Using namedQuery affects paging implementation. If you use it, full data set is fetched\n from JPA and records that aren't in the requested range are dropped at the server side.",
        groups:[
            "customQuerying"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"attr:OperationBinding.customSQL",
                description:null
            },
            {
                ref:"attr:DataSourceField.customSQL",
                description:null
            }
        ],
        ref:"attr:OperationBinding.namedQuery",
        valueType:"String",
        name:"namedQuery",
        definingClass:"class:OperationBinding"
    },
    "attr:Canvas.hoverAutoDestroy":{
        ref:"attr:Canvas.hoverAutoDestroy",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"hoverAutoDestroy",
        flags:"IRW",
        description:"If <code>this.showHover</code> is true and ${isc.DocUtils.linkForRef('method:Canvas.getHoverComponent')} is implemented, should\n the hoverCanvas returned from it be automatically destroyed when it is hidden?\n <P>\n The default of null indicates that the component <b>will</b> be automatically\n destroyed.  Set to false to prevent this.",
        groups:[
            "hovers"
        ],
        definingClass:"class:Canvas",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:Canvas.showHover",
                description:null
            }
        ]
    },
    "attr:DynamicForm.values":{
        getter:[
            "getValues"
        ],
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"An Object containing the initial values of the form as properties, where each\n propertyName is the name of a ${isc.DocUtils.linkForRef('group:Items','form item')} in the form, and each property\n value is the value held by that form item.\n <P>\n The form's values may contain values that are not managed by any FormItem, and these\n values will be preserved and available when the form values are subsequently retrieved\n via ${isc.DocUtils.linkForRef('method:DynamicForm.getValues')}.\n <P>\n Providing values on initialization is equivalent to calling ${isc.DocUtils.linkForRef('method:DynamicForm.setValues')}.\n <P>\n As the user manipulates form items to change values, change events fire\n ${isc.DocUtils.linkForRef('method:FormItem.change','on the items')} and \n ${isc.DocUtils.linkForRef('method:DynamicForm.itemChange','on the form as a whole')}.\n <P>\n Note that form values are logical values, for example, the value of a ${isc.DocUtils.linkForRef('class:DateItem')} is\n a JavaScript Date object, not a String, even if the user enters the date via a text\n input.  Likewise the value of a ${isc.DocUtils.linkForRef('class:TextItem')} or ${isc.DocUtils.linkForRef('class:CheckboxItem')} that started out\n null remains null until the user changes it; the value will not be automatically\n converted to the null string (\"\") or false respectively, as happens with native HTML\n elements.",
        groups:[
            "formValues"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DynamicForm.values",
        valueType:"Object",
        name:"values",
        definingClass:"class:DynamicForm",
        setter:[
            "setValues"
        ]
    },
    "type:VerticalAlignment":{
        ref:"type:VerticalAlignment",
        values:[
            {
                description:"At the top of the container",
                value:"Canvas.TOP"
            },
            {
                description:"Center within container.",
                value:"Canvas.CENTER"
            },
            {
                description:"At the bottom of the container",
                value:"Canvas.BOTTOM"
            }
        ],
        deprecated:null,
        name:"VerticalAlignment",
        description:null,
        groups:[
            "appearance"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:Canvas.resizeTo":{
        deprecated:null,
        flags:"",
        description:"          Resizes the widget to the specified width and height (moves the right and/ or bottom\n          sides of the widget). The width and height parameters can be expressed as a percentage\n          of viewport size or as the number of pixels.\n",
        groups:[
            "sizing"
        ],
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"width",
                description:"new width for canvas.",
                optional:true,
                type:"number"
            },
            {
                defaultValue:null,
                name:"height",
                description:"new height for canvas",
                optional:true,
                type:"number"
            }
        ],
        seeAlso:[
        ],
        ref:"method:Canvas.resizeTo",
        examples:[
            "${isc.DocUtils.linkForExampleId('resize')}"
        ],
        name:"resizeTo",
        definingClass:"class:Canvas",
        returns:{
            description:"whether the size actually changed",
            type:"Boolean"
        }
    },
    "attr:DataSource.resultTreeClass":{
        serverDS:"allowed",
        ref:"attr:DataSource.resultTreeClass",
        defaultValue:"null",
        valueType:"Class Object",
        deprecated:null,
        name:"resultTreeClass",
        flags:"IRA",
        description:"Class for ResultTrees used by this datasource.  If null, defaults to using\n ${isc.DocUtils.linkForRef('class:ResultTree')}.\n <P>\n This can be set to a custom subclass of ResultTree that, for example, hangs on to extra\n information necessary for integration with web services.",
        definingClass:"class:DataSource",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DrawItem.lineOpacity":{
        defaultValue:"1.0",
        deprecated:null,
        flags:"IRW",
        description:"Opacity for lines, as a number between 0 (transparent) and 1 (opaque).",
        groups:[
            "line"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DrawItem.lineOpacity",
        valueType:"float",
        name:"lineOpacity",
        definingClass:"class:DrawItem",
        setter:[
            "setLineOpacity"
        ]
    },
    "attr:ImgSplitbar.canDrag":{
        ref:"attr:ImgSplitbar.canDrag",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"canDrag",
        flags:"IRW",
        description:"<code>canDrag</code> set to true to allow dragging of the split bar. Dragging the\n Splitbar will resize it's ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}",
        definingClass:"class:ImgSplitbar",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DataSource.fieldMatchesFilter":{
        ref:"method:DataSource.fieldMatchesFilter",
        deprecated:null,
        name:"fieldMatchesFilter",
        flags:"",
        description:" Compares a criteria value to a field value and returns whether they match, as follows:\n <ul>\n <li> any non-String filter value is directly compared (==) to the field value\n <li> any String filter value is compared according to\n      ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle')} in the passed <code>requestProperties</code>,\n      regardless of the actual field type\n <li> if the filter value is an Array, the comparison is a logical OR.  If textMatchStyle\n      is \"exact\", it matches if fieldValue (or any of it's entries, if it's also an array) \n      is contained in the filterValue Array.  If textMatchStyle if substring, it matches \n      if any of the entries in filterValue appear as a case-insensitive substring of any\n      of the entries in fieldValue.\n <li>Dates are compared as logical dates if either the field value or the filter value is a logical date.\n     Only if none of them is a logical date they will be compared as standard Dates\n </ul>\n",
        definingClass:"class:DataSource",
        returns:{
            description:"true if the filter and field values match, false otherwise",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"fieldValue",
                description:"field value to be compared",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"filterValue",
                description:"filter value to be compared",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"requestProperties",
                description:"optional dataSource request properties",
                optional:true,
                type:"DSRequest Properties"
            }
        ],
        seeAlso:[
        ]
    },
    "group:toolbar":{
        ref:"group:toolbar",
        refs:[
            "attr:Dialog.showToolbar",
            "attr:Dialog.autoFocus"
        ],
        deprecated:null,
        name:"toolbar",
        description:null,
        type:"group",
        seeAlso:[
        ]
    },
    "method:Date.toSerializeableDate":{
        ref:"method:Date.toSerializeableDate",
        deprecated:null,
        name:"toSerializeableDate",
        flags:"A",
        description:" Return this date in 'serialized' format <code>YYYY-MM-DD HH:MM:SS</code>\n",
        groups:[
            "dateFormatting"
        ],
        definingClass:"class:Date",
        returns:{
            description:"formatted date string",
            type:"String"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:Canvas.getPanelContainer":{
        ref:"method:Canvas.getPanelContainer",
        deprecated:null,
        name:"getPanelContainer",
        flags:"",
        description:" Returns this Canvas's \"panel container\".  A panel container is a widget that manages a \n collection of panels, like a ${isc.DocUtils.linkForRef('class:TabSet')} or ${isc.DocUtils.linkForRef('class:SectionStack')}.  If this\n Canvas is not a child of such a panel container, this method returns null.\n\n",
        definingClass:"class:Canvas",
        returns:{
            description:"the Canvas's panel container, or null if the Canvas is not a chlld of                    a panel container",
            type:"Canvas"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "attr:ResultSet.disableCacheSync":{
        ref:"attr:ResultSet.disableCacheSync",
        defaultValue:"false",
        valueType:"boolean",
        deprecated:null,
        name:"disableCacheSync",
        flags:"IRA",
        description:"By default when the data of this ResultSet's dataSource is modified, the ResultSet will\n be updated to display these changes.\n Set this flag to true to disable this behavior.",
        groups:[
            "cacheSync"
        ],
        definingClass:"class:ResultSet",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:FormItem.valueIconHeight":{
        ref:"attr:FormItem.valueIconHeight",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"valueIconHeight",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:FormItem.valueIcons')} is specified, use this property to specify a height for the\n value icon written out.",
        groups:[
            "valueIcons"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:FormItem.valueIconWidth",
                description:null
            },
            {
                ref:"attr:FormItem.valueIconSize",
                description:null
            }
        ]
    },
    "attr:FormItem.accessKey":{
        ref:"attr:FormItem.accessKey",
        defaultValue:"null",
        valueType:"keyChar",
        deprecated:null,
        name:"accessKey",
        flags:"IRW",
        description:"If specified this governs the HTML accessKey for the item.\n <P>\n This should be set to a character - when a user hits the html accessKey modifier for\n the browser, plus this character, focus will be given to the item.\n The accessKey modifier can vary by browser and platform. \n <P>\n The following list of default behavior is for reference only, developers should also\n consult browser documentation for additional information.\n <ul>\n <li><b>Internet Explorer (all platforms)</b>: <code>Alt</code> + <i>accessKey</i></li>\n <li><b>Mozilla Firefox (Windows, Unix)</b>: <code>Alt+Shift</code> + <i>accessKey</i></li>\n <li><b>Mozilla Firefox (Mac)</b>: <code>Ctrl+Opt</code> + <i>accessKey</i></li>\n <li><b>Chrome and Safari (Windows, Unix)</b>:  <code>Alt</code> + <i>accessKey</i></li>\n <li><b>Chrome and Safari (Mac)</b>:  <code>Ctrl+Opt</code> + <i>accessKey</i></li>\n </ul>",
        groups:[
            "focus"
        ],
        definingClass:"class:FormItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:StretchItem.height":{
        ref:"attr:StretchItem.height",
        defaultValue:"null",
        valueType:"number or String",
        deprecated:null,
        name:"height",
        flags:"IR",
        description:"The height of the image. This can either be a number (for the number of pixels tall), the string\n \"*\" (remaining space, divided amongst all items that specify height:\"*\"), or the name of a property\n on the StretchImg component, such as \"capSize\" for the StretchImg's ${isc.DocUtils.linkForRef('attr:StretchImg.capSize','capSize')}.\n <p>\n <b>NOTE:</b> The height is only used if the StretchImg stacks its images vertically\n (${isc.DocUtils.linkForRef('attr:StretchImg.vertical')} is true).",
        definingClass:"object:StretchItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGridField.canReorder":{
        ref:"attr:ListGridField.canReorder",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"canReorder",
        flags:"IR",
        description:"Whether this field can be reordered using the mouse.  If unset, the default behavior is\n governed by ${isc.DocUtils.linkForRef('attr:ListGrid.canReorderFields')}.  Note that setting this property to\n <code>false</code> will lock this field from being moved - that is, the user is\n prevented from moving this field directly by dragging with the mouse, or by dropping\n another field onto this field.\n <P>\n Note that setting <code>canReorder:false</code> on a field in the middle of a grid is\n mostly useless, since it's possible that such a \"locked\" field may still be reordered\n automatically, as a result of the user dragging one unlocked field onto another unlocked\n field.",
        groups:[
            "dragging"
        ],
        definingClass:"object:ListGridField",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:LoginDialog.loginButtonTitle":{
        ref:"attr:LoginDialog.loginButtonTitle",
        defaultValue:"Dialog.LOGIN_BUTTON_TITLE",
        valueType:"String",
        deprecated:null,
        name:"loginButtonTitle",
        flags:"IR",
        description:"Specifies the contents of the login submission button of the ${isc.DocUtils.linkForRef('attr:LoginDialog.loginForm')}.",
        definingClass:"class:LoginDialog",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:UploadItem.height":{
        ref:"attr:UploadItem.height",
        defaultValue:"19",
        valueType:"number",
        deprecated:null,
        name:"height",
        flags:"IRW",
        description:"Height for this uploadItem. Note that SmartClient will not apply this size to the\n native HTML &lt;input ...&gt; element written out by this formItem as this leads to\n inconsistent appearance across different browsers. The specified height\n acts as a minimum cell width for the item.",
        definingClass:"class:UploadItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TableView.showIconField":{
        ref:"attr:TableView.showIconField",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showIconField",
        flags:"IRW",
        description:"Should an icon field be shown for each record? A column in the table is set\n aside for an icon as specified on each record in the ${isc.DocUtils.linkForRef('attr:TableView.iconField')}.",
        definingClass:"class:TableView",
        type:"attr",
        seeAlso:[
        ]
    },
    "classAttr:FileLoader.modulesDir":{
        ref:"classAttr:FileLoader.modulesDir",
        defaultValue:"\"system/modules/\"",
        valueType:"String",
        deprecated:null,
        name:"modulesDir",
        flags:"IR",
        description:"Path to module files (ISC_Core.js et al) relative to the isomorphicDir (see\n ${isc.DocUtils.linkForRef('class:FileLoader','FileLoader overview')}).\n <p>\n Does not normally need to be set for SmartClient.  If using Smart GWT, set to \"modules/\".",
        definingClass:"class:FileLoader",
        type:"classAttr",
        seeAlso:[
        ]
    },
    "method:Date.toNormalDatetime":{
        ref:"method:Date.toNormalDatetime",
        deprecated:null,
        name:"toNormalDatetime",
        flags:"",
        description:" Returns the datetime as a formatted string using the format set up via the\n <code>setNormalDatetimeDisplayFormat()</code> method.\n",
        groups:[
            "dateFormatting"
        ],
        definingClass:"class:Date",
        returns:{
            description:"formatted date string",
            type:"string"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"format",
                description:"Optional Format for the date returned",
                optional:false,
                type:"DateDisplayFormat"
            },
            {
                defaultValue:null,
                name:"useCustomTimezone",
                description:"If a custom timezone has been set via   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.\n   To suppress this behavior, this parameter should be set to false.",
                optional:true,
                type:"Boolean"
            }
        ],
        seeAlso:[
        ]
    },
    "type:Overflow":{
        ref:"type:Overflow",
        values:[
            {
                description:"Content that extends beyond the widget's width or height is                              displayed.\n                              Note: To have the content be sized only by the drawn size of\n                              the content set the overflow to be Canvas.VISIBLE and specify\n                              a small size, allowing the size to expand to the size required\n                              by the content.\n                              Leaving the width / height for the widget undefined will use the\n                              default value of 100, and setting the size to zero may cause the\n                              widget not to draw.",
                value:"Canvas.VISIBLE"
            },
            {
                description:"Content that extends beyond the widget's width or height is                              clipped (hidden).",
                value:"Canvas.HIDDEN"
            },
            {
                description:"Horizontal and/or vertical scrollbars are displayed only if                              necessary. Content that extends beyond the remaining visible\n                              area is clipped.",
                value:"Canvas.AUTO"
            },
            {
                description:"Horizontal and vertical scrollbars are always drawn inside the                              widget. Content that extends beyond the remaining visible area\n                              is clipped, and can be accessed via scrolling.",
                value:"Canvas.SCROLL"
            },
            {
                description:"Clip horizontally but extend the canvas's clip region                              vertically if necessary.",
                value:"Canvas.CLIP_H"
            },
            {
                description:"Clip vertically but extend the canvas's clip region                              horizontally if necessary.",
                value:"Canvas.CLIP_V"
            }
        ],
        deprecated:null,
        name:"Overflow",
        description:null,
        groups:[
            "sizing"
        ],
        type:"type",
        seeAlso:[
        ]
    },
    "method:Calendar.timelineEventResized":{
        ref:"method:Calendar.timelineEventResized",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('method:Calendar.eventResizeStop')}",
        name:"timelineEventResized",
        flags:"",
        description:" Called when a Timeline event is resized via dragging by a user.  Return false to disallow \n the resize.\n",
        definingClass:"class:Calendar",
        returns:{
            description:"return false to disallow the resize",
            type:"Boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"event",
                description:"the event that was resized",
                optional:false,
                type:"CalendarEvent"
            },
            {
                defaultValue:null,
                name:"startDate",
                description:"new start date of the passed event, after the resize",
                optional:false,
                type:"Date"
            },
            {
                defaultValue:null,
                name:"endDate",
                description:"new end date of the passed event, after the resize",
                optional:false,
                type:"Date"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:DataSource.flattenCriteria":{
        ref:"classMethod:DataSource.flattenCriteria",
        deprecated:null,
        name:"flattenCriteria",
        flags:"",
        description:" Returns new criteria that has at most one top-level LogicalOperator (\"and\" or \"or\").\n This new criteria will be considered \"flat\" by ${isc.DocUtils.linkForRef('classMethod:DataSource.isFlatCriteria')}.\n <p>\n Not all AdvancedCriteria can be flattened and remain logically equivalent.  When\n criteria will be logically modified by flattening, all criteria that appear anywhere in\n the AdvancedCriteria structure will appear under a single top-level operator, which\n will be the same top-level operator as the passed AdvancedCriteria.\n <p>\n For example, given criteria like this (in the JSON representation of AdvancedCriteria):\n <pre>\n      { operator: \"and\", criteria: [\n         { fieldName: \"continent\", operator: \"equals\", value: \"Europe\"},\n         { operator: \"or\", criteria: [\n            { fieldName: \"countryName\", operator: \"iEndsWith\", value: \"land\"},\n            { fieldName: \"population\", operator: \"lessThan\", value: 3000000}\n         ]}\n        ]\n      }\n </pre>\n The returned criteria would be:\n <pre>\n      { operator: \"and\", criteria: [\n         { fieldName: \"continent\", operator: \"equals\", value: \"Europe\"},\n         { fieldName: \"countryName\", operator: \"iEndsWith\", value: \"land\"},\n         { fieldName: \"population\", operator: \"lessThan\", value: 3000000}\n       ]}\n </pre>\n This returned criteria is not logically equivalent to the passed criteria - the\n \"iEndsWith\" and \"lessThan\" criteria that were formerly nested under a logical \"or\"\n operator must now <i>both</i> be satisfied instead of <i>either</i> being satisfied.\n You can use ${isc.DocUtils.linkForRef('classMethod:DataSource.canFlattenCriteria')} to detect whether an AdvancedCriteria is going\n to be changed by <code>flattenCriteria()</code>.\n <p>\n Because the returned criteria may not be logically equivalent,\n <code>flattenCriteria</code> should not be used as a means of simplifying criteria to\n make server implementation easier or anything of the kind.  The primary purpose of\n returning logically different criteria is to enable an end user to switch from an\n interface for editing nested criteria to an interface that can't handle nested\n criteria and convert the criteria while preserving as much as possible.\n\n",
        definingClass:"class:DataSource",
        returns:{
            description:"flattened criteria",
            type:"AdvancedCriteria"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"the AdvancedCriteria to flatten",
                optional:false,
                type:"AdvancedCriteria"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:PickTreeItem.button":{
        ref:"attr:PickTreeItem.button",
        defaultValue:"null",
        valueType:"AutoChild Canvas",
        deprecated:null,
        name:"button",
        flags:"R",
        description:"The visible button created by a PickTreeItem is an ${isc.DocUtils.linkForRef('type:AutoChild')} of type\n ${isc.DocUtils.linkForRef('class:TreeMenuButton')} by default.",
        definingClass:"class:PickTreeItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ProcessElement.nextElement":{
        ref:"attr:ProcessElement.nextElement",
        defaultValue:"null",
        valueType:"String",
        deprecated:null,
        name:"nextElement",
        flags:"IR",
        description:"Next ${isc.DocUtils.linkForRef('attr:Process.sequences','sequence')} or ${isc.DocUtils.linkForRef('attr:Process.elements','element')} to execute\n after this one completes.  \n <p>\n <code>nextElement</code> does not need to be specified on most elements if you use\n ${isc.DocUtils.linkForRef('attr:Process.sequences','sequences')}.\n <p>\n Note that if there is both a <code>sequence</code> and a normal <code>element</code>\n with the same name in the current <code>Process</code>, the <code>sequence</code> will\n be used.",
        definingClass:"class:ProcessElement",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:StretchImgButton.labelVPad":{
        ref:"attr:StretchImgButton.labelVPad",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"labelVPad",
        flags:"IRW",
        description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",
        definingClass:"class:StretchImgButton",
        type:"attr",
        seeAlso:[
        ]
    },
    "classMethod:isA.ClassObject":{
        ref:"classMethod:isA.ClassObject",
        deprecated:null,
        name:"ClassObject",
        flags:"",
        description:"\n\tIs <code>object</code> a class object?\n\n",
        definingClass:"object:isA",
        returns:{
            description:"true == <code>object</code> is a Class Object",
            type:"boolean"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"object",
                description:"object to test",
                optional:false,
                type:"object"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:RPCRequest.httpHeaders":{
        ref:"attr:RPCRequest.httpHeaders",
        defaultValue:"null",
        valueType:"Object",
        deprecated:null,
        name:"httpHeaders",
        flags:"IRW",
        description:"HTTP headers to send, as a Object mapping Header name -> Header value, eg<br>\n { \"Content-Type\" : \"text/xml\" }\n <P>\n Valid with the xmlHttpRequest ${isc.DocUtils.linkForRef('attr:RPCRequest.transport','transport')} only.",
        definingClass:"class:RPCRequest",
        type:"attr",
        seeAlso:[
        ]
    },
    "class:DateRangeItem":{
        classAttrs:[
        ],
        ref:"class:DateRangeItem",
        methods:[
            "method:DateRangeItem.setFromDate",
            "method:DateRangeItem.setToDate",
            "method:DateRangeItem.hasAdvancedCriteria",
            "method:DateRangeItem.getCriterion",
            "method:DateRangeItem.validateRange",
            "method:DateRangeItem.canEditCriterion",
            "method:DateRangeItem.setCriterion",
            "method:DateRangeItem.setValue",
            "method:DateRangeItem.getValue"
        ],
        deprecated:null,
        name:"DateRangeItem",
        description:"Allows a user to select an absolute or relative range of dates via two\n ${isc.DocUtils.linkForRef('class:RelativeDateItem')}s (if ${isc.DocUtils.linkForRef('attr:DateRangeItem.allowRelativeDates')} is true) or two\n ${isc.DocUtils.linkForRef('class:DateItem','DateItems')}.\n <P>\n The item's ${isc.DocUtils.linkForRef('attr:FormItem.type','data type')} is expected to be one of \"date\" or \"datetime\" and\n dictates whether the dates in the range include a time portion.  If unset and the item's \n form is databound, the data type is detected from the associated \n ${isc.DocUtils.linkForRef('class:DataSourceField','dataSource field')}.  If there is no such field, or the form is not \n databound, the default data type value is \"date\".\n <P>\n DateRangeItem is just a convenience relative to using two ${isc.DocUtils.linkForRef('class:RelativeDateItem')} or\n ${isc.DocUtils.linkForRef('class:DateItem')} controls in a form, then using ${isc.DocUtils.linkForRef('attr:FormItem.operator')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.criteriaField')} to cause them to produce a date range.  If you need more\n control over layout, validation, event handling or any other aspect of appearance or\n behavior, stop using DateRangeItem and use two DateItem/RelativeDateItem controls directly\n instead.",
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:DateRangeItem.fieldLayout",
            "attr:DateRangeItem.shouldSaveValue",
            "attr:DateRangeItem.fromTitle",
            "attr:DateRangeItem.toTitle",
            "attr:DateRangeItem.innerTitleOrientation",
            "attr:DateRangeItem.allowRelativeDates",
            "attr:DateRangeItem.fromField",
            "attr:DateRangeItem.toField",
            "attr:DateRangeItem.fromDate",
            "attr:DateRangeItem.toDate",
            "attr:DateRangeItem.dateInputFormat",
            "attr:DateRangeItem.inputFormat",
            "attr:DateRangeItem.dateDisplayFormat",
            "attr:DateRangeItem.validateCriteria",
            "attr:DateRangeItem.dateRangeForm",
            "attr:DateRangeItem.relativeItemConstructor",
            "attr:DateRangeItem.absoluteItemConstructor",
            "attr:DateRangeItem.absoluteDateTimeItemConstructor",
            "attr:DateRangeItem.invalidRangeErrorMessage"
        ]
    },
    "attr:ListGrid.autoFitHeaderHeights":{
        ref:"attr:ListGrid.autoFitHeaderHeights",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"autoFitHeaderHeights",
        flags:"IR",
        description:"If this property is set to true, header buttons for either ${isc.DocUtils.linkForRef('attr:ListGrid.fields','fields')} or\n ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','header spans')} will automatically expand to accommodate their\n titles vertically.  This means if you have a \"tall\" title - typically a long string where\n ${isc.DocUtils.linkForRef('attr:ListGridField.wrap')} is set to true such that you end up with several lines of text -\n the button will render large enough to accommodate it.  If necessary this will cause the\n header for the grid as a whole to expand beyond the specified ${isc.DocUtils.linkForRef('attr:ListGrid.headerHeight')}.\n <P>\n Note that you need not set ${isc.DocUtils.linkForRef('attr:HeaderSpan.height')} or ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpanHeight')} if you set\n this property, but if you do, they will be used as minimum values.",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:RecordEditor.actionButton":{
        ref:"attr:RecordEditor.actionButton",
        defaultValue:"null",
        valueType:"Button AutoChild",
        deprecated:null,
        name:"actionButton",
        flags:"R",
        description:"Automatically created Button auto-child shown at the edge of the recordEditor.\n For a recordEditor acting as a ${isc.DocUtils.linkForRef('attr:ListGrid.filterEditor')}, this button will\n show the ${isc.DocUtils.linkForRef('attr:RecordEditor.filterImg')} as an ${isc.DocUtils.linkForRef('attr:Button.icon')} by default.\n <P>\n Clicking this button will call ${isc.DocUtils.linkForRef('method:RecordEditor.performAction')} on the editor.\n <P>\n May be customized using the standard ${isc.DocUtils.linkForRef('type:AutoChild')} pattern, by overriding\n ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButtonProperties')}.",
        definingClass:"class:RecordEditor",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DetailViewer.hiliteIconWidth":{
        ref:"attr:DetailViewer.hiliteIconWidth",
        defaultValue:"null",
        valueType:"number",
        deprecated:null,
        name:"hiliteIconWidth",
        flags:"IRW",
        description:"Width for hilite icons for this component.\n Overrides ${isc.DocUtils.linkForRef('attr:DetailViewer.hiliteIconSize','hiliteIconSize')}.\n Can be overridden at the field level.",
        groups:[
            "hiliting"
        ],
        definingClass:"class:DetailViewer",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.rowNumberStyle":{
        ref:"attr:ListGrid.rowNumberStyle",
        defaultValue:"\"specialCol\"",
        valueType:"CSSStyleName",
        deprecated:null,
        name:"rowNumberStyle",
        flags:"IRWA",
        description:"The CSS Style name for the ${isc.DocUtils.linkForRef('attr:ListGrid.rowNumberField')}.",
        groups:[
            "rowNumberField"
        ],
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:ListGrid.showSelectedStyle":{
        ref:"attr:ListGrid.showSelectedStyle",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showSelectedStyle",
        flags:"IRW",
        description:"Should the \"Selected\" style be applied to selected records?",
        definingClass:"class:ListGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"method:GridRenderer.getCellStyle",
                description:null
            }
        ]
    },
    "attr:MenuItem.keyTitle":{
        defaultValue:"see below",
        deprecated:null,
        flags:"IR",
        description:"A string to display in the shortcut-key column for this item. If not\n specified, the first KeyName value in ${isc.DocUtils.linkForRef('attr:MenuItem.keys')} will be used by default.",
        groups:[
            "menuKeys"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:MenuItem.keyTitle",
        examples:[
            "${isc.DocUtils.linkForExampleId('fullMenu')}"
        ],
        valueType:"string",
        name:"keyTitle",
        definingClass:"object:MenuItem"
    },
    "method:DrawItem.mouseOver":{
        ref:"method:DrawItem.mouseOver",
        deprecated:null,
        name:"mouseOver",
        flags:"",
        description:" Notification fired when the mouse enters this DrawItem.\n <p>\n Note that if this item is part of a ${isc.DocUtils.linkForRef('class:DrawGroup')}, then the group's ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')}\n setting affects whether this item receives the notification. If useGroupRect is true, then\n this item will <em>not</em> receive the notification. Otherwise, the item receives the\n notification and notification bubbles up to the group.\n",
        groups:[
            "widgetEvents"
        ],
        definingClass:"class:DrawItem",
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"Boolean"
        },
        type:"method",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ]
    },
    "attr:Window.bodyColor":{
        defaultValue:"\"#FFFFFF\"",
        deprecated:null,
        flags:"IRW",
        description:"Color of the Window body. Overrides the background color specified in the style.",
        groups:[
            "appearance",
            "body"
        ],
        type:"attr",
        seeAlso:[
            {
                ref:"method:Window.flash",
                description:null
            }
        ],
        ref:"attr:Window.bodyColor",
        valueType:"CSSColor",
        name:"bodyColor",
        definingClass:"class:Window",
        setter:[
            "setBodyColor"
        ]
    },
    "attr:ColorItem.allowComplexMode":{
        ref:"attr:ColorItem.allowComplexMode",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"allowComplexMode",
        flags:"IR",
        description:"Should \"complex\" mode be allowed for the ${isc.DocUtils.linkForRef('class:ColorPicker')} window associated with  \n this ColorItem?<p>\n If false, no \"More\" button is shown on the simple picker",
        definingClass:"class:ColorItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:Canvas.edgeImage":{
        defaultValue:"\"[SKIN]edge.gif\"",
        deprecated:null,
        flags:"IR",
        description:"Base name of images for edges.  Extensions for each corner or edge piece will be added\n to this image URL, before the extension.  For example, with the default base name of\n \"edge.gif\", the top-left corner image will be \"edge_TL.gif\".\n <P>\n The full list of extensions is: \"_TL\", \"_TR\", \"_BL\", \"_BR\", \"_T\", \"_L\", \"_B\", \"_R\",\n \"_center\".",
        groups:[
            "imageEdges"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:Canvas.edgeImage",
        examples:[
            "${isc.DocUtils.linkForExampleId('edges')}"
        ],
        valueType:"SCImgURL",
        name:"edgeImage",
        definingClass:"class:Canvas"
    },
    "attr:ColorPicker.okButtonConstructor":{
        ref:"attr:ColorPicker.okButtonConstructor",
        defaultValue:"IButton",
        valueType:"Class",
        deprecated:null,
        name:"okButtonConstructor",
        flags:"IRWA",
        description:"The class of the \"OK\" button. It is intended that you use either IButton or \n      Button - other classes are unlikely to work correctly.",
        definingClass:"class:ColorPicker",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:Callbacks.MessagingCallback":{
        ref:"method:Callbacks.MessagingCallback",
        deprecated:null,
        name:"MessagingCallback",
        flags:"",
        description:" Callback executed when a message is sent to a channel that you have\n ${isc.DocUtils.linkForRef('classMethod:Messaging.subscribe','subscribed')} to.\n",
        definingClass:"class:Callbacks",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"data",
                description:"data contained in the message",
                optional:false,
                type:"any"
            }
        ],
        seeAlso:[
        ]
    },
    "class:SpinnerItem":{
        classAttrs:[
        ],
        methods:[
            "method:SpinnerItem.getNextValue",
            "method:SpinnerItem.getPreviousValue"
        ],
        deprecated:null,
        description:"Item for picking a number. Includes arrow buttons to increase / decrease the value",
        treeLocation:[
            "Client Reference/Forms/Form Items"
        ],
        type:"class",
        seeAlso:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:SpinnerItem.mask",
            "attr:SpinnerItem.maskSaveLiterals",
            "attr:SpinnerItem.maskPadChar",
            "attr:SpinnerItem.maskPromptChar",
            "attr:SpinnerItem.maskOverwriteMode",
            "attr:SpinnerItem.unstackedTextBoxStyle",
            "attr:SpinnerItem.unstackedPrintTextBoxStyle",
            "attr:SpinnerItem.unstackedReadOnlyTextBoxStyle",
            "attr:SpinnerItem.step",
            "attr:SpinnerItem.max",
            "attr:SpinnerItem.min",
            "attr:SpinnerItem.increaseIcon",
            "attr:SpinnerItem.increaseIconProperties",
            "attr:SpinnerItem.decreaseIcon",
            "attr:SpinnerItem.decreaseIconProperties",
            "attr:SpinnerItem.writeStackedIcons",
            "attr:SpinnerItem.unstackedIncreaseIcon",
            "attr:SpinnerItem.unstackedDecreaseIcon"
        ],
        ref:"class:SpinnerItem",
        examples:[
            "${isc.DocUtils.linkForExampleId('spinnerItem')}"
        ],
        name:"SpinnerItem"
    },
    "attr:DynamicForm.datetimeFormatter":{
        ref:"attr:DynamicForm.datetimeFormatter",
        defaultValue:"null",
        valueType:"DateDisplayFormat",
        deprecated:null,
        name:"datetimeFormatter",
        flags:"IRW",
        description:"Default ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} for Date type values displayed in this form in fields\n of type <code>datetime</code>.\n <P>\n For datetime fields, this attribute will be used instead of ${isc.DocUtils.linkForRef('attr:DynamicForm.dateFormatter')}\n when formatting Date values.\n <P>\n Note that if specified, ${isc.DocUtils.linkForRef('attr:FormItem.dateFormatter')} and ${isc.DocUtils.linkForRef('attr:FormItem.timeFormatter')}\n take precedence over the format specified at the component level.\n <P>\n If no explicit formatter is specified at the field or component level, datetime field\n values will be formatted according to the system-wide\n ${isc.DocUtils.linkForRef('classMethod:Date.setShortDatetimeDisplayFormat','short datetime display format')}.",
        definingClass:"class:DynamicForm",
        type:"attr",
        seeAlso:[
        ]
    },
    "method:DynamicForm.setValuesAsCriteria":{
        ref:"method:DynamicForm.setValuesAsCriteria",
        deprecated:null,
        name:"setValuesAsCriteria",
        flags:"",
        description:" This method will display the specified criteria in this form for editing. The criteria\n parameter may be a simple ${isc.DocUtils.linkForRef('object:Criterion')} object or an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object.\n <P>\n For simple criteria, the specified fieldName will be used to apply criteria to form items,\n as with a standard setValues() call.\n <P>\n For AdvancedCriteria, behavior is as follows:\n <ul>\n <li>If the top level operator doesn't match the ${isc.DocUtils.linkForRef('attr:DynamicForm.operator','operator')} for\n  this form, the entire criteria will be nested in an outer advanced criteria object with\n  the appropriate operator.</li>\n <li>Each criterion within AdvancedCriteria will be applied to a form item if\n  ${isc.DocUtils.linkForRef('attr:FormItem.shouldSaveValue')} is true for the item and \n  ${isc.DocUtils.linkForRef('method:FormItem.canEditCriterion')} returns true for the criterion in question. By default\n  this method checks for a match with both the <code>fieldName</code> and <code>operator</code>\n  of the criterion. The criterion is actually passed to the item for editing via\n  ${isc.DocUtils.linkForRef('method:FormItem.setCriterion')}\n  .\n  Note that these methods may be overridden for custom\n  handling. Also note that the default ${isc.DocUtils.linkForRef('method:CanvasItem.setCriterion')} implementation\n   handles editing nested criteria via embedded dynamicForms.</li>\n <li>Criteria which don't map to any form item will be stored directly on the form and\n  recombined with the edited values from each item when ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} is\n  called.</li>\n </ul>\n",
        groups:[
            "criteriaEditing"
        ],
        definingClass:"class:DynamicForm",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"criteria",
                description:"criteria to edit.",
                optional:false,
                type:"Criterion"
            }
        ],
        seeAlso:[
        ]
    },
    "method:StatefulCanvas.getState":{
        ref:"method:StatefulCanvas.getState",
        deprecated:null,
        name:"getState",
        flags:"A",
        description:" Return the state of this StatefulCanvas\n",
        groups:[
            "state"
        ],
        definingClass:"class:StatefulCanvas",
        returns:{
            description:null,
            type:"State"
        },
        type:"method",
        seeAlso:[
        ]
    },
    "method:ImgButton.setBaseStyle":{
        ref:"method:ImgButton.setBaseStyle",
        deprecated:null,
        name:"setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        definingClass:"class:ImgButton",
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"style",
                description:"new base style",
                optional:false,
                type:"CSSStyleName"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:History.getHistoryData":{
        ref:"classMethod:History.getHistoryData",
        deprecated:null,
        name:"getHistoryData",
        flags:"",
        description:"\n Returns the data associated with the specified history id.\n\n",
        definingClass:"class:History",
        returns:{
            description:"The data associated with the specified history id.",
            type:"any"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"id",
                description:"The id for which to fetch history data.",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "method:Calendar.getIndicatorHoverHTML":{
        ref:"method:Calendar.getIndicatorHoverHTML",
        deprecated:null,
        name:"getIndicatorHoverHTML",
        flags:"",
        description:" Gets the hover HTML for an ${isc.DocUtils.linkForRef('attr:Calendar.indicators','indicator')} being hovered over. \n Override here to return custom HTML based upon the parameter indicator object.\n\n",
        definingClass:"class:Calendar",
        returns:{
            description:"the HTML to show in the hover",
            type:"HTMLString"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"indicator",
                description:"The indicator being hovered over",
                optional:false,
                type:"CalendarEvent"
            },
            {
                defaultValue:null,
                name:"indicatorCanvas",
                description:"the indicator canvas being hovered over",
                optional:false,
                type:"IndicatorCanvas"
            },
            {
                defaultValue:null,
                name:"view",
                description:"the CalendarView in which the indicatorCanvas is displayed",
                optional:false,
                type:"CalendarView"
            },
            {
                defaultValue:null,
                name:"defaultValue",
                description:"the default HTML to show when hovering over the passed Indicator",
                optional:false,
                type:"String"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:SliderItem.sliderConstructor":{
        ref:"attr:SliderItem.sliderConstructor",
        defaultValue:"Slider",
        valueType:"Class",
        deprecated:null,
        name:"sliderConstructor",
        flags:"IR",
        description:"Constructor class for this item's ${isc.DocUtils.linkForRef('class:Slider')}.",
        definingClass:"class:SliderItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSource.defaultTextMatchStyle":{
        serverDS:"allowed",
        defaultValue:"\"exact\"",
        deprecated:null,
        flags:"IR",
        description:"The default textMatchStyle to use for ${isc.DocUtils.linkForRef('class:DSRequest')}s that do not explicitly state \n a ${isc.DocUtils.linkForRef('attr:DSRequest.textMatchStyle','textMatchStyle')}.    Note, however, that DSRequests \n issued by ${isc.DocUtils.linkForRef('class:ListGrid')}s and other ${isc.DocUtils.linkForRef('interface:DataBoundComponent','components')} will \n generally have a setting for textMatchStyle on the component itself (see\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoFetchTextMatchStyle')}, for example).",
        groups:[
            "clientDataIntegration",
            "serverDataIntegration"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DataSource.defaultTextMatchStyle",
        examples:[
            "${isc.DocUtils.linkForExampleId('jsonDataSource')}",
            "${isc.DocUtils.linkForExampleId('simpleJSON')}"
        ],
        valueType:"TextMatchStyle",
        name:"defaultTextMatchStyle",
        definingClass:"class:DataSource"
    },
    "method:SliderItem.pendingStatusChanged":{
        ref:"method:SliderItem.pendingStatusChanged",
        examples:[
            "${isc.DocUtils.linkForExampleId('canvasItemShowPendingSupport')}"
        ],
        deprecated:null,
        name:"pendingStatusChanged",
        flags:"",
        description:" Notification method called when ${isc.DocUtils.linkForRef('attr:FormItem.showPending','showPending')} is enabled and\n this <code>SliderItem</code> should either clear or show its pending visual state.\n <p>\n The default behavior is that the ${isc.DocUtils.linkForRef('attr:FormItem.titleStyle','titleStyle')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.cellStyle','cellStyle')} are updated to include/exclude the \"Pending\" suffix.\n In addition, when displayed in the pending state the value label changes color.\n Returning <code>false</code> will cancel this default behavior.\n",
        definingClass:"class:SliderItem",
        returns:{
            description:"<code>false</code> to cancel the default behavior.",
            type:"boolean"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"form",
                description:"the managing <code>DynamicForm</code> instance.",
                optional:false,
                type:"DynamicForm"
            },
            {
                defaultValue:null,
                name:"item",
                description:"the form item itself (also available as \"this\").",
                optional:false,
                type:"FormItem"
            },
            {
                defaultValue:null,
                name:"pendingStatus",
                description:"<code>true</code> if the item should show its pending visual state; <code>false</code> otherwise.",
                optional:false,
                type:"boolean"
            },
            {
                defaultValue:null,
                name:"newValue",
                description:"the current form item value.",
                optional:false,
                type:"any"
            },
            {
                defaultValue:null,
                name:"value",
                description:"the value that would be restored by a call to ${isc.DocUtils.linkForRef('method:DynamicForm.resetValues')}.",
                optional:false,
                type:"any"
            }
        ],
        seeAlso:[
        ]
    },
    "classMethod:Date.getLogicalDateOnly":{
        ref:"classMethod:Date.getLogicalDateOnly",
        deprecated:null,
        name:"getLogicalDateOnly",
        flags:"",
        description:" Get a logical date - a value appropriate for a DataSourceField of type \"date\" - from a\n datetime value (a value from a DataSourceField of type \"datetime\").\n <P>\n This method correctly takes into account the current\n ${isc.DocUtils.linkForRef('classMethod:Time.setDefaultDisplayTimezone','display timezone')}, specifically, the returned Date\n will reflect the day, month and year that appears when the datetime is rendered\n by a SmartClient component rather than the date values that would be returned by\n Date.getDay() et al (which can differ, since getDay() uses the browser's local timezone).\n <P>\n For further background on date, time and datetime types, storage and transmission, see\n ${isc.DocUtils.linkForRef('group:dateFormatAndStorage','this overview')}.\n\n",
        definingClass:"class:Date",
        returns:{
            description:"a Date instance representing just the date portion of the datetime value, as                a logical date",
            type:"Date"
        },
        type:"classMethod",
        params:[
            {
                defaultValue:null,
                name:"date",
                description:"a Date instance representing a datetime value",
                optional:false,
                type:"Date"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:MenuButton.showMenuBelow":{
        ref:"attr:MenuButton.showMenuBelow",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"showMenuBelow",
        flags:"IRW",
        description:"The menu drops down below the menu button.\n\t\t\tSet to false if the menu should appear above the menu button.",
        definingClass:"class:MenuButton",
        type:"attr",
        setter:[
            "setShowMenuBelow"
        ],
        seeAlso:[
        ]
    },
    "attr:SplitPane.detailTitle":{
        ref:"attr:SplitPane.detailTitle",
        defaultValue:"null",
        valueType:"HTMLString",
        deprecated:null,
        name:"detailTitle",
        flags:"IRW",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:SplitPane.detailPane','detailPane')}.",
        definingClass:"class:SplitPane",
        type:"attr",
        setter:[
            "setDetailTitle"
        ],
        seeAlso:[
        ]
    },
    "attr:DynamicForm.dataSource":{
        defaultValue:"null",
        deprecated:null,
        flags:"IRW",
        description:"The DataSource that this component should bind to for default fields and for performing\n ${isc.DocUtils.linkForRef('class:DSRequest','DataSource requests')}.\n <P>\n Can be specified as either a DataSource instance or the String ID of a DataSource.",
        groups:[
            "databinding"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DynamicForm.dataSource",
        examples:[
            "${isc.DocUtils.linkForExampleId('dataSourceFields')}"
        ],
        valueType:"DataSource or ID",
        name:"dataSource",
        definingClass:"class:DynamicForm"
    },
    "method:Canvas.getImage":{
        ref:"method:Canvas.getImage",
        deprecated:null,
        name:"getImage",
        flags:"A",
        description:" Retrieve a native image element by name.\n <P>\n The image element must have been created from HTML generated by calling\n ${isc.DocUtils.linkForRef('method:Canvas.imgHTML')} on this particular Canvas.\n\n",
        groups:[
            "images"
        ],
        definingClass:"class:Canvas",
        returns:{
            description:"DOM image element if found, else null",
            type:"DOMElement"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"identifier",
                description:"name of the image to get, as originally passed to                              <code>imgHTML()</code>",
                optional:false,
                type:"string"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:ComboBoxItem.separateValuesList":{
        ref:"attr:ComboBoxItem.separateValuesList",
        defaultValue:"null",
        valueType:"AutoChild ListGrid",
        deprecated:null,
        name:"separateValuesList",
        flags:"IR",
        description:"AutoChild used to show ${isc.DocUtils.linkForRef('attr:ComboBoxItem.specialValues')}.",
        definingClass:"class:ComboBoxItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:DataSourceField.joinType":{
        serverDS:"only",
        defaultValue:"null",
        deprecated:null,
        flags:"IR",
        description:"This property is only applicable to fields of SQL DataSources that also specify a \n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} property; it is ignored for all other fields.  Indicates the \n type of join to make between the tables underlying this DataSource and the other DataSource\n referred to in the <code>foreignKey</code> property, when resolving ${isc.DocUtils.linkForRef('attr:DataSourceField.includeFrom','includeFrom')} \n fields.  The default value of null is the same as specifying \"inner\".\n <P>\n Note, outer joins are allowed for all supported database products only if you are using \n ${isc.DocUtils.linkForRef('attr:DataSource.useAnsiJoins','ANSI-style joins')}, which is not the case by default.  If you\n are using the older strategy of additional join expressions in the WHERE clause, outer \n joins are only supported for database products that provide a proprietary native syntax for \n expressing outer joins.  Those products are:<ul>\n <li>Oracle</li>\n <li>Versions of Microsoft SQL Server earlier than 2012, and running in compatibility mode 80</li>\n </ul>",
        groups:[
            "dataSourceRelations"
        ],
        type:"attr",
        seeAlso:[
        ],
        ref:"attr:DataSourceField.joinType",
        valueType:"JoinType",
        name:"joinType",
        definingClass:"class:DataSourceField"
    },
    "method:ListGrid.getCellStartRow":{
        ref:"method:ListGrid.getCellStartRow",
        deprecated:null,
        name:"getCellStartRow",
        flags:"",
        description:" When using ${isc.DocUtils.linkForRef('method:ListGrid.getRowSpan','row spanning')}, returns the row number where a row-spanning cell\n starts.\n <P>\n For example, if row 2 col 0 spans 3 cells, <code>getCellStartRow()</code> for row 2 col 0,\n row 3 col 0, row 4 col 0 will all return 2, because that's the row when spanning starts.\n\n",
        definingClass:"class:ListGrid",
        returns:{
            description:"row number where spanning starts",
            type:"int"
        },
        type:"method",
        params:[
            {
                defaultValue:null,
                name:"rowNum",
                description:"row number of cell for which the start row should be returned",
                optional:false,
                type:"int"
            },
            {
                defaultValue:null,
                name:"colNum",
                description:"column number of cell for which the start row should be returned",
                optional:false,
                type:"int"
            }
        ],
        seeAlso:[
        ]
    },
    "attr:RelativeDateItem.shouldSaveValue":{
        ref:"attr:RelativeDateItem.shouldSaveValue",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"shouldSaveValue",
        flags:"IR",
        description:"Should this item's value be saved in the form's values and hence returned from\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')}?\n <p>\n <code>shouldSaveValue:false</code> is used to mark formItems which do not correspond to\n the underlying data model and should not save a value into the form's\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','values')}.  Example includes visual separators, password re-type fields,\n or checkboxes used to show/hide other form items.\n <p>\n A <code>shouldSaveValue:false</code> item should be given a value either via\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue')} or by calling\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValue','form.setValue(item, value)')} or \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','formItem.setValue(value)')}.  Providing a value via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','form.values')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','form.setValues()')} \n will automatically switch the item to <code>shouldSaveValue:true</code>.\n <P>\n Note that <ul>\n <li>if an item is shouldSaveValue true, but has no name, a warning is logged, and \n     shouldSaveValue will be set to false.\n </li></ul>",
        groups:[
            "formValues"
        ],
        definingClass:"class:RelativeDateItem",
        type:"attr",
        seeAlso:[
        ]
    },
    "attr:TreeGrid.canReparentNodes":{
        ref:"attr:TreeGrid.canReparentNodes",
        defaultValue:"null",
        valueType:"boolean",
        deprecated:null,
        name:"canReparentNodes",
        flags:"IRW",
        description:"If set this property allows the user to reparent nodes by dragging them from their\n current folder to a new folder.<br>\n <b>Backcompat:</b> For backwards compatibility with versions prior to SmartClient 1.5,\n if this property is unset, but <code>this.canAcceptDroppedRecords</code> is true, we\n allow nodes to be dragged to different folders.",
        groups:[
            "dragdrop"
        ],
        definingClass:"class:TreeGrid",
        type:"attr",
        seeAlso:[
            {
                ref:"attr:TreeNode.canDrag",
                description:null
            },
            {
                ref:"attr:TreeNode.canAcceptDrop",
                description:null
            }
        ]
    },
    "attr:DateRangeItem.shouldSaveValue":{
        ref:"attr:DateRangeItem.shouldSaveValue",
        defaultValue:"true",
        valueType:"Boolean",
        deprecated:null,
        name:"shouldSaveValue",
        flags:"IR",
        description:"Allow dateRangeItems' values to show up in the form's values array, or if \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} is called, for the criterion to be included\n in the returned 