/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.Token;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{55, 121};
    static final short[] startStatementTokens = new short[]{55, 121, 4, 88};
    static final short[] startStatementTokensSchema = new short[]{55, 121};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(String string) {
        super.reset(string);
    }

    StatementSchema compileCreate() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        this.read();
        switch (this.token.tokenType) {
            case 120: {
                this.read();
                this.readThis(523);
                this.readIfThis(608);
                this.readThis(278);
                bl = true;
                n = 3;
                break;
            }
            case 632: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 3;
                break;
            }
            case 523: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 3;
                break;
            }
            case 608: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 4;
                break;
            }
            case 570: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 5;
                break;
            }
            case 633: {
                this.read();
                this.readThis(278);
                bl = true;
                n = 7;
                break;
            }
            case 278: {
                this.read();
                bl = true;
                n = this.database.schemaManager.getDefaultTableType();
                break;
            }
            default: {
                n = 4;
            }
        }
        if (bl) {
            return this.compileCreateTable(n);
        }
        if (this.database.sqlSyntaxOra && this.token.tokenType == 197) {
            this.read();
            this.readThis(729);
            switch (this.token.tokenType) {
                case 117: 
                case 215: 
                case 291: 
                case 535: 
                case 545: {
                    break;
                }
                default: {
                    throw this.unexpectedToken("OR");
                }
            }
            bl2 = true;
        }
        switch (this.token.tokenType) {
            case 558: {
                return this.compileCreateAlias();
            }
            case 505: {
                return this.compileCreateSequence();
            }
            case 497: {
                return this.compileCreateSchema();
            }
            case 291: {
                return this.compileCreateTrigger(bl2);
            }
            case 305: {
                return this.compileCreateUser();
            }
            case 490: {
                return this.compileCreateRole();
            }
            case 545: {
                return this.compileCreateView(false, bl2);
            }
            case 393: {
                return this.compileCreateDomain();
            }
            case 535: {
                return this.compileCreateType(bl2);
            }
            case 35: {
                return this.compileCreateCharacterSet();
            }
            case 358: {
                return this.compileCreateCollation();
            }
            case 299: {
                this.read();
                this.checkIsThis(598);
                return this.compileCreateIndex(true);
            }
            case 598: {
                return this.compileCreateIndex(false);
            }
            case 559: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
            case 117: 
            case 215: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 598: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                if (this.token.tokenType == 624) {
                    this.read();
                    this.readThis(285);
                    return this.compileRenameObject(hsqlName, 20);
                }
                this.readThis(10);
                Index index = (Index)this.database.schemaManager.getSchemaObject(hsqlName);
                if (index == null) {
                    throw Error.error(5501);
                }
                Table table = (Table)this.database.schemaManager.getSchemaObject(index.getName().parent);
                int[] nArray = this.readColumnList(table, true);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{table, nArray, index.getName()};
                HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
                return new StatementSchema(string, 1121, objectArray, null, hsqlNameArray);
            }
            case 497: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                this.readThis(624);
                this.readThis(285);
                return this.compileRenameObject(hsqlName, 2);
            }
            case 348: {
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.checkValidCatalogName(string);
                this.read();
                this.readThis(624);
                this.readThis(285);
                return this.compileRenameObject(this.database.getCatalogName(), 1);
            }
            case 505: {
                return this.compileAlterSequence();
            }
            case 278: {
                return this.compileAlterTable();
            }
            case 305: {
                return this.compileAlterUser();
            }
            case 393: {
                return this.compileAlterDomain();
            }
            case 545: {
                return this.compileCreateView(true, false);
            }
            case 508: {
                return this.compileAlterSession();
            }
            case 259: {
                return this.compileAlterSpecificRoutine();
            }
            case 491: {
                return this.compileAlterRoutine();
            }
            case 48: {
                this.read();
                Constraint constraint = (Constraint)this.readSchemaObjectName(5);
                this.readThis(624);
                this.readThis(285);
                return this.compileRenameObject(constraint.getName(), 5);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterRoutine() {
        this.readThis(491);
        RoutineSchema routineSchema = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(624);
        this.readThis(285);
        return this.compileRenameObject(routineSchema.getName(), routineSchema.getName().type);
    }

    Statement compileDrop() {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        SchemaObject schemaObject;
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.read();
        int n3 = this.token.tokenType;
        switch (n3) {
            case 598: {
                this.read();
                n2 = 1129;
                n = 20;
                bl3 = true;
                break;
            }
            case 339: {
                this.read();
                n2 = 24;
                n = 6;
                bl = true;
                break;
            }
            case 259: {
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 30;
                n = 24;
                bl = true;
                bl3 = true;
                break;
            }
            case 215: {
                this.read();
                n2 = 30;
                n = 17;
                bl = true;
                bl3 = true;
                break;
            }
            case 117: {
                this.read();
                n2 = 30;
                n = 16;
                bl = true;
                bl3 = true;
                break;
            }
            case 497: {
                this.read();
                n2 = 31;
                n = 2;
                bl = true;
                bl3 = true;
                break;
            }
            case 505: {
                this.read();
                n2 = 135;
                n = 7;
                bl = true;
                bl3 = true;
                break;
            }
            case 291: {
                this.read();
                n2 = 34;
                n = 8;
                bl = false;
                bl3 = true;
                break;
            }
            case 305: {
                this.read();
                n2 = 1131;
                n = 11;
                bl = true;
                break;
            }
            case 490: {
                this.read();
                n2 = 29;
                n = 11;
                bl = true;
                break;
            }
            case 393: {
                this.read();
                n2 = 27;
                n = 13;
                bl = true;
                bl3 = true;
                break;
            }
            case 535: {
                this.read();
                n2 = 35;
                n = 12;
                bl = true;
                bl3 = true;
                break;
            }
            case 35: {
                this.read();
                this.readThis(254);
                n2 = 25;
                n = 14;
                bl = false;
                bl3 = true;
                break;
            }
            case 358: {
                this.read();
                n2 = 26;
                n = 15;
                bl = false;
                bl3 = true;
                break;
            }
            case 545: {
                this.read();
                n2 = 36;
                n = 4;
                bl = true;
                bl3 = true;
                break;
            }
            case 278: {
                this.read();
                n2 = 32;
                n = 3;
                bl = true;
                bl3 = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (bl3 && this.token.tokenType == 412) {
            int n4 = this.getPosition();
            this.read();
            if (this.token.tokenType == 101) {
                this.read();
                bl4 = true;
            } else {
                this.rewind(n4);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName hsqlName = null;
        switch (n3) {
            case 305: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getUserManager().get(this.token.tokenString);
                this.read();
                break;
            }
            case 490: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getGranteeManager().getRole(this.token.tokenString);
                this.read();
                break;
            }
            case 497: {
                hsqlName = this.readNewSchemaName();
                schemaObject = this.database.schemaManager.findSchema(hsqlName.name);
                break;
            }
            case 278: {
                boolean bl5;
                boolean bl6 = bl5 = this.token.namePrePrefix == null && ("MODULE".equals(this.token.namePrefix) || "SESSION".equals(this.token.namePrefix));
                if (bl5) {
                    hsqlName = this.readNewSchemaObjectName(n, false);
                    if (!bl4 && this.token.tokenType == 412) {
                        this.read();
                        this.readThis(101);
                        bl4 = true;
                    }
                    Object[] objectArray = new Object[]{hsqlName, bl4};
                    return new StatementSession(32, objectArray);
                }
            }
            default: {
                hsqlName = this.readNewSchemaObjectName(n, false);
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                schemaObject = this.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
            }
        }
        if (!bl4 && bl3 && this.token.tokenType == 412) {
            this.read();
            this.readThis(101);
            bl4 = true;
        }
        if (bl) {
            if (this.token.tokenType == 347) {
                bl2 = true;
                this.read();
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(373);
                }
            } else if (this.token.tokenType == 485) {
                this.read();
            }
        }
        if (schemaObject == null) {
            hsqlNameArray = null;
        } else {
            hsqlName = schemaObject.getName();
            hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(hsqlName);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, new Integer(n), bl2, bl4};
        StatementSchema statementSchema = new StatementSchema(string, n2, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    Statement compileAlterTable() {
        this.read();
        String string = this.token.tokenString;
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Table table = this.database.schemaManager.getUserTable(this.session, string, hsqlName.name);
        this.read();
        switch (this.token.tokenType) {
            case 624: {
                this.read();
                if (this.database.sqlSyntaxPgs && this.token.tokenType == 43) {
                    this.read();
                    this.checkIsIdentifier();
                    int n = table.getColumnIndex(this.token.tokenString);
                    ColumnSchema columnSchema = table.getColumn(n);
                    this.read();
                    this.readThis(285);
                    return this.compileAlterColumnRename(table, columnSchema);
                }
                this.readThis(285);
                return this.compileRenameObject(table.getName(), 3);
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName hsqlName2 = null;
                if (this.token.tokenType == 48) {
                    this.read();
                    hsqlName2 = this.readNewDependentSchemaObjectName(table.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 113: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddForeignKeyConstraint(table, hsqlName2);
                    }
                    case 299: {
                        this.read();
                        if (this.database.sqlSyntaxMys && !this.readIfThis(598)) {
                            this.readIfThis(427);
                        }
                        return this.compileAlterTableAddUniqueConstraint(table, hsqlName2);
                    }
                    case 37: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(table, hsqlName2);
                    }
                    case 214: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddPrimaryKey(table, hsqlName2);
                    }
                    case 43: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(table);
                    }
                }
                if (hsqlName2 != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(table);
            }
            case 88: {
                this.read();
                switch (this.token.tokenType) {
                    case 214: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableDropPrimaryKey(table);
                    }
                    case 48: {
                        this.read();
                        return this.compileAlterTableDropConstraint(table);
                    }
                    case 43: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String string2 = this.token.tokenString;
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 485) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    bl = true;
                }
                return this.compileAlterTableDropColumn(table, string2, bl);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 43) {
                    this.read();
                }
                int n = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n);
                this.read();
                return this.compileAlterColumn(table, columnSchema, n);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean bl = false;
        SchemaObject schemaObject = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            bl = true;
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{schemaObject.getName(), ValuePool.getInt(5), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        HsqlNameManager.HsqlName hsqlName = ((Constraint)schemaObject).getMainTableName();
        if (hsqlName != null && hsqlName != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName, hsqlNameArray.length, 1);
        }
        StatementSchema statementSchema = new StatementSchema(string, 1130, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean bl = false;
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            bl = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String string = this.getLastPart();
        Constraint constraint = table.getPrimaryConstraint();
        Object[] objectArray = new Object[]{constraint.getName(), ValuePool.getInt(5), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        StatementSchema statementSchema = new StatementSchema(string, 1130, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        Object object;
        StatementSchema statementSchema;
        int n = super.getPosition();
        try {
            this.readThis(77);
            this.readThis(157);
            this.readThis(523);
            this.readThis(278);
        }
        catch (HsqlException hsqlException) {
            this.lastError = hsqlException;
            this.rewind(n);
            return null;
        }
        if (this.token.namePrePrefix != null || this.token.namePrefix != null && !"MODULE".equals(this.token.namePrefix) && !"SESSION".equals(this.token.namePrefix)) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.schema = SqlInvariants.MODULE_HSQLNAME;
        Table table = new Table(this.database, hsqlName, 3);
        if (this.token.tokenType == 10) {
            statementSchema = this.compileCreateTableAsSubqueryDefinition(table);
        } else {
            statementSchema = this.compileCreateTableBody(table, false);
            object = (HsqlArrayList)statementSchema.arguments[1];
            for (int i = 0; i < ((HsqlArrayList)object).size(); ++i) {
                Constraint constraint = (Constraint)((HsqlArrayList)object).get(i);
                if (constraint.getConstraintType() != 0) continue;
                throw this.unexpectedToken("FOREIGN");
            }
        }
        object = new StatementSession(1119, statementSchema.arguments);
        return object;
    }

    StatementSchema compileCreateView(boolean bl, boolean bl2) {
        QueryExpression queryExpression;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(4, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        if (this.token.tokenType == 816) {
            try {
                hsqlNameArray = this.readColumnNames(hsqlName);
            }
            catch (HsqlException hsqlException) {
                if (this.session.isProcessingScript() && this.database.getProperties().isVersion18()) {
                    while (this.token.tokenType != 10) {
                        this.read();
                    }
                }
                throw hsqlException;
            }
        }
        this.readThis(10);
        this.startRecording();
        int n = this.getPosition();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        Token[] tokenArray = this.getRecordedStatement();
        int n2 = 0;
        if (this.token.tokenType == 319) {
            this.read();
            n2 = 2;
            if (this.readIfThis(157)) {
                n2 = 1;
            } else {
                this.readIfThis(28);
            }
            this.readThis(37);
            this.readThis(455);
        }
        View view = new View(this.database, hsqlName, hsqlNameArray, n2);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        view.setStatement(Token.getSQL(tokenArray));
        StatementQuery statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{view};
        int n3 = bl ? 1122 : 84;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, n3, objectArray, statementQuery.readTableNames, hsqlNameArray2);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        boolean bl = false;
        if (this.token.tokenType == 412) {
            int n = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThis(101);
                bl = true;
            } else {
                this.rewind(n);
            }
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(7, false);
        NumberSequence numberSequence = new NumberSequence(hsqlName, Type.SQL_INTEGER);
        this.readSequenceOptions(numberSequence, true, false, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 133, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateDomain() {
        Object[] objectArray;
        int n;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(13, false);
        this.readIfThis(10);
        Type type = this.readTypeDefinition(true, false).duplicate();
        Expression expression = null;
        if (this.readIfThis(78)) {
            expression = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        userTypeModifier.setDefaultClause(expression);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            n = 0;
            switch (this.token.tokenType) {
                case 37: 
                case 48: {
                    this.readConstraint(type, hsqlArrayList);
                    break;
                }
                default: {
                    n = 1;
                }
            }
        } while (n == 0);
        this.compileContext.currentDomain = null;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = (Object[])hsqlArrayList.get(n);
            objectArray.prepareCheckConstraint(this.session, null);
            userTypeModifier.addConstraint((Constraint)objectArray);
        }
        String string = this.getLastPart();
        objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 23, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateType(boolean bl) {
        UserTypeModifier userTypeModifier;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(12, false);
        this.readThis(10);
        Type type = this.readTypeDefinition(true, false).duplicate();
        this.readIfThis(400);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(hsqlName, 12, type);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 83, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(254);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(14, false);
        this.readIfThis(10);
        this.readThis(119);
        String string = this.token.namePrefix;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, string);
        this.read();
        if (this.token.tokenType == 358) {
            this.read();
            this.readThis(115);
            this.readThis(78);
        }
        Charset charset2 = new Charset(hsqlName);
        charset2.base = charset.getName();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{charset2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 8, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCollation() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(15, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(112);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(14, false);
        this.readThis(115);
        HsqlNameManager.HsqlName hsqlName3 = this.readNewSchemaObjectName(15, false);
        Boolean bl = null;
        if (this.readIfThis(180)) {
            this.readThis(463);
            bl = Boolean.FALSE;
        } else if (this.readIfThis(463)) {
            this.readThis(514);
            bl = Boolean.TRUE;
        }
        String string = hsqlName2.schema == null ? null : hsqlName2.schema.name;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, hsqlName2.name, string);
        if (charset == null) {
            throw Error.error(5501, hsqlName2.getSchemaQualifiedStatementName());
        }
        string = hsqlName3.schema == null ? null : hsqlName3.schema.name;
        Collation collation = this.database.schemaManager.getCollation(this.session, hsqlName3.name, string);
        Collation collation2 = new Collation(hsqlName, collation, charset, bl);
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{collation2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 10, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateAlias() {
        Object[] objectArray;
        Object object;
        String string;
        HsqlNameManager.HsqlName hsqlName = null;
        Routine[] routineArray = null;
        String string2 = null;
        if (!this.session.isProcessingScript()) {
            throw super.unsupportedFeature();
        }
        this.read();
        try {
            string = this.token.tokenString;
            this.read();
            this.readThis(112);
            string2 = this.token.tokenString;
            this.read();
        }
        catch (HsqlException hsqlException) {
            string = null;
        }
        if (string != null) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            hsqlName = this.database.nameManager.newHsqlName((HsqlNameManager.HsqlName)object, string, 16);
            objectArray = Routine.getMethods(string2);
            routineArray = Routine.newRoutines(this.session, (Method[])objectArray);
        }
        object = this.getLastPart();
        objectArray = new Object[]{hsqlName, routineArray};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema((String)object, 1124, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateIndex(boolean bl) {
        String[] stringArray = null;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        while (this.token.tokenType != 194) {
            this.checkIsIdentifier();
            hsqlArrayList.add(this.token.tokenString);
            this.read();
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        this.readThis(194);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName hsqlName2 = table.getSchemaName();
        hsqlName.setSchemaIfNull(hsqlName2);
        hsqlName.parent = table.getName();
        if (hsqlName.schema != hsqlName2) {
            throw Error.error(5505);
        }
        hsqlName.schema = table.getSchemaName();
        int[] nArray = this.readColumnList(table, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, hsqlName, bl, stringArray};
        return new StatementSchema(string, 1125, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean bl;
        Grantee grantee;
        HsqlNameManager.HsqlName hsqlName = null;
        String string = null;
        HsqlNameManager.HsqlName hsqlName2 = null;
        this.read();
        if (this.token.tokenType != 15) {
            hsqlName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 15) {
            this.read();
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            if (hsqlName == null) {
                grantee = this.database.getGranteeManager().get(string);
                if (grantee == null) {
                    throw Error.error(4001, string);
                }
                hsqlName = this.database.nameManager.newHsqlName(grantee.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(string)) {
            throw Error.error(4002, string);
        }
        Grantee grantee2 = grantee = string == null ? this.session.getGrantee() : this.database.getGranteeManager().get(string);
        if (grantee == null) {
            throw Error.error(4001, string);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (grantee instanceof User && ((User)grantee).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (!(!this.database.schemaManager.schemaExists(hsqlName.name) || this.session.isProcessingScript() && "PUBLIC".equals(hsqlName.name))) {
            throw Error.error(5504, hsqlName.name);
        }
        if (hsqlName.name.equals("SYSTEM_LOBS")) {
            hsqlName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            grantee = hsqlName.owner;
        }
        if (this.readIfThis(78)) {
            this.readThis(35);
            this.readThis(254);
            hsqlName2 = this.readNewSchemaObjectName(14, false);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, grantee};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string2, 64, objectArray, null, hsqlNameArray);
        statementSchema.setSchemaHsqlName(hsqlName);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        hsqlArrayList.add(statementSchema);
        this.getCompiledStatementBody(hsqlArrayList);
        StatementSchema[] statementSchemaArray = new StatementSchema[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementSchemaArray);
        do {
            bl = false;
            for (int i = 0; i < statementSchemaArray.length - 1; ++i) {
                if (statementSchemaArray[i].order <= statementSchemaArray[i + 1].order) continue;
                StatementSchema statementSchema2 = statementSchemaArray[i + 1];
                statementSchemaArray[i + 1] = statementSchemaArray[i];
                statementSchemaArray[i] = statementSchema2;
                bl = true;
            }
        } while (bl);
        return new StatementSchemaDefinition(statementSchemaArray);
    }

    void getCompiledStatementBody(HsqlList hsqlList) {
        boolean bl = false;
        while (!bl) {
            StatementSchema statementSchema = null;
            int n = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 55: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 299: 
                        case 305: 
                        case 497: {
                            throw this.unexpectedToken();
                        }
                        case 598: {
                            int n2 = 1125;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 505: {
                            statementSchema = this.compileCreateSequence();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 490: {
                            statementSchema = this.compileCreateRole();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 393: {
                            int n2 = 23;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 535: {
                            statementSchema = this.compileCreateType(false);
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 35: {
                            statementSchema = this.compileCreateCharacterSet();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 339: {
                            throw this.unexpectedToken();
                        }
                        case 120: 
                        case 278: 
                        case 523: 
                        case 570: 
                        case 608: 
                        case 632: 
                        case 633: {
                            int n2 = 77;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 291: {
                            int n2 = 80;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 545: {
                            int n2 = 84;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 117: {
                            int n2 = 14;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 215: {
                            int n2 = 14;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 121: {
                    statementSchema = this.compileGrantOrRevoke();
                    statementSchema.sql = this.getLastPart(n);
                    break;
                }
                case 821: {
                    this.read();
                    bl = true;
                    break;
                }
                case 872: {
                    bl = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (statementSchema == null) continue;
            statementSchema.isSchemaDefinition = true;
            hsqlList.add(statementSchema);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 61, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateUser() {
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        Grantee grantee = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        this.readThis(616);
        if (this.readIfThis(586)) {
            bl2 = Boolean.TRUE;
        }
        String string = this.readPassword();
        if (this.token.tokenType == 335) {
            this.read();
            bl = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, string, grantee, bl, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 1126, objectArray, null, hsqlNameArray);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedIdentifier();
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl, 11);
        this.read();
        return hsqlName;
    }

    String readPassword() {
        String string = this.token.tokenString;
        if (this.isUndelimitedSimpleName() || this.isDelimitedSimpleName()) {
            this.read();
        } else {
            this.readQuotedString();
        }
        return string;
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        String string = this.getLastPart();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName);
                break;
            }
            default: {
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName.schema);
            }
        }
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] nArray = this.readColumnList(table, false);
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("IDX", hsqlName.name, table.getSchemaName(), table.getName(), 20);
        Index index = table.createIndexStructure(hsqlName2, nArray, null, null, true, true, false);
        Constraint constraint = new Constraint(hsqlName, table, index, 2);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = this.readFKReferences(table, hsqlName, orderedHashSet);
        HsqlNameManager.HsqlName hsqlName2 = constraint.getMainTableName();
        constraint.core.mainTable = this.database.schemaManager.getUserTable(this.session, hsqlName2.name, hsqlName2.schema.name);
        constraint.setColumnsIndexes(table);
        if (constraint.core.mainCols.length != constraint.core.refCols.length) {
            throw Error.error(5593);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        if (hsqlName2 != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName2, hsqlNameArray.length, 1);
        }
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint constraint = new Constraint(hsqlName, null, 3);
        this.readCheckConstraintCondition(constraint);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int n = table.getColumnCount();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            n = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1133, table, columnSchema, new Integer(n), hsqlArrayList};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableDropColumn(Table table, String string, boolean bl) {
        int n = table.getColumnIndex(string);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{table.getColumn(n).getName(), ValuePool.getInt(9), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string2, 1128, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterColumn(Table table, ColumnSchema columnSchema, int n) {
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int n2 = this.getPosition();
        switch (this.token.tokenType) {
            case 624: {
                this.read();
                this.readThis(285);
                return this.compileAlterColumnRename(table, columnSchema);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1141, table, columnSchema, n};
                    return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1142, table, columnSchema, n};
                    return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(535);
                        return this.compileAlterColumnDataType(table, columnSchema);
                    }
                    case 78: {
                        this.read();
                        Type type = columnSchema.getDataType();
                        Expression expression = this.readDefaultClause(type);
                        String string = this.getLastPart();
                        Object[] objectArray = new Object[]{1140, table, columnSchema, n, expression};
                        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        return this.compileAlterColumnSetNullability(table, columnSchema, false);
                    }
                    case 186: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, columnSchema, true);
                    }
                    case 407: {
                        return this.compileAlterColumnAddSequence(table, columnSchema, n);
                    }
                }
                this.rewind(n2);
                this.read();
                break;
            }
            case 407: {
                return this.compileAlterColumnAddSequence(table, columnSchema, n);
            }
        }
        if (this.token.tokenType == 254 || this.token.tokenType == 484) {
            if (!columnSchema.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, columnSchema, n);
        }
        return this.compileAlterColumnDataTypeIdentity(table, columnSchema);
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence numberSequence = columnSchema.getIdentitySequence();
        Type type = columnSchema.getDataType();
        if (this.token.tokenType == 128) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (numberSequence == null) {
                numberSequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(true, true);
            switch (this.token.tokenType) {
                case 128: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (numberSequence != null) break;
                    numberSequence = new NumberSequence(null, type);
                    break;
                }
                case 407: {
                    numberSequence = this.readSequence(columnSchema);
                    break;
                }
                default: {
                    numberSequence = null;
                }
            }
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1143, table, columnSchema, type, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(true, true);
        if (columnSchema.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1136, table, columnSchema, type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema columnSchema, boolean bl) {
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1139, table, columnSchema, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, hsqlName.name, true);
        this.read();
        if (this.token.tokenType == 624) {
            this.read();
            this.readThis(285);
            return this.compileRenameObject(numberSequence.getName(), 7);
        }
        this.checkSchemaUpdateAuthorisation(this.session, numberSequence.getName().schema);
        NumberSequence numberSequence2 = numberSequence.duplicate();
        this.readSequenceOptions(numberSequence2, false, true, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, numberSequence2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 134, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema columnSchema, int n) {
        if (!columnSchema.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (columnSchema.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence numberSequence = this.readSequence(columnSchema);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1137, table, columnSchema, n, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    NumberSequence readSequence(ColumnSchema columnSchema) {
        this.readThis(407);
        NumberSequence numberSequence = new NumberSequence(null, columnSchema.getDataType());
        boolean bl = false;
        if (this.token.tokenType == 24) {
            this.read();
            this.readThis(78);
        } else {
            this.readThis(337);
            bl = true;
        }
        this.readThis(10);
        this.readThis(128);
        numberSequence.setAlways(bl);
        if (this.token.tokenType == 816) {
            this.read();
            this.readSequenceOptions(numberSequence, false, false, false);
            this.readThis(802);
        }
        numberSequence.checkValues();
        return numberSequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema columnSchema, int n) {
        boolean bl;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        NumberSequence numberSequence = columnSchema.getIdentitySequence().duplicate();
        do {
            bl = false;
            block0 : switch (this.token.tokenType) {
                case 484: {
                    long l;
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(319)) {
                        l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.reset();
                    break;
                }
                case 254: {
                    long l;
                    this.read();
                    switch (this.token.tokenType) {
                        case 417: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(24);
                            l = this.readBigint();
                            numberSequence.setIncrement(l);
                            break block0;
                        }
                        case 180: {
                            this.read();
                            if (this.token.tokenType == 438) {
                                numberSequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 442) {
                                numberSequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 71) {
                                numberSequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 438: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMaxValueNoCheck(l);
                            break block0;
                        }
                        case 442: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMinValueNoCheck(l);
                            break block0;
                        }
                        case 71: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            numberSequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        numberSequence.checkValues();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1137, table, columnSchema, n, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 4, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema columnSchema) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(hsqlName.name) > -1) {
            throw Error.error(5504, hsqlName.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), columnSchema.getName());
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{columnSchema.getName(), hsqlName};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterSchemaRename() {
        HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
        this.checkSchemaUpdateAuthorisation(hsqlName);
        this.readThis(624);
        this.readThis(285);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaName();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        User user = this.database.getUserManager().get(hsqlName.name);
        if (hsqlName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        if (hsqlName.name.equals("_SYSTEM")) {
            throw Error.error(5503);
        }
        this.readThis(254);
        switch (this.token.tokenType) {
            case 157: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{user, bl};
                return new StatementCommand(1091, objectArray);
            }
            case 616: {
                this.read();
                boolean bl = false;
                if (this.readIfThis(586)) {
                    bl = Boolean.TRUE;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{user, string, bl};
                StatementCommand statementCommand = new StatementCommand(1093, objectArray);
                String string2 = user.getSetUserPasswordDigestSQL(string, bl);
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 599: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName hsqlName2 = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{user, hsqlName2};
                return new StatementCommand(1092, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Type type = this.database.schemaManager.getDomain(this.token.tokenString, hsqlName.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 624: {
                this.read();
                this.readThis(285);
                return this.compileRenameObject(type.getName(), 13);
            }
            case 88: {
                this.read();
                if (this.token.tokenType == 78) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1132, type};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 48) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.schemaManager.getSchemaObjectName(type.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1130, type, hsqlName2};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 254: {
                this.read();
                this.readThis(78);
                Expression expression = this.readDefaultClause(type);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1135, type, expression};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 48 && this.token.tokenType != 37) break;
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                this.compileContext.currentDomain = type;
                this.readConstraint(type, hsqlArrayList);
                this.compileContext.currentDomain = null;
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1134, type, constraint};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 79: 
            case 100: 
            case 135: 
            case 222: 
            case 251: 
            case 303: 
            case 540: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean bl = this.token.tokenType == 121;
        this.read();
        if (this.isGrantToken() || !bl && (this.token.tokenType == 121 || this.token.tokenType == 411)) {
            return this.compileRightGrantOrRevoke(bl);
        }
        return this.compileRoleGrantOrRevoke(bl);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean bl) {
        Object[] objectArray;
        int n;
        int n2;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        Grantee grantee = null;
        Right right = null;
        HsqlNameManager.HsqlName hsqlName = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl) {
            if (this.token.tokenType == 121) {
                this.read();
                this.readThis(455);
                this.readThis(112);
                bl6 = true;
            } else if (this.token.tokenType == 411) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 478) {
                this.read();
            }
            right = Right.fullRights;
            bl5 = true;
        } else {
            right = new Right();
            n2 = 1;
            block21: while (n2 != 0) {
                this.checkIsUndelimitedIdentifer();
                int n3 = GranteeManager.getCheckSingleRight(this.token.tokenString);
                n = this.token.tokenType;
                objectArray = null;
                this.read();
                switch (n) {
                    case 135: 
                    case 222: 
                    case 251: 
                    case 303: {
                        if (this.token.tokenType == 816) {
                            objectArray = this.readColumnNames(false);
                        }
                    }
                    case 291: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(n3, (OrderedHashSet)objectArray);
                        bl2 = true;
                        break;
                    }
                    case 79: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(n3, null);
                        bl2 = true;
                        break;
                    }
                    case 540: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl3 = true;
                        n2 = 0;
                        continue block21;
                    }
                    case 100: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl4 = true;
                        n2 = 0;
                        continue block21;
                    }
                }
                if (this.token.tokenType != 804) break;
                this.read();
            }
        }
        this.readThis(194);
        n2 = 0;
        switch (this.token.tokenType) {
            case 574: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                n2 = 16;
                break;
            }
            case 259: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 117: 
                    case 215: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 24;
                break;
            }
            case 117: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 16;
                break;
            }
            case 215: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 17;
                break;
            }
            case 491: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 18;
                break;
            }
            case 535: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 12;
                break;
            }
            case 393: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 13;
                break;
            }
            case 505: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 7;
                break;
            }
            case 35: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(254);
                n2 = 14;
                break;
            }
            default: {
                if (!bl2 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(278);
                n2 = 3;
            }
        }
        hsqlName = this.readNewSchemaObjectName(n2, false);
        if (bl) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 804) break;
            this.read();
        }
        if (bl) {
            if (this.token.tokenType == 319) {
                this.read();
                this.readThis(121);
                this.readThis(455);
                bl6 = true;
            }
            if (this.token.tokenType == 410) {
                this.read();
                this.readThis(24);
                if (this.token.tokenType == 69) {
                    this.read();
                } else {
                    this.readThis(64);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantee = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 347) {
            bl7 = true;
            this.read();
        } else {
            this.readThis(485);
        }
        String string = this.getLastPart();
        n = bl ? 48 : 59;
        objectArray = new Object[]{orderedHashSet, hsqlName, right, grantee, bl7, bl6};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        StatementSchema statementSchema = new StatementSchema(string, n, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean bl) {
        Grantee grantee = this.session.getGrantee();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        boolean bl2 = false;
        if (!bl && this.token.tokenType == 335) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 804) break;
            this.read();
        }
        if (bl) {
            this.readThis(285);
        } else {
            this.readThis(115);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet2.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 804) break;
            this.read();
        }
        if (bl && this.token.tokenType == 319) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 410) {
            this.read();
            this.readThis(24);
            if (this.token.tokenType == 69) {
                this.read();
            } else {
                this.readThis(64);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantee = this.session.getRole();
            }
        }
        if (!bl) {
            if (this.token.tokenType == 347) {
                bl2 = true;
                this.read();
            } else {
                this.readThis(485);
            }
        }
        String string = this.getLastPart();
        int n = bl ? 49 : 129;
        Object[] objectArray = new Object[]{orderedHashSet2, orderedHashSet, grantee, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        StatementSchema statementSchema = new StatementSchema(string, n, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName hsqlName) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (hsqlName == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, hsqlName.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        HsqlNameManager.HsqlName hsqlName;
        this.readThis(576);
        this.readThis(194);
        switch (this.token.tokenType) {
            case 278: 
            case 491: {
                int n = this.token.tokenType == 491 ? 18 : 3;
                this.read();
                this.checkIsSchemaObjectName();
                hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, n);
                hsqlName.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
                this.read();
                break;
            }
            case 43: {
                this.read();
                this.checkIsSchemaObjectName();
                hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, 9);
                if (this.token.namePrefix == null) {
                    throw Error.error(5501);
                }
                hsqlName.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
                hsqlName.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 3);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(142);
        String string = this.readQuotedString();
        Object[] objectArray = new Object[]{hsqlName, string};
        return new StatementSchema(null, 1123, objectArray, null, null);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 625) {
            this.read();
            int n = this.token.tokenType;
            switch (this.token.tokenType) {
                case 2: {
                    this.read();
                    break;
                }
                case 236: {
                    this.read();
                    this.readThis(510);
                    break;
                }
                case 278: {
                    this.read();
                    this.readThis(378);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] objectArray = new Object[]{this.session.getId(), n};
            return new StatementCommand(1005, objectArray);
        }
        long l = this.readBigint();
        Session session = this.database.sessionManager.getSession(l);
        if (session == null) {
            throw Error.error(4500);
        }
        int n = this.token.tokenType;
        switch (this.token.tokenType) {
            case 39: {
                this.read();
                break;
            }
            case 233: {
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{l, n};
        return new StatementCommand(1005, objectArray);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 294) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 106) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }
}

