/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.Resource;
import org.openqa.jetty.util.URLResource;

public class JarResource
extends URLResource {
    private static Log log = LogFactory.getLog(JarResource.class);
    protected transient JarURLConnection _jarConnection;

    JarResource(URL url) {
        super(url, null);
    }

    @Override
    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    @Override
    protected boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    @Override
    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    @Override
    public File getFile() throws IOException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this._urlString.endsWith("!/")) {
            return super.getInputStream();
        }
        URL url = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        return url.openStream();
    }

    public static void extract(Resource resource, File directory, boolean deleteOnExit) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extract " + resource + " to " + directory));
        }
        JarInputStream jin = new JarInputStream(resource.getInputStream());
        JarEntry entry = null;
        while ((entry = jin.getNextJarEntry()) != null) {
            File file = new File(directory, entry.getName());
            if (entry.isDirectory()) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    IO.copy(jin, fout);
                }
                catch (Throwable throwable) {
                    IO.close(fout);
                    throw throwable;
                }
                IO.close(fout);
                if (entry.getTime() >= 0L) {
                    file.setLastModified(entry.getTime());
                }
            }
            if (!deleteOnExit) continue;
            file.deleteOnExit();
        }
    }

    public void extract(File directory, boolean deleteOnExit) throws IOException {
        JarResource.extract(this, directory, deleteOnExit);
    }
}

