/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.SeleniumServerHelper;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestRunnerSelenium;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.log.Logger;
import com.thoughtworks.selenium.Selenium;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class SgwtRunnerHelper
extends ConfiguredBase {
    private static Logger log = new Logger(TestRunnerHelper.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private static RuntimeException fatalException;

    public static void testAll(String browser, String[] scripts, ShowcaseSpecifier showcase, TestRunnerHelper.TestCallback callback) {
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        seleniumServerHelper.startSeleniumServer();
        String testRootPath = config.getTestRoot(showcase);
        List<String> testFiles = ((TestRunnerLauncher)config).getTestScripts(scripts, "Test\\.java$", testRootPath + "/com/smartgwt/qa", testRootPath + "/com/smartgwt/qa2");
        if (testFiles != null && testFiles.size() > 0) {
            SgwtRunnerHelper.processUsualTests(testFiles, browser, callback, testRootPath, showcase);
        }
        seleniumServerHelper.stopSeleniumServer();
        if (fatalException != null) {
            log.error((Object)"Test framework aborted due to exception!");
            Utils.dumpStringToFile(tmpDir + "/awstest.exception.txt", ExceptionUtils.getStackTrace((Throwable)fatalException));
            throw fatalException;
        }
    }

    protected static void processUsualTests(List testFiles, String browser, TestRunnerHelper.TestCallback callback, String testRootPath, ShowcaseSpecifier showcase) {
        if (!"localhost".equals(config.getHttpTarget())) {
            log.warn((Object)"Attempting to run SGWT Java TestRunner tests on a remote machine. This is unpredictable because the list of tests to run is generated locally, yet the files are then loaded by the remote browser.  If the two hiearchies differ, tests may not load and may time out.");
        }
        String browserURL = config.getHttpBaseURL(showcase);
        String fileRootPath = config.getFileRoot();
        String serverFile = config.getShowcaseFile(showcase);
        int port = SeleniumServerHelper.getInstance().getSeleniumPort();
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, browserURL);
        int spanLength = config.getSgwtRunnerClassSpan();
        for (int fromIndex = 0; fromIndex < testFiles.size(); fromIndex += spanLength) {
            List span = testFiles.subList(fromIndex, Math.min(fromIndex + spanLength, testFiles.size()));
            String testClasses = StringUtils.join((Object[])SgwtRunnerHelper.getTestClasses(span), (String)":");
            selenium.start();
            try {
                for (String object : span) {
                    String name = object.substring(testRootPath.length() + 1);
                    String filePath = object.substring(fileRootPath.length() + 1);
                    TestSpecifier ts = new TestSpecifier(browserURL + serverFile, name, testClasses, showcase);
                    TestCaseResults tcr = TestRunnerHelper.test(ts, browser, (Selenium)selenium, showcase, false);
                    callback.onTestResults(tcr);
                    testClasses = null;
                }
            }
            catch (RuntimeException e) {
                fatalException = e;
            }
            selenium.stop();
        }
    }

    protected static String[] getTestClasses(List testFiles) {
        ArrayList<String> classes = new ArrayList<String>();
        for (Object object : testFiles) {
            String className = (String)object;
            className = className.replaceFirst("^((.*src)?/)?", "").replaceFirst("\\.java$", "");
            classes.add(className.replaceAll("/", "."));
        }
        return classes.toArray(new String[classes.size()]);
    }
}

