/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.ILogger;
import com.isomorphic.log.Level;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.varia.NullAppender;
import org.apache.log4j.xml.DOMConfigurator;

class Log4jLogger
implements ILogger {
    private static final Map<Level, org.apache.log4j.Level> toLog4j = new HashMap<Level, org.apache.log4j.Level>(){
        {
            this.put(Logger.ALL, org.apache.log4j.Level.ALL);
            this.put(Logger.OFF, org.apache.log4j.Level.OFF);
            this.put(Logger.FATAL, org.apache.log4j.Level.FATAL);
            this.put(Logger.ERROR, org.apache.log4j.Level.ERROR);
            this.put(Logger.WARN, org.apache.log4j.Level.WARN);
            this.put(Logger.INFO, org.apache.log4j.Level.INFO);
            this.put(Logger.DEBUG, org.apache.log4j.Level.DEBUG);
        }
    };
    private static final Map<org.apache.log4j.Level, Level> fromLog4j = new HashMap<org.apache.log4j.Level, Level>(){
        {
            this.put(org.apache.log4j.Level.ALL, Logger.ALL);
            this.put(org.apache.log4j.Level.OFF, Logger.OFF);
            this.put(org.apache.log4j.Level.FATAL, Logger.FATAL);
            this.put(org.apache.log4j.Level.ERROR, Logger.ERROR);
            this.put(org.apache.log4j.Level.WARN, Logger.WARN);
            this.put(org.apache.log4j.Level.INFO, Logger.INFO);
            this.put(org.apache.log4j.Level.DEBUG, Logger.DEBUG);
        }
    };
    private static LoggerRepository repository;
    private org.apache.log4j.Logger log;

    public static LoggerRepository getLoggerRepository() {
        return repository;
    }

    public static void setLoggerRepository(Object newRepos) {
        if (!(newRepos instanceof LoggerRepository)) {
            throw new IllegalArgumentException("Expected argument of org.apache.log4j.spi.LoggerRepository type");
        }
        repository = (LoggerRepository)newRepos;
    }

    protected static void init(boolean logEnabled) throws Exception {
        if (!logEnabled) {
            repository = LogManager.getRootLogger().getLoggerRepository();
            repository.getRootLogger().setLevel(org.apache.log4j.Level.OFF);
            return;
        }
        URL configURL = Loader.getResource((String)"log4j.isc.project.config.xml");
        if (configURL == null) {
            configURL = Loader.getResource((String)"log4j.isc.config.xml");
        }
        if (configURL == null) {
            System.out.println("=== SmartClient Init: log4j.isc.config.xml not found in CLASSPATH. Assuming log4j configuration for com.isomorphic is located in some other log4j configuration file.");
            repository = LogManager.getRootLogger().getLoggerRepository();
        } else {
            System.out.println("ISC: Configuring log4j from: " + configURL);
            Hierarchy hierarchy = new Hierarchy((org.apache.log4j.Logger)new RootLogger(org.apache.log4j.Level.WARN));
            repository = hierarchy;
            new DOMConfigurator().doConfigure(configURL, repository);
        }
        org.apache.log4j.Logger rootLogger = repository.getRootLogger();
        Enumeration e = rootLogger.getAllAppenders();
        if (!e.hasMoreElements()) {
            rootLogger.addAppender((Appender)new NullAppender());
        }
    }

    public static Level getLevelForCategory(String category) {
        org.apache.log4j.Logger logger;
        if (repository != null && (logger = repository.getLogger(category)) != null) {
            return fromLog4j.get(logger.getLevel());
        }
        return null;
    }

    public static void setLevelForCategory(String category, Level level) {
        org.apache.log4j.Logger logger;
        if (repository != null && (logger = repository.getLogger(category)) != null) {
            logger.setLevel(toLog4j.get(level));
        }
    }

    public static void setLevelForCategory(String category, String level) {
        org.apache.log4j.Logger logger;
        if (repository != null && (logger = repository.getLogger(category)) != null) {
            logger.setLevel(org.apache.log4j.Level.toLevel((String)level));
        }
    }

    public static List getCurrentLoggers() {
        ArrayList<DataTypeMap> loggers = new ArrayList<DataTypeMap>();
        if (repository != null) {
            Enumeration e = repository.getCurrentLoggers();
            while (e.hasMoreElements()) {
                org.apache.log4j.Logger logger = (org.apache.log4j.Logger)e.nextElement();
                if (logger.getLevel() == null) continue;
                loggers.add(DataTools.buildMap("category", logger.getName(), "threshold", logger.getLevel().toString()));
            }
        }
        return loggers;
    }

    protected Log4jLogger(String subsystem) {
        this.log = repository.getLogger(subsystem);
    }

    public void fatal(String message) {
        this.log.fatal((Object)message);
    }

    public void fatal(String message, Throwable t) {
        this.log.fatal((Object)message, t);
    }

    public void error(String message) {
        this.log.error((Object)message);
    }

    public void error(String message, Throwable t) {
        this.log.error((Object)message, t);
    }

    public void warn(String message) {
        this.log.warn((Object)message);
    }

    public void warn(String message, Throwable t) {
        this.log.warn((Object)message, t);
    }

    public void info(String message) {
        this.log.info((Object)message);
    }

    public void info(String message, Throwable t) {
        this.log.info((Object)message, t);
    }

    public void debug(String message) {
        this.log.debug((Object)message);
    }

    public void debug(String message, Throwable t) {
        this.log.debug((Object)message, t);
    }

    public boolean isFatalEnabled() {
        return this.log.isEnabledFor((Priority)org.apache.log4j.Level.FATAL);
    }

    public boolean isDebugEnabled() {
        return this.log.isEnabledFor((Priority)org.apache.log4j.Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.log.isEnabledFor((Priority)org.apache.log4j.Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
    }

    public Level getLevel() {
        return fromLog4j.get(this.log.getLevel());
    }

    public void setLevel(Level level) {
        this.log.setLevel(toLog4j.get(level));
    }
}

