/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.EasyX509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class EasySSLProtocolSocketFactory
extends SSLConnectionSocketFactory {
    private SSLContext sslcontext = null;

    public EasySSLProtocolSocketFactory(SSLContext context) {
        super(context);
    }

    private static SSLContext createEasySSLContext() throws ClientProtocolException {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, null);
            return context;
        }
        catch (Exception e) {
            throw new ClientProtocolException(e.toString());
        }
    }

    private SSLContext getSSLContext() throws ClientProtocolException {
        if (this.sslcontext == null) {
            this.sslcontext = EasySSLProtocolSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(EasySSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return EasySSLProtocolSocketFactory.class.hashCode();
    }
}

