/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.tools.DataExport;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class SQLExec
extends Base {
    private static Logger log = new Logger(SQLExec.class.getName());
    private static Perl5Util perl = new Perl5Util();
    private static JSTranslater jsTrans = new JSTranslater();
    static PrintStream out = System.out;
    static PrintStream err = System.err;
    public static boolean verbose = false;
    public static boolean continueOnError = false;
    public static boolean js = false;

    public static void main(String[] args) {
        try {
            String filename = null;
            String database = config.getString((Object)"sql.defaultDatabase");
            DefaultParser parser = new DefaultParser();
            String cmdLineSyntax = "sqlExec [options]";
            Options options = new Options();
            options.addOption("h", "help", false, "Display this help message");
            options.addOption("v", "verbose", false, "Enable verbose output");
            options.addOption("j", "outputJS", false, "Display result set as a Javascript object. (Applies to queries only)");
            options.addOption("c", "continue-on-error", false, "Continue execution despite errors generated by individual sql statements.  By default, execution would terminate on the first SQL error");
            OptionBuilder.withLongOpt((String)"file");
            OptionBuilder.withDescription((String)"Read SQL from target file.  Specify '-' as the filename to use stdin (default).");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"fileName|-");
            OptionBuilder.withValueSeparator((char)' ');
            options.addOption(OptionBuilder.create((char)'f'));
            OptionBuilder.withLongOpt((String)"database");
            OptionBuilder.withDescription((String)"Connect to dbname for sql execution.  Defaults to sql.defaultDatabase.");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"databaseName");
            OptionBuilder.withValueSeparator((char)' ');
            options.addOption(OptionBuilder.create((char)'d'));
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("h")) {
                SQLExec.outputHelp(cmdLineSyntax, options);
                System.exit(0);
            }
            if (line.hasOption("v")) {
                verbose = true;
            }
            if (line.hasOption("j")) {
                js = true;
            }
            if (line.hasOption("c")) {
                continueOnError = true;
            }
            if (line.hasOption("f")) {
                filename = line.getOptionValue("f");
            }
            if (line.hasOption("d")) {
                database = line.getOptionValue("d");
            }
            SQLExec.executeSQL(SQLExec.readCommandsFromFile(filename), database);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nUtility for executing arbitrary sql commands via a JDBC driver.  This class is part of the Althem framework and, as such, reads database configuration and logging directives from masterConfig.properties.  Commands are seperated by a newline.");
    }

    public static List readCommandsFromFile(String filename) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        boolean stdin = false;
        InputStream istream = null;
        if (filename == null || filename.equals("-")) {
            istream = System.in;
            stdin = true;
            out.println("\n\nUsing stdin for SQL commands - enter your commands line by line and press Ctrl+D or enter an empty line when finished.");
        } else {
            File sqlFile = new File(filename);
            if (!(sqlFile.exists() && sqlFile.isFile() && sqlFile.canRead())) {
                throw new Exception(filename + " does not exists, is not a file, or is not readable");
            }
            istream = new FileInputStream(sqlFile);
        }
        BufferedReader sqlReader = new BufferedReader(new InputStreamReader(istream));
        String sqlLine = sqlReader.readLine();
        while (!(sqlLine == null || stdin && "".equals(sqlLine))) {
            sqlLine.trim();
            if (sqlLine.endsWith(";")) {
                sqlLine = sqlLine.substring(0, sqlLine.length() - 1);
            }
            result.add(sqlLine);
            sqlLine = sqlReader.readLine();
        }
        return result;
    }

    public static void executeSQL(List sqlCommands, String dbName) throws Exception {
        SQLDriver driver = SQLDriver.instance((String)dbName);
        if (driver == null) {
            throw new Exception("Unable to instantiate SQLDriver for database: " + dbName);
        }
        for (String sqlCommand : sqlCommands) {
            try {
                if (perl.match("/^\\s*SELECT/i", sqlCommand)) {
                    List results = driver.executeQuery(sqlCommand, null);
                    if (results == null || results.size() == 0) {
                        out.println("No results were returned for this query.");
                        out.flush();
                        continue;
                    }
                    DataExport de = new DataExport();
                    if (js) {
                        de.setOutputType(2);
                    }
                    OutputStreamWriter writer = new OutputStreamWriter(System.out);
                    de.exportResultSet(results, writer);
                    ((Writer)writer).flush();
                    continue;
                }
                driver.executeUpdate(sqlCommand, null);
            }
            catch (Exception e) {
                if (continueOnError) {
                    log.error((Object)("Database (" + dbName + ") Exception while executing : " + sqlCommand + " : " + e.toString()));
                    continue;
                }
                throw e;
            }
        }
    }
}

