/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.awt.Color;
import org.apache.poi.ss.usermodel.ExtendedColor;
import org.apache.poi.util.Internal;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;

public class XSSFColor
extends ExtendedColor {
    private CTColor ctColor;

    public XSSFColor(CTColor color) {
        this.ctColor = color;
    }

    public XSSFColor() {
        this.ctColor = CTColor.Factory.newInstance();
    }

    public XSSFColor(Color clr) {
        this();
        this.setColor(clr);
    }

    public XSSFColor(byte[] rgb) {
        this();
        this.ctColor.setRgb(rgb);
    }

    public boolean isAuto() {
        return this.ctColor.getAuto();
    }

    public void setAuto(boolean auto) {
        this.ctColor.setAuto(auto);
    }

    public boolean isIndexed() {
        return this.ctColor.isSetIndexed();
    }

    public boolean isRGB() {
        return this.ctColor.isSetRgb();
    }

    public boolean isThemed() {
        return this.ctColor.isSetTheme();
    }

    public boolean hasTint() {
        if (!this.ctColor.isSetRgb()) {
            return false;
        }
        return this.ctColor.getRgb().length == 4;
    }

    public short getIndex() {
        return (short)this.ctColor.getIndexed();
    }

    public short getIndexed() {
        return this.getIndex();
    }

    public void setIndexed(int indexed) {
        this.ctColor.setIndexed((long)indexed);
    }

    public byte[] getRGB() {
        byte[] rgb = this.getRGBOrARGB();
        if (rgb == null) {
            return null;
        }
        if (rgb.length == 4) {
            byte[] tmp = new byte[3];
            System.arraycopy(rgb, 1, tmp, 0, 3);
            return tmp;
        }
        return rgb;
    }

    public byte[] getARGB() {
        byte[] rgb = this.getRGBOrARGB();
        if (rgb == null) {
            return null;
        }
        if (rgb.length == 3) {
            byte[] tmp = new byte[4];
            tmp[0] = -1;
            System.arraycopy(rgb, 0, tmp, 1, 3);
            return tmp;
        }
        return rgb;
    }

    protected byte[] getStoredRBG() {
        return this.ctColor.getRgb();
    }

    public void setRGB(byte[] rgb) {
        this.ctColor.setRgb(rgb);
    }

    public int getTheme() {
        return (int)this.ctColor.getTheme();
    }

    public void setTheme(int theme) {
        this.ctColor.setTheme((long)theme);
    }

    public double getTint() {
        return this.ctColor.getTint();
    }

    public void setTint(double tint) {
        this.ctColor.setTint(tint);
    }

    @Internal
    public CTColor getCTColor() {
        return this.ctColor;
    }

    public static XSSFColor toXSSFColor(org.apache.poi.ss.usermodel.Color color) {
        if (color != null && !(color instanceof XSSFColor)) {
            throw new IllegalArgumentException("Only XSSFColor objects are supported");
        }
        return (XSSFColor)color;
    }

    public int hashCode() {
        return this.ctColor.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XSSFColor)) {
            return false;
        }
        XSSFColor cf = (XSSFColor)((Object)o);
        return this.ctColor.toString().equals(cf.getCTColor().toString());
    }
}

