/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.desktop;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.protos.DesktopUtilsProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.stp.services.messages.desktop.DesktopUtilsMessage;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScopeDesktopUtils
extends AbstractService
implements DesktopUtils {
    private static final String SUBSTITUTED_STRING_REGEXP = "(%[\\+\\#\\-\\ 0]?(?:\\d+)?(?:\\.\\d)?[hlL]?[cdieEfgGosuxXpn%])";
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ScopeDesktopUtils(ScopeServices services) {
        super(services, "desktop-utils", "2.0");
        services.setDesktopUtils(this);
    }

    @Override
    public void init() {
    }

    @Override
    public String getString(String enumText, boolean stripAmpersand) {
        String string = "";
        DesktopUtilsProtos.DesktopStringID.Builder stringBuilder = DesktopUtilsProtos.DesktopStringID.newBuilder();
        stringBuilder.setEnumText(enumText);
        UmsProtos.Response response = this.executeMessage(DesktopUtilsMessage.GET_STRING, (AbstractMessage.Builder<?>)stringBuilder);
        if (response == null) {
            this.logger.warning(String.format("Could not fetch string for ID: %s", enumText));
        } else {
            DesktopUtilsProtos.DesktopStringText.Builder stringTextBuilder = DesktopUtilsProtos.DesktopStringText.newBuilder();
            ScopeDesktopUtils.buildPayload(response, stringTextBuilder);
            DesktopUtilsProtos.DesktopStringText stringText = stringTextBuilder.build();
            string = this.removeCR(stringText.getText());
            if (stripAmpersand && string.contains("(&")) {
                return string.replaceAll("\\(&.\\)", "");
            }
            if (stripAmpersand && string.contains("&")) {
                return string.replace("&", "");
            }
        }
        return string;
    }

    @Override
    public String getSubstitutedString(String[] args, boolean stripAmpersand) {
        boolean orderedMode;
        String stringId = args[0];
        String rawString = this.getString(stringId, stripAmpersand);
        this.logger.finer(String.format("String \"%s\" fetched as \"%s\"", stringId, rawString));
        StringBuffer buf = new StringBuffer();
        int curArg = 0;
        int formattersCount = 0;
        String orderedFormatterRegexp = "%(\\d+)";
        Pattern pattern = Pattern.compile(SUBSTITUTED_STRING_REGEXP);
        Matcher matcher = pattern.matcher(rawString);
        if (matcher.find()) {
            this.logger.finer("Parsing with standard formatters");
            matcher.reset();
            orderedMode = false;
        } else {
            this.logger.finer("Parsing with ordered formatters");
            pattern = Pattern.compile(orderedFormatterRegexp);
            matcher = pattern.matcher(rawString);
            orderedMode = true;
        }
        while (matcher.find()) {
            ++formattersCount;
            String replaceStr = matcher.group();
            String substitution = "";
            if (replaceStr.equals("%%")) {
                substitution = "%";
            } else {
                curArg = orderedMode ? Integer.parseInt(replaceStr.substring(1)) : ++curArg;
                if (curArg < args.length) {
                    substitution = args[curArg];
                    if (substitution.isEmpty()) {
                        substitution = "_ANY_";
                    }
                } else {
                    substitution = replaceStr;
                }
            }
            matcher.appendReplacement(buf, substitution);
        }
        matcher.appendTail(buf);
        if (formattersCount != args.length - 1) {
            this.logger.warning(String.format("Argument count incorrect for %s, got %d, expected %d", stringId, args.length - 1, formattersCount));
        }
        String result = buf.toString();
        this.logger.finer("Final string: '" + result + "'");
        return result;
    }

    @Override
    public String removeCR(String text) {
        return text.replaceAll("(\\r)", "");
    }

    @Override
    public String getOperaPath() {
        UmsProtos.Response response = this.executeMessage(DesktopUtilsMessage.GET_OPERA_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        ScopeDesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath string_path = pathBuilder.build();
        return string_path.getPath();
    }

    @Override
    public String getLargePreferencesPath() {
        UmsProtos.Response response = this.executeMessage(DesktopUtilsMessage.GET_LARGE_PREFERENCES_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        ScopeDesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath stringPath = pathBuilder.build();
        return stringPath.getPath();
    }

    @Override
    public String getSmallPreferencesPath() {
        UmsProtos.Response response = this.executeMessage(DesktopUtilsMessage.GET_SMALL_PREFERENCES_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        ScopeDesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath stringPath = pathBuilder.build();
        return stringPath.getPath();
    }

    @Override
    public String getCachePreferencesPath() {
        UmsProtos.Response response = this.executeMessage(DesktopUtilsMessage.GET_CACHE_PREFERENCES_PATH, null);
        DesktopUtilsProtos.DesktopPath.Builder pathBuilder = DesktopUtilsProtos.DesktopPath.newBuilder();
        ScopeDesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPath stringPath = pathBuilder.build();
        return stringPath.getPath();
    }

    @Override
    public int getOperaPid() {
        UmsProtos.Response response = this.executeMessage(DesktopUtilsMessage.GET_OPERA_PID, null);
        DesktopUtilsProtos.DesktopPid.Builder pathBuilder = DesktopUtilsProtos.DesktopPid.newBuilder();
        ScopeDesktopUtils.buildPayload(response, pathBuilder);
        DesktopUtilsProtos.DesktopPid desktopPid = pathBuilder.build();
        return desktopPid.getPid();
    }
}

