/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;

public class ParameterExpressionImpl<T>
extends ExpressionImpl<T>
implements ParameterExpression<T> {
    protected String name;
    protected Integer position;

    public ParameterExpressionImpl(Metamodel metamodel, Class<T> javaType, String name) {
        super(metamodel, javaType, new ExpressionBuilder().getParameter(name, javaType));
        this.name = name;
    }

    public ParameterExpressionImpl(Metamodel metamodel, Class<T> javaType) {
        super(metamodel, javaType, null);
        this.name = String.valueOf(System.identityHashCode(this));
        this.currentNode = new ExpressionBuilder().getParameter(this.name, javaType);
    }

    public ParameterExpressionImpl(Metamodel metamodel, Class<T> javaType, Integer position) {
        super(metamodel, javaType, new ExpressionBuilder().getParameter(position.toString(), javaType));
        this.position = position;
        this.name = String.valueOf(position);
    }

    @Override
    public void findRootAndParameters(AbstractQueryImpl query) {
        query.addParameter(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Class<T> getParameterType() {
        return this.javaType;
    }

    public int hashCode() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name.hashCode();
    }

    @Override
    public boolean isParameter() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ClassConstants.STRING == obj.getClass()) {
            return this.name.equals(obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterExpressionImpl other = (ParameterExpressionImpl)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

