/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NoInitialContextException;

public class ISCInit {
    private static Config config;
    private static boolean initialized;
    public static boolean webRootSet;
    private static String webRoot;
    private static Logger log;
    public static final String AUTODETECT = "__AUTODETECT__";
    protected static boolean reentrant;

    public static void go() {
        ISCInit.go("[No class name provided]");
    }

    public static boolean isInitialized() {
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void go(String callingClassName) {
        if (reentrant) {
            return;
        }
        reentrant = true;
        try {
            try {
                if (callingClassName != null) {
                    log.debug("Isomorphic SmartClient/SmartGWT Framework initialization called from " + callingClassName);
                }
                if (initialized && webRootSet) {
                    if (callingClassName != null) {
                        log.debug("Isomorphic SmartClient/SmartGWT Framework is already initialized");
                    }
                    Object var9_1 = null;
                    reentrant = false;
                    return;
                }
                boolean initBlockExecuted = false;
                if (!initialized) {
                    log.info("Isomorphic SmartClient/SmartGWT Framework - Initializing");
                    config = Config.getGlobal();
                    if (config == null) {
                        config = Config.initGlobalConfig();
                    }
                    Logger.initialize();
                    initialized = true;
                    initBlockExecuted = true;
                    ISCInit.bindJDBCViaJNDI();
                }
                if (!webRootSet) {
                    if (webRoot == null) {
                        webRoot = config.getPath("webRoot");
                    }
                    if (!AUTODETECT.equals(webRoot) && (ISCInit.verifyWebRoot(webRoot) || ISCFile.isContainerIOPath(webRoot))) {
                        log.info("Using Configured webRoot: " + webRoot);
                        webRootSet = true;
                    } else {
                        if (!AUTODETECT.equals(webRoot)) {
                            throw new Exception("Configured webRoot path is invalid please check your server.properties setting.  Current value is: " + webRoot);
                        }
                        if (ISCFile.servletContext == null) {
                            log.info("No ServletContext available yet - using container IO for now");
                            config.put("webRoot", "__USE_CONTAINER__");
                        } else {
                            String realPath = ISCFile.servletContext.getRealPath("/");
                            String autoWebRoot = ISCInit.fixRealPath(realPath);
                            if (autoWebRoot == null) {
                                log.info("Container refusing to provide getRealPath() - assuming WAR context and using container IO");
                                config.put("webRoot", "__USE_CONTAINER__");
                            } else if (ISCInit.verifyWebRoot(autoWebRoot)) {
                                config.put("webRoot", autoWebRoot);
                                log.info("Auto-detected webRoot - using: " + autoWebRoot);
                            } else {
                                config.put("webRoot", "__USE_CONTAINER__");
                                log.info("WebRoot auto-detection failed - using container IO");
                            }
                            webRootSet = true;
                        }
                    }
                }
                if (initBlockExecuted) {
                    String initScript;
                    if (config != null && (initScript = config.getString("init.script")) != null) {
                        String initScriptLanguage = config.getString("init.script.language");
                        if (initScriptLanguage == null) {
                            log.warn("init.script is defined, but init.script.language is not. Please define it (in server.properties) if you want your init script to run");
                        } else {
                            DataTypeMap params = new DataTypeMap();
                            HashMap<String, Logger> bindings = new HashMap<String, Logger>();
                            params.put("bindings", bindings);
                            bindings.put("log", log);
                            params.put("engineName", initScriptLanguage);
                            ISCFile scriptFile = ISCFile.newInstance(initScript);
                            String script = scriptFile.getAsString();
                            params.put("script", script);
                            log.info("Executing init script: " + initScript);
                            Scripting.evalServerScript(params);
                        }
                    }
                    String version = config.getString("iscVersion");
                    String packageDate = config.getString("iscPackageDate");
                    log.info("Isomorphic SmartClient/SmartGWT Framework (" + version + " " + packageDate + ") - Initialization Complete");
                }
            }
            catch (Throwable e) {
                System.err.println("Isomorphic Init: Exception in Init.go()");
                e.printStackTrace(System.err);
                Object var9_3 = null;
                reentrant = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            reentrant = false;
            throw throwable;
        }
        Object var9_2 = null;
        reentrant = false;
    }

    private static String fixRealPath(String path) {
        if (path == null) {
            return null;
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private static boolean verifyWebRoot(String webRoot) {
        log.debug("Verifying webroot: " + webRoot);
        webRoot = ISCFile.canonicalizePath(webRoot);
        File webRootDir = new File(webRoot);
        if (!webRootDir.exists() || !webRootDir.isDirectory()) {
            return false;
        }
        String markerFileName = ISCFile.canonicalizePath(webRoot + "/" + config.getPath("isomorphicPathRootRelative"));
        File markerFile = new File(markerFileName);
        try {
            markerFile = markerFile.getAbsoluteFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!markerFile.exists()) {
            log.error("Can't find marker file for webRoot: " + markerFileName + " for configured/autodetected webRoot - if you moved the 'isomorphic' directory, please set isomorphicPathRootRelative in server.properties to the new location and restart the servlet engine.");
            return false;
        }
        return true;
    }

    public static boolean canRestartContainer() {
        String containerClassName = System.getProperty("com.isomorphic.embedded_tomcat.className");
        return containerClassName != null;
    }

    public static void restartContainer() throws Exception {
        if (!ISCInit.canRestartContainer()) {
            throw new Exception("Unable to respond to container restart command - not running in embedded Tomcat mode - ignoring.");
        }
        log.info("Container restart requested");
        System.exit(5);
    }

    public static void shutdownContainer() {
        log.info("Container shutdown requested");
        System.exit(0);
    }

    private static void bindJDBCViaJNDI() {
        String defaultPublishPath;
        String initialContextFactory;
        if (!config.getBoolean((Object)"sql.jndi.publish", false)) {
            log.info("SQL JNDI publishing disabled");
            return;
        }
        String className = "com.isomorphic.sql.DBDataSource";
        Class<?> c = null;
        try {
            c = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            try {
                c = Class.forName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == null) {
            log.info("SQL JNDI publishing is enabled, but isomorphic_sql.jar is not present - proceeding without publishing isomorphic SQL databases to JNDI");
            return;
        }
        if (config.getBoolean((Object)"devenv", false) && (initialContextFactory = System.getProperty("java.naming.factory.initial")) == null) {
            try {
                System.setProperty("java.naming.factory.initial", "com.isomorphic.naming.MockInitialContextFactory");
            }
            catch (Exception e) {
                log.warn((Object)"Error binding MockInitialContext", e);
            }
        }
        if ("".equals(defaultPublishPath = config.getString("sql.jndi.publish.path"))) {
            defaultPublishPath = null;
        }
        ArrayList<String> dbNames = new ArrayList<String>();
        Config dbConfig = config.getSubtree("sql");
        for (String key : dbConfig.keySet()) {
            String dbName;
            int index = key.indexOf(".database.type");
            if (index == -1 || dbNames.contains(dbName = key.substring(0, index))) continue;
            dbNames.add(dbName);
        }
        if (dbNames.size() > 1) {
            dbNames.add("defaultDatabase");
            try {
                for (String dbName : dbNames) {
                    String publishPath = config.getString("sql." + dbName + ".jndi.publish.path", null);
                    if (publishPath == null && (publishPath = defaultPublishPath) != null) {
                        publishPath = publishPath + "/" + dbName;
                    }
                    Context ctx = null;
                    if (publishPath == null) continue;
                    try {
                        ctx = JNDI.createSubcontextPath(publishPath, true);
                    }
                    catch (NoInitialContextException nic) {
                        log.info("No default JNDI initial context factory present. Attempting to use MockInitialContextFactory.");
                        System.setProperty("java.naming.factory.initial", "com.isomorphic.naming.MockInitialContextFactory");
                        ctx = JNDI.createSubcontextPath(publishPath, true);
                    }
                    Object iscDS = c.newInstance();
                    String dbNameForLookup = dbName;
                    if ("defaultDatabase".equals(dbName)) {
                        dbNameForLookup = "config:sql.defaultDatabase";
                    }
                    DataTools.setProperties((Map)((Object)DataTools.buildMap("dbName", dbNameForLookup)), iscDS);
                    ctx.bind(publishPath, iscDS);
                    log.info("Bound DB " + dbName + " via JNDI at: " + publishPath);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to populate JNDI context with JDBC connections configured in server.properties -  impacted databases: " + ((Object)dbNames).toString()), t);
            }
        }
    }

    static {
        initialized = false;
        webRootSet = false;
        log = new Logger(ISCInit.class.getName());
        reentrant = false;
    }
}

