/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class MediaList
extends SimpleScriptable {
    private final org.w3c.dom.stylesheets.MediaList wrappedList_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=31.0f)})
    public MediaList() {
        this.wrappedList_ = null;
    }

    public MediaList(CSSStyleSheet parent, org.w3c.dom.stylesheets.MediaList wrappedList) {
        this.wrappedList_ = wrappedList;
        this.setParentScope((Scriptable)parent);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxFunction
    public String item(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return this.wrappedList_.item(index);
    }

    @JsxGetter
    public int getLength() {
        return this.wrappedList_.getLength();
    }

    @JsxGetter
    public String getMediaText() {
        return this.wrappedList_.getMediaText();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null) {
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_EMPTY_STRING)) {
                return "";
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_ALL)) {
                return "all";
            }
        }
        return super.getDefaultValue(hint);
    }
}

