/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.cdi;

import com.isomorphic.interfaces.ICDIBeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIBeanManager
implements ICDIBeanManager {
    protected static BeanManager beanManager;

    public Object getBeanManager() throws Exception {
        block5: {
            if (beanManager == null) {
                try {
                    InitialContext context = new InitialContext();
                    beanManager = (BeanManager)context.lookup("java:comp/env/BeanManager");
                }
                catch (NamingException ignored) {
                    if (beanManager != null) break block5;
                    try {
                        InitialContext context = new InitialContext();
                        beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
                    }
                    catch (NamingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return beanManager;
    }

    public Object getBean(String beanName) throws Exception {
        this.getBeanManager();
        Iterator i = beanManager.getBeans(beanName).iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("Failed to get bean '" + beanName + "' from CDI BeanManager");
        }
        Bean bean = (Bean)i.next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        Object o = beanManager.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }

    public Object getBean(Type beanType) throws Exception {
        this.getBeanManager();
        Iterator i = beanManager.getBeans(beanType, new Annotation[0]).iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("Failed to get bean of type '" + beanType + "' from CDI BeanManager");
        }
        Bean bean = (Bean)i.next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        Object o = beanManager.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }
}

