/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.tidy.DOMAttrMapImpl;
import org.w3c.tidy.DOMNodeListImpl;
import org.w3c.tidy.Node;
import org.w3c.tidy.TidyUtils;

public class DOMNodeImpl
implements org.w3c.dom.Node {
    protected Node adaptee;

    protected DOMNodeImpl(Node node) {
        this.adaptee = node;
    }

    public String getNodeValue() {
        String string = "";
        if ((this.adaptee.type == 4 || this.adaptee.type == 8 || this.adaptee.type == 2 || this.adaptee.type == 3) && this.adaptee.textarray != null && this.adaptee.start < this.adaptee.end) {
            string = TidyUtils.getString(this.adaptee.textarray, this.adaptee.start, this.adaptee.end - this.adaptee.start);
        }
        return string;
    }

    public void setNodeValue(String string) {
        if (this.adaptee.type == 4 || this.adaptee.type == 8 || this.adaptee.type == 2 || this.adaptee.type == 3) {
            byte[] byArray = TidyUtils.getBytes(string);
            this.adaptee.textarray = byArray;
            this.adaptee.start = 0;
            this.adaptee.end = byArray.length;
        }
    }

    public String getNodeName() {
        return this.adaptee.element;
    }

    public short getNodeType() {
        short s = -1;
        switch (this.adaptee.type) {
            case 0: {
                s = 9;
                break;
            }
            case 1: {
                s = 10;
                break;
            }
            case 2: {
                s = 8;
                break;
            }
            case 3: {
                s = 7;
                break;
            }
            case 4: {
                s = 3;
                break;
            }
            case 8: {
                s = 4;
                break;
            }
            case 5: 
            case 7: {
                s = 1;
            }
        }
        return s;
    }

    public org.w3c.dom.Node getParentNode() {
        if (this.adaptee.parent != null) {
            return this.adaptee.parent.getAdapter();
        }
        return null;
    }

    public NodeList getChildNodes() {
        return new DOMNodeListImpl(this.adaptee);
    }

    public org.w3c.dom.Node getFirstChild() {
        if (this.adaptee.content != null) {
            return this.adaptee.content.getAdapter();
        }
        return null;
    }

    public org.w3c.dom.Node getLastChild() {
        if (this.adaptee.last != null) {
            return this.adaptee.last.getAdapter();
        }
        return null;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        if (this.adaptee.prev != null) {
            return this.adaptee.prev.getAdapter();
        }
        return null;
    }

    public org.w3c.dom.Node getNextSibling() {
        if (this.adaptee.next != null) {
            return this.adaptee.next.getAdapter();
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        return new DOMAttrMapImpl(this.adaptee.attributes);
    }

    public Document getOwnerDocument() {
        Node node = this.adaptee;
        if (node != null && node.type == 0) {
            return null;
        }
        while (node != null && node.type != 0) {
            node = node.parent;
        }
        if (node != null) {
            return (Document)node.getAdapter();
        }
        return null;
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        if (node == null) {
            return null;
        }
        if (!(node instanceof DOMNodeImpl)) {
            throw new DOMException(4, "newChild not instanceof DOMNodeImpl");
        }
        DOMNodeImpl dOMNodeImpl = (DOMNodeImpl)node;
        if (this.adaptee.type == 0 ? dOMNodeImpl.adaptee.type != 1 && dOMNodeImpl.adaptee.type != 3 : this.adaptee.type == 5 && dOMNodeImpl.adaptee.type != 5 && dOMNodeImpl.adaptee.type != 7 && dOMNodeImpl.adaptee.type != 2 && dOMNodeImpl.adaptee.type != 4 && dOMNodeImpl.adaptee.type != 8) {
            throw new DOMException(3, "newChild cannot be a child of this node");
        }
        if (node2 == null) {
            this.adaptee.insertNodeAtEnd(dOMNodeImpl.adaptee);
            if (this.adaptee.type == 7) {
                this.adaptee.setType((short)5);
            }
        } else {
            Node node3 = this.adaptee.content;
            while (node3 != null && node3.getAdapter() != node2) {
                node3 = node3.next;
            }
            if (node3 == null) {
                throw new DOMException(8, "refChild not found");
            }
            Node.insertNodeBeforeElement(node3, dOMNodeImpl.adaptee);
        }
        return node;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        if (node == null) {
            return null;
        }
        if (!(node instanceof DOMNodeImpl)) {
            throw new DOMException(4, "newChild not instanceof DOMNodeImpl");
        }
        DOMNodeImpl dOMNodeImpl = (DOMNodeImpl)node;
        if (this.adaptee.type == 0 ? dOMNodeImpl.adaptee.type != 1 && dOMNodeImpl.adaptee.type != 3 : this.adaptee.type == 5 && dOMNodeImpl.adaptee.type != 5 && dOMNodeImpl.adaptee.type != 7 && dOMNodeImpl.adaptee.type != 2 && dOMNodeImpl.adaptee.type != 4 && dOMNodeImpl.adaptee.type != 8) {
            throw new DOMException(3, "newChild cannot be a child of this node");
        }
        if (node2 == null) {
            throw new DOMException(8, "oldChild not found");
        }
        Node node3 = this.adaptee.content;
        while (node3 != null && node3.getAdapter() != node2) {
            node3 = node3.next;
        }
        if (node3 == null) {
            throw new DOMException(8, "oldChild not found");
        }
        dOMNodeImpl.adaptee.next = node3.next;
        dOMNodeImpl.adaptee.prev = node3.prev;
        dOMNodeImpl.adaptee.last = node3.last;
        dOMNodeImpl.adaptee.parent = node3.parent;
        dOMNodeImpl.adaptee.content = node3.content;
        if (node3.parent != null) {
            if (node3.parent.content == node3) {
                node3.parent.content = dOMNodeImpl.adaptee;
            }
            if (node3.parent.last == node3) {
                node3.parent.last = dOMNodeImpl.adaptee;
            }
        }
        if (node3.prev != null) {
            node3.prev.next = dOMNodeImpl.adaptee;
        }
        if (node3.next != null) {
            node3.next.prev = dOMNodeImpl.adaptee;
        }
        Node node4 = node3.content;
        while (node4 != null) {
            if (node4.parent == node3) {
                node4.parent = dOMNodeImpl.adaptee;
            }
            node4 = node4.next;
        }
        return node2;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = this.adaptee.content;
        while (node2 != null && node2.getAdapter() != node) {
            node2 = node2.next;
        }
        if (node2 == null) {
            throw new DOMException(8, "refChild not found");
        }
        Node.discardElement(node2);
        if (this.adaptee.content == null && this.adaptee.type == 5) {
            this.adaptee.setType((short)7);
        }
        return node;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) {
        if (node == null) {
            return null;
        }
        if (!(node instanceof DOMNodeImpl)) {
            throw new DOMException(4, "newChild not instanceof DOMNodeImpl");
        }
        DOMNodeImpl dOMNodeImpl = (DOMNodeImpl)node;
        if (this.adaptee.type == 0 ? dOMNodeImpl.adaptee.type != 1 && dOMNodeImpl.adaptee.type != 3 : this.adaptee.type == 5 && dOMNodeImpl.adaptee.type != 5 && dOMNodeImpl.adaptee.type != 7 && dOMNodeImpl.adaptee.type != 2 && dOMNodeImpl.adaptee.type != 4 && dOMNodeImpl.adaptee.type != 8) {
            throw new DOMException(3, "newChild cannot be a child of this node");
        }
        this.adaptee.insertNodeAtEnd(dOMNodeImpl.adaptee);
        if (this.adaptee.type == 7) {
            this.adaptee.setType((short)5);
        }
        return node;
    }

    public boolean hasChildNodes() {
        return this.adaptee.content != null;
    }

    public org.w3c.dom.Node cloneNode(boolean bl) {
        Node node = this.adaptee.cloneNode(bl);
        node.parent = null;
        return node.getAdapter();
    }

    public void normalize() {
    }

    public boolean supports(String string, String string2) {
        return this.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) throws DOMException {
    }

    public String getLocalName() {
        return this.getNodeName();
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public boolean hasAttributes() {
        return this.adaptee.attributes != null;
    }

    public short compareDocumentPosition(org.w3c.dom.Node node) throws DOMException {
        throw new DOMException(9, "DOM method not supported");
    }

    public String getBaseURI() {
        return null;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return false;
    }

    public boolean isEqualNode(org.w3c.dom.Node node) {
        return false;
    }

    public boolean isSameNode(org.w3c.dom.Node node) {
        return false;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public void setTextContent(String string) throws DOMException {
        throw new DOMException(7, "Node is read only");
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }
}

