/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCObjectPool;
import com.isomorphic.pool.ISCPoolableObjectFactory;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.WrappedConnection;
import com.isomorphic.util.DataTools;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.pool.ObjectPool;

public class PoolableSQLConnectionFactory
extends ISCPoolableObjectFactory {
    private static Logger log = new Logger(PoolableSQLConnectionFactory.class.getName());
    private static Config config = Config.getGlobal();
    private String serverName;
    private String defaultCatalog;
    private String databaseType;
    private String pingTest;
    private int pingTestTimeout;
    private String interfaceType = "datasource";
    private boolean driverManagerRegistered = false;
    private Config sqlConfig;
    private Config driverConfig;
    private Config databaseConfig;
    private boolean autoDeriveConfig = false;
    DataSource ds;
    private long nanosPassivating = 0L;

    public IPoolableObjectFactory newInstance(Object key) throws Exception {
        return new PoolableSQLConnectionFactory(key.toString());
    }

    public PoolableSQLConnectionFactory() {
    }

    public PoolableSQLConnectionFactory(String serverName) throws Exception {
        this(serverName, config.getSubtree("sql." + serverName));
    }

    public PoolableSQLConnectionFactory(String serverName, Config sqlConfig) throws Exception {
        String interfaceType;
        this.serverName = serverName;
        this.sqlConfig = sqlConfig;
        if (sqlConfig == null || sqlConfig.size() == 0) {
            log.info((Object)("No explicit configuration for db: " + serverName + " in server.properties - will look for a Connection object at " + serverName + " or java:comp/env/" + serverName + "."));
            sqlConfig = new Config();
            sqlConfig.put((Object)"interface.type", (Object)"jndi");
            sqlConfig.put((Object)"driver.name", (Object)serverName);
            this.autoDeriveConfig = true;
        }
        if ((interfaceType = sqlConfig.getString((Object)"interface.type")) == null) {
            log.warning((Object)("sql." + serverName + ".interface.type not set - assuming " + this.interfaceType));
        } else {
            this.interfaceType = interfaceType;
        }
        if ("jndi".equals(this.interfaceType)) {
            if (!this.sqlConfig.getBoolean((Object)"pool.enabled", false)) {
                this.poolDisabled = Boolean.TRUE;
            }
        } else if (this.sqlConfig.getBoolean((Object)"pool.enabled", false)) {
            this.poolDisabled = Boolean.FALSE;
        }
        this.interfaceType = this.interfaceType.toLowerCase().intern();
        this.driverConfig = sqlConfig.getSubtree("driver");
        this.databaseConfig = sqlConfig.getSubtree("database");
        if (!sqlConfig.getBoolean((Object)"autoDeriveConfig", false)) {
            this.configureDB();
        }
        this.defaultCatalog = this.driverConfig.getString((Object)"databaseName");
        if (this.defaultCatalog == null && "hsqldb".equals(this.databaseType)) {
            this.defaultCatalog = this.driverConfig.getString((Object)"url");
            this.defaultCatalog = this.defaultCatalog == null ? "isomorphic" : this.defaultCatalog.substring(this.defaultCatalog.lastIndexOf("/") + 1);
        }
    }

    private void configureDB() {
        this.databaseType = this.databaseConfig.getString((Object)"type");
        this.pingTest = config.getString((Object)("sql." + this.databaseType + ".pingTest"));
        this.pingTestTimeout = this.sqlConfig.getInt((Object)"validationQueryTimeout", 10);
    }

    public void activateObject(Object obj) throws Exception {
        ++this.numActivateObjectCalls;
        if (obj instanceof ISCPoolableConnection) {
            ((ISCPoolableConnection)((Object)obj)).activate();
        }
    }

    public void destroyObject(Object obj) throws Exception {
        ++this.numDestroyObjectCalls;
        try {
            if (obj instanceof PoolableConnection) {
                ((PoolableConnection)obj).reallyClose();
            } else {
                ((Connection)obj).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeUnpooledObject() throws Exception {
        Connection conn = null;
        if (this.interfaceType == "datasource") {
            PoolableSQLConnectionFactory poolableSQLConnectionFactory = this;
            synchronized (poolableSQLConnectionFactory) {
                if (this.ds == null) {
                    String dsImplementer = this.sqlConfig.getString((Object)"driver");
                    log.debug((Object)("Initializing SQL config for '" + this.serverName + "' from system config - using DataSource:  " + dsImplementer));
                    this.ds = (DataSource)Reflection.newInstance((String)dsImplementer);
                    DataTypeMap workConfig = new DataTypeMap((Map)this.driverConfig);
                    SQLDriver sqlDriver = SQLDriver.instance("", this.databaseType);
                    sqlDriver.addDriverProperties((Map)workConfig);
                    try {
                        DataTools.setProperties((Map)workConfig, (Object)this.ds);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception trying to set connection properties", (Throwable)e);
                    }
                    if (this.ds != null && this.sqlConfig.getBoolean((Object)"log.enabled", false)) {
                        this.ds.setLogWriter(new PrintWriter(System.out));
                    }
                }
            }
            if (this.ds == null) {
                throw new Exception("Unable to instantiate JDBC DataSource for database " + this.serverName + " - check your config.");
            }
            conn = this.ds.getConnection();
        } else if (this.interfaceType == "drivermanager") {
            String jdbcURL = this.driverConfig.getString((Object)"url");
            Boolean credentialsSetting = this.sqlConfig.getBoolean((Object)"interface.credentialsInURL");
            boolean credentialsInURL = credentialsSetting == null || credentialsSetting != false;
            SQLDriver sqlDriver = SQLDriver.instance("", this.databaseType);
            if (jdbcURL == null || jdbcURL.length() == 0) {
                jdbcURL = "jdbc:" + sqlDriver.getDriverNameForURL(this.driverConfig) + "://" + this.driverConfig.getString((Object)"serverName") + ":" + this.driverConfig.get((Object)"portNumber") + "/" + this.driverConfig.get((Object)"databaseName") + (credentialsInURL ? "?user=" + this.driverConfig.get((Object)"user") + "&password=" + this.driverConfig.get((Object)"password") : "");
                String params = sqlDriver.getURLParameterString();
                if (params != null) {
                    jdbcURL = jdbcURL + (credentialsInURL ? "&" : "?") + params;
                }
            }
            Class driver = null;
            PoolableSQLConnectionFactory poolableSQLConnectionFactory = this;
            synchronized (poolableSQLConnectionFactory) {
                if (!this.driverManagerRegistered) {
                    String dmImplementer = this.sqlConfig.getString((Object)"driver");
                    log.debug((Object)("Initializing SQL config for '" + this.serverName + "' from system config - using DriverManager:  " + dmImplementer));
                    driver = Reflection.classForName((String)dmImplementer);
                    if (driver != null) {
                        log.debug((Object)(dmImplementer + " lookup successful"));
                        this.driverManagerRegistered = true;
                    } else {
                        throw new Exception("Unable to register JDBC DriverManager for database " + this.serverName + " - check your config.");
                    }
                }
            }
            if (ISCFile.isUnresolvedContainer((String)jdbcURL)) {
                jdbcURL = ISCFile.replaceUnresolvedContainer((String)jdbcURL) + "; shutdown=true";
            }
            log.debug((Object)("DriverManager fetching connection for " + this.serverName + " via jdbc url " + jdbcURL));
            if (!credentialsInURL) {
                log.debug((Object)"Passing credentials getConnection separately from JDBC URL");
                conn = DriverManager.getConnection(jdbcURL, this.driverConfig.getString((Object)"user"), this.driverConfig.getString((Object)"password"));
            } else {
                log.debug((Object)"Passing JDBC URL only to getConnection");
                conn = DriverManager.getConnection(jdbcURL);
            }
        } else if (this.interfaceType == "jndi") {
            String jndiName = null;
            PoolableSQLConnectionFactory credentialsSetting = this;
            synchronized (credentialsSetting) {
                if (this.ds == null) {
                    String ctxName = this.driverConfig.getString((Object)"context");
                    if (ctxName == null) {
                        ctxName = "";
                        this.driverConfig.put((Object)"context", (Object)"");
                    }
                    log.debug((Object)("Initializing SQL config for '" + this.serverName + "' via JNDI"));
                    Context dbContext = JNDI.bindConfiguredContext((String)ctxName);
                    jndiName = this.driverConfig.getString((Object)"name");
                    if (jndiName == null) {
                        throw new Exception("Encountered null JNDI name when trying to connect a JNDI DataSource. ");
                    }
                    try {
                        this.ds = (DataSource)dbContext.lookup(jndiName);
                    }
                    catch (NameNotFoundException driver) {
                        // empty catch block
                    }
                    if (this.ds == null) {
                        dbContext = JNDI.bindConfiguredContext((String)"_container_");
                        if (dbContext != null) {
                            this.ds = (DataSource)dbContext.lookup(jndiName);
                            if (this.ds != null) {
                                this.driverConfig.put((Object)"context", (Object)"_container_");
                            }
                        } else {
                            log.warn((Object)"Unable to obtain initialContext via new InitialContext() - this shouldn't happen and indicates a low level error with instantiating a Context.INITIAL_CONTEXT_FACTORY - please check for overrides of this on the command line or other bootstrap logic");
                        }
                    }
                    if (this.ds != null && this.sqlConfig.getBoolean((Object)"log.enabled", false)) {
                        this.ds.setLogWriter(new PrintWriter(System.out));
                    }
                }
            }
            if (this.ds == null) {
                throw new Exception("JNDI lookup for " + jndiName + " failed.");
            }
            conn = this.ds.getConnection();
            if (this.autoDeriveConfig) {
                DatabaseMetaData md = conn.getMetaData();
                String productName = md.getDatabaseProductName();
                String productVersion = md.getDatabaseProductVersion();
                String driverName = md.getDriverName();
                String driverVersion = md.getDriverVersion();
                log.info((Object)("Auto-configuring connection to " + this.serverName + " - connected to " + productName + ", version: " + productVersion + " via JDBC driver: " + driverName + ", version: " + driverVersion));
                String dbType = "generic";
                if (productName.toLowerCase().indexOf("sql server") != -1) {
                    dbType = "sqlserver";
                } else if (productName.toLowerCase().indexOf("oracle") != -1) {
                    dbType = "oracle";
                } else if (productName.toLowerCase().indexOf("mysql") != -1) {
                    dbType = "mysql";
                } else if (productName.toLowerCase().indexOf("postgresql") != -1) {
                    dbType = "postgresql";
                } else if (productName.toLowerCase().indexOf("db2") != -1) {
                    dbType = "db2";
                } else if (productName.toLowerCase().indexOf("hsqldb") != -1) {
                    dbType = "hsqldb";
                } else if (productName.toLowerCase().indexOf("cache") != -1) {
                    dbType = "cache";
                }
                log.info((Object)("Derived DB type is: " + dbType + ", for serverName: " + this.serverName + ", jndiName: " + jndiName));
                config.put((Object)("sql." + this.serverName + ".database.type"), (Object)dbType);
                config.put((Object)("sql." + this.serverName + ".driver.name"), (Object)this.serverName);
                config.put((Object)("sql." + this.serverName + ".driver.serverName"), (Object)"[Auto-configured JNDI resource]");
                config.put((Object)("sql." + this.serverName + ".driver.autoConfigured"), (Object)Boolean.TRUE);
                config.put((Object)("sql." + this.serverName + ".interface.type"), (Object)"jndi");
                this.autoDeriveConfig = false;
            }
        } else {
            throw new Exception("Unsupported interface type " + this.interfaceType + " for database " + this.serverName + " - check your config.");
        }
        if (config.getBoolean((Object)"devenv", false) && config.getBoolean((Object)"sql.wrapConnections", true)) {
            conn = (Connection)new WrappedConnection(this.serverName, this.defaultCatalog).wrap(conn);
        }
        return conn;
    }

    public Object makeObject() throws Exception {
        ++this.numMakeObjectCalls;
        Connection conn = (Connection)this.makeUnpooledObject();
        if (conn == null) {
            throw new Exception("Error: unable to obtain a database connection");
        }
        if (this.pool == null) {
            log.debug((Object)("makeObject() created an unpooled Connection '" + conn.hashCode() + "'"));
            return conn;
        }
        log.debug((Object)("makeObject() created a pooled Connection '" + conn.hashCode() + "'"));
        return new ISCPoolableConnection(conn, (ISCObjectPool)this.pool){};
    }

    public void passivateObject(Object obj) throws Exception {
        log.debug((Object)("Passivating connection '" + obj.hashCode()));
        ++this.numPassivateObjectCalls;
        if (obj instanceof ISCPoolableConnection) {
            long before = System.nanoTime();
            ((ISCPoolableConnection)((Object)obj)).passivate();
            this.nanosPassivating += System.nanoTime() - before;
        }
    }

    public void logPassivateStats() {
        log.warn((Object)("Made " + this.numPassivateObjectCalls + " passivate calls in " + this.nanosPassivating + "us"));
    }

    public boolean validateObject(Object obj) {
        ++this.numValidateObjectCalls;
        Connection conn = (Connection)obj;
        Statement s = null;
        try {
            if (conn.isClosed()) {
                log.debug((Object)"Connection was already closed in validateObject - returning false");
                return false;
            }
            if (this.pingTest != null) {
                s = conn.createStatement();
                s.setQueryTimeout(this.pingTestTimeout);
                log.debug((Object)("Executing pingTest '" + this.pingTest + "' on connection " + obj.hashCode()));
                s.executeQuery(this.pingTest);
                s.close();
            }
            return true;
        }
        catch (SQLException e) {
            log.warn((Object)("Exception running pingTest: " + e.getMessage()));
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception ignored) {
                log.warn((Object)("Failed to close statement " + obj.hashCode() + ": " + ignored.getMessage()));
                ignored.printStackTrace();
            }
            return false;
        }
    }

    private static class ISCPoolableConnection
    extends PoolableConnection {
        public ISCPoolableConnection(Connection conn, ISCObjectPool pool) {
            super(conn, (ObjectPool)pool);
        }

        public void passivate() throws SQLException {
            super.passivate();
        }

        public void activate() {
            super.activate();
        }
    }
}

