/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInvocationHandler;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.List;

public class WrappedStatement
extends ISCInvocationHandler {
    protected static Logger log = new Logger(WrappedStatement.class.getName());
    String dbName;
    String defaultCatalog;

    public WrappedStatement(String dbName, String defaultCatalog) {
        this.dbName = dbName;
        this.defaultCatalog = defaultCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Method method, Object[] args) throws Throwable {
        Config config = Config.getGlobal();
        List updateMethods = DataTools.buildList((Object[])new Object[]{"execute", "executeUpdate", "executeBatch"});
        if (!config.getBoolean((Object)"autotest.running", false) || !updateMethods.contains(method.getName())) return method.invoke(this.target, args);
        Class<WrappedStatement> clazz = WrappedStatement.class;
        synchronized (WrappedStatement.class) {
            String fullDbName;
            List restoreDBList = config.getList((Object)"autotest.restoreDBList");
            String canonicalDBName = "Mysql2".equals(this.dbName) ? "Mysql" : (this.dbName.endsWith("/defaultDatabase") ? config.getString((Object)"sql.defaultDatabase") : this.dbName);
            if (!this.dbName.equals(canonicalDBName)) {
                log.warn((Object)("Canonicalized dbName: " + this.dbName + " to: " + canonicalDBName));
            }
            String string = fullDbName = this.defaultCatalog == null ? canonicalDBName : canonicalDBName + "." + this.defaultCatalog;
            if (restoreDBList.contains(fullDbName)) return method.invoke(this.target, args);
            log.warn((Object)("In autotest, detected possible update operation: " + method.getName() + " with args:" + args + " current restoreDBList: " + restoreDBList.toString() + ", taking snapshotof: " + fullDbName));
            SQLDriver.snapshotDB(fullDbName);
            restoreDBList.add(fullDbName);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return method.invoke(this.target, args);
        }
    }

    public Statement getUnwrappedStatement() {
        return (Statement)this.target;
    }
}

