/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.Operation;
import com.isomorphic.webdriver.SeleneseRunnerProperties;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringEscapeUtils;
import org.htmlparser.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.NodeVisitor;
import org.openqa.selenium.Capabilities;

class SeleneseTestCaseParser
extends NodeVisitor {
    private Class driverClass;
    private SmartClientWebDriver driver;
    private boolean found = false;
    private boolean successful = true;
    private PrintStream output;
    private boolean debug;

    public SeleneseTestCaseParser(Class driverClass, SeleneseRunnerProperties driverProps, String baseUrl, PrintStream output, boolean debug) {
        this.driverClass = driverClass;
        if (baseUrl != null) {
            try {
                if (driverProps == null || driverProps.isEmpty()) {
                    Constructor driverCons = driverClass.getConstructor(new Class[0]);
                    this.driver = (SmartClientWebDriver)driverCons.newInstance(new Object[0]);
                } else {
                    Constructor driverCons = driverClass.getConstructor(Capabilities.class);
                    Capabilities capabilities = driverProps.getConfiguredCapabilities();
                    this.driver = (SmartClientWebDriver)driverCons.newInstance(capabilities);
                }
                this.driver.setBaseUrl(baseUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.successful = false;
            }
        }
        this.output = output;
        this.debug = debug;
    }

    public void visitTag(Tag tag) {
        NodeList children;
        Object result = null;
        Operation operation = null;
        String label = null;
        boolean mapped = true;
        String name = tag.getTagName();
        if ("tr".equalsIgnoreCase(name) && (children = tag.getChildren()).size() == 6) {
            this.found = true;
            try {
                RowVisitor rowVisitor = null;
                rowVisitor = new RowVisitor(this.output);
                children.visitAllNodesWith((NodeVisitor)rowVisitor);
                operation = rowVisitor.getOperation();
                if (this.debug) {
                    System.err.println(operation.toString());
                }
                result = operation.execute(this.driver, this.driverClass);
            }
            catch (NoSuchMethodException e) {
                String action = "skipping";
                if (this.output != null && operation != null) {
                    action = "adding a comment and " + action;
                }
                System.err.println("!!! Unable to map a command from the Selenium HTML file - " + action + ".  " + e.getMessage());
                mapped = false;
            }
            catch (Throwable t) {
                Throwable cause;
                if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
                    t = cause;
                }
                if (this.output != null && operation != null) {
                    String[] lines;
                    label = "^^^ " + t.getClass().getCanonicalName() + " ^^^";
                    String message = t.getMessage();
                    if (message != null && (lines = message.split("(\r)?\n")).length > 0) {
                        label = label + ": " + lines[0];
                    }
                }
                t.printStackTrace();
                this.successful = false;
            }
            if (operation == null) {
                return;
            }
            if (this.output != null) {
                if (!mapped) {
                    this.output.print("//");
                }
                this.output.println("    " + operation.toJavaString());
                if (operation.getAndWait()) {
                    this.output.println("//    driver.pause(3000L);");
                }
                if (label != null) {
                    this.output.println("//  " + label);
                }
            }
            if (operation.isVerify() || operation.isWaitFor() || operation.isAssert()) {
                if (result == null) {
                    result = Boolean.FALSE;
                }
                boolean bl = this.successful = this.successful && (Boolean)result != false;
                if (result.equals(Boolean.FALSE) && mapped && this.output != null) {
                    this.output.println("//  ^^^ " + operation.getOperator() + " Failed ^^^");
                }
            }
            if (this.debug) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getResult() {
        if (!this.found) {
            System.err.println("!!! No valid selenese found");
        }
        if (this.driver != null) {
            this.driver.close();
            this.driver.quit();
        }
        return this.successful && this.found;
    }

    private static class RowVisitor
    extends NodeVisitor {
        private int col = 0;
        private String operator;
        private String operand1;
        private String operand2;

        public RowVisitor(PrintStream output) {
        }

        public void reset() {
            this.col = 0;
        }

        public Operation getOperation() {
            return new Operation(this.operator, this.operand1, this.operand2);
        }

        public void visitTag(Tag tag) {
            String name = tag.getTagName();
            if ("td".equalsIgnoreCase(name)) {
                if (this.col == 0) {
                    this.operator = tag.getChildren().asString();
                    ++this.col;
                } else if (this.col == 1) {
                    if (tag.getChildren() != null) {
                        this.operand1 = tag.getChildren().asString();
                        this.operand1 = StringEscapeUtils.unescapeHtml((String)this.operand1);
                    } else {
                        this.operand1 = null;
                    }
                    ++this.col;
                } else if (this.col == 2) {
                    if (tag.getChildren() != null) {
                        this.operand2 = tag.getChildren().asString();
                        this.operand2 = StringEscapeUtils.unescapeHtml((String)this.operand2);
                    } else {
                        this.operand2 = null;
                    }
                    this.reset();
                }
            }
        }
    }
}

