/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.Map;
import org.quartz.SchedulerContext;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.scheduling.quartz.SchedulerContextAware;

public class SpringBeanJobFactory
extends AdaptableJobFactory
implements SchedulerContextAware {
    private String[] ignoredUnknownProperties;
    private SchedulerContext schedulerContext;

    public void setIgnoredUnknownProperties(String ... ignoredUnknownProperties) {
        this.ignoredUnknownProperties = ignoredUnknownProperties;
    }

    @Override
    public void setSchedulerContext(SchedulerContext schedulerContext) {
        this.schedulerContext = schedulerContext;
    }

    @Override
    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object job = super.createJobInstance(bundle);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)job);
        if (this.isEligibleForPropertyPopulation(bw.getWrappedInstance())) {
            MutablePropertyValues pvs = new MutablePropertyValues();
            if (this.schedulerContext != null) {
                pvs.addPropertyValues((Map)this.schedulerContext);
            }
            pvs.addPropertyValues((Map)bundle.getJobDetail().getJobDataMap());
            pvs.addPropertyValues((Map)bundle.getTrigger().getJobDataMap());
            if (this.ignoredUnknownProperties != null) {
                for (String propName : this.ignoredUnknownProperties) {
                    if (!pvs.contains(propName) || bw.isWritableProperty(propName)) continue;
                    pvs.removePropertyValue(propName);
                }
                bw.setPropertyValues((PropertyValues)pvs);
            } else {
                bw.setPropertyValues((PropertyValues)pvs, true);
            }
        }
        return job;
    }

    protected boolean isEligibleForPropertyPopulation(Object jobObject) {
        return !(jobObject instanceof QuartzJobBean);
    }
}

