/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByAll
extends By
implements Serializable {
    private static final long serialVersionUID = 4573668832699497306L;
    private By[] bys;

    public ByAll(By ... bys) {
        this.bys = bys;
    }

    @Override
    public WebElement findElement(SearchContext context) {
        List<WebElement> elements = this.findElements(context);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return elements.get(0);
    }

    @Override
    public List<WebElement> findElements(SearchContext context) {
        ArrayList<WebElement> elems = new ArrayList<WebElement>();
        By[] byArray = this.bys;
        int n = this.bys.length;
        int n2 = 0;
        while (n2 < n) {
            By by = byArray[n2];
            elems.addAll(by.findElements(context));
            ++n2;
        }
        return elems;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("By.all(");
        stringBuilder.append("{");
        boolean first = true;
        By[] byArray = this.bys;
        int n = this.bys.length;
        int n2 = 0;
        while (n2 < n) {
            By by = byArray[n2];
            stringBuilder.append(first ? "" : ",").append(by);
            first = false;
            ++n2;
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }
}

