/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.io.Closeables;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinNT;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.Kernel32;
import org.openqa.selenium.os.WindowsUtils;

public class ProcessUtils {
    private static Logger LOG = Logger.getLogger(ProcessUtils.class.getName());

    private static int waitForProcessDeath(Process p, long timeout) {
        ProcessWaiter pw = new ProcessWaiter(p);
        Thread waiter = new Thread(pw);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for process", e);
        }
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        try {
            waiter.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for dead process waiter", e);
        }
        InterruptedException ie = pw.getException();
        if (ie != null) {
            throw new ProcessStillAliveException("Timeout waiting for process to die", ie);
        }
        return p.exitValue();
    }

    public static int killProcess(Process process) {
        if (WindowsUtils.thisIsWindows()) {
            return ProcessUtils.killWinProcess(process);
        }
        return ProcessUtils.killUnixProcess(process);
    }

    private static int killUnixProcess(Process process) {
        int exitValue;
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 1000L);
            ProcessUtils.closeAllStreamsAndDestroyProcess(process);
            if (exitValue == 0) {
                return exitValue;
            }
        }
        catch (Exception exception) {}
        process.destroy();
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
            ProcessUtils.closeAllStreamsAndDestroyProcess(process);
        }
        catch (ProcessStillAliveException ex) {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                throw ex;
            }
            try {
                LOG.info("Process didn't die after 10 seconds");
                ProcessUtils.kill9(process);
                exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
                ProcessUtils.closeAllStreamsAndDestroyProcess(process);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Process refused to die after 10 seconds, and couldn't kill9 it", ex);
                throw new RuntimeException("Process refused to die after 10 seconds, and couldn't kill9 it: " + e.getMessage(), ex);
            }
        }
        return exitValue;
    }

    private static int killWinProcess(Process process) {
        int exitValue;
        try {
            Field f = process.getClass().getDeclaredField("handle");
            f.setAccessible(true);
            long hndl = f.getLong(process);
            Kernel32 kernel = Kernel32.INSTANCE;
            WinNT.HANDLE handle = new WinNT.HANDLE();
            handle.setPointer(Pointer.createConstant((long)hndl));
            int pid = kernel.GetProcessId(handle);
            WindowsUtils.killPID("" + pid);
            exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Process refused to die after 10 seconds, and couldn't taskkill it", ex);
            throw new RuntimeException("Process refused to die after 10 seconds, and couldn't taskkill it: " + ex.getMessage(), ex);
        }
        return exitValue;
    }

    private static void closeAllStreamsAndDestroyProcess(Process process) {
        try {
            Closeables.close((Closeable)process.getInputStream(), (boolean)true);
            Closeables.close((Closeable)process.getErrorStream(), (boolean)true);
            Closeables.close((Closeable)process.getOutputStream(), (boolean)true);
        }
        catch (IOException iOException) {}
        process.destroy();
    }

    static int getProcessId(Process p) {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            throw new IllegalStateException("UnixUtils may not be used on Windows");
        }
        try {
            Field f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return (Integer)f.get(p);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't detect pid", e);
        }
    }

    private static void kill9(Integer pid) {
        LOG.fine("kill -9 " + pid);
        CommandLine command = new CommandLine("kill", "-9", pid.toString());
        command.execute();
        String result = command.getStdOut();
        int output = command.getExitCode();
        LOG.fine(String.valueOf(output));
        if (!command.isSuccessful()) {
            throw new RuntimeException("exec return code " + result + ": " + output);
        }
    }

    private static void kill9(Process p) {
        ProcessUtils.kill9(ProcessUtils.getProcessId(p));
    }

    public static class ProcessStillAliveException
    extends RuntimeException {
        public ProcessStillAliveException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ProcessWaiter
    implements Runnable {
        private volatile InterruptedException t;
        private final Process p;

        public ProcessWaiter(Process p) {
            this.p = p;
        }

        public InterruptedException getException() {
            return this.t;
        }

        @Override
        public void run() {
            try {
                this.p.waitFor();
            }
            catch (InterruptedException e) {
                this.t = e;
            }
        }
    }
}

