/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.Jenkins;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;

public class JenkinsBuild {
    private static Logger log = new Logger(JenkinsBuild.class.getName());
    protected Jenkins jenkins;
    protected String buildName;
    protected String queueURL;
    protected String buildURL;

    public JenkinsBuild(Jenkins jenkins, String buildName, String queueURL) {
        this.jenkins = jenkins;
        this.buildName = buildName;
        this.queueURL = queueURL;
    }

    public DataTypeMap queueStatus() throws Exception {
        DataTypeMap queueStatus = this.jenkins.jsonGet(this.queueURL);
        if (queueStatus != null && queueStatus.get((Object)"executable") != null) {
            this.buildURL = queueStatus.getMap((Object)"executable").getString((Object)"url");
            log.info((Object)(this.buildName + ": buildURL has become available: " + this.buildURL));
        }
        return queueStatus;
    }

    public DataTypeMap buildStatus() throws Exception {
        if (this.buildURL == null) {
            this.queueStatus();
        }
        if (this.buildURL == null) {
            return null;
        }
        return this.jenkins.jsonGet(this.buildURL);
    }

    public DataTypeMap waitForExecutionStart() throws Exception {
        DataTypeMap buildStatus;
        while ((buildStatus = this.buildStatus()) == null) {
            DataTypeMap queueStatus = this.queueStatus();
            if (queueStatus == null) {
                return null;
            }
            if (queueStatus.getBoolean((Object)"cancelled", false)) {
                log.info((Object)(this.buildName + ": build was cancelled - terminating block on waitForExecutionStart()"));
                log.info((Object)("buildStatus:" + DataTools.prettyPrint((Object)queueStatus)));
                return null;
            }
            if (queueStatus.getBoolean((Object)"stuck", false)) {
                log.info((Object)(this.buildName + ": build is stuck - terminating block on waitForExecutionStart()"));
                log.info((Object)("buildStatus:" + DataTools.prettyPrint((Object)queueStatus)));
                return null;
            }
            Thread.sleep(250L);
        }
        return buildStatus;
    }

    public DataTypeMap waitForExecutionComplete() throws Exception {
        DataTypeMap buildStatus = this.waitForExecutionStart();
        while (buildStatus != null) {
            if (buildStatus.getString((Object)"result") != null) {
                return buildStatus;
            }
            Thread.sleep(10000L);
            buildStatus = this.buildStatus();
        }
        return null;
    }

    public DataTypeMap waitForExecutionSuccess() throws Exception {
        DataTypeMap buildStatus = this.waitForExecutionComplete();
        if (buildStatus == null || !"SUCCESS".equals(buildStatus.getString((Object)"results"))) {
            return null;
        }
        return buildStatus;
    }
}

