/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.google.common.base.Function;
import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.Operation;
import com.isomorphic.webdriver.ScActions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class SmartClientWebDriver
implements WebDriver,
HasInputDevices,
TakesScreenshot,
JavascriptExecutor {
    private static final int WAIT_TIMEOUT_MILLIS = 30000;
    private static final int WAIT_QUANTUM_MILLIS = 100;
    private static final String COORDS_NO_CLICK_EX = "not clickable at point";
    private String baseUrl = "";
    private JavascriptExecutor js;
    private RemoteWebDriver driver;
    private ScActions actions;
    private boolean allowCoordClickOnOccludingElement;
    private boolean useFrameworkValueAsFallback = true;
    private int timeoutInMillis = 30000;
    private int[] keysDown = new int[256];
    private static final String GET_CURRENT_WINDOW = "selenium.browserbot.getCurrentWindow().";

    SmartClientWebDriver(RemoteWebDriver driver) {
        this.driver = driver;
        this.driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
        this.js = driver;
        Capabilities localCapabilities = driver.getCapabilities();
        ((DesiredCapabilities)localCapabilities).setJavascriptEnabled(true);
        this.actions = new ScActions(this);
    }

    private String appendScSeleniumQueryToURL(String url) {
        String baseUrl = url;
        String fragment = "";
        int index = url.indexOf(35);
        if (index >= 0) {
            fragment = url.substring(index);
            baseUrl = url.substring(0, index);
        }
        baseUrl = (index = baseUrl.indexOf(63)) >= 0 ? baseUrl + "&sc_selenium=true" : baseUrl + "?sc_selenium=true";
        return baseUrl + fragment;
    }

    public void setDefaultWaitTimeout(int timeoutInSeconds) {
        if (timeoutInSeconds <= 0) {
            throw new IllegalArgumentException("The default timeout must be positive");
        }
        this.timeoutInMillis = timeoutInSeconds * 1000;
    }

    public void setAllowCoordClickOnOccludingElement(boolean allow) {
        this.allowCoordClickOnOccludingElement = allow;
    }

    public boolean waitForElementClickable(By by) {
        return this.waitForElementClickable(by, 0);
    }

    public boolean waitForElementClickable(By by, int timeoutInSeconds) {
        return this.waitForJavascriptFunction(by, "isElementClickable", null, timeoutInSeconds * 1000);
    }

    public boolean waitForElementReadyForKeyPresses(By by) {
        return this.waitForElementReadyForKeyPresses(by, 0);
    }

    public boolean waitForElementReadyForKeyPresses(By by, int timeoutInSeconds) {
        return this.waitForJavascriptFunction(by, "isElementReadyForKeyPresses", null, timeoutInSeconds * 1000);
    }

    public boolean waitForGridDone(By by) {
        return this.waitForGridDone(by, 0);
    }

    public boolean waitForGridDone(By by, int timeoutInSeconds) {
        return this.waitForGridDone(by, null, 0);
    }

    public boolean waitForGridDone(By by, Boolean allowEdits) {
        return this.waitForGridDone(by, allowEdits, 0);
    }

    public boolean waitForGridDone(By by, Boolean allowEdits, int timeoutInSeconds) {
        return this.waitForJavascriptFunction(by, "isGridDone", allowEdits, timeoutInSeconds * 1000);
    }

    public boolean waitForSystemDone() {
        return this.waitForSystemDone(0);
    }

    public boolean waitForSystemDone(int timeoutInSeconds) {
        return this.waitForJavascriptFunction(null, "isSystemDone", null, timeoutInSeconds * 1000);
    }

    public boolean waitForElementPresent(By by) {
        return this.waitForElementPresent(by, 0);
    }

    public boolean waitForElementPresent(By by, int timeoutInSeconds) {
        return new Waiter(timeoutInSeconds * 1000){

            @Override
            boolean success(List<WebElement> results, String argument1, Object argument2) {
                return results.size() > 0;
            }
        }.waitFor(by, null, null);
    }

    public boolean waitForElementNotPresent(By by) {
        return this.waitForElementNotPresent(by, 0);
    }

    public boolean waitForElementNotPresent(By by, int timeoutInSeconds) {
        return new Waiter(timeoutInSeconds * 1000){

            @Override
            boolean success(List<WebElement> results, String argument1, Object argument2) {
                return results.size() == 0;
            }
        }.waitFor(by, null, null);
    }

    public boolean waitForText(By by, String string) {
        return this.waitForText(by, string, 0);
    }

    public boolean waitForText(By by, String targetText, int timeoutInSeconds) {
        return new Waiter(timeoutInSeconds * 1000){

            @Override
            boolean success(List<WebElement> results, String targetText, Object argument2) {
                return results.size() > 0 && targetText.equals(results.get(0).getText());
            }
        }.waitFor(by, targetText, null);
    }

    @Deprecated
    public boolean waitForText(String string, By by) {
        return this.waitForText(by, string);
    }

    public boolean waitForCondition(String javascript) {
        return this.waitForCondition(javascript, 0);
    }

    public boolean waitForCondition(String javascript, int timeoutInSeconds) {
        javascript = javascript.replace(GET_CURRENT_WINDOW, "");
        return new Waiter(timeoutInSeconds * 1000){

            @Override
            boolean success(List<WebElement> results, String javascript, Object argument2) {
                try {
                    if (Boolean.TRUE.equals(SmartClientWebDriver.this.js.executeScript(javascript, new Object[0]))) {
                        return true;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception in WebDriver." + javascript + ":" + e);
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }.waitFor(null, "return " + javascript, null);
    }

    private boolean waitForJavascriptFunction(final By by, String methodName, Object methodArg, int timeoutInMillis) {
        return new Waiter(timeoutInMillis){

            @Override
            boolean success(List<WebElement> results, String name, Object arg) {
                return by == null ? SmartClientWebDriver.this.performJavascriptFunction(null, name, arg) : results.size() > 0 && SmartClientWebDriver.this.performJavascriptFunction(results.get(0), name, arg);
            }
        }.waitFor(by, methodName, methodArg);
    }

    private boolean performJavascriptFunction(WebElement element, String methodName, Object methodArg) {
        try {
            Boolean done = (Boolean)this.js.executeScript("return isc.AutoTest." + methodName + "(arguments[0],arguments[1])", new Object[]{element, methodArg});
            if (Boolean.TRUE.equals(done)) {
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Exception in WebDriver." + methodName + ":" + e);
            e.printStackTrace(System.err);
        }
        return false;
    }

    public boolean waitForFrameToLoad(String frameLocator, int timeoutInSeconds) {
        WebDriverWait wait = new WebDriverWait((WebDriver)this.driver, (long)timeoutInSeconds);
        try {
            wait.until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)frameLocator));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public void pause(long waitInMillis) {
        try {
            Thread.sleep(waitInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private void reset() {
        for (int i = 0; i < this.keysDown.length; ++i) {
            this.keysDown[i] = 0;
        }
    }

    public void get(String relativeUrl) {
        this.get(relativeUrl, true);
    }

    public void get(String relativeUrl, boolean maximize) {
        this.driver.get(this.baseUrl + this.appendScSeleniumQueryToURL(relativeUrl));
        if (this.driver.getCapabilities().getCapability("nativeEvents") == null) {
            System.err.println("*** Warning: Native events are not enabled. You may need to update your WebDriver version ***");
        }
        if (maximize) {
            this.driver.manage().window().maximize();
        }
        this.reset();
    }

    public void showConsole() {
        this.js.executeScript("isc.showConsole()", new Object[0]);
    }

    public void setClientLogLevel(String category, int level) {
        this.js.executeScript("isc.Log.setPriority(category, isc.Log[" + level + "])", new Object[0]);
    }

    public void setClientLogLevel(String category, String level) {
        this.js.executeScript("isc.Log.setPriority(category, isc.Log['" + level + "'])", new Object[0]);
    }

    public void setServerLogLevel(String category, String level) {
        this.js.executeScript("var requestElement = document.createElement('IscSeleniumConfigureServerLogsElement');requestElement.setAttribute('arguments', ['" + category + "','" + level + "']);document.documentElement.appendChild(requestElement);var autWindowEvent = document.createEvent('Events');autWindowEvent.initEvent('IscSeleniumConfigureServerLogsEvent', true, false);requestElement.dispatchEvent(autWindowEvent);", new Object[0]);
    }

    public SmartClientWebDriver sendKeys(By by, CharSequence ... keysToSend) {
        WebElement element = this.findElement(by);
        if (element != null) {
            this.js.executeScript("var canvas = isc.AutoTest.locateCanvasFromDOMElement(arguments[0]); if (canvas) canvas.setFocus(true);", new Object[]{element});
        }
        this.actions.sendKeys(element, keysToSend).perform();
        return this;
    }

    public SmartClientWebDriver sendKeys(By by, String keysToSend) {
        return this.sendKeys(by, new CharSequence[]{keysToSend});
    }

    public SmartClientWebDriver type(By by) {
        return this.type(by, "");
    }

    public SmartClientWebDriver type(By by, String keysToSend) {
        WebElement e = this.findElement(by);
        this.actions.moveToElement(e).perform();
        this.findElement(by).click();
        this.findElement(by).clear();
        this.findElement(by).sendKeys(new CharSequence[]{keysToSend});
        return this;
    }

    public SmartClientWebDriver type(By by, Long keysToSend) {
        this.type(by, keysToSend.toString());
        return this;
    }

    public SmartClientWebDriver keyPress(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        if (this.keysDown[charToSend.intValue()] <= 0) {
            this.actions.sendKeys(null, new CharSequence[]{key}).perform();
        }
        return this;
    }

    public SmartClientWebDriver keyPress(By by, String keysToSend) {
        this.actions.sendKeys(null, keysToSend).perform();
        return this;
    }

    public SmartClientWebDriver keyDown(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        if (key.equals((Object)Keys.ENTER)) {
            this.actions.sendKeys(this.findElement(by), new CharSequence[]{key}).perform();
            return this;
        }
        try {
            if (this.keysDown[charToSend.intValue()] == 0) {
                this.keyDown(null, key);
            }
            int n = charToSend.intValue();
            this.keysDown[n] = this.keysDown[n] + 1;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: keyDown ignored for: " + charToSend + " @ " + by);
            e.printStackTrace(System.err);
        }
        return this;
    }

    private Keys getWebDriverKey(int seleniumCode) {
        switch (seleniumCode) {
            case 8: {
                return Keys.BACK_SPACE;
            }
            case 9: {
                return Keys.TAB;
            }
            case 13: {
                return Keys.ENTER;
            }
            case 16: {
                return Keys.SHIFT;
            }
            case 17: {
                return Keys.CONTROL;
            }
            case 32: {
                return Keys.SPACE;
            }
            case 35: {
                return Keys.END;
            }
            case 36: {
                return Keys.HOME;
            }
            case 37: {
                return Keys.ARROW_LEFT;
            }
            case 38: {
                return Keys.ARROW_UP;
            }
            case 39: {
                return Keys.ARROW_RIGHT;
            }
            case 40: {
                return Keys.ARROW_DOWN;
            }
            case 46: {
                return Keys.DELETE;
            }
        }
        System.err.println("Unmapped selenium keyCode: " + seleniumCode);
        return null;
    }

    public SmartClientWebDriver keyUp(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        try {
            int n = charToSend.intValue();
            this.keysDown[n] = this.keysDown[n] - 1;
            if (this.keysDown[charToSend.intValue()] == 0) {
                this.keyUp(null, key);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: keyUp ignored for: " + charToSend + " @ " + by);
        }
        return this;
    }

    public SmartClientWebDriver keyDown(By by, Keys theKey) {
        this.actions.keyDown(this.findElement(by), theKey).perform();
        return this;
    }

    public SmartClientWebDriver keyUp(By by, Keys theKey) {
        this.actions.keyUp(this.findElement(by), theKey).perform();
        return this;
    }

    SmartClientWebDriver shiftKeyDown(By by) {
        return this.keyDown(null, 16L);
    }

    SmartClientWebDriver shiftKeyUp(By by) {
        return this.keyUp(null, 16L);
    }

    public SmartClientWebDriver shiftKeyDown() {
        return this.shiftKeyDown(null);
    }

    public SmartClientWebDriver shiftKeyUp() {
        return this.shiftKeyUp(null);
    }

    public SmartClientWebDriver controlKeyDown() {
        return this.keyDown(null, 17L);
    }

    public SmartClientWebDriver controlKeyUp() {
        return this.keyUp(null, 17L);
    }

    private WebElement getElementFromPoint(Point point) {
        return (WebElement)this.js.executeScript("return document.elementFromPoint(arguments[0],arguments[1])", new Object[]{point.getX(), point.getY()});
    }

    private void internalClick(By by) {
        WebElement element = this.findElement(by);
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        this.internalClick(element, coordinates, false);
    }

    private void internalClick(WebElement element, Point coordinates, boolean nested) {
        try {
            this.actions.click(element, coordinates).perform();
        }
        catch (StaleElementReferenceException e) {
            System.err.println("Unable to click on coordinates offset from element " + element);
            e.printStackTrace(System.err);
            element.click();
        }
        catch (WebDriverException e) {
            String message = e.getMessage();
            if (message != null && message.toLowerCase().contains(COORDS_NO_CLICK_EX)) {
                WebElement occluding = null;
                if (!nested && this.allowCoordClickOnOccludingElement && (occluding = this.getElementFromPoint(coordinates)) != null) {
                    this.internalClick(occluding, coordinates, true);
                } else {
                    element.click();
                }
            }
            throw e;
        }
    }

    public SmartClientWebDriver click(By by) {
        this.js.executeScript("if (isc.EH._isSecondClick == null){ isc.EH._isSecondClick = false;}", new Object[0]);
        this.internalClick(by);
        this.js.executeScript("isc.EH._isSecondClick = null;", new Object[0]);
        return this;
    }

    public SmartClientWebDriver secondClick(By by) {
        this.js.executeScript("isc.EH._isSecondClick = true;", new Object[0]);
        this.internalClick(by);
        this.js.executeScript("isc.EH._isSecondClick = null;", new Object[0]);
        return this;
    }

    public SmartClientWebDriver doubleClick(By by) {
        return this.click(by).secondClick(by);
    }

    public SmartClientWebDriver clickAndHold(By by) {
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        this.actions.clickAndHold(this.findElement(by), coordinates).perform();
        return this;
    }

    public SmartClientWebDriver release(By by) {
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        this.actions.release(this.findElement(by), coordinates).perform();
        return this;
    }

    public SmartClientWebDriver contextClick(By by) {
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        this.actions.contextClick(this.findElement(by), coordinates).perform();
        return this;
    }

    public SmartClientWebDriver mouseMove(By by) {
        this.actions.moveToElement(this.driver.findElement(by)).perform();
        return this;
    }

    public SmartClientWebDriver dragAndDrop(By sourceBy, By targetBy) {
        this.actions.dragAndDrop(this.findElement(sourceBy), this.findElement(targetBy)).perform();
        return this;
    }

    public SmartClientWebDriver dragAndDrop(By sourceBy, String offset) {
        String[] xy = offset.split(",");
        return this.dragAndDropBy(sourceBy, Integer.parseInt(xy[0].replace("+", "")), Integer.parseInt(xy[1].replace("+", "")));
    }

    public SmartClientWebDriver dragAndDropBy(By sourceBy, int xOffset, int yOffset) {
        if (sourceBy instanceof ByScLocator) {
            ByScLocator locator = (ByScLocator)sourceBy;
            if (locator.isEdgeLocator()) {
                long width = (Long)this.js.executeScript("return isc.AutoTest.locateCanvasFromDOMElement(isc.AutoTest.getElement(arguments[0])).getVisibleWidth()", new Object[]{locator.getBaseLocator()});
                long height = (Long)this.js.executeScript("return isc.AutoTest.locateCanvasFromDOMElement(isc.AutoTest.getElement(arguments[0])).getVisibleHeight()", new Object[]{locator.getBaseLocator()});
                long margin = (Long)this.js.executeScript("return isc.AutoTest.locateCanvasFromDOMElement(isc.AutoTest.getElement(arguments[0])).edgeMarginSize", new Object[]{locator.getBaseLocator()});
                System.err.println("dims: " + width + "," + height + "," + margin);
                this.actions.dragEdgeAndDropBy(this.findElement(sourceBy), locator.getEdgeOffsetX(width, margin), locator.getEdgeOffsetY(height, margin), xOffset, yOffset).perform();
            } else {
                this.actions.dragAndDropBy(this.findElement(sourceBy), xOffset, yOffset).perform();
            }
        } else {
            this.actions.dragAndDropBy(this.findElement(sourceBy), xOffset, yOffset).perform();
        }
        return this;
    }

    private static boolean isValueMatch(Object expected, Object value) {
        boolean match;
        boolean bl = expected == null ? value == null : (match = expected.equals(value));
        if (!match) {
            System.err.println("Expected: '" + expected + "', found: '" + value + "'");
        }
        return match;
    }

    private static boolean isValueMatch(Long expected, String value) {
        return SmartClientWebDriver.isValueMatch((Object)(expected == null ? null : expected.toString()), (Object)value);
    }

    private static boolean isValueMatch(Long expected, Integer value) {
        return SmartClientWebDriver.isValueMatch(expected == null ? null : Integer.valueOf(expected.intValue()), (Object)value);
    }

    private static boolean isValueMatch(String expected, Integer value) {
        return SmartClientWebDriver.isValueMatch(expected == null ? null : Integer.valueOf(Integer.parseInt(expected)), (Object)value);
    }

    private static boolean isValueMatch(String expected, Long value) {
        return SmartClientWebDriver.isValueMatch((Object)(expected == null ? null : Long.valueOf(Long.parseLong(expected))), (Object)value);
    }

    private static boolean haveIntegers(String expected, Object value) {
        return value instanceof Integer && Operation.isInteger(expected);
    }

    private static boolean haveLongs(String expected, Object value) {
        return value instanceof Long && Operation.isLong(expected);
    }

    public Object getValue(By scLocator) {
        return this.js.executeScript("return isc.AutoTest.getValue(arguments[0])", new Object[]{((ByScLocator)scLocator).getLocatorString()});
    }

    public boolean verifyValue(By scLocator, Boolean expected) {
        Object value = this.getValue(scLocator);
        if (value instanceof Boolean) {
            return SmartClientWebDriver.isValueMatch(expected, (Boolean)value);
        }
        System.err.println("Non-Boolean found: '" + value + "'");
        return false;
    }

    public boolean verifyValue(By scLocator, Long expected) {
        Object value = this.getValue(scLocator);
        if (value instanceof Long) {
            return SmartClientWebDriver.isValueMatch((Object)expected, (Object)((Long)value));
        }
        if (value instanceof String) {
            return SmartClientWebDriver.isValueMatch(expected, (String)value);
        }
        if (value instanceof Integer) {
            return SmartClientWebDriver.isValueMatch(expected, (Integer)value);
        }
        System.err.println("Non-Long found: '" + value + "'");
        return false;
    }

    public boolean verifyValue(By scLocator, Integer expected) {
        return this.verifyValue(scLocator, new Long(expected.intValue()));
    }

    public boolean verifyValue(By scLocator, String expected) {
        Object value = this.getValue(scLocator);
        if (value instanceof String) {
            return SmartClientWebDriver.isValueMatch((Object)expected, (Object)((String)value));
        }
        if (SmartClientWebDriver.haveIntegers(expected, value)) {
            return SmartClientWebDriver.isValueMatch(expected, (Integer)value);
        }
        if (SmartClientWebDriver.haveLongs(expected, value)) {
            return SmartClientWebDriver.isValueMatch(expected, (Long)value);
        }
        System.err.println("Non-String found: '" + value + "'");
        return false;
    }

    public boolean assertEval(String javaScript, Boolean expected) {
        boolean match;
        Object result = this.js.executeScript(javaScript.replace(GET_CURRENT_WINDOW, ""), new Object[0]);
        boolean bl = expected == null ? result == null : (match = expected.equals(result));
        if (!match) {
            System.err.println("Expected: '" + expected + "', found: '" + result + "'");
        }
        return match;
    }

    public String getText(By scLocator) {
        WebElement element = this.findElement(scLocator);
        if (element == null) {
            return null;
        }
        this.js.executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
        String text = element.getText();
        if (text != null && text.length() > 0) {
            return text;
        }
        Object value = this.useFrameworkValueAsFallback ? this.getValue(scLocator) : element.getAttribute("value");
        return value != null ? value.toString() : "";
    }

    public boolean verifyText(By scLocator) {
        return this.verifyText(scLocator, "");
    }

    public boolean verifyText(By scLocator, String expected) {
        String value = this.getText(scLocator);
        if (expected == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        String pattern = expected.replaceAll("([-.,{}()|#\\^$\\[\\\\]+])", Pattern.quote("\\") + "$1").replace("*", ".*").replace("?", ".");
        boolean match = Pattern.matches(pattern.trim(), value.trim());
        if (!match) {
            System.err.println("Expected: '" + expected + "', found: '" + value + "'");
        }
        return match;
    }

    public String getTable(By scLocator, long row, long col) {
        WebElement element = this.findElement(scLocator);
        if (element == null) {
            return null;
        }
        return (String)this.js.executeScript("return isc.AutoTest.getTableCellValue(arguments[0],arguments[1],arguments[2])", new Object[]{element, row, col});
    }

    public boolean verifyTable(By scLocator, long row, long col, String expected) {
        WebElement element = this.findElement(scLocator);
        if (element == null) {
            return expected == null;
        }
        String cellValue = this.getTable(scLocator, row, col);
        if (cellValue == null) {
            return expected == null;
        }
        String pattern = expected.replaceAll("([-.,{}()|#\\^$\\[\\\\]+])", Pattern.quote("\\") + "$1").replace("*", ".*").replace("?", ".");
        boolean match = Pattern.matches(pattern.trim(), cellValue.trim());
        if (!match) {
            System.err.println("Expected: '" + expected + "', found: '" + cellValue + "'");
        }
        return match;
    }

    public boolean verifyTable(By scLocator, long row, long col) {
        return this.verifyTable(scLocator, row, col, "");
    }

    public void setUseFrameworkValueAsFallback(boolean useFrameworkValue) {
        this.useFrameworkValueAsFallback = useFrameworkValue;
    }

    @Deprecated
    public void setUseValueAsTextFallback(boolean useFrameworkValue) {
        this.setUseFrameworkValueAsFallback(useFrameworkValue);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        if (by == null) {
            return null;
        }
        return this.driver.findElement(by);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Keyboard getKeyboard() {
        return this.driver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.driver.getMouse();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)this.driver.getScreenshotAs(target);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.driver.executeAsyncScript(script, args);
    }

    public Object executeScript(String script, Object ... args) {
        return this.driver.executeScript(script, args);
    }

    private abstract class Waiter {
        private int timeoutInMillis;

        public Waiter(int timeoutInMillis) {
            this.timeoutInMillis = SmartClientWebDriver.this.timeoutInMillis;
            if (timeoutInMillis > 0) {
                this.timeoutInMillis = timeoutInMillis;
            }
        }

        List<WebElement> operation(By by) {
            if (by == null) {
                return Collections.emptyList();
            }
            return SmartClientWebDriver.this.findElements(by);
        }

        abstract boolean success(List<WebElement> var1, String var2, Object var3);

        public boolean waitFor(By by, String argument1, Object argument2) {
            int maximumTicks = this.timeoutInMillis / 100;
            try {
                for (int tick = 0; tick <= maximumTicks; ++tick) {
                    List<WebElement> elements = this.operation(by);
                    if (this.success(elements, argument1, argument2)) {
                        return true;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                System.err.println("WebDriver.waiter interrupted: " + e);
            }
            return false;
        }
    }
}

