/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.ParseProperty;
import org.w3c.tidy.TidyUtils;

public final class ParsePropertyImpl {
    static final ParseProperty INT = new ParseInt();
    static final ParseProperty BOOL = new ParseBoolean();
    static final ParseProperty INVBOOL = new ParseInvBoolean();
    static final ParseProperty CHAR_ENCODING = new ParseCharEncoding();
    static final ParseProperty NAME = new ParseName();
    static final ParseProperty TAGNAMES = new ParseTagNames();
    static final ParseProperty DOCTYPE = new ParseDocType();
    static final ParseProperty REPEATED_ATTRIBUTES = new ParseRepeatedAttribute();
    static final ParseProperty STRING = new ParseString();
    static final ParseProperty INDENT = new ParseIndent();
    static final ParseProperty CSS1SELECTOR = new ParseCSS1Selector();
    static final ParseProperty NEWLINE = new ParseNewLine();

    private ParsePropertyImpl() {
    }

    static class ParseNewLine
    implements ParseProperty {
        ParseNewLine() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            if ("lf".equalsIgnoreCase(string)) {
                configuration.newline = new char[]{'\n'};
            } else if ("cr".equalsIgnoreCase(string)) {
                configuration.newline = new char[]{'\r'};
            } else if ("crlf".equalsIgnoreCase(string)) {
                configuration.newline = new char[]{'\r', '\n'};
            } else {
                configuration.report.badArgument(string, string2);
            }
            return null;
        }

        public String getType() {
            return "Enum";
        }

        public String getOptionValues() {
            return "lf, crlf, cr";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            if (configuration.newline.length == 1) {
                return configuration.newline[0] == '\n' ? "lf" : "cr";
            }
            return "crlf";
        }
    }

    static class ParseCSS1Selector
    implements ParseProperty {
        ParseCSS1Selector() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = null;
            if (stringTokenizer.countTokens() >= 1) {
                string3 = stringTokenizer.nextToken() + "-";
            } else {
                configuration.report.badArgument(string, string2);
            }
            if (!Lexer.isCSS1Selector(string)) {
                configuration.report.badArgument(string, string2);
            }
            return string3;
        }

        public String getType() {
            return "Name";
        }

        public String getOptionValues() {
            return "CSS1 selector";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            return object == null ? "" : (String)object;
        }
    }

    static class ParseIndent
    implements ParseProperty {
        ParseIndent() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            boolean bl = configuration.indentContent;
            if ("yes".equalsIgnoreCase(string)) {
                bl = true;
                configuration.smartIndent = false;
            } else if ("true".equalsIgnoreCase(string)) {
                bl = true;
                configuration.smartIndent = false;
            } else if ("no".equalsIgnoreCase(string)) {
                bl = false;
                configuration.smartIndent = false;
            } else if ("false".equalsIgnoreCase(string)) {
                bl = false;
                configuration.smartIndent = false;
            } else if ("auto".equalsIgnoreCase(string)) {
                bl = true;
                configuration.smartIndent = true;
            } else {
                configuration.report.badArgument(string, string2);
            }
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }

        public String getType() {
            return "Indent";
        }

        public String getOptionValues() {
            return "auto, y/n, yes/no, t/f, true/false, 1/0";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            return object == null ? "" : object.toString();
        }
    }

    static class ParseString
    implements ParseProperty {
        ParseString() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            return string;
        }

        public String getType() {
            return "String";
        }

        public String getOptionValues() {
            return "-";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            return object == null ? "" : (String)object;
        }
    }

    static class ParseRepeatedAttribute
    implements ParseProperty {
        ParseRepeatedAttribute() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            int n;
            if ("keep-first".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("keep-last".equalsIgnoreCase(string)) {
                n = 0;
            } else {
                configuration.report.badArgument(string, string2);
                n = -1;
            }
            return new Integer(n);
        }

        public String getType() {
            return "Enum";
        }

        public String getOptionValues() {
            return "keep-first, keep-last";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            String string2;
            if (object == null) {
                return "";
            }
            int n = (Integer)object;
            switch (n) {
                case 1: {
                    string2 = "keep-first";
                    break;
                }
                case 0: {
                    string2 = "keep-last";
                    break;
                }
                default: {
                    string2 = "unknown";
                }
            }
            return string2;
        }
    }

    static class ParseDocType
    implements ParseProperty {
        ParseDocType() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            if ((string = string.trim()).startsWith("\"")) {
                configuration.docTypeMode = 4;
                return string;
            }
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if ("auto".equalsIgnoreCase(string3)) {
                configuration.docTypeMode = 1;
            } else if ("omit".equalsIgnoreCase(string3)) {
                configuration.docTypeMode = 0;
            } else if ("strict".equalsIgnoreCase(string3)) {
                configuration.docTypeMode = 2;
            } else if ("loose".equalsIgnoreCase(string3) || "transitional".equalsIgnoreCase(string3)) {
                configuration.docTypeMode = 3;
            } else {
                configuration.report.badArgument(string, string2);
            }
            return null;
        }

        public String getType() {
            return "DocType";
        }

        public String getOptionValues() {
            return "omit | auto | strict | loose | [fpi]";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            String string2;
            switch (configuration.docTypeMode) {
                case 1: {
                    string2 = "auto";
                    break;
                }
                case 0: {
                    string2 = "omit";
                    break;
                }
                case 2: {
                    string2 = "strict";
                    break;
                }
                case 3: {
                    string2 = "transitional";
                    break;
                }
                case 4: {
                    string2 = configuration.docTypeStr;
                    break;
                }
                default: {
                    string2 = "unknown";
                }
            }
            return string2;
        }
    }

    static class ParseTagNames
    implements ParseProperty {
        ParseTagNames() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            short s = 2;
            if ("new-inline-tags".equals(string2)) {
                s = 2;
            } else if ("new-blocklevel-tags".equals(string2)) {
                s = 4;
            } else if ("new-empty-tags".equals(string2)) {
                s = 1;
            } else if ("new-pre-tags".equals(string2)) {
                s = 8;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
            while (stringTokenizer.hasMoreTokens()) {
                configuration.definedTags |= s;
                configuration.tt.defineTag(s, stringTokenizer.nextToken());
            }
            return null;
        }

        public String getType() {
            return "Tag names";
        }

        public String getOptionValues() {
            return "tagX, tagY, ...";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            int n;
            if ("new-inline-tags".equals(string)) {
                n = 2;
            } else if ("new-blocklevel-tags".equals(string)) {
                n = 4;
            } else if ("new-empty-tags".equals(string)) {
                n = 1;
            } else if ("new-pre-tags".equals(string)) {
                n = 8;
            } else {
                return "";
            }
            List list = configuration.tt.findAllDefinedTag((short)n);
            if (list.isEmpty()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }

    static class ParseName
    implements ParseProperty {
        ParseName() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = null;
            if (stringTokenizer.countTokens() >= 1) {
                string3 = stringTokenizer.nextToken();
            } else {
                configuration.report.badArgument(string, string2);
            }
            return string3;
        }

        public String getType() {
            return "Name";
        }

        public String getOptionValues() {
            return "-";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            return object == null ? "" : object.toString();
        }
    }

    static class ParseCharEncoding
    implements ParseProperty {
        ParseCharEncoding() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            if ("raw".equalsIgnoreCase(string)) {
                configuration.rawOut = true;
            } else if (!TidyUtils.isCharEncodingSupported(string)) {
                configuration.report.badArgument(string, string2);
            } else if ("input-encoding".equalsIgnoreCase(string2)) {
                configuration.setInCharEncodingName(string);
            } else if ("output-encoding".equalsIgnoreCase(string2)) {
                configuration.setOutCharEncodingName(string);
            } else if ("char-encoding".equalsIgnoreCase(string2)) {
                configuration.setInCharEncodingName(string);
                configuration.setOutCharEncodingName(string);
            }
            return null;
        }

        public String getType() {
            return "Encoding";
        }

        public String getOptionValues() {
            return "Any valid java char encoding name";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            if ("output-encoding".equalsIgnoreCase(string)) {
                return configuration.getOutCharEncodingName();
            }
            return configuration.getInCharEncodingName();
        }
    }

    static class ParseInvBoolean
    implements ParseProperty {
        ParseInvBoolean() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            return (Boolean)BOOL.parse(string, string2, configuration) != false ? Boolean.FALSE : Boolean.TRUE;
        }

        public String getType() {
            return "Boolean";
        }

        public String getOptionValues() {
            return "yes, no, true, false";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            if (object == null) {
                return "";
            }
            return (Boolean)object != false ? "no" : "yes";
        }
    }

    static class ParseBoolean
    implements ParseProperty {
        ParseBoolean() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            Boolean bl = Boolean.TRUE;
            if (string != null && string.length() > 0) {
                char c = string.charAt(0);
                if (c == 't' || c == 'T' || c == 'Y' || c == 'y' || c == '1') {
                    bl = Boolean.TRUE;
                } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n' || c == '0') {
                    bl = Boolean.FALSE;
                } else {
                    configuration.report.badArgument(string, string2);
                }
            }
            return bl;
        }

        public String getType() {
            return "Boolean";
        }

        public String getOptionValues() {
            return "y/n, yes/no, t/f, true/false, 1/0";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            if (object == null) {
                return "";
            }
            return (Boolean)object != false ? "yes" : "no";
        }
    }

    static class ParseInt
    implements ParseProperty {
        ParseInt() {
        }

        public Object parse(String string, String string2, Configuration configuration) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                configuration.report.badArgument(string, string2);
                n = -1;
            }
            return new Integer(n);
        }

        public String getType() {
            return "Integer";
        }

        public String getOptionValues() {
            return "0, 1, 2, ...";
        }

        public String getFriendlyName(String string, Object object, Configuration configuration) {
            return object == null ? "" : object.toString();
        }
    }
}

