/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.log.Logger;
import com.isomorphic.velocity.StoredRecordHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EditedRecordHandler
implements Map {
    private static final String CLASS_NAME = EditedRecordHandler.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    private StoredRecordHandler storedRecord;
    private Map editedRecord;
    private Map combinedRecord;

    public EditedRecordHandler(StoredRecordHandler storedRecordHandler) {
        this.storedRecord = storedRecordHandler;
        this.editedRecord = null;
        this.combinedRecord = null;
    }

    public void reset() {
        this.editedRecord = null;
        this.combinedRecord = null;
    }

    private void prepareEditedRecord() {
        this.editedRecord = this.storedRecord.validationContext != null ? new HashMap(this.storedRecord.validationContext.getCurrentRecord()) : new HashMap();
    }

    private void prepareCombinedRecord() {
        this.storedRecord.warnOnNoRecord = false;
        this.combinedRecord = new HashMap(this.storedRecord);
        this.combinedRecord.putAll(this.editedRecord);
    }

    @Override
    public int size() {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.containsValue(value);
    }

    public Object get(Object key) {
        if (this.editedRecord == null) {
            this.prepareEditedRecord();
        }
        if (this.editedRecord.containsKey(key)) {
            return this.editedRecord.get(key);
        }
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.get(key);
    }

    public Object put(Object key, Object value) {
        if (this.editedRecord == null) {
            this.prepareEditedRecord();
        }
        if (this.editedRecord.containsKey(key)) {
            if (this.combinedRecord == null) {
                return this.editedRecord.put(key, value);
            }
            this.combinedRecord.put(key, value);
            return this.editedRecord.put(key, value);
        }
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.put(key, value);
    }

    public Object remove(Object key) {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.remove(key);
    }

    public void putAll(Map m) {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        this.combinedRecord.putAll(m);
    }

    @Override
    public void clear() {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        this.combinedRecord.clear();
    }

    public Set keySet() {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.keySet();
    }

    public Collection values() {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.values();
    }

    public Set entrySet() {
        if (this.combinedRecord == null) {
            this.prepareCombinedRecord();
        }
        return this.combinedRecord.entrySet();
    }
}

