/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();

    public TransactionManagerMV2PL(Database database) {
        this.database = database;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new LongKeyHashMap(8192);
        this.txModel = 1;
        this.catalogNameList = new HsqlNameManager.HsqlName[]{this.database.getCatalogName()};
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public void setGlobalChangeTimestamp(long l) {
        this.globalChangeTimestamp.set(l);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 1;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        this.writeLock.lock();
        try {
            int n;
            int n2 = session.rowActionList.size();
            session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            for (n = 0; n < n2; ++n) {
                RowAction rowAction = (RowAction)session.rowActionList.get(n);
                rowAction.prepareCommit(session);
            }
            n = 1;
            return n != 0;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] objectArray;
            int n;
            int n2 = session.rowActionList.size();
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (n = 0; n < n2; ++n) {
                objectArray = (Object[])session.rowActionList.get(n);
                objectArray.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            n = session.rowActionList.size();
            if (n > n2) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(objectArray, n2, n, session.actionTimestamp);
                this.finaliseRows(session, objectArray, n2, n);
                session.rowActionList.setSize(n2);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                objectArray = session.rowActionList.getArray();
                this.mergeTransaction(objectArray, 0, n2, session.actionTimestamp);
                this.finaliseRows(session, objectArray, 0, n2);
            } else {
                objectArray = session.rowActionList.toArray();
                this.addToCommittedQueue(session, objectArray);
            }
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.actionSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int n, long l) {
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                rowAction.rollback(session, l);
                int n3 = rowAction.mergeRollback(session, l, row);
                if (rowAction.type == 3) {
                    if (rowAction.deleteComplete) continue;
                    rowAction.deleteComplete = true;
                }
                rowAction.store.rollbackRow(session, row, n3, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction;
        Row row2 = row;
        synchronized (row2) {
            switch (table.tableType) {
                case 5: {
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                    this.addTransactionInfo(row);
                    break;
                }
                case 3: {
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                    persistentStore.delete(session, row);
                    row.rowAction = null;
                    break;
                }
                default: {
                    rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                }
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        persistentStore.indexRow(session, row);
        if (table.persistenceScope == 20) {
            row.rowAction = null;
            return;
        }
        session.rowActionList.add(rowAction);
    }

    @Override
    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        if (rowAction.table.tableType == 3) {
            return true;
        }
        return rowAction.canRead(session, 0);
    }

    @Override
    public boolean canRead(Session session, PersistentStore persistentStore, long l, int n) {
        if (persistentStore.getTable().tableType == 3) {
            return true;
        }
        RowAction rowAction = (RowAction)this.rowActionMap.get(l);
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n);
    }

    @Override
    public void addTransactionInfo(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        if (row.getTable().tableType == 5) {
            this.rowActionMap.put(cachedObject.getPos(), row.rowAction);
        }
    }

    @Override
    public void setTransactionInfo(PersistentStore persistentStore, CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        Row row = (Row)cachedObject;
        if (row.getTable().tableType == 5) {
            RowAction rowAction;
            row.rowAction = rowAction = (RowAction)this.rowActionMap.get(row.getPos());
        }
    }

    @Override
    public void removeTransactionInfo(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        this.rowActionMap.remove(cachedObject.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionInfo(long l) {
        this.rowActionMap.getWriteLock().lock();
        try {
            RowAction rowAction;
            RowAction rowAction2 = rowAction = (RowAction)this.rowActionMap.get(l);
            synchronized (rowAction2) {
                if (rowAction.type == 0) {
                    this.rowActionMap.remove(l);
                }
            }
        }
        finally {
            this.rowActionMap.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long l2 = 0L;
            Object[] objectArray = null;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionTimestamps.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
                session.isPreTransaction = false;
                session.isTransaction = true;
                ++this.transactionCount;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        this.writeLock.lock();
        try {
            boolean bl;
            if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = statement = session.statementManager.getStatement(session, statement);
                if (statement == null) {
                    return;
                }
            }
            if (bl = this.setWaitedSessionsTPL(session, statement)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isPreTransaction = false;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void resetSession(Session session, Session session2, int n) {
        super.resetSession(session, session2, n);
    }

    private void endTransaction(Session session) {
        long l = session.transactionTimestamp;
        int n = this.liveTransactionTimestamps.indexOf(l);
        if (n >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }
}

