/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.auth.DevModeAuthFilter;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.RPCDMI;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.RequestContext;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RPCRequest
extends BaseRequest<RPCRequest, RPCResponse> {
    private static Logger log = new Logger(RPCRequest.class.getName());
    private Object data;

    public RPCRequest() {
    }

    public RPCRequest(Object data) {
        this(null, data, null);
    }

    public RPCRequest(RPCManager rpcManager, Object data, RequestContext context) {
        super(rpcManager, rpcManager != null ? rpcManager.getDsTransaction() : null);
        this.data = data;
        this.context = context;
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    public Object getData() {
        return this.data;
    }

    public RPCRequest setData(Object data) {
        this.data = data;
        return this;
    }

    public boolean isDMI() {
        return RPCDMI.isDMIRequest(this);
    }

    public String getAppID() {
        if (this.data == null) {
            return null;
        }
        return (String)((Map)this.data).get("appID");
    }

    public String getServerObjectID() {
        if (this.data == null) {
            return null;
        }
        return (String)((Map)this.data).get("className");
    }

    public String getMethodName() {
        if (this.data == null) {
            return null;
        }
        return (String)((Map)this.data).get("methodName");
    }

    public List getMethodArguments() {
        if (this.data == null) {
            return null;
        }
        return (List)((Map)this.data).get("arguments");
    }

    @Override
    public RPCResponse execute() throws Exception {
        log.info("Executing " + this.getAppID() + "." + this.getMethodName());
        if (this.isDMI()) {
            DSTransaction dsTransaction = this.getDsTransaction();
            if (dsTransaction != null && dsTransaction.isSkipRemainingQueue()) {
                RPCResponse rpcResponse = new RPCResponse();
                rpcResponse.setStatus(4);
                dsTransaction.registerResponse(this, rpcResponse);
                return rpcResponse;
            }
            String appID = this.getAppID();
            boolean devModeAuthorized = false;
            if (this.context != null && this.context.request != null) {
                if (DevModeAuthFilter.devModeAuthorized((HttpServletRequest)this.context.request)) {
                    devModeAuthorized = true;
                } else if (config.getBoolean((Object)"RPCManager.superuserRole.enablesAllBuiltinRPCs", false)) {
                    String superuserRole = config.getString("authentication.superuserRole");
                    if (superuserRole == null) {
                        log.error("configured to authorize devMode for superuserRole, but authentication.superuserRole not set in server.properties - NOT enabling devmode");
                    } else {
                        devModeAuthorized = this.context.request.isUserInRole(superuserRole);
                        log.info("superuserRole detected, dev mode authorized");
                    }
                }
            }
            if ("isc_builtin".equals(appID) && !config.getBoolean((Object)"RPCManager.enableBuiltinRPCs", false) && !devModeAuthorized) {
                throw new Exception("Received Builtin RPC request, but they are disabled in config - ignoring request.  To enable BuiltinRPCs, set RPCManager.enableBuiltinRPCs: true in server.properties, but note that these are development-only tools not audited from a security standpoint for production use.");
            }
            if (devModeAuthorized) {
                String userId = DevModeAuthFilter.getAuthorizedUserId((HttpServletRequest)this.context.request);
                log.info("DevMode Authorized for userId: " + userId + " enabling BuiltinRPC execution.");
            }
            return RPCDMI.execute(this, this.getRPCManager(), this.context, devModeAuthorized);
        }
        throw new Exception("Received non-DMI RPCRequest in IDACall - ignoring.  To send generic RPCRequests, you should override the actionURL property either on the RPCRequest or globally via RPCManager.actionURL.");
    }

    @Override
    public void commit(DSTransaction dsTransaction) throws Exception {
    }

    @Override
    public void rollback(DSTransaction dsTransaction) throws Exception {
    }
}

