/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.annotations.DataSourceAnnotations;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.hibernate.HibernateDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.store.DataStructCache;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EntityType;
import org.hibernate.type.EnumType;
import org.hibernate.type.Type;

public class HibernateDSGenerator {
    private static final String CLASS_NAME = HibernateDSGenerator.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);

    public static DataSource fromTable(String tableName, String schema) throws Exception {
        return HibernateDSGenerator.fromTable(tableName, schema, tableName, true, null);
    }

    public static DataSource fromTable(String tableName, String schema, boolean cacheDS) throws Exception {
        return HibernateDSGenerator.fromTable(tableName, schema, tableName, cacheDS, null);
    }

    public static DataSource fromTable(String tableName, String schema, String ID) throws Exception {
        return HibernateDSGenerator.fromTable(tableName, schema, ID, true, null);
    }

    public static DataSource fromTable(String tableName, String schema, String ID, boolean cacheDS, Map overriddenFields) throws Exception {
        Connection conn = HibernateDataSource.getConnection();
        DataSource ds = SQLDataSource.fromTable((Connection)conn, (String)tableName, (String)schema, (String)ID, (String)"hibernate", null, null, (boolean)cacheDS, (Map)overriddenFields, null);
        HibernateDataSource.freeConnection(conn);
        return ds;
    }

    public static Map getConfigFromTable(String tableName, String schema) throws Exception {
        Connection conn = HibernateDataSource.getConnection();
        Map config = SQLDataSource.getConfigFromTable((Connection)conn, (String)tableName, (String)schema, (String)tableName, (String)"hibernate", null, null, null, null);
        HibernateDataSource.freeConnection(conn);
        return config;
    }

    public static Object getConfigFromJavaClass(String className, String ID, boolean isAutoDeriveDS, Map deriverConfig) throws Exception {
        Config iscConfig;
        Class c = Reflection.classForName((String)className);
        if (c == null) {
            Package p = Package.getPackage(className);
            if (p == null) {
                return "Package not found for Class: " + className;
            }
            return "Class not found: " + className;
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (ID == null) {
            ID = c.getSimpleName();
        }
        config.put("ID", ID);
        config.put("dataSourceVersion", String.valueOf(1));
        config.put("serverType", "hibernate");
        config.put("beanClassName", className);
        config.put("__autoConstruct", "DataSource");
        if (isAutoDeriveDS) {
            config.put("_inheritsFrom", "true");
        }
        if ((iscConfig = Config.getGlobal()) != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        List fields = Reflection.getBeanFields((String)className);
        config.put("fields", fields);
        return config;
    }

    public static DataSource fromMapping(String entityName) throws Exception {
        return HibernateDSGenerator.fromMapping(entityName, null, false, null);
    }

    public static DataSource fromMapping(String entityName, String ID) throws Exception {
        return HibernateDSGenerator.fromMapping(entityName, ID, false, null);
    }

    public static DataSource fromMapping(String entityName, String ID, boolean isAutoDeriveDS) throws Exception {
        return HibernateDSGenerator.fromMapping(entityName, ID, isAutoDeriveDS, null);
    }

    public static DataSource fromMapping(String entityName, String ID, boolean isAutoDeriveDS, Map deriverConfig) throws Exception {
        Map config = HibernateDSGenerator.getConfigFromMapping(entityName, ID, false, false, deriverConfig);
        if (config == null) {
            return null;
        }
        config.put("__autoConstruct", "DataSource");
        if (isAutoDeriveDS) {
            config.put("_inheritsFrom", "true");
            ID = ID + "_inheritsFrom";
        }
        DataSource ds = DataSource.fromConfig((Map)config, null);
        DataStructCache.addCachedObjectWithNoConfigFile((String)ID, (Object)ds);
        return ds;
    }

    public static Map getConfigFromMapping(String entityName, String ID, boolean generateRelations, boolean extended) throws Exception {
        return HibernateDSGenerator.getConfigFromMapping(entityName, ID, generateRelations, extended, null);
    }

    public static Map getConfigFromMapping(String entityName, String ID, boolean generateRelations, boolean extended, Map deriverConfig) throws Exception {
        Configuration cfg = null;
        if (deriverConfig != null && deriverConfig.get("configBean") != null) {
            log.debug((Object)("Obtaining local Hibernate config for DataSource '" + ID + "' via Spring bean '" + deriverConfig.get("configBean") + "'."));
            HashMap<String, String> serverObjectConfig = new HashMap<String, String>();
            serverObjectConfig.put("bean", "&" + deriverConfig.get("configBean"));
            serverObjectConfig.put("lookupStyle", "spring");
            Map spring = HibernateDataSource.initSpringConfigAndSessionFactory(serverObjectConfig);
            if (spring == null) {
                log.error((Object)("Attempted lookup of DataSource-specific Hibernate config for DataSource '" + ID + "' failed; the returned object was null.  We will use the system-level config instead."));
            } else {
                cfg = (Configuration)spring.get("config");
            }
        }
        if (cfg == null) {
            cfg = HibernateDataSource.getStaticHibernateConfig();
        }
        Map<String, Object> config = HibernateDSGenerator.getConfigFromMapping(cfg, entityName, ID, generateRelations, extended);
        if (deriverConfig != null && deriverConfig.get("configBean") != null) {
            config.put("configBean", deriverConfig.get("configBean"));
        }
        return config;
    }

    public static Map<String, Object> getConfigFromMapping(Configuration cfg, String entityName, String ID, boolean generateRelations, boolean extended) throws Exception {
        PersistentClass clazz = cfg.getClassMapping(entityName);
        if (clazz != null) {
            Class mappedClass = clazz.getMappedClass();
            if (ID == null) {
                ID = entityName.substring(entityName.lastIndexOf(46) + 1);
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            log.debug((Object)("Generating data source '" + ID + "' for entity " + entityName));
            config.put("ID", ID);
            config.put("serverType", "hibernate");
            config.put("entityName", entityName);
            if (clazz.hasPojoRepresentation()) {
                config.put("beanClassName", mappedClass.getName());
            }
            config.put("dropExtraFields", Boolean.TRUE);
            config.put("allowAdvancedCriteria", Boolean.TRUE);
            Config iscConfig = Config.getGlobal();
            if (iscConfig != null) {
                String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
                config.put("generatedBy", version);
            }
            ArrayList<Map<String, Object>> dsFields = new ArrayList<Map<String, Object>>();
            if (clazz.hasIdentifierProperty()) {
                Property identifierProperty = clazz.getIdentifierProperty();
                List<Map<String, Object>> fields = HibernateDSGenerator.getDSField(clazz.getIdentifierProperty(), generateRelations, extended);
                for (Map<String, Object> field : fields) {
                    field.put("primaryKey", Boolean.TRUE);
                    Boolean generated = (Boolean)field.get("autoGenerated");
                    if (generated == null || !generated.booleanValue()) continue;
                    if ("integer".equals(field.get("type"))) {
                        field.put("type", "sequence");
                        field.remove("autoGenerated");
                    }
                    field.put("hidden", Boolean.TRUE);
                    field.put("canEdit", Boolean.FALSE);
                    field.put("required", Boolean.FALSE);
                }
                dsFields.addAll(fields);
                if (identifierProperty.getType() instanceof ComponentType) {
                    config.put("idClassName", identifierProperty.getType().getReturnedClass().getName());
                    config.put("extIsEmbeddedId", Boolean.TRUE);
                }
            } else {
                Component identifierMapper = clazz.getIdentifierMapper();
                Iterator properties = identifierMapper.getPropertyIterator();
                while (properties.hasNext()) {
                    Property property = (Property)properties.next();
                    List<Map<String, Object>> fields = HibernateDSGenerator.getDSField(property, generateRelations, extended);
                    for (Map<String, Object> field : fields) {
                        field.put("primaryKey", Boolean.TRUE);
                        Boolean generated = (Boolean)field.get("autoGenerated");
                        if (generated == null || !generated.booleanValue()) continue;
                        if ("integer".equals(field.get("type"))) {
                            field.put("type", "sequence");
                            field.remove("autoGenerated");
                        }
                        field.put("hidden", Boolean.TRUE);
                        field.put("canEdit", Boolean.FALSE);
                        field.put("required", Boolean.FALSE);
                    }
                    dsFields.addAll(fields);
                }
                config.put("idClassName", clazz.getIdentifier().getType().getReturnedClass().getName());
                config.put("extIsEmbeddedId", Boolean.FALSE);
            }
            Iterator properties = clazz.getPropertyIterator();
            while (properties.hasNext()) {
                Property property = (Property)properties.next();
                dsFields.addAll(HibernateDSGenerator.getDSField(property, generateRelations, extended));
            }
            if (generateRelations) {
                for (Map map : dsFields) {
                    String role = (String)map.get("role");
                    if (role == null) continue;
                    Collection roleMapping = cfg.getCollectionMapping(role);
                    map.put("javaClass", roleMapping.getElement().getType().getReturnedClass().getName());
                    String relationIdName = roleMapping.getElement().getType().getName();
                    relationIdName = relationIdName.substring(relationIdName.lastIndexOf(46) + 1);
                    map.put("type", relationIdName);
                    if (roleMapping.getReferencedPropertyName() != null) {
                        map.put("foreignKey", relationIdName + "." + roleMapping.getReferencedPropertyName());
                    }
                    map.remove("role");
                }
            }
            config.put("fields", dsFields);
            log.debug((Object)("Generated data source configuration: " + config));
            return config;
        }
        return null;
    }

    public static List<Map<String, Object>> getDSField(Property property, boolean generateRelations, boolean extended) throws Exception {
        ArrayList<Map<String, Object>> dsFields = new ArrayList<Map<String, Object>>();
        if (!property.isSynthetic() && !"_identifierMapper".equals(property.getName())) {
            Type type = property.getType();
            Value value = property.getValue();
            if (property.isComposite()) {
                Component componentValue = (Component)property.getValue();
                Iterator propertyIterator = componentValue.getPropertyIterator();
                while (propertyIterator.hasNext()) {
                    List<Map<String, Object>> fields = HibernateDSGenerator.getDSField((Property)propertyIterator.next(), generateRelations, extended);
                    for (Map<String, Object> field : fields) {
                        String valueXPath = (String)field.get("valueXPath");
                        valueXPath = valueXPath != null ? property.getName() + "/" + valueXPath : property.getName() + "/" + field.get("name");
                        field.put("valueXPath", valueXPath);
                        field.put("name", property.getName() + "_" + field.get("name"));
                    }
                    dsFields.addAll(fields);
                }
            } else if (type.isAssociationType()) {
                if (generateRelations) {
                    if (type instanceof EntityType) {
                        EntityType entityType = (EntityType)type;
                        HashMap<String, Object> dsField = new HashMap<String, Object>();
                        dsField.put("name", property.getName());
                        String relationIdName = entityType.getAssociatedEntityName();
                        relationIdName = relationIdName.substring(relationIdName.lastIndexOf(46) + 1);
                        dsField.put("type", relationIdName);
                        if (!entityType.isReferenceToPrimaryKey()) {
                            dsField.put("foreignKey", relationIdName + "." + entityType.getRHSUniqueKeyPropertyName());
                        }
                        if (property.isOptional()) {
                            dsField.put("required", Boolean.FALSE);
                        } else {
                            dsField.put("required", Boolean.TRUE);
                        }
                        if (extended) {
                            if (property.isLazy()) {
                                dsField.put("extIsLazy", Boolean.TRUE);
                            } else {
                                dsField.put("extIsLazy", Boolean.FALSE);
                            }
                        }
                        if (property.isInsertable() || property.isUpdateable()) {
                            dsField.put("canEdit", Boolean.TRUE);
                        } else {
                            dsField.put("canEdit", Boolean.FALSE);
                        }
                        if (value.getColumnSpan() == 1) {
                            Column column = (Column)value.getColumnIterator().next();
                            dsField.put("length", column.getLength());
                            if (extended) {
                                dsField.put("extPrecision", column.getPrecision());
                                dsField.put("extScale", column.getScale());
                                dsField.put("extIsUnique", column.isUnique());
                            }
                        }
                        dsFields.add(dsField);
                    } else if (type instanceof CollectionType) {
                        CollectionType collectionType = (CollectionType)type;
                        HashMap<String, Object> dsField = new HashMap<String, Object>();
                        dsField.put("name", property.getName());
                        if (extended) {
                            if (property.isLazy()) {
                                dsField.put("extIsLazy", Boolean.TRUE);
                            } else {
                                dsField.put("extIsLazy", Boolean.FALSE);
                            }
                        }
                        if (property.isInsertable() || property.isUpdateable()) {
                            dsField.put("canEdit", Boolean.TRUE);
                        } else {
                            dsField.put("canEdit", Boolean.FALSE);
                        }
                        dsField.put("multiple", Boolean.TRUE);
                        dsField.put("role", collectionType.getRole());
                        dsFields.add(dsField);
                    }
                }
            } else {
                SimpleValue simpleValue;
                CustomType customType;
                HashMap<String, Object> dsField = new HashMap<String, Object>();
                dsField.put("name", property.getName());
                dsField.put("type", DataSourceAnnotations.dsTypeForJavaType((Class)type.getReturnedClass()));
                if (type instanceof CustomType && (customType = (CustomType)type).getUserType() instanceof EnumType) {
                    EnumType enumType = (EnumType)customType.getUserType();
                    int sqlType = enumType.sqlTypes()[0];
                    if (sqlType == -6 || sqlType == 5 || sqlType == 4 || sqlType == -5 || sqlType == 6 || sqlType == 7 || sqlType == 8 || sqlType == 2 || sqlType == 3) {
                        Map values = Reflection.getEnumValues((Class)enumType.returnedClass(), (boolean)true);
                        dsField.put("type", "intEnum");
                        dsField.put("valueMap", values);
                    } else {
                        Map values = Reflection.getEnumValues((Class)enumType.returnedClass(), (boolean)false);
                        dsField.put("type", "enum");
                        dsField.put("valueMap", values);
                    }
                }
                if (type instanceof AbstractSingleColumnStandardBasicType) {
                    AbstractSingleColumnStandardBasicType singleColumnType = (AbstractSingleColumnStandardBasicType)type;
                    int sqlType = singleColumnType.sqlType();
                    if (sqlType == 91) {
                        dsField.put("type", "date");
                    } else if (sqlType == 92) {
                        dsField.put("type", "time");
                    }
                }
                if (property.isOptional()) {
                    dsField.put("required", Boolean.FALSE);
                } else {
                    dsField.put("required", Boolean.TRUE);
                }
                if (extended) {
                    if (property.isLazy()) {
                        dsField.put("extIsLazy", Boolean.TRUE);
                    } else {
                        dsField.put("extIsLazy", Boolean.FALSE);
                    }
                }
                if (property.isInsertable() || property.isUpdateable()) {
                    dsField.put("canEdit", Boolean.TRUE);
                } else {
                    dsField.put("canEdit", Boolean.FALSE);
                }
                if (value.getColumnSpan() == 1) {
                    Column column = (Column)value.getColumnIterator().next();
                    dsField.put("length", column.getLength());
                    if (extended) {
                        dsField.put("extPrecision", column.getPrecision());
                        dsField.put("extScale", column.getScale());
                        dsField.put("extIsUnique", column.isUnique());
                    }
                }
                if (value instanceof SimpleValue && (simpleValue = (SimpleValue)value).getIdentifierGeneratorStrategy() != null && !"assigned".equals(simpleValue.getIdentifierGeneratorStrategy())) {
                    dsField.put("autoGenerated", Boolean.TRUE);
                }
                dsFields.add(dsField);
            }
        }
        return dsFields;
    }

    public static List getMappedClasses(boolean excludeNullMappings) throws Exception {
        Configuration cfg = HibernateDataSource.getStaticHibernateConfig();
        return HibernateDSGenerator.getMappedClasses(cfg, excludeNullMappings);
    }

    public static List getMappedClasses(Configuration cfg, boolean excludeNullMappings) throws Exception {
        ArrayList classes = new ArrayList();
        Iterator i = HibernateDataSource.getStaticHibernateConfig().getClassMappings();
        while (i.hasNext()) {
            PersistentClass pc = (PersistentClass)i.next();
            if (excludeNullMappings && pc.getClassName() == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("entityName", pc.getEntityName());
            map.put("className", pc.getClassName());
            classes.add(map);
        }
        return classes;
    }
}

