/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.interfaces.IServletCompression;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ServletCompression;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class RequestContext {
    public static Config config;
    public static Logger staticLog;
    public Logger log;
    public JSTranslater jsTrans;
    protected IServletCompression compression;
    public ServletContext servletContext;
    protected static final ThreadLocal<Stack> requestContextStackContainer;
    public ISCHttpServletRequest request;
    public HttpServletResponse response;
    public HttpSession session;
    protected Writer out = null;
    public boolean clientContextHeaderSent = false;
    public boolean cachingEnabled = true;
    public String contentType = null;
    public String requestPath;
    public String servletPath;
    public String pathInfo;
    private Locale locale;

    public static void pushThreadLocal(RequestContext requestContext) {
        Stack<RequestContext> requestContextStack = requestContextStackContainer.get();
        if (requestContextStack == null) {
            requestContextStack = new Stack<RequestContext>();
            requestContextStackContainer.set(requestContextStack);
        }
        requestContextStack.push(requestContext);
    }

    public static RequestContext getThreadLocal() {
        Stack requestContextStack = requestContextStackContainer.get();
        if (requestContextStack != null && !requestContextStack.isEmpty()) {
            return (RequestContext)requestContextStack.peek();
        }
        return null;
    }

    public static RequestContext popThreadLocal() {
        Stack requestContextStack = requestContextStackContainer.get();
        if (requestContextStack != null) {
            try {
                return (RequestContext)requestContextStack.pop();
            }
            catch (EmptyStackException ese) {
                staticLog.warn((Object)"No stack in popThreadLocal()", ese);
            }
        }
        return null;
    }

    public static void purgeThreadLocal() {
        requestContextStackContainer.remove();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.request.getLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static RequestContext instance(PageContext pageContext) throws Exception {
        return RequestContext.instance(pageContext.getServletContext(), pageContext.getRequest(), pageContext.getResponse());
    }

    public static RequestContext instance(ServletRequest request, ServletResponse response) throws Exception {
        return RequestContext.instance(null, request, response);
    }

    public static RequestContext instance(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return RequestContext.instance(servlet.getServletConfig().getServletContext(), (ServletRequest)request, (ServletResponse)response);
    }

    public static RequestContext instance(Servlet servlet, HttpServletRequest request, HttpServletResponse response, Writer out) throws Exception {
        RequestContext context = RequestContext.instance(servlet.getServletConfig().getServletContext(), (ServletRequest)request, (ServletResponse)response);
        context.setOut(out);
        return context;
    }

    public static RequestContext instance(ServletContext servletContext, ServletRequest request, ServletResponse response) throws Exception {
        RequestContext context = new RequestContext();
        if (RequestContext.getThreadLocal() == null) {
            RequestContext.pushThreadLocal(context);
        }
        context.init(servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
        return context;
    }

    public RequestContext() {
    }

    public RequestContext(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.init(servlet.getServletConfig().getServletContext(), request, response);
    }

    public void init(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (servletContext != null) {
            Init.go(servletContext, true);
            this.servletContext = servletContext;
        }
        if (config == null) {
            config = Config.getGlobal();
            if (staticLog == null) {
                staticLog = new Logger(RequestContext.class.getName());
            }
        }
        this.requestPath = RequestContext.getRequestPath(request);
        this.servletPath = request.getServletPath();
        this.pathInfo = request.getPathInfo();
        this.log = new Logger(RequestContext.class.getName());
        this.request = request instanceof ISCHttpServletRequest ? (ISCHttpServletRequest)request : new ISCHttpServletRequest(request);
        this.response = response;
        if (response instanceof ProxyHttpServletResponse) {
            this.contentType = ((ProxyHttpServletResponse)response).iscGetContentType();
        }
        this.jsTrans = JSTranslater.instance();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Paths for request:\nServlet path: '" + request.getServletPath() + "'\nRequest URI: '" + request.getRequestURI() + "'\nPath Info: '" + request.getPathInfo() + "'\nPath Translated: '" + request.getPathTranslated() + (servletContext != null ? "'\nReal FileSystem Path: '" + servletContext.getRealPath(this.requestPath) : "") + "'");
            if (config.getBoolean((Object)"requestContext.reportParams", false)) {
                this.log.debug("Request parameters: " + this.getParamsAsString());
            }
        }
        if (this.log.isInfoEnabled()) {
            boolean alreadyLoggedURL;
            String cgetHeader = request.getHeader("If-Modified-Since");
            boolean isCGET = cgetHeader != null && !"".equals(cgetHeader);
            boolean bl = alreadyLoggedURL = request.getAttribute("isc_alreadyLoggedURL") != null;
            if (!(isCGET && !this.log.isDebugEnabled() || alreadyLoggedURL)) {
                request.setAttribute("isc_alreadyLoggedURL", new Object());
                this.log.info((isCGET ? "CGET " : "") + "URL: '" + this.requestPath + "', User-Agent: '" + request.getHeader("User-Agent") + "': " + ServletTools.getBrowserSummary(this));
            }
        }
        if (config.getBoolean((Object)"servlet.logCookies", false)) {
            this.logCookies();
        }
        if (config.getBoolean((Object)"servlet.logHeaders", false)) {
            this.logHeaders();
        }
    }

    public void logCookies() {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.getCookiesAsString());
        }
    }

    public String getCookiesAsString() {
        String output = "Cookies:";
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            output = output + " NONE";
            return output;
        }
        for (int ii = 0; ii < cookies.length; ++ii) {
            output = output + "\nName: '" + cookies[ii].getName() + "', value: '" + cookies[ii].getValue() + "', domain: '" + cookies[ii].getDomain() + "', path: '" + cookies[ii].getPath() + "', maxAge: '" + cookies[ii].getMaxAge() + "', isSecure: '" + cookies[ii].getSecure() + "'";
        }
        return output;
    }

    public void logHeaders() {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.getHeadersAsString());
        }
    }

    public String getHeadersAsString() {
        String output = "Client HTTP Headers:";
        Enumeration headers = this.request.getHeaderNames();
        if (headers == null) {
            output = output + " request.getHeaderNames() returned null";
        } else {
            while (headers.hasMoreElements()) {
                String headerName = (String)headers.nextElement();
                output = output + "\n" + headerName + ": " + this.request.getHeader(headerName);
            }
        }
        return output;
    }

    public String getParamsAsString() throws Exception {
        return this.jsTrans.toJS(this.request.getParams());
    }

    public static String getRequestPath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public final void sendClientContextHeader() {
        if (this.clientContextHeaderSent) {
            return;
        }
        this.clientContextHeaderSent = true;
        this._sendClientContextHeader();
    }

    protected void _sendClientContextHeader() {
    }

    public void setNoCacheHeaders() throws Exception {
        if (this.response.isCommitted()) {
            throw new Exception("Response has already been committed, unable to setNoCacheHeaders()");
        }
        if (this.cachingEnabled) {
            RequestContext.setNoCacheHeaders(this.response);
            this.cachingEnabled = false;
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        if (staticLog != null) {
            staticLog.debug("Setting headers to disable caching");
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", System.currentTimeMillis());
    }

    public void setContentType(String contentType) throws IOException {
        this.setContentType(contentType, false);
    }

    public void setContentType(String contentType, boolean skipWarning) throws IOException {
        if (this.contentType != null && !contentType.equals(this.contentType)) {
            this.log.warning("Content type has already been set to: " + this.contentType + " - setting to: " + contentType);
        }
        this.contentType = contentType;
        RequestContext.setContentType(contentType, this.response);
    }

    public static void setContentType(String contentType, HttpServletResponse response) {
        response.setContentType(contentType);
    }

    public boolean compressIfPossible() {
        if (this.compression != null) {
            return true;
        }
        try {
            this.compression = (IServletCompression)InterfaceProvider.load("IServletCompression");
        }
        catch (Exception e) {
            if (ServletTools.compressionEnabled()) {
                this.log.error((Object)"Compresion enabled in config, but compression module not present - unable to compress", e);
            }
            return false;
        }
        return this.compression.compressIfPossible(this);
    }

    public boolean _compressIfPossibleLocal() {
        if (this.compression != null) {
            return true;
        }
        this.compression = new ServletCompression();
        return this.compression.compressIfPossible(this);
    }

    public Writer out() throws IOException {
        if (this.out == null) {
            this.log.debug("Getting output stream via servletResponse.getWriter()");
            if (this.contentType == null) {
                if (this.response instanceof ProxyHttpServletResponse) {
                    this.contentType = ((ProxyHttpServletResponse)this.response).iscGetContentType();
                }
                if (this.contentType == null) {
                    this.setContentType(config.getString("requestContext.defaultMimeType", "text/html"));
                }
            }
            this.setOut(this.response.getWriter());
        }
        return this.out;
    }

    public void setOut(Writer out) throws IOException {
        if (this.out != null) {
            throw new IOException("The output stream has already been set");
        }
        this.out = out;
    }

    public void completeResponse() throws Exception {
        if (this.out == null) {
            this.log.debug("out is null, completeResponse() ignored");
            return;
        }
        try {
            this.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.compression != null) {
            this.compression.completeResponse(this);
        }
        try {
            this.response.flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        requestContextStackContainer = new ThreadLocal();
    }
}

