/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentificationVariableDeclaration
extends AbstractExpression {
    private boolean hasSpace;
    private AbstractExpression joins;
    private boolean parsingJoinExpression;
    private AbstractExpression rangeVariableDeclaration;

    public IdentificationVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRangeVariableDeclaration().accept(visitor);
        this.getJoins().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRangeVariableDeclaration());
        children.add(this.getJoins());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.rangeVariableDeclaration != null) {
            children.add(this.rangeVariableDeclaration);
        }
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.joins != null) {
            children.add(this.joins);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getJoins());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public Expression getJoins() {
        if (this.joins == null) {
            this.joins = this.buildNullExpression();
        }
        return this.joins;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("identification_variable_declaration");
    }

    public Expression getRangeVariableDeclaration() {
        if (this.rangeVariableDeclaration == null) {
            this.rangeVariableDeclaration = this.buildNullExpression();
        }
        return this.rangeVariableDeclaration;
    }

    public boolean hasJoins() {
        return this.joins != null && !this.joins.isNull();
    }

    public boolean hasRangeVariableDeclaration() {
        return this.rangeVariableDeclaration != null && !this.rangeVariableDeclaration.isNull();
    }

    public boolean hasSpace() {
        return this.hasSpace;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (this.parsingJoinExpression) {
            return !word.equalsIgnoreCase("INNER") && !word.equalsIgnoreCase("JOIN") && !word.equalsIgnoreCase("OUTER") && !word.equalsIgnoreCase("LEFT") && super.isParsingComplete(wordParser, word, expression);
        }
        return word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || word.equalsIgnoreCase("OUTER") || word.equalsIgnoreCase("IN") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            this.rangeVariableDeclaration = this.parse(wordParser, "range_variable_declaration", tolerant);
        } else {
            this.rangeVariableDeclaration = new RangeVariableDeclaration(this);
            this.rangeVariableDeclaration.parse(wordParser, tolerant);
        }
        int count = wordParser.skipLeadingWhitespace();
        this.parsingJoinExpression = true;
        this.joins = this.parse(wordParser, "join*", tolerant);
        if (!this.hasJoins() && wordParser.character() != ',') {
            wordParser.moveBackward(count);
        } else {
            this.hasSpace = count > 0;
        }
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return this.parsingJoinExpression;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.rangeVariableDeclaration != null) {
            this.rangeVariableDeclaration.toParsedText(writer, actual);
        }
        if (this.hasSpace && (actual || this.hasJoins())) {
            writer.append(' ');
        }
        if (this.joins != null) {
            this.joins.toParsedText(writer, actual);
        }
    }
}

