/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

public class MessagingWebSocketEndpoint
extends Endpoint
implements ServerApplicationConfig {
    protected static Config config;
    protected static Logger log;
    protected static JSTranslater jsTrans;
    static int keepaliveInterval;
    static int connectionTTL;
    static int keepaliveReestablishDelay;
    static int connectTimeout;
    protected String connectionID = null;
    protected ISCMessageDispatcher dispatcher = null;
    protected ISubscriber subscriber = null;
    protected Session session = null;
    protected RemoteEndpoint.Basic remoteEndpointBasic = null;
    protected RemoteEndpoint.Async remoteEndpointAsync = null;

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.session = session;
        if (config.getBoolean((Object)"messaging.websocket.async", false)) {
            this.remoteEndpointAsync = session.getAsyncRemote();
            long sendTimeout = config.getLong((Object)"messaging.websocket.async.timeout", -1L);
            if (sendTimeout != -1L) {
                this.remoteEndpointAsync.setSendTimeout(sendTimeout);
            } else {
                sendTimeout = this.remoteEndpointAsync.getSendTimeout();
            }
            log.debug((Object)("Using async endpoint (messaging.websocket.async: true, timeout: " + sendTimeout + ")"));
            try {
                this.remoteEndpointAsync.setBatchingAllowed(false);
            }
            catch (IOException iOException) {}
        } else {
            log.debug((Object)"Using synchronous endpoint (messaging.websocket.async: false)");
            this.remoteEndpointBasic = session.getBasicRemote();
            try {
                this.remoteEndpointBasic.setBatchingAllowed(false);
            }
            catch (IOException sendTimeout) {
                // empty catch block
            }
        }
        try {
            Map queryParams = ServletTools.parseQueryString((String)session.getQueryString());
            this.connectionID = (String)queryParams.get("connectionID");
            Map channels = (Map)jsTrans.fromJS((String)queryParams.get("subscribedChannels"));
            String subscriberImpl = config.getString((Object)"messaging.subscriberImplementer");
            this.subscriber = new ISCWebSocketSubscriber(this);
            this.dispatcher = ISCMessageDispatcher.instance();
            this.dispatcher.register(this.subscriber);
            this.dispatcher.subscribe(this.subscriber, channels);
            session.addMessageHandler((MessageHandler)new ISCMessageHandler(this));
            this.sendConnectCallback();
        }
        catch (Exception e) {
            log.error((Object)"Exception onOpen", (Throwable)e);
            this.cleanup();
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.cleanup();
    }

    public void onError(Session session, Throwable thr) {
        this.cleanup();
    }

    public void cleanup() {
        log.debug((Object)"calling cleanup()");
        if (this.dispatcher != null) {
            if (this.subscriber != null) {
                try {
                    this.dispatcher.unregister(this.subscriber);
                    this.subscriber = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.dispatcher.stop();
            this.dispatcher = null;
        }
        if (this.remoteEndpointBasic != null) {
            this.remoteEndpointBasic = null;
        }
        if (this.remoteEndpointAsync != null) {
            this.remoteEndpointAsync = null;
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendText(String message) throws Exception {
        if (this.remoteEndpointAsync != null) {
            RemoteEndpoint.Async async = this.remoteEndpointAsync;
            synchronized (async) {
                this.remoteEndpointAsync.sendText(message).get();
                return;
            }
        }
        RemoteEndpoint.Basic basic = this.remoteEndpointBasic;
        synchronized (basic) {
            this.remoteEndpointBasic.sendText(message);
        }
    }

    public void sendKeepalive() throws Exception {
        String message = "{  command: 'keepalive'  ,connectionID: '" + this.connectionID + "'}";
        this.doSendText(message);
    }

    public void sendConnectCallback() throws Exception {
        String message = "{  command: 'connectCallback'  ,connectionID: '" + this.connectionID + "'  ,config: {    keepaliveInterval: " + keepaliveInterval + "    ,connectionTTL: " + connectionTTL + "    ,connectTimeout: " + connectTimeout + "    ,keepaliveReestablishDelay: " + keepaliveReestablishDelay + "  }}";
        this.doSendText(message);
    }

    public void sendMessage(ISCMessage msg) throws Exception {
        DataTypeMap messageMap = DataTools.buildMap((Object[])new Object[]{"connectionID", this.connectionID, "channels", msg.getTargetChannels(), "id", msg.getID(), "data", msg.getData()});
        this.doSendText(jsTrans.toJS((Object)messageMap));
    }

    public void terminateConnection() throws Exception {
        String message = "{  command: 'serverConnTerminate'  ,connectionID: '" + this.connectionID + "'}";
        this.doSendText(message);
    }

    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> scanned) {
        HashSet<ServerEndpointConfig> result = new HashSet<ServerEndpointConfig>();
        if (!config.getBoolean((Object)"messaging.websocket.enabled", false)) {
            log.debug((Object)"Websocket support disabled via server.properties setting: messaging.websocket.enabled");
            return result;
        }
        String endpointURI = config.getString((Object)"messaging.websocket.URI");
        log.info((Object)("Registering Realtime Messaging endpoint at: " + endpointURI));
        result.add(ServerEndpointConfig.Builder.create(MessagingWebSocketEndpoint.class, (String)endpointURI).build());
        return result;
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return scanned;
    }

    static {
        ISCInit.go((String)MessagingWebSocketEndpoint.class.getName());
        config = Config.getGlobal();
        log = new Logger(MessagingWebSocketEndpoint.class.getName());
        jsTrans = JSTranslater.instance();
        keepaliveInterval = config.getInt((Object)"messaging.websocket.keepaliveInterval", -1);
        connectionTTL = config.getInt((Object)"messaging.websocket.connectionTTL", 0);
        keepaliveReestablishDelay = config.getInt((Object)"messaging.websocket.keepaliveReestablishDelay", -1);
        connectTimeout = config.getInt((Object)"messaging.websocket.connectTimeout", -1);
    }

    private static class ISCMessageHandler
    implements MessageHandler.Whole<String> {
        MessagingWebSocketEndpoint webSocketEndpoint;

        private ISCMessageHandler(MessagingWebSocketEndpoint webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
        }

        public void onMessage(String message) {
            try {
                Map envelope = (Map)jsTrans.fromJS(message);
                String command = (String)envelope.get("command");
                if (command != null) {
                    if ("send".equals(command)) {
                        List channels = (List)envelope.get("sendToChannels");
                        Object data = envelope.get("data");
                        ISCMessage msg = new ISCMessage(channels, data);
                        this.webSocketEndpoint.dispatcher.deliver(msg);
                    }
                    if ("keepalive".equals(command)) {
                        this.webSocketEndpoint.sendKeepalive();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failure in onMessage handler", (Throwable)e);
            }
        }
    }

    private static class ISCWebSocketSubscriber
    implements ISubscriber {
        MessagingWebSocketEndpoint webSocketEndpoint;

        private ISCWebSocketSubscriber(MessagingWebSocketEndpoint webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
        }

        @Override
        public void send(ISCMessage message) throws Exception {
            try {
                this.webSocketEndpoint.sendMessage(message);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to deliver messsage " + message.getID() + " to channel(s): " + message.getTargetChannels()), (Throwable)e);
                this.webSocketEndpoint.cleanup();
            }
        }

        @Override
        public ISCMessage nextMessage(long timeout) throws Exception {
            throw new Exception("nextMessage() not supported");
        }
    }
}

