/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.grid;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.drawing.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;

/**
 * A ListGrid is a {@link com.smartgwt.client.widgets.DataBoundComponent} that displays a list of objects in a grid, where
 * each row represents one object and each cell in the row represents one property.
 * @see com.smartgwt.client.docs.Editing Editing overview and related methods
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("ListGrid")
public class ListGrid extends VLayout implements DataBoundComponent, com.smartgwt.client.widgets.grid.events.HasCellSavedHandlers, com.smartgwt.client.widgets.grid.events.HasCellClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellErrorIconHoverHandlers, com.smartgwt.client.widgets.grid.events.HasCellErrorIconOutHandlers, com.smartgwt.client.widgets.grid.events.HasCellErrorIconOverHandlers, com.smartgwt.client.widgets.grid.events.HasCellHoverHandlers, com.smartgwt.client.widgets.grid.events.HasCellMouseDownHandlers, com.smartgwt.client.widgets.grid.events.HasCellMouseUpHandlers, com.smartgwt.client.widgets.grid.events.HasCellOutHandlers, com.smartgwt.client.widgets.grid.events.HasCellOverHandlers, com.smartgwt.client.widgets.grid.events.HasCellSelectionChangedHandlers, com.smartgwt.client.widgets.grid.events.HasCellValueHoverHandlers, com.smartgwt.client.widgets.grid.events.HasDataArrivedHandlers, com.smartgwt.client.widgets.grid.events.HasDataChangedHandlers, com.smartgwt.client.widgets.grid.events.HasDrawAreaChangedHandlers, com.smartgwt.client.widgets.grid.events.HasEditCompleteHandlers, com.smartgwt.client.widgets.grid.events.HasEditFailedHandlers, com.smartgwt.client.widgets.grid.events.HasEditorEnterHandlers, com.smartgwt.client.widgets.grid.events.HasEditorExitHandlers, com.smartgwt.client.widgets.grid.events.HasFieldStateChangedHandlers, com.smartgwt.client.widgets.grid.events.HasFilterEditorSubmitHandlers, com.smartgwt.client.widgets.events.HasFormulaUpdatedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupByCompleteHandlers, com.smartgwt.client.widgets.grid.events.HasGroupStateChangedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupByHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderHoverHandlers, com.smartgwt.client.widgets.grid.events.HasHilitesChangedHandlers, com.smartgwt.client.widgets.grid.events.HasBodyKeyPressHandlers, com.smartgwt.client.widgets.grid.events.HasRecordCollapseHandlers, com.smartgwt.client.widgets.grid.events.HasRecordExpandHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordDropHandlers, com.smartgwt.client.widgets.grid.events.HasRemoveRecordClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasRowContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasRowEditorEnterHandlers, com.smartgwt.client.widgets.grid.events.HasRowEditorExitHandlers, com.smartgwt.client.widgets.grid.events.HasRowHoverHandlers, com.smartgwt.client.widgets.grid.events.HasRowMouseDownHandlers, com.smartgwt.client.widgets.grid.events.HasRowMouseUpHandlers, com.smartgwt.client.widgets.grid.events.HasRowOutHandlers, com.smartgwt.client.widgets.grid.events.HasRowOverHandlers, com.smartgwt.client.widgets.grid.events.HasSelectionChangedHandlers, com.smartgwt.client.widgets.grid.events.HasSelectionUpdatedHandlers, com.smartgwt.client.widgets.grid.events.HasSetSortHandlers, com.smartgwt.client.widgets.grid.events.HasSortChangedHandlers, com.smartgwt.client.widgets.grid.events.HasSorterClickHandlers, com.smartgwt.client.widgets.grid.events.HasSorterContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasViewStateChangedHandlers {

    public static ListGrid getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new ListGrid(jsObj);
        } else {
            assert refInstance instanceof ListGrid;
            return (ListGrid)refInstance;
        }
    }

    private static final ListGrid TEST_INSTANCE = new ListGrid();
    static {
        TEST_INSTANCE.setID("isc_ListGrid_testInstance");
    }

    @Override
    protected ListGrid getTestInstance() {
        return TEST_INSTANCE;
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ListGrid.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.ListGrid.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(ListGrid.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.ListGrid.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public ListGrid(){
        setModalEditing(true);scClassName = "ListGrid";
    }

    public ListGrid(JavaScriptObject jsObj){
        scClassName = "ListGrid";
        setJavaScriptObject(jsObj);
    }


    public ListGrid(DataSource dataSource) {
        setDataSource(dataSource);
                setModalEditing(true);scClassName = "ListGrid";
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;

    // ********************* Properties / Attributes ***********************

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set, total
     * number of available fields that must be present in the grid before the advanced field picker interface is used instead
     * of the normal columns submenu. <P> Set to 0 to have the advanced picker always used (when useAdvancedFieldPicker is
     * true).
     *
     * @param advancedFieldPickerThreshold New advancedFieldPickerThreshold value. Default value is 25
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAdvancedFieldPickerThreshold(int advancedFieldPickerThreshold)  throws IllegalStateException {
        setAttribute("advancedFieldPickerThreshold", advancedFieldPickerThreshold, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set, total
     * number of available fields that must be present in the grid before the advanced field picker interface is used instead
     * of the normal columns submenu. <P> Set to 0 to have the advanced picker always used (when useAdvancedFieldPicker is
     * true).
     *
     * @return Current advancedFieldPickerThreshold value. Default value is 25
     */
    public int getAdvancedFieldPickerThreshold()  {
        return getAttributeAsInt("advancedFieldPickerThreshold");
    }
    

    /**
     * For use with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}:true, allows simple
     * search expressions to be entered into filter fields, as though {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getAllowExpressions DynamicForm.allowExpressions} were true. <P> This
     * attribute can also be set at the {@link com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterExpressions field
     * level}.
     *
     * @param allowFilterExpressions New allowFilterExpressions value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAllowFilterExpressions(Boolean allowFilterExpressions)  throws IllegalStateException {
        setAttribute("allowFilterExpressions", allowFilterExpressions, false);
    }

    /**
     * For use with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}:true, allows simple
     * search expressions to be entered into filter fields, as though {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getAllowExpressions DynamicForm.allowExpressions} were true. <P> This
     * attribute can also be set at the {@link com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterExpressions field
     * level}.
     *
     * @return Current allowFilterExpressions value. Default value is null
     */
    public Boolean getAllowFilterExpressions()  {
        return getAttributeAsBoolean("allowFilterExpressions");
    }
    

    /**
     * Causes a menu item titled {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterUsingText "Filter using"} to appear
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} that allows the end
     * user to pick an advanced {@link com.smartgwt.client.types.OperatorId search operator} to use for this field. <p> Once an
     * operator has been chosen, the active operator is indicated by an {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} placed within the field (you can alternatively
     * cause the icon to {@link com.smartgwt.client.widgets.grid.ListGrid#getAlwaysShowOperatorIcon always be present}).  The
     * <code>operatorIcon</code>  shows the same textual representation of the search operator as is used by the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getAllowExpressions FormItem.allowExpressions} feature.  Clicking on
     * the icon provides a second way to  modify the search operator.   <p> This feature is enabled by default if {@link
     * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria DataSource.supportsAdvancedCriteria()} is true,  for all
     * fields where it is normally possible to filter by typing in a search string.  This  excludes field types such as "date"
     * or "boolean" which show specialized filter controls.   Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterOperators ListGridField.allowFilterOperators} to disable
     * this interface for individual  fields, or set {@link com.smartgwt.client.data.DataSourceField#getCanFilter
     * DataSourceField.canFilter} to false to disallow filtering entirely for  a field. <p> Note that this feature is similar
     * to {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions}, which allows  the
     * end users to directly type in characters such as "&gt;" to control filtering. <code>allowFilterOperators</code> is
     * easier to use and more discoverable than <code>allowFilterExpressions</code>, and also avoids the drawback where special
     * characters  like "&gt;" cannot be used in filter values.  However, <code>allowFilterExpressions</code>  allows users to
     * make use of certain operators that <code>allowFilterOperators</code> does  not support, such as using the
     * "betweenInclusive" operator by typing "5...10". <P> When both <code>allowfilterExpressions</code> and
     * <code>allowFilterOperators</code> are set, filter expressions entered in to the edit-area are parsed and the operator
     * automatically  applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon}.
     *
     * @param allowFilterOperators New allowFilterOperators value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAllowFilterOperators(Boolean allowFilterOperators)  throws IllegalStateException {
        setAttribute("allowFilterOperators", allowFilterOperators, false);
    }

    /**
     * Causes a menu item titled {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterUsingText "Filter using"} to appear
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} that allows the end
     * user to pick an advanced {@link com.smartgwt.client.types.OperatorId search operator} to use for this field. <p> Once an
     * operator has been chosen, the active operator is indicated by an {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} placed within the field (you can alternatively
     * cause the icon to {@link com.smartgwt.client.widgets.grid.ListGrid#getAlwaysShowOperatorIcon always be present}).  The
     * <code>operatorIcon</code>  shows the same textual representation of the search operator as is used by the {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getAllowExpressions FormItem.allowExpressions} feature.  Clicking on
     * the icon provides a second way to  modify the search operator.   <p> This feature is enabled by default if {@link
     * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria DataSource.supportsAdvancedCriteria()} is true,  for all
     * fields where it is normally possible to filter by typing in a search string.  This  excludes field types such as "date"
     * or "boolean" which show specialized filter controls.   Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAllowFilterOperators ListGridField.allowFilterOperators} to disable
     * this interface for individual  fields, or set {@link com.smartgwt.client.data.DataSourceField#getCanFilter
     * DataSourceField.canFilter} to false to disallow filtering entirely for  a field. <p> Note that this feature is similar
     * to {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions}, which allows  the
     * end users to directly type in characters such as "&gt;" to control filtering. <code>allowFilterOperators</code> is
     * easier to use and more discoverable than <code>allowFilterExpressions</code>, and also avoids the drawback where special
     * characters  like "&gt;" cannot be used in filter values.  However, <code>allowFilterExpressions</code>  allows users to
     * make use of certain operators that <code>allowFilterOperators</code> does  not support, such as using the
     * "betweenInclusive" operator by typing "5...10". <P> When both <code>allowfilterExpressions</code> and
     * <code>allowFilterOperators</code> are set, filter expressions entered in to the edit-area are parsed and the operator
     * automatically  applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon}.
     *
     * @return Current allowFilterOperators value. Default value is null
     */
    public Boolean getAllowFilterOperators()  {
        return getAttributeAsBoolean("allowFilterOperators");
    }
    

    /**
     * Should cells in this grid be allowed to span multiple rows? If set to <code>true</code>, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} method will be called for every cell when rendering
     * out the listGrid to determine how many rows the cell should span. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} for more details
     *
     * @param allowRowSpanning New allowRowSpanning value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAllowRowSpanning(Boolean allowRowSpanning)  throws IllegalStateException {
        setAttribute("allowRowSpanning", allowRowSpanning, false);
    }

    /**
     * Should cells in this grid be allowed to span multiple rows? If set to <code>true</code>, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} method will be called for every cell when rendering
     * out the listGrid to determine how many rows the cell should span. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} for more details
     *
     * @return Current allowRowSpanning value. Default value is false
     */
    public Boolean getAllowRowSpanning()  {
        Boolean result = getAttributeAsBoolean("allowRowSpanning");
        return result == null ? false : result;
    }
    

    /**
     * Optional css style to apply to the body if {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles
     * alternateRecordStyles} is true for this grid. If unset {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName
     * bodyStyleName} will be used to style the body regardless of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles} setting.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateBodyStyleName alternateBodyStyleName} for this listGrid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param alternateBodyStyleName new body style name when showing alternateRecordStyles. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setAlternateBodyStyleName(String alternateBodyStyleName) {
        setAttribute("alternateBodyStyleName", alternateBodyStyleName, true);
    }

    /**
     * Optional css style to apply to the body if {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles
     * alternateRecordStyles} is true for this grid. If unset {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName
     * bodyStyleName} will be used to style the body regardless of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles} setting.
     *
     * @return Current alternateBodyStyleName value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getAlternateBodyStyleName()  {
        return getAttributeAsString("alternateBodyStyleName");
    }
    

    /**
     * The number of consecutive columns to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternateColumnStyles} is true.
     *
     * @param alternateFieldFrequency New alternateFieldFrequency value. Default value is 1
     */
    public void setAlternateFieldFrequency(int alternateFieldFrequency) {
        setAttribute("alternateFieldFrequency", alternateFieldFrequency, true);
    }

    /**
     * The number of consecutive columns to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternateColumnStyles} is true.
     *
     * @return Current alternateFieldFrequency value. Default value is 1
     */
    public int getAlternateFieldFrequency()  {
        return getAttributeAsInt("alternateFieldFrequency");
    }
    

    /**
     * Whether alternating columns (or blocks of columns, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnFrequency GridRenderer.alternateColumnFrequency}) should
     * be drawn in alternating styles, in order to create a vertical "ledger" effect for easier reading. <P> If enabled, the
     * cell style for alternate rows will have the {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnSuffix GridRenderer.alternateColumnSuffix} appended to
     * it. See also {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles
     * GridRenderer.alternateRowStyles}.
     *
     * @param alternateFieldStyles New alternateFieldStyles value. Default value is false
     */
    public void setAlternateFieldStyles(boolean alternateFieldStyles) {
        setAttribute("alternateFieldStyles", alternateFieldStyles, true);
    }

    /**
     * Whether alternating columns (or blocks of columns, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnFrequency GridRenderer.alternateColumnFrequency}) should
     * be drawn in alternating styles, in order to create a vertical "ledger" effect for easier reading. <P> If enabled, the
     * cell style for alternate rows will have the {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnSuffix GridRenderer.alternateColumnSuffix} appended to
     * it. See also {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles
     * GridRenderer.alternateRowStyles}.
     *
     * @return Current alternateFieldStyles value. Default value is false
     */
    public boolean getAlternateFieldStyles()  {
        Boolean result = getAttributeAsBoolean("alternateFieldStyles");
        return result == null ? false : result;
    }
    

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternate columns}.
     * Note that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles GridRenderer.alternateRowStyles}
     * is enabled, cells which fall into both an alternate row and column will have both suffixes appended - for example
     * <code>"cellDarkAltCol"</code>.
     *
     * @param alternateFieldSuffix New alternateFieldSuffix value. Default value is "AltCol"
     */
    public void setAlternateFieldSuffix(String alternateFieldSuffix) {
        setAttribute("alternateFieldSuffix", alternateFieldSuffix, true);
    }

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternate columns}.
     * Note that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles GridRenderer.alternateRowStyles}
     * is enabled, cells which fall into both an alternate row and column will have both suffixes appended - for example
     * <code>"cellDarkAltCol"</code>.
     *
     * @return Current alternateFieldSuffix value. Default value is "AltCol"
     */
    public String getAlternateFieldSuffix()  {
        return getAttributeAsString("alternateFieldSuffix");
    }
    

    /**
     * The number of consecutive rows to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternateRowStyles} is true.
     *
     * @param alternateRecordFrequency New alternateRecordFrequency value. Default value is 1
     */
    public void setAlternateRecordFrequency(int alternateRecordFrequency) {
        setAttribute("alternateRecordFrequency", alternateRecordFrequency, true);
    }

    /**
     * The number of consecutive rows to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternateRowStyles} is true.
     *
     * @return Current alternateRecordFrequency value. Default value is 1
     */
    public int getAlternateRecordFrequency()  {
        return getAttributeAsInt("alternateRecordFrequency");
    }
    

    /**
     * Whether alternating rows (or blocks of rows, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowFrequency GridRenderer.alternateRowFrequency}) should be
     * drawn in alternating styles, in order to create a "ledger" effect for easier reading. <P> If enabled, the cell style for
     * alternate rows will have the {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowSuffix
     * GridRenderer.alternateRowSuffix} appended to it. See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles GridRenderer.alternateColumnStyles}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}
     *
     * @param alternateRecordStyles New value for <code>this.alternateRecordStyles</code>. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public void setAlternateRecordStyles(Boolean alternateRecordStyles) {
        setAttribute("alternateRecordStyles", alternateRecordStyles, true);
    }

    /**
     * Whether alternating rows (or blocks of rows, depending on {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowFrequency GridRenderer.alternateRowFrequency}) should be
     * drawn in alternating styles, in order to create a "ledger" effect for easier reading. <P> If enabled, the cell style for
     * alternate rows will have the {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowSuffix
     * GridRenderer.alternateRowSuffix} appended to it. See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles GridRenderer.alternateColumnStyles}.
     *
     * @return Current alternateRecordStyles value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public Boolean getAlternateRecordStyles()  {
        Boolean result = getAttributeAsBoolean("alternateRecordStyles");
        return result == null ? false : result;
    }
    

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternate rows}. Note
     * that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles
     * GridRenderer.alternateColumnStyles} is enabled, cells which fall into both an alternate row and column will have both
     * suffixes appended - for example <code>"cellDarkAltCol"</code>.
     *
     * @param alternateRecordSuffix New alternateRecordSuffix value. Default value is "Dark"
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public void setAlternateRecordSuffix(String alternateRecordSuffix) {
        setAttribute("alternateRecordSuffix", alternateRecordSuffix, true);
    }

    /**
     * Suffix to append to {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternate rows}. Note
     * that if {@link com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles
     * GridRenderer.alternateColumnStyles} is enabled, cells which fall into both an alternate row and column will have both
     * suffixes appended - for example <code>"cellDarkAltCol"</code>.
     *
     * @return Current alternateRecordSuffix value. Default value is "Dark"
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public String getAlternateRecordSuffix()  {
        return getAttributeAsString("alternateRecordSuffix");
    }
    

    /**
     * When this attribute is set, editors will be rendered into every row of the grid rather than showing up in a single
     * record at a time. This attribute is only valid when {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * editByCell} is false
     *
     * @param alwaysShowEditors New alwaysShowEditors value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setAlwaysShowEditors(Boolean alwaysShowEditors)  throws IllegalStateException {
        setAttribute("alwaysShowEditors", alwaysShowEditors, false);
    }

    /**
     * When this attribute is set, editors will be rendered into every row of the grid rather than showing up in a single
     * record at a time. This attribute is only valid when {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * editByCell} is false
     *
     * @return Current alwaysShowEditors value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAlwaysShowEditors()  {
        return getAttributeAsBoolean("alwaysShowEditors");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled, whether
     * to show the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} for all filterable fields, or
     * only for fields where the user has explicitly chosen a search operator different from the default operator for the
     * field. <p> The default operator for a field is determined by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} or by setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator} for a specific field.
     *
     * @param alwaysShowOperatorIcon New alwaysShowOperatorIcon value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAlwaysShowOperatorIcon(Boolean alwaysShowOperatorIcon)  throws IllegalStateException {
        setAttribute("alwaysShowOperatorIcon", alwaysShowOperatorIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled, whether
     * to show the {@link com.smartgwt.client.widgets.grid.ListGrid#getOperatorIcon operatorIcon} for all filterable fields, or
     * only for fields where the user has explicitly chosen a search operator different from the default operator for the
     * field. <p> The default operator for a field is determined by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} or by setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator} for a specific field.
     *
     * @return Current alwaysShowOperatorIcon value. Default value is null
     */
    public Boolean getAlwaysShowOperatorIcon()  {
        return getAttributeAsBoolean("alwaysShowOperatorIcon");
    }
    

    /**
     * When animating folder opening / closing, this property can be set to apply an animated acceleration effect. This allows
     * the animation speed to be "weighted", for example expanding or collapsing at a faster rate toward the beginning of the
     * animation than at the end. <P> For a ListGrid, this property applies when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolderEffect New animateFolderEffect value. Default value is null
     */
    public void setAnimateFolderEffect(AnimationAcceleration animateFolderEffect) {
        setAttribute("animateFolderEffect", animateFolderEffect == null ? null : animateFolderEffect.getValue(), true);
    }

    /**
     * When animating folder opening / closing, this property can be set to apply an animated acceleration effect. This allows
     * the animation speed to be "weighted", for example expanding or collapsing at a faster rate toward the beginning of the
     * animation than at the end. <P> For a ListGrid, this property applies when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return Current animateFolderEffect value. Default value is null
     */
    public AnimationAcceleration getAnimateFolderEffect()  {
        return EnumUtil.getEnum(AnimationAcceleration.values(), getAttribute("animateFolderEffect"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolders animateFolders} is true for this grid, this number
     * can be set to designate the maximum number of rows to animate at a time when opening / closing a folder. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @param animateFolderMaxRows New animateFolderMaxRows value. Default value is null
     * @see com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderMaxRows
     */
    public void setAnimateFolderMaxRows(Integer animateFolderMaxRows) {
        setAttribute("animateFolderMaxRows", animateFolderMaxRows, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolders animateFolders} is true for this grid, this number
     * can be set to designate the maximum number of rows to animate at a time when opening / closing a folder. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @return Current animateFolderMaxRows value. Default value is null
     * @see com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderMaxRows
     */
    public Integer getAnimateFolderMaxRows()  {
        return getAttributeAsInt("animateFolderMaxRows");
    }
    

    /**
     * If true, when folders are opened / closed children will be animated into view. <P> For a ListGrid, this property applies
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolders New animateFolders value. Default value is true
     */
    public void setAnimateFolders(Boolean animateFolders) {
        setAttribute("animateFolders", animateFolders, true);
    }

    /**
     * If true, when folders are opened / closed children will be animated into view. <P> For a ListGrid, this property applies
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return Current animateFolders value. Default value is true
     */
    public Boolean getAnimateFolders()  {
        Boolean result = getAttributeAsBoolean("animateFolders");
        return result == null ? true : result;
    }
    

    /**
     * When animating folder opening / closing, this property designates the speed of the animation in pixels shown (or hidden)
     * per second. Takes precedence over the {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderTime
     * TreeGrid.animateFolderTime} property, which allows the developer to specify a duration for the animation rather than a
     * speed. <P> For a ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy
     * grouping} is enabled.
     *
     * @param animateFolderSpeed New animateFolderSpeed value. Default value is 3000
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateFolderTime
     */
    public void setAnimateFolderSpeed(int animateFolderSpeed) {
        setAttribute("animateFolderSpeed", animateFolderSpeed, true);
    }

    /**
     * When animating folder opening / closing, this property designates the speed of the animation in pixels shown (or hidden)
     * per second. Takes precedence over the {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderTime
     * TreeGrid.animateFolderTime} property, which allows the developer to specify a duration for the animation rather than a
     * speed. <P> For a ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy
     * grouping} is enabled.
     *
     * @return Current animateFolderSpeed value. Default value is 3000
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolderTime
     */
    public int getAnimateFolderSpeed()  {
        return getAttributeAsInt("animateFolderSpeed");
    }
    

    /**
     * When animating folder opening / closing, if {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderSpeed
     * TreeGrid.animateFolderSpeed} is not set, this property designates the duration of the animation in ms. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @param animateFolderTime New animateFolderTime value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateFolderSpeed
     */
    public void setAnimateFolderTime(int animateFolderTime) {
        setAttribute("animateFolderTime", animateFolderTime, true);
    }

    /**
     * When animating folder opening / closing, if {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderSpeed
     * TreeGrid.animateFolderSpeed} is not set, this property designates the duration of the animation in ms. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @return Current animateFolderTime value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolderSpeed
     */
    public int getAnimateFolderTime()  {
        return getAttributeAsInt("animateFolderTime");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, should records
     * be animated out of view when they are removed by the user?
     *
     * @param animateRemoveRecord New animateRemoveRecord value. Default value is true
     */
    public void setAnimateRemoveRecord(Boolean animateRemoveRecord) {
        setAttribute("animateRemoveRecord", animateRemoveRecord, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, should records
     * be animated out of view when they are removed by the user?
     *
     * @return Current animateRemoveRecord value. Default value is true
     */
    public Boolean getAnimateRemoveRecord()  {
        Boolean result = getAttributeAsBoolean("animateRemoveRecord");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animating record removal}, this property
     * designates the speed of the animation in pixels per second. Takes precedence over the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveTime animateRemoveTime} property, which allows the developer
     * to specify a duration for the animation rather than a speed.
     *
     * @param animateRemoveSpeed New animateRemoveSpeed value. Default value is 200
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateRemoveRecord
     */
    public void setAnimateRemoveSpeed(int animateRemoveSpeed) {
        setAttribute("animateRemoveSpeed", animateRemoveSpeed, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animating record removal}, this property
     * designates the speed of the animation in pixels per second. Takes precedence over the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveTime animateRemoveTime} property, which allows the developer
     * to specify a duration for the animation rather than a speed.
     *
     * @return Current animateRemoveSpeed value. Default value is 200
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord
     */
    public int getAnimateRemoveSpeed()  {
        return getAttributeAsInt("animateRemoveSpeed");
    }
    

    /**
     * When animating record removal {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord (see
     * animateRemoveRecord)}, if {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveSpeed animateRemoveSpeed} is
     * not set, this property designates the duration of the animation in ms.
     *
     * @param animateRemoveTime New animateRemoveTime value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateRemoveRecord
     */
    public void setAnimateRemoveTime(int animateRemoveTime) {
        setAttribute("animateRemoveTime", animateRemoveTime, true);
    }

    /**
     * When animating record removal {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord (see
     * animateRemoveRecord)}, if {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveSpeed animateRemoveSpeed} is
     * not set, this property designates the duration of the animation in ms.
     *
     * @return Current animateRemoveTime value. Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord
     */
    public int getAnimateRemoveTime()  {
        return getAttributeAsInt("animateRemoveTime");
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollOverCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateRollOver New animateRollOver value. Default value is false
     */
    public void setAnimateRollOver(Boolean animateRollOver) {
        setAttribute("animateRollOver", animateRollOver, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollOverCanvasProperties</code>.
     *
     * @return Current animateRollOver value. Default value is false
     */
    public Boolean getAnimateRollOver()  {
        Boolean result = getAttributeAsBoolean("animateRollOver");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollUnderCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateRollUnder New animateRollUnder value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public void setAnimateRollUnder(Boolean animateRollUnder) {
        setAttribute("animateRollUnder", animateRollUnder, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>rollUnderCanvasProperties</code>.
     *
     * @return Current animateRollUnder value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getAnimateRollUnder()  {
        Boolean result = getAttributeAsBoolean("animateRollUnder");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>selectionCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateSelection New animateSelection value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateSelectionUnder
     */
    public void setAnimateSelection(Boolean animateSelection) {
        setAttribute("animateSelection", animateSelection, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>selectionCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect Canvas.animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionCanvasProperties</code>.
     *
     * @return Current animateSelection value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateSelectionUnder
     */
    public Boolean getAnimateSelection()  {
        Boolean result = getAttributeAsBoolean("animateSelection");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} is enabled,
     * setting this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code> is displayed it is
     * animated into view via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the
     * animation effect may be customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect
     * Canvas.animateShowEffect}, {@link com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and
     * {@link com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionUnderCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateSelectionUnder New animateSelectionUnder value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateSelection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public void setAnimateSelectionUnder(Boolean animateSelectionUnder) {
        setAttribute("animateSelectionUnder", animateSelectionUnder, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} is enabled,
     * setting this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code> is displayed it is
     * animated into view via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the
     * animation effect may be customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect
     * Canvas.animateShowEffect}, {@link com.smartgwt.client.widgets.Canvas#getAnimateShowTime Canvas.animateShowTime} and
     * {@link com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration Canvas.animateShowAcceleration} set in
     * <code>selectionUnderCanvasProperties</code>.
     *
     * @return Current animateSelectionUnder value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateSelection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getAnimateSelectionUnder()  {
        Boolean result = getAttributeAsBoolean("animateSelectionUnder");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula ListGridField.userFormula} is set for some
     * field, and this grid is showing {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summaries} or
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, this property determines what field
     * value should be present in those summary rows. Should the field apply the user-formula to the calculated summary row, or
     * should it apply a standard grid or group summary to the user-formula values displayed in the grid? <P> May be overridden
     * at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getApplyAfterSummary
     * ListGridField.applyAfterSummary}
     *
     * @param applyFormulaAfterSummary New applyFormulaAfterSummary value. Default value is false
     */
    public void setApplyFormulaAfterSummary(Boolean applyFormulaAfterSummary) {
        setAttribute("applyFormulaAfterSummary", applyFormulaAfterSummary, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula ListGridField.userFormula} is set for some
     * field, and this grid is showing {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summaries} or
     * a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, this property determines what field
     * value should be present in those summary rows. Should the field apply the user-formula to the calculated summary row, or
     * should it apply a standard grid or group summary to the user-formula values displayed in the grid? <P> May be overridden
     * at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getApplyAfterSummary
     * ListGridField.applyAfterSummary}
     *
     * @return Current applyFormulaAfterSummary value. Default value is false
     */
    public Boolean getApplyFormulaAfterSummary()  {
        Boolean result = getAttributeAsBoolean("applyFormulaAfterSummary");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, should we apply the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberStyle rowNumberStyle} to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param applyRowNumberStyle New applyRowNumberStyle value. Default value is true
     */
    public void setApplyRowNumberStyle(boolean applyRowNumberStyle) {
        setAttribute("applyRowNumberStyle", applyRowNumberStyle, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, should we apply the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberStyle rowNumberStyle} to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}
     *
     * @return Current applyRowNumberStyle value. Default value is true
     */
    public boolean getApplyRowNumberStyle()  {
        Boolean result = getAttributeAsBoolean("applyRowNumberStyle");
        return result == null ? true : result;
    }
    

    /**
     * Action to perform when the listGrid has keyboard focus (but not editing focus) and a user presses the up or down arrow
     * key. Possible values are: <ul> <li><code>"select"</code> : select the next row in the list (calls
     * <code>recordClick</code> handler)</li> <li><code>"focus"</code> : move focus to the next row in the list without
     * changing the selection</li> <li><code>"activate"</code> : select and activate the next row in the list (calls 
     * <code>recordDoubleClick</code> handler)</li> <li><code>"none"</code> : no action</li> <li> <code>null</code> : if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is "checkbox", behaves as if set 
     * to "focus"; otherwise, behaves as if set to "select"</li> </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param arrowKeyAction New arrowKeyAction value. Default value is null
     */
    public void setArrowKeyAction(String arrowKeyAction) {
        setAttribute("arrowKeyAction", arrowKeyAction, true);
    }

    /**
     * Action to perform when the listGrid has keyboard focus (but not editing focus) and a user presses the up or down arrow
     * key. Possible values are: <ul> <li><code>"select"</code> : select the next row in the list (calls
     * <code>recordClick</code> handler)</li> <li><code>"focus"</code> : move focus to the next row in the list without
     * changing the selection</li> <li><code>"activate"</code> : select and activate the next row in the list (calls 
     * <code>recordDoubleClick</code> handler)</li> <li><code>"none"</code> : no action</li> <li> <code>null</code> : if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is "checkbox", behaves as if set 
     * to "focus"; otherwise, behaves as if set to "select"</li> </ul>
     *
     * @return Current arrowKeyAction value. Default value is null
     */
    public String getArrowKeyAction()  {
        return getAttributeAsString("arrowKeyAction");
    }
    

    /**
     * The prompt to display while interactivity is blocked during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold asynchronous grouping}.
     *
     * @param asynchGroupingPrompt New asynchGroupingPrompt value. Default value is "${loadingImage}&amp;nbsp;Grouping data..."
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public void setAsynchGroupingPrompt(String asynchGroupingPrompt)  throws IllegalStateException {
        setAttribute("asynchGroupingPrompt", asynchGroupingPrompt, false);
    }

    /**
     * The prompt to display while interactivity is blocked during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold asynchronous grouping}.
     *
     * @return Current asynchGroupingPrompt value. Default value is "${loadingImage}&amp;nbsp;Grouping data..."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getAsynchGroupingPrompt()  {
        return getAttributeAsString("asynchGroupingPrompt");
    }
    

    /**
     * Whether to do inline autoComplete in text fields during inline editing<br> Overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete ListGridField.autoComplete} if specified. If unset picks
     * up the default from the appropriate editor class (subclass of FormItem).
     *
     * @param autoComplete New autoComplete value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#setAutoComplete
     */
    public void setAutoComplete(AutoComplete autoComplete) {
        setAttribute("autoComplete", autoComplete == null ? null : autoComplete.getValue(), true);
    }

    /**
     * Whether to do inline autoComplete in text fields during inline editing<br> Overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete ListGridField.autoComplete} if specified. If unset picks
     * up the default from the appropriate editor class (subclass of FormItem).
     *
     * @return Current autoComplete value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete
     */
    public AutoComplete getAutoComplete()  {
        return EnumUtil.getEnum(AutoComplete.values(), getAttribute("autoComplete"));
    }
    

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded by
     * default. This flag determines whether we should save such edits automatically in this case.  See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits}, which  allows the user to choose
     * whether to save or discard the unsaved edits.
     *
     * @param autoConfirmSaveEdits New autoConfirmSaveEdits value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setAutoConfirmSaveEdits(Boolean autoConfirmSaveEdits) {
        setAttribute("autoConfirmSaveEdits", autoConfirmSaveEdits, true);
    }

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded by
     * default. This flag determines whether we should save such edits automatically in this case.  See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits}, which  allows the user to choose
     * whether to save or discard the unsaved edits.
     *
     * @return Current autoConfirmSaveEdits value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAutoConfirmSaveEdits()  {
        Boolean result = getAttributeAsBoolean("autoConfirmSaveEdits");
        return result == null ? false : result;
    }
    
    

    /**
     * If true, for fields where {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource} is specified, a valueMap will be automatically created by making a {@link
     * com.smartgwt.client.data.DataSource#fetchData DataSource.fetchData()} call against the specified dataSource and
     * extracting a valueMap from the returned records based on the displayField and valueField. <P> If set to false, valueMaps
     * will not be automatically fetched.  In this case, setting field.optionDataSource is effectively a shortcut for setting
     * optionDataSource on the editor via {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties
     * ListGridField.editorProperties}. <P> Can also be disabled on a per-field basis with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap ListGridField.autoFetchDisplayMap}.
     *
     * @param autoFetchDisplayMap New autoFetchDisplayMap value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGridField#setAutoFetchDisplayMap
     * @see com.smartgwt.client.widgets.grid.ListGridField#setOptionDataSource
     */
    public void setAutoFetchDisplayMap(Boolean autoFetchDisplayMap) {
        setAttribute("autoFetchDisplayMap", autoFetchDisplayMap, true);
    }

    /**
     * If true, for fields where {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource} is specified, a valueMap will be automatically created by making a {@link
     * com.smartgwt.client.data.DataSource#fetchData DataSource.fetchData()} call against the specified dataSource and
     * extracting a valueMap from the returned records based on the displayField and valueField. <P> If set to false, valueMaps
     * will not be automatically fetched.  In this case, setting field.optionDataSource is effectively a shortcut for setting
     * optionDataSource on the editor via {@link com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties
     * ListGridField.editorProperties}. <P> Can also be disabled on a per-field basis with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap ListGridField.autoFetchDisplayMap}.
     *
     * @return Current autoFetchDisplayMap value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap
     * @see com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     */
    public Boolean getAutoFetchDisplayMap()  {
        Boolean result = getAttributeAsBoolean("autoFetchDisplayMap");
        return result == null ? true : result;
    }
    
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of all visible fields via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()} method.
     *
     * @param autoFitAllText New autoFitAllText value. Default value is "Auto Fit All Columns"
     */
    public void setAutoFitAllText(String autoFitAllText) {
        setAttribute("autoFitAllText", autoFitAllText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of all visible fields via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()} method.
     *
     * @return Current autoFitAllText value. Default value is "Auto Fit All Columns"
     */
    public String getAutoFitAllText()  {
        return getAttributeAsString("autoFitAllText");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled and the
     * calculated field sizes are wide enough that horizontal scrolling would be introduced, this attribute may be set to an
     * array of fieldNames, causing those fields to be clipped rather than forcing horizontal scrollbars to appear. <P> Note:
     * If any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} are included in this list they
     * will not be clipped.
     *
     * @param autoFitClipFields New autoFitClipFields value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitClipFields(String... autoFitClipFields)  throws IllegalStateException {
        setAttribute("autoFitClipFields", autoFitClipFields, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled and the
     * calculated field sizes are wide enough that horizontal scrolling would be introduced, this attribute may be set to an
     * array of fieldNames, causing those fields to be clipped rather than forcing horizontal scrollbars to appear. <P> Note:
     * If any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} are included in this list they
     * will not be clipped.
     *
     * @return Current autoFitClipFields value. Default value is null
     */
    public String[] getAutoFitClipFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("autoFitClipFields"));
    }
    

    /**
     * Should this ListGrid automatically expand to accommodate the size of records and fields? <P> Valid settings are
     * <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>     <li><code>"horizontal"</code>:
     * expand horizontally to accommodate fields.</li>     <li><code>"both"</code>: expand horizontally and vertically to
     * accommodate content.</li> </ul> How far the ListGrid will expand may be limited via the following properties: {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}. <P> Note that this property causes
     * the grid as a whole to expand to fit records or fields. To have the fields or records themselves expand to fit cell
     * contents, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData}.
     *
     * @param autoFitData One of <code>"vertical"</code>, <code>"horizontal"</code>  or <code>"both"</code>. To disable auto fit behavior, pass in
     * <code>null</code>. Default value is null
     */
    public void setAutoFitData(Autofit autoFitData) {
        setAttribute("autoFitData", autoFitData == null ? null : autoFitData.getValue(), true);
    }

    /**
     * Should this ListGrid automatically expand to accommodate the size of records and fields? <P> Valid settings are
     * <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>     <li><code>"horizontal"</code>:
     * expand horizontally to accommodate fields.</li>     <li><code>"both"</code>: expand horizontally and vertically to
     * accommodate content.</li> </ul> How far the ListGrid will expand may be limited via the following properties: {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}. <P> Note that this property causes
     * the grid as a whole to expand to fit records or fields. To have the fields or records themselves expand to fit cell
     * contents, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * @return Current autoFitData value. Default value is null
     */
    public Autofit getAutoFitData()  {
        return EnumUtil.getEnum(Autofit.values(), getAttribute("autoFitData"));
    }
    

    /**
     * Should listGrids automatically size date fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type date will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth defaultDateFieldWidth},  (or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth defaultEditableDateFieldWidth} for editable
     * fields). This static value is appropriate for dates rendered with the standard short-date formatter. If set to
     * <code>"title"</code> or <code>"both"</code>, the drawn width of the title will be taken into account when sizing the
     * column. <P> This is achieved by enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth
     * autoFitWidth:true} on date fields when this property is set to anything other than <code>"none"</code>, setting the
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the
     * value specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth
     * defaultDateFieldWidth} or {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth
     * defaultEditableDateFieldWidth} if appropriate.
     *
     * @param autoFitDateFields New autoFitDateFields value. Default value is "value"
     */
    public void setAutoFitDateFields(AutoFitWidthApproach autoFitDateFields) {
        setAttribute("autoFitDateFields", autoFitDateFields == null ? null : autoFitDateFields.getValue(), true);
    }

    /**
     * Should listGrids automatically size date fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type date will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth defaultDateFieldWidth},  (or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth defaultEditableDateFieldWidth} for editable
     * fields). This static value is appropriate for dates rendered with the standard short-date formatter. If set to
     * <code>"title"</code> or <code>"both"</code>, the drawn width of the title will be taken into account when sizing the
     * column. <P> This is achieved by enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth
     * autoFitWidth:true} on date fields when this property is set to anything other than <code>"none"</code>, setting the
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the
     * value specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultDateFieldWidth
     * defaultDateFieldWidth} or {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultEditableDateFieldWidth
     * defaultEditableDateFieldWidth} if appropriate.
     *
     * @return Current autoFitDateFields value. Default value is "value"
     */
    public AutoFitWidthApproach getAutoFitDateFields()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitDateFields"));
    }
    

    /**
     * The field to expand if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} are enabled and
     * auto-fitting will not fill all available horizontal space. <P> If unset, will default to the text field with the longest
     * {@link com.smartgwt.client.data.DataSourceField#getLength DataSourceField.length} if length is set, otherwise, the first
     * text field with no width specified. <P> Note that expanding {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} is not supported.
     *
     * @param autoFitExpandField New autoFitExpandField value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitExpandField(String autoFitExpandField)  throws IllegalStateException {
        setAttribute("autoFitExpandField", autoFitExpandField, false);
    }

    /**
     * The field to expand if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} are enabled and
     * auto-fitting will not fill all available horizontal space. <P> If unset, will default to the text field with the longest
     * {@link com.smartgwt.client.data.DataSourceField#getLength DataSourceField.length} if length is set, otherwise, the first
     * text field with no width specified. <P> Note that expanding {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} is not supported.
     *
     * @return Current autoFitExpandField value. Default value is null
     */
    public String getAutoFitExpandField()  {
        return getAttributeAsString("autoFitExpandField");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code>, setting this property will cause the ListGrid body to size large enough to accomodate the actual
     * data and also leave this many extra rows' worth of blank space below the last record. If a maximum size is specified via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, it will still be respected. Once the
     * data set is large enough to fill or exceed that space, this property no longer has an effect.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExtraRecords autoFitExtraRecords}.
     *
     * @param autoFitExtraRecords Number of extra rows beyond the data-size we'll expand to accommodate if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is enabled vertically. Default value is null
     */
    public void setAutoFitExtraRecords(Integer autoFitExtraRecords) {
        setAttribute("autoFitExtraRecords", autoFitExtraRecords, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code>, setting this property will cause the ListGrid body to size large enough to accomodate the actual
     * data and also leave this many extra rows' worth of blank space below the last record. If a maximum size is specified via
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, it will still be respected. Once the
     * data set is large enough to fill or exceed that space, this property no longer has an effect.
     *
     * @return Current autoFitExtraRecords value. Default value is null
     */
    public Integer getAutoFitExtraRecords()  {
        return getAttributeAsInt("autoFitExtraRecords");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled, and extra
     * space is available after autofitting all fields, should the grid automatically expand one field to fill the extra space.
     * <P> When enabled, the field to expand may be specified via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExpandField autoFitExpandField}. <P> Note this logic will not expand
     * a {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen column}.
     *
     * @param autoFitFieldsFillViewport New autoFitFieldsFillViewport value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitFieldsFillViewport(Boolean autoFitFieldsFillViewport)  throws IllegalStateException {
        setAttribute("autoFitFieldsFillViewport", autoFitFieldsFillViewport, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled, and extra
     * space is available after autofitting all fields, should the grid automatically expand one field to fill the extra space.
     * <P> When enabled, the field to expand may be specified via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExpandField autoFitExpandField}. <P> Note this logic will not expand
     * a {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen column}.
     *
     * @return Current autoFitFieldsFillViewport value. Default value is true
     */
    public Boolean getAutoFitFieldsFillViewport()  {
        Boolean result = getAttributeAsBoolean("autoFitFieldsFillViewport");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and user-driven auto fit of fields is enabled via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields}, this attribute will be shown as the
     * menu item title for an item to perform a one-time autoFit of the field to its title or content via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()}.
     *
     * @param autoFitFieldText New autoFitFieldText value. Default value is "Auto Fit"
     */
    public void setAutoFitFieldText(String autoFitFieldText) {
        setAttribute("autoFitFieldText", autoFitFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and user-driven auto fit of fields is enabled via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields}, this attribute will be shown as the
     * menu item title for an item to perform a one-time autoFit of the field to its title or content via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField autoFitField()}.
     *
     * @return Current autoFitFieldText value. Default value is "Auto Fit"
     */
    public String getAutoFitFieldText()  {
        return getAttributeAsString("autoFitFieldText");
    }
    

    /**
     * Should ListGrid fields autofit their widths to titles or content? This property may be overridden on a per-field basis
     * via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}. Developers may
     * wish to consider disabling autoFit for fields known to have  exceptionally long content as this can lead to large
     * horizontal scrollbars and unwieldy UI. <P> The {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach
     * autoFitWidthApproach} controls whether fitting is to values, titles or both. This property may also be overridden on a
     * per field basis. <P> If {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth field.width} is also set on the
     * field, it will be taken as a minimum width. {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth
     * minFieldWidth} will also be respected. <P> By default, the entire available width of the grid will still be used, by
     * allocating any "extra" space to specific columns - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} for details on
     * controlling this behavior. <P> When this feature is enabled, autofitting is active on an ongoing basis. Autofitting will
     * be performed: <ul>  <li> whenever the dataset is completely changed or rows are added or removed  <li> whenever a field
     * which is autofitting is changed  <li> on a manual call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField
     * autoFitField()} or       {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitFields autoFitFields()} </ul>
     * Auto-fitting behavior continues until the user resizes the field manually, at which point it stops. The user can also
     * perform a one-time auto-fit of fields via the header context menu if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is enabled. <P> When autofitting to
     * column values, {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} will be
     * called to determine the space required for a field's values. This method uses values from the rendered set of rows to
     * calculate the required column width, which means the field width may still be smaller than values from non-rendered
     * rows.  See {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}) to control incremental rendering of rows.
     * <P> Note that for <code>icon</code> type fields, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitIconFields autoFitIconFields} property setting may turn on
     * auto-fit-width behavior for specific fields by default, even if <code>autoFitFieldWidths</code> is false for the grid as
     * a whole. <P> Using this feature has a performance penalty roughly comparable to always rendering one additional field
     * per field where autofitting is enabled.  Specifically, enabling it for all fields would be comparable to <i>both</i>
     * doubling the number of fields <i>and</i> disabling {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllColumns
     * horizontal incremental rendering}. In a grid where only half the fields are normally visible and hence only half are
     * normally rendered, this would be roughly 4 times slower overall. <P> This performance penalty is a result of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} having to render out the data set
     * offscreen and measure the rendered content - it does not apply for cases where this method can return a simple fixed
     * values (as with icon fields). <P> Which fields are currently autofitting is saved as part of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} of the ListGrid.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}. Modifies the default auto-fit-width behavior for fields in this grid. Note that this may be overridden at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}.
     *
     * @param autoFitFieldWidths New value for autoFitFieldWidths. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitFieldWidths(Boolean autoFitFieldWidths)  throws IllegalStateException {
        setAttribute("autoFitFieldWidths", autoFitFieldWidths, false);
    }

    /**
     * Should ListGrid fields autofit their widths to titles or content? This property may be overridden on a per-field basis
     * via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}. Developers may
     * wish to consider disabling autoFit for fields known to have  exceptionally long content as this can lead to large
     * horizontal scrollbars and unwieldy UI. <P> The {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach
     * autoFitWidthApproach} controls whether fitting is to values, titles or both. This property may also be overridden on a
     * per field basis. <P> If {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth field.width} is also set on the
     * field, it will be taken as a minimum width. {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth
     * minFieldWidth} will also be respected. <P> By default, the entire available width of the grid will still be used, by
     * allocating any "extra" space to specific columns - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} for details on
     * controlling this behavior. <P> When this feature is enabled, autofitting is active on an ongoing basis. Autofitting will
     * be performed: <ul>  <li> whenever the dataset is completely changed or rows are added or removed  <li> whenever a field
     * which is autofitting is changed  <li> on a manual call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField
     * autoFitField()} or       {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitFields autoFitFields()} </ul>
     * Auto-fitting behavior continues until the user resizes the field manually, at which point it stops. The user can also
     * perform a one-time auto-fit of fields via the header context menu if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is enabled. <P> When autofitting to
     * column values, {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} will be
     * called to determine the space required for a field's values. This method uses values from the rendered set of rows to
     * calculate the required column width, which means the field width may still be smaller than values from non-rendered
     * rows.  See {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}) to control incremental rendering of rows.
     * <P> Note that for <code>icon</code> type fields, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitIconFields autoFitIconFields} property setting may turn on
     * auto-fit-width behavior for specific fields by default, even if <code>autoFitFieldWidths</code> is false for the grid as
     * a whole. <P> Using this feature has a performance penalty roughly comparable to always rendering one additional field
     * per field where autofitting is enabled.  Specifically, enabling it for all fields would be comparable to <i>both</i>
     * doubling the number of fields <i>and</i> disabling {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllColumns
     * horizontal incremental rendering}. In a grid where only half the fields are normally visible and hence only half are
     * normally rendered, this would be roughly 4 times slower overall. <P> This performance penalty is a result of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} having to render out the data set
     * offscreen and measure the rendered content - it does not apply for cases where this method can return a simple fixed
     * values (as with icon fields). <P> Which fields are currently autofitting is saved as part of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} of the ListGrid.
     *
     * @return Current autoFitFieldWidths value. Default value is null
     */
    public Boolean getAutoFitFieldWidths()  {
        return getAttributeAsBoolean("autoFitFieldWidths");
    }
    

    /**
     * If this property is set to true, header buttons for either {@link com.smartgwt.client.widgets.grid.ListGrid#getFields
     * fields} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans header spans} will automatically expand to
     * accommodate their titles vertically.  This means if you have a "tall" title - typically a long string where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWrap ListGridField.wrap} is set to true such that you end up with
     * several lines of text - the button will render large enough to accommodate it.  If necessary this will cause the header
     * for the grid as a whole to expand beyond the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight}. <P> Note that you need not set {@link com.smartgwt.client.widgets.grid.HeaderSpan#getHeight
     * HeaderSpan.height} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpanHeight headerSpanHeight} if you set
     * this property, but if you do, they will be used as minimum values.
     *
     * @param autoFitHeaderHeights New autoFitHeaderHeights value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitHeaderHeights(Boolean autoFitHeaderHeights)  throws IllegalStateException {
        setAttribute("autoFitHeaderHeights", autoFitHeaderHeights, false);
    }

    /**
     * If this property is set to true, header buttons for either {@link com.smartgwt.client.widgets.grid.ListGrid#getFields
     * fields} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans header spans} will automatically expand to
     * accommodate their titles vertically.  This means if you have a "tall" title - typically a long string where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWrap ListGridField.wrap} is set to true such that you end up with
     * several lines of text - the button will render large enough to accommodate it.  If necessary this will cause the header
     * for the grid as a whole to expand beyond the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight}. <P> Note that you need not set {@link com.smartgwt.client.widgets.grid.HeaderSpan#getHeight
     * HeaderSpan.height} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpanHeight headerSpanHeight} if you set
     * this property, but if you do, they will be used as minimum values.
     *
     * @return Current autoFitHeaderHeights value. Default value is null
     */
    public Boolean getAutoFitHeaderHeights()  {
        return getAttributeAsBoolean("autoFitHeaderHeights");
    }
    

    /**
     * Smart GWT listGrids have special logic to automatically size fields that are displayed as an icon - that is fields with
     * {@link com.smartgwt.client.types.ListGridFieldType type:"icon"}, fields displaying only {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly value icons}, and boolean fields (which are rendered
     * as a checkmark type icon by default. <P> This attribute controls this behavior - governing whether icon fields should be
     * sized to fit their content (icon), title, or whether to disable this behavior. Setting this value to
     * <code>"title"</code> or <code>"iconWidth"</code> will cause {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} to be enabled by default for
     * all icon fields with the {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} set to <code>"value"</code> or <code>"both"</code> as appropriate. Note that the
     * width required for the icons is calculated by {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} which performs a simple calculation based on the specified icon width for these types of fields.
     * <P> This setting governs default behavior for icon fields - for specific fields within a grid, this default behavior can
     * be overridden by setting an explicit {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width}
     * or explicitly enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}
     * and setting {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} on the field in question.
     *
     * @param autoFitIconFields New autoFitIconFields value. Default value is "title"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAutoFitFieldWidths
     */
    public void setAutoFitIconFields(AutoFitIconFieldType autoFitIconFields) {
        setAttribute("autoFitIconFields", autoFitIconFields == null ? null : autoFitIconFields.getValue(), true);
    }

    /**
     * Smart GWT listGrids have special logic to automatically size fields that are displayed as an icon - that is fields with
     * {@link com.smartgwt.client.types.ListGridFieldType type:"icon"}, fields displaying only {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly value icons}, and boolean fields (which are rendered
     * as a checkmark type icon by default. <P> This attribute controls this behavior - governing whether icon fields should be
     * sized to fit their content (icon), title, or whether to disable this behavior. Setting this value to
     * <code>"title"</code> or <code>"iconWidth"</code> will cause {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} to be enabled by default for
     * all icon fields with the {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} set to <code>"value"</code> or <code>"both"</code> as appropriate. Note that the
     * width required for the icons is calculated by {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} which performs a simple calculation based on the specified icon width for these types of fields.
     * <P> This setting governs default behavior for icon fields - for specific fields within a grid, this default behavior can
     * be overridden by setting an explicit {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width}
     * or explicitly enabling {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}
     * and setting {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach
     * ListGridField.autoFitWidthApproach} on the field in question.
     *
     * @return Current autoFitIconFields value. Default value is "title"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     */
    public AutoFitIconFieldType getAutoFitIconFields()  {
        return EnumUtil.getEnum(AutoFitIconFieldType.values(), getAttribute("autoFitIconFields"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides the maximum number of columns for which the ListGrid will expand. If more
     * columns are present, scrolling will be introduced to reach them as normal. If unset the ListGrid will expand to
     * accommodate as many columns as are defined for the grid.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}.
     *
     * @param autoFitMaxColumns Maximum number of fields we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * auto fit} is enabled horizontally. Default value is 50
     */
    public void setAutoFitMaxColumns(int autoFitMaxColumns) {
        setAttribute("autoFitMaxColumns", autoFitMaxColumns, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides the maximum number of columns for which the ListGrid will expand. If more
     * columns are present, scrolling will be introduced to reach them as normal. If unset the ListGrid will expand to
     * accommodate as many columns as are defined for the grid.
     *
     * @return Current autoFitMaxColumns value. Default value is 50
     */
    public int getAutoFitMaxColumns()  {
        return getAttributeAsInt("autoFitMaxColumns");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand vertically to accommodate
     * its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords} allows you to limit vertical
     * expansion based on the number of rows to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}.
     *
     * @param autoFitMaxHeight Maximum height in px we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto
     * fit} is enabled vertically. Default value is null
     */
    public void setAutoFitMaxHeight(Integer autoFitMaxHeight) {
        setAttribute("autoFitMaxHeight", autoFitMaxHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand vertically to accommodate
     * its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords} allows you to limit vertical
     * expansion based on the number of rows to be rendered.
     *
     * @return Current autoFitMaxHeight value. Default value is null
     */
    public Integer getAutoFitMaxHeight()  {
        return getAttributeAsInt("autoFitMaxHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides the maximum number of records for which the ListGrid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand
     * to accommodate as many records as are present.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}.
     *
     * @param autoFitMaxRecords Maximum number of rows we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * auto fit} is enabled vertically. Default value is 50
     */
    public void setAutoFitMaxRecords(int autoFitMaxRecords) {
        setAttribute("autoFitMaxRecords", autoFitMaxRecords, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides the maximum number of records for which the ListGrid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand
     * to accommodate as many records as are present.
     *
     * @return Current autoFitMaxRecords value. Default value is 50
     */
    public int getAutoFitMaxRecords()  {
        return getAttributeAsInt("autoFitMaxRecords");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}.
     *
     * @param autoFitMaxWidth Width we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is
     * enabled horizontally. Default value is null
     */
    public void setAutoFitMaxWidth(Integer autoFitMaxWidth) {
        setAttribute("autoFitMaxWidth", autoFitMaxWidth, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * @return Returns the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}. Note that this method
     * always returns an integer value - autoFitMaxWidth specified as a percentage will be resolved to a pixel value before
     * being returned. Default value is null
     */
    public Integer getAutoFitMaxWidth()  {
        return getAttributeAsInt("autoFitMaxWidth");
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}.
     *
     * @param autoFitMaxWidth Width we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is
     * enabled horizontally. Default value is null
     */
    public void setAutoFitMaxWidth(String autoFitMaxWidth) {
        setAttribute("autoFitMaxWidth", autoFitMaxWidth, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. Value may be specified as a numeric pixel value or a percentage value. <P> If content exceeds
     * this width, scrollbars will be introduced as usual. In addition to this property, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit horizontal
     * expansion based on the number of columns to be rendered.
     *
     * @return Returns the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}. Note that this method
     * always returns an integer value - autoFitMaxWidth specified as a percentage will be resolved to a pixel value before
     * being returned. Default value is null
     */
    public String getAutoFitMaxWidthAsString()  {
        return getAttributeAsString("autoFitMaxWidth");
    }
    

    /**
     * Should listGrids automatically size time fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type time will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth defaultTimeFieldWidth}. This static value is
     * appropriate for dates rendered with the standard time formatter. If set to <code>"title"</code> or <code>"both"</code>,
     * the drawn width of the title will be taken into account when sizing the column. <P> This is achieved by enabling {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth:true} on date fields when this property is
     * set to anything other than <code>"none"</code>, setting the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the value
     * specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth
     * defaultTimeFieldWidth} if appropriate.
     *
     * @param autoFitTimeFields New autoFitTimeFields value. Default value is "value"
     */
    public void setAutoFitTimeFields(AutoFitWidthApproach autoFitTimeFields) {
        setAttribute("autoFitTimeFields", autoFitTimeFields == null ? null : autoFitTimeFields.getValue(), true);
    }

    /**
     * Should listGrids automatically size time fields to fit their values or titles? If set to <code>"value"</code>, fields of
     * type time will be rendered at the size specified by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth defaultTimeFieldWidth}. This static value is
     * appropriate for dates rendered with the standard time formatter. If set to <code>"title"</code> or <code>"both"</code>,
     * the drawn width of the title will be taken into account when sizing the column. <P> This is achieved by enabling {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth:true} on date fields when this property is
     * set to anything other than <code>"none"</code>, setting the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach} to the value
     * specified here and having logic in {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth
     * getDefaultFieldWidth()} pick up the {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultTimeFieldWidth
     * defaultTimeFieldWidth} if appropriate.
     *
     * @return Current autoFitTimeFields value. Default value is "value"
     */
    public AutoFitWidthApproach getAutoFitTimeFields()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitTimeFields"));
    }
    

    /**
     * When a user requests column autofitting via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems header context menu} or via a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent mouse gesture}, what autofit approach is used.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}.
     *
     * @param autoFitWidthApproach new AutoFitWidth approach. Default value is "value"
     */
    public void setAutoFitWidthApproach(AutoFitWidthApproach autoFitWidthApproach) {
        setAttribute("autoFitWidthApproach", autoFitWidthApproach == null ? null : autoFitWidthApproach.getValue(), true);
    }

    /**
     * When a user requests column autofitting via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems header context menu} or via a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent mouse gesture}, what autofit approach is used.
     *
     * @return Current autoFitWidthApproach value. Default value is "value"
     */
    public AutoFitWidthApproach getAutoFitWidthApproach()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitWidthApproach"));
    }
    

    /**
     * If this ListGrid is editable, should edits be saved out when the user finishes editing a row (or a cell if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell} is true). <P> The default of <code>true</code>
     * indicates that edits will be {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell automatically saved} as the
     * user navigates through the grid and/or {@link com.smartgwt.client.types.EnterKeyEditAction hits 'Enter'} to end editing.
     * See the {@link com.smartgwt.client.docs.Editing Grid Editing} overview for details. <P> Setting
     * <code>autoSaveEdits</code> false creates a "mass update" / "mass delete" interaction where edits will be retained for
     * all edited cells (across rows if appropriate) until {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * saveEdits()} is called to save a particular row, or {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits
     * saveAllEdits()} is called to save all changes in a batch. <P> <b>Note:</b> when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByField listGrid grouping} is enabled, or when working with
     * hierarchical data in a {@link com.smartgwt.client.widgets.tree.TreeGrid}, users have the option to hide records from
     * view by collapsing the parent folder or group. This, in conjunction with <code>autoSaveEdits</code> being set to
     * <code>false</code> can lead to a case where a user is unable to save edits due to validation errors on hidden rows.
     * Therefore we recommend developers consider having validators in place such that errors are caught and displayed to the
     * user on change or editor exit rather than being caught only when saving is attempted. If it's not possible for all
     * validation to be performed immediately  on row exit, we recommend that a different UI design be used that does not
     * involve <code>autoSaveEdits</code> being set to <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param autoSaveEdits New autoSaveEdits value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setAutoSaveEdits(Boolean autoSaveEdits) {
        setAttribute("autoSaveEdits", autoSaveEdits, true);
    }

    /**
     * If this ListGrid is editable, should edits be saved out when the user finishes editing a row (or a cell if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell} is true). <P> The default of <code>true</code>
     * indicates that edits will be {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell automatically saved} as the
     * user navigates through the grid and/or {@link com.smartgwt.client.types.EnterKeyEditAction hits 'Enter'} to end editing.
     * See the {@link com.smartgwt.client.docs.Editing Grid Editing} overview for details. <P> Setting
     * <code>autoSaveEdits</code> false creates a "mass update" / "mass delete" interaction where edits will be retained for
     * all edited cells (across rows if appropriate) until {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * saveEdits()} is called to save a particular row, or {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits
     * saveAllEdits()} is called to save all changes in a batch. <P> <b>Note:</b> when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByField listGrid grouping} is enabled, or when working with
     * hierarchical data in a {@link com.smartgwt.client.widgets.tree.TreeGrid}, users have the option to hide records from
     * view by collapsing the parent folder or group. This, in conjunction with <code>autoSaveEdits</code> being set to
     * <code>false</code> can lead to a case where a user is unable to save edits due to validation errors on hidden rows.
     * Therefore we recommend developers consider having validators in place such that errors are caught and displayed to the
     * user on change or editor exit rather than being caught only when saving is attempted. If it's not possible for all
     * validation to be performed immediately  on row exit, we recommend that a different UI design be used that does not
     * involve <code>autoSaveEdits</code> being set to <code>false</code>.
     *
     * @return Current autoSaveEdits value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAutoSaveEdits()  {
        Boolean result = getAttributeAsBoolean("autoSaveEdits");
        return result == null ? true : result;
    }
    

    /**
     * If this listGrid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, setting
     * this attribute to true will cause spans to expand to accommodate long titles if necessary.
     *
     * @param autoSizeHeaderSpans New autoSizeHeaderSpans value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoSizeHeaderSpans(Boolean autoSizeHeaderSpans)  throws IllegalStateException {
        setAttribute("autoSizeHeaderSpans", autoSizeHeaderSpans, false);
    }

    /**
     * If this listGrid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, setting
     * this attribute to true will cause spans to expand to accommodate long titles if necessary.
     *
     * @return Current autoSizeHeaderSpans value. Default value is false
     */
    public Boolean getAutoSizeHeaderSpans()  {
        Boolean result = getAttributeAsBoolean("autoSizeHeaderSpans");
        return result == null ? false : result;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getShowBackgroundComponents
     * showBackgroundComponents} is <code>true</code>. <P> Canvas created and embedded in the body behind a given record.  
     * When {@link com.smartgwt.client.widgets.grid.ListGridRecord#getBackgroundComponent ListGridRecord.backgroundComponent}
     * is set, this autoChild canvas will be constructed (if listGridRecord.backgroundComponent is not already a Canvas) and
     * its properties combined with those of listGridRecord.backgroundComponent and then displayed behind a specific record in
     * the page's z-order, meaning it will only be visible if the cell styling is transparent.
     *
     * @return null
     */
    public Canvas getBackgroundComponent()  {
        return null;
    }
    

    /**
     * If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true), badFormulaResultValue is
     * displayed instead.  The default value is ".".
     *
     * @param badFormulaResultValue New badFormulaResultValue value. Default value is "."
     * @see com.smartgwt.client.docs.FormulaFields FormulaFields overview and related methods
     */
    public void setBadFormulaResultValue(String badFormulaResultValue) {
        setAttribute("badFormulaResultValue", badFormulaResultValue, true);
    }

    /**
     * If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true), badFormulaResultValue is
     * displayed instead.  The default value is ".".
     *
     * @return Current badFormulaResultValue value. Default value is "."
     * @see com.smartgwt.client.docs.FormulaFields FormulaFields overview and related methods
     */
    public String getBadFormulaResultValue()  {
        return getAttributeAsString("badFormulaResultValue");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle base cell style} for this listGrid. If this property
     * is unset, base style may be derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle
     * normalBaseStyle} or {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} as described in
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle getBaseStyle()}. <P> See {@link
     * com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined with the base style to
     * generate stateful cell styles.
     *
     * @param baseStyle New baseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setBaseStyle(String baseStyle)  throws IllegalStateException {
        setAttribute("baseStyle", baseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle base cell style} for this listGrid. If this property
     * is unset, base style may be derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle
     * normalBaseStyle} or {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} as described in
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle getBaseStyle()}. <P> See {@link
     * com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined with the base style to
     * generate stateful cell styles.
     *
     * @return Return the base styleName for this cell.  Has the following implementation by default: <ul> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle this.editFailedBaseStyle} is defined, and the     cell
     * is displaying a validation error return this value.</li> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditPendingBaseStyle this.editFailedPendingStyle} is defined, and     the
     * cell is displaying an edit value that has not yet been saved (see     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}) return this value.</li> <li>Otherwise return
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordBaseStyleProperty record[listGrid.recordBaseStyleProperty]},  
     * if defined, otherwise {@link com.smartgwt.client.widgets.grid.ListGridField#getBaseStyle field.baseStyle}.</li> </ul> If
     * no custom style is found for the cell as described above, the default baseStyle will be returned. If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is specified this will be used. Otherwise for grids
     * showing fixed height rows which match {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight
     * normalCellHeight} {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. For
     * grids with variable, or modified cell heights, {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle
     * tallBaseStyle} will be used. <P> Note also that enabling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} will cause the <code>tallBaseStyle</code>
     * to be used rather than {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle}. <P> As
     * noted under {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping}, cell content which
     * renders taller than the available space within a cell may cause rows to expand even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}  is true. This can lead to
     * misaligned rows when frozen columns are used. Developers should be aware that changing cell styling such that there is
     * increased borders or padding will reduce the available space for content within the specified cell height, making this
     * scenario more common. To fix this, specify a larger cellHeight, or set enforceVClipping to true. <p> <b>Note: This is an
     * override point.</b>. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBaseStyle()  {
        return getAttributeAsString("baseStyle");
    }
    
    

    /**
     * Background color applied to the ListGrid body (that is, the area of the grid where data values are rendered).<br> Note
     * that this will typically not be visible to the user unless there are few enough rows that there is visible space in the
     * body below the last row. To style data cells, override {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} instead.
     *
     * @param bodyBackgroundColor New bodyBackgroundColor value. Default value is "white"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setBodyBackgroundColor(String bodyBackgroundColor) {
        setAttribute("bodyBackgroundColor", bodyBackgroundColor, true);
    }

    /**
     * Background color applied to the ListGrid body (that is, the area of the grid where data values are rendered).<br> Note
     * that this will typically not be visible to the user unless there are few enough rows that there is visible space in the
     * body below the last row. To style data cells, override {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} instead.
     *
     * @return Current bodyBackgroundColor value. Default value is "white"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBodyBackgroundColor()  {
        return getAttributeAsString("bodyBackgroundColor");
    }
    

    /**
     * Overflow setting for the "body", that is, the area of the grid where data values are rendered. <P> <b>This is a very
     * advanced setting</b> which is typically only changed by subclasses of ListGrid which never show a header.  To achieve
     * auto-fitting, instead use properties such as {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData}, {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow bodyOverflow} for this listGrid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param bodyOverflow new overflow setting for the body. Default value is Canvas.AUTO
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public void setBodyOverflow(Overflow bodyOverflow) {
        setAttribute("bodyOverflow", bodyOverflow == null ? null : bodyOverflow.getValue(), true);
    }

    /**
     * Overflow setting for the "body", that is, the area of the grid where data values are rendered. <P> <b>This is a very
     * advanced setting</b> which is typically only changed by subclasses of ListGrid which never show a header.  To achieve
     * auto-fitting, instead use properties such as {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData}, {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * @return Current bodyOverflow value. Default value is Canvas.AUTO
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Overflow getBodyOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("bodyOverflow"));
    }
    

    /**
     * CSS style used for the body of this grid.  If applying a background-color to the body via a CSS style applied using this
     * property, be sure to set {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyBackgroundColor bodyBackgroundColor} to
     * <code>null</code>.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName bodyStyleName} for this listGrid.
     *
     * @param bodyStyleName new body style name. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setBodyStyleName(String bodyStyleName) {
        setAttribute("bodyStyleName", bodyStyleName, true);
    }

    /**
     * CSS style used for the body of this grid.  If applying a background-color to the body via a CSS style applied using this
     * property, be sure to set {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyBackgroundColor bodyBackgroundColor} to
     * <code>null</code>.
     *
     * @return Current bodyStyleName value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBodyStyleName()  {
        return getAttributeAsString("bodyStyleName");
    }
    

    /**
     * An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is enabled, the base style is
     * suffixed with "True", "False", or "Partial" if the checkbox is selected, unselected, or partially selected; if the
     * checkbox is disabled, the suffix is "TrueDisabled", "FalseDisabled", or "PartialDisabled". <p> <b>NOTE:</b> This
     * attribute is not supported by {@link com.smartgwt.client.widgets.tree.TreeGrid}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanBaseStyle New booleanBaseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanBaseStyle(String booleanBaseStyle)  throws IllegalStateException {
        setAttribute("booleanBaseStyle", booleanBaseStyle, false);
    }

    /**
     * An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is enabled, the base style is
     * suffixed with "True", "False", or "Partial" if the checkbox is selected, unselected, or partially selected; if the
     * checkbox is disabled, the suffix is "TrueDisabled", "FalseDisabled", or "PartialDisabled". <p> <b>NOTE:</b> This
     * attribute is not supported by {@link com.smartgwt.client.widgets.tree.TreeGrid}.
     *
     * @return Current booleanBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanBaseStyle()  {
        return getAttributeAsString("booleanBaseStyle");
    }
    

    /**
     * Image to display for a false value in a boolean field. Default <code>null</code> value or the special value "blank"
     * means no image will be displayed. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getUncheckedImage CheckboxItem.uncheckedImage}. <P>
     * <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean false" appearance.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanFalseImage New booleanFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanFalseImage(String booleanFalseImage) {
        setAttribute("booleanFalseImage", booleanFalseImage, true);
    }

    /**
     * Image to display for a false value in a boolean field. Default <code>null</code> value or the special value "blank"
     * means no image will be displayed. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getUncheckedImage CheckboxItem.uncheckedImage}. <P>
     * <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean false" appearance.
     *
     * @return Current booleanFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanFalseImage()  {
        return getAttributeAsString("booleanFalseImage");
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconHeight CheckboxItem.valueIconHeight}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanImageHeight New booleanImageHeight value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanImageHeight(int booleanImageHeight) {
        setAttribute("booleanImageHeight", booleanImageHeight, true);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconHeight CheckboxItem.valueIconHeight}.
     *
     * @return Current booleanImageHeight value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getBooleanImageHeight()  {
        return getAttributeAsInt("booleanImageHeight");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconWidth CheckboxItem.valueIconWidth}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanImageWidth New booleanImageWidth value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanImageWidth(int booleanImageWidth) {
        setAttribute("booleanImageWidth", booleanImageWidth, true);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage} will be used to indicate
     * a true value in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconWidth CheckboxItem.valueIconWidth}.
     *
     * @return Current booleanImageWidth value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getBooleanImageWidth()  {
        return getAttributeAsInt("booleanImageWidth");
    }
    

    /**
     * Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means
     * that no image will be shown. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true. <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPartialSelectedImage
     * CheckboxItem.partialSelectedImage}. <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image,
     * by setting this property to a {@link com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers
     * can omit this property and instead use CSS directly in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property to provide a "boolean true"
     * appearance.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanPartialImage New booleanPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanPartialImage(String booleanPartialImage) {
        setAttribute("booleanPartialImage", booleanPartialImage, true);
    }

    /**
     * Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means
     * that no image will be shown. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon ListGridField.suppressValueIcon} to true. <P> If
     * this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPartialSelectedImage
     * CheckboxItem.partialSelectedImage}. <P> {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image,
     * by setting this property to a {@link com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers
     * can omit this property and instead use CSS directly in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property to provide a "boolean true"
     * appearance.
     *
     * @return Current booleanPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanPartialImage()  {
        return getAttributeAsString("booleanPartialImage");
    }
    

    /**
     * Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown. <P>
     * To turn this off explicitly set {@link com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon
     * ListGridField.suppressValueIcon} to true. <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage}. <P>
     * {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean true" appearance.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanTrueImage New booleanTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanTrueImage(String booleanTrueImage) {
        setAttribute("booleanTrueImage", booleanTrueImage, true);
    }

    /**
     * Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown. <P>
     * To turn this off explicitly set {@link com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon
     * ListGridField.suppressValueIcon} to true. <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage CheckboxItem.checkedImage}. <P>
     * {@link com.smartgwt.client.docs.Skinning Spriting} can be used for this image, by setting this property to a {@link
     * com.smartgwt.client.docs.SCSpriteConfig} formatted string. Alternatively developers can omit this property and instead
     * use CSS directly in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} property
     * to provide a "boolean true" appearance.
     *
     * @return Current booleanTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanTrueImage()  {
        return getAttributeAsString("booleanTrueImage");
    }
    

    /**
     * Indicates whether records can be dropped into this listGrid.
     *
     * @param canAcceptDroppedRecords New canAcceptDroppedRecords value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     */
    public void setCanAcceptDroppedRecords(Boolean canAcceptDroppedRecords) {
        setAttribute("canAcceptDroppedRecords", canAcceptDroppedRecords, true);
    }

    /**
     * Indicates whether records can be dropped into this listGrid.
     *
     * @return Current canAcceptDroppedRecords value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     */
    public Boolean getCanAcceptDroppedRecords()  {
        Boolean result = getAttributeAsBoolean("canAcceptDroppedRecords");
        return result == null ? false : result;
    }
    
    
    

    /**
     * Can the user perform one-time autofit for specific columns in this grid? <P> If set to true, the default header menu
     * will include options to auto fit {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitAllText all fields} such
     * that they fit their content or titles as specified via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach}.<br>
     * Autofitting of individual fields via a {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldText header
     * context menu item}, or the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent}
     * will also be enabled when this property is set unless {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is explicitly set to
     * false <P> Note that the ability to perform one-time autofitting of fields via this  subsystem is separate from the
     * programmatic autofit behavior enabled  via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths}. <P> This subsystem is requires canResizeFields be enabled and will be disabled if that property is
     * set to false
     *
     * @param canAutoFitFields New canAutoFitFields value. Default value is true
     */
    public void setCanAutoFitFields(Boolean canAutoFitFields) {
        setAttribute("canAutoFitFields", canAutoFitFields, true);
    }

    /**
     * Can the user perform one-time autofit for specific columns in this grid? <P> If set to true, the default header menu
     * will include options to auto fit {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitAllText all fields} such
     * that they fit their content or titles as specified via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach ListGridField.autoFitWidthApproach}.<br>
     * Autofitting of individual fields via a {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldText header
     * context menu item}, or the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent}
     * will also be enabled when this property is set unless {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is explicitly set to
     * false <P> Note that the ability to perform one-time autofitting of fields via this  subsystem is separate from the
     * programmatic autofit behavior enabled  via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths}. <P> This subsystem is requires canResizeFields be enabled and will be disabled if that property is
     * set to false
     *
     * @return Current canAutoFitFields value. Default value is true
     */
    public Boolean getCanAutoFitFields()  {
        Boolean result = getAttributeAsBoolean("canAutoFitFields");
        return result == null ? true : result;
    }
    

    /**
     * If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true this property is used as the message
     * to display in the confirmation dismissal prompt.
     *
     * @param cancelEditingConfirmationMessage New cancelEditingConfirmationMessage value. Default value is Cancelling this edit will discard unsaved changes for this record. Continue?
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setCancelEditingConfirmationMessage(String cancelEditingConfirmationMessage) {
        setAttribute("cancelEditingConfirmationMessage", cancelEditingConfirmationMessage, true);
    }

    /**
     * If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true this property is used as the message
     * to display in the confirmation dismissal prompt.
     *
     * @return Current cancelEditingConfirmationMessage value. Default value is Cancelling this edit will discard unsaved changes for this record. Continue?
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getCancelEditingConfirmationMessage()  {
        return getAttributeAsString("cancelEditingConfirmationMessage");
    }
    

    /**
     * Can a group be collapsed/expanded? When true a collapse/expand icon is shown ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon}) and the user can collapse or expand the group by
     * clicking either the row as a whole or the opener icon (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCollapseGroupOnRowClick collapseGroupOnRowClick}); When false the group
     * icon is not shown and clicking on the row does not change group state. Additionally {@link
     * com.smartgwt.client.types.GroupStartOpen groupStartOpen} is initialized to "all".
     *
     * @param canCollapseGroup New canCollapseGroup value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setCanCollapseGroup(Boolean canCollapseGroup)  throws IllegalStateException {
        setAttribute("canCollapseGroup", canCollapseGroup, false);
    }

    /**
     * Can a group be collapsed/expanded? When true a collapse/expand icon is shown ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon}) and the user can collapse or expand the group by
     * clicking either the row as a whole or the opener icon (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCollapseGroupOnRowClick collapseGroupOnRowClick}); When false the group
     * icon is not shown and clicking on the row does not change group state. Additionally {@link
     * com.smartgwt.client.types.GroupStartOpen groupStartOpen} is initialized to "all".
     *
     * @return Current canCollapseGroup value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getCanCollapseGroup()  {
        Boolean result = getAttributeAsBoolean("canCollapseGroup");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether records can be dragged from this listGrid and dropped elsewhere. <p> <strong>NOTE:</strong> If
     * <code>canDragRecordsOut</code> is initially enabled or might be dynamically enabled after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a drag operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag and drop of records out of the grid.
     *
     * @param canDragRecordsOut New canDragRecordsOut value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_records_across_windows" target="examples">Records across Windows Example</a>
     */
    public void setCanDragRecordsOut(Boolean canDragRecordsOut) {
        setAttribute("canDragRecordsOut", canDragRecordsOut, true);
    }

    /**
     * Indicates whether records can be dragged from this listGrid and dropped elsewhere. <p> <strong>NOTE:</strong> If
     * <code>canDragRecordsOut</code> is initially enabled or might be dynamically enabled after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a drag operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag and drop of records out of the grid.
     *
     * @return Current canDragRecordsOut value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_records_across_windows" target="examples">Records across Windows Example</a>
     */
    public Boolean getCanDragRecordsOut()  {
        Boolean result = getAttributeAsBoolean("canDragRecordsOut");
        return result == null ? false : result;
    }
    

    /**
     * If this property is true, users can drag the mouse to select several rows or cells.  This is mutually exclusive with
     * rearranging rows or cells by dragging. <p> <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or
     * might be dynamically enabled after the grid is created, it may be desirable to disable {@link
     * com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that touch-dragging records/cells selects
     * them rather than starting a scroll. If {@link com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag
     * Canvas.disableTouchScrollingForDrag} is set to <code>true</code>, then touch scrolling will be disabled automatically.
     * However, for {@link com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch
     * scrolling enabled and provide an alternative set of controls that can be used to perform drag-selection.
     *
     * @param canDragSelect New canDragSelect value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_select_list" target="examples">Drag list (select) Example</a>
     */
    public void setCanDragSelect(Boolean canDragSelect) {
        setAttribute("canDragSelect", canDragSelect, true);
    }

    /**
     * If this property is true, users can drag the mouse to select several rows or cells.  This is mutually exclusive with
     * rearranging rows or cells by dragging. <p> <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or
     * might be dynamically enabled after the grid is created, it may be desirable to disable {@link
     * com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that touch-dragging records/cells selects
     * them rather than starting a scroll. If {@link com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag
     * Canvas.disableTouchScrollingForDrag} is set to <code>true</code>, then touch scrolling will be disabled automatically.
     * However, for {@link com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch
     * scrolling enabled and provide an alternative set of controls that can be used to perform drag-selection.
     *
     * @return Current canDragSelect value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_select_list" target="examples">Drag list (select) Example</a>
     */
    public Boolean getCanDragSelect()  {
        Boolean result = getAttributeAsBoolean("canDragSelect");
        return result == null ? false : result;
    }
    

    /**
     * If this property is true, users can drag the mouse to select text within grid rows, ready to be cliped to clipboard.<br>
     * This is mutually exclusive with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords rearranging rows
     * or cells by dragging}, and with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelect drag selection of
     * rows}. <P> To enable selecting cell text on click, see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectCellTextOnClick selectCellTextOnClick}.
     *
     * @param canDragSelectText New canDragSelectText value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setCanDragSelectText(Boolean canDragSelectText) {
        setAttribute("canDragSelectText", canDragSelectText, true);
    }

    /**
     * If this property is true, users can drag the mouse to select text within grid rows, ready to be cliped to clipboard.<br>
     * This is mutually exclusive with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords rearranging rows
     * or cells by dragging}, and with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelect drag selection of
     * rows}. <P> To enable selecting cell text on click, see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectCellTextOnClick selectCellTextOnClick}.
     *
     * @return Current canDragSelectText value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getCanDragSelectText()  {
        Boolean result = getAttributeAsBoolean("canDragSelectText");
        return result == null ? false : result;
    }
    

    /**
     * If set to false, dropping over an empty part of the grid body is disallowed and the no-drop indicator is displayed.
     *
     * @param canDropInEmptyArea New canDropInEmptyArea value. Default value is true
     * @see com.smartgwt.client.docs.Dragdrop Dragdrop overview and related methods
     */
    public void setCanDropInEmptyArea(Boolean canDropInEmptyArea) {
        setAttribute("canDropInEmptyArea", canDropInEmptyArea, true);
    }

    /**
     * If set to false, dropping over an empty part of the grid body is disallowed and the no-drop indicator is displayed.
     *
     * @return Current canDropInEmptyArea value. Default value is true
     * @see com.smartgwt.client.docs.Dragdrop Dragdrop overview and related methods
     */
    public Boolean getCanDropInEmptyArea()  {
        Boolean result = getAttributeAsBoolean("canDropInEmptyArea");
        return result == null ? true : result;
    }
    

    /**
     * Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for      individual fields.<br>   
     * If 'canEdit' is false at the listGrid level, fields can never be edited - in this case      the canEdit property on
     * individual fields will be ignored.<br>      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit'
     * property to      false at the field level will prevent the field from being edited inline unless a      custom override
     * of {@link com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} allows it.<br>      If 'canEdit' is not
     * set at the listGrid level, setting 'canEdit' to true at the field      level enables the field to be edited inline.
     *
     * @param canEdit New canEdit value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordEditProperty
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public void setCanEdit(Boolean canEdit) {
        setAttribute("canEdit", canEdit, true);
    }

    /**
     * Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for      individual fields.<br>   
     * If 'canEdit' is false at the listGrid level, fields can never be edited - in this case      the canEdit property on
     * individual fields will be ignored.<br>      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit'
     * property to      false at the field level will prevent the field from being edited inline unless a      custom override
     * of {@link com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} allows it.<br>      If 'canEdit' is not
     * set at the listGrid level, setting 'canEdit' to true at the field      level enables the field to be edited inline.
     *
     * @return Current canEdit value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFields
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public Boolean getCanEdit()  {
        return getAttributeAsBoolean("canEdit");
    }
    

    /**
     * If this component is bound to a dataSource, this attribute may be specified to customize what fields from the dataSource
     * may be edited by default. For example the {@link com.smartgwt.client.widgets.form.SearchForm} class has this attribute
     * set to <code>"canFilter"</code> which allows search forms to edit dataSource fields marked as <code>canEdit:false</code>
     * (but not those marked as <code>canFilter:false</code>). <P> Note that if <code>canEdit</code> is explicitly specified on
     * a field in  the {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields} array, that
     * property will be respected in preference to  the canEditAttribute value. (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit FormItem.canEdit}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanEdit ListGridField.canEdit}). Also note that individual
     * dataBoundComponents may have additional logic around whether a field can be edited - for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} may be overridden.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canEditFieldAttribute New canEditFieldAttribute value. Default value is "canEdit"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanEditFieldAttribute(String canEditFieldAttribute)  throws IllegalStateException {
        setAttribute("canEditFieldAttribute", canEditFieldAttribute, false);
    }

    /**
     * If this component is bound to a dataSource, this attribute may be specified to customize what fields from the dataSource
     * may be edited by default. For example the {@link com.smartgwt.client.widgets.form.SearchForm} class has this attribute
     * set to <code>"canFilter"</code> which allows search forms to edit dataSource fields marked as <code>canEdit:false</code>
     * (but not those marked as <code>canFilter:false</code>). <P> Note that if <code>canEdit</code> is explicitly specified on
     * a field in  the {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields} array, that
     * property will be respected in preference to  the canEditAttribute value. (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit FormItem.canEdit}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanEdit ListGridField.canEdit}). Also note that individual
     * dataBoundComponents may have additional logic around whether a field can be edited - for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#canEditCell canEditCell()} may be overridden.
     *
     * @return Current canEditFieldAttribute value. Default value is "canEdit"
     */
    public String getCanEditFieldAttribute()  {
        return getAttributeAsString("canEditFieldAttribute");
    }
    

    /**
     * Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the {@link
     * com.smartgwt.client.widgets.grid.HiliteEditor}. <P> User-added hilites can be persisted via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteState DataBoundComponent.getHiliteState()} and  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHiliteState DataBoundComponent.setHiliteState()}.
     *
     * @param canEditHilites New canEditHilites value. Default value is false
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setCanEditHilites(boolean canEditHilites) {
        setAttribute("canEditHilites", canEditHilites, true);
    }

    /**
     * Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the {@link
     * com.smartgwt.client.widgets.grid.HiliteEditor}. <P> User-added hilites can be persisted via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteState DataBoundComponent.getHiliteState()} and  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHiliteState DataBoundComponent.setHiliteState()}.
     *
     * @return Current canEditHilites value. Default value is false
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public boolean getCanEditHilites()  {
        Boolean result = getAttributeAsBoolean("canEditHilites");
        return result == null ? false : result;
    }
    

    /**
     * If set to true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker advanced field picker}
     * provides an interface allowing users to modify fields' titles. <P> Note that when enabled, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFieldState field state} for this component will include field titles.
     *
     * @param canEditTitles New canEditTitles value. Default value is false
     */
    public void setCanEditTitles(boolean canEditTitles) {
        setAttribute("canEditTitles", canEditTitles, true);
    }

    /**
     * If set to true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker advanced field picker}
     * provides an interface allowing users to modify fields' titles. <P> Note that when enabled, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFieldState field state} for this component will include field titles.
     *
     * @return Current canEditTitles value. Default value is false
     */
    public boolean getCanEditTitles()  {
        Boolean result = getAttributeAsBoolean("canEditTitles");
        return result == null ? false : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this property
     * indicates whether multiple records can be expanded simultaneously.  If set to false, expanding a record will
     * automatically collapse any record which is already expanded.  The default value is <code>true</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canExpandMultipleRecords New canExpandMultipleRecords value. Default value is true
     */
    public void setCanExpandMultipleRecords(Boolean canExpandMultipleRecords) {
        setAttribute("canExpandMultipleRecords", canExpandMultipleRecords, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this property
     * indicates whether multiple records can be expanded simultaneously.  If set to false, expanding a record will
     * automatically collapse any record which is already expanded.  The default value is <code>true</code>.
     *
     * @return Current canExpandMultipleRecords value. Default value is true
     */
    public Boolean getCanExpandMultipleRecords()  {
        Boolean result = getAttributeAsBoolean("canExpandMultipleRecords");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record can be expanded.
     *
     * @param canExpandRecordProperty New canExpandRecordProperty value. Default value is "canExpand"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanExpand
     */
    public void setCanExpandRecordProperty(String canExpandRecordProperty)  throws IllegalStateException {
        setAttribute("canExpandRecordProperty", canExpandRecordProperty, false);
    }

    /**
     * Property name on a record that will be checked to determine whether a record can be expanded.
     *
     * @return Current canExpandRecordProperty value. Default value is "canExpand"
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanExpand
     */
    public String getCanExpandRecordProperty()  {
        return getAttributeAsString("canExpandRecordProperty");
    }
    

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) to allow users to expand
     * and collapse individual records. See {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord expandRecord()} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} for details on record expansion. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} is automatically enabled when
     * canExpandRecords is set to true. <P> Note that expanded records are not currently supported in conjunction with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canExpandRecords new value for listGrid.canExpandRecords. Default value is false
     */
    public void setCanExpandRecords(Boolean canExpandRecords) {
        setAttribute("canExpandRecords", canExpandRecords, true);
    }

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) to allow users to expand
     * and collapse individual records. See {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord expandRecord()} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} for details on record expansion. <P>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} is automatically enabled when
     * canExpandRecords is set to true. <P> Note that expanded records are not currently supported in conjunction with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}.
     *
     * @return Current canExpandRecords value. Default value is false
     */
    public Boolean getCanExpandRecords()  {
        Boolean result = getAttributeAsBoolean("canExpandRecords");
        return result == null ? false : result;
    }
    

    /**
     * If the listGrid is empty, should the user be able to put focus into the grid body by tabbing to it? <P> Note that if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} is true for this grid and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} is set to next, having this property
     * set to true will allow users to automatically create a new edit row by simply tabbing into the grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canFocusInEmptyGrid New canFocusInEmptyGrid value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanFocusInEmptyGrid(boolean canFocusInEmptyGrid)  throws IllegalStateException {
        setAttribute("canFocusInEmptyGrid", canFocusInEmptyGrid, false);
    }

    /**
     * If the listGrid is empty, should the user be able to put focus into the grid body by tabbing to it? <P> Note that if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} is true for this grid and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} is set to next, having this property
     * set to true will allow users to automatically create a new edit row by simply tabbing into the grid.
     *
     * @return Current canFocusInEmptyGrid value. Default value is true
     */
    public boolean getCanFocusInEmptyGrid()  {
        Boolean result = getAttributeAsBoolean("canFocusInEmptyGrid");
        return result == null ? true : result;
    }
    

    /**
     * Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect
     * to horizontally scrolling. If unset, this property defaults to <code>true</code> unless:<ul> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights this.fixedRecordHeights} is <code>false</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow this.bodyOverflow} is <code>"visible"</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData this.autoFitData} is set to
     * <code>"horizontal"</code> or <code>"both"</code></li> <li>Any field has overflow set to <code>"visible"</code></li></ul>
     * <P> Note that the <code>canFreezeFields</code> setting enables or disables the user interface for freezing and
     * unfreezing fields only.  Fields can be programmatically frozen via setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen field.frozen} to true when the grid is created, or dynamically
     * frozen and unfrozen via {@link com.smartgwt.client.widgets.grid.ListGrid#freezeField freezeField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unfreezeField unfreezeField()}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter method for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields canFreezeFields}
     *
     * @param canFreezeFields New value for <code>listGrid.canFreezeFields</code>. Default value is null
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setCanFreezeFields(Boolean canFreezeFields) {
        setAttribute("canFreezeFields", canFreezeFields, true);
    }

    /**
     * Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect
     * to horizontally scrolling. If unset, this property defaults to <code>true</code> unless:<ul> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights this.fixedRecordHeights} is <code>false</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow this.bodyOverflow} is <code>"visible"</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData this.autoFitData} is set to
     * <code>"horizontal"</code> or <code>"both"</code></li> <li>Any field has overflow set to <code>"visible"</code></li></ul>
     * <P> Note that the <code>canFreezeFields</code> setting enables or disables the user interface for freezing and
     * unfreezing fields only.  Fields can be programmatically frozen via setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen field.frozen} to true when the grid is created, or dynamically
     * frozen and unfrozen via {@link com.smartgwt.client.widgets.grid.ListGrid#freezeField freezeField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unfreezeField unfreezeField()}.
     *
     * @return Current canFreezeFields value. Default value is null
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public Boolean getCanFreezeFields()  {
        return getAttributeAsBoolean("canFreezeFields");
    }
    

    /**
     * If false, grouping via context menu will be disabled.
     *
     * @param canGroupBy New canGroupBy value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setCanGroupBy(Boolean canGroupBy) {
        setAttribute("canGroupBy", canGroupBy, true);
    }

    /**
     * If false, grouping via context menu will be disabled.
     *
     * @return Current canGroupBy value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getCanGroupBy()  {
        Boolean result = getAttributeAsBoolean("canGroupBy");
        return result == null ? true : result;
    }
    

    /**
     * If true, cellHover and rowHover events will fire and then a hover will be shown (if not canceled) when the user leaves
     * the mouse over a row / cell unless the corresponding field has {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} set to false. If unset or null, the hover will be
     * shown if the corresponding field has showHover:true. If false, then hovers are disabled. <p> Note that standard hovers
     * override {@link com.smartgwt.client.widgets.grid.ListGrid#getShowClippedValuesOnHover clipped value hovers}. Thus, to
     * enable clipped value hovers, canHover must be unset or null and the corresponding field must have showHover unset or
     * null as well.
     *
     * @param canHover New canHover value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowHover
     * @see com.smartgwt.client.widgets.grid.ListGridField#setShowHover
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_value_hover" target="examples">Value hover tips Example</a>
     */
    public void setCanHover(Boolean canHover) {
        setAttribute("canHover", canHover, true);
    }

    /**
     * If true, cellHover and rowHover events will fire and then a hover will be shown (if not canceled) when the user leaves
     * the mouse over a row / cell unless the corresponding field has {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} set to false. If unset or null, the hover will be
     * shown if the corresponding field has showHover:true. If false, then hovers are disabled. <p> Note that standard hovers
     * override {@link com.smartgwt.client.widgets.grid.ListGrid#getShowClippedValuesOnHover clipped value hovers}. Thus, to
     * enable clipped value hovers, canHover must be unset or null and the corresponding field must have showHover unset or
     * null as well.
     *
     * @return Current canHover value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowHover
     * @see com.smartgwt.client.widgets.grid.ListGridField#getShowHover
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_value_hover" target="examples">Value hover tips Example</a>
     */
    public Boolean getCanHover()  {
        return getAttributeAsBoolean("canHover");
    }
    

    /**
     * When true, indicates that this ListGrid supports grouping on multiple fields.
     *
     * @param canMultiGroup New canMultiGroup value. Default value is false
     */
    public void setCanMultiGroup(boolean canMultiGroup) {
        setAttribute("canMultiGroup", canMultiGroup, true);
    }

    /**
     * When true, indicates that this ListGrid supports grouping on multiple fields.
     *
     * @return Current canMultiGroup value. Default value is false
     */
    public boolean getCanMultiGroup()  {
        Boolean result = getAttributeAsBoolean("canMultiGroup");
        return result == null ? false : result;
    }
    

    /**
     * When true, indicates that this ListGrid supports sorting on multiple fields.  Note that even when set to true,
     * multi-field sorting may not be available if the grid is databound and the {@link
     * com.smartgwt.client.data.DataSource#getCanMultiSort DataSource doesn't support multi-sort}, or if sorting for a field is
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getCanSortClientOnly client-only} but not all data is available.
     *
     * @param canMultiSort New canMultiSort value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortNumeralMenuButtonSpaceOffset
     */
    public void setCanMultiSort(Boolean canMultiSort) {
        setAttribute("canMultiSort", canMultiSort, true);
    }

    /**
     * When true, indicates that this ListGrid supports sorting on multiple fields.  Note that even when set to true,
     * multi-field sorting may not be available if the grid is databound and the {@link
     * com.smartgwt.client.data.DataSource#getCanMultiSort DataSource doesn't support multi-sort}, or if sorting for a field is
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getCanSortClientOnly client-only} but not all data is available.
     *
     * @return Current canMultiSort value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortNumeralMenuButtonSpaceOffset
     */
    public Boolean getCanMultiSort()  {
        Boolean result = getAttributeAsBoolean("canMultiSort");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether the field picker item and submenu should be present in the header context menu. This menu allows the
     * user to hide visible fields and show hidden fields. <p> By default only fields explicitly included in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array will be available in this menu, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickOmittedFields canPickOmittedFields} is set to true for a databound
     * grid. <p> A specific field can be omitted from the column picker via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanHide ListGridField.canHide}.
     *
     * @param canPickFields New canPickFields value. Default value is true
     */
    public void setCanPickFields(Boolean canPickFields) {
        setAttribute("canPickFields", canPickFields, true);
    }

    /**
     * Indicates whether the field picker item and submenu should be present in the header context menu. This menu allows the
     * user to hide visible fields and show hidden fields. <p> By default only fields explicitly included in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array will be available in this menu, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickOmittedFields canPickOmittedFields} is set to true for a databound
     * grid. <p> A specific field can be omitted from the column picker via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanHide ListGridField.canHide}.
     *
     * @return Current canPickFields value. Default value is true
     */
    public Boolean getCanPickFields()  {
        Boolean result = getAttributeAsBoolean("canPickFields");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAllDataSourceFields useAllDataSourceFields} is false, setting this
     * property to true will cause all dataSource fields not included in the specified set of fields to show up in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields field picker menu item}. <P> Has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} is unset (as in this case all dataSource fields will be
     * displayed by default), or if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields canPickFields} is false.
     *
     * @param canPickOmittedFields New canPickOmittedFields value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanPickOmittedFields(Boolean canPickOmittedFields)  throws IllegalStateException {
        setAttribute("canPickOmittedFields", canPickOmittedFields, false);
    }

    /**
     * If this grid has a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAllDataSourceFields useAllDataSourceFields} is false, setting this
     * property to true will cause all dataSource fields not included in the specified set of fields to show up in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields field picker menu item}. <P> Has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} is unset (as in this case all dataSource fields will be
     * displayed by default), or if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields canPickFields} is false.
     *
     * @return Current canPickOmittedFields value. Default value is false
     */
    public Boolean getCanPickOmittedFields()  {
        Boolean result = getAttributeAsBoolean("canPickOmittedFields");
        return result == null ? false : result;
    }
    

    /**
     * If set, provide UI for the user to remove records from the grid as an additional field showing the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon}, which, when clicked, will call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeRecordClick removeRecordClick()} which removes the row from the data set
     * (or if {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true changes the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved markRecordRemoved()} status for the record). Individual
     * records can be marked to prevent removal - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCanRemoveProperty recordCanRemoveProperty}. <P> To add a confirmation
     * dialog before a record is removed, set {@link com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval}.
     * <P> If deferring removal, the record will appear marked with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} until the removal is committed via a call to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits saveEdits()}. Otherwise, the record will disappear from view.
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animateRemoveRecord} is true, the removed
     * record will appear to shrink out of view when it is removed. <P> By default the field will display the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon} next to each record, and will be rendered as the
     * rightmost column. Two mechanisms exist to further modify this field: <ul> <li>To change the position of the
     * remove-field, include an explicitly specified field with     the attribute {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIsRemoveField isRemoveField:true} set. This will then     be used as
     * the remove field instead of adding a field to the beginning of the set of     columns.</li> <li>Additional direct
     * configuration of the remove field may be achieved by modifying     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldProperties removeFieldProperties}.</li> </ul> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true, when a record is marked as removed, the
     * the icon will change to display the {@link com.smartgwt.client.widgets.grid.ListGrid#getUnremoveIcon unremoveIcon} for
     * this row. Clicking on this icon will call {@link com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved
     * unmarkRecordRemoved()} to mark the record as no longer pending deletion.
     *
     * @param canRemoveRecords New canRemoveRecords value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setCanRemoveRecords(Boolean canRemoveRecords)  throws IllegalStateException {
        setAttribute("canRemoveRecords", canRemoveRecords, false);
    }

    /**
     * If set, provide UI for the user to remove records from the grid as an additional field showing the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon}, which, when clicked, will call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeRecordClick removeRecordClick()} which removes the row from the data set
     * (or if {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true changes the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved markRecordRemoved()} status for the record). Individual
     * records can be marked to prevent removal - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCanRemoveProperty recordCanRemoveProperty}. <P> To add a confirmation
     * dialog before a record is removed, set {@link com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval}.
     * <P> If deferring removal, the record will appear marked with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} until the removal is committed via a call to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits saveEdits()}. Otherwise, the record will disappear from view.
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animateRemoveRecord} is true, the removed
     * record will appear to shrink out of view when it is removed. <P> By default the field will display the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon} next to each record, and will be rendered as the
     * rightmost column. Two mechanisms exist to further modify this field: <ul> <li>To change the position of the
     * remove-field, include an explicitly specified field with     the attribute {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIsRemoveField isRemoveField:true} set. This will then     be used as
     * the remove field instead of adding a field to the beginning of the set of     columns.</li> <li>Additional direct
     * configuration of the remove field may be achieved by modifying     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldProperties removeFieldProperties}.</li> </ul> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true, when a record is marked as removed, the
     * the icon will change to display the {@link com.smartgwt.client.widgets.grid.ListGrid#getUnremoveIcon unremoveIcon} for
     * this row. Clicking on this icon will call {@link com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved
     * unmarkRecordRemoved()} to mark the record as no longer pending deletion.
     *
     * @return Current canRemoveRecords value. Default value is false
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getCanRemoveRecords()  {
        Boolean result = getAttributeAsBoolean("canRemoveRecords");
        return result == null ? false : result;
    }
    

    /**
     * Indicates whether fields in this listGrid can be reordered by dragging and dropping header fields.  If true, can be
     * overridden at the field level via  {@link com.smartgwt.client.widgets.grid.ListGridField#getCanReorder
     * ListGridField.canReorder}.
     *
     * @param canReorderFields New canReorderFields value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public void setCanReorderFields(Boolean canReorderFields) {
        setAttribute("canReorderFields", canReorderFields, true);
    }

    /**
     * Indicates whether fields in this listGrid can be reordered by dragging and dropping header fields.  If true, can be
     * overridden at the field level via  {@link com.smartgwt.client.widgets.grid.ListGridField#getCanReorder
     * ListGridField.canReorder}.
     *
     * @return Current canReorderFields value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public Boolean getCanReorderFields()  {
        Boolean result = getAttributeAsBoolean("canReorderFields");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether records can be reordered by dragging within this <code>ListGrid</code>. <p> <strong>NOTE:</strong> If
     * <code>canReorderRecords</code> is initially enabled or might be {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCanReorderRecords dynamically enabled} after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a reorder operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag-reordering of records.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords canReorderRecords} attribute.
     *
     * @param canReorderRecords new value for <code>this.canReorderRecords</code>. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_drag_reorder" target="examples">Drag reorder Example</a>
     */
    public void setCanReorderRecords(Boolean canReorderRecords) {
        setAttribute("canReorderRecords", canReorderRecords, true);
    }

    /**
     * Indicates whether records can be reordered by dragging within this <code>ListGrid</code>. <p> <strong>NOTE:</strong> If
     * <code>canReorderRecords</code> is initially enabled or might be {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCanReorderRecords dynamically enabled} after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a reorder operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag Canvas.disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag-reordering of records.
     *
     * @return Current canReorderRecords value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_drag_reorder" target="examples">Drag reorder Example</a>
     */
    public Boolean getCanReorderRecords()  {
        Boolean result = getAttributeAsBoolean("canReorderRecords");
        return result == null ? false : result;
    }
    

    /**
     * Indicates whether fields in this listGrid can be resized by dragging header fields.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter method for updating {@link com.smartgwt.client.widgets.grid.ListGrid#getCanResizeFields canResizeFields} at runtime.
     *
     * @param canResizeFields new value for this.canResizeFields. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnsize" target="examples">Column size Example</a>
     */
    public void setCanResizeFields(Boolean canResizeFields) {
        setAttribute("canResizeFields", canResizeFields, true);
    }

    /**
     * Indicates whether fields in this listGrid can be resized by dragging header fields.
     *
     * @return Current canResizeFields value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnsize" target="examples">Column size Example</a>
     */
    public Boolean getCanResizeFields()  {
        Boolean result = getAttributeAsBoolean("canResizeFields");
        return result == null ? true : result;
    }
    

    /**
     * Controls whether a checkbox for selecting all records appears in the header with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} set to "checkbox"
     *
     * @param canSelectAll New canSelectAll value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setCanSelectAll(Boolean canSelectAll) {
        setAttribute("canSelectAll", canSelectAll, true);
    }

    /**
     * Controls whether a checkbox for selecting all records appears in the header with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} set to "checkbox"
     *
     * @return Current canSelectAll value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getCanSelectAll()  {
        return getAttributeAsBoolean("canSelectAll");
    }
    

    /**
     * Enables cell-level selection behavior as well as {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers
     * cell-level rollover}. <P> To query and manipulate cell-level selections, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellSelection getCellSelection()} to retrieve the {@link
     * com.smartgwt.client.widgets.grid.CellSelection}. <P> Note that the ListGrid has a data model of one {@link
     * com.smartgwt.client.data.Record} per row, unlike the {@link com.smartgwt.client.widgets.cube.CubeGrid} which supports
     * one {@link com.smartgwt.client.widgets.cube.CellRecord} per cell.  For this reason record-oriented APIs that act on the
     * selection will act on entire Records that have <i>any</i> selected cells (examples include drag and drop and
     * transferSelectedData()). <P> More generally, <code>canSelectCells</code> is primarily intended to enable developers to
     * build Excel-like interactions on local datasets, by using {@link com.smartgwt.client.widgets.grid.ListGrid#setData
     * setData()} plus {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}:true rather than
     * record-oriented DataSources and data binding. <P> The following keyboard selection behaviors are enabled with this
     * property in addition to standard single-selection Arrow Key navigation: <P> SHIFT +        [Arrow Key]:  begin or
     * continue incremental selection <P> SHIFT + CTRL + [Arrow Key]:  incremental selection to the end of row or column <P>
     * CTRL  + A: select all cells (enabled only with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll
     * canSelectAll}) <P> Incremental selection allows selection of rows and columns of cells via keyboard or mouse provided
     * the shift key is down.  Behavior is designed to match Excel. Thus, if a previous selection has begun, cells will be
     * selected from that origin. <P> Users may also navigate through cells using the <i>Tab</i> and <i>Shift+Tab</i>
     * keypresses if {@link com.smartgwt.client.widgets.grid.ListGrid#getNavigateOnTab navigateOnTab} is true. When a user tabs
     * to the end of the row, the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is
     * used to determine whether to shift selection to the next row, return to the beginning of the same row, or simply move on
     * through the page's tab order.
     *
     * @param canSelectCells New canSelectCells value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanSelectCells(Boolean canSelectCells)  throws IllegalStateException {
        setAttribute("canSelectCells", canSelectCells, false);
    }

    /**
     * Enables cell-level selection behavior as well as {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers
     * cell-level rollover}. <P> To query and manipulate cell-level selections, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellSelection getCellSelection()} to retrieve the {@link
     * com.smartgwt.client.widgets.grid.CellSelection}. <P> Note that the ListGrid has a data model of one {@link
     * com.smartgwt.client.data.Record} per row, unlike the {@link com.smartgwt.client.widgets.cube.CubeGrid} which supports
     * one {@link com.smartgwt.client.widgets.cube.CellRecord} per cell.  For this reason record-oriented APIs that act on the
     * selection will act on entire Records that have <i>any</i> selected cells (examples include drag and drop and
     * transferSelectedData()). <P> More generally, <code>canSelectCells</code> is primarily intended to enable developers to
     * build Excel-like interactions on local datasets, by using {@link com.smartgwt.client.widgets.grid.ListGrid#setData
     * setData()} plus {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}:true rather than
     * record-oriented DataSources and data binding. <P> The following keyboard selection behaviors are enabled with this
     * property in addition to standard single-selection Arrow Key navigation: <P> SHIFT +        [Arrow Key]:  begin or
     * continue incremental selection <P> SHIFT + CTRL + [Arrow Key]:  incremental selection to the end of row or column <P>
     * CTRL  + A: select all cells (enabled only with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll
     * canSelectAll}) <P> Incremental selection allows selection of rows and columns of cells via keyboard or mouse provided
     * the shift key is down.  Behavior is designed to match Excel. Thus, if a previous selection has begun, cells will be
     * selected from that origin. <P> Users may also navigate through cells using the <i>Tab</i> and <i>Shift+Tab</i>
     * keypresses if {@link com.smartgwt.client.widgets.grid.ListGrid#getNavigateOnTab navigateOnTab} is true. When a user tabs
     * to the end of the row, the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is
     * used to determine whether to shift selection to the next row, return to the beginning of the same row, or simply move on
     * through the page's tab order.
     *
     * @return Current canSelectCells value. Default value is false
     */
    public Boolean getCanSelectCells()  {
        Boolean result = getAttributeAsBoolean("canSelectCells");
        return result == null ? false : result;
    }
    

    /**
     * Controls whether a checkbox for selecting {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groups} appears in
     * the group node if {@link com.smartgwt.client.types.SelectionAppearance} is set to <code>"checkbox"</code>
     *
     * @param canSelectGroups New canSelectGroups value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setCanSelectGroups(boolean canSelectGroups) {
        setAttribute("canSelectGroups", canSelectGroups, true);
    }

    /**
     * Controls whether a checkbox for selecting {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groups} appears in
     * the group node if {@link com.smartgwt.client.types.SelectionAppearance} is set to <code>"checkbox"</code>
     *
     * @return Current canSelectGroups value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public boolean getCanSelectGroups()  {
        Boolean result = getAttributeAsBoolean("canSelectGroups");
        return result == null ? false : result;
    }
    

    /**
     * Whether to allow selection of the summary row, for example by clicking on the record.  The default is to disallow it.
     * <p> If this property is set, further customization of selection can be made by applying the appropriate
     * selection-related properties to the autochild via {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow
     * summaryRowProperties}.  The request to fetch the summary row(s) can be customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canSelectSummaryRows New canSelectSummaryRows value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanSelectSummaryRows(boolean canSelectSummaryRows)  throws IllegalStateException {
        setAttribute("canSelectSummaryRows", canSelectSummaryRows, false);
    }

    /**
     * Whether to allow selection of the summary row, for example by clicking on the record.  The default is to disallow it.
     * <p> If this property is set, further customization of selection can be made by applying the appropriate
     * selection-related properties to the autochild via {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow
     * summaryRowProperties}.  The request to fetch the summary row(s) can be customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}.
     *
     * @return Current canSelectSummaryRows value. Default value is false
     */
    public boolean getCanSelectSummaryRows()  {
        Boolean result = getAttributeAsBoolean("canSelectSummaryRows");
        return result == null ? false : result;
    }
    

    /**
     * Enables or disables interactive sorting behavior for this listGrid. Does not affect sorting by direct calls to the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort} methods.
     *
     * @param canSort New canSort value. Default value is true
     */
    public void setCanSort(Boolean canSort) {
        setAttribute("canSort", canSort, true);
    }

    /**
     * Enables or disables interactive sorting behavior for this listGrid. Does not affect sorting by direct calls to the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort} methods.
     *
     * @return Current canSort value. Default value is true
     */
    public Boolean getCanSort()  {
        Boolean result = getAttributeAsBoolean("canSort");
        return result == null ? true : result;
    }
    

    /**
     * Should the header be included in the tab-order for the page? If not explicitly specified, the header will be included in
     * the tab order for the page if {@link com.smartgwt.client.util.isc#setScreenReaderMode isc.setScreenReaderMode()} is
     * called.
     *
     * @param canTabToHeader New canTabToHeader value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public void setCanTabToHeader(Boolean canTabToHeader)  throws IllegalStateException {
        setAttribute("canTabToHeader", canTabToHeader, false);
    }

    /**
     * Should the header be included in the tab-order for the page? If not explicitly specified, the header will be included in
     * the tab order for the page if {@link com.smartgwt.client.util.isc#setScreenReaderMode isc.setScreenReaderMode()} is
     * called.
     *
     * @return Current canTabToHeader value. Default value is null
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public Boolean getCanTabToHeader()  {
        return getAttributeAsBoolean("canTabToHeader");
    }
    

    /**
     * The menu displayed when a cell is right clicked on.
     * <p>
     * This component is an AutoChild named "cellContextMenu".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current cellContextMenu value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Layout getCellContextMenu() throws IllegalStateException {
        errorIfNotCreated("cellContextMenu");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("cellContextMenu"));
    }
    

    /**
     * The default height of each row in pixels.
     *
     * @param cellHeight New cellHeight value. Default value is 20
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_multiline" target="examples">Multiline values Example</a>
     */
    public void setCellHeight(int cellHeight) {
        setAttribute("cellHeight", cellHeight, true);
    }

    /**
     * The default height of each row in pixels.
     *
     * @return Current cellHeight value. Default value is 20
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_multiline" target="examples">Multiline values Example</a>
     */
    public int getCellHeight()  {
        return getAttributeAsInt("cellHeight");
    }
    

    /**
     * The amount of empty space, in pixels, surrounding each value in its cell.
     *
     * @param cellPadding New cellPadding value. Default value is 2
     */
    public void setCellPadding(int cellPadding) {
        setAttribute("cellPadding", cellPadding, true);
    }

    /**
     * The amount of empty space, in pixels, surrounding each value in its cell.
     *
     * @return Current cellPadding value. Default value is 2
     */
    public int getCellPadding()  {
        return getAttributeAsInt("cellPadding");
    }
    

    /**
     * Name of the Smart GWT Class to be used when creating charts.  Must support the Chart interface.
     *
     * @param chartConstructor New chartConstructor value. Default value is "FacetChart"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setChartConstructor(String chartConstructor)  throws IllegalStateException {
        setAttribute("chartConstructor", chartConstructor, false);
    }

    /**
     * Name of the Smart GWT Class to be used when creating charts.  Must support the Chart interface.
     *
     * @return Current chartConstructor value. Default value is "FacetChart"
     */
    public String getChartConstructor()  {
        return getAttributeAsString("chartConstructor");
    }
    

    /**
     * Default type of chart to plot.
     *
     * @param chartType New chartType value. Default value is "Column"
     */
    public void setChartType(ChartType chartType) {
        setAttribute("chartType", chartType == null ? null : chartType.getValue(), true);
    }

    /**
     * Default type of chart to plot.
     *
     * @return Current chartType value. Default value is "Column"
     */
    public ChartType getChartType()  {
        return EnumUtil.getEnum(ChartType.values(), getAttribute("chartType"));
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for an unselected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldFalseImage New checkboxFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setCheckboxFieldFalseImage(String checkboxFieldFalseImage) {
        setAttribute("checkboxFieldFalseImage", checkboxFieldFalseImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for an unselected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     *
     * @return Current checkboxFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getCheckboxFieldFalseImage()  {
        return getAttributeAsString("checkboxFieldFalseImage");
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the height of the checkbox image displayed to indicate
     * whether a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @param checkboxFieldImageHeight New checkboxFieldImageHeight value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCheckboxFieldImageHeight(Integer checkboxFieldImageHeight)  throws IllegalStateException {
        setAttribute("checkboxFieldImageHeight", checkboxFieldImageHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the height of the checkbox image displayed to indicate
     * whether a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @return Current checkboxFieldImageHeight value. Default value is null
     */
    public Integer getCheckboxFieldImageHeight()  {
        return getAttributeAsInt("checkboxFieldImageHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the width of the checkbox image displayed to indicate whether
     * a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @param checkboxFieldImageWidth New checkboxFieldImageWidth value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCheckboxFieldImageWidth(Integer checkboxFieldImageWidth)  throws IllegalStateException {
        setAttribute("checkboxFieldImageWidth", checkboxFieldImageWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the width of the checkbox image displayed to indicate whether
     * a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @return Current checkboxFieldImageWidth value. Default value is null
     */
    public Integer getCheckboxFieldImageWidth()  {
        return getAttributeAsInt("checkboxFieldImageWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a partially selected
     * row. If unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} will be
     * used. Note that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldPartialImage New checkboxFieldPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setCheckboxFieldPartialImage(String checkboxFieldPartialImage) {
        setAttribute("checkboxFieldPartialImage", checkboxFieldPartialImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a partially selected
     * row. If unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} will be
     * used. Note that the special value "blank" means that no image will be shown.
     *
     * @return Current checkboxFieldPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getCheckboxFieldPartialImage()  {
        return getAttributeAsString("checkboxFieldPartialImage");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a selected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldTrueImage New checkboxFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setCheckboxFieldTrueImage(String checkboxFieldTrueImage) {
        setAttribute("checkboxFieldTrueImage", checkboxFieldTrueImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a selected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     *
     * @return Current checkboxFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getCheckboxFieldTrueImage()  {
        return getAttributeAsString("checkboxFieldTrueImage");
    }
    

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, what the child's
     * expansionMode should be. <P>Default value <code>null</code> means no further expansion.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param childExpansionMode New childExpansionMode value. Default value is null
     */
    public void setChildExpansionMode(ExpansionMode childExpansionMode) {
        setAttribute("childExpansionMode", childExpansionMode == null ? null : childExpansionMode.getValue(), true);
    }

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, what the child's
     * expansionMode should be. <P>Default value <code>null</code> means no further expansion.
     *
     * @return Current childExpansionMode value. Default value is null
     */
    public ExpansionMode getChildExpansionMode()  {
        return EnumUtil.getEnum(ExpansionMode.values(), getAttribute("childExpansionMode"));
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear any existing sort on all fields.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @param clearAllSortingText New clearAllSortingText value. Default value is "Clear All Sorting"
     */
    public void setClearAllSortingText(String clearAllSortingText) {
        setAttribute("clearAllSortingText", clearAllSortingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear any existing sort on all fields.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @return Current clearAllSortingText value. Default value is "Clear All Sorting"
     */
    public String getClearAllSortingText()  {
        return getAttributeAsString("clearAllSortingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible, this
     * attribute will be shown as the menu item title to clear any existing filter.  This menu-item is displayed only in the
     * context menu for the sorter button.
     *
     * @param clearFilterText New clearFilterText value. Default value is "Clear Filter"
     */
    public void setClearFilterText(String clearFilterText) {
        setAttribute("clearFilterText", clearFilterText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible, this
     * attribute will be shown as the menu item title to clear any existing filter.  This menu-item is displayed only in the
     * context menu for the sorter button.
     *
     * @return Current clearFilterText value. Default value is "Clear Filter"
     */
    public String getClearFilterText()  {
        return getAttributeAsString("clearFilterText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear an existing sort on this field.
     *
     * @param clearSortFieldText New clearSortFieldText value. Default value is "Clear Sort"
     */
    public void setClearSortFieldText(String clearSortFieldText) {
        setAttribute("clearSortFieldText", clearSortFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear an existing sort on this field.
     *
     * @return Current clearSortFieldText value. Default value is "Clear Sort"
     */
    public String getClearSortFieldText()  {
        return getAttributeAsString("clearSortFieldText");
    }
    

    /**
     * Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped,
     * and potentially showing the full title on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover hover}. <p> In some cases this may be
     * preferable to the button component's default clipping behavior because if a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSortArrow sort arrow} or sort numeral is displayed for a header, then
     * the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes
     * special HTML which keeps the sort arrow/numeral visible. <p> This feature is automatically enabled if supported by the
     * browser. The only supported use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles to
     * false. <P> Note that this feature is incompatible with {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * ListGridField.wrap}, and will automatically be disabled for wrapping fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param clipHeaderTitles New clipHeaderTitles value. Default value is varies
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setClipHeaderTitles(Boolean clipHeaderTitles)  throws IllegalStateException {
        setAttribute("clipHeaderTitles", clipHeaderTitles, false);
    }

    /**
     * Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped,
     * and potentially showing the full title on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover hover}. <p> In some cases this may be
     * preferable to the button component's default clipping behavior because if a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSortArrow sort arrow} or sort numeral is displayed for a header, then
     * the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes
     * special HTML which keeps the sort arrow/numeral visible. <p> This feature is automatically enabled if supported by the
     * browser. The only supported use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles to
     * false. <P> Note that this feature is incompatible with {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * ListGridField.wrap}, and will automatically be disabled for wrapping fields.
     *
     * @return Current clipHeaderTitles value. Default value is varies
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getClipHeaderTitles()  {
        return getAttributeAsBoolean("clipHeaderTitles");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanCollapseGroup canCollapseGroup} is true, will a click anywhere
     * on the group row toggle the group's expanded state? If false, the user must click the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon} directly to toggle the group.
     *
     * @param collapseGroupOnRowClick New collapseGroupOnRowClick value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setCollapseGroupOnRowClick(boolean collapseGroupOnRowClick)  throws IllegalStateException {
        setAttribute("collapseGroupOnRowClick", collapseGroupOnRowClick, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanCollapseGroup canCollapseGroup} is true, will a click anywhere
     * on the group row toggle the group's expanded state? If false, the user must click the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon} directly to toggle the group.
     *
     * @return Current collapseGroupOnRowClick value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public boolean getCollapseGroupOnRowClick()  {
        Boolean result = getAttributeAsBoolean("collapseGroupOnRowClick");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-grouping is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiGroupDialog} to configure the grouping for this grid.
     *
     * @param configureGroupingText New configureGroupingText value. Default value is "Configure Grouping..."
     */
    public void setConfigureGroupingText(String configureGroupingText) {
        setAttribute("configureGroupingText", configureGroupingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-grouping is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiGroupDialog} to configure the grouping for this grid.
     *
     * @return Current configureGroupingText value. Default value is "Configure Grouping..."
     */
    public String getConfigureGroupingText()  {
        return getAttributeAsString("configureGroupingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-sorting is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiSortDialog} to configure the sort-specification for this grid.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @param configureSortText New configureSortText value. Default value is "Configure Sort..."
     */
    public void setConfigureSortText(String configureSortText) {
        setAttribute("configureSortText", configureSortText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-sorting is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiSortDialog} to configure the sort-specification for this grid.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @return Current configureSortText value. Default value is "Configure Sort..."
     */
    public String getConfigureSortText()  {
        return getAttributeAsString("configureSortText");
    }
    

    /**
     * If this is an editable listGrid, when the user attempts to cancel an edit, should we display a confirmation prompt
     * before discarding the edited values for the record?
     *
     * @param confirmCancelEditing New confirmCancelEditing value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setConfirmCancelEditing(Boolean confirmCancelEditing) {
        setAttribute("confirmCancelEditing", confirmCancelEditing, true);
    }

    /**
     * If this is an editable listGrid, when the user attempts to cancel an edit, should we display a confirmation prompt
     * before discarding the edited values for the record?
     *
     * @return Current confirmCancelEditing value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getConfirmCancelEditing()  {
        Boolean result = getAttributeAsBoolean("confirmCancelEditing");
        return result == null ? false : result;
    }
    

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded. This
     * flag determines whether we should display a confirmation dialog with options to save or discard the edits, or cancel the
     * action in this case.
     *
     * @param confirmDiscardEdits New confirmDiscardEdits value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setConfirmDiscardEdits(Boolean confirmDiscardEdits) {
        setAttribute("confirmDiscardEdits", confirmDiscardEdits, true);
    }

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded. This
     * flag determines whether we should display a confirmation dialog with options to save or discard the edits, or cancel the
     * action in this case.
     *
     * @return Current confirmDiscardEdits value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getConfirmDiscardEdits()  {
        Boolean result = getAttributeAsBoolean("confirmDiscardEdits");
        return result == null ? true : result;
    }
    

    /**
     * If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the error message string
     * displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to
     * sort/filter actions that would otherwise drop unsaved edit values.
     *
     * @param confirmDiscardEditsMessage New confirmDiscardEditsMessage value. Default value is "This action will discard unsaved changes for this list."
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setConfirmDiscardEditsMessage(String confirmDiscardEditsMessage) {
        setAttribute("confirmDiscardEditsMessage", confirmDiscardEditsMessage, true);
    }

    /**
     * If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the error message string
     * displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to
     * sort/filter actions that would otherwise drop unsaved edit values.
     *
     * @return Current confirmDiscardEditsMessage value. Default value is "This action will discard unsaved changes for this list."
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getConfirmDiscardEditsMessage()  {
        return getAttributeAsString("confirmDiscardEditsMessage");
    }
    

    /**
     * A list of ListGridRecord objects, specifying the data to be used to populate the ListGrid.  In ListGrids, the data array
     * specifies rows. <p> When using a {@link com.smartgwt.client.data.DataSource}, rather than directly providing
     * <code>data</code>, you will typically call {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}
     * instead, which will automatically establish <code>data</code> as a {@link com.smartgwt.client.data.ResultSet ResultSet}
     * (see the {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} docs for details). <p> If you call
     * <code>fetchData</code>, any previously supplied <code>data</code> is discarded.  Also, it is not necessary to call
     * <code>setData()</code> after calling {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}. <p> When
     * calling <code>setData()</code>, if <code>data</code> is provided as a RecordList or ResultSet, direct changes to the
     * list using Framework APIs such as {@link com.smartgwt.client.data.RecordList#add RecordList.add()} or  {@link
     * com.smartgwt.client.data.RecordList#remove RecordList.remove()} will be automatically observed and the ListGrid will
     * redraw in response.  However, direct changes to individual Records will not be automatically observed and require calls
     * to {@link com.smartgwt.client.widgets.grid.ListGrid#refreshCell refreshCell()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#refreshRow refreshRow()} to cause the ListGrid to visually update.  Calling
     * methods such as {@link com.smartgwt.client.widgets.grid.ListGrid#updateData updateData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData removeData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData addData()} always causes automatic visual refresh.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Provides a new data set to the ListGrid after the grid has been created or drawn. The ListGrid will redraw to show the new data automatically. <P> Note that passing null will not clear {@link com.smartgwt.client.widgets.grid.ListGrid#getData data}, but will regroup it and reapply the current sort, highlighting, and summaries to the grid.  Size will be recalculated for fields marked as {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autofitWidth}:true and a {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionManager selection manager} will be created if none exists.  To clear the grid instead, pass [].
     *
     * @param data data to show in the list. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridRecord
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_inline_data" target="examples">Inline data Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_local_data" target="examples">Local data Example</a>
     */
    public void setData(ListGridRecord... data) {
        setAttribute("data", data, true);
    }
    

    /**
     * Delay in milliseconds before fetching data. <P> Note: the floor value for this attribute is 1.  If you set this value to
     * zero, it will be defaulted to 1 for you instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dataFetchDelay New dataFetchDelay value. Default value is 1
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setDataFetchDelay(Integer dataFetchDelay) {
        setAttribute("dataFetchDelay", dataFetchDelay, true);
    }

    /**
     * Delay in milliseconds before fetching data. <P> Note: the floor value for this attribute is 1.  If you set this value to
     * zero, it will be defaulted to 1 for you instead.
     *
     * @return Current dataFetchDelay value. Default value is 1
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Integer getDataFetchDelay()  {
        return getAttributeAsInt("dataFetchDelay");
    }
    

    /**
     * How to fetch and manage records retrieve from the server.  See {@link com.smartgwt.client.types.FetchMode}. <P> This
     * setting only applies to the {@link com.smartgwt.client.data.ResultSet} automatically created by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.  If a pre-existing ResultSet is passed to setData()
     * instead, it's existing setting for {@link com.smartgwt.client.data.ResultSet#getFetchMode ResultSet.fetchMode} applies.
     *
     * @param dataFetchMode New dataFetchMode value. Default value is "paged"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setDataFetchMode(FetchMode dataFetchMode)  throws IllegalStateException {
        setAttribute("dataFetchMode", dataFetchMode == null ? null : dataFetchMode.getValue(), false);
    }

    /**
     * How to fetch and manage records retrieve from the server.  See {@link com.smartgwt.client.types.FetchMode}. <P> This
     * setting only applies to the {@link com.smartgwt.client.data.ResultSet} automatically created by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.  If a pre-existing ResultSet is passed to setData()
     * instead, it's existing setting for {@link com.smartgwt.client.data.ResultSet#getFetchMode ResultSet.fetchMode} applies.
     *
     * @return Current dataFetchMode value. Default value is "paged"
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public FetchMode getDataFetchMode()  {
        return EnumUtil.getEnum(FetchMode.values(), getAttribute("dataFetchMode"));
    }
    
    
    

    /**
     * The DataSource that this component should bind to for default fields and for performing {@link
     * com.smartgwt.client.data.DSRequest DataSource requests}. <P> Can be specified as either a DataSource instance or the
     * String ID of a DataSource.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Bind to a new DataSource. <P> Like passing the "dataSource" property on creation, binding to a DataSource means that the component will use the DataSource to provide default data for its fields. <P> When binding to a new DataSource, if the component has any existing "fields" or has a dataset, these will be discarded by default, since it is assumed the new DataSource may represent a completely unrelated set of objects.  If the old "fields" are still relevant, pass them to setDataSource().
     *
     * @param dataSource DataSource to bind to. Default value is null
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_ds_fields" target="examples">DataSource fields Example</a>
     */
    public void setDataSource(DataSource dataSource) {
        setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj(), true);
    }

    /**
     * The DataSource that this component should bind to for default fields and for performing {@link
     * com.smartgwt.client.data.DSRequest DataSource requests}. <P> Can be specified as either a DataSource instance or the
     * String ID of a DataSource.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Bind to a new DataSource. <P> Like passing the "dataSource" property on creation, binding to a DataSource means that the component will use the DataSource to provide default data for its fields. <P> When binding to a new DataSource, if the component has any existing "fields" or has a dataset, these will be discarded by default, since it is assumed the new DataSource may represent a completely unrelated set of objects.  If the old "fields" are still relevant, pass them to setDataSource().
     *
     * @param dataSource DataSource to bind to. Default value is null
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_ds_fields" target="examples">DataSource fields Example</a>
     */
    public void setDataSource(String dataSource) {
        setAttribute("dataSource", dataSource, true);
    }
    

    /**
     * How should Date type values be displayed in this ListGrid by default? <P> This property specifies the default
     * DateDisplayFormat to apply to Date values displayed in this grid for all fields except those of {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type "time"} (See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTimeFormatter timeFormatter}).<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDatetimeFormatter datetimeFormatter} is specified, that will be applied by
     * default to fields of type <code>"datetime"</code>. <P> Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter ListGridField.timeFormatter} are specified those
     * properties will take precedence over the component level settings. <P> If unset, date values will be formatted according
     * to the system wide {@link com.smartgwt.client.util.DateUtil#setShortDisplayFormat short display format} or {@link
     * com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat short datetime display format} for datetime type fields.
     * <P> If this field is editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @param dateFormatter New dateFormatter value. Default value is null
     */
    public void setDateFormatter(DateDisplayFormat dateFormatter) {
        setAttribute("dateFormatter", dateFormatter == null ? null : dateFormatter.getValue(), true);
    }

    /**
     * How should Date type values be displayed in this ListGrid by default? <P> This property specifies the default
     * DateDisplayFormat to apply to Date values displayed in this grid for all fields except those of {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type "time"} (See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTimeFormatter timeFormatter}).<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDatetimeFormatter datetimeFormatter} is specified, that will be applied by
     * default to fields of type <code>"datetime"</code>. <P> Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter ListGridField.timeFormatter} are specified those
     * properties will take precedence over the component level settings. <P> If unset, date values will be formatted according
     * to the system wide {@link com.smartgwt.client.util.DateUtil#setShortDisplayFormat short display format} or {@link
     * com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat short datetime display format} for datetime type fields.
     * <P> If this field is editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @return Current dateFormatter value. Default value is null
     */
    public DateDisplayFormat getDateFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("dateFormatter"));
    }
    

    /**
     * If this is an editable listGrid, this property will specify the {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getInputFormat inputFormat} applied to editors for fields of type
     * <code>"date"</code>. May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getInputFormat ListGridField.inputFormat}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dateInputFormat New dateInputFormat value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDateFormatter
     * @see com.smartgwt.client.docs.DateInputFormat DateInputFormat 
     */
    public void setDateInputFormat(String dateInputFormat) {
        setAttribute("dateInputFormat", dateInputFormat, true);
    }
    

    /**
     * Display format to use for fields specified as type 'datetime'.  Default is to use the system-wide default date time
     * format, configured via {@link com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat
     * DateUtil.setShortDatetimeDisplayFormat()}.  Specify any valid {@link com.smartgwt.client.types.DateDisplayFormat} to
     * change the display format for datetimes used by this grid.  <P> May also be specified at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} <P> If this field is
     * editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @param datetimeFormatter New datetimeFormatter value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#setDateFormatter
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setDatetimeFormatter(DateDisplayFormat datetimeFormatter) {
        setAttribute("datetimeFormatter", datetimeFormatter == null ? null : datetimeFormatter.getValue(), true);
    }

    /**
     * Display format to use for fields specified as type 'datetime'.  Default is to use the system-wide default date time
     * format, configured via {@link com.smartgwt.client.util.DateUtil#setShortDatetimeDisplayFormat
     * DateUtil.setShortDatetimeDisplayFormat()}.  Specify any valid {@link com.smartgwt.client.types.DateDisplayFormat} to
     * change the display format for datetimes used by this grid.  <P> May also be specified at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter ListGridField.dateFormatter} <P> If this field is
     * editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @return Current datetimeFormatter value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public DateDisplayFormat getDatetimeFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("datetimeFormatter"));
    }
    

    /**
     * Default width for date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultDateFieldWidth New defaultDateFieldWidth value. Default value is varies
     */
    public void setDefaultDateFieldWidth(Integer defaultDateFieldWidth) {
        setAttribute("defaultDateFieldWidth", defaultDateFieldWidth, true);
    }

    /**
     * Default width for date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultDateFieldWidth value. Default value is varies
     */
    public Integer getDefaultDateFieldWidth()  {
        return getAttributeAsInt("defaultDateFieldWidth");
    }
    

    /**
     * Default width for datetime type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultDateTimeFieldWidth New defaultDateTimeFieldWidth value. Default value is varies
     */
    public void setDefaultDateTimeFieldWidth(Integer defaultDateTimeFieldWidth) {
        setAttribute("defaultDateTimeFieldWidth", defaultDateTimeFieldWidth, true);
    }

    /**
     * Default width for datetime type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultDateTimeFieldWidth value. Default value is varies
     */
    public Integer getDefaultDateTimeFieldWidth()  {
        return getAttributeAsInt("defaultDateTimeFieldWidth");
    }
    

    /**
     * Default width for editable date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultEditableDateFieldWidth New defaultEditableDateFieldWidth value. Default value is varies
     */
    public void setDefaultEditableDateFieldWidth(Integer defaultEditableDateFieldWidth) {
        setAttribute("defaultEditableDateFieldWidth", defaultEditableDateFieldWidth, true);
    }

    /**
     * Default width for editable date type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultEditableDateFieldWidth value. Default value is varies
     */
    public Integer getDefaultEditableDateFieldWidth()  {
        return getAttributeAsInt("defaultEditableDateFieldWidth");
    }
    

    /**
     * Default width for editable datetime type fields. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields autoFitDateFields} for details on how this property is
     * used.
     *
     * @param defaultEditableDateTimeFieldWidth New defaultEditableDateTimeFieldWidth value. Default value is varies
     */
    public void setDefaultEditableDateTimeFieldWidth(Integer defaultEditableDateTimeFieldWidth) {
        setAttribute("defaultEditableDateTimeFieldWidth", defaultEditableDateTimeFieldWidth, true);
    }

    /**
     * Default width for editable datetime type fields. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields autoFitDateFields} for details on how this property is
     * used.
     *
     * @return Current defaultEditableDateTimeFieldWidth value. Default value is varies
     */
    public Integer getDefaultEditableDateTimeFieldWidth()  {
        return getAttributeAsInt("defaultEditableDateTimeFieldWidth");
    }
    

    /**
     * An array of listGrid field configuration objects.  When a listGrid is initialized, if this property is set and there is
     * no value for the <code>fields</code> attribute, this.fields will be defaulted to a generated array of field objects
     * duplicated from this array. <P> This property is useful for cases where a standard set of fields will be displayed in
     * multiple listGrids - for example a subclass of ListGrid intended to display a particular type of data:<br> In this
     * example we would not assign a single {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array directly
     * to the class via <code>addProperties()</code> as every generated instance of this class would then point to the same
     * fields array object. This would cause unexpected behavior such as changes to the field order in one grid effecting other
     * grids on the page.<br> Instead we could use <code>addProperties()</code> on our new subclass to set
     * <code>defaultFields</code> to a standard array of fields to display. Each generated instance of the subclass would then
     * show up with default fields duplicated from this array.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param defaultFields New defaultFields value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setDefaultFields(ListGridField... defaultFields)  throws IllegalStateException {
        setAttribute("defaultFields", defaultFields, false);
    }

    /**
     * An array of listGrid field configuration objects.  When a listGrid is initialized, if this property is set and there is
     * no value for the <code>fields</code> attribute, this.fields will be defaulted to a generated array of field objects
     * duplicated from this array. <P> This property is useful for cases where a standard set of fields will be displayed in
     * multiple listGrids - for example a subclass of ListGrid intended to display a particular type of data:<br> In this
     * example we would not assign a single {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array directly
     * to the class via <code>addProperties()</code> as every generated instance of this class would then point to the same
     * fields array object. This would cause unexpected behavior such as changes to the field order in one grid effecting other
     * grids on the page.<br> Instead we could use <code>addProperties()</code> on our new subclass to set
     * <code>defaultFields</code> to a standard array of fields to display. Each generated instance of the subclass would then
     * show up with default fields duplicated from this array.
     *
     * @return Current defaultFields value. Default value is null
     */
    public ListGridField[] getDefaultFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("defaultFields"));
    }
    

    /**
     * Default {@link com.smartgwt.client.types.OperatorId filter operator} to use for text-based fields in this grid's  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filter editor}, when producing {@link
     * com.smartgwt.client.data.AdvancedCriteria}.   When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} are enabled for the grid, the
     * default is {@link com.smartgwt.client.data.DataSource#getTranslatePatternOperators "iContainsPattern"}.  Otherwise, the
     * default is "iContains". <p> Does not apply to special fields where exact match is obviously the right default setting,
     * such as fields of type:"enum", or fields with a {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueMap
     * valueMap} or  {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource optionDataSource}.
     *
     * @param defaultFilterOperator New defaultFilterOperator value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setDefaultFilterOperator(OperatorId defaultFilterOperator)  throws IllegalStateException {
        setAttribute("defaultFilterOperator", defaultFilterOperator == null ? null : defaultFilterOperator.getValue(), false);
    }

    /**
     * Default {@link com.smartgwt.client.types.OperatorId filter operator} to use for text-based fields in this grid's  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filter editor}, when producing {@link
     * com.smartgwt.client.data.AdvancedCriteria}.   When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterExpressions allowFilterExpressions} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} are enabled for the grid, the
     * default is {@link com.smartgwt.client.data.DataSource#getTranslatePatternOperators "iContainsPattern"}.  Otherwise, the
     * default is "iContains". <p> Does not apply to special fields where exact match is obviously the right default setting,
     * such as fields of type:"enum", or fields with a {@link com.smartgwt.client.widgets.form.fields.FormItem#getValueMap
     * valueMap} or  {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionDataSource optionDataSource}.
     *
     * @return Current defaultFilterOperator value. Default value is null
     */
    public OperatorId getDefaultFilterOperator()  {
        return EnumUtil.getEnum(OperatorId.values(), getAttribute("defaultFilterOperator"));
    }
    

    /**
     * Text to show after the name of the default filterOperator in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled.
     *
     * @param defaultFilterOperatorSuffix New defaultFilterOperatorSuffix value. Default value is "(default)"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setDefaultFilterOperatorSuffix(String defaultFilterOperatorSuffix)  throws IllegalStateException {
        setAttribute("defaultFilterOperatorSuffix", defaultFilterOperatorSuffix, false);
    }

    /**
     * Text to show after the name of the default filterOperator in the  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled.
     *
     * @return Current defaultFilterOperatorSuffix value. Default value is "(default)"
     */
    public String getDefaultFilterOperatorSuffix()  {
        return getAttributeAsString("defaultFilterOperatorSuffix");
    }
    

    /**
     * Default width for time type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @param defaultTimeFieldWidth New defaultTimeFieldWidth value. Default value is varies
     */
    public void setDefaultTimeFieldWidth(Integer defaultTimeFieldWidth) {
        setAttribute("defaultTimeFieldWidth", defaultTimeFieldWidth, true);
    }

    /**
     * Default width for time type fields. See {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitDateFields
     * autoFitDateFields} for details on how this property is used.
     *
     * @return Current defaultTimeFieldWidth value. Default value is varies
     */
    public Integer getDefaultTimeFieldWidth()  {
        return getAttributeAsInt("defaultTimeFieldWidth");
    }
    

    /**
     * When enabled, the field shown by {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * causes records to be marked for future removal via {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * markRecordRemoved()} instead of immediately being removed. <P> When a record has been marked for removal, an icon in the
     * <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed. <P> If not explicitly specified by
     * this property, removal of records will be deferred if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits
     * autoSaveEdits} is false for the grid.
     *
     * @param deferRemoval New deferRemoval value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setDeferRemoval(Boolean deferRemoval)  throws IllegalStateException {
        setAttribute("deferRemoval", deferRemoval, false);
    }

    /**
     * When enabled, the field shown by {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * causes records to be marked for future removal via {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * markRecordRemoved()} instead of immediately being removed. <P> When a record has been marked for removal, an icon in the
     * <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed. <P> If not explicitly specified by
     * this property, removal of records will be deferred if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits
     * autoSaveEdits} is false for the grid.
     *
     * @return Current deferRemoval value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getDeferRemoval()  {
        return getAttributeAsBoolean("deferRemoval");
    }
    

    /**
     * Should partially selected checkbox be deselected or selected on click? This setting affects {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll header selection checkbox}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups group\n checkboxes} and folder checkbox selection in a Tree
     * data set. <p> By default clicking a partially selected checkbox selects it.
     *
     * @param deselectOnPartialCheckboxClick New deselectOnPartialCheckboxClick value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setDeselectOnPartialCheckboxClick(Boolean deselectOnPartialCheckboxClick) {
        setAttribute("deselectOnPartialCheckboxClick", deselectOnPartialCheckboxClick, true);
    }

    /**
     * Should partially selected checkbox be deselected or selected on click? This setting affects {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll header selection checkbox}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups group\n checkboxes} and folder checkbox selection in a Tree
     * data set. <p> By default clicking a partially selected checkbox selects it.
     *
     * @return Current deselectOnPartialCheckboxClick value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getDeselectOnPartialCheckboxClick()  {
        Boolean result = getAttributeAsBoolean("deselectOnPartialCheckboxClick");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>"related"</code>, this property specifies the
     * dataSource for the related records grid to be shown embedded in expanded records. <P> This property may also be
     * specified on a per-record basis - see {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordDetailDSProperty
     * recordDetailDSProperty}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param detailDS New detailDS value. Default value is null
     */
    public void setDetailDS(String detailDS) {
        setAttribute("detailDS", detailDS, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>"related"</code>, this property specifies the
     * dataSource for the related records grid to be shown embedded in expanded records. <P> This property may also be
     * specified on a per-record basis - see {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordDetailDSProperty
     * recordDetailDSProperty}
     *
     * @return Current detailDS value. Default value is null
     */
    public String getDetailDS()  {
        return getAttributeAsString("detailDS");
    }
    

    /**
     * The field whose contents to show in the expanded portion of a record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is <code>true</code> and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param detailField New detailField value. Default value is null
     */
    public void setDetailField(String detailField) {
        setAttribute("detailField", detailField, true);
    }

    /**
     * The field whose contents to show in the expanded portion of a record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is <code>true</code> and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>.
     *
     * @return Current detailField value. Default value is null
     */
    public String getDetailField()  {
        return getAttributeAsString("detailField");
    }
    

    /**
     * If a user is editing a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit:true} listGrid, and they hide
     * a field while the editor is showing, should we discard any edits in the edit row for the field being hidden? <P> Default
     * behavior is to discard the edits - set this flag to false to preserve edits
     *
     * @param discardEditsOnHideField New discardEditsOnHideField value. Default value is true
     */
    public void setDiscardEditsOnHideField(boolean discardEditsOnHideField) {
        setAttribute("discardEditsOnHideField", discardEditsOnHideField, true);
    }

    /**
     * If a user is editing a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit:true} listGrid, and they hide
     * a field while the editor is showing, should we discard any edits in the edit row for the field being hidden? <P> Default
     * behavior is to discard the edits - set this flag to false to preserve edits
     *
     * @return Current discardEditsOnHideField value. Default value is true
     */
    public boolean getDiscardEditsOnHideField()  {
        Boolean result = getAttributeAsBoolean("discardEditsOnHideField");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits} is true this is the
     * title for the save button appearing in the lost edits confirmation dialog. Override this for localization if necessary.
     *
     * @param discardEditsSaveButtonTitle New discardEditsSaveButtonTitle value. Default value is "Save"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setDiscardEditsSaveButtonTitle(String discardEditsSaveButtonTitle) {
        setAttribute("discardEditsSaveButtonTitle", discardEditsSaveButtonTitle, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits} is true this is the
     * title for the save button appearing in the lost edits confirmation dialog. Override this for localization if necessary.
     *
     * @return Current discardEditsSaveButtonTitle value. Default value is "Save"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getDiscardEditsSaveButtonTitle()  {
        return getAttributeAsString("discardEditsSaveButtonTitle");
    }
    
    

    /**
     * Like {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}, but applies when the
     * component is being drag-scrolled (via a scrollbar).  This value is typically set higher than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} to avoid too many concurrent fetches
     * to the server for {@link com.smartgwt.client.data.ResultSet}-backed components since it's quite easy to induce such a
     * case with a scrollbar and a grid bound to a large databaset.
     *
     * @param dragScrollRedrawDelay New dragScrollRedrawDelay value. Default value is 75
     */
    public void setDragScrollRedrawDelay(int dragScrollRedrawDelay) {
        setAttribute("dragScrollRedrawDelay", dragScrollRedrawDelay, true);
    }

    /**
     * Like {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}, but applies when the
     * component is being drag-scrolled (via a scrollbar).  This value is typically set higher than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} to avoid too many concurrent fetches
     * to the server for {@link com.smartgwt.client.data.ResultSet}-backed components since it's quite easy to induce such a
     * case with a scrollbar and a grid bound to a large databaset.
     *
     * @return Current dragScrollRedrawDelay value. Default value is 75
     */
    public int getDragScrollRedrawDelay()  {
        return getAttributeAsInt("dragScrollRedrawDelay");
    }
    

    /**
     * When records are being dragged from within a ListGrid, what sort of drag-tracker should be displayed?<br> Note that if
     * multiple records are being dragged the displayed tracker will be based on the first selected record.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dragTrackerMode New dragTrackerMode value. Default value is "icon"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setDragTrackerMode(DragTrackerMode dragTrackerMode)  throws IllegalStateException {
        setAttribute("dragTrackerMode", dragTrackerMode == null ? null : dragTrackerMode.getValue(), false);
    }

    /**
     * When records are being dragged from within a ListGrid, what sort of drag-tracker should be displayed?<br> Note that if
     * multiple records are being dragged the displayed tracker will be based on the first selected record.
     *
     * @return Current dragTrackerMode value. Default value is "icon"
     */
    public DragTrackerMode getDragTrackerMode()  {
        return EnumUtil.getEnum(DragTrackerMode.values(), getAttribute("dragTrackerMode"));
    }
    
    

    /**
     * How far should we render rows ahead of the currently visible area?  This is expressed as a ratio from viewport size to
     * rendered area size. <P> Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
     * initial render time and render time when scrolling by large amounts. <P> NOTE: Only applies when showAllRows is false.
     *
     * @param drawAheadRatio New drawAheadRatio value. Default value is 2.0
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_fetch" target="examples">Databound fetch Example</a>
     */
    public void setDrawAheadRatio(float drawAheadRatio) {
        setAttribute("drawAheadRatio", drawAheadRatio, true);
    }

    /**
     * How far should we render rows ahead of the currently visible area?  This is expressed as a ratio from viewport size to
     * rendered area size. <P> Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
     * initial render time and render time when scrolling by large amounts. <P> NOTE: Only applies when showAllRows is false.
     *
     * @return Current drawAheadRatio value. Default value is 2.0
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_fetch" target="examples">Databound fetch Example</a>
     */
    public float getDrawAheadRatio()  {
        return getAttributeAsFloat("drawAheadRatio");
    }
    

    /**
     * If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered, the full dataset will
     * instead be drawn even if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} is false and
     * the viewport size and {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} setting would
     * normally have caused incremental rendering to be used. <P> The <code>drawAllMaxCells</code> setting prevents incremental
     * rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
     * cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief
     * "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be
     * obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on
     * initial draw time. <P> <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature if
     * performance is an issue and: <ul> <li> you are very frequently redraw a grid <li> you do a lot of computation when
     * rendering each cell (eg formulas) <li> you are showing many grids on one screen and the user won't scroll most of them
     * </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param drawAllMaxCells New drawAllMaxCells value. Default value is 250
     */
    public void setDrawAllMaxCells(int drawAllMaxCells) {
        setAttribute("drawAllMaxCells", drawAllMaxCells, true);
    }

    /**
     * If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered, the full dataset will
     * instead be drawn even if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} is false and
     * the viewport size and {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} setting would
     * normally have caused incremental rendering to be used. <P> The <code>drawAllMaxCells</code> setting prevents incremental
     * rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
     * cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief
     * "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be
     * obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on
     * initial draw time. <P> <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature if
     * performance is an issue and: <ul> <li> you are very frequently redraw a grid <li> you do a lot of computation when
     * rendering each cell (eg formulas) <li> you are showing many grids on one screen and the user won't scroll most of them
     * </ul>
     *
     * @return Current drawAllMaxCells value. Default value is 250
     */
    public int getDrawAllMaxCells()  {
        return getAttributeAsInt("drawAllMaxCells");
    }
    

    /**
     * Determines whether when the user edits a cell in this listGrid the entire row becomes editable, or just the cell that
     * received the edit event. <P> No effect if this.canEdit is false or null.
     *
     * @param editByCell New editByCell value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanEdit
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_cell" target="examples">Edit by cell Example</a>
     */
    public void setEditByCell(Boolean editByCell) {
        setAttribute("editByCell", editByCell, true);
    }

    /**
     * Determines whether when the user edits a cell in this listGrid the entire row becomes editable, or just the cell that
     * received the edit event. <P> No effect if this.canEdit is false or null.
     *
     * @return Current editByCell value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_cell" target="examples">Edit by cell Example</a>
     */
    public Boolean getEditByCell()  {
        return getAttributeAsBoolean("editByCell");
    }
    

    /**
     * Event that will trigger inline editing, see {@link com.smartgwt.client.types.ListGridEditEvent} for options. <P> Note
     * this setting has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} has been set to
     * enable editing. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing startEditing()}.
     *
     * @param editEvent New editEvent value. Default value is "doubleClick"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public void setEditEvent(ListGridEditEvent editEvent) {
        setAttribute("editEvent", editEvent == null ? null : editEvent.getValue(), true);
    }

    /**
     * Event that will trigger inline editing, see {@link com.smartgwt.client.types.ListGridEditEvent} for options. <P> Note
     * this setting has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} has been set to
     * enable editing. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing startEditing()}.
     *
     * @return Current editEvent value. Default value is "doubleClick"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public ListGridEditEvent getEditEvent()  {
        return EnumUtil.getEnum(ListGridEditEvent.values(), getAttribute("editEvent"));
    }
    

    /**
     * A base name for the CSS class applied to cells when editing has failed.<br>  If this listGrid is editable, this style
     * will be applied to any edited cells for which  validation failed.<br>  As with the default 'baseStyle' property, this
     * style will have "Dark", "Over", "Selected",  or "Disabled" appended to it according to the state of the cell.<br> If
     * null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom
     * CSSText applied as derived from <code>this.editFailedCSSText</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editFailedBaseStyle New editFailedBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedCSSText
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditFailedBaseStyle(String editFailedBaseStyle) {
        setAttribute("editFailedBaseStyle", editFailedBaseStyle, true);
    }

    /**
     * A base name for the CSS class applied to cells when editing has failed.<br>  If this listGrid is editable, this style
     * will be applied to any edited cells for which  validation failed.<br>  As with the default 'baseStyle' property, this
     * style will have "Dark", "Over", "Selected",  or "Disabled" appended to it according to the state of the cell.<br> If
     * null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom
     * CSSText applied as derived from <code>this.editFailedCSSText</code>
     *
     * @return Current editFailedBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedCSSText
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditFailedBaseStyle()  {
        return getAttributeAsString("editFailedBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to cells when editing has failed.<br>  If this listGrid is editable, this css text will be
     * applied to any edited cells for which  validation failed, on top of the base style for the cell.<br> For further
     * customization of styling for cells that failed editing validation, use <code>this.editFailedBaseStyle</code> instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editFailedCSSText New editFailedCSSText value. Default value is "color:red;border:1px solid red;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditFailedCSSText(String editFailedCSSText) {
        setAttribute("editFailedCSSText", editFailedCSSText, true);
    }

    /**
     * Custom CSS text to be applied to cells when editing has failed.<br>  If this listGrid is editable, this css text will be
     * applied to any edited cells for which  validation failed, on top of the base style for the cell.<br> For further
     * customization of styling for cells that failed editing validation, use <code>this.editFailedBaseStyle</code> instead.
     *
     * @return Current editFailedCSSText value. Default value is "color:red;border:1px solid red;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditFailedCSSText()  {
        return getAttributeAsString("editFailedCSSText");
    }
    

    /**
     * Should we start editing when the widget has focus and the user presses the "f2" key (if this ListGrid supports editing)?
     * <P> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to <code>"click"</code>
     * or <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may also be used to start editing,
     * depending on the value for {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace
     * generateClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace
     * generateDoubleClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter
     * generateClickOnEnter} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter
     * generateDoubleClickOnEnter}. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is false, or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to "none" this property has no effect.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editOnF2Keypress New editOnF2Keypress value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEditOnF2Keypress(Boolean editOnF2Keypress) {
        setAttribute("editOnF2Keypress", editOnF2Keypress, true);
    }

    /**
     * Should we start editing when the widget has focus and the user presses the "f2" key (if this ListGrid supports editing)?
     * <P> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to <code>"click"</code>
     * or <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may also be used to start editing,
     * depending on the value for {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace
     * generateClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace
     * generateDoubleClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter
     * generateClickOnEnter} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter
     * generateDoubleClickOnEnter}. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is false, or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to "none" this property has no effect.
     *
     * @return Current editOnF2Keypress value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEditOnF2Keypress()  {
        Boolean result = getAttributeAsBoolean("editOnF2Keypress");
        return result == null ? true : result;
    }
    

    /**
     * Should we start editing when this widget receives focus (if this ListGrid supports editing)? <P> Note that this property
     * being set to true will cause editing to occur on a single click, even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is <code>"doubleClick"</code>, because single clicking
     * the grid will place keyboard focus there automatically. <P> If this property is set together with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} being set to "next",  users can create
     * a new edit row in an empty grid by simply tabbing into the grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editOnFocus New editOnFocus value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEditOnFocus(Boolean editOnFocus) {
        setAttribute("editOnFocus", editOnFocus, true);
    }

    /**
     * Should we start editing when this widget receives focus (if this ListGrid supports editing)? <P> Note that this property
     * being set to true will cause editing to occur on a single click, even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is <code>"doubleClick"</code>, because single clicking
     * the grid will place keyboard focus there automatically. <P> If this property is set together with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} being set to "next",  users can create
     * a new edit row in an empty grid by simply tabbing into the grid.
     *
     * @return Current editOnFocus value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEditOnFocus()  {
        return getAttributeAsBoolean("editOnFocus");
    }
    

    /**
     * A base name for the CSS class applied to cells containing pending (unsaved) edits<br> As with the default 'baseStyle'
     * property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the
     * cell. <P> If this property is null (the default setting), cells with pending edits will pick up custom css text to be
     * applied on top of the normal base style from <code>this.editPendingCSSText</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editPendingBaseStyle New editPendingBaseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditPendingBaseStyle(String editPendingBaseStyle)  throws IllegalStateException {
        setAttribute("editPendingBaseStyle", editPendingBaseStyle, false);
    }

    /**
     * A base name for the CSS class applied to cells containing pending (unsaved) edits<br> As with the default 'baseStyle'
     * property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the
     * cell. <P> If this property is null (the default setting), cells with pending edits will pick up custom css text to be
     * applied on top of the normal base style from <code>this.editPendingCSSText</code>.
     *
     * @return Current editPendingBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditPendingBaseStyle()  {
        return getAttributeAsString("editPendingBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to cells with pending edits that have not yet been submitted.<br> For further
     * customization of styling for cells with pending edits use <code>this.editPendingBaseStyle</code> instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editPendingCSSText New editPendingCSSText value. Default value is "color:#0066CC;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditPendingCSSText(String editPendingCSSText) {
        setAttribute("editPendingCSSText", editPendingCSSText, true);
    }

    /**
     * Custom CSS text to be applied to cells with pending edits that have not yet been submitted.<br> For further
     * customization of styling for cells with pending edits use <code>this.editPendingBaseStyle</code> instead.
     *
     * @return Current editPendingCSSText value. Default value is "color:#0066CC;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditPendingCSSText()  {
        return getAttributeAsString("editPendingCSSText");
    }
    

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @param editProxyConstructor New editProxyConstructor value. Default value is "GridEditProxy"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCClassName SCClassName 
     */
    public void setEditProxyConstructor(String editProxyConstructor)  throws IllegalStateException {
        setAttribute("editProxyConstructor", editProxyConstructor, false);
    }

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @return Current editProxyConstructor value. Default value is "GridEditProxy"
     * @see com.smartgwt.client.docs.SCClassName SCClassName 
     */
    public String getEditProxyConstructor()  {
        return getAttributeAsString("editProxyConstructor");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectOnEdit selectOnEdit} is true, what should be the
     * edit-selection behavior be? <P> If set to <code>null</code> behavior is as follows:<ul> <li>For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} set to <code>"simple"</code> edit rows will be
     * selected additively - this is the same behavior as if the <code>editSelectionType</code> was
     * <code>"multiple"</code></li> <li>Otherwise edit rows will be selected singly - this is the same behavior as if the
     * <code>editSelectionType</code> was <code>"single"</code></li> </ul> <P> Setting to <code>"single"</code> will cause the
     * edit row to be automatically selected and any other selection in the grid to be dropped.<br> If set to
     * <code>"multiple"</code>, selection will be additive (as a record goes  into edit mode, it is selected in addition to any
     * pre-existant selection). <P>
     *
     * @param editSelectionType New editSelectionType value. Default value is null
     */
    public void setEditSelectionType(SelectionStyle editSelectionType) {
        setAttribute("editSelectionType", editSelectionType == null ? null : editSelectionType.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectOnEdit selectOnEdit} is true, what should be the
     * edit-selection behavior be? <P> If set to <code>null</code> behavior is as follows:<ul> <li>For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} set to <code>"simple"</code> edit rows will be
     * selected additively - this is the same behavior as if the <code>editSelectionType</code> was
     * <code>"multiple"</code></li> <li>Otherwise edit rows will be selected singly - this is the same behavior as if the
     * <code>editSelectionType</code> was <code>"single"</code></li> </ul> <P> Setting to <code>"single"</code> will cause the
     * edit row to be automatically selected and any other selection in the grid to be dropped.<br> If set to
     * <code>"multiple"</code>, selection will be additive (as a record goes  into edit mode, it is selected in addition to any
     * pre-existant selection). <P>
     *
     * @return Current editSelectionType value. Default value is null
     */
    public SelectionStyle getEditSelectionType()  {
        return EnumUtil.getEnum(SelectionStyle.values(), getAttribute("editSelectionType"));
    }
    

    /**
     * The value to display for cells whose value is null or the empty string after applying {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} and valueMap (if any). <p> This is the grid-wide
     * attribute.  You may also set the emptyCellValue on a per-field basis.
     *
     * @param emptyCellValue New emptyCellValue value. Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.grid.ListGridField#setEmptyCellValue
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_values" target="examples">Empty values Example</a>
     */
    public void setEmptyCellValue(String emptyCellValue) {
        setAttribute("emptyCellValue", emptyCellValue, true);
    }

    /**
     * The value to display for cells whose value is null or the empty string after applying {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} and valueMap (if any). <p> This is the grid-wide
     * attribute.  You may also set the emptyCellValue on a per-field basis.
     *
     * @return Current emptyCellValue value. Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.grid.ListGridField#getEmptyCellValue
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_values" target="examples">Empty values Example</a>
     */
    public String getEmptyCellValue()  {
        return getAttributeAsString("emptyCellValue");
    }
    

    /**
     * The string to display in the body of a listGrid with an empty data array, if showEmptyMessage is true.
     *
     * @param emptyMessage New emptyMessage value. Default value is "No items to show."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public void setEmptyMessage(String emptyMessage) {
        setAttribute("emptyMessage", emptyMessage, true);
    }

    /**
     * The string to display in the body of a listGrid with an empty data array, if showEmptyMessage is true.
     *
     * @return Current emptyMessage value. Default value is "No items to show."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public String getEmptyMessage()  {
        return getAttributeAsString("emptyMessage");
    }
    

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage emptyMessage} if
     * displayed.
     *
     * @param emptyMessageStyle New emptyMessageStyle value. Default value is "emptyMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setEmptyMessageStyle(String emptyMessageStyle) {
        setAttribute("emptyMessageStyle", emptyMessageStyle, true);
    }

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage emptyMessage} if
     * displayed.
     *
     * @return Current emptyMessageStyle value. Default value is "emptyMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getEmptyMessageStyle()  {
        return getAttributeAsString("emptyMessageStyle");
    }
    

    /**
     * For performance reasons, even when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} is set, vertical clipping is not enforced by default for some kinds of content (such as images) on
     * all browsers. Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping:true} to enforce
     * clipping for all types of content on all browsers. <P> This additional setting is likely to be phased out as browsers
     * improve.
     *
     * @param enforceVClipping New enforceVClipping value. Default value is false
     */
    public void setEnforceVClipping(Boolean enforceVClipping) {
        setAttribute("enforceVClipping", enforceVClipping, true);
    }

    /**
     * For performance reasons, even when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} is set, vertical clipping is not enforced by default for some kinds of content (such as images) on
     * all browsers. Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping:true} to enforce
     * clipping for all types of content on all browsers. <P> This additional setting is likely to be phased out as browsers
     * improve.
     *
     * @return Current enforceVClipping value. Default value is false
     */
    public Boolean getEnforceVClipping()  {
        Boolean result = getAttributeAsBoolean("enforceVClipping");
        return result == null ? false : result;
    }
    

    /**
     * What to do when a user hits enter while editing a cell: <ul> <li>"nextCell": start editing the next editable cell in
     * this record (or the first     editable cell in the next record if focus is in the last editable cell in the row)
     * <li>"nextRow": start editing the same field in the next row (skipping any rows where      that would be a non-editable
     * cell. <li>"nextRowStart": start editing the first editable cell in the next row. <li>"done": hide the editor (editing is
     * complete) </ul> Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
     *
     * @param enterKeyEditAction New enterKeyEditAction value. Default value is "done"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEnterKeyEditAction(EnterKeyEditAction enterKeyEditAction) {
        setAttribute("enterKeyEditAction", enterKeyEditAction == null ? null : enterKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits enter while editing a cell: <ul> <li>"nextCell": start editing the next editable cell in
     * this record (or the first     editable cell in the next record if focus is in the last editable cell in the row)
     * <li>"nextRow": start editing the same field in the next row (skipping any rows where      that would be a non-editable
     * cell. <li>"nextRowStart": start editing the first editable cell in the next row. <li>"done": hide the editor (editing is
     * complete) </ul> Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
     *
     * @return Current enterKeyEditAction value. Default value is "done"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public EnterKeyEditAction getEnterKeyEditAction()  {
        return EnumUtil.getEnum(EnterKeyEditAction.values(), getAttribute("enterKeyEditAction"));
    }
    

    /**
     * In a ListGrid that has a DataSource and has filter criteria that include values for fields declared as {@link
     * com.smartgwt.client.types.FieldType type "enum"} in the DataSource, by default a newly edited row will use those filter
     * criteria as initial values. <P> For example, if a ListGrid is showing all Accounts that have status:"Active" and a new
     * row is created, the new row will default to status:"Active" unless this flag is set to false.
     *
     * @param enumCriteriaAsInitialValues New enumCriteriaAsInitialValues value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEnumCriteriaAsInitialValues(Boolean enumCriteriaAsInitialValues)  throws IllegalStateException {
        setAttribute("enumCriteriaAsInitialValues", enumCriteriaAsInitialValues, false);
    }

    /**
     * In a ListGrid that has a DataSource and has filter criteria that include values for fields declared as {@link
     * com.smartgwt.client.types.FieldType type "enum"} in the DataSource, by default a newly edited row will use those filter
     * criteria as initial values. <P> For example, if a ListGrid is showing all Accounts that have status:"Active" and a new
     * row is created, the new row will default to status:"Active" unless this flag is set to false.
     *
     * @return Current enumCriteriaAsInitialValues value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEnumCriteriaAsInitialValues()  {
        Boolean result = getAttributeAsBoolean("enumCriteriaAsInitialValues");
        return result == null ? true : result;
    }
    

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @param errorIconHeight New errorIconHeight value. Default value is 16
     */
    public void setErrorIconHeight(Integer errorIconHeight) {
        setAttribute("errorIconHeight", errorIconHeight, true);
    }

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @return Current errorIconHeight value. Default value is 16
     */
    public Integer getErrorIconHeight()  {
        return getAttributeAsInt("errorIconHeight");
    }
    

    /**
     * Src of the image to show as an error icon, if we're showing icons when validation      errors occur.
     *
     * @param errorIconSrc New errorIconSrc value. Default value is "[SKIN]/ListGrid/validation_error_icon.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setErrorIconSrc(String errorIconSrc) {
        setAttribute("errorIconSrc", errorIconSrc, true);
    }

    /**
     * Src of the image to show as an error icon, if we're showing icons when validation      errors occur.
     *
     * @return Current errorIconSrc value. Default value is "[SKIN]/ListGrid/validation_error_icon.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getErrorIconSrc()  {
        return getAttributeAsString("errorIconSrc");
    }
    

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @param errorIconWidth New errorIconWidth value. Default value is 16
     */
    public void setErrorIconWidth(Integer errorIconWidth) {
        setAttribute("errorIconWidth", errorIconWidth, true);
    }

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @return Current errorIconWidth value. Default value is 16
     */
    public Integer getErrorIconWidth()  {
        return getAttributeAsInt("errorIconWidth");
    }
    

    /**
     * What to do when a user hits escape while editing a cell:<ul> <li>"cancel": close the editor and discard the current set
     * of edit values <li>"done": just close the editor (the edit is complete, but the edited values are retained). </ul> Note
     * that if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, this may cause a save
     * of the current edit values
     *
     * @param escapeKeyEditAction New escapeKeyEditAction value. Default value is "cancel"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEscapeKeyEditAction(EscapeKeyEditAction escapeKeyEditAction) {
        setAttribute("escapeKeyEditAction", escapeKeyEditAction == null ? null : escapeKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits escape while editing a cell:<ul> <li>"cancel": close the editor and discard the current set
     * of edit values <li>"done": just close the editor (the edit is complete, but the edited values are retained). </ul> Note
     * that if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, this may cause a save
     * of the current edit values
     *
     * @return Current escapeKeyEditAction value. Default value is "cancel"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public EscapeKeyEditAction getEscapeKeyEditAction()  {
        return EnumUtil.getEnum(EscapeKeyEditAction.values(), getAttribute("escapeKeyEditAction"));
    }
    

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, is that component
     * editable? <P>The default value for this property is <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionCanEdit New expansionCanEdit value. Default value is null
     */
    public void setExpansionCanEdit(Boolean expansionCanEdit) {
        setAttribute("expansionCanEdit", expansionCanEdit, true);
    }

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, is that component
     * editable? <P>The default value for this property is <code>false</code>.
     *
     * @return Current expansionCanEdit value. Default value is null
     */
    public Boolean getExpansionCanEdit()  {
        return getAttributeAsBoolean("expansionCanEdit");
    }
    

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansionComponents}. <P> The default mode is "destroy",
     * which means that automatically created expansionComponents are destroyed when rows are collapsed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionComponentPoolingMode New expansionComponentPoolingMode value. Default value is "destroy"
     */
    public void setExpansionComponentPoolingMode(ExpansionComponentPoolingMode expansionComponentPoolingMode) {
        setAttribute("expansionComponentPoolingMode", expansionComponentPoolingMode == null ? null : expansionComponentPoolingMode.getValue(), true);
    }

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansionComponents}. <P> The default mode is "destroy",
     * which means that automatically created expansionComponents are destroyed when rows are collapsed.
     *
     * @return Current expansionComponentPoolingMode value. Default value is "destroy"
     */
    public ExpansionComponentPoolingMode getExpansionComponentPoolingMode()  {
        return EnumUtil.getEnum(ExpansionComponentPoolingMode.values(), getAttribute("expansionComponentPoolingMode"));
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.HTMLFlow} for displaying the contents of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailField a specified field} in a record's expanded section when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>. <P> This component is an
     * {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailFieldProperties</code> and <code>listGrid.expansionDetailFieldDefaults</code>. <P> Note,
     * however, that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild()
     * not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public HTMLFlow getExpansionDetailField()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.layout.HLayout} appearing in a record's expanded section when
     * {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailRelated</code>. This component
     * contains two other autoChild components, a {@link com.smartgwt.client.widgets.viewer.DetailViewer} for viewing fields
     * from the record which are not already present in the grid and a separate embedded {@link
     * com.smartgwt.client.widgets.grid.ListGrid} for displaying other data related to this record via record.detailDS.  See
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionDetails expansionDetails} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionRelated expansionRelated} for more information. <P> This component
     * is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailRelatedProperties</code> and <code>listGrid.expansionDetailRelatedDefaults</code>. <P>
     * Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public HLayout getExpansionDetailRelated()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.viewer.DetailViewer} for displaying the details of a record
     * in its expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is
     * <code>details</code>.  Note that only those fields which do not already appear in the grid are displayed in the expanded
     * section. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailsProperties</code> and <code>listGrid.expansionDetailsDefaults</code>. <P> Note, however,
     * that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild() not 
     * addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public DetailViewer getExpansionDetails()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.form.DynamicForm} for editing the details of a record in its
     * expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>editor</code>. 
     * Note that only those fields which do not already appear in the grid will appear in the expanded section. <P> According
     * to the value of {@link com.smartgwt.client.widgets.grid.ListGrid#getShowExpansionEditorSaveButton
     * showExpansionEditorSaveButton}, a save button is shown beneath the editor.  You can save the values in the editor by
     * clicking this button <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized
     * via <code>listGrid.expansionEditorProperties</code> and <code>listGrid.expansionEditorDefaults</code>. <P> Note,
     * however, that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild()
     * not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public DynamicForm getExpansionEditor()  {
        return null;
    }
    

    /**
     * When {@link com.smartgwt.client.types.ExpansionMode} is <i>editor</i>, should the row be collapsed following a save
     * initiated by the expansion-component's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorSaveButton
     * save button}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current expansionEditorCollapseOnSave value. Default value is true
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Boolean getExpansionEditorCollapseOnSave() throws IllegalStateException {
        errorIfNotCreated("expansionEditorCollapseOnSave");
        Boolean result = getAttributeAsBoolean("expansionEditorCollapseOnSave");
        return result == null ? true : result;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.IButton} for saving the values in the expanded portion of a
     * ListGrid row. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionEditorSaveButtonProperties</code> and <code>listGrid.expansionEditorSaveButtonDefaults</code>.
     * <P> Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public IButton getExpansionEditorSaveButton()  {
        return null;
    }
    

    /**
     * The title for the {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorSaveButton
     * expansionEditorSaveButton}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current expansionEditorSaveButtonTitle value. Default value is "Save"
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public String getExpansionEditorSaveButtonTitle() throws IllegalStateException {
        errorIfNotCreated("expansionEditorSaveButtonTitle");
        return getAttributeAsString("expansionEditorSaveButtonTitle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, the prompt to display in a
     * dialog when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @param expansionEditorSaveDialogPrompt New expansionEditorSaveDialogPrompt value. Default value is "You have unsaved changes - do you want to save them now?"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionEditorSaveDialogPrompt(String expansionEditorSaveDialogPrompt)  throws IllegalStateException {
        setAttribute("expansionEditorSaveDialogPrompt", expansionEditorSaveDialogPrompt, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, the prompt to display in a
     * dialog when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @return Current expansionEditorSaveDialogPrompt value. Default value is "You have unsaved changes - do you want to save them now?"
     */
    public String getExpansionEditorSaveDialogPrompt()  {
        return getAttributeAsString("expansionEditorSaveDialogPrompt");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, whether a dialog should be
     * displayed when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @param expansionEditorShowSaveDialog New expansionEditorShowSaveDialog value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionEditorShowSaveDialog(Boolean expansionEditorShowSaveDialog)  throws IllegalStateException {
        setAttribute("expansionEditorShowSaveDialog", expansionEditorShowSaveDialog, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, whether a dialog should be
     * displayed when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @return Current expansionEditorShowSaveDialog value. Default value is null
     */
    public Boolean getExpansionEditorShowSaveDialog()  {
        return getAttributeAsBoolean("expansionEditorShowSaveDialog");
    }
    

    /**
     * The field providing the facility to expand and collapse rows.
     * <p>
     * This component is an AutoChild named "expansionField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Returns the specially generated expansion field used when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true. <P> Called during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFields setFields()}, this method can be overridden to add advanced dynamic
     * defaults to the expansion field (call Super, modify the default field returned by Super, return the modified field). 
     * Normal customization can be handled by just setting {@link com.smartgwt.client.types.AutoChild} properties, as mentioned
     * under the docs for {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansionField}. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getExpansionField() throws IllegalStateException {
        errorIfNotCreated("expansionField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("expansionField"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for collapsed rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldFalseImage New expansionFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setExpansionFieldFalseImage(String expansionFieldFalseImage) {
        setAttribute("expansionFieldFalseImage", expansionFieldFalseImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for collapsed rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used.
     *
     * @return Current expansionFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getExpansionFieldFalseImage()  {
        return getAttributeAsString("expansionFieldFalseImage");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the height of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @param expansionFieldImageHeight New expansionFieldImageHeight value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionFieldImageHeight(Integer expansionFieldImageHeight)  throws IllegalStateException {
        setAttribute("expansionFieldImageHeight", expansionFieldImageHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the height of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @return Current expansionFieldImageHeight value. Default value is null
     */
    public Integer getExpansionFieldImageHeight()  {
        return getAttributeAsInt("expansionFieldImageHeight");
    }
    

    /**
     * Should a "_selected" suffix be added to the  {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * expansionFieldTrueImage} and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * expansionFieldFalseImage} image URLs for selected rows? <P> This allows developers to provide separate expansion field
     * media for selected rows, in case the selected row style does not contrast well with the standard expansion field image
     * media. <P> If both this property and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageShowRTL
     * expansionFieldImageShowRTL} are true, and the grid is in RTL mode, both suffixes will be applied to selected rows'
     * expansion field image (combined as "selected_rtl")
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldImageShowSelected New expansionFieldImageShowSelected value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionFieldImageShowSelected(boolean expansionFieldImageShowSelected)  throws IllegalStateException {
        setAttribute("expansionFieldImageShowSelected", expansionFieldImageShowSelected, false);
    }

    /**
     * Should a "_selected" suffix be added to the  {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * expansionFieldTrueImage} and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * expansionFieldFalseImage} image URLs for selected rows? <P> This allows developers to provide separate expansion field
     * media for selected rows, in case the selected row style does not contrast well with the standard expansion field image
     * media. <P> If both this property and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageShowRTL
     * expansionFieldImageShowRTL} are true, and the grid is in RTL mode, both suffixes will be applied to selected rows'
     * expansion field image (combined as "selected_rtl")
     *
     * @return Current expansionFieldImageShowSelected value. Default value is false
     */
    public boolean getExpansionFieldImageShowSelected()  {
        Boolean result = getAttributeAsBoolean("expansionFieldImageShowSelected");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the width of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @param expansionFieldImageWidth New expansionFieldImageWidth value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionFieldImageWidth(Integer expansionFieldImageWidth)  throws IllegalStateException {
        setAttribute("expansionFieldImageWidth", expansionFieldImageWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the width of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @return Current expansionFieldImageWidth value. Default value is null
     */
    public Integer getExpansionFieldImageWidth()  {
        return getAttributeAsInt("expansionFieldImageWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for expanded rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldTrueImage New expansionFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setExpansionFieldTrueImage(String expansionFieldTrueImage) {
        setAttribute("expansionFieldTrueImage", expansionFieldTrueImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for expanded rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used.
     *
     * @return Current expansionFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageHeight
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getExpansionFieldTrueImage()  {
        return getAttributeAsString("expansionFieldTrueImage");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.layout.VLayout} which fills a record's expanded section and
     * contains other builtin {@link com.smartgwt.client.types.ExpansionMode expansion-components}.  You can also override
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent getExpansionComponent()} to provide components of
     * your own specification. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be
     * customized via <code>listGrid.expansionLayoutProperties</code> and <code>listGrid.expansionLayoutDefaults</code>. <P>
     * Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public VLayout getExpansionLayout()  {
        return null;
    }
    

    /**
     * The {@link com.smartgwt.client.types.ExpansionMode} for records in this grid. Default <code>null</code> value means no
     * expansion.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionMode New expansionMode value. Default value is null
     */
    public void setExpansionMode(ExpansionMode expansionMode) {
        setAttribute("expansionMode", expansionMode == null ? null : expansionMode.getValue(), true);
    }

    /**
     * The {@link com.smartgwt.client.types.ExpansionMode} for records in this grid. Default <code>null</code> value means no
     * expansion.
     *
     * @return Current expansionMode value. Default value is null
     */
    public ExpansionMode getExpansionMode()  {
        return EnumUtil.getEnum(ExpansionMode.values(), getAttribute("expansionMode"));
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid} for displaying data related to a record in its
     * expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>related</code>.
     * The {@link com.smartgwt.client.data.DataSource} containing the related data is provided by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRelatedDataSource getRelatedDataSource()} which, by default, returns the
     * DataSource referred to in {@link com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS ListGridRecord.detailDS}.
     * <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionRelatedProperties</code> and <code>listGrid.expansionRelatedDefaults</code>. <P> Note, however,
     * that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild() not 
     * addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public ListGrid getExpansionRelated()  {
        return null;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for even-numbered rows, to create a "banded" or "ledger" effect.  Odd-numbered rows will  use the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportDefaultBGColor exportDefaultBGColor}. <p> See {@link
     * com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @param exportAlternateRowBGColor New exportAlternateRowBGColor value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public void setExportAlternateRowBGColor(String exportAlternateRowBGColor)  throws IllegalStateException {
        setAttribute("exportAlternateRowBGColor", exportAlternateRowBGColor, false);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for even-numbered rows, to create a "banded" or "ledger" effect.  Odd-numbered rows will  use the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportDefaultBGColor exportDefaultBGColor}. <p> See {@link
     * com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @return Current exportAlternateRowBGColor value. Default value is null
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getExportAlternateRowBGColor()  {
        return getAttributeAsString("exportAlternateRowBGColor");
    }
    

    /**
     * Default background color to use when exporting data to Excel/OpenOffice format using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <p> If unset (the default), cells that
     * are not provided a background color by more specific APIs will be the default background color used by the spreadsheet
     * program where they are viewed. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @param exportDefaultBGColor New exportDefaultBGColor value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public void setExportDefaultBGColor(String exportDefaultBGColor)  throws IllegalStateException {
        setAttribute("exportDefaultBGColor", exportDefaultBGColor, false);
    }

    /**
     * Default background color to use when exporting data to Excel/OpenOffice format using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <p> If unset (the default), cells that
     * are not provided a background color by more specific APIs will be the default background color used by the spreadsheet
     * program where they are viewed. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @return Current exportDefaultBGColor value. Default value is null
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getExportDefaultBGColor()  {
        return getAttributeAsString("exportDefaultBGColor");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether field
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign horizontal header alignments} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign data value alignments} should be replicated in the resulting
     * spreadsheet.  <p> If this attribute is not set, cells will be assigned a default alignment by the spreadsheet, which is
     * typically right-aligned for numeric and date values, and left-aligned for  everything else (including dates and numbers
     * that have been exported as strings, as would be the case, for example, if {@link
     * com.smartgwt.client.data.DSRequest#getExportDatesAsFormattedString DSRequest.exportDatesAsFormattedString} is set)
     *
     * @param exportFieldAlignments New exportFieldAlignments value. Default value is false
     */
    public void setExportFieldAlignments(boolean exportFieldAlignments) {
        setAttribute("exportFieldAlignments", exportFieldAlignments, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether field
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign horizontal header alignments} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign data value alignments} should be replicated in the resulting
     * spreadsheet.  <p> If this attribute is not set, cells will be assigned a default alignment by the spreadsheet, which is
     * typically right-aligned for numeric and date values, and left-aligned for  everything else (including dates and numbers
     * that have been exported as strings, as would be the case, for example, if {@link
     * com.smartgwt.client.data.DSRequest#getExportDatesAsFormattedString DSRequest.exportDatesAsFormattedString} is set)
     *
     * @return Current exportFieldAlignments value. Default value is false
     */
    public boolean getExportFieldAlignments()  {
        Boolean result = getAttributeAsBoolean("exportFieldAlignments");
        return result == null ? false : result;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether widths
     * of fields should be replicated in the resulting spreadsheet. <p> Because Excel's unit of measurement for field widths is
     * based on the default system font, there is no exact way to translate field widths in pixels to Excel column widths.  The
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExportWidthScale exportWidthScale} property can be set to adjust
     * scaling; it's default value errs on the side of making Excel's columns slightly wider than the ListGrid field's actual
     * width to avoid clipping. <p> Note that you can switch off width export for individual fields with the  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getExportFieldWidth ListGridField.exportFieldWidth} flag.
     *
     * @param exportFieldWidths New exportFieldWidths value. Default value is false
     */
    public void setExportFieldWidths(boolean exportFieldWidths) {
        setAttribute("exportFieldWidths", exportFieldWidths, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether widths
     * of fields should be replicated in the resulting spreadsheet. <p> Because Excel's unit of measurement for field widths is
     * based on the default system font, there is no exact way to translate field widths in pixels to Excel column widths.  The
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExportWidthScale exportWidthScale} property can be set to adjust
     * scaling; it's default value errs on the side of making Excel's columns slightly wider than the ListGrid field's actual
     * width to avoid clipping. <p> Note that you can switch off width export for individual fields with the  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getExportFieldWidth ListGridField.exportFieldWidth} flag.
     *
     * @return Current exportFieldWidths value. Default value is false
     */
    public boolean getExportFieldWidths()  {
        Boolean result = getAttributeAsBoolean("exportFieldWidths");
        return result == null ? false : result;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, causes the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight} and {@link
     * com.smartgwt.client.widgets.grid.HeaderSpan#getHeight headerSpan heights} to be applied to the corresponding cells in
     * the spreadsheet.
     *
     * @param exportHeaderHeights New exportHeaderHeights value. Default value is false
     */
    public void setExportHeaderHeights(boolean exportHeaderHeights) {
        setAttribute("exportHeaderHeights", exportHeaderHeights, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, causes the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight} and {@link
     * com.smartgwt.client.widgets.grid.HeaderSpan#getHeight headerSpan heights} to be applied to the corresponding cells in
     * the spreadsheet.
     *
     * @return Current exportHeaderHeights value. Default value is false
     */
    public boolean getExportHeaderHeights()  {
        Boolean result = getAttributeAsBoolean("exportHeaderHeights");
        return result == null ? false : result;
    }
    

    /**
     * Dictates whether the data in this grid should be exported raw by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}.  If set to true, data will not be
     * processed by field-formatters during exports. Decreases the time taken for large exports.  This property can also be set
     * at the {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field level}.
     *
     * @param exportRawValues New exportRawValues value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExportRawValues(Boolean exportRawValues)  throws IllegalStateException {
        setAttribute("exportRawValues", exportRawValues, false);
    }

    /**
     * Dictates whether the data in this grid should be exported raw by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}.  If set to true, data will not be
     * processed by field-formatters during exports. Decreases the time taken for large exports.  This property can also be set
     * at the {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field level}.
     *
     * @return Current exportRawValues value. Default value is null
     */
    public Boolean getExportRawValues()  {
        return getAttributeAsBoolean("exportRawValues");
    }
    

    /**
     * Scaling factor to translate from ListGrid field widths in pixels to Excel/OpenOffice units for field width, which are
     * 1/256th of the width of the widest digit character in the default font for the spreadsheet.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for where this is used.
     *
     * @param exportWidthScale New exportWidthScale value. Default value is 0.12
     */
    public void setExportWidthScale(double exportWidthScale) {
        setAttribute("exportWidthScale", exportWidthScale, true);
    }

    /**
     * Scaling factor to translate from ListGrid field widths in pixels to Excel/OpenOffice units for field width, which are
     * 1/256th of the width of the widest digit character in the default font for the spreadsheet.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for where this is used.
     *
     * @return Current exportWidthScale value. Default value is 0.12
     */
    public double getExportWidthScale()  {
        return getAttributeAsDouble("exportWidthScale");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether titles
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader ListGrid header} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} should be allowed to wrap. <p> Excel will wrap at
     * the column boundary automatically; for explicit control over wrapping, insert "&lt;br&gt;" tags into your titles. <p>
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for replicating the
     * widths of fields in the exported spreadsheet.
     *
     * @param exportWrapHeaderTitles New exportWrapHeaderTitles value. Default value is false
     */
    public void setExportWrapHeaderTitles(boolean exportWrapHeaderTitles) {
        setAttribute("exportWrapHeaderTitles", exportWrapHeaderTitles, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, whether titles
     * in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader ListGrid header} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} should be allowed to wrap. <p> Excel will wrap at
     * the column boundary automatically; for explicit control over wrapping, insert "&lt;br&gt;" tags into your titles. <p>
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for replicating the
     * widths of fields in the exported spreadsheet.
     *
     * @return Current exportWrapHeaderTitles value. Default value is false
     */
    public boolean getExportWrapHeaderTitles()  {
        Boolean result = getAttributeAsBoolean("exportWrapHeaderTitles");
        return result == null ? false : result;
    }
    

    /**
     * <b>Note: This property only has an effect in Internet Explorer</b> <P> Advanced property to improve performance for
     * dynamic styling of gridRenderer cells in Internet Explorer, at the expense of slightly slower initial drawing, and some 
     * limitations on supported styling options. <P> <code>fastCellUpdates</code> speeds up the dynamic styling system used by
     * rollovers, selections, and custom styling that calls {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#refreshCellStyle GridRenderer.refreshCellStyle()}, at the cost of slightly
     * slower draw() and redraw() times. <P> Notes: <ul> <li>When this property is set, ListGrid cells may be styled using the 
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle getBaseStyle()} for      more information.</li> <li>If any cell
     * styles specify a a background image URL, the URL will be resolved relative     to the page location rather than the
     * location of the CSS stylesheet. This means cell     styles with a background URL should either supply a fully qualified
     * path, or the     background image media should be made available at a second location for IE.</li> <li>fastCellUpdates
     * will not work if the styles involved are in an external stylesheet loaded     from a remote host. Either the stylesheet
     * containing cell styles needs to be loaded     from the same host as the main page, or the cell styles need to be inlined
     * in the html      of the bootstrap page.</li> <li>fastCellUpdates will not work if the css styles for cells are defined
     * in     a <code>.css</code> file loaded via <code>@import</code>. Instead the <code>.css</code>     file should be loaded
     * via a <code>&lt;link ...&gt;</code> tag.</li> </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.GridRenderer#getFastCellUpdates GridRenderer.fastCellUpdates}. Has no effect in browsers other than Internet Explorer.
     *
     * @param fastCellUpdates whether to enable fastCellUpdates. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFastCellUpdates(Boolean fastCellUpdates)  throws IllegalStateException {
        setAttribute("fastCellUpdates", fastCellUpdates, false);
    }
    

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true), and we're re-filtering on every keypress ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} is true), this property is the delay in
     * milliseconds between the user changing the filter and the filter request being kicked off. If multiple changes are made
     * to the filter within this fetch delay, only the most recent will actually cause a re-filter
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fetchDelay New fetchDelay value. Default value is 300
     */
    public void setFetchDelay(int fetchDelay) {
        setAttribute("fetchDelay", fetchDelay, true);
    }

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true), and we're re-filtering on every keypress ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} is true), this property is the delay in
     * milliseconds between the user changing the filter and the filter request being kicked off. If multiple changes are made
     * to the filter within this fetch delay, only the most recent will actually cause a re-filter
     *
     * @return Current fetchDelay value. Default value is 300
     */
    public int getFetchDelay()  {
        return getAttributeAsInt("fetchDelay");
    }
    

    /**
     * Names of properties on {@link com.smartgwt.client.widgets.grid.ListGridField} for which the {@link
     * com.smartgwt.client.widgets.FieldPicker} should show an editing interface, for convenience. <P> For example, specify
     * ["frozen", "decimalPrecision"] to allow end users to modify {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen ListGridField.frozen} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDecimalPrecision ListGridField.decimalPrecision} respectively.
     *
     * @param fieldPickerFieldProperties New fieldPickerFieldProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFieldPickerFieldProperties(String... fieldPickerFieldProperties)  throws IllegalStateException {
        setAttribute("fieldPickerFieldProperties", fieldPickerFieldProperties, false);
    }

    /**
     * Names of properties on {@link com.smartgwt.client.widgets.grid.ListGridField} for which the {@link
     * com.smartgwt.client.widgets.FieldPicker} should show an editing interface, for convenience. <P> For example, specify
     * ["frozen", "decimalPrecision"] to allow end users to modify {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen ListGridField.frozen} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDecimalPrecision ListGridField.decimalPrecision} respectively.
     *
     * @return Current fieldPickerFieldProperties value. Default value is null
     */
    public String[] getFieldPickerFieldProperties()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("fieldPickerFieldProperties"));
    }
    

    /**
     * When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.
     *
     * @param fieldPickerShowSampleValues New fieldPickerShowSampleValues value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFieldPickerShowSampleValues(Boolean fieldPickerShowSampleValues)  throws IllegalStateException {
        setAttribute("fieldPickerShowSampleValues", fieldPickerShowSampleValues, false);
    }

    /**
     * When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.
     *
     * @return Current fieldPickerShowSampleValues value. Default value is true
     */
    public Boolean getFieldPickerShowSampleValues()  {
        Boolean result = getAttributeAsBoolean("fieldPickerShowSampleValues");
        return result == null ? true : result;
    }
    

    /**
     * Instance of {@link com.smartgwt.client.widgets.FieldPickerWindow} used if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set.
     * <p>
     * This component is an AutoChild named "fieldPickerWindow".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current fieldPickerWindow value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public FieldPickerWindow getFieldPickerWindow() throws IllegalStateException {
        errorIfNotCreated("fieldPickerWindow");
        return (FieldPickerWindow)FieldPickerWindow.getByJSObject(getAttributeAsJavaScriptObject("fieldPickerWindow"));
    }
    

    /**
     * An array of field objects, specifying the order, layout, formatting, and sorting behavior of each field in the listGrid
     * object.  In ListGrids, the fields array specifies columns.  Each field in the fields array is a ListGridField object.
     * Any listGrid that will display data should have at least one visible field. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is also set, this value acts as a set of overrides
     * as explained in {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets the fields array and/or field widths to newFields and sizes, respectively.<br><br> If newFields is specified, it is assumed that the new fields may have nothing in common with the old fields, and the component is substantially rebuilt.  Furthermore, it's invalid to modify any of the existing {@link com.smartgwt.client.widgets.grid.ListGridField}s after they've been passed to this function. Consider the following methods for more efficient, more incremental changes: {@link com.smartgwt.client.widgets.grid.ListGrid#resizeField resizeField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#reorderField reorderField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()}, or {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldProperties setFieldProperties()}.
     *
     * @param fields array of fields to draw. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_lg_fields" target="examples">ListGrid fields Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_merged_fields" target="examples">Merged fields Example</a>
     */
    public void setFields(ListGridField... fields) {
        setAttribute("fields", fields, true);
    }

    /**
     * An array of field objects, specifying the order, layout, formatting, and sorting behavior of each field in the listGrid
     * object.  In ListGrids, the fields array specifies columns.  Each field in the fields array is a ListGridField object.
     * Any listGrid that will display data should have at least one visible field. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is also set, this value acts as a set of overrides
     * as explained in {@link com.smartgwt.client.widgets.DataBoundComponent#getFields DataBoundComponent.fields}.
     *
     * @return Get the array of all <b>currently visible</b> fields for this ListGrid. <P> This list fields is only valid once the
     * ListGrid has been {@link com.smartgwt.client.widgets.Canvas#draw drawn} or once {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFields setFields()} has been called explicitly.  If called earlier, only
     * the list of directly specified fields will be returned (the Array passed to create()). <P> This Array should be treated
     * as <b>read-only</b>.  To modify the set of visible fields, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()} and related APIs.  To update properties of individual
     * fields, use {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldProperties setFieldProperties()} or more specific
     * APIs such as {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldTitle setFieldTitle()}. <P> To get the Array of
     * all fields, including fields that are not currently visible or were specified implicitly, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllFields getAllFields()}. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_lg_fields" target="examples">ListGrid fields Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_merged_fields" target="examples">Merged fields Example</a>
     */
    public ListGridField[] getFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("fields"));
    }
    

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridFieldState field state} for the grid. <p> {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be used to initialize all view properties of the
     * grid. When doing so, <code>fieldState</code> is not needed because <code>viewState</code> includes it as well. If both
     * are provided, <code>fieldState</code> has priority for field state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets some presentation properties (visibility, width, userFormula and userSummary) of the listGrid fields based on the {@link com.smartgwt.client.docs.ListGridFieldState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState getFieldState()}.
     *
     * @param fieldState state to apply to the listGrid's fields. Default value is null
     * @see com.smartgwt.client.docs.ListGridFieldState ListGridFieldState 
     */
    public void setFieldState(String fieldState) {
        setAttribute("fieldState", fieldState, true);
    }

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridFieldState field state} for the grid. <p> {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be used to initialize all view properties of the
     * grid. When doing so, <code>fieldState</code> is not needed because <code>viewState</code> includes it as well. If both
     * are provided, <code>fieldState</code> has priority for field state.
     *
     * @return Returns a snapshot of the current presentation of this listGrid's fields as a {@link
     * com.smartgwt.client.docs.ListGridFieldState} object. <P> This object can later be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFieldState setFieldState()} to reset this grid's fields to the current
     * state. <P> Note that the information stored includes the current width and visibility of each of this grid's fields, as
     * well as any {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddFormulaFields formula} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary fields} added by the user. Default value is null
     * @see com.smartgwt.client.docs.ListGridFieldState ListGridFieldState 
     */
    public String getFieldState()  {
        return getAttributeAsString("fieldState");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields this.canPickFields} is true, this attribute
     * will be shown as the title for the menu item which contains a submenu with items allowing the user to show and hide
     * fields in the grid.
     *
     * @param fieldVisibilitySubmenuTitle New fieldVisibilitySubmenuTitle value. Default value is "Columns"
     */
    public void setFieldVisibilitySubmenuTitle(String fieldVisibilitySubmenuTitle) {
        setAttribute("fieldVisibilitySubmenuTitle", fieldVisibilitySubmenuTitle, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields this.canPickFields} is true, this attribute
     * will be shown as the title for the menu item which contains a submenu with items allowing the user to show and hide
     * fields in the grid.
     *
     * @return Current fieldVisibilitySubmenuTitle value. Default value is "Columns"
     */
    public String getFieldVisibilitySubmenuTitle()  {
        return getAttributeAsString("fieldVisibilitySubmenuTitle");
    }
    

    /**
     * The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
     *
     * @param filterButtonPrompt New filterButtonPrompt value. Default value is "Filter"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFilterButtonPrompt(String filterButtonPrompt)  throws IllegalStateException {
        setAttribute("filterButtonPrompt", filterButtonPrompt, false);
    }

    /**
     * The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
     *
     * @return Current filterButtonPrompt value. Default value is "Filter"
     */
    public String getFilterButtonPrompt()  {
        return getAttributeAsString("filterButtonPrompt");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this attribute may be
     * used to customize the filter button shown to the right of the filterEditor row.
     *
     * @param filterButtonProperties New filterButtonProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public void setFilterButtonProperties(Button filterButtonProperties)  throws IllegalStateException {
        if (filterButtonProperties != null) {
            if (filterButtonProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setFilterButtonProperties", "Button");
            }                                                                       
            filterButtonProperties.setConfigOnly(true);
        }
        JavaScriptObject config = filterButtonProperties == null ? null : filterButtonProperties.getConfig();
        setAttribute("filterButtonProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this attribute may be
     * used to customize the filter button shown to the right of the filterEditor row.
     *
     * @return Current filterButtonProperties value. Default value is null
     */
    public Button getFilterButtonProperties()  {
        Button properties = new Button();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("filterButtonProperties"));
        return properties;
    }
    

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user puts focus in a different field in the filter editor.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterByCell New filterByCell value. Default value is null
     */
    public void setFilterByCell(Boolean filterByCell) {
        setAttribute("filterByCell", filterByCell, true);
    }

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user puts focus in a different field in the filter editor.
     *
     * @return Current filterByCell value. Default value is null
     */
    public Boolean getFilterByCell()  {
        return getAttributeAsBoolean("filterByCell");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is set to true, the
     * <code>filterEditor</code> is automatically created as an AutoChild.<br> Developers may customize the AutoChild using
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorProperties filterEditorProperties}.
     * <p>
     * This component is an AutoChild named "filterEditor".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterEditor value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public RecordEditor getFilterEditor() throws IllegalStateException {
        errorIfNotCreated("filterEditor");
        return (RecordEditor)RecordEditor.getByJSObject(getAttributeAsJavaScriptObject("filterEditor"));
    }
    

    /**
     * Height for the filterEditor, if shown.
     *
     * @param filterEditorHeight New filterEditorHeight value. Default value is 22
     */
    public void setFilterEditorHeight(int filterEditorHeight) {
        setAttribute("filterEditorHeight", filterEditorHeight, true);
    }

    /**
     * Height for the filterEditor, if shown.
     *
     * @return Current filterEditorHeight value. Default value is 22
     */
    public int getFilterEditorHeight()  {
        return getAttributeAsInt("filterEditorHeight");
    }
    

    /**
     * Properties to apply to the automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
     * filterEditor} if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true.
     *
     * @param filterEditorProperties New filterEditorProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public void setFilterEditorProperties(RecordEditor filterEditorProperties)  throws IllegalStateException {
        if (filterEditorProperties != null) {
            if (filterEditorProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setFilterEditorProperties", "RecordEditor");
            }                                                                       
            filterEditorProperties.setConfigOnly(true);
        }
        JavaScriptObject config = filterEditorProperties == null ? null : filterEditorProperties.getConfig();
        setAttribute("filterEditorProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to the automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
     * filterEditor} if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true.
     *
     * @return Current filterEditorProperties value. Default value is null
     */
    public RecordEditor getFilterEditorProperties()  {
        RecordEditor properties = new RecordEditor();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("filterEditorProperties"));
        return properties;
    }
    

    /**
     * Causes filtering to be performed against the local data set, even when a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is provided. <p> When using this mode, data must be
     * provided to the grid via {@link com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as  
     * a RecordList.   <p> Note that a {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} must be
     * provided for filtering to occur even when filtering locally. <P> If this property is set to true, the supplied data is
     * applied as the  {@link com.smartgwt.client.data.ResultSet#getAllRows complete dataset} of a {@link
     * com.smartgwt.client.data.ResultSet}, which is then  filtered according to the specified criteria, and the results
     * displayed. If false, a  normal databound fetch will occur, retrieving records that match the specified criteria  from
     * this component's {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <p>
     * <code>filterLocalData</code> includes both calls to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * fetchData()} and {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} as well as automatic
     * filtering when the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} is enabled. <p> If
     * this property is not explicitly set, default behavior will filter against the dataSource unless the grid has a specified
     * {@link com.smartgwt.client.docs.DataPath dataPath}, in which case filtering will occur locally. <p> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} to cause saves to ignore the DataSource and affect
     * the local data set only.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterLocalData New filterLocalData value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFilterLocalData(Boolean filterLocalData)  throws IllegalStateException {
        setAttribute("filterLocalData", filterLocalData, false);
    }

    /**
     * Causes filtering to be performed against the local data set, even when a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is provided. <p> When using this mode, data must be
     * provided to the grid via {@link com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as  
     * a RecordList.   <p> Note that a {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} must be
     * provided for filtering to occur even when filtering locally. <P> If this property is set to true, the supplied data is
     * applied as the  {@link com.smartgwt.client.data.ResultSet#getAllRows complete dataset} of a {@link
     * com.smartgwt.client.data.ResultSet}, which is then  filtered according to the specified criteria, and the results
     * displayed. If false, a  normal databound fetch will occur, retrieving records that match the specified criteria  from
     * this component's {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <p>
     * <code>filterLocalData</code> includes both calls to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * fetchData()} and {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} as well as automatic
     * filtering when the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor} is enabled. <p> If
     * this property is not explicitly set, default behavior will filter against the dataSource unless the grid has a specified
     * {@link com.smartgwt.client.docs.DataPath dataPath}, in which case filtering will occur locally. <p> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} to cause saves to ignore the DataSource and affect
     * the local data set only.
     *
     * @return Current filterLocalData value. Default value is null
     */
    public Boolean getFilterLocalData()  {
        return getAttributeAsBoolean("filterLocalData");
    }
    

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user modifies the value in a field of the filter-editor. Can also be set at the field level.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterOnKeypress New filterOnKeypress value. Default value is null
     */
    public void setFilterOnKeypress(Boolean filterOnKeypress) {
        setAttribute("filterOnKeypress", filterOnKeypress, true);
    }

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user modifies the value in a field of the filter-editor. Can also be set at the field level.
     *
     * @return Current filterOnKeypress value. Default value is null
     */
    public Boolean getFilterOnKeypress()  {
        return getAttributeAsBoolean("filterOnKeypress");
    }
    

    /**
     * Text for the menu item shown in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * headerContextMenu} when {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators}
     * is enabled.
     *
     * @param filterUsingText New filterUsingText value. Default value is "Filter using"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFilterUsingText(String filterUsingText)  throws IllegalStateException {
        setAttribute("filterUsingText", filterUsingText, false);
    }

    /**
     * Text for the menu item shown in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * headerContextMenu} when {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators}
     * is enabled.
     *
     * @return Current filterUsingText value. Default value is "Filter using"
     */
    public String getFilterUsingText()  {
        return getAttributeAsString("filterUsingText");
    }
    

    /**
     * Should we horizontally clip cell contents, or allow columns to expand horizontally to show all contents? <P> If we allow
     * columns to expand, the column width is treated as a minimum. <P> NOTE: the header does not automatically respond to
     * expanded field widths. If your grid is showing a header we'd recommend developers consider setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} rather than using this attribute.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fixedFieldWidths New fixedFieldWidths value. Default value is true
     */
    public void setFixedFieldWidths(Boolean fixedFieldWidths) {
        setAttribute("fixedFieldWidths", fixedFieldWidths, true);
    }

    /**
     * Should we horizontally clip cell contents, or allow columns to expand horizontally to show all contents? <P> If we allow
     * columns to expand, the column width is treated as a minimum. <P> NOTE: the header does not automatically respond to
     * expanded field widths. If your grid is showing a header we'd recommend developers consider setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} rather than using this attribute.
     *
     * @return Current fixedFieldWidths value. Default value is true
     */
    public Boolean getFixedFieldWidths()  {
        Boolean result = getAttributeAsBoolean("fixedFieldWidths");
        return result == null ? true : result;
    }
    

    /**
     * Should we vertically clip cell contents, or allow rows to expand vertically to show all contents? <P> If we allow rows
     * to expand, the row height as derived from {@link com.smartgwt.client.widgets.grid.GridRenderer#getRowHeight
     * getRowHeight()} or the default {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} is treated as
     * a minimum. <P> Setting <code>fixedRecordHeights</code> to false enables the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} system. <P> <b>NOTE:</b><ul> <li>Setting
     * fixedRecordHeights to false for {@link com.smartgwt.client.widgets.cube.CubeGrid} is not supported, though a similar
     * option for the row headers is available as {@link com.smartgwt.client.widgets.cube.CubeGrid#getAutoSizeHeaders
     * CubeGrid.autoSizeHeaders}. <li>By default, for performance reasons, clipping is not enforced for some kinds of content
     * (such as images) on all browsers.  Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping
     * enforceVClipping:true} to enforce clipping for all types of content on all browsers. </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fixedRecordHeights New fixedRecordHeights value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public void setFixedRecordHeights(Boolean fixedRecordHeights) {
        setAttribute("fixedRecordHeights", fixedRecordHeights, true);
    }

    /**
     * Should we vertically clip cell contents, or allow rows to expand vertically to show all contents? <P> If we allow rows
     * to expand, the row height as derived from {@link com.smartgwt.client.widgets.grid.GridRenderer#getRowHeight
     * getRowHeight()} or the default {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} is treated as
     * a minimum. <P> Setting <code>fixedRecordHeights</code> to false enables the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} system. <P> <b>NOTE:</b><ul> <li>Setting
     * fixedRecordHeights to false for {@link com.smartgwt.client.widgets.cube.CubeGrid} is not supported, though a similar
     * option for the row headers is available as {@link com.smartgwt.client.widgets.cube.CubeGrid#getAutoSizeHeaders
     * CubeGrid.autoSizeHeaders}. <li>By default, for performance reasons, clipping is not enforced for some kinds of content
     * (such as images) on all browsers.  Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping
     * enforceVClipping:true} to enforce clipping for all types of content on all browsers. </ul>
     *
     * @return Current fixedRecordHeights value. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public Boolean getFixedRecordHeights()  {
        Boolean result = getAttributeAsBoolean("fixedRecordHeights");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInFormulaBuilder showHeaderSpanTitlesInFormulaBuilder}
     * is true, this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid in
     * the FormulaBuilder and SummaryBuilder.
     *
     * @param formulaBuilderSpanTitleSeparator New formulaBuilderSpanTitleSeparator value. Default value is " - "
     */
    public void setFormulaBuilderSpanTitleSeparator(String formulaBuilderSpanTitleSeparator) {
        setAttribute("formulaBuilderSpanTitleSeparator", formulaBuilderSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInFormulaBuilder showHeaderSpanTitlesInFormulaBuilder}
     * is true, this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid in
     * the FormulaBuilder and SummaryBuilder.
     *
     * @return Current formulaBuilderSpanTitleSeparator value. Default value is " - "
     */
    public String getFormulaBuilderSpanTitleSeparator()  {
        return getAttributeAsString("formulaBuilderSpanTitleSeparator");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze a currently unfrozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Freeze " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param freezeFieldText New freezeFieldText value. Default value is "Freeze ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public void setFreezeFieldText(String freezeFieldText) {
        setAttribute("freezeFieldText", freezeFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze a currently unfrozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Freeze " + the field's summary title.
     *
     * @return Current freezeFieldText value. Default value is "Freeze ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getFreezeFieldText()  {
        return getAttributeAsString("freezeFieldText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the left of the scrollable body.
     *
     * @param freezeOnLeftText New freezeOnLeftText value. Default value is "Freeze on left"
     */
    public void setFreezeOnLeftText(String freezeOnLeftText) {
        setAttribute("freezeOnLeftText", freezeOnLeftText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the left of the scrollable body.
     *
     * @return Current freezeOnLeftText value. Default value is "Freeze on left"
     */
    public String getFreezeOnLeftText()  {
        return getAttributeAsString("freezeOnLeftText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the right of the scrollable body.
     *
     * @param freezeOnRightText New freezeOnRightText value. Default value is "Freeze on right"
     */
    public void setFreezeOnRightText(String freezeOnRightText) {
        setAttribute("freezeOnRightText", freezeOnRightText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the right of the scrollable body.
     *
     * @return Current freezeOnRightText value. Default value is "Freeze on right"
     */
    public String getFreezeOnRightText()  {
        return getAttributeAsString("freezeOnRightText");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom baseStyle to all cells in those
     * frozen fields. If unset, the standard base style will be used for both frozen and unfrozen cells.
     *
     * @param frozenBaseStyle New frozenBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setFrozenBaseStyle(String frozenBaseStyle) {
        setAttribute("frozenBaseStyle", frozenBaseStyle, true);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom baseStyle to all cells in those
     * frozen fields. If unset, the standard base style will be used for both frozen and unfrozen cells.
     *
     * @return Current frozenBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public String getFrozenBaseStyle()  {
        return getAttributeAsString("frozenBaseStyle");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerBaseStyle to the frozen
     * set of fields. If unset, the standard headerBaseStyle will be used for both frozen and unfrozen cells.
     *
     * @param frozenHeaderBaseStyle New frozenHeaderBaseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setFrozenHeaderBaseStyle(String frozenHeaderBaseStyle)  throws IllegalStateException {
        setAttribute("frozenHeaderBaseStyle", frozenHeaderBaseStyle, false);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerBaseStyle to the frozen
     * set of fields. If unset, the standard headerBaseStyle will be used for both frozen and unfrozen cells.
     *
     * @return Current frozenHeaderBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public String getFrozenHeaderBaseStyle()  {
        return getAttributeAsString("frozenHeaderBaseStyle");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerTitleStyle to the frozen
     * set of fields. If unset, the standard headerTitleStyle will be used for both frozen and unfrozen cells.
     *
     * @param frozenHeaderTitleStyle New frozenHeaderTitleStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderTitleStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setFrozenHeaderTitleStyle(String frozenHeaderTitleStyle)  throws IllegalStateException {
        setAttribute("frozenHeaderTitleStyle", frozenHeaderTitleStyle, false);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerTitleStyle to the frozen
     * set of fields. If unset, the standard headerTitleStyle will be used for both frozen and unfrozen cells.
     *
     * @return Current frozenHeaderTitleStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public String getFrozenHeaderTitleStyle()  {
        return getAttributeAsString("frozenHeaderTitleStyle");
    }
    
    
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a click event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateClickOnEnter New generateClickOnEnter value. Default value is false
     */
    public void setGenerateClickOnEnter(Boolean generateClickOnEnter) {
        setAttribute("generateClickOnEnter", generateClickOnEnter, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a click event.
     *
     * @return Current generateClickOnEnter value. Default value is false
     */
    public Boolean getGenerateClickOnEnter()  {
        Boolean result = getAttributeAsBoolean("generateClickOnEnter");
        return result == null ? false : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits space, the cell will respond to a click event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateClickOnSpace New generateClickOnSpace value. Default value is true
     */
    public void setGenerateClickOnSpace(Boolean generateClickOnSpace) {
        setAttribute("generateClickOnSpace", generateClickOnSpace, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits space, the cell will respond to a click event.
     *
     * @return Current generateClickOnSpace value. Default value is true
     */
    public Boolean getGenerateClickOnSpace()  {
        Boolean result = getAttributeAsBoolean("generateClickOnSpace");
        return result == null ? true : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a double click
     * event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateDoubleClickOnEnter New generateDoubleClickOnEnter value. Default value is true
     */
    public void setGenerateDoubleClickOnEnter(Boolean generateDoubleClickOnEnter) {
        setAttribute("generateDoubleClickOnEnter", generateDoubleClickOnEnter, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a double click
     * event.
     *
     * @return Current generateDoubleClickOnEnter value. Default value is true
     */
    public Boolean getGenerateDoubleClickOnEnter()  {
        Boolean result = getAttributeAsBoolean("generateDoubleClickOnEnter");
        return result == null ? true : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Space, the cell will respond to a double click
     * event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateDoubleClickOnSpace New generateDoubleClickOnSpace value. Default value is false
     */
    public void setGenerateDoubleClickOnSpace(Boolean generateDoubleClickOnSpace) {
        setAttribute("generateDoubleClickOnSpace", generateDoubleClickOnSpace, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Space, the cell will respond to a double click
     * event.
     *
     * @return Current generateDoubleClickOnSpace value. Default value is false
     */
    public Boolean getGenerateDoubleClickOnSpace()  {
        Boolean result = getAttributeAsBoolean("generateDoubleClickOnSpace");
        return result == null ? false : result;
    }
    

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *
     * @param gridComponents New gridComponents value. Default value is (see below)
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGridComponents(ListGridComponent... gridComponents)  throws IllegalStateException {
        setAttribute("gridComponents", gridComponents, false);
    }

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *
     * @return Current gridComponents value. Default value is (see below)
     */
    public ListGridComponent[] getGridComponents()  {
        final String[] strings = getAttributeAsStringArray("gridComponents");
        return EnumUtil.getEnums(ListGridComponent.values(), strings, strings == null ? null : new ListGridComponent[strings.length]);
    }

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *
     * @param gridComponents New gridComponents value. Default value is (see below)
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGridComponents(Object... gridComponents)  throws IllegalStateException {
        setAttribute("gridComponents", gridComponents, false);
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, this attribute will be
     * set to true on the record object representing the grid summary row.
     *
     * @param gridSummaryRecordProperty New gridSummaryRecordProperty value. Default value is "isGridSummary"
     */
    public void setGridSummaryRecordProperty(String gridSummaryRecordProperty) {
        setAttribute("gridSummaryRecordProperty", gridSummaryRecordProperty, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, this attribute will be
     * set to true on the record object representing the grid summary row.
     *
     * @return Current gridSummaryRecordProperty value. Default value is "isGridSummary"
     */
    public String getGridSummaryRecordProperty()  {
        return getAttributeAsString("gridSummaryRecordProperty");
    }
    

    /**
     * When grouping is requested with this number of records or more, an asynchronous approach is used to avoid the browser
     * showing a "script is running slowly.." message prompting the user to stop execution of JavaScript. <p> Note that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} must be set at least as high as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold groupByAsyncThreshold} or asynchronous grouping will
     * never be used. <p> During async grouping, interactivity is blocked and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt asynchGroupingPrompt} is shown to the user, then
     * hidden when grouping completes; {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()} then fires. <p> Note that this async processing covers grouping <b>only</b> - it does not
     * cover whole grid or per-group summaries, client-side sort or filter, or other operations that may cause the browser to
     * show the "script is running slowly" prompt when working with very large sets of records in a grid. <p> At this time,
     * there is no generally effective way to avoid this warning dialog appearing with very large datasets in Microsoft's
     * Internet Explorer (IE).  IE's severely flawed detection algorithm for runaway scripts has been shown to interrupt
     * computations after only 0.2 seconds elapsed time even if the computation would have finished in 0.3 seconds. 
     * Optimizations that reduce execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
     * every operation can reasonably be made asynchronous, the current recommendation is to avoid working with overly large
     * datasets until the affected versions of IE are obsoleted.
     *
     * @param groupByAsyncThreshold New groupByAsyncThreshold value. Default value is 50
     */
    public void setGroupByAsyncThreshold(int groupByAsyncThreshold) {
        setAttribute("groupByAsyncThreshold", groupByAsyncThreshold, true);
    }

    /**
     * When grouping is requested with this number of records or more, an asynchronous approach is used to avoid the browser
     * showing a "script is running slowly.." message prompting the user to stop execution of JavaScript. <p> Note that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} must be set at least as high as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold groupByAsyncThreshold} or asynchronous grouping will
     * never be used. <p> During async grouping, interactivity is blocked and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt asynchGroupingPrompt} is shown to the user, then
     * hidden when grouping completes; {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()} then fires. <p> Note that this async processing covers grouping <b>only</b> - it does not
     * cover whole grid or per-group summaries, client-side sort or filter, or other operations that may cause the browser to
     * show the "script is running slowly" prompt when working with very large sets of records in a grid. <p> At this time,
     * there is no generally effective way to avoid this warning dialog appearing with very large datasets in Microsoft's
     * Internet Explorer (IE).  IE's severely flawed detection algorithm for runaway scripts has been shown to interrupt
     * computations after only 0.2 seconds elapsed time even if the computation would have finished in 0.3 seconds. 
     * Optimizations that reduce execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
     * every operation can reasonably be made asynchronous, the current recommendation is to avoid working with overly large
     * datasets until the affected versions of IE are obsoleted.
     *
     * @return Current groupByAsyncThreshold value. Default value is 50
     */
    public int getGroupByAsyncThreshold()  {
        return getAttributeAsInt("groupByAsyncThreshold");
    }
    

    /**
     * List of fields to group grid records. If only a single field is used, that field may be specified as a string. After
     * initialization, use {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()} to update the grouping field
     * list, instead of modifying groupByField directly.
     *
     * @param groupByField New groupByField value. Default value is see below
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_grouping_dynamic" target="examples">Dynamic Grouping Example</a>
     */
    public void setGroupByField(String groupByField)  throws IllegalStateException {
        setAttribute("groupByField", groupByField, false);
    }

    /**
     * List of fields to group grid records. If only a single field is used, that field may be specified as a string. After
     * initialization, use {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()} to update the grouping field
     * list, instead of modifying groupByField directly.
     *
     * @param groupByField New groupByField value. Default value is see below
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_grouping_dynamic" target="examples">Dynamic Grouping Example</a>
     */
    public void setGroupByField(String... groupByField)  throws IllegalStateException {
        setAttribute("groupByField", groupByField, false);
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute may be set to an
     * array of groupBy field names for which group summaries should appear. <P> This is particularly useful for listGrids
     * grouped by more than one field as it allows developers to display the group summary for a particular nested group
     * without showing a summary for every level of the tree.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByFieldSummaries groupByFieldSummaries} attribute
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param groupByFieldSummaries new value for this.groupByFieldSummaries. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowGroupSummary
     */
    public void setGroupByFieldSummaries(String... groupByFieldSummaries) {
        setAttribute("groupByFieldSummaries", groupByFieldSummaries, true);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute may be set to an
     * array of groupBy field names for which group summaries should appear. <P> This is particularly useful for listGrids
     * grouped by more than one field as it allows developers to display the group summary for a particular nested group
     * without showing a summary for every level of the tree.
     *
     * @return Current groupByFieldSummaries value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary
     */
    public String[] getGroupByFieldSummaries()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("groupByFieldSummaries"));
    }
    

    /**
     * Maximum number of records to which a groupBy can be applied. If there are more records, grouping will not be available
     * via the default header context menu, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}
     * will be ignored. <P> The maximum exists because ListGrid grouping is performed in-browser, hence requires loading of all
     * records that match the current filter criteria before records can be grouped.  The default maximum represents a number
     * of records which are safe to load in legacy browsers such as Internet Explorer 8 (modern browsers can handle far more),
     * and is also a good upper limit from the perspective of loading data from a database. <P> Going beyond this limit can
     * cause "script running slowly" errors from legacy browsers (as well as high database load).  To build an interface for
     * grouping that handles arbitrary data volume, use a TreeGrid with {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getLoadDataOnDemand TreeGrid.loadDataOnDemand} with server-side grouping code.
     *
     * @param groupByMaxRecords New groupByMaxRecords value. Default value is 1000
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setGroupByMaxRecords(int groupByMaxRecords) {
        setAttribute("groupByMaxRecords", groupByMaxRecords, true);
    }

    /**
     * Maximum number of records to which a groupBy can be applied. If there are more records, grouping will not be available
     * via the default header context menu, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}
     * will be ignored. <P> The maximum exists because ListGrid grouping is performed in-browser, hence requires loading of all
     * records that match the current filter criteria before records can be grouped.  The default maximum represents a number
     * of records which are safe to load in legacy browsers such as Internet Explorer 8 (modern browsers can handle far more),
     * and is also a good upper limit from the perspective of loading data from a database. <P> Going beyond this limit can
     * cause "script running slowly" errors from legacy browsers (as well as high database load).  To build an interface for
     * grouping that handles arbitrary data volume, use a TreeGrid with {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getLoadDataOnDemand TreeGrid.loadDataOnDemand} with server-side grouping code.
     *
     * @return Current groupByMaxRecords value. Default value is 1000
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public int getGroupByMaxRecords()  {
        return getAttributeAsInt("groupByMaxRecords");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Group by " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param groupByText New groupByText value. Default value is "Group by ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public void setGroupByText(String groupByText) {
        setAttribute("groupByText", groupByText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Group by " + the field's summary title.
     *
     * @return If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field.<br> Default implementation evaluates
     * and returns the dynamic {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByText groupByText} string. Default value is "Group by ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getGroupByText()  {
        return getAttributeAsString("groupByText");
    }
    

    /**
     * The URL of the base icon for the group icons in this listGrid. Default value may  be overridden by the {@link
     * com.smartgwt.client.docs.Skinning current skin}.
     *
     * @param groupIcon New groupIcon value. Default value is "[SKINIMG]/TreeGrid/opener.gif"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setGroupIcon(String groupIcon) {
        setAttribute("groupIcon", groupIcon, true);
    }

    /**
     * The URL of the base icon for the group icons in this listGrid. Default value may  be overridden by the {@link
     * com.smartgwt.client.docs.Skinning current skin}.
     *
     * @return Current groupIcon value. Default value is "[SKINIMG]/TreeGrid/opener.gif"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getGroupIcon()  {
        return getAttributeAsString("groupIcon");
    }
    

    /**
     * Default width and height of group icons for this ListGrid.
     *
     * @param groupIconSize New groupIconSize value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setGroupIconSize(int groupIconSize) {
        setAttribute("groupIconSize", groupIconSize, true);
    }

    /**
     * Default width and height of group icons for this ListGrid.
     *
     * @return Current groupIconSize value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public int getGroupIconSize()  {
        return getAttributeAsInt("groupIconSize");
    }
    

    /**
     * Default number of pixels by which to indent subgroups relative to parent group.
     *
     * @param groupIndentSize New groupIndentSize value. Default value is 20
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public void setGroupIndentSize(int groupIndentSize) {
        setAttribute("groupIndentSize", groupIndentSize, true);
    }

    /**
     * Default number of pixels by which to indent subgroups relative to parent group.
     *
     * @return Current groupIndentSize value. Default value is 20
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public int getGroupIndentSize()  {
        return getAttributeAsInt("groupIndentSize");
    }
    

    /**
     * Default number of pixels by which to indent all groups.
     *
     * @param groupLeadingIndent New groupLeadingIndent value. Default value is 10
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public void setGroupLeadingIndent(int groupLeadingIndent) {
        setAttribute("groupLeadingIndent", groupLeadingIndent, true);
    }

    /**
     * Default number of pixels by which to indent all groups.
     *
     * @return Current groupLeadingIndent value. Default value is 10
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public int getGroupLeadingIndent()  {
        return getAttributeAsInt("groupLeadingIndent");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle Base style} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows. <P> Note that this property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeStyle groupNodeStyle} is non null.
     *
     * @param groupNodeBaseStyle New groupNodeBaseStyle value. Default value is null
     */
    public void setGroupNodeBaseStyle(String groupNodeBaseStyle) {
        setAttribute("groupNodeBaseStyle", groupNodeBaseStyle, true);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle Base style} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows. <P> Note that this property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeStyle groupNodeStyle} is non null.
     *
     * @return Current groupNodeBaseStyle value. Default value is null
     */
    public String getGroupNodeBaseStyle()  {
        return getAttributeAsString("groupNodeBaseStyle");
    }
    

    /**
     * The CSS style that {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows will have. <P> Note that this is
     * not a {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle base style}, so, if this property is set, group
     * nodes will not show stateful styling (different styles for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}, etc). To enable stateful
     * styling for groupNodes, set this property to <code>null</code> and specify a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeBaseStyle groupNodeBaseStyle}
     *
     * @param groupNodeStyle New groupNodeStyle value. Default value is "groupNode"
     */
    public void setGroupNodeStyle(String groupNodeStyle) {
        setAttribute("groupNodeStyle", groupNodeStyle, true);
    }

    /**
     * The CSS style that {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows will have. <P> Note that this is
     * not a {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle base style}, so, if this property is set, group
     * nodes will not show stateful styling (different styles for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}, etc). To enable stateful
     * styling for groupNodes, set this property to <code>null</code> and specify a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeBaseStyle groupNodeBaseStyle}
     *
     * @return Current groupNodeStyle value. Default value is "groupNode"
     */
    public String getGroupNodeStyle()  {
        return getAttributeAsString("groupNodeStyle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst sortByGroupFirst} is active, the sorting
     * direction applied for implicit  sorting by the field(s) used for grouping. Default of null means that sort direction  is
     * based on the current direction of user-configured sort, or is "ascending" if the  user has not sorted the data.
     *
     * @param groupSortDirection New groupSortDirection value. Default value is null
     */
    public void setGroupSortDirection(SortDirection groupSortDirection) {
        setAttribute("groupSortDirection", groupSortDirection == null ? null : groupSortDirection.getValue(), true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst sortByGroupFirst} is active, the sorting
     * direction applied for implicit  sorting by the field(s) used for grouping. Default of null means that sort direction  is
     * based on the current direction of user-configured sort, or is "ascending" if the  user has not sorted the data.
     *
     * @return Current groupSortDirection value. Default value is null
     */
    public SortDirection getGroupSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("groupSortDirection"));
    }
    
    

    /**
     * Initial group state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>groupState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>groupState</code> has priority for group state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's grouping to match the {@link com.smartgwt.client.docs.ListGridGroupState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupState getGroupState()}.
     *
     * @param groupState Object describing the desired grouping state of                                              the grid. Default value is null
     * @see com.smartgwt.client.docs.ListGridGroupState ListGridGroupState 
     */
    public void setGroupState(String groupState) {
        setAttribute("groupState", groupState, true);
    }

    /**
     * Initial group state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>groupState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>groupState</code> has priority for group state.
     *
     * @return Returns a snapshot of the current grouping state of this ListGrid.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setGroupState setGroupState()} to reset this grid's grouping to the current
     * state (assuming the same data / fields are present in the grid).<br>. Default value is null
     * @see com.smartgwt.client.docs.ListGridGroupState ListGridGroupState 
     */
    public String getGroupState()  {
        return getAttributeAsString("groupState");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute will
     * be set to true on each record object representing a group-level summary row.
     *
     * @param groupSummaryRecordProperty New groupSummaryRecordProperty value. Default value is "isGroupSummary"
     */
    public void setGroupSummaryRecordProperty(String groupSummaryRecordProperty) {
        setAttribute("groupSummaryRecordProperty", groupSummaryRecordProperty, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute will
     * be set to true on each record object representing a group-level summary row.
     *
     * @return Current groupSummaryRecordProperty value. Default value is "isGroupSummary"
     */
    public String getGroupSummaryRecordProperty()  {
        return getAttributeAsString("groupSummaryRecordProperty");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getCustomStyle ListGridRecord.customStyle} for the group-level
     * summary row displayed when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is
     * true.
     *
     * @param groupSummaryStyle New groupSummaryStyle value. Default value is "gridSummaryCell"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setGroupSummaryStyle(String groupSummaryStyle)  throws IllegalStateException {
        setAttribute("groupSummaryStyle", groupSummaryStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getCustomStyle ListGridRecord.customStyle} for the group-level
     * summary row displayed when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is
     * true.
     *
     * @return Current groupSummaryStyle value. Default value is "gridSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getGroupSummaryStyle()  {
        return getAttributeAsString("groupSummaryStyle");
    }
    
    

    /**
     * Custom properties for the automatically generated <code>groupTitleColumn</code>. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn showGroupTitleColumn} for an overview of the
     * groupTitleColumn.
     *
     * @param groupTitleColumnProperties New groupTitleColumnProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGroupTitleColumnProperties(ListGridField groupTitleColumnProperties)  throws IllegalStateException {
        JavaScriptObject config = JSOHelper.createObject();
        if (groupTitleColumnProperties != null) {
            JSOHelper.addProperties(config, groupTitleColumnProperties.getJsObj());
        }
        setAttribute("groupTitleColumnProperties", groupTitleColumnProperties == null ? null : config, false);
    }

    /**
     * Custom properties for the automatically generated <code>groupTitleColumn</code>. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn showGroupTitleColumn} for an overview of the
     * groupTitleColumn.
     *
     * @return Current groupTitleColumnProperties value. Default value is null
     */
    public ListGridField getGroupTitleColumnProperties()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("groupTitleColumnProperties"));
    }
    

    /**
     * When a list grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, each group shows under an auto
     * generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will
     * span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though
     * they were values of the designated field instead of spanning all columns and record values in the designated
     * groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree. <P> Note
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, the
     * header nodes will not show a single spanning title value by default - instead they will show the summary values for each
     * field. In this case, if groupTitleField is unset, a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} can be automatically generated to
     * show the title for each group.
     *
     * @param groupTitleField New groupTitleField value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setGroupTitleField(String groupTitleField)  throws IllegalStateException {
        setAttribute("groupTitleField", groupTitleField, false);
    }

    /**
     * When a list grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, each group shows under an auto
     * generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will
     * span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though
     * they were values of the designated field instead of spanning all columns and record values in the designated
     * groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree. <P> Note
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, the
     * header nodes will not show a single spanning title value by default - instead they will show the summary values for each
     * field. In this case, if groupTitleField is unset, a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} can be automatically generated to
     * show the title for each group.
     *
     * @return Current groupTitleField value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public String getGroupTitleField()  {
        return getAttributeAsString("groupTitleField");
    }
    

    /**
     * The data tree that results from a call to  {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}. This
     * will be a {@link com.smartgwt.client.widgets.tree.ResultTree} if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is present, otherwise it will be a {@link
     * com.smartgwt.client.widgets.tree.Tree}.
     * <p>
     * This component is an AutoChild named "groupTree".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current groupTree value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Tree getGroupTree()  {
        return Tree.getOrCreateRef(getAttributeAsJavaScriptObject("groupTree"));
    }
    

    /**
     * A Toolbar used to manager the headers shown for each column of the grid.
     * <p>
     * This component is an AutoChild named "header".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current header value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Layout getHeader() throws IllegalStateException {
        errorIfNotCreated("header");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("header"));
    }
    

    /**
     * Event on a ListGrid header that triggers auto fitting to data and/or title. <P> Note that if sorting is enabled for the
     * field and the headerAutoFitEvent is "click", both sorting and autofit occur on a click. <P> Only has an impact when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} or  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is set to
     * <code>true</code>.
     *
     * @param headerAutoFitEvent New headerAutoFitEvent value. Default value is "doubleClick"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderAutoFitEvent(AutoFitEvent headerAutoFitEvent)  throws IllegalStateException {
        setAttribute("headerAutoFitEvent", headerAutoFitEvent == null ? null : headerAutoFitEvent.getValue(), false);
    }

    /**
     * Event on a ListGrid header that triggers auto fitting to data and/or title. <P> Note that if sorting is enabled for the
     * field and the headerAutoFitEvent is "click", both sorting and autofit occur on a click. <P> Only has an impact when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} or  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} is set to
     * <code>true</code>.
     *
     * @return Current headerAutoFitEvent value. Default value is "doubleClick"
     */
    public AutoFitEvent getHeaderAutoFitEvent()  {
        return EnumUtil.getEnum(AutoFitEvent.values(), getAttribute("headerAutoFitEvent"));
    }
    

    /**
     * BackgroundColor for the header toolbar. Typically this is set to match the color of the header buttons.
     *
     * @param headerBackgroundColor New headerBackgroundColor value. Default value is "#CCCCCC"
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setHeaderBackgroundColor(String headerBackgroundColor) {
        setAttribute("headerBackgroundColor", headerBackgroundColor, true);
    }

    /**
     * BackgroundColor for the header toolbar. Typically this is set to match the color of the header buttons.
     *
     * @return Current headerBackgroundColor value. Default value is "#CCCCCC"
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderBackgroundColor()  {
        return getAttributeAsString("headerBackgroundColor");
    }
    

    /**
     * Set the CSS style used for the header as a whole.
     *
     * @param headerBarStyle New headerBarStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setHeaderBarStyle(String headerBarStyle)  throws IllegalStateException {
        setAttribute("headerBarStyle", headerBarStyle, false);
    }

    /**
     * Set the CSS style used for the header as a whole.
     *
     * @return Current headerBarStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderBarStyle()  {
        return getAttributeAsString("headerBarStyle");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle Button.baseStyle} to apply to the buttons in the header, and the
     * sorter, for
     *  this ListGrid.
     * Note that, depending on the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the
     * header
     * buttons, you may also need to set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle
     * headerTitleStyle}.
     *  <P>
     *  <h4>Rotated Titles</h4>
     *  <p>
     *  The Framework doesn't have built-in support for rotating header button titles in a
     * fashion similar to {@link com.smartgwt.client.widgets.chart.FacetChart#getRotateLabels FacetChart.rotateLabels}. 
     * However, you can manually configure
     * a grid to render with rotated labels by applying a fixed {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth
     * ListGridField.width} to
     * each button, a large {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight} to the grid, and
     * custom CSS via this property.
     *  <P>
     *  For example, given a grid with a header height of 120 and field widths of 48, if you
     *  copied the existing headerButtonXXX style declarations from skin_styles.css as new,
     *  customHeaderButtonXXX declarations, and then added the lines:
     *  <pre>
     *      -ms-transform:     translate(-32px,0px) rotate(270deg);
     *      -webkit-transform: translate(-32px,0px) rotate(270deg);
     *      transform:         translate(-32px,0px) rotate(270deg);
     *      width:110px;</pre>
     *  in the declaration section beginning:
     *  <pre>
     *  .customHeaderButton,
     *  .customHeaderButtonSelected,
     *  .customHeaderButtonSelectedOver,
     *  .customHeaderButtonSelectedDown,
     *  .customHeaderButtonSelectedDisabled,
     *  .customHeaderButtonOver,
     *  .customHeaderButtonDown,
     *  .customHeaderButtonDisabled {</pre>
     *  you'd get vertically rendered titles with overflow via ellipsis as expected, and also
     * wrap with {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapHeaderTitles wrapHeaderTitles}.  The explicit width
     * applied via CSS is needed because
     *  rotated elements don't inherit dimensions in their new orientation from the DOM - the
     *  transform/rotation occurs independently of layout.
     *
     * @param headerBaseStyle New headerBaseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setClipHeaderTitles
     * @see com.smartgwt.client.widgets.grid.ListGrid#setWrapHeaderTitles
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setHeaderBaseStyle(String headerBaseStyle)  throws IllegalStateException {
        setAttribute("headerBaseStyle", headerBaseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle Button.baseStyle} to apply to the buttons in the header, and the
     * sorter, for
     *  this ListGrid.
     * Note that, depending on the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the
     * header
     * buttons, you may also need to set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle
     * headerTitleStyle}.
     *  <P>
     *  <h4>Rotated Titles</h4>
     *  <p>
     *  The Framework doesn't have built-in support for rotating header button titles in a
     * fashion similar to {@link com.smartgwt.client.widgets.chart.FacetChart#getRotateLabels FacetChart.rotateLabels}. 
     * However, you can manually configure
     * a grid to render with rotated labels by applying a fixed {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth
     * ListGridField.width} to
     * each button, a large {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight} to the grid, and
     * custom CSS via this property.
     *  <P>
     *  For example, given a grid with a header height of 120 and field widths of 48, if you
     *  copied the existing headerButtonXXX style declarations from skin_styles.css as new,
     *  customHeaderButtonXXX declarations, and then added the lines:
     *  <pre>
     *      -ms-transform:     translate(-32px,0px) rotate(270deg);
     *      -webkit-transform: translate(-32px,0px) rotate(270deg);
     *      transform:         translate(-32px,0px) rotate(270deg);
     *      width:110px;</pre>
     *  in the declaration section beginning:
     *  <pre>
     *  .customHeaderButton,
     *  .customHeaderButtonSelected,
     *  .customHeaderButtonSelectedOver,
     *  .customHeaderButtonSelectedDown,
     *  .customHeaderButtonSelectedDisabled,
     *  .customHeaderButtonOver,
     *  .customHeaderButtonDown,
     *  .customHeaderButtonDisabled {</pre>
     *  you'd get vertically rendered titles with overflow via ellipsis as expected, and also
     * wrap with {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapHeaderTitles wrapHeaderTitles}.  The explicit width
     * applied via CSS is needed because
     *  rotated elements don't inherit dimensions in their new orientation from the DOM - the
     *  transform/rotation occurs independently of layout.
     *
     * @return Current headerBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles
     * @see com.smartgwt.client.widgets.grid.ListGrid#getWrapHeaderTitles
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderBaseStyle()  {
        return getAttributeAsString("headerBaseStyle");
    }
    
    
    

    /**
     * Properties to apply to all header buttons. Overrides defaults applied via  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonDefaults headerButtonDefaults}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerButtonProperties New headerButtonProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public void setHeaderButtonProperties(Button headerButtonProperties)  throws IllegalStateException {
        if (headerButtonProperties != null) {
            if (headerButtonProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setHeaderButtonProperties", "Button");
            }                                                                       
            headerButtonProperties.setConfigOnly(true);
        }
        JavaScriptObject config = headerButtonProperties == null ? null : headerButtonProperties.getConfig();
        setAttribute("headerButtonProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to all header buttons. Overrides defaults applied via  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonDefaults headerButtonDefaults}.
     *
     * @return Current headerButtonProperties value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Button getHeaderButtonProperties()  {
        Button properties = new Button();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("headerButtonProperties"));
        return properties;
    }
    

    /**
     * The context menu displayed for column headers.
     * <p>
     * This component is an AutoChild named "headerContextMenu".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current headerContextMenu value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Canvas getHeaderContextMenu() throws IllegalStateException {
        errorIfNotCreated("headerContextMenu");
        return (Canvas)Canvas.getByJSObject(getAttributeAsJavaScriptObject("headerContextMenu"));
    }
    

    /**
     * The height of this listGrid's header, in pixels.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Modify the height of a listGrid. To hide the header set height to zero.
     *
     * @param headerHeight new height for the header. Default value is 22
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public void setHeaderHeight(int headerHeight) {
        setAttribute("headerHeight", headerHeight, true);
    }

    /**
     * The height of this listGrid's header, in pixels.
     *
     * @return Current headerHeight value. Default value is 22
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public int getHeaderHeight()  {
        return getAttributeAsInt("headerHeight");
    }
    

    /**
     * This property may be set to customize the alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverAlign New headerHoverAlign value. Default value is null
     */
    public void setHeaderHoverAlign(Alignment headerHoverAlign) {
        setAttribute("headerHoverAlign", headerHoverAlign == null ? null : headerHoverAlign.getValue(), true);
    }

    /**
     * This property may be set to customize the alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverAlign value. Default value is null
     */
    public Alignment getHeaderHoverAlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("headerHoverAlign"));
    }
    

    /**
     * Optional default height for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @param headerHoverHeight New headerHoverHeight value. Default value is null
     */
    public void setHeaderHoverHeight(Integer headerHoverHeight) {
        setAttribute("headerHoverHeight", headerHoverHeight, true);
    }

    /**
     * Optional default height for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @return Current headerHoverHeight value. Default value is null
     */
    public Integer getHeaderHoverHeight()  {
        return getAttributeAsInt("headerHoverHeight");
    }
    

    /**
     * This property may be set to customize the opacity for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverOpacity New headerHoverOpacity value. Default value is null
     */
    public void setHeaderHoverOpacity(Integer headerHoverOpacity) {
        setAttribute("headerHoverOpacity", headerHoverOpacity, true);
    }

    /**
     * This property may be set to customize the opacity for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverOpacity value. Default value is null
     */
    public Integer getHeaderHoverOpacity()  {
        return getAttributeAsInt("headerHoverOpacity");
    }
    

    /**
     * This property may be set to customize the css style for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverStyle New headerHoverStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setHeaderHoverStyle(String headerHoverStyle) {
        setAttribute("headerHoverStyle", headerHoverStyle, true);
    }

    /**
     * This property may be set to customize the css style for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getHeaderHoverStyle()  {
        return getAttributeAsString("headerHoverStyle");
    }
    

    /**
     * This property may be set to customize the vertical alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverVAlign New headerHoverVAlign value. Default value is null
     */
    public void setHeaderHoverVAlign(VerticalAlignment headerHoverVAlign) {
        setAttribute("headerHoverVAlign", headerHoverVAlign == null ? null : headerHoverVAlign.getValue(), true);
    }

    /**
     * This property may be set to customize the vertical alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverVAlign value. Default value is null
     */
    public VerticalAlignment getHeaderHoverVAlign()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("headerHoverVAlign"));
    }
    

    /**
     * Optional default width for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @param headerHoverWidth New headerHoverWidth value. Default value is null
     */
    public void setHeaderHoverWidth(Integer headerHoverWidth) {
        setAttribute("headerHoverWidth", headerHoverWidth, true);
    }

    /**
     * Optional default width for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @return Current headerHoverWidth value. Default value is null
     */
    public Integer getHeaderHoverWidth()  {
        return getAttributeAsInt("headerHoverWidth");
    }
    

    /**
     * This property may be set to customize the <code>wrap</code> attribute for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverWrap New headerHoverWrap value. Default value is null
     */
    public void setHeaderHoverWrap(Boolean headerHoverWrap) {
        setAttribute("headerHoverWrap", headerHoverWrap, true);
    }

    /**
     * This property may be set to customize the <code>wrap</code> attribute for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Current headerHoverWrap value. Default value is null
     */
    public Boolean getHeaderHoverWrap()  {
        return getAttributeAsBoolean("headerHoverWrap");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, when the user
     * rolls over the header buttons in this grid the headerMenuButton will be shown over the header button in question. When
     * clicked this button will display the standard header context menu (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu displayHeaderContextMenu()}). <P> {@link
     * com.smartgwt.client.docs.HeaderMenuButton Several properties} exist to customize the appearance of the headerMenuButton.
     * Also see the {@link com.smartgwt.client.types.AutoChild} documentation for information on how to make free-form
     * modifications to autoChild widgets
     * <p>
     * This component is an AutoChild named "headerMenuButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current headerMenuButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public StatefulCanvas getHeaderMenuButton() throws IllegalStateException {
        errorIfNotCreated("headerMenuButton");
        return (StatefulCanvas)StatefulCanvas.getByJSObject(getAttributeAsJavaScriptObject("headerMenuButton"));
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonHeight New headerMenuButtonHeight value. Default value is "100%"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonHeight(int headerMenuButtonHeight)  throws IllegalStateException {
        setAttribute("headerMenuButtonHeight", headerMenuButtonHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonHeight value. Default value is "100%"
     */
    public int getHeaderMenuButtonHeight()  {
        return getAttributeAsInt("headerMenuButtonHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIcon New headerMenuButtonIcon value. Default value is "[SKIN]/ListGrid/headerMenuButton_icon.gif"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.URL URL 
     */
    public void setHeaderMenuButtonIcon(String headerMenuButtonIcon)  throws IllegalStateException {
        setAttribute("headerMenuButtonIcon", headerMenuButtonIcon, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonIcon value. Default value is "[SKIN]/ListGrid/headerMenuButton_icon.gif"
     * @see com.smartgwt.client.docs.URL URL 
     */
    public String getHeaderMenuButtonIcon()  {
        return getAttributeAsString("headerMenuButtonIcon");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIconHeight New headerMenuButtonIconHeight value. Default value is 7
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonIconHeight(int headerMenuButtonIconHeight)  throws IllegalStateException {
        setAttribute("headerMenuButtonIconHeight", headerMenuButtonIconHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonIconHeight value. Default value is 7
     */
    public int getHeaderMenuButtonIconHeight()  {
        return getAttributeAsInt("headerMenuButtonIconHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIconWidth New headerMenuButtonIconWidth value. Default value is 7
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonIconWidth(int headerMenuButtonIconWidth)  throws IllegalStateException {
        setAttribute("headerMenuButtonIconWidth", headerMenuButtonIconWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonIconWidth value. Default value is 7
     */
    public int getHeaderMenuButtonIconWidth()  {
        return getAttributeAsInt("headerMenuButtonIconWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonWidth New headerMenuButtonWidth value. Default value is 16
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonWidth(int headerMenuButtonWidth)  throws IllegalStateException {
        setAttribute("headerMenuButtonWidth", headerMenuButtonWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code>
     *
     * @return Current headerMenuButtonWidth value. Default value is 16
     */
    public int getHeaderMenuButtonWidth()  {
        return getAttributeAsInt("headerMenuButtonWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowColor Canvas.shadowColor} for the header shadow.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowColor New headerShadowColor value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public void setHeaderShadowColor(String headerShadowColor)  throws IllegalStateException {
        setAttribute("headerShadowColor", headerShadowColor, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowColor Canvas.shadowColor} for the header shadow.
     *
     * @return Current headerShadowColor value. Default value is null
     * @see com.smartgwt.client.docs.CSSColor CSSColor 
     */
    public String getHeaderShadowColor()  {
        return getAttributeAsString("headerShadowColor");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowHOffset Canvas.shadowHOffset} for the header shadow
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowHOffset New headerShadowHOffset value. Default value is 0
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderShadowHOffset(int headerShadowHOffset)  throws IllegalStateException {
        setAttribute("headerShadowHOffset", headerShadowHOffset, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowHOffset Canvas.shadowHOffset} for the header shadow
     *
     * @return Current headerShadowHOffset value. Default value is 0
     */
    public int getHeaderShadowHOffset()  {
        return getAttributeAsInt("headerShadowHOffset");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowSoftness Canvas.shadowSoftness} for the header shadow
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowSoftness New headerShadowSoftness value. Default value is 1
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderShadowSoftness(int headerShadowSoftness)  throws IllegalStateException {
        setAttribute("headerShadowSoftness", headerShadowSoftness, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowSoftness Canvas.shadowSoftness} for the header shadow
     *
     * @return Current headerShadowSoftness value. Default value is 1
     */
    public int getHeaderShadowSoftness()  {
        return getAttributeAsInt("headerShadowSoftness");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowVOffset Canvas.shadowVOffset} for the header shadow
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerShadowVOffset New headerShadowVOffset value. Default value is 1
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderShadowVOffset(int headerShadowVOffset)  throws IllegalStateException {
        setAttribute("headerShadowVOffset", headerShadowVOffset, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderShadow showHeaderShadow} is true, the {@link
     * com.smartgwt.client.widgets.Canvas#getShadowVOffset Canvas.shadowVOffset} for the header shadow
     *
     * @return Current headerShadowVOffset value. Default value is 1
     */
    public int getHeaderShadowVOffset()  {
        return getAttributeAsInt("headerShadowVOffset");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are created via the {@link
     * com.smartgwt.client.types.AutoChild} pattern, hence <code>headerSpanConstructor</code>, <code>headerSpanDefaults</code>
     * and <code>headerSpanProperties</code> are valid.
     *
     * @return null
     */
    public StatefulCanvas getHeaderSpan()  {
        return null;
    }
    
    

    /**
     * Default height for a {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan} with no height
     * specified. <P> If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2 of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @param headerSpanHeight New headerSpanHeight value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderSpanHeight(Integer headerSpanHeight)  throws IllegalStateException {
        setAttribute("headerSpanHeight", headerSpanHeight, false);
    }

    /**
     * Default height for a {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan} with no height
     * specified. <P> If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2 of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @return Current headerSpanHeight value. Default value is null
     */
    public Integer getHeaderSpanHeight()  {
        return getAttributeAsInt("headerSpanHeight");
    }
    

    /**
     * Header spans are a second level of headers that appear above the normal ListGrid headers,
     *  spanning one or more listGrid fields in a manner similar to a column-spanning cell in an
     *  HTML table.
     *  <P>
     *  A header span can be created by simply naming the fields the header should span.  The
     *  example below creates a headerSpan that spans the first two fields of the ListGrid.
     *  
     *  
     *  <pre>
     *       ListGrid grid = new ListGrid();
     *       grid.setHeaderHeight(40);
     *       grid.setFields(new ListGridField[] {
     *           new ListGridField("field1"),
     *           new ListGridField("field2"),
     *           new ListGridField("field3")
     *       });
     *       grid.setHeaderSpans(new HeaderSpan[] {
     *           new HeaderSpan("Field 1 and 2", new String[] {"field1", "field2"})
     *       });
     *  </pre>
     *  
     *  Header spans can be nested, allowing fields to be grouped by multiple levels of
     * granularity. See {@link com.smartgwt.client.widgets.grid.HeaderSpan#getSpans HeaderSpan.spans} for further information
     * on nesting spans.
     *  <P>
     *  Header spans will automatically react to resizing of the headers they span, and will be
     *  hidden automatically when all of the spanned fields are hidden.
     *  <P>
     * Header spans appear in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader header} area of the ListGrid,
     * sharing space
     * with the existing headers, so it's typical to set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight} to
     *  approximately double its normal height when using headerSpans, or if using nested header
     *  spans, the default header height multiplied by the number of levels of header spans to be
     *  shown.
     *  <P>
     *  See {@link com.smartgwt.client.widgets.grid.HeaderSpan} for many properties that allow the control of the appearance of
     *  headerSpans.
     *  
     *  <P>
     *  Neither headerSpans themselves nor the fields within them may be drag reordered, but other
     *  unspanned headers may be.
     *  <P>
     *  A span can only span adjacent fields - if a span is defined and the spanned fields don't
     *  sit next to each other in the specified fields array, the fields array will be automatically
     * reordered to match the order specified in the span's {@link com.smartgwt.client.widgets.grid.HeaderSpan#getFields
     * HeaderSpan.fields} array.
     *  <P>
     *  Note that headerSpans primarily provide a visual cue for grouping multiple headers
     *  together.  If you have an OLAP, data "cube" or multi-dimensional data model, the
     *  {@link com.smartgwt.client.widgets.cube.CubeGrid} component is the right choice.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the headerSpans configuration on the grid dynamically.
     *
     * @param headerSpans same configuration block as that passed to                                          {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}. Default value is null
     */
    public void setHeaderSpans(HeaderSpan... headerSpans) {
        setAttribute("headerSpans", headerSpans, true);
    }
    
    

    /**
     * {@link com.smartgwt.client.widgets.StretchImgButton#getTitleStyle StretchImgButton.titleStyle} to apply to the buttons
     * in the header, and the sorter, for this ListGrid. Note that this will typically only have an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor headerButtonConstructor} is set to {@link
     * com.smartgwt.client.widgets.StretchImgButton} or a subclass thereof.
     *
     * @param headerTitleStyle New headerTitleStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setHeaderTitleStyle(String headerTitleStyle)  throws IllegalStateException {
        setAttribute("headerTitleStyle", headerTitleStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.StretchImgButton#getTitleStyle StretchImgButton.titleStyle} to apply to the buttons
     * in the header, and the sorter, for this ListGrid. Note that this will typically only have an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor headerButtonConstructor} is set to {@link
     * com.smartgwt.client.widgets.StretchImgButton} or a subclass thereof.
     *
     * @return Current headerTitleStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getHeaderTitleStyle()  {
        return getAttributeAsString("headerTitleStyle");
    }
    

    /**
     * If true, causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow} component to be hidden if
     * it has no data after summaries have been recalculated
     *
     * @param hideEmptySummaryRow New hideEmptySummaryRow value. Default value is null
     */
    public void setHideEmptySummaryRow(Boolean hideEmptySummaryRow) {
        setAttribute("hideEmptySummaryRow", hideEmptySummaryRow, true);
    }

    /**
     * If true, causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow} component to be hidden if
     * it has no data after summaries have been recalculated
     *
     * @return Current hideEmptySummaryRow value. Default value is null
     */
    public Boolean getHideEmptySummaryRow()  {
        return getAttributeAsBoolean("hideEmptySummaryRow");
    }
    

    /**
     * If set, end users can create advanced hiliting rules that will use the {@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue} feature to cause values in hilited cells to
     * be replaced with a user-entered value.  For example, a user could create a hilite rule that replaces numeric values
     * ranging from 0.5 to 1.0 with the text "LOW". <p> Specifically, when the "Add Advanced Rule" button is pressed and
     * <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled "Replace value with" ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteReplaceValueFieldTitle hiliteReplaceValueFieldTitle}) and if they
     * enter a value, that value will appear in the grid cell in lieu of the cell's original value.
     *
     * @param hiliteCanReplaceValue New hiliteCanReplaceValue value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteCanReplaceValue(Boolean hiliteCanReplaceValue)  throws IllegalStateException {
        setAttribute("hiliteCanReplaceValue", hiliteCanReplaceValue, false);
    }

    /**
     * If set, end users can create advanced hiliting rules that will use the {@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue} feature to cause values in hilited cells to
     * be replaced with a user-entered value.  For example, a user could create a hilite rule that replaces numeric values
     * ranging from 0.5 to 1.0 with the text "LOW". <p> Specifically, when the "Add Advanced Rule" button is pressed and
     * <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled "Replace value with" ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteReplaceValueFieldTitle hiliteReplaceValueFieldTitle}) and if they
     * enter a value, that value will appear in the grid cell in lieu of the cell's original value.
     *
     * @return Current hiliteCanReplaceValue value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Boolean getHiliteCanReplaceValue()  {
        return getAttributeAsBoolean("hiliteCanReplaceValue");
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInHiliteEditor showHeaderSpanTitlesInHiliteEditor} is
     * true, this string will be inserted between the headerSpan title and the field title in the hiliteEditor field chooser
     * grid.
     *
     * @param hiliteEditorSpanTitleSeparator New hiliteEditorSpanTitleSeparator value. Default value is " - "
     */
    public void setHiliteEditorSpanTitleSeparator(String hiliteEditorSpanTitleSeparator) {
        setAttribute("hiliteEditorSpanTitleSeparator", hiliteEditorSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInHiliteEditor showHeaderSpanTitlesInHiliteEditor} is
     * true, this string will be inserted between the headerSpan title and the field title in the hiliteEditor field chooser
     * grid.
     *
     * @return Current hiliteEditorSpanTitleSeparator value. Default value is " - "
     */
    public String getHiliteEditorSpanTitleSeparator()  {
        return getAttributeAsString("hiliteEditorSpanTitleSeparator");
    }
    

    /**
     * If set to true, custom HTML applied as part of hiliting will be applied after {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} for each cell. If false, hilite HTML will be
     * applied before formatting. <P> This applies to the following hilite properties: <ul> <li>{@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlBefore Hilite.htmlBefore}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlAfter Hilite.htmlAfter}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlValue Hilite.htmlValue}</li> </ul> <P> May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteHTMLAfterFormat ListGridField.hiliteHTMLAfterFormat}
     *
     * @param hiliteHTMLAfterFormat New hiliteHTMLAfterFormat value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHiliteHTMLAfterFormat(boolean hiliteHTMLAfterFormat)  throws IllegalStateException {
        setAttribute("hiliteHTMLAfterFormat", hiliteHTMLAfterFormat, false);
    }

    /**
     * If set to true, custom HTML applied as part of hiliting will be applied after {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} for each cell. If false, hilite HTML will be
     * applied before formatting. <P> This applies to the following hilite properties: <ul> <li>{@link
     * com.smartgwt.client.data.Hilite#getReplacementValue Hilite.replacementValue}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlBefore Hilite.htmlBefore}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlAfter Hilite.htmlAfter}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlValue Hilite.htmlValue}</li> </ul> <P> May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteHTMLAfterFormat ListGridField.hiliteHTMLAfterFormat}
     *
     * @return Current hiliteHTMLAfterFormat value. Default value is true
     */
    public boolean getHiliteHTMLAfterFormat()  {
        Boolean result = getAttributeAsBoolean("hiliteHTMLAfterFormat");
        return result == null ? true : result;
    }
    

    /**
     * Height for hilite icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level
     *
     * @param hiliteIconHeight New hiliteIconHeight value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconHeight(Integer hiliteIconHeight) {
        setAttribute("hiliteIconHeight", hiliteIconHeight, true);
    }

    /**
     * Height for hilite icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level
     *
     * @return Current hiliteIconHeight value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Integer getHiliteIconHeight()  {
        return getAttributeAsInt("hiliteIconHeight");
    }
    

    /**
     * How much padding should there be on the left of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @param hiliteIconLeftPadding New hiliteIconLeftPadding value. Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconLeftPadding(int hiliteIconLeftPadding) {
        setAttribute("hiliteIconLeftPadding", hiliteIconLeftPadding, true);
    }

    /**
     * How much padding should there be on the left of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @return Current hiliteIconLeftPadding value. Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconLeftPadding()  {
        return getAttributeAsInt("hiliteIconLeftPadding");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hiliteIcons} are present, where the hilite icon
     * will be placed  relative to the field value.  See {@link com.smartgwt.client.types.HiliteIconPosition}. Can be
     * overridden at the field level.
     *
     * @param hiliteIconPosition New hiliteIconPosition value. Default value is "before"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconPosition(HiliteIconPosition hiliteIconPosition)  throws IllegalStateException {
        setAttribute("hiliteIconPosition", hiliteIconPosition == null ? null : hiliteIconPosition.getValue(), false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hiliteIcons} are present, where the hilite icon
     * will be placed  relative to the field value.  See {@link com.smartgwt.client.types.HiliteIconPosition}. Can be
     * overridden at the field level.
     *
     * @return Current hiliteIconPosition value. Default value is "before"
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public HiliteIconPosition getHiliteIconPosition()  {
        return EnumUtil.getEnum(HiliteIconPosition.values(), getAttribute("hiliteIconPosition"));
    }
    

    /**
     * How much padding should there be on the right of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @param hiliteIconRightPadding New hiliteIconRightPadding value. Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconRightPadding(int hiliteIconRightPadding) {
        setAttribute("hiliteIconRightPadding", hiliteIconRightPadding, true);
    }

    /**
     * How much padding should there be on the right of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @return Current hiliteIconRightPadding value. Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconRightPadding()  {
        return getAttributeAsInt("hiliteIconRightPadding");
    }
    

    /**
     * Specifies a list of icons that can be used in {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * hilites}. <P> <code>hiliteIcons</code> should be specified as an Array of {@link com.smartgwt.client.docs.SCImgURL}.
     * When present, the hilite editing interface shown when {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * DataBoundComponent.editHilites()} is called  will offer the user a drop down for picking one of these icons when
     * defining either a  simple or advanced hilite rule. <P> If the user picks an icon, the created hiliting rule will have
     * {@link com.smartgwt.client.data.Hilite#getIcon Hilite.icon} set to  the chosen icon.  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteIconPosition DataBoundComponent.hiliteIconPosition} controls
     * where the icon will  appear for that field -- the default is that it appears in front of the normal cell content. This
     * can also be overridden at the field level.
     *
     * @param hiliteIcons New hiliteIcons value. Default value is ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"]
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIcons(String... hiliteIcons)  throws IllegalStateException {
        setAttribute("hiliteIcons", hiliteIcons, false);
    }

    /**
     * Specifies a list of icons that can be used in {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * hilites}. <P> <code>hiliteIcons</code> should be specified as an Array of {@link com.smartgwt.client.docs.SCImgURL}.
     * When present, the hilite editing interface shown when {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * DataBoundComponent.editHilites()} is called  will offer the user a drop down for picking one of these icons when
     * defining either a  simple or advanced hilite rule. <P> If the user picks an icon, the created hiliting rule will have
     * {@link com.smartgwt.client.data.Hilite#getIcon Hilite.icon} set to  the chosen icon.  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteIconPosition DataBoundComponent.hiliteIconPosition} controls
     * where the icon will  appear for that field -- the default is that it appears in front of the normal cell content. This
     * can also be overridden at the field level.
     *
     * @return Current hiliteIcons value. Default value is ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"]
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public String[] getHiliteIcons()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("hiliteIcons"));
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite icons} for this
     * component. Can be overridden at the component level via explicit  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth hiliteIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight hiliteIconHeight}, or at the field level via  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize hiliteIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconWidth hiliteIconWidth} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconHeight hiliteIconHeight}
     *
     * @param hiliteIconSize New hiliteIconSize value. Default value is 12
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#setHiliteIconSize
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconSize(int hiliteIconSize) {
        setAttribute("hiliteIconSize", hiliteIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite icons} for this
     * component. Can be overridden at the component level via explicit  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth hiliteIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight hiliteIconHeight}, or at the field level via  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize hiliteIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconWidth hiliteIconWidth} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconHeight hiliteIconHeight}
     *
     * @return Current hiliteIconSize value. Default value is 12
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconSize()  {
        return getAttributeAsInt("hiliteIconSize");
    }
    

    /**
     * Width for hilite icons for this component. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level.
     *
     * @param hiliteIconWidth New hiliteIconWidth value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconWidth(Integer hiliteIconWidth) {
        setAttribute("hiliteIconWidth", hiliteIconWidth, true);
    }

    /**
     * Width for hilite icons for this component. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level.
     *
     * @return Current hiliteIconWidth value. Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Integer getHiliteIconWidth()  {
        return getAttributeAsInt("hiliteIconWidth");
    }
    

    /**
     * Title used for the text box shown when {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteCanReplaceValue
     * hiliteCanReplaceValue} is set.
     *
     * @param hiliteReplaceValueFieldTitle New hiliteReplaceValueFieldTitle value. Default value is "Replace value with"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHiliteReplaceValueFieldTitle(String hiliteReplaceValueFieldTitle)  throws IllegalStateException {
        setAttribute("hiliteReplaceValueFieldTitle", hiliteReplaceValueFieldTitle, false);
    }

    /**
     * Title used for the text box shown when {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteCanReplaceValue
     * hiliteCanReplaceValue} is set.
     *
     * @return Current hiliteReplaceValueFieldTitle value. Default value is "Replace value with"
     */
    public String getHiliteReplaceValueFieldTitle()  {
        return getAttributeAsString("hiliteReplaceValueFieldTitle");
    }
    

    /**
     * When the grid body gets keyboard focus, should we highlight the current focus row, using the rollover cell style? <P>
     * This property may be explicitly set to control this behavior independently of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}. Otherwise (if this property is null), we will
     * show the roll-over styling for the keyboard focus row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @param hiliteRowOnFocus New hiliteRowOnFocus value. Default value is null
     */
    public void setHiliteRowOnFocus(Boolean hiliteRowOnFocus) {
        setAttribute("hiliteRowOnFocus", hiliteRowOnFocus, true);
    }

    /**
     * When the grid body gets keyboard focus, should we highlight the current focus row, using the rollover cell style? <P>
     * This property may be explicitly set to control this behavior independently of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}. Otherwise (if this property is null), we will
     * show the roll-over styling for the keyboard focus row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @return Current hiliteRowOnFocus value. Default value is null
     */
    public Boolean getHiliteRowOnFocus()  {
        return getAttributeAsBoolean("hiliteRowOnFocus");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is true, the builtin
     * mode to use when automatically creating a hover component for rows in this grid. <P> A number of builtin modes are
     * provided - see {@link com.smartgwt.client.types.HoverMode}.  You can also override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()} to provide a custom hover
     * widget - in that case, this attribute is ignored.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param hoverMode New hoverMode value. Default value is null
     */
    public void setHoverMode(HoverMode hoverMode) {
        setAttribute("hoverMode", hoverMode == null ? null : hoverMode.getValue(), true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is true, the builtin
     * mode to use when automatically creating a hover component for rows in this grid. <P> A number of builtin modes are
     * provided - see {@link com.smartgwt.client.types.HoverMode}.  You can also override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()} to provide a custom hover
     * widget - in that case, this attribute is ignored.
     *
     * @return Current hoverMode value. Default value is null
     */
    public HoverMode getHoverMode()  {
        return EnumUtil.getEnum(HoverMode.values(), getAttribute("hoverMode"));
    }
    

    /**
     * Style to apply to hovers shown over this grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param hoverStyle New hoverStyle value. Default value is "gridHover"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowHover
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setHoverStyle(String hoverStyle) {
        setAttribute("hoverStyle", hoverStyle, true);
    }

    /**
     * Style to apply to hovers shown over this grid.
     *
     * @return Current hoverStyle value. Default value is "gridHover"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowHover
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getHoverStyle()  {
        return getAttributeAsString("hoverStyle");
    }
    

    /**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, padding in pixels
     * left on each side of fields that show images.
     *
     * @param iconPadding New iconPadding value. Default value is 2
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setIconPadding(Integer iconPadding)  throws IllegalStateException {
        setAttribute("iconPadding", iconPadding, false);
    }

    /**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, padding in pixels
     * left on each side of fields that show images.
     *
     * @return Current iconPadding value. Default value is 2
     */
    public Integer getIconPadding()  {
        return getAttributeAsInt("iconPadding");
    }
    

    /**
     * Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageSize ListGridField.imageSize} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageWidth ListGridField.imageWidth}/{@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageHeight ListGridField.imageHeight}
     *
     * @param imageSize New imageSize value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setImageSize(int imageSize) {
        setAttribute("imageSize", imageSize, true);
    }

    /**
     * Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageSize ListGridField.imageSize} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageWidth ListGridField.imageWidth}/{@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageHeight ListGridField.imageHeight}
     *
     * @return Current imageSize value. Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getImageSize()  {
        return getAttributeAsInt("imageSize");
    }
    
    

    /**
     * When assembling a value for a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}, if
     * a referenced field is hilited, should the hilite HTML be included in the summary field value? <P> To control hilites
     * showing in group summaries, see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHilitesInGroupSummary
     * showHilitesInGroupSummary}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param includeHilitesInSummaryFields New includeHilitesInSummaryFields value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#shouldIncludeHiliteInSummaryField
     */
    public void setIncludeHilitesInSummaryFields(boolean includeHilitesInSummaryFields) {
        setAttribute("includeHilitesInSummaryFields", includeHilitesInSummaryFields, true);
    }

    /**
     * When assembling a value for a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}, if
     * a referenced field is hilited, should the hilite HTML be included in the summary field value? <P> To control hilites
     * showing in group summaries, see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHilitesInGroupSummary
     * showHilitesInGroupSummary}.
     *
     * @return Current includeHilitesInSummaryFields value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#shouldIncludeHiliteInSummaryField
     */
    public boolean getIncludeHilitesInSummaryFields()  {
        Boolean result = getAttributeAsBoolean("includeHilitesInSummaryFields");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record should be included when calculating totals
     * for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}.
     *
     * @param includeInSummaryProperty New includeInSummaryProperty value. Default value is "includeInSummary"
     */
    public void setIncludeInSummaryProperty(String includeInSummaryProperty) {
        setAttribute("includeInSummaryProperty", includeInSummaryProperty, true);
    }

    /**
     * Property name on a record that will be checked to determine whether a record should be included when calculating totals
     * for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}.
     *
     * @return Current includeInSummaryProperty value. Default value is "includeInSummary"
     */
    public String getIncludeInSummaryProperty()  {
        return getAttributeAsString("includeInSummaryProperty");
    }
    
    

    /**
     * An array of {@link com.smartgwt.client.data.SortSpecifier} objects used to set up the initial sort configuration for
     * this grid. If specified, this will be used instead of any {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField
     * sortField} specified.
     *
     * @param initialSort New initialSort value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setInitialSort(SortSpecifier... initialSort)  throws IllegalStateException {
        setAttribute("initialSort", initialSort, false);
    }

    /**
     * An array of {@link com.smartgwt.client.data.SortSpecifier} objects used to set up the initial sort configuration for
     * this grid. If specified, this will be used instead of any {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField
     * sortField} specified.
     *
     * @return Current initialSort value. Default value is null
     */
    public SortSpecifier[] getInitialSort()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfSortSpecifier(getAttributeAsJavaScriptObject("initialSort"));
    }
    

    /**
     * If true, if the user clicks on the scroll buttons at the end of the track or clicks once on the scroll track, there will
     * be an instant redraw of the grid content so that the user doesn't see any blank space.  For drag scrolling or other
     * types of scrolling, the {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}
     * applies.
     *
     * @param instantScrollTrackRedraw New instantScrollTrackRedraw value. Default value is true
     */
    public void setInstantScrollTrackRedraw(Boolean instantScrollTrackRedraw) {
        setAttribute("instantScrollTrackRedraw", instantScrollTrackRedraw, true);
    }

    /**
     * If true, if the user clicks on the scroll buttons at the end of the track or clicks once on the scroll track, there will
     * be an instant redraw of the grid content so that the user doesn't see any blank space.  For drag scrolling or other
     * types of scrolling, the {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}
     * applies.
     *
     * @return Current instantScrollTrackRedraw value. Default value is true
     */
    public Boolean getInstantScrollTrackRedraw()  {
        Boolean result = getAttributeAsBoolean("instantScrollTrackRedraw");
        return result == null ? true : result;
    }
    

    /**
     * Value to display to the user if showing summary values (through {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} or {@link
     * com.smartgwt.client.types.ListGridFieldType listGridFieldType:"summary"}), and the summary function returns
     * <code>"null"</code> (implying it was unable to calculate a valid summary value). This property will only be used in the
     * default formatting behavior. If an explicit formatter has been specified - via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter setCellFormatter()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFormatGridSummary formatGridSummary()}, for example - this property
     * has no effect.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param invalidSummaryValue New invalidSummaryValue value. Default value is "&amp;nbsp;"
     */
    public void setInvalidSummaryValue(String invalidSummaryValue) {
        setAttribute("invalidSummaryValue", invalidSummaryValue, true);
    }

    /**
     * Value to display to the user if showing summary values (through {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} or {@link
     * com.smartgwt.client.types.ListGridFieldType listGridFieldType:"summary"}), and the summary function returns
     * <code>"null"</code> (implying it was unable to calculate a valid summary value). This property will only be used in the
     * default formatting behavior. If an explicit formatter has been specified - via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter setCellFormatter()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFormatGridSummary formatGridSummary()}, for example - this property
     * has no effect.
     *
     * @return Current invalidSummaryValue value. Default value is "&amp;nbsp;"
     */
    public String getInvalidSummaryValue()  {
        return getAttributeAsString("invalidSummaryValue");
    }
    

    /**
     * True if this listGrid is grouped, false otherwise
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current isGrouped value. Default value is false
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public boolean getIsGrouped() throws IllegalStateException {
        errorIfNotCreated("isGrouped");
        Boolean result = getAttributeAsBoolean("isGrouped");
        return result == null ? false : result;
    }
    

    /**
     * If <code>record[this.isSeparatorProperty]</code> is set for some record, the record will be displayed as a simple
     * separator row.
     *
     * @param isSeparatorProperty New isSeparatorProperty value. Default value is "isSeparator"
     */
    public void setIsSeparatorProperty(String isSeparatorProperty) {
        setAttribute("isSeparatorProperty", isSeparatorProperty, true);
    }

    /**
     * If <code>record[this.isSeparatorProperty]</code> is set for some record, the record will be displayed as a simple
     * separator row.
     *
     * @return Current isSeparatorProperty value. Default value is "isSeparator"
     */
    public String getIsSeparatorProperty()  {
        return getAttributeAsString("isSeparatorProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, when
     * auto-fitting fields to the title width via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths} or {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth
     * ListGridField.autoFitWidth}, should the button be sized such that there is enough space for the header menu button to
     * show without covering the field title? <P> May be explicitly specified at the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLeaveHeaderMenuButtonSpace field level} or at the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace grid level}. If not explicitly specified space
     * will be left for fields with {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign ListGridField.align} set to
     * <code>"left"</code> or <code>"right"</code>, but not for fields with align set to <code>"center"</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param leaveHeaderMenuButtonSpace New leaveHeaderMenuButtonSpace value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortArrowMenuButtonSpaceOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortNumeralMenuButtonSpaceOffset
     */
    public void setLeaveHeaderMenuButtonSpace(Boolean leaveHeaderMenuButtonSpace) {
        setAttribute("leaveHeaderMenuButtonSpace", leaveHeaderMenuButtonSpace, true);
    }
    

    /**
     * Whether to leave a gap for the vertical scrollbar, even when it's not present. <P> Note that if leaveScrollbarGap is
     * false and vertical scrolling is introduced, fields will be resized to fit the smaller body area if possible, in order to
     * avoid horizontal scrolling also being required.
     *
     * @param leaveScrollbarGap New leaveScrollbarGap value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public void setLeaveScrollbarGap(Boolean leaveScrollbarGap) {
        setAttribute("leaveScrollbarGap", leaveScrollbarGap, true);
    }

    /**
     * Whether to leave a gap for the vertical scrollbar, even when it's not present. <P> Note that if leaveScrollbarGap is
     * false and vertical scrolling is introduced, fields will be resized to fit the smaller body area if possible, in order to
     * avoid horizontal scrolling also being required.
     *
     * @return Current leaveScrollbarGap value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Boolean getLeaveScrollbarGap()  {
        Boolean result = getAttributeAsBoolean("leaveScrollbarGap");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will hold the link text for that record. <P> This property is configurable to avoid
     * possible collision with data values in the record. <P> Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty ListGridField.linkTextProperty} if you have more than
     * one link field and
     *
     * @param linkTextProperty New linkTextProperty value. Default value is "linkText"
     * @see com.smartgwt.client.types.ListGridFieldType
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.widgets.grid.ListGridField#setLinkText
     * @see com.smartgwt.client.widgets.grid.ListGridField#setLinkTextProperty
     */
    public void setLinkTextProperty(String linkTextProperty) {
        setAttribute("linkTextProperty", linkTextProperty, true);
    }

    /**
     * Property name on a record that will hold the link text for that record. <P> This property is configurable to avoid
     * possible collision with data values in the record. <P> Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty ListGridField.linkTextProperty} if you have more than
     * one link field and
     *
     * @return Current linkTextProperty value. Default value is "linkText"
     * @see com.smartgwt.client.types.ListGridFieldType
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.widgets.grid.ListGridField#getLinkText
     * @see com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty
     */
    public String getLinkTextProperty()  {
        return getAttributeAsString("linkTextProperty");
    }
    

    /**
     * If the user is editing the last record in this listGrid, and attempts to navigate beyond the last row either by tabbing
     * off the last editable field, or using the down arrow key, this property determines what action to take:<ul> <li>"next":
     * start editing a new record at the end of the list. <li>"done": hide the editor <li>"stop": leave focus in the cell being
     * edited <li>"none": no action </ul> <P> See the {@link com.smartgwt.client.docs.Editing Grid Editing overview} and also
     * the {@link com.smartgwt.client.docs.UnsavedRecords Editing Unsaved Records overview} for context about how newly added
     * records behave.
     *
     * @param listEndEditAction New listEndEditAction value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_new_row" target="examples">Enter new rows Example</a>
     */
    public void setListEndEditAction(RowEndEditAction listEndEditAction) {
        setAttribute("listEndEditAction", listEndEditAction == null ? null : listEndEditAction.getValue(), true);
    }

    /**
     * If the user is editing the last record in this listGrid, and attempts to navigate beyond the last row either by tabbing
     * off the last editable field, or using the down arrow key, this property determines what action to take:<ul> <li>"next":
     * start editing a new record at the end of the list. <li>"done": hide the editor <li>"stop": leave focus in the cell being
     * edited <li>"none": no action </ul> <P> See the {@link com.smartgwt.client.docs.Editing Grid Editing overview} and also
     * the {@link com.smartgwt.client.docs.UnsavedRecords Editing Unsaved Records overview} for context about how newly added
     * records behave.
     *
     * @return Current listEndEditAction value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_new_row" target="examples">Enter new rows Example</a>
     */
    public RowEndEditAction getListEndEditAction()  {
        return EnumUtil.getEnum(RowEndEditAction.values(), getAttribute("listEndEditAction"));
    }
    

    /**
     * The string to display in the body of a listGrid while data is being loaded. Use <code>"&#36;{loadingImage}"</code> to
     * include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading image}.
     *
     * @param loadingDataMessage New loadingDataMessage value. Default value is "${loadingImage}&amp;nbsp;Loading data..."
     * @see com.smartgwt.client.widgets.grid.ListGrid#setLoadingDataMessageStyle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public void setLoadingDataMessage(String loadingDataMessage) {
        setAttribute("loadingDataMessage", loadingDataMessage, true);
    }

    /**
     * The string to display in the body of a listGrid while data is being loaded. Use <code>"&#36;{loadingImage}"</code> to
     * include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading image}.
     *
     * @return Current loadingDataMessage value. Default value is "${loadingImage}&amp;nbsp;Loading data..."
     * @see com.smartgwt.client.widgets.grid.ListGrid#getLoadingDataMessageStyle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getLoadingDataMessage()  {
        return getAttributeAsString("loadingDataMessage");
    }
    

    /**
     * The CSS style name applied to the loadingDataMessage string if displayed.
     *
     * @param loadingDataMessageStyle New loadingDataMessageStyle value. Default value is "loadingDataMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setLoadingDataMessageStyle(String loadingDataMessageStyle) {
        setAttribute("loadingDataMessageStyle", loadingDataMessageStyle, true);
    }

    /**
     * The CSS style name applied to the loadingDataMessage string if displayed.
     *
     * @return Current loadingDataMessageStyle value. Default value is "loadingDataMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getLoadingDataMessageStyle()  {
        return getAttributeAsString("loadingDataMessageStyle");
    }
    

    /**
     * If you have a databound listGrid and you scroll out of the currently loaded dataset, by default you will see blank rows
     * until the server returns the data for those rows.  The loadingMessage attribute allows you to specify arbitrary html
     * that will be shown in each such "blank" record while the data for that record is loading.
     *
     * @param loadingMessage New loadingMessage value. Default value is "&amp;nbsp;"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setLoadingMessage(String loadingMessage)  throws IllegalStateException {
        setAttribute("loadingMessage", loadingMessage, false);
    }

    /**
     * If you have a databound listGrid and you scroll out of the currently loaded dataset, by default you will see blank rows
     * until the server returns the data for those rows.  The loadingMessage attribute allows you to specify arbitrary html
     * that will be shown in each such "blank" record while the data for that record is loading.
     *
     * @return Current loadingMessage value. Default value is "&amp;nbsp;"
     */
    public String getLoadingMessage()  {
        return getAttributeAsString("loadingMessage");
    }
    

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the column be identified? <br> Note that getLocator() will actually store all available information about the
     * column in the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options
     * area: <ul> <li><code>"fieldName"</code> Attempt to identify by fieldName.</li> <li><code>"index"</code> Attempt to
     * identify by colNum (index in the fields array).</li> </ul> If unset, default behavior is to identify by fieldName (if
     * available), otherwise by index.
     *
     * @param locateColumnsBy New locateColumnsBy value. Default value is null
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public void setLocateColumnsBy(String locateColumnsBy) {
        setAttribute("locateColumnsBy", locateColumnsBy, true);
    }

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the column be identified? <br> Note that getLocator() will actually store all available information about the
     * column in the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options
     * area: <ul> <li><code>"fieldName"</code> Attempt to identify by fieldName.</li> <li><code>"index"</code> Attempt to
     * identify by colNum (index in the fields array).</li> </ul> If unset, default behavior is to identify by fieldName (if
     * available), otherwise by index.
     *
     * @return Current locateColumnsBy value. Default value is null
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public String getLocateColumnsBy()  {
        return getAttributeAsString("locateColumnsBy");
    }
    

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the row be identified? <br> Note that getLocator() will actually store all available information about the row in
     * the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options area: <ul>
     * <li><code>"primaryKey"</code> Only applies to databound grids: If the cell in question has  a primary key cell value,
     * use it to identify cells in autoTest locator strings.</li> <li><code>"titleField"</code> If the cell in question has a
     * value for the  {@link com.smartgwt.client.widgets.grid.ListGrid#getTitleField titleField}, use it to identify cells in
     * autoTest  locator strings</li> <li><code>"targetCellValue"</code> Identify rows by storing the cell value for the target
     * row / field in autoTest locator strings</li> <li><code>"index"</code>The rowNum will be used to identify the row.</li>
     * </ul> If unset, default behavior is to identify by primary key (if available), otherwise by titleField (if available),
     * otherwise by cell value (if available), and lastly by index.
     *
     * @param locateRowsBy New locateRowsBy value. Default value is null
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public void setLocateRowsBy(String locateRowsBy) {
        setAttribute("locateRowsBy", locateRowsBy, true);
    }

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the row be identified? <br> Note that getLocator() will actually store all available information about the row in
     * the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options area: <ul>
     * <li><code>"primaryKey"</code> Only applies to databound grids: If the cell in question has  a primary key cell value,
     * use it to identify cells in autoTest locator strings.</li> <li><code>"titleField"</code> If the cell in question has a
     * value for the  {@link com.smartgwt.client.widgets.grid.ListGrid#getTitleField titleField}, use it to identify cells in
     * autoTest  locator strings</li> <li><code>"targetCellValue"</code> Identify rows by storing the cell value for the target
     * row / field in autoTest locator strings</li> <li><code>"index"</code>The rowNum will be used to identify the row.</li>
     * </ul> If unset, default behavior is to identify by primary key (if available), otherwise by titleField (if available),
     * otherwise by cell value (if available), and lastly by index.
     *
     * @return Current locateRowsBy value. Default value is null
     * @see com.smartgwt.client.types.LocatorStrategy
     */
    public String getLocateRowsBy()  {
        return getAttributeAsString("locateRowsBy");
    }
    

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds this value, the ListGrid shows an edit field of type {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType longTextEditorType} rather than the standard text field
     * when the field enters inline edit mode.
     *
     * @param longTextEditorThreshold New longTextEditorThreshold value. Default value is 255
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setLongTextEditorThreshold(int longTextEditorThreshold) {
        setAttribute("longTextEditorThreshold", longTextEditorThreshold, true);
    }

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds this value, the ListGrid shows an edit field of type {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType longTextEditorType} rather than the standard text field
     * when the field enters inline edit mode.
     *
     * @return Current longTextEditorThreshold value. Default value is 255
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public int getLongTextEditorThreshold()  {
        return getAttributeAsInt("longTextEditorThreshold");
    }
    

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds <code>this.longTextEditorThreshold</code> show an edit field of this type rather than
     * the standard text field when the field enters inline edit mode.
     *
     * @param longTextEditorType New longTextEditorType value. Default value is "PopUpTextAreaItem"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setLongTextEditorType(String longTextEditorType) {
        setAttribute("longTextEditorType", longTextEditorType, true);
    }

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength
     * DataSourceField.length} exceeds <code>this.longTextEditorThreshold</code> show an edit field of this type rather than
     * the standard text field when the field enters inline edit mode.
     *
     * @return Current longTextEditorType value. Default value is "PopUpTextAreaItem"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getLongTextEditorType()  {
        return getAttributeAsString("longTextEditorType");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandMultipleRecords canExpandMultipleRecords} are both true, this
     * property dictates the number of records which can be expanded simultaneously.  If the expanded record count hits the
     * value of this property, further attempts to expand records will result in a popup warning (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecordsPrompt maxExpandedRecordsPrompt}) and expansion will be
     * cancelled. <P> The default value is null, meaning there is no limit on the number of expanded records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param maxExpandedRecords New maxExpandedRecords value. Default value is null
     */
    public void setMaxExpandedRecords(Integer maxExpandedRecords) {
        setAttribute("maxExpandedRecords", maxExpandedRecords, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandMultipleRecords canExpandMultipleRecords} are both true, this
     * property dictates the number of records which can be expanded simultaneously.  If the expanded record count hits the
     * value of this property, further attempts to expand records will result in a popup warning (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecordsPrompt maxExpandedRecordsPrompt}) and expansion will be
     * cancelled. <P> The default value is null, meaning there is no limit on the number of expanded records.
     *
     * @return Current maxExpandedRecords value. Default value is null
     */
    public Integer getMaxExpandedRecords()  {
        return getAttributeAsInt("maxExpandedRecords");
    }
    

    /**
     * This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code when the message is
     * displayed. Note that the local variable <code>count</code> will be available and set to this.maxExpandedRecords. The
     * string will be executed in the scope of the ListGrid so <code>this</code> may also be used to determine other
     * information about this grid. <P> Default value returns <P> <code> <i>This grid is limited to <code>[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecords maxExpandedRecords}]</code> simultaneously expanded
     * records.  Please collapse some expanded records and retry.</i> </code>
     *
     * @param maxExpandedRecordsPrompt New maxExpandedRecordsPrompt value. Default value is "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry."
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public void setMaxExpandedRecordsPrompt(String maxExpandedRecordsPrompt)  throws IllegalStateException {
        setAttribute("maxExpandedRecordsPrompt", maxExpandedRecordsPrompt, false);
    }

    /**
     * This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code when the message is
     * displayed. Note that the local variable <code>count</code> will be available and set to this.maxExpandedRecords. The
     * string will be executed in the scope of the ListGrid so <code>this</code> may also be used to determine other
     * information about this grid. <P> Default value returns <P> <code> <i>This grid is limited to <code>[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecords maxExpandedRecords}]</code> simultaneously expanded
     * records.  Please collapse some expanded records and retry.</i> </code>
     *
     * @return Current maxExpandedRecordsPrompt value. Default value is "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getMaxExpandedRecordsPrompt()  {
        return getAttributeAsString("maxExpandedRecordsPrompt");
    }
    

    /**
     * Minimum size, in pixels, for ListGrid headers.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Updates {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth minFieldWidth} and redraws any columns as needed.
     *
     * @param minFieldWidth New minFieldWidth value. Default value is 15
     */
    public void setMinFieldWidth(int minFieldWidth) {
        setAttribute("minFieldWidth", minFieldWidth, true);
    }

    /**
     * Minimum size, in pixels, for ListGrid headers.
     *
     * @return Current minFieldWidth value. Default value is 15
     */
    public int getMinFieldWidth()  {
        return getAttributeAsInt("minFieldWidth");
    }
    

    /**
     * Minimum height for the entire list (smaller than this doesn't tend to work very well). If not set, this value will be
     * defaulted when {@link com.smartgwt.client.widgets.Canvas#draw draw} is called to something reasonable based on whether
     * we're showing the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary summary rows}, and/or the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowEmptyMessage empty message}. <P> Note that any top or bottom CSS
     * padding specified by {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessageStyle emptyMessageStyle} will be
     * taken into account, increasing <code>minHeight</code> so that the empty message can be shown without overflow.
     *
     * @param minHeight New minHeight value. Default value is varies
     * @see com.smartgwt.client.widgets.Canvas#setMinHeight
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public void setMinHeight(int minHeight) {
        setAttribute("minHeight", minHeight, true);
    }

    /**
     * Minimum height for the entire list (smaller than this doesn't tend to work very well). If not set, this value will be
     * defaulted when {@link com.smartgwt.client.widgets.Canvas#draw draw} is called to something reasonable based on whether
     * we're showing the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeader header}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary summary rows}, and/or the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowEmptyMessage empty message}. <P> Note that any top or bottom CSS
     * padding specified by {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessageStyle emptyMessageStyle} will be
     * taken into account, increasing <code>minHeight</code> so that the empty message can be shown without overflow.
     *
     * @return Current minHeight value. Default value is varies
     * @see com.smartgwt.client.widgets.Canvas#getMinHeight
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public int getMinHeight()  {
        return getAttributeAsInt("minHeight");
    }
    

    /**
     * Minimum height for ListGrid cells, settable by the skin, based on the size of the  checkbox media used for boolean
     * fields plus minimal surrounding padding.   <code>minimumCellHeight</code> is used by {@link
     * com.smartgwt.client.widgets.Canvas#resizeControls Canvas.resizeControls()} to  avoid shrinking ListGrid rows so much
     * that correct display is impossible.   Do not set minimumCellHeight on a per-instance basis - it's only for use in custom
     * skins.
     *
     * @param minimumCellHeight New minimumCellHeight value. Default value is 20
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setMinimumCellHeight(int minimumCellHeight)  throws IllegalStateException {
        setAttribute("minimumCellHeight", minimumCellHeight, false);
    }

    /**
     * Minimum height for ListGrid cells, settable by the skin, based on the size of the  checkbox media used for boolean
     * fields plus minimal surrounding padding.   <code>minimumCellHeight</code> is used by {@link
     * com.smartgwt.client.widgets.Canvas#resizeControls Canvas.resizeControls()} to  avoid shrinking ListGrid rows so much
     * that correct display is impossible.   Do not set minimumCellHeight on a per-instance basis - it's only for use in custom
     * skins.
     *
     * @return Current minimumCellHeight value. Default value is 20
     */
    public int getMinimumCellHeight()  {
        return getAttributeAsInt("minimumCellHeight");
    }
    

    /**
     * If a summary format string contains an invalid field reference, replace the reference with the missingSummaryFieldValue.
     * The default value is "-".
     *
     * @param missingSummaryFieldValue New missingSummaryFieldValue value. Default value is "-"
     */
    public void setMissingSummaryFieldValue(String missingSummaryFieldValue) {
        setAttribute("missingSummaryFieldValue", missingSummaryFieldValue, true);
    }

    /**
     * If a summary format string contains an invalid field reference, replace the reference with the missingSummaryFieldValue.
     * The default value is "-".
     *
     * @return Current missingSummaryFieldValue value. Default value is "-"
     */
    public String getMissingSummaryFieldValue()  {
        return getAttributeAsString("missingSummaryFieldValue");
    }
    

    /**
     * If this property is true, any mouse click outside of the open cell editors      will end editing mode, hiding the cell
     * editors and saving any changes to those      cell values.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param modalEditing New modalEditing value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_modal" target="examples">Modal editing Example</a>
     */
    public void setModalEditing(Boolean modalEditing) {
        setAttribute("modalEditing", modalEditing, true);
    }

    /**
     * If this property is true, any mouse click outside of the open cell editors      will end editing mode, hiding the cell
     * editors and saving any changes to those      cell values.
     *
     * @return Current modalEditing value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_modal" target="examples">Modal editing Example</a>
     */
    public Boolean getModalEditing()  {
        return getAttributeAsBoolean("modalEditing");
    }
    

    /**
     * Class-level defaults to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically 
     * generated when {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @param multiGroupDialogDefaults New multiGroupDialogDefaults value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public void setMultiGroupDialogDefaults(MultiGroupDialog multiGroupDialogDefaults)  throws IllegalStateException {
        if (multiGroupDialogDefaults != null) {
            if (multiGroupDialogDefaults.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setMultiGroupDialogDefaults", "MultiGroupDialog");
            }                                                                       
            multiGroupDialogDefaults.setConfigOnly(true);
        }
        JavaScriptObject config = multiGroupDialogDefaults == null ? null : multiGroupDialogDefaults.getConfig();
        setAttribute("multiGroupDialogDefaults", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Class-level defaults to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically 
     * generated when {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @return Current multiGroupDialogDefaults value. Default value is null
     */
    public MultiGroupDialog getMultiGroupDialogDefaults()  {
        MultiGroupDialog properties = new MultiGroupDialog();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("multiGroupDialogDefaults"));
        return properties;
    }
    

    /**
     * Properties to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically  generated when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @param multiGroupDialogProperties New multiGroupDialogProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public void setMultiGroupDialogProperties(MultiGroupDialog multiGroupDialogProperties)  throws IllegalStateException {
        if (multiGroupDialogProperties != null) {
            if (multiGroupDialogProperties.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(ListGrid.class, "setMultiGroupDialogProperties", "MultiGroupDialog");
            }                                                                       
            multiGroupDialogProperties.setConfigOnly(true);
        }
        JavaScriptObject config = multiGroupDialogProperties == null ? null : multiGroupDialogProperties.getConfig();
        setAttribute("multiGroupDialogProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to the {@link com.smartgwt.client.widgets.MultiGroupDialog} which gets automatically  generated when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#configureGrouping configureGrouping()} is called.
     *
     * @return Current multiGroupDialogProperties value. Default value is null
     */
    public MultiGroupDialog getMultiGroupDialogProperties()  {
        MultiGroupDialog properties = new MultiGroupDialog();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("multiGroupDialogProperties"));
        return properties;
    }
    
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this property allows the
     * user to navigate through the cells of a grid using Tab and Shift+Tab keypresses. When a user tabs to the end of the row,
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine whether
     * to shift selection to the next row, return to the beginning of the same row, or simply move on through the page's tab
     * order.
     *
     * @param navigateOnTab New navigateOnTab value. Default value is true
     */
    public void setNavigateOnTab(boolean navigateOnTab) {
        setAttribute("navigateOnTab", navigateOnTab, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this property allows the
     * user to navigate through the cells of a grid using Tab and Shift+Tab keypresses. When a user tabs to the end of the row,
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine whether
     * to shift selection to the next row, return to the beginning of the same row, or simply move on through the page's tab
     * order.
     *
     * @return Current navigateOnTab value. Default value is true
     */
    public boolean getNavigateOnTab()  {
        Boolean result = getAttributeAsBoolean("navigateOnTab");
        return result == null ? true : result;
    }
    

    /**
     * If true, validation will not occur as a result of cell editing for this grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param neverValidate New neverValidate value. Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public void setNeverValidate(Boolean neverValidate) {
        setAttribute("neverValidate", neverValidate, true);
    }

    /**
     * If true, validation will not occur as a result of cell editing for this grid.
     *
     * @return Current neverValidate value. Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getNeverValidate()  {
        return getAttributeAsBoolean("neverValidate");
    }
    

    /**
     * "Normal" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style if
     * the grid is showing fixed height rows, and the specified cellHeight matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight} (and in Internet Explorer, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is false). Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used. <P> Having separate styles
     * defined for fixed vs. variable height rows allows the developer to specify css which is designed to render at a specific
     * height (typically using background images, which won't scale), without breaking support for styling rows of variable
     * height. <P> See {@link com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined
     * with the base style to generate stateful cell styles.
     *
     * @param normalBaseStyle New normalBaseStyle value. Default value is "cell"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setNormalBaseStyle(String normalBaseStyle)  throws IllegalStateException {
        setAttribute("normalBaseStyle", normalBaseStyle, false);
    }

    /**
     * "Normal" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style if
     * the grid is showing fixed height rows, and the specified cellHeight matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight} (and in Internet Explorer, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is false). Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used. <P> Having separate styles
     * defined for fixed vs. variable height rows allows the developer to specify css which is designed to render at a specific
     * height (typically using background images, which won't scale), without breaking support for styling rows of variable
     * height. <P> See {@link com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are combined
     * with the base style to generate stateful cell styles.
     *
     * @return Current normalBaseStyle value. Default value is "cell"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getNormalBaseStyle()  {
        return getAttributeAsString("normalBaseStyle");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is unset, base style will be derived from
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} if this grid has fixed row heights
     * and the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} matches this value.
     * Otherwise {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param normalCellHeight New normalCellHeight value. Default value is 20
     */
    public void setNormalCellHeight(int normalCellHeight) {
        setAttribute("normalCellHeight", normalCellHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is unset, base style will be derived from
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} if this grid has fixed row heights
     * and the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} matches this value.
     * Otherwise {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used.
     *
     * @return Current normalCellHeight value. Default value is 20
     */
    public int getNormalCellHeight()  {
        return getAttributeAsInt("normalCellHeight");
    }
    

    /**
     * Default alias to use for groups with no value
     *
     * @param nullGroupTitle New nullGroupTitle value. Default value is '-none-'
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setNullGroupTitle(String nullGroupTitle) {
        setAttribute("nullGroupTitle", nullGroupTitle, true);
    }

    /**
     * Default alias to use for groups with no value
     *
     * @return Current nullGroupTitle value. Default value is '-none-'
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public String getNullGroupTitle()  {
        return getAttributeAsString("nullGroupTitle");
    }
    

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.DataBoundComponent#getOfflineMessage
     * offlineMessage} if displayed.
     *
     * @param offlineMessageStyle New offlineMessageStyle value. Default value is "offlineMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setOfflineMessageStyle(String offlineMessageStyle) {
        setAttribute("offlineMessageStyle", offlineMessageStyle, true);
    }

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.DataBoundComponent#getOfflineMessage
     * offlineMessage} if displayed.
     *
     * @return Current offlineMessageStyle value. Default value is "offlineMessage"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getOfflineMessageStyle()  {
        return getAttributeAsString("offlineMessageStyle");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Inline icon shown inside {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter editor} fields when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} is enabled.
     *
     * @return null
     */
    public FormItemIcon getOperatorIcon()  {
        return null;
    }
    
    

    /**
     * Name of a CSS Style to use as the {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for a cell
     * that is currently a selection origin for shifted incremental cell selection. Only has an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true. <P>
     *
     * @param originBaseStyle New originBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setOriginBaseStyle(String originBaseStyle) {
        setAttribute("originBaseStyle", originBaseStyle, true);
    }

    /**
     * Name of a CSS Style to use as the {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for a cell
     * that is currently a selection origin for shifted incremental cell selection. Only has an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true. <P>
     *
     * @return Current originBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getOriginBaseStyle()  {
        return getAttributeAsString("originBaseStyle");
    }
    

    /**
     * Since {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} is configured with overflow: auto by default, no
     * overflow is expected for the {@link com.smartgwt.client.widgets.grid.ListGrid} itself so by default it has overflow:
     * hidden.
     *
     * @param overflow New overflow value. Default value is Canvas.HIDDEN
     * @see com.smartgwt.client.widgets.layout.Layout#setOverflow
     */
    public void setOverflow(Overflow overflow) {
        setAttribute("overflow", overflow == null ? null : overflow.getValue(), true);
    }

    /**
     * Since {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} is configured with overflow: auto by default, no
     * overflow is expected for the {@link com.smartgwt.client.widgets.grid.ListGrid} itself so by default it has overflow:
     * hidden.
     *
     * @return Current overflow value. Default value is Canvas.HIDDEN
     * @see com.smartgwt.client.widgets.layout.Layout#getOverflow
     */
    public Overflow getOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("overflow"));
    }
    

    /**
     * Should recycled {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents record components}, be pooled
     * per column or per record. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <P> When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} is "recycle" and you
     * have components of different types in different columns, set this property to true to ensure that components intended
     * for one column are not recycled for use in another column that should have a different component. <P> If no components
     * applicable to a particular column are available in the pool, the system calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent}.
     *
     * @param poolComponentsPerColumn New poolComponentsPerColumn value. Default value is true
     */
    public void setPoolComponentsPerColumn(Boolean poolComponentsPerColumn) {
        setAttribute("poolComponentsPerColumn", poolComponentsPerColumn, true);
    }

    /**
     * Should recycled {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents record components}, be pooled
     * per column or per record. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <P> When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} is "recycle" and you
     * have components of different types in different columns, set this property to true to ensure that components intended
     * for one column are not recycled for use in another column that should have a different component. <P> If no components
     * applicable to a particular column are available in the pool, the system calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent}.
     *
     * @return Current poolComponentsPerColumn value. Default value is true
     */
    public Boolean getPoolComponentsPerColumn()  {
        Boolean result = getAttributeAsBoolean("poolComponentsPerColumn");
        return result == null ? true : result;
    }
    

    /**
     * Should cells be written out with css that will preserve whitespace? <P> If true, depending on the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, the css generated for cells will use the <a
     * href='https://www.w3.org/wiki/CSS/Properties/white-space#Values' target='_blank'>white-space</a> property values of
     * <code>pre</code> or <code>pre-wrap</code>. This avoids collapsing sequences of whitespace without requiring special
     * <i>&amp;nbsp;</i> characters.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param preserveWhitespace New preserveWhitespace value. Default value is false
     */
    public void setPreserveWhitespace(Boolean preserveWhitespace) {
        setAttribute("preserveWhitespace", preserveWhitespace, true);
    }

    /**
     * Should cells be written out with css that will preserve whitespace? <P> If true, depending on the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, the css generated for cells will use the <a
     * href='https://www.w3.org/wiki/CSS/Properties/white-space#Values' target='_blank'>white-space</a> property values of
     * <code>pre</code> or <code>pre-wrap</code>. This avoids collapsing sequences of whitespace without requiring special
     * <i>&amp;nbsp;</i> characters.
     *
     * @return Current preserveWhitespace value. Default value is false
     */
    public Boolean getPreserveWhitespace()  {
        Boolean result = getAttributeAsBoolean("preserveWhitespace");
        return result == null ? false : result;
    }
    

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link com.smartgwt.client.types.Autofit}, but
     * specific to printed output.
     *
     * @param printAutoFit New printAutoFit value. Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintAutoFit(Boolean printAutoFit) {
        setAttribute("printAutoFit", printAutoFit, true);
    }

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link com.smartgwt.client.types.Autofit}, but
     * specific to printed output.
     *
     * @return Current printAutoFit value. Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public Boolean getPrintAutoFit()  {
        Boolean result = getAttributeAsBoolean("printAutoFit");
        return result == null ? true : result;
    }
    

    /**
     * Style for non-header cells in printed output.  Defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} if null.
     *
     * @param printBaseStyle New printBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBaseStyle(String printBaseStyle) {
        setAttribute("printBaseStyle", printBaseStyle, true);
    }

    /**
     * Style for non-header cells in printed output.  Defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} if null.
     *
     * @return Current printBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBaseStyle()  {
        return getAttributeAsString("printBaseStyle");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} to use when {@link
     * com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanBaseStyle New printBooleanBaseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanBaseStyle(String printBooleanBaseStyle)  throws IllegalStateException {
        setAttribute("printBooleanBaseStyle", printBooleanBaseStyle, false);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} to use when {@link
     * com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printBooleanBaseStyle value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanBaseStyle()  {
        return getAttributeAsString("printBooleanBaseStyle");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintUncheckedImage
     * CheckboxItem.printUncheckedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanFalseImage New printBooleanFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanFalseImage(String printBooleanFalseImage) {
        setAttribute("printBooleanFalseImage", printBooleanFalseImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintUncheckedImage
     * CheckboxItem.printUncheckedImage}.
     *
     * @return Current printBooleanFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanFalseImage()  {
        return getAttributeAsString("printBooleanFalseImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} to use when
     * {@link com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} are unset, this will be set
     * to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintPartialSelectedImage
     * CheckboxItem.printPartialSelectedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanPartialImage New printBooleanPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanPartialImage(String printBooleanPartialImage) {
        setAttribute("printBooleanPartialImage", printBooleanPartialImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} to use when
     * {@link com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage printBooleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} are unset, this will be set
     * to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintPartialSelectedImage
     * CheckboxItem.printPartialSelectedImage}.
     *
     * @return Current printBooleanPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanPartialImage()  {
        return getAttributeAsString("printBooleanPartialImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintCheckedImage
     * CheckboxItem.printCheckedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanTrueImage New printBooleanTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanTrueImage(String printBooleanTrueImage) {
        setAttribute("printBooleanTrueImage", printBooleanTrueImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} to use when {@link
     * com.smartgwt.client.docs.Printing printing}. <p> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage printBooleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage printBooleanPartialImage} are unset, this will be
     * set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPrintCheckedImage
     * CheckboxItem.printCheckedImage}.
     *
     * @return Current printBooleanTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanTrueImage()  {
        return getAttributeAsString("printBooleanTrueImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage checkboxFieldFalseImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldFalseImage New printCheckboxFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintCheckboxFieldFalseImage(String printCheckboxFieldFalseImage) {
        setAttribute("printCheckboxFieldFalseImage", printCheckboxFieldFalseImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage checkboxFieldFalseImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printCheckboxFieldFalseImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldFalseImage()  {
        return getAttributeAsString("printCheckboxFieldFalseImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage checkboxFieldPartialImage} to
     * use when {@link com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldPartialImage New printCheckboxFieldPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintCheckboxFieldPartialImage(String printCheckboxFieldPartialImage) {
        setAttribute("printCheckboxFieldPartialImage", printCheckboxFieldPartialImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage checkboxFieldPartialImage} to
     * use when {@link com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printCheckboxFieldPartialImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldPartialImage()  {
        return getAttributeAsString("printCheckboxFieldPartialImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage checkboxFieldTrueImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldTrueImage New printCheckboxFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintCheckboxFieldTrueImage(String printCheckboxFieldTrueImage) {
        setAttribute("printCheckboxFieldTrueImage", printCheckboxFieldTrueImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage checkboxFieldTrueImage} to use
     * when {@link com.smartgwt.client.docs.Printing printing}.
     *
     * @return Current printCheckboxFieldTrueImage value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldTrueImage()  {
        return getAttributeAsString("printCheckboxFieldTrueImage");
    }
    

    /**
     * Style for header cells in printed output.  Defaults to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle headerBaseStyle} if null.
     *
     * @param printHeaderStyle New printHeaderStyle value. Default value is "printHeader"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintHeaderStyle(String printHeaderStyle) {
        setAttribute("printHeaderStyle", printHeaderStyle, true);
    }

    /**
     * Style for header cells in printed output.  Defaults to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle headerBaseStyle} if null.
     *
     * @return Current printHeaderStyle value. Default value is "printHeader"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintHeaderStyle()  {
        return getAttributeAsString("printHeaderStyle");
    }
    

    /**
     * Advanced property - when generating printHTML for a large ListGrid, rows are printed in batches in order to avoid
     * triggering a native "script is running slowly" browser dialog. <P> For grids with exceptional numbers of columns or
     * complex formatting logic, this number might need to be adjusted downward.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printMaxRows New printMaxRows value. Default value is 100
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintMaxRows(int printMaxRows) {
        setAttribute("printMaxRows", printMaxRows, true);
    }

    /**
     * Advanced property - when generating printHTML for a large ListGrid, rows are printed in batches in order to avoid
     * triggering a native "script is running slowly" browser dialog. <P> For grids with exceptional numbers of columns or
     * complex formatting logic, this number might need to be adjusted downward.
     *
     * @return Current printMaxRows value. Default value is 100
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public int getPrintMaxRows()  {
        return getAttributeAsInt("printMaxRows");
    }
    

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, but specific to printed output.
     *
     * @param printWrapCells New printWrapCells value. Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintWrapCells(Boolean printWrapCells) {
        setAttribute("printWrapCells", printWrapCells, true);
    }

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, but specific to printed output.
     *
     * @return Current printWrapCells value. Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public Boolean getPrintWrapCells()  {
        Boolean result = getAttributeAsBoolean("printWrapCells");
        return result == null ? true : result;
    }
    

    /**
     * Alternative to {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}, to be used when the
     * user is rapidly changing the grids viewport (for example drag scrolling through the grid). If unspecified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} will be used in all cases
     *
     * @param quickDrawAheadRatio New quickDrawAheadRatio value. Default value is 2.0
     */
    public void setQuickDrawAheadRatio(float quickDrawAheadRatio) {
        setAttribute("quickDrawAheadRatio", quickDrawAheadRatio, true);
    }

    /**
     * Alternative to {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}, to be used when the
     * user is rapidly changing the grids viewport (for example drag scrolling through the grid). If unspecified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} will be used in all cases
     *
     * @return Current quickDrawAheadRatio value. Default value is 2.0
     */
    public float getQuickDrawAheadRatio()  {
        return getAttributeAsFloat("quickDrawAheadRatio");
    }
    

    /**
     * This attribute allows custom base styles to be displayed on a per-record basis. To specify a custom base-style for some
     * record set <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name - for example if
     * <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set <code>record._baseStyle</code> to the custom base
     * style name.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordBaseStyleProperty New recordBaseStyleProperty value. Default value is "_baseStyle"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setRecordBaseStyleProperty(String recordBaseStyleProperty) {
        setAttribute("recordBaseStyleProperty", recordBaseStyleProperty, true);
    }

    /**
     * This attribute allows custom base styles to be displayed on a per-record basis. To specify a custom base-style for some
     * record set <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name - for example if
     * <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set <code>record._baseStyle</code> to the custom base
     * style name.
     *
     * @return Current recordBaseStyleProperty value. Default value is "_baseStyle"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRecordBaseStyleProperty()  {
        return getAttributeAsString("recordBaseStyleProperty");
    }
    

    /**
     * If set to false on a record and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * is true, removal of that record is disallowed in the UI. The icon in the remove field is not shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCanRemoveProperty New recordCanRemoveProperty value. Default value is "_canRemove"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setRecordCanRemoveProperty(String recordCanRemoveProperty)  throws IllegalStateException {
        setAttribute("recordCanRemoveProperty", recordCanRemoveProperty, false);
    }

    /**
     * If set to false on a record and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * is true, removal of that record is disallowed in the UI. The icon in the remove field is not shown.
     *
     * @return Current recordCanRemoveProperty value. Default value is "_canRemove"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getRecordCanRemoveProperty()  {
        return getAttributeAsString("recordCanRemoveProperty");
    }
    

    /**
     * If set to false on a record, selection of that record is disallowed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCanSelectProperty New recordCanSelectProperty value. Default value is "canSelect"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRecordCanSelectProperty(String recordCanSelectProperty)  throws IllegalStateException {
        setAttribute("recordCanSelectProperty", recordCanSelectProperty, false);
    }

    /**
     * If set to false on a record, selection of that record is disallowed.
     *
     * @return Current recordCanSelectProperty value. Default value is "canSelect"
     */
    public String getRecordCanSelectProperty()  {
        return getAttributeAsString("recordCanSelectProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this
     * attribute may be used to specify a standard height for record components. If specified every row in the grid will be
     * sized tall enough to accommodate a recordComponent of this size. <P> Note that if this property is unset, the grid will
     * not be able to know row heights in advance, and {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * fields} are not currently supported in this case.  If you are putting a recordComponent in every row, and they all have
     * a consistent height, set <code>recordComponentHeight</code> and you will then be able to use frozen fields <i>and</i>
     * avoid the whitespace side-effect of virtual scrolling by setting  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false. <P> Similarly, if your
     * recordComponents are never tall enough that they will expand the row beyond the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false to avoid the whitespace
     * side-effect of {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtual scrolling} and to allow 
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields} to be used.  In this mode, you can have
     * recordComponents on some rows but not others, and recordComponents of different heights, so long as no recordComponent
     * ever causes a row to grow beyond {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} (which would
     * happen if the recordComponents height + 2*{@link com.smartgwt.client.widgets.grid.ListGrid#getCellPadding cellPadding}
     * is larger than  {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}).
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordComponentHeight recordComponent height. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setVirtualScrolling
     */
    public void setRecordComponentHeight(Integer recordComponentHeight) {
        setAttribute("recordComponentHeight", recordComponentHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this
     * attribute may be used to specify a standard height for record components. If specified every row in the grid will be
     * sized tall enough to accommodate a recordComponent of this size. <P> Note that if this property is unset, the grid will
     * not be able to know row heights in advance, and {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * fields} are not currently supported in this case.  If you are putting a recordComponent in every row, and they all have
     * a consistent height, set <code>recordComponentHeight</code> and you will then be able to use frozen fields <i>and</i>
     * avoid the whitespace side-effect of virtual scrolling by setting  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false. <P> Similarly, if your
     * recordComponents are never tall enough that they will expand the row beyond the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false to avoid the whitespace
     * side-effect of {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtual scrolling} and to allow 
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields} to be used.  In this mode, you can have
     * recordComponents on some rows but not others, and recordComponents of different heights, so long as no recordComponent
     * ever causes a row to grow beyond {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} (which would
     * happen if the recordComponents height + 2*{@link com.smartgwt.client.widgets.grid.ListGrid#getCellPadding cellPadding}
     * is larger than  {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}).
     *
     * @return Current recordComponentHeight value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling
     */
    public Integer getRecordComponentHeight()  {
        return getAttributeAsInt("recordComponentHeight");
    }
    

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents}. <P> The default mode is "viewport",
     * which means that recordComponents are destroyed as soon their record is no longer being rendered (scrolled out of the
     * viewport, eliminated by search criteria, etc). <P> For a large or dynamic data set where the components shown on
     * different rows are similar, switch to "recycle" mode, which pools recordComponents by detaching them from records that
     * are not visible and re-using them in other records.  In this mode, you should implement {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent updateRecordComponent()} to apply any changes to make
     * reused components applicable to the new record they appear in, if necessary.  For example, if you have several controls
     * in your <code>recordComponents</code>, and not all of the controls apply to every record, your
     * <code>updateRecordComponent()</code> implementation could simply hide or disable inapplicable controls, and this would
     * be much faster than creating a whole new set of controls every time a given record is scrolled into view. <p> If you are
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell per-cell recordComponents}, and you
     * have components of different types in different columns and still want to take advantage of component recycling, you can
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getPoolComponentsPerColumn poolComponentsPerColumn} to ensure that
     * components intended for one column are not recycled for use in another column that should have a different component.
     * <P> Note that, if different records have distinctly different components embedded in them, or multiple columns in each
     * record embed different components, you should leave the recordComponentPoolingMode at "viewport" if your dataset is very
     * large or use "data" otherwise.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordComponentPoolingMode New recordComponentPoolingMode value. Default value is "viewport"
     */
    public void setRecordComponentPoolingMode(RecordComponentPoolingMode recordComponentPoolingMode) {
        setAttribute("recordComponentPoolingMode", recordComponentPoolingMode == null ? null : recordComponentPoolingMode.getValue(), true);
    }

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents}. <P> The default mode is "viewport",
     * which means that recordComponents are destroyed as soon their record is no longer being rendered (scrolled out of the
     * viewport, eliminated by search criteria, etc). <P> For a large or dynamic data set where the components shown on
     * different rows are similar, switch to "recycle" mode, which pools recordComponents by detaching them from records that
     * are not visible and re-using them in other records.  In this mode, you should implement {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent updateRecordComponent()} to apply any changes to make
     * reused components applicable to the new record they appear in, if necessary.  For example, if you have several controls
     * in your <code>recordComponents</code>, and not all of the controls apply to every record, your
     * <code>updateRecordComponent()</code> implementation could simply hide or disable inapplicable controls, and this would
     * be much faster than creating a whole new set of controls every time a given record is scrolled into view. <p> If you are
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell per-cell recordComponents}, and you
     * have components of different types in different columns and still want to take advantage of component recycling, you can
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getPoolComponentsPerColumn poolComponentsPerColumn} to ensure that
     * components intended for one column are not recycled for use in another column that should have a different component.
     * <P> Note that, if different records have distinctly different components embedded in them, or multiple columns in each
     * record embed different components, you should leave the recordComponentPoolingMode at "viewport" if your dataset is very
     * large or use "data" otherwise.
     *
     * @return Current recordComponentPoolingMode value. Default value is "viewport"
     */
    public RecordComponentPoolingMode getRecordComponentPoolingMode()  {
        return EnumUtil.getEnum(RecordComponentPoolingMode.values(), getAttribute("recordComponentPoolingMode"));
    }
    

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, how should
     * the component appear within the cell. Valid options are <ul><li><code>"within"</code>: the component will be rendered
     * inside the record / cell.  {@link com.smartgwt.client.widgets.Canvas#getSnapTo Canvas.snapTo} may be set to specify
     * where the component should render within  the row or cell, and {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetTop Canvas.snapOffsetTop} / {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft Canvas.snapOffsetLeft} may  be set to indent recordComponents
     * within their parent cells.  Note that if unset, the component will show up at the top/left edge  for components embedded
     * within an entire row, or for per-cell components, cell  align and valign will be respected.  Note also that, when
     * rendering components "within"  cells, specified component heights will be respected and will change the height of the 
     * row.  However, if you want components to completely fill a cell at it's default height,  set height: "100%" or rows will
     * render at the default height of the component. </li> <li><code>"expand"</code>: the component will be written into the
     * cell below the  normal cell content, causing the cell to expand vertically to accommodate it. <li><code>null</code>: If
     * this attribute is unset, we will default to showing  recordComponents with position <code>"within"</code> if  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} is true, otherwise
     * using <code>"expand"</code>  logic. </ul>
     *
     * @param recordComponentPosition New recordComponentPosition value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRecordComponents
     */
    public void setRecordComponentPosition(EmbeddedPosition recordComponentPosition) {
        setAttribute("recordComponentPosition", recordComponentPosition == null ? null : recordComponentPosition.getValue(), true);
    }

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, how should
     * the component appear within the cell. Valid options are <ul><li><code>"within"</code>: the component will be rendered
     * inside the record / cell.  {@link com.smartgwt.client.widgets.Canvas#getSnapTo Canvas.snapTo} may be set to specify
     * where the component should render within  the row or cell, and {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetTop Canvas.snapOffsetTop} / {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft Canvas.snapOffsetLeft} may  be set to indent recordComponents
     * within their parent cells.  Note that if unset, the component will show up at the top/left edge  for components embedded
     * within an entire row, or for per-cell components, cell  align and valign will be respected.  Note also that, when
     * rendering components "within"  cells, specified component heights will be respected and will change the height of the 
     * row.  However, if you want components to completely fill a cell at it's default height,  set height: "100%" or rows will
     * render at the default height of the component. </li> <li><code>"expand"</code>: the component will be written into the
     * cell below the  normal cell content, causing the cell to expand vertically to accommodate it. <li><code>null</code>: If
     * this attribute is unset, we will default to showing  recordComponents with position <code>"within"</code> if  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} is true, otherwise
     * using <code>"expand"</code>  logic. </ul>
     *
     * @return Current recordComponentPosition value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents
     */
    public EmbeddedPosition getRecordComponentPosition()  {
        return EnumUtil.getEnum(EmbeddedPosition.values(), getAttribute("recordComponentPosition"));
    }
    
    

    /**
     * The name of the ListGridRecord property that specifies the DataSource to use when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is "related".  The default is {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS ListGridRecord.detailDS}. Note that you can set the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} at the grid level instead if the same dataSource is to
     * be used for all records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordDetailDSProperty New recordDetailDSProperty value. Default value is "detailDS"
     */
    public void setRecordDetailDSProperty(String recordDetailDSProperty) {
        setAttribute("recordDetailDSProperty", recordDetailDSProperty, true);
    }

    /**
     * The name of the ListGridRecord property that specifies the DataSource to use when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is "related".  The default is {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS ListGridRecord.detailDS}. Note that you can set the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} at the grid level instead if the same dataSource is to
     * be used for all records.
     *
     * @return Current recordDetailDSProperty value. Default value is "detailDS"
     */
    public String getRecordDetailDSProperty()  {
        return getAttributeAsString("recordDetailDSProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAcceptDroppedRecords canAcceptDroppedRecords} is true for this
     * listGrid, this property governs whether the user can drop between, or over records within the grid. This controls what
     * {@link com.smartgwt.client.types.RecordDropPosition} is passed to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordDrop recordDrop()} event handler.
     *
     * @param recordDropAppearance New recordDropAppearance value. Default value is ListGrid.BETWEEN
     */
    public void setRecordDropAppearance(RecordDropAppearance recordDropAppearance) {
        setAttribute("recordDropAppearance", recordDropAppearance == null ? null : recordDropAppearance.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAcceptDroppedRecords canAcceptDroppedRecords} is true for this
     * listGrid, this property governs whether the user can drop between, or over records within the grid. This controls what
     * {@link com.smartgwt.client.types.RecordDropPosition} is passed to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordDrop recordDrop()} event handler.
     *
     * @return Current recordDropAppearance value. Default value is ListGrid.BETWEEN
     */
    public RecordDropAppearance getRecordDropAppearance()  {
        return EnumUtil.getEnum(RecordDropAppearance.values(), getAttribute("recordDropAppearance"));
    }
    

    /**
     * Property name on a record that should be checked to determine whether the record may be edited. <br> This property is
     * configurable to avoid possible collision with data values in record. With the default setting of "_canEdit", a record
     * can be set non-editable by ensuring record._canEdit == false. <br> For controlling editability for the entire grid or
     * for a field, set grid.canEdit or field.canEdit.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordEditProperty New recordEditProperty value. Default value is "_canEdit"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setRecordEditProperty(String recordEditProperty) {
        setAttribute("recordEditProperty", recordEditProperty, true);
    }

    /**
     * Property name on a record that should be checked to determine whether the record may be edited. <br> This property is
     * configurable to avoid possible collision with data values in record. With the default setting of "_canEdit", a record
     * can be set non-editable by ensuring record._canEdit == false. <br> For controlling editability for the entire grid or
     * for a field, set grid.canEdit or field.canEdit.
     *
     * @return Current recordEditProperty value. Default value is "_canEdit"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getRecordEditProperty()  {
        return getAttributeAsString("recordEditProperty");
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record is enabled. <P> Setting this property on a
     * record will effect the visual style and interactivity of the record.  If set to <code>false</code> the record (row in a
     * {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid}) will not
     * highlight when the mouse moves over it, nor will it respond to mouse clicks.
     *
     * @param recordEnabledProperty New recordEnabledProperty value. Default value is "enabled"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setEnabled
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_disabled_rows" target="examples">Disabled rows Example</a>
     */
    public void setRecordEnabledProperty(String recordEnabledProperty)  throws IllegalStateException {
        setAttribute("recordEnabledProperty", recordEnabledProperty, false);
    }

    /**
     * Property name on a record that will be checked to determine whether a record is enabled. <P> Setting this property on a
     * record will effect the visual style and interactivity of the record.  If set to <code>false</code> the record (row in a
     * {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid}) will not
     * highlight when the mouse moves over it, nor will it respond to mouse clicks.
     *
     * @return Current recordEnabledProperty value. Default value is "enabled"
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getEnabled
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_disabled_rows" target="examples">Disabled rows Example</a>
     */
    public String getRecordEnabledProperty()  {
        return getAttributeAsString("recordEnabledProperty");
    }
    

    /**
     * If showing any record summary fields (IE: fields of {@link com.smartgwt.client.types.ListGridFieldType type:"summary"}),
     * this attribute specifies a custom base style to apply to cells in the summary field
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordSummaryBaseStyle New recordSummaryBaseStyle value. Default value is "recordSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setRecordSummaryBaseStyle(String recordSummaryBaseStyle) {
        setAttribute("recordSummaryBaseStyle", recordSummaryBaseStyle, true);
    }

    /**
     * If showing any record summary fields (IE: fields of {@link com.smartgwt.client.types.ListGridFieldType type:"summary"}),
     * this attribute specifies a custom base style to apply to cells in the summary field
     *
     * @return Current recordSummaryBaseStyle value. Default value is "recordSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getRecordSummaryBaseStyle()  {
        return getAttributeAsString("recordSummaryBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to records that have been {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked for removal}. <P> This CSS text will be applied on
     * top of standard disabled styling for the cell.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param removedCSSText New removedCSSText value. Default value is "text-decoration:line-through;"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setRemovedCSSText(String removedCSSText) {
        setAttribute("removedCSSText", removedCSSText, true);
    }

    /**
     * Custom CSS text to be applied to records that have been {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked for removal}. <P> This CSS text will be applied on
     * top of standard disabled styling for the cell.
     *
     * @return Current removedCSSText value. Default value is "text-decoration:line-through;"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRemovedCSSText()  {
        return getAttributeAsString("removedCSSText");
    }
    
    

    /**
     * Configuration properties for the "remove field" displayed when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled.
     *
     * @param removeFieldProperties New removeFieldProperties value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRemoveFieldProperties(ListGridField removeFieldProperties)  throws IllegalStateException {
        JavaScriptObject config = JSOHelper.createObject();
        if (removeFieldProperties != null) {
            JSOHelper.addProperties(config, removeFieldProperties.getJsObj());
        }
        setAttribute("removeFieldProperties", removeFieldProperties == null ? null : config, false);
    }

    /**
     * Configuration properties for the "remove field" displayed when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled.
     *
     * @return Current removeFieldProperties value. Default value is null
     */
    public ListGridField getRemoveFieldProperties()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("removeFieldProperties"));
    }
    

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults remove field}. <P> By
     * default this title is not displayed in the remove column header button as the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults removeFieldDefaults} sets {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle ListGridField.showTitle} to <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param removeFieldTitle New removeFieldTitle value. Default value is "&amp;nbsp;"
     */
    public void setRemoveFieldTitle(String removeFieldTitle) {
        setAttribute("removeFieldTitle", removeFieldTitle, true);
    }

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults remove field}. <P> By
     * default this title is not displayed in the remove column header button as the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults removeFieldDefaults} sets {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle ListGridField.showTitle} to <code>false</code>.
     *
     * @return Current removeFieldTitle value. Default value is "&amp;nbsp;"
     */
    public String getRemoveFieldTitle()  {
        return getAttributeAsString("removeFieldTitle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, default icon to
     * show in the auto-generated field that allows removing records.
     *
     * @param removeIcon New removeIcon value. Default value is "[SKIN]/actions/remove.png"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setRemoveIcon(String removeIcon)  throws IllegalStateException {
        setAttribute("removeIcon", removeIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, default icon to
     * show in the auto-generated field that allows removing records.
     *
     * @return Current removeIcon value. Default value is "[SKIN]/actions/remove.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getRemoveIcon()  {
        return getAttributeAsString("removeIcon");
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon remove icons} for this
     * ListGrid.
     *
     * @param removeIconSize New removeIconSize value. Default value is 16
     */
    public void setRemoveIconSize(int removeIconSize) {
        setAttribute("removeIconSize", removeIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon remove icons} for this
     * ListGrid.
     *
     * @return Current removeIconSize value. Default value is 16
     */
    public int getRemoveIconSize()  {
        return getAttributeAsInt("removeIconSize");
    }
    

    /**
     * If true, when an update operation occurs on a selected record in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound} listGrid, ensure the updated record is re-selected
     * when the operation completes. The {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdateNotifications
     * reselectOnUpdateNotifications} attributes governs whether {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionUpdatedHandler ListGrid.selectionUpdated()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionChangedHandler ListGrid.selectionChanged()} will fire when this
     * occurs.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reselectOnUpdate New reselectOnUpdate value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setReselectOnUpdate(boolean reselectOnUpdate)  throws IllegalStateException {
        setAttribute("reselectOnUpdate", reselectOnUpdate, false);
    }

    /**
     * If true, when an update operation occurs on a selected record in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound} listGrid, ensure the updated record is re-selected
     * when the operation completes. The {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdateNotifications
     * reselectOnUpdateNotifications} attributes governs whether {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionUpdatedHandler ListGrid.selectionUpdated()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionChangedHandler ListGrid.selectionChanged()} will fire when this
     * occurs.
     *
     * @return Current reselectOnUpdate value. Default value is true
     */
    public boolean getReselectOnUpdate()  {
        Boolean result = getAttributeAsBoolean("reselectOnUpdate");
        return result == null ? true : result;
    }
    

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdate reselectOnUpdate} is true, this property governs
     * what selection changed notifications should be triggered when a selected record is edited then automatically reselected
     * when the edited data is merged into the data set.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reselectOnUpdateNotifications New reselectOnUpdateNotifications value. Default value is "selectionChanged"
     */
    public void setReselectOnUpdateNotifications(SelectionNotificationType reselectOnUpdateNotifications) {
        setAttribute("reselectOnUpdateNotifications", reselectOnUpdateNotifications == null ? null : reselectOnUpdateNotifications.getValue(), true);
    }

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdate reselectOnUpdate} is true, this property governs
     * what selection changed notifications should be triggered when a selected record is edited then automatically reselected
     * when the edited data is merged into the data set.
     *
     * @return Current reselectOnUpdateNotifications value. Default value is "selectionChanged"
     */
    public SelectionNotificationType getReselectOnUpdateNotifications()  {
        return EnumUtil.getEnum(SelectionNotificationType.values(), getAttribute("reselectOnUpdateNotifications"));
    }
    

    /**
     * If <code>true</code>, the grid contents are redrawn in real time as fields are resized. This can be slow with a large
     * grid and/or on some platforms. By default, this is enabled in modern desktop browsers. This is automatically switched
     * off in mobile browsers.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param resizeFieldsInRealTime New resizeFieldsInRealTime value. Default value is see below
     */
    public void setResizeFieldsInRealTime(boolean resizeFieldsInRealTime) {
        setAttribute("resizeFieldsInRealTime", resizeFieldsInRealTime, true);
    }

    /**
     * If <code>true</code>, the grid contents are redrawn in real time as fields are resized. This can be slow with a large
     * grid and/or on some platforms. By default, this is enabled in modern desktop browsers. This is automatically switched
     * off in mobile browsers.
     *
     * @return Current resizeFieldsInRealTime value. Default value is see below
     */
    public boolean getResizeFieldsInRealTime()  {
        Boolean result = getAttributeAsBoolean("resizeFieldsInRealTime");
        return result == null ? false : result;
    }
    

    /**
     * If a page is rendered in {@link com.smartgwt.client.util.Page#isRTL RTL mode}, should cell alignments specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign ListGridField.cellAlign} be reversed (so an
     * <code>align:"right"</code> field will have content aligned on the left and vice versa)? <P> This is true by default to
     * match user expectation that text flows from start-to end and is aligned with the start of text flow (left in LTR mode,
     * right in RTL mode) by default. May be set to false to have the specified alignments be taken literally in RTL mode.
     *
     * @param reverseRTLAlign New reverseRTLAlign value. Default value is true
     */
    public void setReverseRTLAlign(Boolean reverseRTLAlign) {
        setAttribute("reverseRTLAlign", reverseRTLAlign, true);
    }

    /**
     * If a page is rendered in {@link com.smartgwt.client.util.Page#isRTL RTL mode}, should cell alignments specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign ListGridField.cellAlign} be reversed (so an
     * <code>align:"right"</code> field will have content aligned on the left and vice versa)? <P> This is true by default to
     * match user expectation that text flows from start-to end and is aligned with the start of text flow (left in LTR mode,
     * right in RTL mode) by default. May be set to false to have the specified alignments be taken literally in RTL mode.
     *
     * @return Current reverseRTLAlign value. Default value is true
     */
    public Boolean getReverseRTLAlign()  {
        Boolean result = getAttributeAsBoolean("reverseRTLAlign");
        return result == null ? true : result;
    }
    
    
    

    /**
     * If the user is editing a record in this listGrid, and attempts to navigate to a field beyond the end of the row, via tab
     * (or shift-tab off the first editable field), this property determines what action to take:<ul> <li>"next": start editing
     * the next (or previous) record in the list <li>"same": put focus back into the first editable field of the same record.
     * <li>"done": hide the editor <li>"stop": leave focus in the cell being edited <li>"none": no action </ul>
     *
     * @param rowEndEditAction New rowEndEditAction value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setRowEndEditAction(RowEndEditAction rowEndEditAction) {
        setAttribute("rowEndEditAction", rowEndEditAction == null ? null : rowEndEditAction.getValue(), true);
    }

    /**
     * If the user is editing a record in this listGrid, and attempts to navigate to a field beyond the end of the row, via tab
     * (or shift-tab off the first editable field), this property determines what action to take:<ul> <li>"next": start editing
     * the next (or previous) record in the list <li>"same": put focus back into the first editable field of the same record.
     * <li>"done": hide the editor <li>"stop": leave focus in the cell being edited <li>"none": no action </ul>
     *
     * @return Current rowEndEditAction value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public RowEndEditAction getRowEndEditAction()  {
        return EnumUtil.getEnum(RowEndEditAction.values(), getAttribute("rowEndEditAction"));
    }
    

    /**
     * An automatically generated field that displays the current row number when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true.
     * <p>
     * This component is an AutoChild named "rowNumberField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current rowNumberField value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getRowNumberField() throws IllegalStateException {
        errorIfNotCreated("rowNumberField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("rowNumberField"));
    }
    

    /**
     * The number to start the row-count from - default value is 1.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowNumberStart New rowNumberStart value. Default value is 1
     */
    public void setRowNumberStart(int rowNumberStart) {
        setAttribute("rowNumberStart", rowNumberStart, true);
    }

    /**
     * The number to start the row-count from - default value is 1.
     *
     * @return Current rowNumberStart value. Default value is 1
     */
    public int getRowNumberStart()  {
        return getAttributeAsInt("rowNumberStart");
    }
    

    /**
     * The CSS Style name for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowNumberStyle New rowNumberStyle value. Default value is "specialCol"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setRowNumberStyle(String rowNumberStyle) {
        setAttribute("rowNumberStyle", rowNumberStyle, true);
    }

    /**
     * The CSS Style name for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}.
     *
     * @return Current rowNumberStyle value. Default value is "specialCol"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getRowNumberStyle()  {
        return getAttributeAsString("rowNumberStyle");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning allowRowSpanning} is enabled, this property may
     * be used to specify editing behavior for cells that span multiple rows.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowSpanEditMode New rowSpanEditMode value. Default value is "first"
     */
    public void setRowSpanEditMode(RowSpanEditMode rowSpanEditMode) {
        setAttribute("rowSpanEditMode", rowSpanEditMode == null ? null : rowSpanEditMode.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning allowRowSpanning} is enabled, this property may
     * be used to specify editing behavior for cells that span multiple rows.
     *
     * @return Current rowSpanEditMode value. Default value is "first"
     */
    public RowSpanEditMode getRowSpanEditMode()  {
        return EnumUtil.getEnum(RowSpanEditMode.values(), getAttribute("rowSpanEditMode"));
    }
    

    /**
     * Chooses the selection mode when {@link com.smartgwt.client.widgets.grid.ListGrid#getUseRowSpanStyling useRowSpanStyling}
     * is enabled.  See {@link com.smartgwt.client.types.RowSpanSelectionMode}.
     *
     * @param rowSpanSelectionMode New rowSpanSelectionMode value. Default value is "forward"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRowSpanSelectionMode(RowSpanSelectionMode rowSpanSelectionMode)  throws IllegalStateException {
        setAttribute("rowSpanSelectionMode", rowSpanSelectionMode == null ? null : rowSpanSelectionMode.getValue(), false);
    }

    /**
     * Chooses the selection mode when {@link com.smartgwt.client.widgets.grid.ListGrid#getUseRowSpanStyling useRowSpanStyling}
     * is enabled.  See {@link com.smartgwt.client.types.RowSpanSelectionMode}.
     *
     * @return Current rowSpanSelectionMode value. Default value is "forward"
     */
    public RowSpanSelectionMode getRowSpanSelectionMode()  {
        return EnumUtil.getEnum(RowSpanSelectionMode.values(), getAttribute("rowSpanSelectionMode"));
    }
    

    /**
     * Whether edits should be saved whenever the user moves between cells in the current edit row. <P> If unset, defaults to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell this.editByCell}. <P> To avoid automatic saving entirely,
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}:false.
     *
     * @param saveByCell New saveByCell value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditByCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setSaveByCell(Boolean saveByCell) {
        setAttribute("saveByCell", saveByCell, true);
    }

    /**
     * Whether edits should be saved whenever the user moves between cells in the current edit row. <P> If unset, defaults to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell this.editByCell}. <P> To avoid automatic saving entirely,
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}:false.
     *
     * @return Current saveByCell value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getSaveByCell()  {
        return getAttributeAsBoolean("saveByCell");
    }
    

    /**
     * For grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, this property can
     * be set to <code>true</code> to cause the grid directly update its local data set instead of performing an operation
     * against it's configured DataSource. <p> When using this mode, data must be provided to the grid via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as   a RecordList.  Setting
     * <code>saveLocally</code> is invalid if either {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is
     * called or if a {@link com.smartgwt.client.data.ResultSet} is provided as the data model. <p> <code>saveLocally</code>
     * mode includes changes made via  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit inline editing}, record
     * removal via {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}, as well as
     * programmatic calls to {@link com.smartgwt.client.widgets.grid.ListGrid#updateData updateData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData addData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData removeData()}.  This also causes saves to be performed
     * synchronously (unlike normal DataSource operations). <p> Note that using this mode also disables the automatic cache
     * synchronization provided by the DataSource system - changes made to this grid are saved only to this grid's data set.
     * <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} to allow filtering,
     * such as filtering performed by the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor}, to
     * also work only with the local data set. <P> If saveLocally is unset, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} is true, the saveLocally behavior is
     * enabled by default
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param saveLocally New saveLocally value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setUseRemoteValidators
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setSaveLocally(Boolean saveLocally)  throws IllegalStateException {
        setAttribute("saveLocally", saveLocally, false);
    }

    /**
     * For grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, this property can
     * be set to <code>true</code> to cause the grid directly update its local data set instead of performing an operation
     * against it's configured DataSource. <p> When using this mode, data must be provided to the grid via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData setData()}, and must be provided as   a RecordList.  Setting
     * <code>saveLocally</code> is invalid if either {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is
     * called or if a {@link com.smartgwt.client.data.ResultSet} is provided as the data model. <p> <code>saveLocally</code>
     * mode includes changes made via  {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit inline editing}, record
     * removal via {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}, as well as
     * programmatic calls to {@link com.smartgwt.client.widgets.grid.ListGrid#updateData updateData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData addData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData removeData()}.  This also causes saves to be performed
     * synchronously (unlike normal DataSource operations). <p> Note that using this mode also disables the automatic cache
     * synchronization provided by the DataSource system - changes made to this grid are saved only to this grid's data set.
     * <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} to allow filtering,
     * such as filtering performed by the {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor}, to
     * also work only with the local data set. <P> If saveLocally is unset, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData filterLocalData} is true, the saveLocally behavior is
     * enabled by default
     *
     * @return Current saveLocally value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getUseRemoteValidators
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getSaveLocally()  {
        return getAttributeAsBoolean("saveLocally");
    }
    

    /**
     * For editable grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, where
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is false, this attribute may be used to
     * specify standard DSRequest properties to apply to all save operations performed by this grid (whether triggered by user
     * interaction, or explicit saveEdits or saveAllEdits call). <P> An example usage would be to customize the prompt
     * displayed while saving is in progress if {@link com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave waitForSave} is
     * true. <P> Note that for more advanced customization of save operations, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddOperation DataBoundComponent.addOperation} and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation DataBoundComponent.updateOperation} are available to
     * developers, allowing specification of an explicit {@link com.smartgwt.client.data.OperationBinding} for the add / update
     * operation performed on save.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param saveRequestProperties New saveRequestProperties value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setSaveRequestProperties(DSRequest saveRequestProperties) {
        JavaScriptObject config = JSOHelper.createObject();
        if (saveRequestProperties != null) {
            JSOHelper.addProperties(config, saveRequestProperties.getJsObj());
        }
        setAttribute("saveRequestProperties", saveRequestProperties == null ? null : config, true);
    }

    /**
     * For editable grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, where
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is false, this attribute may be used to
     * specify standard DSRequest properties to apply to all save operations performed by this grid (whether triggered by user
     * interaction, or explicit saveEdits or saveAllEdits call). <P> An example usage would be to customize the prompt
     * displayed while saving is in progress if {@link com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave waitForSave} is
     * true. <P> Note that for more advanced customization of save operations, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddOperation DataBoundComponent.addOperation} and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation DataBoundComponent.updateOperation} are available to
     * developers, allowing specification of an explicit {@link com.smartgwt.client.data.OperationBinding} for the add / update
     * operation performed on save.
     *
     * @return Current saveRequestProperties value. Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public DSRequest getSaveRequestProperties()  {
        return new DSRequest(getAttributeAsJavaScriptObject("saveRequestProperties"));
    }
    

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible separator
     * string is written out between each cell value. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the different cell values as the contents of a row are read aloud. The {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator screenReaderRowSeparator} string if any will be
     * written out after the last cell in a row to separate the last cell's value from the screen reader's announcement of the
     * row's number and total number of rows in the grid (such as "3 of 20"). <P> This attribute may be set to null to disable
     * the feature. <P> Note that screen readers vary widely on which punctuation symbols are read aloud, and sometimes it
     * depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and VoiceOver screen readers all read
     * the forward slash '/' as "slash". See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderCellSeparator New screenReaderCellSeparator value. Default value is "/"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public void setScreenReaderCellSeparator(String screenReaderCellSeparator)  throws IllegalStateException {
        setAttribute("screenReaderCellSeparator", screenReaderCellSeparator, false);
    }

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible separator
     * string is written out between each cell value. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the different cell values as the contents of a row are read aloud. The {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator screenReaderRowSeparator} string if any will be
     * written out after the last cell in a row to separate the last cell's value from the screen reader's announcement of the
     * row's number and total number of rows in the grid (such as "3 of 20"). <P> This attribute may be set to null to disable
     * the feature. <P> Note that screen readers vary widely on which punctuation symbols are read aloud, and sometimes it
     * depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and VoiceOver screen readers all read
     * the forward slash '/' as "slash". See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     *
     * @return Current screenReaderCellSeparator value. Default value is "/"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getScreenReaderCellSeparator()  {
        return getAttributeAsString("screenReaderCellSeparator");
    }
    

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible string will
     * be written out after the last cell in a row. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the end of the row's contents and the screen reader's announcement of the row's number
     * and total number of rows in the grid (such as "3 of 20"). <p> This attribute may be set to null to disable writing out
     * an invisible string at the end of each row. <p> Note that screen readers vary widely on which punctuation symbols are
     * read aloud, and sometimes it depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and
     * VoiceOver screen readers all pause briefly for a comma ',' that is within text. See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderRowSeparator New screenReaderRowSeparator value. Default value is ","
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setScreenReaderCellSeparator
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public void setScreenReaderRowSeparator(String screenReaderRowSeparator)  throws IllegalStateException {
        setAttribute("screenReaderRowSeparator", screenReaderRowSeparator, false);
    }

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible string will
     * be written out after the last cell in a row. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the end of the row's contents and the screen reader's announcement of the row's number
     * and total number of rows in the grid (such as "3 of 20"). <p> This attribute may be set to null to disable writing out
     * an invisible string at the end of each row. <p> Note that screen readers vary widely on which punctuation symbols are
     * read aloud, and sometimes it depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and
     * VoiceOver screen readers all pause briefly for a comma ',' that is within text. See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     *
     * @return Current screenReaderRowSeparator value. Default value is ","
     * @see com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getScreenReaderRowSeparator()  {
        return getAttributeAsString("screenReaderRowSeparator");
    }
    

    /**
     * While drag scrolling in an incrementally rendered grid, time in milliseconds to wait before redrawing, after the last
     * mouse movement by the user. This delay may be  separately customized for mouse-wheel scrolling via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollWheelRedrawDelay scrollWheelRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw GridRenderer.instantScrollTrackRedraw} for
     * cases where this delay is skipped. <P> <strong>NOTE:</strong> In {@link com.smartgwt.client.util.Browser#isTouch touch
     * browsers}, {@link com.smartgwt.client.widgets.grid.GridRenderer#getTouchScrollRedrawDelay touchScrollRedrawDelay} is
     * used instead.
     *
     * @param scrollRedrawDelay New scrollRedrawDelay value. Default value is 0
     */
    public void setScrollRedrawDelay(int scrollRedrawDelay) {
        setAttribute("scrollRedrawDelay", scrollRedrawDelay, true);
    }

    /**
     * While drag scrolling in an incrementally rendered grid, time in milliseconds to wait before redrawing, after the last
     * mouse movement by the user. This delay may be  separately customized for mouse-wheel scrolling via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollWheelRedrawDelay scrollWheelRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw GridRenderer.instantScrollTrackRedraw} for
     * cases where this delay is skipped. <P> <strong>NOTE:</strong> In {@link com.smartgwt.client.util.Browser#isTouch touch
     * browsers}, {@link com.smartgwt.client.widgets.grid.GridRenderer#getTouchScrollRedrawDelay touchScrollRedrawDelay} is
     * used instead.
     *
     * @return Current scrollRedrawDelay value. Default value is 0
     */
    public int getScrollRedrawDelay()  {
        return getAttributeAsInt("scrollRedrawDelay");
    }
    

    /**
     * When scrollToCell is called, this is used as defaults if xPosition weren't explicitly passed into the method.
     *
     * @param scrollToCellXPosition New scrollToCellXPosition value. Default value is "center"
     */
    public void setScrollToCellXPosition(Alignment scrollToCellXPosition) {
        setAttribute("scrollToCellXPosition", scrollToCellXPosition == null ? null : scrollToCellXPosition.getValue(), true);
    }

    /**
     * When scrollToCell is called, this is used as defaults if xPosition weren't explicitly passed into the method.
     *
     * @return Current scrollToCellXPosition value. Default value is "center"
     */
    public Alignment getScrollToCellXPosition()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("scrollToCellXPosition"));
    }
    

    /**
     * When scrollToCell is called, this is used as defaults if yPosition weren't explicitly passed into the method.
     *
     * @param scrollToCellYPosition New scrollToCellYPosition value. Default value is "center"
     */
    public void setScrollToCellYPosition(VerticalAlignment scrollToCellYPosition) {
        setAttribute("scrollToCellYPosition", scrollToCellYPosition == null ? null : scrollToCellYPosition.getValue(), true);
    }

    /**
     * When scrollToCell is called, this is used as defaults if yPosition weren't explicitly passed into the method.
     *
     * @return Current scrollToCellYPosition value. Default value is "center"
     */
    public VerticalAlignment getScrollToCellYPosition()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("scrollToCellYPosition"));
    }
    

    /**
     * While scrolling an incrementally rendered grid, using the mouseWheel, time in  milliseconds to wait before redrawing,
     * after the last mouseWheel movement by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and mouseWheel scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. From experimentation, the default
     * setting of  <code>250</code> is typically enough time for a user to rapidly scroll through a grid (rotating the scroll
     * wheel with repeated flicks), without redrawing between rotations, but this will differ depending on how long the redraw
     * takes. A larger delay may be warranted for grids with large numbers of columns, heavy custom  formatting, etc. <P> See
     * also {@link com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw
     * GridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
     *
     * @param scrollWheelRedrawDelay New scrollWheelRedrawDelay value. Default value is 0
     */
    public void setScrollWheelRedrawDelay(Integer scrollWheelRedrawDelay) {
        setAttribute("scrollWheelRedrawDelay", scrollWheelRedrawDelay, true);
    }

    /**
     * While scrolling an incrementally rendered grid, using the mouseWheel, time in  milliseconds to wait before redrawing,
     * after the last mouseWheel movement by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and mouseWheel scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. From experimentation, the default
     * setting of  <code>250</code> is typically enough time for a user to rapidly scroll through a grid (rotating the scroll
     * wheel with repeated flicks), without redrawing between rotations, but this will differ depending on how long the redraw
     * takes. A larger delay may be warranted for grids with large numbers of columns, heavy custom  formatting, etc. <P> See
     * also {@link com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw
     * GridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
     *
     * @return Current scrollWheelRedrawDelay value. Default value is 0
     */
    public Integer getScrollWheelRedrawDelay()  {
        return getAttributeAsInt("scrollWheelRedrawDelay");
    }
    

    /**
     * If this property is set to true, clicking on a cell will natively select the  cell's content, ready to be copied to the
     * browser clipboard. <P> For control of this behavior at the field level,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSelectCellTextOnClick ListGridField.selectCellTextOnClick} may be
     * used. These properties interact as follows: <table border=1 cellpadding=4><tr>  <td><b>listGrid.selectCellTextOnClick
     * value</b></td>  <td><b>listGridField.selectCellTextOnClick value</b></td>  <td><b>Behavior</b></td> </tr><tr>  <td
     * rowspan=2><code>true</code></td>      <td><i>unset</i> or <code>true</code></td>          <td>Cell contents will be
     * natively selected on click.</td> </tr><tr>      <td><code>false</code></td>          <td>Cell contents will not be
     * natively selected on click.</td> </tr><tr> </tr><tr>  <td rowspan=2><i>unset</i></td>      <td><code>true</code></td>   
     * <td>Cell contents will be natively selected on click.</td> </tr><tr>      <td><i>unset</i> or <code>false</code></td>   
     * <td>Cell contents will not be natively selected on click.</td> </tr><tr>  <td><code>false</code></td>     
     * <td><code>true</code>, <code>false</code> or <i>unset</i></td>          <td>Cell contents will not be natively selected
     * on click.</td> </tr><table> <P> This is related to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelectText canDragSelectText} attribute which enables native text
     * selection of grid content by standard browser interactions (drag selecting or double-click selecting). <P> Note that
     * developers may also be interested in the related formItem properties {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnClick FormItem.selectOnClick} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnFocus FormItem.selectOnFocus}.
     *
     * @param selectCellTextOnClick New selectCellTextOnClick value. Default value is false
     */
    public void setSelectCellTextOnClick(Boolean selectCellTextOnClick) {
        setAttribute("selectCellTextOnClick", selectCellTextOnClick, true);
    }

    /**
     * If this property is set to true, clicking on a cell will natively select the  cell's content, ready to be copied to the
     * browser clipboard. <P> For control of this behavior at the field level,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSelectCellTextOnClick ListGridField.selectCellTextOnClick} may be
     * used. These properties interact as follows: <table border=1 cellpadding=4><tr>  <td><b>listGrid.selectCellTextOnClick
     * value</b></td>  <td><b>listGridField.selectCellTextOnClick value</b></td>  <td><b>Behavior</b></td> </tr><tr>  <td
     * rowspan=2><code>true</code></td>      <td><i>unset</i> or <code>true</code></td>          <td>Cell contents will be
     * natively selected on click.</td> </tr><tr>      <td><code>false</code></td>          <td>Cell contents will not be
     * natively selected on click.</td> </tr><tr> </tr><tr>  <td rowspan=2><i>unset</i></td>      <td><code>true</code></td>   
     * <td>Cell contents will be natively selected on click.</td> </tr><tr>      <td><i>unset</i> or <code>false</code></td>   
     * <td>Cell contents will not be natively selected on click.</td> </tr><tr>  <td><code>false</code></td>     
     * <td><code>true</code>, <code>false</code> or <i>unset</i></td>          <td>Cell contents will not be natively selected
     * on click.</td> </tr><table> <P> This is related to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelectText canDragSelectText} attribute which enables native text
     * selection of grid content by standard browser interactions (drag selecting or double-click selecting). <P> Note that
     * developers may also be interested in the related formItem properties {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnClick FormItem.selectOnClick} and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getSelectOnFocus FormItem.selectOnFocus}.
     *
     * @return Current selectCellTextOnClick value. Default value is false
     */
    public Boolean getSelectCellTextOnClick()  {
        Boolean result = getAttributeAsBoolean("selectCellTextOnClick");
        return result == null ? false : result;
    }
    

    /**
     * Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState setSelectedState()} to reset this grid's selection the
     * current state (assuming the same data is present in the grid).<br>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's selection to match the {@link com.smartgwt.client.docs.ListGridSelectedState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedState getSelectedState()}.
     *
     * @param selectedState Object describing the desired selection state of                                              the grid. Default value is null
     * @see com.smartgwt.client.docs.ListGridSelectedState ListGridSelectedState 
     */
    public void setSelectedState(String selectedState) {
        setAttribute("selectedState", selectedState, true);
    }

    /**
     * Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState setSelectedState()} to reset this grid's selection the
     * current state (assuming the same data is present in the grid).<br>
     *
     * @return Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState setSelectedState()} to reset this grid's current selection
     * state (assuming the same data is present in the grid).<br>. Default value is null
     * @see com.smartgwt.client.docs.ListGridSelectedState ListGridSelectedState 
     */
    public String getSelectedState()  {
        return getAttributeAsString("selectedState");
    }
    

    /**
     * If true, show the field-header for the sorted field (or the first field in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sort} grid) in the selected state.
     *
     * @param selectHeaderOnSort New selectHeaderOnSort value. Default value is true
     */
    public void setSelectHeaderOnSort(Boolean selectHeaderOnSort) {
        setAttribute("selectHeaderOnSort", selectHeaderOnSort, true);
    }

    /**
     * If true, show the field-header for the sorted field (or the first field in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sort} grid) in the selected state.
     *
     * @return Current selectHeaderOnSort value. Default value is true
     */
    public Boolean getSelectHeaderOnSort()  {
        Boolean result = getAttributeAsBoolean("selectHeaderOnSort");
        return result == null ? true : result;
    }
    
    

    /**
     * How selection of rows should be presented to the user. <P> For <code>selectionAppearance:"checkbox"</code> with multiple
     * selection allowed, you would typically use {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType
     * selectionType}:"simple" (the default).  Because <code>selectionType</code> and <code>selectionAppearance</code> are
     * unrelated, the combination of <code>selectionAppearance:"checkbox"</code> and <code>selectionType:"multiple"</code>
     * results in a grid where multiple selection can only be achieved via shift-click or ctrl-click. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.grid.ListGrid}, see also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} for customization APIs. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.tree.TreeGrid}, an extra icon, {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getExtraIcon TreeGrid.getExtraIcon()} is not supported. Additionally only
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType}:"simple" and "single" are supported.
     * You can also toggle the display of a disabled checkbox on a treeGrid, displayed when the node can't be selected, via
     * {@link com.smartgwt.client.widgets.tree.TreeGrid#getShowDisabledSelectionCheckbox
     * TreeGrid.showDisabledSelectionCheckbox}. <p> Note that the default behavior when you enable checkbox selection is to
     * continue to show the selected style.  This can be changed by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedStyle showSelectedStyle} to false.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes selectionAppearance on the fly.
     *
     * @param selectionAppearance new selection appearance. Default value is "rowStyle"
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setSelectionAppearance(SelectionAppearance selectionAppearance) {
        setAttribute("selectionAppearance", selectionAppearance == null ? null : selectionAppearance.getValue(), true);
    }

    /**
     * How selection of rows should be presented to the user. <P> For <code>selectionAppearance:"checkbox"</code> with multiple
     * selection allowed, you would typically use {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType
     * selectionType}:"simple" (the default).  Because <code>selectionType</code> and <code>selectionAppearance</code> are
     * unrelated, the combination of <code>selectionAppearance:"checkbox"</code> and <code>selectionType:"multiple"</code>
     * results in a grid where multiple selection can only be achieved via shift-click or ctrl-click. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.grid.ListGrid}, see also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} for customization APIs. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.tree.TreeGrid}, an extra icon, {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getExtraIcon TreeGrid.getExtraIcon()} is not supported. Additionally only
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType}:"simple" and "single" are supported.
     * You can also toggle the display of a disabled checkbox on a treeGrid, displayed when the node can't be selected, via
     * {@link com.smartgwt.client.widgets.tree.TreeGrid#getShowDisabledSelectionCheckbox
     * TreeGrid.showDisabledSelectionCheckbox}. <p> Note that the default behavior when you enable checkbox selection is to
     * continue to show the selected style.  This can be changed by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedStyle showSelectedStyle} to false.
     *
     * @return Current selectionAppearance value. Default value is "rowStyle"
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public SelectionAppearance getSelectionAppearance()  {
        return EnumUtil.getEnum(SelectionAppearance.values(), getAttribute("selectionAppearance"));
    }
    
    
    

    /**
     * If specified, the selection object for this list will use this property to mark records as selected.  In other words, if
     * this attribute were set to <code>"isSelected"</code> any records in the listGrid data where <code>"isSelected"</code> is
     * <code>true</code> will show up as selected in the grid. Similarly if records are selected within the grid after the grid
     * has been created, this property will be set to true on the selected records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectionProperty New selectionProperty value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setSelectionProperty(String selectionProperty)  throws IllegalStateException {
        setAttribute("selectionProperty", selectionProperty, false);
    }

    /**
     * If specified, the selection object for this list will use this property to mark records as selected.  In other words, if
     * this attribute were set to <code>"isSelected"</code> any records in the listGrid data where <code>"isSelected"</code> is
     * <code>true</code> will show up as selected in the grid. Similarly if records are selected within the grid after the grid
     * has been created, this property will be set to true on the selected records.
     *
     * @return Current selectionProperty value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public String getSelectionProperty()  {
        return getAttributeAsString("selectionProperty");
    }
    

    /**
     * Defines a listGrid's clickable-selection behavior. <P> The default selection appearance is governed by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance}: if selectionAppearance is
     * "checkbox", this will be "simple", otherwise, this will be "multiple".
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes selectionType on the fly.
     *
     * @param selectionType New selection style. Default value is null
     * @see com.smartgwt.client.types.SelectionStyle
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_multiselect" target="examples">Multiple select Example</a>
     */
    public void setSelectionType(SelectionStyle selectionType) {
        setAttribute("selectionType", selectionType == null ? null : selectionType.getValue(), true);
    }

    /**
     * Defines a listGrid's clickable-selection behavior. <P> The default selection appearance is governed by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance}: if selectionAppearance is
     * "checkbox", this will be "simple", otherwise, this will be "multiple".
     *
     * @return Current selectionType value. Default value is null
     * @see com.smartgwt.client.types.SelectionStyle
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_multiselect" target="examples">Multiple select Example</a>
     */
    public SelectionStyle getSelectionType()  {
        return EnumUtil.getEnum(SelectionStyle.values(), getAttribute("selectionType"));
    }
    
    

    /**
     * When the user starts editing a row, should the row also be selected?  <P>  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditSelectionType editSelectionType} for how edit-selection behaves.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectOnEdit New selectOnEdit value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setSelectOnEdit(Boolean selectOnEdit) {
        setAttribute("selectOnEdit", selectOnEdit, true);
    }

    /**
     * When the user starts editing a row, should the row also be selected?  <P>  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditSelectionType editSelectionType} for how edit-selection behaves.
     *
     * @return Current selectOnEdit value. Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getSelectOnEdit()  {
        Boolean result = getAttributeAsBoolean("selectOnEdit");
        return result == null ? true : result;
    }
    

    /**
     * When set to false, clicking a record's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansion
     * field} will not add the record to the current selection.
     *
     * @param selectOnExpandRecord New selectOnExpandRecord value. Default value is true
     */
    public void setSelectOnExpandRecord(boolean selectOnExpandRecord) {
        setAttribute("selectOnExpandRecord", selectOnExpandRecord, true);
    }

    /**
     * When set to false, clicking a record's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansion
     * field} will not add the record to the current selection.
     *
     * @return Current selectOnExpandRecord value. Default value is true
     */
    public boolean getSelectOnExpandRecord()  {
        Boolean result = getAttributeAsBoolean("selectOnExpandRecord");
        return result == null ? true : result;
    }
    

    /**
     * Whether all columns should be drawn all at once, or only columns visible in the viewport. <P> Drawing all columns causes
     * longer initial rendering time, but allows smoother horizontal scrolling.  With a very large number of columns,
     * showAllColumns will become too slow.
     *
     * @param showAllColumns New showAllColumns value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowAllColumns(Boolean showAllColumns)  throws IllegalStateException {
        setAttribute("showAllColumns", showAllColumns, false);
    }

    /**
     * Whether all columns should be drawn all at once, or only columns visible in the viewport. <P> Drawing all columns causes
     * longer initial rendering time, but allows smoother horizontal scrolling.  With a very large number of columns,
     * showAllColumns will become too slow.
     *
     * @return Current showAllColumns value. Default value is false
     */
    public Boolean getShowAllColumns()  {
        Boolean result = getAttributeAsBoolean("showAllColumns");
        return result == null ? false : result;
    }
    

    /**
     * Whether all rows should be drawn all at once, or only rows visible in the viewport. <P> Drawing all rows causes longer
     * initial rendering time, but allows smoother vertical scrolling. With a very large number of rows, showAllRows will
     * become too slow. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAllMaxCells drawAllMaxCells}.
     *
     * @param showAllRecords New showAllRecords value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public void setShowAllRecords(Boolean showAllRecords) {
        setAttribute("showAllRecords", showAllRecords, true);
    }

    /**
     * Whether all rows should be drawn all at once, or only rows visible in the viewport. <P> Drawing all rows causes longer
     * initial rendering time, but allows smoother vertical scrolling. With a very large number of rows, showAllRows will
     * become too slow. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAllMaxCells drawAllMaxCells}.
     *
     * @return Current showAllRecords value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Boolean getShowAllRecords()  {
        Boolean result = getAttributeAsBoolean("showAllRecords");
        return result == null ? false : result;
    }
    

    /**
     * If set to false, do not show the {@link com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt
     * asynchGroupingPrompt} dialog during {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold
     * asynchronous grouping}.
     *
     * @param showAsynchGroupingPrompt New showAsynchGroupingPrompt value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowAsynchGroupingPrompt(Boolean showAsynchGroupingPrompt)  throws IllegalStateException {
        setAttribute("showAsynchGroupingPrompt", showAsynchGroupingPrompt, false);
    }

    /**
     * If set to false, do not show the {@link com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt
     * asynchGroupingPrompt} dialog during {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold
     * asynchronous grouping}.
     *
     * @return Current showAsynchGroupingPrompt value. Default value is null
     */
    public Boolean getShowAsynchGroupingPrompt()  {
        return getAttributeAsBoolean("showAsynchGroupingPrompt");
    }
    

    /**
     * If <code>true</code> this grid will create and show per-row backgroundComponents as detailed {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBackgroundComponent here}.
     *
     * @param showBackgroundComponents New showBackgroundComponents value. Default value is false
     */
    public void setShowBackgroundComponents(Boolean showBackgroundComponents) {
        setAttribute("showBackgroundComponents", showBackgroundComponents, true);
    }

    /**
     * If <code>true</code> this grid will create and show per-row backgroundComponents as detailed {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBackgroundComponent here}.
     *
     * @return Current showBackgroundComponents value. Default value is false
     */
    public Boolean getShowBackgroundComponents()  {
        Boolean result = getAttributeAsBoolean("showBackgroundComponents");
        return result == null ? false : result;
    }
    

    /**
     * Whether to show a context menu with standard items for all context clicks on rows in the body.
     *
     * @param showCellContextMenus New showCellContextMenus value. Default value is false
     */
    public void setShowCellContextMenus(Boolean showCellContextMenus) {
        setAttribute("showCellContextMenus", showCellContextMenus, true);
    }

    /**
     * Whether to show a context menu with standard items for all context clicks on rows in the body.
     *
     * @return Current showCellContextMenus value. Default value is false
     */
    public Boolean getShowCellContextMenus()  {
        Boolean result = getAttributeAsBoolean("showCellContextMenus");
        return result == null ? false : result;
    }
    

    /**
     * If true and a header button's title is clipped, then a hover containing the full field title is enabled.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showClippedHeaderTitlesOnHover New showClippedHeaderTitlesOnHover value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerTitleClipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerHoverHTML
     */
    public void setShowClippedHeaderTitlesOnHover(boolean showClippedHeaderTitlesOnHover)  throws IllegalStateException {
        setAttribute("showClippedHeaderTitlesOnHover", showClippedHeaderTitlesOnHover, false);
    }

    /**
     * If true and a header button's title is clipped, then a hover containing the full field title is enabled.
     *
     * @return Current showClippedHeaderTitlesOnHover value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerTitleClipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerHoverHTML
     */
    public boolean getShowClippedHeaderTitlesOnHover()  {
        Boolean result = getAttributeAsBoolean("showClippedHeaderTitlesOnHover");
        return result == null ? true : result;
    }
    

    /**
     * If true and a cell's value is clipped, then a hover containing the full cell value is enabled. <p> Note that standard
     * cell hovers override clipped value hovers. Thus, to enable clipped value hovers, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} must be unset or null and the corresponding field must
     * have {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} unset or null as well.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showClippedValuesOnHover New showClippedValuesOnHover value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellValueHoverHTML
     */
    public void setShowClippedValuesOnHover(Boolean showClippedValuesOnHover)  throws IllegalStateException {
        setAttribute("showClippedValuesOnHover", showClippedValuesOnHover, false);
    }

    /**
     * If true and a cell's value is clipped, then a hover containing the full cell value is enabled. <p> Note that standard
     * cell hovers override clipped value hovers. Thus, to enable clipped value hovers, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} must be unset or null and the corresponding field must
     * have {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} unset or null as well.
     *
     * @return Current showClippedValuesOnHover value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellValueHoverHTML
     */
    public Boolean getShowClippedValuesOnHover()  {
        return getAttributeAsBoolean("showClippedValuesOnHover");
    }
    

    /**
     * Should group summaries be visible when the group is collapsed? <P> This property only applies to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} grids showing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}. When set to true, the group summary
     * row(s) for each group will show up under the group header nodes when the group is collapsed, or at then end of the
     * grouped set of data if the group is expanded. <P> This property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getShowCollapsedGroupSummary showCollapsedGroupSummary}
     *
     * @param showCollapsedGroupSummary new showCollapsedGroupSummary value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setShowCollapsedGroupSummary(Boolean showCollapsedGroupSummary) {
        setAttribute("showCollapsedGroupSummary", showCollapsedGroupSummary, true);
    }

    /**
     * Should group summaries be visible when the group is collapsed? <P> This property only applies to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} grids showing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}. When set to true, the group summary
     * row(s) for each group will show up under the group header nodes when the group is collapsed, or at then end of the
     * grouped set of data if the group is expanded. <P> This property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true.
     *
     * @return Current showCollapsedGroupSummary value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getShowCollapsedGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showCollapsedGroupSummary");
        return result == null ? false : result;
    }
    

    /**
     * Whether to include fields marked <code>detail:true</code> from this component's <code>DataSource</code>. <P> When this
     * property is <code>true</code>, the <code>ListGrid</code> will include all detail fields unless fields have been
     * specifically declared using the {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array. <P> Any field
     * which has been included directly in the <code>fields</code> array will be included regardless of the fields
     * <code>detail</code> attribute. <p> Detail fields included will initially be hidden but the user may show these fields
     * via the default header context menu ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * showHeaderContextMenu}). <P> The field's visibility can also be overridden programatically using the standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} APIs, for example, set showIf:"true" to
     * show a detail field initially. <P> Setting this property to false will completely exclude all detail fields from the
     * list grid's fields array, such that they cannot be shown by the user or programmatically.
     *
     * @param showDetailFields New showDetailFields value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setShowDetailFields(Boolean showDetailFields)  throws IllegalStateException {
        setAttribute("showDetailFields", showDetailFields, false);
    }

    /**
     * Whether to include fields marked <code>detail:true</code> from this component's <code>DataSource</code>. <P> When this
     * property is <code>true</code>, the <code>ListGrid</code> will include all detail fields unless fields have been
     * specifically declared using the {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array. <P> Any field
     * which has been included directly in the <code>fields</code> array will be included regardless of the fields
     * <code>detail</code> attribute. <p> Detail fields included will initially be hidden but the user may show these fields
     * via the default header context menu ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu
     * showHeaderContextMenu}). <P> The field's visibility can also be overridden programatically using the standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField hideField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} APIs, for example, set showIf:"true" to
     * show a detail field initially. <P> Setting this property to false will completely exclude all detail fields from the
     * list grid's fields array, such that they cannot be shown by the user or programmatically.
     *
     * @return Current showDetailFields value. Default value is true
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getShowDetailFields()  {
        Boolean result = getAttributeAsBoolean("showDetailFields");
        return result == null ? true : result;
    }
    

    /**
     * Should ellipses be displayed when cell content is clipped? May be overridden at the field  level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowEllipsisWhenClipped ListGridField.showEllipsisWhenClipped}
     *
     * @param showEllipsisWhenClipped New showEllipsisWhenClipped value. Default value is true
     */
    public void setShowEllipsisWhenClipped(boolean showEllipsisWhenClipped) {
        setAttribute("showEllipsisWhenClipped", showEllipsisWhenClipped, true);
    }

    /**
     * Should ellipses be displayed when cell content is clipped? May be overridden at the field  level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowEllipsisWhenClipped ListGridField.showEllipsisWhenClipped}
     *
     * @return Current showEllipsisWhenClipped value. Default value is true
     */
    public boolean getShowEllipsisWhenClipped()  {
        Boolean result = getAttributeAsBoolean("showEllipsisWhenClipped");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether the text of the emptyMessage property should be displayed if no data is available.
     *
     * @param showEmptyMessage New showEmptyMessage value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEmptyMessage
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public void setShowEmptyMessage(Boolean showEmptyMessage) {
        setAttribute("showEmptyMessage", showEmptyMessage, true);
    }

    /**
     * Indicates whether the text of the emptyMessage property should be displayed if no data is available.
     *
     * @return Current showEmptyMessage value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public Boolean getShowEmptyMessage()  {
        Boolean result = getAttributeAsBoolean("showEmptyMessage");
        return result == null ? true : result;
    }
    

    /**
     * If this grid is editable, and an edit has caused validation failure for some cell,  should we show an icon to indicate
     * validation failure?
     *
     * @param showErrorIcons New showErrorIcons value. Default value is true
     */
    public void setShowErrorIcons(boolean showErrorIcons) {
        setAttribute("showErrorIcons", showErrorIcons, true);
    }

    /**
     * If this grid is editable, and an edit has caused validation failure for some cell,  should we show an icon to indicate
     * validation failure?
     *
     * @return Current showErrorIcons value. Default value is true
     */
    public boolean getShowErrorIcons()  {
        Boolean result = getAttributeAsBoolean("showErrorIcons");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.types.ExpansionMode} is <i>editor</i>, should a Save button be shown below the the
     * expanded editor? <P> Note that if an expanded-row containing an editor is collapsed while changes are outstanding,
     * changes will be either be automatically updated to the grid, or will first show a confirmation dialog, according to the
     * value of {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorShowSaveDialog
     * expansionEditorShowSaveDialog}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Current showExpansionEditorSaveButton value. Default value is true
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Boolean getShowExpansionEditorSaveButton() throws IllegalStateException {
        errorIfNotCreated("showExpansionEditorSaveButton");
        Boolean result = getAttributeAsBoolean("showExpansionEditorSaveButton");
        return result == null ? true : result;
    }
    

    /**
     * Should this listGrid display a filter row.  If true, this ListGrid
     *  will be drawn with a single editable row, (separate from the body) with a filter button.
     *  <P>
     *  Values entered into this row are used as filter criteria to filter this List's data on
     * enter-keypress or filter button click. {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle
     * autoFetchTextMatchStyle} determines
     *  the textMatchStyle for the request passed to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.
     *  <P>
     * The default {@link com.smartgwt.client.widgets.form.fields.FormItem#getOperator search operator} for an item in the
     * filterEditor can
     * be set via {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator}.   When
     * <code>field.filterOperator</code> 
     *  has been set calls to retrieve the criteria from the grid return {@link com.smartgwt.client.data.AdvancedCriteria}.  
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} for a UI that
     * allows end users to change the search
     *  operator on the fly
     *  <P>
     * Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is called
     *  directly while the filter editor is showing, the filter editor values will be updated to
     *  reflect the new set of criteria. If you wish to retain the user entered filter criteria
     *  and modify a subset of field values programmatically, this can be achieved by
     *  copying the existing set of criteria and adding other changes - something
     *  like this:
     *  
     *  
     *  <pre><code>
     *    Criteria newCriteria = myListGrid.getFilterEditorCriteria();
     *    newCriteria = DataSource.combineCriteria(newCriteria,
     *       new Criteria("field1", "new value1")
     *    );
     *    myListGrid.setCriteria(newCriteria);
     *  </code></pre>
     *  
     * In this example code we're using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * getFilterEditorCriteria()} rather than
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria getCriteria()} - this ensures that if the user has typed a
     * new value into
     *  the filter editor, but not yet clicked the filter button, we pick up the value the user
     * entered.  This sample code uses {@link com.smartgwt.client.data.DataSource#combineCriteria DataSource.combineCriteria()}
     * to combine the
     *  existing filterEditorCriteria with some new custom criteria.  This technique is
     *  applicable to both simple and advanced criteria.
     *  <P>
     *  If you call <code>filterData()</code> and pass in criteria for dataSource
     *  fields that are not present in the ListGrid, these criteria will continue to be applied
     *  along with the user-visible criteria.
     *  <P>
     *  <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
     *  on a ListGrid and passes in {@link com.smartgwt.client.data.AdvancedCriteria}, expected behavior of the filter
     *  editor becomes ambiguous, since AdvancedCriteria has far more complex filter
     *  expression support than the ordinary filterEditor can represent.
     *  <P>
     *  Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
     *  in the filter editor as follows:
     *  <ul>
     *  <li>If the top level criteria has operator of type "and":<br>
     *   Each field in the top level
     *   criteria array for which a 'canFilter' true field is shown in the listGrid will show up
     *   if the specified operator matches the default filter behavior
     * (based on the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle}).<br>
     *   If the user enters values in the filter editor, these will be combined with the
     *   existing AdvancedCriteria by either replacing or adding field level criteria at the top
     *   level.</li>
     *  <li>If the top level criteria is a single field-criteria:<br>
     *   If the field shows up in the listGrid and is canFilter:true, it will be displayed to
     *   the user (if the operator matches the default filter behavior for the field).<br>
     *   If the user enters new filter criteria in the filterEditor, they will be combined with
     *   this existing criterion via a top level "and" operator, or if the user modifies the
     *   field for which the criterion already existed, it will be replaced.</li>
     *  <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
     *   these will not be shown in the filter editor. Any filter parameters the user enters will
     *   be added to the existing criteria via an additional top level "and" operator, meaning
     *   the user will essentially filter a subset of the existing criteria</li>
     *  </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} property. Allows the filter editor to be shown or hidden at runtime.
     *
     * @param showFilterEditor true if the filter editor should be shown, false if it should be hidden. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public void setShowFilterEditor(boolean showFilterEditor) {
        setAttribute("showFilterEditor", showFilterEditor, true);
    }

    /**
     * Should this listGrid display a filter row.  If true, this ListGrid
     *  will be drawn with a single editable row, (separate from the body) with a filter button.
     *  <P>
     *  Values entered into this row are used as filter criteria to filter this List's data on
     * enter-keypress or filter button click. {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle
     * autoFetchTextMatchStyle} determines
     *  the textMatchStyle for the request passed to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.
     *  <P>
     * The default {@link com.smartgwt.client.widgets.form.fields.FormItem#getOperator search operator} for an item in the
     * filterEditor can
     * be set via {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterOperator ListGridField.filterOperator}.   When
     * <code>field.filterOperator</code> 
     *  has been set calls to retrieve the criteria from the grid return {@link com.smartgwt.client.data.AdvancedCriteria}.  
     * See also {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowFilterOperators allowFilterOperators} for a UI that
     * allows end users to change the search
     *  operator on the fly
     *  <P>
     * Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#filterData filterData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()} is called
     *  directly while the filter editor is showing, the filter editor values will be updated to
     *  reflect the new set of criteria. If you wish to retain the user entered filter criteria
     *  and modify a subset of field values programmatically, this can be achieved by
     *  copying the existing set of criteria and adding other changes - something
     *  like this:
     *  
     *  
     *  <pre><code>
     *    Criteria newCriteria = myListGrid.getFilterEditorCriteria();
     *    newCriteria = DataSource.combineCriteria(newCriteria,
     *       new Criteria("field1", "new value1")
     *    );
     *    myListGrid.setCriteria(newCriteria);
     *  </code></pre>
     *  
     * In this example code we're using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * getFilterEditorCriteria()} rather than
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria getCriteria()} - this ensures that if the user has typed a
     * new value into
     *  the filter editor, but not yet clicked the filter button, we pick up the value the user
     * entered.  This sample code uses {@link com.smartgwt.client.data.DataSource#combineCriteria DataSource.combineCriteria()}
     * to combine the
     *  existing filterEditorCriteria with some new custom criteria.  This technique is
     *  applicable to both simple and advanced criteria.
     *  <P>
     *  If you call <code>filterData()</code> and pass in criteria for dataSource
     *  fields that are not present in the ListGrid, these criteria will continue to be applied
     *  along with the user-visible criteria.
     *  <P>
     *  <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
     *  on a ListGrid and passes in {@link com.smartgwt.client.data.AdvancedCriteria}, expected behavior of the filter
     *  editor becomes ambiguous, since AdvancedCriteria has far more complex filter
     *  expression support than the ordinary filterEditor can represent.
     *  <P>
     *  Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
     *  in the filter editor as follows:
     *  <ul>
     *  <li>If the top level criteria has operator of type "and":<br>
     *   Each field in the top level
     *   criteria array for which a 'canFilter' true field is shown in the listGrid will show up
     *   if the specified operator matches the default filter behavior
     * (based on the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle}).<br>
     *   If the user enters values in the filter editor, these will be combined with the
     *   existing AdvancedCriteria by either replacing or adding field level criteria at the top
     *   level.</li>
     *  <li>If the top level criteria is a single field-criteria:<br>
     *   If the field shows up in the listGrid and is canFilter:true, it will be displayed to
     *   the user (if the operator matches the default filter behavior for the field).<br>
     *   If the user enters new filter criteria in the filterEditor, they will be combined with
     *   this existing criterion via a top level "and" operator, or if the user modifies the
     *   field for which the criterion already existed, it will be replaced.</li>
     *  <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
     *   these will not be shown in the filter editor. Any filter parameters the user enters will
     *   be added to the existing criteria via an additional top level "and" operator, meaning
     *   the user will essentially filter a subset of the existing criteria</li>
     *  </ul>
     *
     * @return Current showFilterEditor value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public boolean getShowFilterEditor()  {
        Boolean result = getAttributeAsBoolean("showFilterEditor");
        return result == null ? false : result;
    }
    

    /**
     * Should this ListGrid show a summary row beneath the last record of the grid. This summary row will contain per-field
     * summary information. See {@link com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary
     * ListGridField.showGridSummary} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction
     * getGridSummaryFunction()} for details on how the summary value to be displayed for each column will be calculated. <P>
     * Note that the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow autoChild} will be created to
     * actually display the summary row.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} attribute
     *
     * @param showGridSummary new value for this.showGridSummary. Default value is false
     */
    public void setShowGridSummary(Boolean showGridSummary) {
        setAttribute("showGridSummary", showGridSummary, true);
    }

    /**
     * Should this ListGrid show a summary row beneath the last record of the grid. This summary row will contain per-field
     * summary information. See {@link com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary
     * ListGridField.showGridSummary} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction
     * getGridSummaryFunction()} for details on how the summary value to be displayed for each column will be calculated. <P>
     * Note that the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow autoChild} will be created to
     * actually display the summary row.
     *
     * @return Current showGridSummary value. Default value is false
     */
    public Boolean getShowGridSummary()  {
        Boolean result = getAttributeAsBoolean("showGridSummary");
        return result == null ? false : result;
    }
    

    /**
     * If this listGrid supports {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping}, setting this
     * property will cause the grid to render an extra row at the end of each group when grouped, containing summary
     * information for the fields. Summary information will be calculated by the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGroupSummary ListGridField.getGroupSummary()} method if specified,
     * otherwise via the specified {@link com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction
     * ListGridField.summaryFunction}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} attribute
     *
     * @param showGroupSummary new value for this.showGroupSummary. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setGroupByFieldSummaries
     */
    public void setShowGroupSummary(Boolean showGroupSummary) {
        setAttribute("showGroupSummary", showGroupSummary, true);
    }

    /**
     * If this listGrid supports {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping}, setting this
     * property will cause the grid to render an extra row at the end of each group when grouped, containing summary
     * information for the fields. Summary information will be calculated by the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGroupSummary ListGridField.getGroupSummary()} method if specified,
     * otherwise via the specified {@link com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction
     * ListGridField.summaryFunction}.
     *
     * @return Current showGroupSummary value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupByFieldSummaries
     */
    public Boolean getShowGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showGroupSummary");
        return result == null ? false : result;
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, setting this property causes
     * field summary values for each group to be displayed directly in the group header node, rather than showing up at the
     * bottom of each expanded group. <P> Note that this means the group header node will be showing multiple field values
     * rather than the default display of a single cell spanning all columns containing the group title. Developers may specify
     * an explicit {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}, or rely on the
     * automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} to
     * have group titles be visible as well as the summary values. <P> Also note that multi-line group summaries are not
     * supported when showing the group summary in the group header. If multiple {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction field summary functions} are defined for some field
     * only the first will be displayed when this property is set to true.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader}
     *
     * @param showGroupSummaryInHeader new showGroupSummaryInHeader state. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setShowGroupSummaryInHeader(Boolean showGroupSummaryInHeader) {
        setAttribute("showGroupSummaryInHeader", showGroupSummaryInHeader, true);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, setting this property causes
     * field summary values for each group to be displayed directly in the group header node, rather than showing up at the
     * bottom of each expanded group. <P> Note that this means the group header node will be showing multiple field values
     * rather than the default display of a single cell spanning all columns containing the group title. Developers may specify
     * an explicit {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}, or rely on the
     * automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} to
     * have group titles be visible as well as the summary values. <P> Also note that multi-line group summaries are not
     * supported when showing the group summary in the group header. If multiple {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction field summary functions} are defined for some field
     * only the first will be displayed when this property is set to true.
     *
     * @return Current showGroupSummaryInHeader value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getShowGroupSummaryInHeader()  {
        Boolean result = getAttributeAsBoolean("showGroupSummaryInHeader");
        return result == null ? false : result;
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, instead of
     * group header nodes showing up with a single cell value spanning the full set of columns, summaries for each field will
     * show up in the appropriate columns of the header node. <P> In this case there are 2 options for where the group title
     * will show up. Developers may specify an existing field to put the title values into via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}. If no groupTitleField is specified, this
     * property may be set to <code>true</code> which causes a <code>groupTitleColumn</code> to be automatically generated.
     * Each group header will show the group title in this column (records within the group will not show a value for this
     * column). The column appears in the leftmost position within the grid (unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, in which case this column shows up
     * in the second-leftmost position), and by default will auto-fit to its data. <P> To customize this field, developers may
     * modify {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleColumnProperties groupTitleColumnProperties}
     *
     * @param showGroupTitleColumn New showGroupTitleColumn value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowGroupTitleColumn(Boolean showGroupTitleColumn)  throws IllegalStateException {
        setAttribute("showGroupTitleColumn", showGroupTitleColumn, false);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, instead of
     * group header nodes showing up with a single cell value spanning the full set of columns, summaries for each field will
     * show up in the appropriate columns of the header node. <P> In this case there are 2 options for where the group title
     * will show up. Developers may specify an existing field to put the title values into via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}. If no groupTitleField is specified, this
     * property may be set to <code>true</code> which causes a <code>groupTitleColumn</code> to be automatically generated.
     * Each group header will show the group title in this column (records within the group will not show a value for this
     * column). The column appears in the leftmost position within the grid (unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, in which case this column shows up
     * in the second-leftmost position), and by default will auto-fit to its data. <P> To customize this field, developers may
     * modify {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleColumnProperties groupTitleColumnProperties}
     *
     * @return Current showGroupTitleColumn value. Default value is true
     */
    public Boolean getShowGroupTitleColumn()  {
        Boolean result = getAttributeAsBoolean("showGroupTitleColumn");
        return result == null ? true : result;
    }
    

    /**
     * If this is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and has  {@link
     * com.smartgwt.client.docs.FrozenFields frozen fields}, should the group title show in the frozen or unfrozen body? <P>
     * Setting this property to false will cause the group title to show in the  unfrozen body in this case, meaning it will
     * appear to the right of the frozen fields, and scroll horizontally as the user scrolls the unfrozen fields.  This can be
     * useful for grids where there isn't enough available space to show the group title text in the frozen body. <P> Note that
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField} is explicitly set, or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, this property
     * has no effect. In this case rather than the group title showing in a single cell spanning multiple other fields, it will
     * be rendered into a specific column.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showGroupTitleInFrozenBody New showGroupTitleInFrozenBody value. Default value is true
     */
    public void setShowGroupTitleInFrozenBody(boolean showGroupTitleInFrozenBody) {
        setAttribute("showGroupTitleInFrozenBody", showGroupTitleInFrozenBody, true);
    }

    /**
     * If this is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and has  {@link
     * com.smartgwt.client.docs.FrozenFields frozen fields}, should the group title show in the frozen or unfrozen body? <P>
     * Setting this property to false will cause the group title to show in the  unfrozen body in this case, meaning it will
     * appear to the right of the frozen fields, and scroll horizontally as the user scrolls the unfrozen fields.  This can be
     * useful for grids where there isn't enough available space to show the group title text in the frozen body. <P> Note that
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField} is explicitly set, or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, this property
     * has no effect. In this case rather than the group title showing in a single cell spanning multiple other fields, it will
     * be rendered into a specific column.
     *
     * @return Current showGroupTitleInFrozenBody value. Default value is true
     */
    public boolean getShowGroupTitleInFrozenBody()  {
        Boolean result = getAttributeAsBoolean("showGroupTitleInFrozenBody");
        return result == null ? true : result;
    }
    

    /**
     * Should we show the header for this ListGrid?
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Show or hide the ListGrid header.
     *
     * @param showHeader true to show the header, false to hide it. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setShowHeader(Boolean showHeader) {
        setAttribute("showHeader", showHeader, true);
    }

    /**
     * Should we show the header for this ListGrid?
     *
     * @return Current showHeader value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getShowHeader()  {
        Boolean result = getAttributeAsBoolean("showHeader");
        return result == null ? true : result;
    }
    

    /**
     * Whether to show a context menu on the header with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderContextMenu New showHeaderContextMenu value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setShowHeaderContextMenu(Boolean showHeaderContextMenu)  throws IllegalStateException {
        setAttribute("showHeaderContextMenu", showHeaderContextMenu, false);
    }

    /**
     * Whether to show a context menu on the header with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Current showHeaderContextMenu value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Boolean getShowHeaderContextMenu()  {
        Boolean result = getAttributeAsBoolean("showHeaderContextMenu");
        return result == null ? true : result;
    }
    

    /**
     * If set to true and {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is
     * true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButton headerMenuButton} will be displayed when
     * the user rolls over the header buttons in this grid.  Not supported for {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderMenuButton New showHeaderMenuButton value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowHeaderMenuButton(Boolean showHeaderMenuButton)  throws IllegalStateException {
        setAttribute("showHeaderMenuButton", showHeaderMenuButton, false);
    }

    /**
     * If set to true and {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is
     * true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButton headerMenuButton} will be displayed when
     * the user rolls over the header buttons in this grid.  Not supported for {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Current showHeaderMenuButton value. Default value is true
     */
    public Boolean getShowHeaderMenuButton()  {
        Boolean result = getAttributeAsBoolean("showHeaderMenuButton");
        return result == null ? true : result;
    }
    

    /**
     * Should partial selection of all records be shown in header with a special icon? The partial icon will show in the header
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll canSelectAll} is enabled and at least one record
     * is selected but all records are not selected. To only show all selected and none selected states, set this attribute to
     * <code>false</code>.
     *
     * @param showHeaderPartialSelection New showHeaderPartialSelection value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setShowHeaderPartialSelection(Boolean showHeaderPartialSelection) {
        setAttribute("showHeaderPartialSelection", showHeaderPartialSelection, true);
    }

    /**
     * Should partial selection of all records be shown in header with a special icon? The partial icon will show in the header
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll canSelectAll} is enabled and at least one record
     * is selected but all records are not selected. To only show all selected and none selected states, set this attribute to
     * <code>false</code>.
     *
     * @return Current showHeaderPartialSelection value. Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getShowHeaderPartialSelection()  {
        return getAttributeAsBoolean("showHeaderPartialSelection");
    }
    

    /**
     * Should the header show a drop-shadow? Shadow will be applied to the header, or for a grid with frozen columns, the
     * header layout.  <P> Header shadow will only be displayed if {@link com.smartgwt.client.widgets.Canvas#getUseCSSShadow
     * css shadows} are being used.
     *
     * @param showHeaderShadow New showHeaderShadow value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowVOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowHOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowSoftness
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderShadowColor
     */
    public void setShowHeaderShadow(Boolean showHeaderShadow) {
        setAttribute("showHeaderShadow", showHeaderShadow, true);
    }

    /**
     * Should the header show a drop-shadow? Shadow will be applied to the header, or for a grid with frozen columns, the
     * header layout.  <P> Header shadow will only be displayed if {@link com.smartgwt.client.widgets.Canvas#getUseCSSShadow
     * css shadows} are being used.
     *
     * @return Current showHeaderShadow value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowVOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowHOffset
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowSoftness
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderShadowColor
     */
    public Boolean getShowHeaderShadow()  {
        Boolean result = getAttributeAsBoolean("showHeaderShadow");
        return result == null ? false : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the FormulaBuilder or
     * SummaryBuilder.
     *
     * @param showHeaderSpanTitlesInFormulaBuilder New showHeaderSpanTitlesInFormulaBuilder value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFormulaBuilderSpanTitleSeparator
     */
    public void setShowHeaderSpanTitlesInFormulaBuilder(Boolean showHeaderSpanTitlesInFormulaBuilder) {
        setAttribute("showHeaderSpanTitlesInFormulaBuilder", showHeaderSpanTitlesInFormulaBuilder, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the FormulaBuilder or
     * SummaryBuilder.
     *
     * @return Current showHeaderSpanTitlesInFormulaBuilder value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFormulaBuilderSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInFormulaBuilder()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInFormulaBuilder");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#editHilites hilite editor}.
     *
     * @param showHeaderSpanTitlesInHiliteEditor New showHeaderSpanTitlesInHiliteEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteEditorSpanTitleSeparator
     */
    public void setShowHeaderSpanTitlesInHiliteEditor(Boolean showHeaderSpanTitlesInHiliteEditor) {
        setAttribute("showHeaderSpanTitlesInHiliteEditor", showHeaderSpanTitlesInHiliteEditor, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#editHilites hilite editor}.
     *
     * @return Current showHeaderSpanTitlesInHiliteEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteEditorSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInHiliteEditor()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInHiliteEditor");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.MultiSortDialog multi-sort editor}.
     *
     * @param showHeaderSpanTitlesInSortEditor New showHeaderSpanTitlesInSortEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortEditorSpanTitleSeparator
     */
    public void setShowHeaderSpanTitlesInSortEditor(Boolean showHeaderSpanTitlesInSortEditor) {
        setAttribute("showHeaderSpanTitlesInSortEditor", showHeaderSpanTitlesInSortEditor, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.MultiSortDialog multi-sort editor}.
     *
     * @return Current showHeaderSpanTitlesInSortEditor value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortEditorSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInSortEditor()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInSortEditor");
        return result == null ? true : result;
    }
    

    /**
     * Determines whether hiliting for any field in this grid is shown in a group summary. This setting affects all fields of
     * the grid. <P> To suppress hilites for a specific field see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHilitesInGroupSummary ListGridField.showHilitesInGroupSummary}.
     * <P> Hiliting in summary fields (columns) can be enabled by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIncludeHilitesInSummaryFields includeHiliteInSummaryField} to true.
     *
     * @param showHilitesInGroupSummary New showHilitesInGroupSummary value. Default value is true
     */
    public void setShowHilitesInGroupSummary(boolean showHilitesInGroupSummary) {
        setAttribute("showHilitesInGroupSummary", showHilitesInGroupSummary, true);
    }

    /**
     * Determines whether hiliting for any field in this grid is shown in a group summary. This setting affects all fields of
     * the grid. <P> To suppress hilites for a specific field see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHilitesInGroupSummary ListGridField.showHilitesInGroupSummary}.
     * <P> Hiliting in summary fields (columns) can be enabled by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIncludeHilitesInSummaryFields includeHiliteInSummaryField} to true.
     *
     * @return Current showHilitesInGroupSummary value. Default value is true
     */
    public boolean getShowHilitesInGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showHilitesInGroupSummary");
        return result == null ? true : result;
    }
    

    /**
     * If true, and canHover is also true, when the user hovers over a cell, hover text will pop up next to the mouse.  The
     * contents of the hover is determined by {@link com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML cellHoverHTML()}.
     *
     * @param showHover New showHover value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     */
    public void setShowHover(Boolean showHover) {
        setAttribute("showHover", showHover, true);
    }

    /**
     * If true, and canHover is also true, when the user hovers over a cell, hover text will pop up next to the mouse.  The
     * contents of the hover is determined by {@link com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML cellHoverHTML()}.
     *
     * @return Current showHover value. Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     */
    public Boolean getShowHover()  {
        Boolean result = getAttributeAsBoolean("showHover");
        return result == null ? true : result;
    }
    

    /**
     * When set to true and canHover is also true, shows a widget hovering at the mouse point. <P> A number of builtin modes
     * are provided - see {@link com.smartgwt.client.types.HoverMode}. <P> Also supported at the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHoverComponents field-level}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showHoverComponents New showHoverComponents value. Default value is false
     */
    public void setShowHoverComponents(Boolean showHoverComponents) {
        setAttribute("showHoverComponents", showHoverComponents, true);
    }

    /**
     * When set to true and canHover is also true, shows a widget hovering at the mouse point. <P> A number of builtin modes
     * are provided - see {@link com.smartgwt.client.types.HoverMode}. <P> Also supported at the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHoverComponents field-level}.
     *
     * @return Current showHoverComponents value. Default value is false
     */
    public Boolean getShowHoverComponents()  {
        Boolean result = getAttributeAsBoolean("showHoverComponents");
        return result == null ? false : result;
    }
    

    /**
     * Should partially selected parents (in a Tree data set) be shown with special icon? This has an impact in grouped grids
     * where {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups canSelectGroups} is true. The partial icon
     * will show up for the group header node when a group is partially selected.
     *
     * @param showPartialSelection New showPartialSelection value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setShowPartialSelection(Boolean showPartialSelection) {
        setAttribute("showPartialSelection", showPartialSelection, true);
    }

    /**
     * Should partially selected parents (in a Tree data set) be shown with special icon? This has an impact in grouped grids
     * where {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups canSelectGroups} is true. The partial icon
     * will show up for the group header node when a group is partially selected.
     *
     * @return Current showPartialSelection value. Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getShowPartialSelection()  {
        Boolean result = getAttributeAsBoolean("showPartialSelection");
        return result == null ? false : result;
    }
    

    /**
     * When enabled, {@link com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent()} will be
     * called when saved rows are being rendered, and any returned component will be displayed embedded within the row or cell.
     * <P> recordComponents are not created for newly added rows which have not yet been saved.   See the {@link
     * com.smartgwt.client.docs.UnsavedRecords Handling Unsaved Records overview} for more information. <P> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} setting,
     * <code>createRecordComponent()</code> will be called either once per row, or once for every cell. <P> Depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition}, components can either be
     * placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content
     * ("within" setting).  For the "within" setting, the default is to fill the row or cell, but the component can specify
     * percent size or even use {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo-positioning} to place itself within
     * the row or cell. <p> The "expand" setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen columns} <i>unless</i> all
     * <code>recordComponents</code> are the same height and they are present in every row, in which case the fixed height of
     * all <code>recordComponents</code> can be set via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight} to re-enable frozen fields.
     * <p> Using <code>recordComponents</code> potentially means creating one component for every visible grid row or cell and
     * so can impact performance.  Before using this subsystem: <ul> <li> consider using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons ListGridField.valueIcons} (possibly with a specified      
     * {@link com.smartgwt.client.widgets.grid.ListGridField#addValueIconClickHandler ListGridField.valueIconClick()} handler)
     * for icons based on field values      which may be displayed alone in the cell or alongside standard content      (see
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly ListGridField.showValueIconOnly}); <li> for
     * clickable icons representing actions that can be taken on a record, also       consider using {@link
     * com.smartgwt.client.types.ListGridFieldType a field of type "icon"}, or       multiple such fields <li> for controls
     * that only need to appear on rollover, consider      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas rollOver controls} <li> if you are trying to customize
     * the editor for a field, you can provide a custom      control via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorType ListGridField.editorType}, and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getIcons FormItem.icons} are a common      way to add clickable
     * buttons.  You can also      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType provide different controls
     * per record}.  These options are      usually better that using <code>recordComponents</code> as custom editors, since   
     * you won't have to manage issues like making the <code>recordComponent</code> appear      only when editing, having
     * changes affect {@link com.smartgwt.client.docs.Editing editValues},      triggering saves and handling validation
     * errors, etc. </ul> <P> See {@link com.smartgwt.client.types.RecordComponentPoolingMode} for an overview of how best to
     * optimize use of <code>recordComponents</code> for different data sets. <p> Regardless of the pooling mode, you can
     * explicitly refresh record components via {@link com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents
     * invalidateRecordComponents()} and {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent
     * refreshRecordComponent()}. <P> <i>Interaction with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths column auto-fit}</i>: per-cell record components are not
     * taken into account when determining the size for column auto fit. The default {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} implementation looks at cell
     * content only. We typically recommend that, for fields showing record-components,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} be disabled, or if  the
     * record components are of a predictable size, a {@link com.smartgwt.client.widgets.grid.ListGridField#getDefaultWidth
     * ListGridField.defaultWidth} be specified.<br> This is particularly pertinent where {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition} is set to "within", in
     * which case cells' content is often empty or completely covered by record-components.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} attribute
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRecordComponents new value for <code>this.showRecordComponents</code>. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordComponentPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRecordComponentsByCell
     * @see com.smartgwt.client.types.RecordComponentPoolingMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#showRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     */
    public void setShowRecordComponents(Boolean showRecordComponents) {
        setAttribute("showRecordComponents", showRecordComponents, true);
    }

    /**
     * When enabled, {@link com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent()} will be
     * called when saved rows are being rendered, and any returned component will be displayed embedded within the row or cell.
     * <P> recordComponents are not created for newly added rows which have not yet been saved.   See the {@link
     * com.smartgwt.client.docs.UnsavedRecords Handling Unsaved Records overview} for more information. <P> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} setting,
     * <code>createRecordComponent()</code> will be called either once per row, or once for every cell. <P> Depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition}, components can either be
     * placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content
     * ("within" setting).  For the "within" setting, the default is to fill the row or cell, but the component can specify
     * percent size or even use {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo-positioning} to place itself within
     * the row or cell. <p> The "expand" setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen columns} <i>unless</i> all
     * <code>recordComponents</code> are the same height and they are present in every row, in which case the fixed height of
     * all <code>recordComponents</code> can be set via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight} to re-enable frozen fields.
     * <p> Using <code>recordComponents</code> potentially means creating one component for every visible grid row or cell and
     * so can impact performance.  Before using this subsystem: <ul> <li> consider using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons ListGridField.valueIcons} (possibly with a specified      
     * {@link com.smartgwt.client.widgets.grid.ListGridField#addValueIconClickHandler ListGridField.valueIconClick()} handler)
     * for icons based on field values      which may be displayed alone in the cell or alongside standard content      (see
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly ListGridField.showValueIconOnly}); <li> for
     * clickable icons representing actions that can be taken on a record, also       consider using {@link
     * com.smartgwt.client.types.ListGridFieldType a field of type "icon"}, or       multiple such fields <li> for controls
     * that only need to appear on rollover, consider      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas rollOver controls} <li> if you are trying to customize
     * the editor for a field, you can provide a custom      control via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorType ListGridField.editorType}, and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getIcons FormItem.icons} are a common      way to add clickable
     * buttons.  You can also      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType provide different controls
     * per record}.  These options are      usually better that using <code>recordComponents</code> as custom editors, since   
     * you won't have to manage issues like making the <code>recordComponent</code> appear      only when editing, having
     * changes affect {@link com.smartgwt.client.docs.Editing editValues},      triggering saves and handling validation
     * errors, etc. </ul> <P> See {@link com.smartgwt.client.types.RecordComponentPoolingMode} for an overview of how best to
     * optimize use of <code>recordComponents</code> for different data sets. <p> Regardless of the pooling mode, you can
     * explicitly refresh record components via {@link com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents
     * invalidateRecordComponents()} and {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent
     * refreshRecordComponent()}. <P> <i>Interaction with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths column auto-fit}</i>: per-cell record components are not
     * taken into account when determining the size for column auto fit. The default {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth getDefaultFieldWidth()} implementation looks at cell
     * content only. We typically recommend that, for fields showing record-components,  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanAutoFitWidth ListGridField.canAutoFitWidth} be disabled, or if  the
     * record components are of a predictable size, a {@link com.smartgwt.client.widgets.grid.ListGridField#getDefaultWidth
     * ListGridField.defaultWidth} be specified.<br> This is particularly pertinent where {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition} is set to "within", in
     * which case cells' content is often empty or completely covered by record-components.
     *
     * @return Current showRecordComponents value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * @see com.smartgwt.client.types.RecordComponentPoolingMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#showRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     */
    public Boolean getShowRecordComponents()  {
        return getAttributeAsBoolean("showRecordComponents");
    }
    

    /**
     * If true, shows {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents} in cells,
     * rather than just in records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRecordComponentsByCell New showRecordComponentsByCell value. Default value is null
     */
    public void setShowRecordComponentsByCell(Boolean showRecordComponentsByCell) {
        if(showRecordComponentsByCell) setRecordComponentPosition(EmbeddedPosition.WITHIN);
        setAttribute("showRecordComponentsByCell", showRecordComponentsByCell, true);
    }

    /**
     * If true, shows {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents} in cells,
     * rather than just in records.
     *
     * @return Current showRecordComponentsByCell value. Default value is null
     */
    public Boolean getShowRecordComponentsByCell()  {
        return getAttributeAsBoolean("showRecordComponentsByCell");
    }
    

    /**
     * Should we show different styling for the cell the mouse is over? <p> If true, the cell style will have the suffix "Over"
     * appended. <p> Can be overridden on a per-record basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getShowRollOver ListGridRecord.showRollOver}.
     *
     * @param showRollOver New showRollOver value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setShowRollOver(Boolean showRollOver) {
        setAttribute("showRollOver", showRollOver, true);
    }

    /**
     * Should we show different styling for the cell the mouse is over? <p> If true, the cell style will have the suffix "Over"
     * appended. <p> Can be overridden on a per-record basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getShowRollOver ListGridRecord.showRollOver}.
     *
     * @return Current showRollOver value. Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getShowRollOver()  {
        Boolean result = getAttributeAsBoolean("showRollOver");
        return result == null ? true : result;
    }
    

    /**
     * When enabled, when the mouse moves over a row or cell (depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers}), an arbitrary Canvas can be shown
     * layered on top of the row or cell (the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas
     * rollOverCanvas}), layered underneath the row or cell (the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas}), or both.  <P> This can be used to
     * dynamically show controls or informational displays only on rollover.  For example, controls to delete a row might
     * appear only on rollover so they do not clutter the static display, or a "rollUnder" Canvas could be used to display
     * additional information that can appear behind normal cell values (like displaying percent complete via as a bar of color
     * that appears behind text values). <p> {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo positioning} can be
     * used to place the rollOver/rollUnderCanvas.  With <code>useCellRollOvers</code>, positioning is relative to the cell,
     * for row-level rollOver, position is relative to the portion of the row that is scrolled into view (this implies a
     * row-level rollOver/UnderCanvas can never be placed horizontally scrolled out of view, but this is possible for a
     * cell-level rollOver).   <p> <code>snapTo</code> positioning makes it easy to do something like place a button at the
     * right edge of the grid, next to the scrollbar: just set snapTo:"R" on the <code>rollOverCanvas</code>. <p> The
     * rollOver/rollUnder Canvas can be a single static component (the same for all cells/rows) configured via the {@link
     * com.smartgwt.client.types.AutoChild} system, or can instead be provided dynamically by implementing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas getRollOverCanvas()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas getRollUnderCanvas()}. <p> The rollOver/rollUnder canvas
     * will be automatically added to the grid's {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} as an  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent embedded component}.<br> For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the behavior is as follows: <ul><li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers} is false (the default), embedded
     * components   will be added to both the body and the frozen body</li> <li>Otherwise the component will be added to
     * whichever body contains the cell the   user is currently over</li></ul> The rollOver/rollUnder canvas added to the
     * frozen body will be created by calling the {@link com.smartgwt.client.widgets.grid.ListGrid#getFrozenRollOverCanvas
     * getFrozenRollOverCanvas()} or {@link com.smartgwt.client.widgets.grid.ListGrid#getFrozenRollUnderCanvas
     * getFrozenRollUnderCanvas()} methods. The default implementation for these methods matches their equivalents for
     * non-frozen rollOver / rollUnder canvases - it will use the autoChild subsystem to create a canvas from the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} autoChild configuration. <p>
     * <code>showRollOverCanvas</code> has no effect if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver
     * showRollOver} is <code>false</code>. <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedRollOverCanvas showSelectedRollOverCanvas}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRollOverCanvas New showRollOverCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRollUnderCanvas
     * 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_rollover_controls" target="examples">RollOver Controls Example</a>
     */
    public void setShowRollOverCanvas(Boolean showRollOverCanvas) {
        setAttribute("showRollOverCanvas", showRollOverCanvas, true);
    }

    /**
     * When enabled, when the mouse moves over a row or cell (depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers}), an arbitrary Canvas can be shown
     * layered on top of the row or cell (the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas
     * rollOverCanvas}), layered underneath the row or cell (the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas}), or both.  <P> This can be used to
     * dynamically show controls or informational displays only on rollover.  For example, controls to delete a row might
     * appear only on rollover so they do not clutter the static display, or a "rollUnder" Canvas could be used to display
     * additional information that can appear behind normal cell values (like displaying percent complete via as a bar of color
     * that appears behind text values). <p> {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo positioning} can be
     * used to place the rollOver/rollUnderCanvas.  With <code>useCellRollOvers</code>, positioning is relative to the cell,
     * for row-level rollOver, position is relative to the portion of the row that is scrolled into view (this implies a
     * row-level rollOver/UnderCanvas can never be placed horizontally scrolled out of view, but this is possible for a
     * cell-level rollOver).   <p> <code>snapTo</code> positioning makes it easy to do something like place a button at the
     * right edge of the grid, next to the scrollbar: just set snapTo:"R" on the <code>rollOverCanvas</code>. <p> The
     * rollOver/rollUnder Canvas can be a single static component (the same for all cells/rows) configured via the {@link
     * com.smartgwt.client.types.AutoChild} system, or can instead be provided dynamically by implementing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas getRollOverCanvas()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas getRollUnderCanvas()}. <p> The rollOver/rollUnder canvas
     * will be automatically added to the grid's {@link com.smartgwt.client.widgets.grid.ListGrid#getBody body} as an  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent embedded component}.<br> For grids with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the behavior is as follows: <ul><li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers} is false (the default), embedded
     * components   will be added to both the body and the frozen body</li> <li>Otherwise the component will be added to
     * whichever body contains the cell the   user is currently over</li></ul> The rollOver/rollUnder canvas added to the
     * frozen body will be created by calling the {@link com.smartgwt.client.widgets.grid.ListGrid#getFrozenRollOverCanvas
     * getFrozenRollOverCanvas()} or {@link com.smartgwt.client.widgets.grid.ListGrid#getFrozenRollUnderCanvas
     * getFrozenRollUnderCanvas()} methods. The default implementation for these methods matches their equivalents for
     * non-frozen rollOver / rollUnder canvases - it will use the autoChild subsystem to create a canvas from the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} autoChild configuration. <p>
     * <code>showRollOverCanvas</code> has no effect if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver
     * showRollOver} is <code>false</code>. <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedRollOverCanvas showSelectedRollOverCanvas}.
     *
     * @return Current showRollOverCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRollUnderCanvas
     * 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_rollover_controls" target="examples">RollOver Controls Example</a>
     */
    public Boolean getShowRollOverCanvas()  {
        return getAttributeAsBoolean("showRollOverCanvas");
    }
    

    /**
     * This setting causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas roll over canvas} to be sized
     * to cover the normal row and the expansion layout. Otherwise the rollOverCanvas is only shown for the un-expanded part of
     * the row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRollOverInExpansion New showRollOverInExpansion value. Default value is null
     */
    public void setShowRollOverInExpansion(Boolean showRollOverInExpansion) {
        setAttribute("showRollOverInExpansion", showRollOverInExpansion, true);
    }

    /**
     * This setting causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas roll over canvas} to be sized
     * to cover the normal row and the expansion layout. Otherwise the rollOverCanvas is only shown for the un-expanded part of
     * the row.
     *
     * @return Current showRollOverInExpansion value. Default value is null
     */
    public Boolean getShowRollOverInExpansion()  {
        return getAttributeAsBoolean("showRollOverInExpansion");
    }
    

    /**
     * If roll overs are enabled, should the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas
     * rollUnderCanvas} be displayed? <p> Use of the <code>showRollUnderCanvas</code> is enabled if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is <code>true</code>, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas showRollOverCanvas} is <code>true</code> and
     * <code>showRollUnderCanvas</code> is unset, or <code>showRollUnderCanvas</code> is explicitly set to <code>true</code>.
     * <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedRollUnderCanvas
     * showSelectedRollUnderCanvas}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRollUnderCanvas New showRollUnderCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRollOverCanvas
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public void setShowRollUnderCanvas(Boolean showRollUnderCanvas) {
        setAttribute("showRollUnderCanvas", showRollUnderCanvas, true);
    }

    /**
     * If roll overs are enabled, should the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas
     * rollUnderCanvas} be displayed? <p> Use of the <code>showRollUnderCanvas</code> is enabled if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is <code>true</code>, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas showRollOverCanvas} is <code>true</code> and
     * <code>showRollUnderCanvas</code> is unset, or <code>showRollUnderCanvas</code> is explicitly set to <code>true</code>.
     * <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedRollUnderCanvas
     * showSelectedRollUnderCanvas}.
     *
     * @return Current showRollUnderCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getShowRollUnderCanvas()  {
        return getAttributeAsBoolean("showRollUnderCanvas");
    }
    

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) that displays the
     * current rowNum for each record.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRowNumbers New showRowNumbers value. Default value is null
     */
    public void setShowRowNumbers(Boolean showRowNumbers) {
        setAttribute("showRowNumbers", showRowNumbers, true);
    }

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) that displays the
     * current rowNum for each record.
     *
     * @return Current showRowNumbers value. Default value is null
     */
    public Boolean getShowRowNumbers()  {
        return getAttributeAsBoolean("showRowNumbers");
    }
    

    /**
     * This setting causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas roll over canvas} to be
     * displayed when the user rolls over selected records in the grid (but not when rolling over other records). This can be
     * useful to display a "Selected Over" appearance which can't be easily achieved via standard cell styling.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSelectedRollOverCanvas New showSelectedRollOverCanvas value. Default value is false
     */
    public void setShowSelectedRollOverCanvas(Boolean showSelectedRollOverCanvas) {
        setAttribute("showSelectedRollOverCanvas", showSelectedRollOverCanvas, true);
    }

    /**
     * This setting causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas roll over canvas} to be
     * displayed when the user rolls over selected records in the grid (but not when rolling over other records). This can be
     * useful to display a "Selected Over" appearance which can't be easily achieved via standard cell styling.
     *
     * @return Current showSelectedRollOverCanvas value. Default value is false
     */
    public Boolean getShowSelectedRollOverCanvas()  {
        Boolean result = getAttributeAsBoolean("showSelectedRollOverCanvas");
        return result == null ? false : result;
    }
    

    /**
     * This setting causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas roll under canvas} to be
     * displayed when the user rolls over selected records in the grid (but not when rolling over other records). This can be
     * useful to display a "Selected Over" appearance which can't be easily achieved via standard cell styling. <P> As with
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollUnderCanvas showRollUnderCanvas}, if this property is unset,
     * but the related {@link com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedRollOverCanvas
     * showSelectedRollOverCanvas} property is true, both the the roll under and roll under canvases will be displayed as the
     * user rolls  over selected records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSelectedRollUnderCanvas New showSelectedRollUnderCanvas value. Default value is false
     */
    public void setShowSelectedRollUnderCanvas(Boolean showSelectedRollUnderCanvas) {
        setAttribute("showSelectedRollUnderCanvas", showSelectedRollUnderCanvas, true);
    }

    /**
     * This setting causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas roll under canvas} to be
     * displayed when the user rolls over selected records in the grid (but not when rolling over other records). This can be
     * useful to display a "Selected Over" appearance which can't be easily achieved via standard cell styling. <P> As with
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRollUnderCanvas showRollUnderCanvas}, if this property is unset,
     * but the related {@link com.smartgwt.client.widgets.grid.ListGrid#getShowSelectedRollOverCanvas
     * showSelectedRollOverCanvas} property is true, both the the roll under and roll under canvases will be displayed as the
     * user rolls  over selected records.
     *
     * @return Current showSelectedRollUnderCanvas value. Default value is false
     */
    public Boolean getShowSelectedRollUnderCanvas()  {
        Boolean result = getAttributeAsBoolean("showSelectedRollUnderCanvas");
        return result == null ? false : result;
    }
    

    /**
     * Should the "Selected" style be applied to selected records?
     *
     * @param showSelectedStyle New showSelectedStyle value. Default value is true
     */
    public void setShowSelectedStyle(Boolean showSelectedStyle) {
        setAttribute("showSelectedStyle", showSelectedStyle, true);
    }

    /**
     * Should the "Selected" style be applied to selected records?
     *
     * @return Current showSelectedStyle value. Default value is true
     */
    public Boolean getShowSelectedStyle()  {
        Boolean result = getAttributeAsBoolean("showSelectedStyle");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, setting this property to <code>true</code> means selection will be
     * displayed to the user with the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas}
     * and/or {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with
     * CSS styling. <p> If <code>showSelectionCanvas</code> is set to <code>true</code>, then the
     * <code>selectionUnderCanvas</code> will automatically be enabled unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionUnderCanvas showSelectionUnderCanvas} is set to
     * <code>false</code>. <p> NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the
     * <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is stacked on top of the selected
     * record and this may interfere with event handling in rare cases. If no interactive components are shown in the
     * <code>selectionCanvas</code> and it simply provides custom styling, then the <code>selectionUnderCanvas</code> should be
     * used instead. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen fields}, the
     * <code>selectionCanvas</code> is displayed only over the non-frozen fields of the selected row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSelectionCanvas New showSelectionCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowSelectionUnderCanvas
     */
    public void setShowSelectionCanvas(Boolean showSelectionCanvas) {
        setAttribute("showSelectionCanvas", showSelectionCanvas, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, setting this property to <code>true</code> means selection will be
     * displayed to the user with the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas}
     * and/or {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with
     * CSS styling. <p> If <code>showSelectionCanvas</code> is set to <code>true</code>, then the
     * <code>selectionUnderCanvas</code> will automatically be enabled unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionUnderCanvas showSelectionUnderCanvas} is set to
     * <code>false</code>. <p> NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the
     * <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is stacked on top of the selected
     * record and this may interfere with event handling in rare cases. If no interactive components are shown in the
     * <code>selectionCanvas</code> and it simply provides custom styling, then the <code>selectionUnderCanvas</code> should be
     * used instead. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen fields}, the
     * <code>selectionCanvas</code> is displayed only over the non-frozen fields of the selected row.
     *
     * @return Current showSelectionCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionUnderCanvas
     */
    public Boolean getShowSelectionCanvas()  {
        return getAttributeAsBoolean("showSelectionCanvas");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionCanvas showSelectionCanvas} is <code>true</code> and
     * <code>showSelectionUnderCanvas</code> is unset, or <code>showSelectionUnderCanvas</code> is explicitly set to
     * <code>true</code>, then selection will be displayed to the user with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with CSS styling.
     * Setting <code>showSelectionUnderCanvas</code> to <code>false</code> will disable the use of the
     * <code>selectionUnderCanvas</code>. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen
     * fields}, the <code>selectionUnderCanvas</code> is displayed only behind the non-frozen fields of the selected row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSelectionUnderCanvas New showSelectionUnderCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowSelectionCanvas
     * 
     */
    public void setShowSelectionUnderCanvas(Boolean showSelectionUnderCanvas) {
        setAttribute("showSelectionUnderCanvas", showSelectionUnderCanvas, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionCanvas showSelectionCanvas} is <code>true</code> and
     * <code>showSelectionUnderCanvas</code> is unset, or <code>showSelectionUnderCanvas</code> is explicitly set to
     * <code>true</code>, then selection will be displayed to the user with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with CSS styling.
     * Setting <code>showSelectionUnderCanvas</code> to <code>false</code> will disable the use of the
     * <code>selectionUnderCanvas</code>. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen
     * fields}, the <code>selectionUnderCanvas</code> is displayed only behind the non-frozen fields of the selected row.
     *
     * @return Current showSelectionUnderCanvas value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionCanvas
     * 
     */
    public Boolean getShowSelectionUnderCanvas()  {
        return getAttributeAsBoolean("showSelectionUnderCanvas");
    }
    

    /**
     * Indicates whether a sorting arrow should appear for the listGrid, and its location. See {@link
     * com.smartgwt.client.types.SortArrow} for details. <P> Clicking the sort arrow reverses the direction of sorting for the
     * current sort column (if any), or sorts the listGrid by its first sortable column. The arrow image on the button
     * indicates the current direction of sorting. If undefined, the sort arrow will show up in the sorted field, and the
     * corner sort button will be displayed if a vertical scrollbar is being displayed
     *
     * @param showSortArrow New showSortArrow value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setShowSortArrow(SortArrow showSortArrow) {
        setAttribute("showSortArrow", showSortArrow == null ? null : showSortArrow.getValue(), true);
    }

    /**
     * Indicates whether a sorting arrow should appear for the listGrid, and its location. See {@link
     * com.smartgwt.client.types.SortArrow} for details. <P> Clicking the sort arrow reverses the direction of sorting for the
     * current sort column (if any), or sorts the listGrid by its first sortable column. The arrow image on the button
     * indicates the current direction of sorting. If undefined, the sort arrow will show up in the sorted field, and the
     * corner sort button will be displayed if a vertical scrollbar is being displayed
     *
     * @return Current showSortArrow value. Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public SortArrow getShowSortArrow()  {
        return EnumUtil.getEnum(SortArrow.values(), getAttribute("showSortArrow"));
    }
    

    /**
     * When multiple fields are sorted, set this to false to hide the sort-numeral displayed by default after the sort-arrows
     * in the header-buttons of sorted fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSortNumerals New showSortNumerals value. Default value is null
     */
    public void setShowSortNumerals(Boolean showSortNumerals) {
        setAttribute("showSortNumerals", showSortNumerals, true);
    }

    /**
     * When multiple fields are sorted, set this to false to hide the sort-numeral displayed by default after the sort-arrows
     * in the header-buttons of sorted fields.
     *
     * @return Current showSortNumerals value. Default value is null
     */
    public Boolean getShowSortNumerals()  {
        return getAttributeAsBoolean("showSortNumerals");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are in use, whether to show a
     * hierarchical column picker that includes both headerSpans and normal headers, with normal headers indented under
     * headerSpans similarly to how a {@link com.smartgwt.client.widgets.tree.TreeGrid} displays a Tree. <P> If
     * <code>showTreeColumnPicker</code> is false, no column picker will be shown on the headerSpan itself, and the column
     * picker for a clicked on a normal field header will include only normal fields.
     *
     * @param showTreeColumnPicker New showTreeColumnPicker value. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowTreeColumnPicker(Boolean showTreeColumnPicker)  throws IllegalStateException {
        setAttribute("showTreeColumnPicker", showTreeColumnPicker, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are in use, whether to show a
     * hierarchical column picker that includes both headerSpans and normal headers, with normal headers indented under
     * headerSpans similarly to how a {@link com.smartgwt.client.widgets.tree.TreeGrid} displays a Tree. <P> If
     * <code>showTreeColumnPicker</code> is false, no column picker will be shown on the headerSpan itself, and the column
     * picker for a clicked on a normal field header will include only normal fields.
     *
     * @return Current showTreeColumnPicker value. Default value is true
     */
    public Boolean getShowTreeColumnPicker()  {
        Boolean result = getAttributeAsBoolean("showTreeColumnPicker");
        return result == null ? true : result;
    }
    

    /**
     * If this list grid is showing any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen} fields, and a
     * horizontal scrollbar is visible at the bottom of the liquid columns, should an equivalent scrollbar gap be left visible
     * below the frozen columns?<br> Note that if set to <code>true</code> any backgroundColor or border applied to the
     * ListGrid will show up below the bottom row of the frozen column(s).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param shrinkForFreeze New shrinkForFreeze value. Default value is false
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setShrinkForFreeze(Boolean shrinkForFreeze) {
        setAttribute("shrinkForFreeze", shrinkForFreeze, true);
    }

    /**
     * If this list grid is showing any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen} fields, and a
     * horizontal scrollbar is visible at the bottom of the liquid columns, should an equivalent scrollbar gap be left visible
     * below the frozen columns?<br> Note that if set to <code>true</code> any backgroundColor or border applied to the
     * ListGrid will show up below the bottom row of the frozen column(s).
     *
     * @return Current shrinkForFreeze value. Default value is false
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public Boolean getShrinkForFreeze()  {
        Boolean result = getAttributeAsBoolean("shrinkForFreeze");
        return result == null ? false : result;
    }
    

    /**
     * If <code>record[this.singleCellValueProperty]</code> is set for some record, the record will be displayed as a single
     * cell spanning every column in the grid, with contents set to the value of
     * <code>record[this.singleCellValueProperty]</code>.
     *
     * @param singleCellValueProperty New singleCellValueProperty value. Default value is "singleCellValue"
     */
    public void setSingleCellValueProperty(String singleCellValueProperty) {
        setAttribute("singleCellValueProperty", singleCellValueProperty, true);
    }

    /**
     * If <code>record[this.singleCellValueProperty]</code> is set for some record, the record will be displayed as a single
     * cell spanning every column in the grid, with contents set to the value of
     * <code>record[this.singleCellValueProperty]</code>.
     *
     * @return Current singleCellValueProperty value. Default value is "singleCellValue"
     */
    public String getSingleCellValueProperty()  {
        return getAttributeAsString("singleCellValueProperty");
    }
    

    /**
     * Where do 'skin' images (those provided with the class) live?
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param skinImgDir New skinImgDir value. Default value is "images/ListGrid/"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Images Images overview and related methods
     */
    public void setSkinImgDir(String skinImgDir) {
        setAttribute("skinImgDir", skinImgDir, true);
    }

    /**
     * Where do 'skin' images (those provided with the class) live?
     *
     * @return Current skinImgDir value. Default value is "images/ListGrid/"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     * @see com.smartgwt.client.docs.Images Images overview and related methods
     */
    public String getSkinImgDir()  {
        return getAttributeAsString("skinImgDir");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace leaveHeaderMenuButtonSpace} is true,
     * configures the amount of space beyond the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonWidth
     * headerMenuButtonWidth} on the right side of a ListGrid header button (left for {@link
     * com.smartgwt.client.util.Page#isRTL RTL mode}) to reserve for the sort arrow if sorting is active for that field and the
     * arrow will be shown.  May be increased for more separation between the sort arrow and the title text, at the expense of
     * a reduced space for the title text. <P> This value may need to be customized in your skin or if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortAscendingImage sortAscendingImage} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortDescendingImage sortDescendingImage} are changed.
     *
     * @param sortArrowMenuButtonSpaceOffset New sortArrowMenuButtonSpaceOffset value. Default value is 7
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortNumeralMenuButtonSpaceOffset
     */
    public void setSortArrowMenuButtonSpaceOffset(int sortArrowMenuButtonSpaceOffset) {
        setAttribute("sortArrowMenuButtonSpaceOffset", sortArrowMenuButtonSpaceOffset, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace leaveHeaderMenuButtonSpace} is true,
     * configures the amount of space beyond the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonWidth
     * headerMenuButtonWidth} on the right side of a ListGrid header button (left for {@link
     * com.smartgwt.client.util.Page#isRTL RTL mode}) to reserve for the sort arrow if sorting is active for that field and the
     * arrow will be shown.  May be increased for more separation between the sort arrow and the title text, at the expense of
     * a reduced space for the title text. <P> This value may need to be customized in your skin or if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortAscendingImage sortAscendingImage} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortDescendingImage sortDescendingImage} are changed.
     *
     * @return Current sortArrowMenuButtonSpaceOffset value. Default value is 7
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortNumeralMenuButtonSpaceOffset
     */
    public int getSortArrowMenuButtonSpaceOffset()  {
        return getAttributeAsInt("sortArrowMenuButtonSpaceOffset");
    }
    

    /**
     * Image to show when sorting ascending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortAscendingImage New sortAscendingImage value. Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortArrowMenuButtonSpaceOffset
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSortAscendingImage(ImgProperties sortAscendingImage) {
        setAttribute("sortAscendingImage", sortAscendingImage == null ? null : sortAscendingImage.getJsObj(), true);
    }

    /**
     * Image to show when sorting ascending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     *
     * @return Current sortAscendingImage value. Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortArrowMenuButtonSpaceOffset
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ImgProperties getSortAscendingImage()  {
        return new ImgProperties(getAttributeAsJavaScriptObject("sortAscendingImage"));
    }
    

    /**
     * For any fields of {@link com.smartgwt.client.types.FieldType type "binary"}, should sorting be performed against the
     * fileName of the value for the field? For Smart GWT server backed dataSources, this is applied to the record
     * automatically as described in the {@link com.smartgwt.client.docs.BinaryFields} overview. <P> If set to false, binary
     * fields will be sorted against the record value for the field in question. Client-side sorting does not support this, so
     * developers who actually want to support a sort against the binary itself would typically set {@link
     * com.smartgwt.client.data.ResultSet#getUseClientSorting ResultSet.useClientSorting} to false on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataProperties dataProperties} block for this grid. <P> Note that this
     * setting will have no effect if {@link com.smartgwt.client.data.DataSourceField#getSortByField
     * DataSourceField.sortByField} is specified
     *
     * @param sortBinaryByFileName New sortBinaryByFileName value. Default value is true
     */
    public void setSortBinaryByFileName(boolean sortBinaryByFileName) {
        setAttribute("sortBinaryByFileName", sortBinaryByFileName, true);
    }

    /**
     * For any fields of {@link com.smartgwt.client.types.FieldType type "binary"}, should sorting be performed against the
     * fileName of the value for the field? For Smart GWT server backed dataSources, this is applied to the record
     * automatically as described in the {@link com.smartgwt.client.docs.BinaryFields} overview. <P> If set to false, binary
     * fields will be sorted against the record value for the field in question. Client-side sorting does not support this, so
     * developers who actually want to support a sort against the binary itself would typically set {@link
     * com.smartgwt.client.data.ResultSet#getUseClientSorting ResultSet.useClientSorting} to false on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataProperties dataProperties} block for this grid. <P> Note that this
     * setting will have no effect if {@link com.smartgwt.client.data.DataSourceField#getSortByField
     * DataSourceField.sortByField} is specified
     *
     * @return Current sortBinaryByFileName value. Default value is true
     */
    public boolean getSortBinaryByFileName()  {
        Boolean result = getAttributeAsBoolean("sortBinaryByFileName");
        return result == null ? true : result;
    }
    

    /**
     * If set, whenever grouping is performed by an end user or by a programmatic call to  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}, data is implicitly sorted by all of the grouped columns,
     * in the order  they were passed to groupBy. Any user-configured sorting is applied after sorting by  grouped columns. <p>
     * Sorting by grouped fields will be in ascending or descending order according to whether  the grid is currently sorted
     * (by any field) in ascending or descending order, defaulting  to ascending if the grid is not sorted. Implicit sorting by
     * group can be forced to be  always ascending or always descending by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupSortDirection groupSortDirection}. <p> The sorting is "implicit" in
     * the sense that the sorting is not shown in the ListGrid  headers, and not shown in the {@link
     * com.smartgwt.client.widgets.MultiSortDialog} if enabled.  An end user cannot  currently remove the implicit sorting
     * themselves (except by removing the grouping),  though it is possible to override it by providing an explicit sort on the
     * group's column. Clicking on the grouped field's header reveals the usual sort indicators with all the same semantics.
     * <p> The correct way to remove implicit sorting programmatically is to call  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSortByGroupFirst setSortByGroupFirst(false)}. <p> Programmatic calls to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSort getSort()} will not include the implicit sort in  the list of
     * return sort specifiers, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()} will implicitly
     * add  the sorting by grouped columns before the specified sort. <p> Note that directly calling ResultSet.getSort() will
     * include the implicit sort  information.
     *
     * @param sortByGroupFirst New sortByGroupFirst value. Default value is null
     */
    public void setSortByGroupFirst(Boolean sortByGroupFirst) {
        setAttribute("sortByGroupFirst", sortByGroupFirst, true);
    }

    /**
     * If set, whenever grouping is performed by an end user or by a programmatic call to  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy groupBy()}, data is implicitly sorted by all of the grouped columns,
     * in the order  they were passed to groupBy. Any user-configured sorting is applied after sorting by  grouped columns. <p>
     * Sorting by grouped fields will be in ascending or descending order according to whether  the grid is currently sorted
     * (by any field) in ascending or descending order, defaulting  to ascending if the grid is not sorted. Implicit sorting by
     * group can be forced to be  always ascending or always descending by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupSortDirection groupSortDirection}. <p> The sorting is "implicit" in
     * the sense that the sorting is not shown in the ListGrid  headers, and not shown in the {@link
     * com.smartgwt.client.widgets.MultiSortDialog} if enabled.  An end user cannot  currently remove the implicit sorting
     * themselves (except by removing the grouping),  though it is possible to override it by providing an explicit sort on the
     * group's column. Clicking on the grouped field's header reveals the usual sort indicators with all the same semantics.
     * <p> The correct way to remove implicit sorting programmatically is to call  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSortByGroupFirst setSortByGroupFirst(false)}. <p> Programmatic calls to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSort getSort()} will not include the implicit sort in  the list of
     * return sort specifiers, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()} will implicitly
     * add  the sorting by grouped columns before the specified sort. <p> Note that directly calling ResultSet.getSort() will
     * include the implicit sort  information.
     *
     * @return Current sortByGroupFirst value. Default value is null
     */
    public Boolean getSortByGroupFirst()  {
        return getAttributeAsBoolean("sortByGroupFirst");
    }
    

    /**
     * Image to show when sorting descending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortDescendingImage New sortDescendingImage value. Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortArrowMenuButtonSpaceOffset
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSortDescendingImage(ImgProperties sortDescendingImage) {
        setAttribute("sortDescendingImage", sortDescendingImage == null ? null : sortDescendingImage.getJsObj(), true);
    }

    /**
     * Image to show when sorting descending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     *
     * @return Current sortDescendingImage value. Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortArrowMenuButtonSpaceOffset
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ImgProperties getSortDescendingImage()  {
        return new ImgProperties(getAttributeAsJavaScriptObject("sortDescendingImage"));
    }
    

    /**
     * Sorting direction of this ListGrid. If specified when the ListGrid is initialized, this property will be the default
     * sorting direction for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField sortField}. May be overridden by
     * specifying {@link com.smartgwt.client.widgets.grid.ListGridField#getSortDirection ListGridField.sortDirection}. <P>
     * After initialization, this property will be updated on {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort()} or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()} to reflect the current sort direction of the grid.
     * When this grid is sorted by multiple fields, the grid's sortDirection reflects the sort direction of the primary sort
     * field.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sort this grid's data, with the option to explicitly specify a single field to sort by and sort direction. <P> If sortField is not provided and listGrid.sortField is undefined, the data will be sorted by the first sortable column according to {@link com.smartgwt.client.widgets.grid.ListGridField#getSortDirection ListGridField.sortDirection} if specified, or {@link com.smartgwt.client.widgets.grid.ListGrid#getSortDirection sortDirection}. <P> ListGrids also support multiple-field sorting. See {@link com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()} for details. <P> Note that for editable grids, sorting is performed by underlying data values, not for unsaved {@link com.smartgwt.client.widgets.grid.ListGrid#getEditValues pending edit values}.
     *
     * @param sortDirection the field name or column number to sort by. Default value is "ascending"
     * @see com.smartgwt.client.types.SortDirection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public void setSortDirection(SortDirection sortDirection) {
        setAttribute("sortDirection", sortDirection == null ? null : sortDirection.getValue(), true);
    }

    /**
     * Sorting direction of this ListGrid. If specified when the ListGrid is initialized, this property will be the default
     * sorting direction for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField sortField}. May be overridden by
     * specifying {@link com.smartgwt.client.widgets.grid.ListGridField#getSortDirection ListGridField.sortDirection}. <P>
     * After initialization, this property will be updated on {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort()} or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()} to reflect the current sort direction of the grid.
     * When this grid is sorted by multiple fields, the grid's sortDirection reflects the sort direction of the primary sort
     * field.
     *
     * @return Current sortDirection value. Default value is "ascending"
     * @see com.smartgwt.client.types.SortDirection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public SortDirection getSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("sortDirection"));
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInSortEditor showHeaderSpanTitlesInSortEditor} is true,
     * this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid on the {@link
     * com.smartgwt.client.widgets.MultiSortDialog multi-sort editor}
     *
     * @param sortEditorSpanTitleSeparator New sortEditorSpanTitleSeparator value. Default value is " - "
     */
    public void setSortEditorSpanTitleSeparator(String sortEditorSpanTitleSeparator) {
        setAttribute("sortEditorSpanTitleSeparator", sortEditorSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInSortEditor showHeaderSpanTitlesInSortEditor} is true,
     * this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid on the {@link
     * com.smartgwt.client.widgets.MultiSortDialog multi-sort editor}
     *
     * @return Current sortEditorSpanTitleSeparator value. Default value is " - "
     */
    public String getSortEditorSpanTitleSeparator()  {
        return getAttributeAsString("sortEditorSpanTitleSeparator");
    }
    

    /**
     * The title for the corner sort button.  The title will only  ListGrid.changeDefaults() rather than replacing with an
     * entirely new object.
     *
     * @param sorterButtonTitle New sorterButtonTitle value. Default value is "corner menu"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSorterButtonTitle(String sorterButtonTitle)  throws IllegalStateException {
        setAttribute("sorterButtonTitle", sorterButtonTitle, false);
    }

    /**
     * The title for the corner sort button.  The title will only  ListGrid.changeDefaults() rather than replacing with an
     * entirely new object.
     *
     * @return Current sorterButtonTitle value. Default value is "corner menu"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getSorterButtonTitle()  {
        return getAttributeAsString("sorterButtonTitle");
    }
    
    
    
    

    /**
     * Specifies the field by which this grid should be initially sorted. Can be set to either a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getName field name} or the index of the field in the fields Array. <P>
     * ListGrids also support being initialized with multiple-field sort via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getInitialSort initialSort}. If initialSort is specified, it will be used in
     * preference to this property. <P> To sort the grid after it has been initialized, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#sort sort()} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort()}. Details about the current sort of a live grid can be retrieved by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortField getSortField()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort getSort()}
     *
     * @param sortField New sortField value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public void setSortField(String sortField)  throws IllegalStateException {
        setAttribute("sortField", sortField, false);
    }

    /**
     * Specifies the field by which this grid should be initially sorted. Can be set to either a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getName field name} or the index of the field in the fields Array. <P>
     * ListGrids also support being initialized with multiple-field sort via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getInitialSort initialSort}. If initialSort is specified, it will be used in
     * preference to this property. <P> To sort the grid after it has been initialized, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#sort sort()} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort()}. Details about the current sort of a live grid can be retrieved by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortField getSortField()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort getSort()}
     *
     * @return Returns the current sort field for this grid. Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort()} has been used to sort by multiple fields, you can call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort getSort()} to retrieve details about the complete sort applied to the
     * grid. Default value is null
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public String getSortField()  {
        return getAttributeAsString("sortField");
    }

    /**
     * Specifies the field by which this grid should be initially sorted. Can be set to either a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getName field name} or the index of the field in the fields Array. <P>
     * ListGrids also support being initialized with multiple-field sort via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getInitialSort initialSort}. If initialSort is specified, it will be used in
     * preference to this property. <P> To sort the grid after it has been initialized, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#sort sort()} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort()}. Details about the current sort of a live grid can be retrieved by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortField getSortField()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort getSort()}
     *
     * @param sortField New sortField value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public void setSortField(Integer sortField)  throws IllegalStateException {
        setAttribute("sortField", sortField, false);
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in ascending order.
     *
     * @param sortFieldAscendingText New sortFieldAscendingText value. Default value is "Sort Ascending"
     */
    public void setSortFieldAscendingText(String sortFieldAscendingText) {
        setAttribute("sortFieldAscendingText", sortFieldAscendingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in ascending order.
     *
     * @return Current sortFieldAscendingText value. Default value is "Sort Ascending"
     */
    public String getSortFieldAscendingText()  {
        return getAttributeAsString("sortFieldAscendingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in descending order.
     *
     * @param sortFieldDescendingText New sortFieldDescendingText value. Default value is "Sort Descending"
     */
    public void setSortFieldDescendingText(String sortFieldDescendingText) {
        setAttribute("sortFieldDescendingText", sortFieldDescendingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in descending order.
     *
     * @return Current sortFieldDescendingText value. Default value is "Sort Descending"
     */
    public String getSortFieldDescendingText()  {
        return getAttributeAsString("sortFieldDescendingText");
    }
    
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace leaveHeaderMenuButtonSpace} is true,
     * configures the amount of space beyond the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonWidth
     * headerMenuButtonWidth} on the right side of a ListGrid header button (left for {@link
     * com.smartgwt.client.util.Page#isRTL RTL mode}) to reserve for the sort numeral if  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sorting} is active for that field and the numeral will
     * be shown. May be increased for more separation between the title text and the sort arrow when  multi-sorting.   <P> Note
     * that larger values may required if 10 or more fields are sorted at once, as the numeral will occupy more space.  This
     * value may need to be customized in your skin or if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortAscendingImage sortAscendingImage} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortDescendingImage sortDescendingImage} are changed.
     *
     * @param sortNumeralMenuButtonSpaceOffset New sortNumeralMenuButtonSpaceOffset value. Default value is 9
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortArrowMenuButtonSpaceOffset
     */
    public void setSortNumeralMenuButtonSpaceOffset(int sortNumeralMenuButtonSpaceOffset) {
        setAttribute("sortNumeralMenuButtonSpaceOffset", sortNumeralMenuButtonSpaceOffset, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace leaveHeaderMenuButtonSpace} is true,
     * configures the amount of space beyond the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButtonWidth
     * headerMenuButtonWidth} on the right side of a ListGrid header button (left for {@link
     * com.smartgwt.client.util.Page#isRTL RTL mode}) to reserve for the sort numeral if  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sorting} is active for that field and the numeral will
     * be shown. May be increased for more separation between the title text and the sort arrow when  multi-sorting.   <P> Note
     * that larger values may required if 10 or more fields are sorted at once, as the numeral will occupy more space.  This
     * value may need to be customized in your skin or if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortAscendingImage sortAscendingImage} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSortDescendingImage sortDescendingImage} are changed.
     *
     * @return Current sortNumeralMenuButtonSpaceOffset value. Default value is 9
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortArrowMenuButtonSpaceOffset
     */
    public int getSortNumeralMenuButtonSpaceOffset()  {
        return getAttributeAsInt("sortNumeralMenuButtonSpaceOffset");
    }
    

    /**
     * When multiple fields are sorted, the Style to apply to the numeral that appears after the sort-arrows in the
     * header-buttons of sorted fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortNumeralStyle New sortNumeralStyle value. Default value is "sortNumeral"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setSortNumeralStyle(String sortNumeralStyle) {
        setAttribute("sortNumeralStyle", sortNumeralStyle, true);
    }

    /**
     * When multiple fields are sorted, the Style to apply to the numeral that appears after the sort-arrows in the
     * header-buttons of sorted fields.
     *
     * @return Current sortNumeralStyle value. Default value is "sortNumeral"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getSortNumeralStyle()  {
        return getAttributeAsString("sortNumeralStyle");
    }
    

    /**
     * Initial sort state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>sortState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>sortState</code> has priority for sort state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's sort state (sort field and direction or list of {@link com.smartgwt.client.data.SortSpecifier}s) to match the {@link com.smartgwt.client.docs.ListGridSortState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getSortState getSortState()}.
     *
     * @param sortState Object describing the desired sort state for the grid. Default value is null
     * @see com.smartgwt.client.docs.ListGridSortState ListGridSortState 
     */
    public void setSortState(String sortState) {
        setAttribute("sortState", sortState, true);
    }

    /**
     * Initial sort state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>sortState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>sortState</code> has priority for sort state.
     *
     * @return Returns a snapshot of the current sort state within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSortState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSortState setSortState()} to reset this grid's sort to the current state
     * (assuming the same fields are present in the grid).<br>. Default value is null
     * @see com.smartgwt.client.docs.ListGridSortState ListGridSortState 
     */
    public String getSortState()  {
        return getAttributeAsString("sortState");
    }
    

    /**
     * The menu displayed when a cell is right clicked on.
     * <p>
     * This component is an AutoChild named "spanContextMenu".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current spanContextMenu value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Layout getSpanContextMenu() throws IllegalStateException {
        errorIfNotCreated("spanContextMenu");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("spanContextMenu"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle Button.baseStyle} to apply to the field header buttons for this
     * ListGrid when showing header spans. Note that, depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the header buttons, you may also need to
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle headerTitleStyle}.
     *
     * @param spannedHeaderBaseStyle New spannedHeaderBaseStyle value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSpannedHeaderBaseStyle(String spannedHeaderBaseStyle)  throws IllegalStateException {
        setAttribute("spannedHeaderBaseStyle", spannedHeaderBaseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle Button.baseStyle} to apply to the field header buttons for this
     * ListGrid when showing header spans. Note that, depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the header buttons, you may also need to
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle headerTitleStyle}.
     *
     * @return Current spannedHeaderBaseStyle value. Default value is null
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getSpannedHeaderBaseStyle()  {
        return getAttributeAsString("spannedHeaderBaseStyle");
    }
    

    /**
     * If this is an editable listGrid, this property determines how failure to save due to validation errors should be
     * displayed to the user. <P> If this property is true, when validation errors occur the errors will be displayed to the
     * user in an alert, and focus will be returned to the first cell to fail validation. <P> If false, the cells that failed
     * validation will be silently styled with the editFailedBaseStyle. <p> <b>Note:</b> stopOnErrors being set to true implies
     * that 'waitForSave' is also true. We will not dismiss the editor until save has completed if stopOnErrors is true.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param stopOnErrors New stopOnErrors value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setWaitForSave
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setStopOnErrors(Boolean stopOnErrors) {
        setAttribute("stopOnErrors", stopOnErrors, true);
    }

    /**
     * If this is an editable listGrid, this property determines how failure to save due to validation errors should be
     * displayed to the user. <P> If this property is true, when validation errors occur the errors will be displayed to the
     * user in an alert, and focus will be returned to the first cell to fail validation. <P> If false, the cells that failed
     * validation will be silently styled with the editFailedBaseStyle. <p> <b>Note:</b> stopOnErrors being set to true implies
     * that 'waitForSave' is also true. We will not dismiss the editor until save has completed if stopOnErrors is true.
     *
     * @return Current stopOnErrors value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getStopOnErrors()  {
        Boolean result = getAttributeAsBoolean("stopOnErrors");
        return result == null ? false : result;
    }
    

    /**
     * Default CSS class for the ListGrid as a whole.
     *
     * @param styleName New styleName value. Default value is "listGrid"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setStyleName(String styleName) {
        setAttribute("styleName", styleName, true);
    }

    /**
     * Default CSS class for the ListGrid as a whole.
     *
     * @return Current styleName value. Default value is "listGrid"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getStyleName()  {
        return getAttributeAsString("styleName");
    }
    

    /**
     * Automatically generated ListGrid for displaying grid summary information (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}). <P> This component is an {@link
     * com.smartgwt.client.types.AutoChild} and as such may be customized via <code>listGrid.summaryRowProperties</code> and
     * <code>listGrid.summaryRowDefaults</code>
     * <p>
     * This component is an AutoChild named "summaryRow".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current summaryRow value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGrid getSummaryRow() throws IllegalStateException {
        errorIfNotCreated("summaryRow");
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("summaryRow"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to specify fetch criteria to apply when retrieving summary data to show in the summary row. If unset, and any
     * filter criteria have been specified for the grid, they will be used. <p> If this property is set, the {@link
     * com.smartgwt.client.data.DSRequest#getTextMatchStyle textMatchStyle} will default to "exact".  Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} will be used.  This can be
     * overridden via {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties
     * summaryRowFetchRequestProperties}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowCriteria New summaryRowCriteria value. Default value is null
     */
    public void setSummaryRowCriteria(Criteria summaryRowCriteria) {
        if (summaryRowCriteria instanceof Criterion) {
            summaryRowCriteria.setAttribute("_constructor", "AdvancedCriteria");
        }
        setAttribute("summaryRowCriteria", summaryRowCriteria == null ? null : summaryRowCriteria.getJsObj(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to specify fetch criteria to apply when retrieving summary data to show in the summary row. If unset, and any
     * filter criteria have been specified for the grid, they will be used. <p> If this property is set, the {@link
     * com.smartgwt.client.data.DSRequest#getTextMatchStyle textMatchStyle} will default to "exact".  Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle} will be used.  This can be
     * overridden via {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties
     * summaryRowFetchRequestProperties}.
     *
     * @return Current summaryRowCriteria value. Default value is null
     */
    public Criteria getSummaryRowCriteria()  {
        return new Criteria(getAttributeAsJavaScriptObject("summaryRowCriteria"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, by default summary
     * values are calculated on the client based on the current data-set for the grid (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummary getGridSummary()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction getGridSummaryFunction()}). <P> In some cases however
     * it may make sense to calculate summary values on the server and retrieve them via a dataSource fetch. If set, this
     * property specifies a dataSource to fetch against for the summary row. The dataSource should return a single record with
     * summary data for each field for which summary data should be shown. Note that specifying this property completely
     * bypasses the standard client-side grid summary calculation logic. <P> The fetch may be further customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowCriteria summaryRowCriteria} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowDataSource New summaryRowDataSource value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setSummaryRowDataSource(DataSource summaryRowDataSource)  throws IllegalStateException {
        setAttribute("summaryRowDataSource", summaryRowDataSource == null ? null : summaryRowDataSource.getOrCreateJsObj(), false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, by default summary
     * values are calculated on the client based on the current data-set for the grid (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummary getGridSummary()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction getGridSummaryFunction()}). <P> In some cases however
     * it may make sense to calculate summary values on the server and retrieve them via a dataSource fetch. If set, this
     * property specifies a dataSource to fetch against for the summary row. The dataSource should return a single record with
     * summary data for each field for which summary data should be shown. Note that specifying this property completely
     * bypasses the standard client-side grid summary calculation logic. <P> The fetch may be further customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowCriteria summaryRowCriteria} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}
     *
     * @return Current summaryRowDataSource value. Default value is null
     */
    public DataSource getSummaryRowDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("summaryRowDataSource"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to customize the fetch request used when retrieving summary data to show in the summary row. An example use case
     * might be specifying a {@link com.smartgwt.client.data.DSRequest#getOperationId DSRequest.operationId} to perform a
     * custom fetch operation which retrieved only summary values based on criteria. <p> By default, only the first {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowCriteria criteria} match is returned if the criteria matches
     * multiple records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowFetchRequestProperties New summaryRowFetchRequestProperties value. Default value is null
     * @see com.smartgwt.client.data.DSRequest#setStartRow
     * @see com.smartgwt.client.data.DSRequest#setEndRow
     */
    public void setSummaryRowFetchRequestProperties(DSRequest summaryRowFetchRequestProperties) {
        JavaScriptObject config = JSOHelper.createObject();
        if (summaryRowFetchRequestProperties != null) {
            JSOHelper.addProperties(config, summaryRowFetchRequestProperties.getJsObj());
        }
        setAttribute("summaryRowFetchRequestProperties", summaryRowFetchRequestProperties == null ? null : config, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to customize the fetch request used when retrieving summary data to show in the summary row. An example use case
     * might be specifying a {@link com.smartgwt.client.data.DSRequest#getOperationId DSRequest.operationId} to perform a
     * custom fetch operation which retrieved only summary values based on criteria. <p> By default, only the first {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowCriteria criteria} match is returned if the criteria matches
     * multiple records.
     *
     * @return Current summaryRowFetchRequestProperties value. Default value is null
     * @see com.smartgwt.client.data.DSRequest#getStartRow
     * @see com.smartgwt.client.data.DSRequest#getEndRow
     */
    public DSRequest getSummaryRowFetchRequestProperties()  {
        return new DSRequest(getAttributeAsJavaScriptObject("summaryRowFetchRequestProperties"));
    }
    

    /**
     * Default height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summary row autoChild}. Note that
     * this height is a minimum - the summary row has {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData} set to "vertical" so if multiple rows are visible in the grid summary, the summaryRow component will expand
     * to accommodate them.
     *
     * @param summaryRowHeight New summaryRowHeight value. Default value is 20
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setSummaryRowHeight(int summaryRowHeight)  throws IllegalStateException {
        setAttribute("summaryRowHeight", summaryRowHeight, false);
    }

    /**
     * Default height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summary row autoChild}. Note that
     * this height is a minimum - the summary row has {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData} set to "vertical" so if multiple rows are visible in the grid summary, the summaryRow component will expand
     * to accommodate them.
     *
     * @return Current summaryRowHeight value. Default value is 20
     */
    public int getSummaryRowHeight()  {
        return getAttributeAsInt("summaryRowHeight");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowStyle New summaryRowStyle value. Default value is "gridSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setSummaryRowStyle(String summaryRowStyle) {
        setAttribute("summaryRowStyle", summaryRowStyle, true);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow}
     *
     * @return Current summaryRowStyle value. Default value is "gridSummaryCell"
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getSummaryRowStyle()  {
        return getAttributeAsString("summaryRowStyle");
    }
    

    /**
     * "Tall" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style
     * unless the grid is showing fixed height rows with a specified cellHeight that matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight}, in which case {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. Note that in Internet
     * Explorer if {@link com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is true,
     * <code>tallBaseStyle</code> will also be used even if the cellHeight matches the specified <code>normalCellHeight</code>
     * for the grid. <P> See {@link com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are
     * combined with the base style to generate stateful cell styles.
     *
     * @param tallBaseStyle New tallBaseStyle value. Default value is "cell"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public void setTallBaseStyle(String tallBaseStyle)  throws IllegalStateException {
        setAttribute("tallBaseStyle", tallBaseStyle, false);
    }

    /**
     * "Tall" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style
     * unless the grid is showing fixed height rows with a specified cellHeight that matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight}, in which case {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. Note that in Internet
     * Explorer if {@link com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is true,
     * <code>tallBaseStyle</code> will also be used even if the cellHeight matches the specified <code>normalCellHeight</code>
     * for the grid. <P> See {@link com.smartgwt.client.docs.CellStyleSuffixes} for details on how stateful suffixes are
     * combined with the base style to generate stateful cell styles.
     *
     * @return Current tallBaseStyle value. Default value is "cell"
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.CSSStyleName CSSStyleName 
     */
    public String getTallBaseStyle()  {
        return getAttributeAsString("tallBaseStyle");
    }
    
    
    

    /**
     * While scrolling an incrementally rendered grid, using the inertial scrolling, time in  milliseconds to wait before
     * redrawing, after the last touchScroll by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and touch scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw GridRenderer.instantScrollTrackRedraw} for
     * cases where this delay is skipped.
     *
     * @param touchScrollRedrawDelay New touchScrollRedrawDelay value. Default value is 0
     */
    public void setTouchScrollRedrawDelay(Integer touchScrollRedrawDelay) {
        setAttribute("touchScrollRedrawDelay", touchScrollRedrawDelay, true);
    }

    /**
     * While scrolling an incrementally rendered grid, using the inertial scrolling, time in  milliseconds to wait before
     * redrawing, after the last touchScroll by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and touch scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw GridRenderer.instantScrollTrackRedraw} for
     * cases where this delay is skipped.
     *
     * @return Current touchScrollRedrawDelay value. Default value is 0
     */
    public Integer getTouchScrollRedrawDelay()  {
        return getAttributeAsInt("touchScrollRedrawDelay");
    }
    

    /**
     * Default image to use for the dragTracker when things are dragged within or out of this list. See {@link
     * com.smartgwt.client.widgets.ImgProperties} for format.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param trackerImage New trackerImage value. Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDragTrackerMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragTrackerIcon
     */
    public void setTrackerImage(ImgProperties trackerImage) {
        setAttribute("trackerImage", trackerImage == null ? null : trackerImage.getJsObj(), true);
    }

    /**
     * Default image to use for the dragTracker when things are dragged within or out of this list. See {@link
     * com.smartgwt.client.widgets.ImgProperties} for format.
     *
     * @return Current trackerImage value. Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragTrackerMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragTrackerIcon
     */
    public ImgProperties getTrackerImage()  {
        return new ImgProperties(getAttributeAsJavaScriptObject("trackerImage"));
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to unfreeze a currently frozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Unfreeze " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param unfreezeFieldText New unfreezeFieldText value. Default value is "Unfreeze ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public void setUnfreezeFieldText(String unfreezeFieldText) {
        setAttribute("unfreezeFieldText", unfreezeFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to unfreeze a currently frozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Unfreeze " + the field's summary title.
     *
     * @return Current unfreezeFieldText value. Default value is "Unfreeze ${title}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getUnfreezeFieldText()  {
        return getAttributeAsString("unfreezeFieldText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getIsGrouped this.isGrouped} is true, this attribute will be
     * shown as the title for the menu item to ungroup the grid.
     *
     * @param ungroupText New ungroupText value. Default value is "Ungroup"
     */
    public void setUngroupText(String ungroupText) {
        setAttribute("ungroupText", ungroupText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getIsGrouped this.isGrouped} is true, this attribute will be
     * shown as the title for the menu item to ungroup the grid.
     *
     * @return Current ungroupText value. Default value is "Ungroup"
     */
    public String getUngroupText()  {
        return getAttributeAsString("ungroupText");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, this icon will
     * be shown in the auto generated field fro removing records if the record has been marked as removed via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved markRecordRemoved()}. At this point, clicking on the icon
     * will unmark the record as removed.
     *
     * @param unremoveIcon New unremoveIcon value. Default value is "[SKIN]/actions/undo.png"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public void setUnremoveIcon(String unremoveIcon)  throws IllegalStateException {
        setAttribute("unremoveIcon", unremoveIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, this icon will
     * be shown in the auto generated field fro removing records if the record has been marked as removed via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved markRecordRemoved()}. At this point, clicking on the icon
     * will unmark the record as removed.
     *
     * @return Current unremoveIcon value. Default value is "[SKIN]/actions/undo.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getUnremoveIcon()  {
        return getAttributeAsString("unremoveIcon");
    }
    
    

    /**
     * Should the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} in this grid always
     * produce  {@link com.smartgwt.client.data.AdvancedCriteria}?
     *
     * @param useAdvancedCriteria New useAdvancedCriteria value. Default value is null
     * @see com.smartgwt.client.docs.CriteriaEditing CriteriaEditing overview and related methods
     */
    public void setUseAdvancedCriteria(Boolean useAdvancedCriteria) {
        setAttribute("useAdvancedCriteria", useAdvancedCriteria, true);
    }

    /**
     * Should the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} in this grid always
     * produce  {@link com.smartgwt.client.data.AdvancedCriteria}?
     *
     * @return Current useAdvancedCriteria value. Default value is null
     * @see com.smartgwt.client.docs.CriteriaEditing CriteriaEditing overview and related methods
     */
    public Boolean getUseAdvancedCriteria()  {
        return getAttributeAsBoolean("useAdvancedCriteria");
    }
    

    /**
     * If set to true, an advanced field picker based on the {@link com.smartgwt.client.widgets.FieldPicker} will be shown
     * instead of the column picker submenu if there are more fields in the grid than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFieldPickerThreshold advancedFieldPickerThreshold}. <P> When there
     * are large numbers of available fields, the FieldPicker-based interface is more usable for both defining visible fields
     * and defining field order.
     *
     * @param useAdvancedFieldPicker New useAdvancedFieldPicker value. Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setUseAdvancedFieldPicker(Boolean useAdvancedFieldPicker)  throws IllegalStateException {
        setAttribute("useAdvancedFieldPicker", useAdvancedFieldPicker, false);
    }

    /**
     * If set to true, an advanced field picker based on the {@link com.smartgwt.client.widgets.FieldPicker} will be shown
     * instead of the column picker submenu if there are more fields in the grid than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFieldPickerThreshold advancedFieldPickerThreshold}. <P> When there
     * are large numbers of available fields, the FieldPicker-based interface is more usable for both defining visible fields
     * and defining field order.
     *
     * @return Current useAdvancedFieldPicker value. Default value is false
     */
    public Boolean getUseAdvancedFieldPicker()  {
        Boolean result = getAttributeAsBoolean("useAdvancedFieldPicker");
        return result == null ? false : result;
    }
    
    

    /**
     * Are rollovers cell-level or row-level?
     *
     * @param useCellRollOvers New useCellRollOvers value. Default value is null
     */
    public void setUseCellRollOvers(Boolean useCellRollOvers) {
        setAttribute("useCellRollOvers", useCellRollOvers, true);
    }

    /**
     * Are rollovers cell-level or row-level?
     *
     * @return Current useCellRollOvers value. Default value is null
     */
    public Boolean getUseCellRollOvers()  {
        return getAttributeAsBoolean("useCellRollOvers");
    }
    

    /**
     * Enables copy/paste shortcuts, provided {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells
     * canSelectCells} is true <p> The default setting of true means that the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} determines whether copy/paste shortcuts are
     * enabled.  Setting this property to false disables said shortcuts unconditionally. <p> Copying is done via copying to a
     * Smart GWT-wide "clipboard" - <b>not</b> the OS-level clipboard, which is inaccessible on some browsers - via the methods
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedCellData getSelectedCellData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyCellData applyCellData()}.  To copy data to and from applications outside
     * of the browser, use the technique shown in the @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#gridToExcel" target="examples">Grid to Excel</a> and @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#excelToGrid" target="examples">Excel to Grid</a> samples. <p> The
     * following shortcuts are available: <p> CTRL + D: copy cell values from top row of selected cells down to all rows <p>
     * CTRL + R: copy cell values from left column of selected cells right to all columns <p> CTRL + C: copy selected cell
     * values into shared clipboard <p> CTRL + V: paste from shared clipboard into current selection
     *
     * @param useCopyPasteShortcuts New useCopyPasteShortcuts value. Default value is true
     */
    public void setUseCopyPasteShortcuts(Boolean useCopyPasteShortcuts) {
        setAttribute("useCopyPasteShortcuts", useCopyPasteShortcuts, true);
    }

    /**
     * Enables copy/paste shortcuts, provided {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells
     * canSelectCells} is true <p> The default setting of true means that the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} determines whether copy/paste shortcuts are
     * enabled.  Setting this property to false disables said shortcuts unconditionally. <p> Copying is done via copying to a
     * Smart GWT-wide "clipboard" - <b>not</b> the OS-level clipboard, which is inaccessible on some browsers - via the methods
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedCellData getSelectedCellData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyCellData applyCellData()}.  To copy data to and from applications outside
     * of the browser, use the technique shown in the @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#gridToExcel" target="examples">Grid to Excel</a> and @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#excelToGrid" target="examples">Excel to Grid</a> samples. <p> The
     * following shortcuts are available: <p> CTRL + D: copy cell values from top row of selected cells down to all rows <p>
     * CTRL + R: copy cell values from left column of selected cells right to all columns <p> CTRL + C: copy selected cell
     * values into shared clipboard <p> CTRL + V: paste from shared clipboard into current selection
     *
     * @return Current useCopyPasteShortcuts value. Default value is true
     */
    public Boolean getUseCopyPasteShortcuts()  {
        Boolean result = getAttributeAsBoolean("useCopyPasteShortcuts");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is specified, but this grid is bound to
     * a DataSource which includes remote field validators, by default edits will be saved synchronously and these validators
     * will not be executed.<br> Set this property to <code>true</code> to ensure these remote validators are called when
     * saving edits in saveLocally mode. Note that since these remote validators need to run on the server, saving with this
     * property set is asynchronous, even though the data that ultimately gets updated is already present on the client.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param useRemoteValidators New useRemoteValidators value. Default value is null
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setUseRemoteValidators(Boolean useRemoteValidators) {
        setAttribute("useRemoteValidators", useRemoteValidators, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is specified, but this grid is bound to
     * a DataSource which includes remote field validators, by default edits will be saved synchronously and these validators
     * will not be executed.<br> Set this property to <code>true</code> to ensure these remote validators are called when
     * saving edits in saveLocally mode. Note that since these remote validators need to run on the server, saving with this
     * property set is asynchronous, even though the data that ultimately gets updated is already present on the client.
     *
     * @return Current useRemoteValidators value. Default value is null
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getUseRemoteValidators()  {
        return getAttributeAsBoolean("useRemoteValidators");
    }
    

    /**
     * Enables various styling behaviors that potentially make sense when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} has been overridden to introduce spanning cells, and
     * spanning is largest on the left and smaller as cells go to the right.  Specifically: <ul> <li> computes {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles banded styling} based on the span of the      cell in
     * the left-most column <li> enables {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells cell-level
     * selection}, including      {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers cell-level rollover}
     * styling <li> enables row-span-sensitive cell selection.  See also {@link com.smartgwt.client.types.RowSpanSelectionMode}
     * for available behaviors </ul> <P> Because this setting enables {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells}, it is incompatible with any APIs that
     * expect a record-oriented data model. <P> Because this setting only makes sense when row spanning decreases from the
     * first column to the last, it has unspecified behavior with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanReorderFields canReorderFields}.
     *
     * @param useRowSpanStyling New useRowSpanStyling value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setUseRowSpanStyling(Boolean useRowSpanStyling)  throws IllegalStateException {
        setAttribute("useRowSpanStyling", useRowSpanStyling, false);
    }

    /**
     * Enables various styling behaviors that potentially make sense when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan getRowSpan()} has been overridden to introduce spanning cells, and
     * spanning is largest on the left and smaller as cells go to the right.  Specifically: <ul> <li> computes {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles banded styling} based on the span of the      cell in
     * the left-most column <li> enables {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells cell-level
     * selection}, including      {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers cell-level rollover}
     * styling <li> enables row-span-sensitive cell selection.  See also {@link com.smartgwt.client.types.RowSpanSelectionMode}
     * for available behaviors </ul> <P> Because this setting enables {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells}, it is incompatible with any APIs that
     * expect a record-oriented data model. <P> Because this setting only makes sense when row spanning decreases from the
     * first column to the last, it has unspecified behavior with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanReorderFields canReorderFields}.
     *
     * @return Current useRowSpanStyling value. Default value is null
     */
    public Boolean getUseRowSpanStyling()  {
        return getAttributeAsBoolean("useRowSpanStyling");
    }
    

    /**
     * Whether client-side validation checks should be performed when the user moves between cells in the current edit row.  If
     * unset, defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell editByCell}. <P> Note that validation
     * always occurs when a row is to be saved, so setting {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell
     * saveByCell}:true forces validation on cell transitions.  To completely disable automatic validation, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNeverValidate neverValidate}:true.
     *
     * @param validateByCell New validateByCell value. Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public void setValidateByCell(Boolean validateByCell) {
        setAttribute("validateByCell", validateByCell, true);
    }

    /**
     * Whether client-side validation checks should be performed when the user moves between cells in the current edit row.  If
     * unset, defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell editByCell}. <P> Note that validation
     * always occurs when a row is to be saved, so setting {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell
     * saveByCell}:true forces validation on cell transitions.  To completely disable automatic validation, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNeverValidate neverValidate}:true.
     *
     * @return Current validateByCell value. Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getValidateByCell()  {
        return getAttributeAsBoolean("validateByCell");
    }
    

    /**
     * If true, validation will be performed on each edited cell when each editor's "change" handler is fired.
     *
     * @param validateOnChange New validateOnChange value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValidateOnChange
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public void setValidateOnChange(Boolean validateOnChange) {
        setAttribute("validateOnChange", validateOnChange, true);
    }

    /**
     * If true, validation will be performed on each edited cell when each editor's "change" handler is fired.
     *
     * @return Current validateOnChange value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValidateOnChange
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getValidateOnChange()  {
        return getAttributeAsBoolean("validateOnChange");
    }
    

    /**
     * Height for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @param valueIconHeight New valueIconHeight value. Default value is null
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconHeight(Integer valueIconHeight) {
        setAttribute("valueIconHeight", valueIconHeight, true);
    }

    /**
     * Height for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @return Current valueIconHeight value. Default value is null
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public Integer getValueIconHeight()  {
        return getAttributeAsInt("valueIconHeight");
    }
    

    /**
     * How much padding should there be on the left of valueIcons by default Can be overridden at the field level
     *
     * @param valueIconLeftPadding New valueIconLeftPadding value. Default value is 2
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconLeftPadding(int valueIconLeftPadding) {
        setAttribute("valueIconLeftPadding", valueIconLeftPadding, true);
    }

    /**
     * How much padding should there be on the left of valueIcons by default Can be overridden at the field level
     *
     * @return Current valueIconLeftPadding value. Default value is 2
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getValueIconLeftPadding()  {
        return getAttributeAsInt("valueIconLeftPadding");
    }
    

    /**
     * How much padding should there be on the right of valueIcons by default
     *
     * @param valueIconRightPadding New valueIconRightPadding value. Default value is 2
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconRightPadding(int valueIconRightPadding) {
        setAttribute("valueIconRightPadding", valueIconRightPadding, true);
    }

    /**
     * How much padding should there be on the right of valueIcons by default
     *
     * @return Current valueIconRightPadding value. Default value is 2
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getValueIconRightPadding()  {
        return getAttributeAsInt("valueIconRightPadding");
    }
    

    /**
     * Default width and height of value icons for this ListGrid. Can be overridden at the listGrid level via explicit {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconWidth valueIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconHeight valueIconHeight}, or at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconSize ListGridField.valueIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconWidth ListGridField.valueIconWidth} and
     * {ListGridField.valueIconHeight}
     *
     * @param valueIconSize New valueIconSize value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#setValueIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setValueIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValueIconSize
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconSize(int valueIconSize) {
        setAttribute("valueIconSize", valueIconSize, true);
    }

    /**
     * Default width and height of value icons for this ListGrid. Can be overridden at the listGrid level via explicit {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconWidth valueIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconHeight valueIconHeight}, or at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconSize ListGridField.valueIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconWidth ListGridField.valueIconWidth} and
     * {ListGridField.valueIconHeight}
     *
     * @return Current valueIconSize value. Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#getValueIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getValueIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValueIconSize
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getValueIconSize()  {
        return getAttributeAsInt("valueIconSize");
    }
    

    /**
     * Width for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @param valueIconWidth New valueIconWidth value. Default value is null
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconWidth(Integer valueIconWidth) {
        setAttribute("valueIconWidth", valueIconWidth, true);
    }

    /**
     * Width for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @return Current valueIconWidth value. Default value is null
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public Integer getValueIconWidth()  {
        return getAttributeAsInt("valueIconWidth");
    }
    

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridViewState view state} for the grid. <P> Since view state contains field
     * state it is not necessary to set {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState fieldState} when also
     * setting <code>viewState</code>. If both are provided, <code>fieldState</code> has priority for field state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's view state to match the {@link com.smartgwt.client.docs.ListGridViewState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState getViewState()}.
     *
     * @param viewState Object describing the desired view state for the grid. Default value is null
     * @see com.smartgwt.client.docs.ListGridViewState ListGridViewState 
     */
    public void setViewState(String viewState) {
        setAttribute("viewState", viewState, true);
    }

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridViewState view state} for the grid. <P> Since view state contains field
     * state it is not necessary to set {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState fieldState} when also
     * setting <code>viewState</code>. If both are provided, <code>fieldState</code> has priority for field state.
     *
     * @return Returns a snapshot of the current view state of this ListGrid.<br> This includes the field, sort, hilite, group, and
     * selected state of the grid, returned  as a string representation of a {@link com.smartgwt.client.docs.ListGridViewState}
     * object.<br> This string can be passed to {@link com.smartgwt.client.widgets.grid.ListGrid#setViewState setViewState()}
     * to reset this grid's view state to the current state (assuming the same data / fields are present in the grid).<br>. Default value is null
     * @see com.smartgwt.client.docs.ListGridViewState ListGridViewState 
     */
    public String getViewState()  {
        return getAttributeAsString("viewState");
    }
    

    /**
     * When incremental rendering is switched on and there are variable record heights, the virtual scrolling mechanism manages
     * the differences in scroll height calculations due to the unknown sizes of un-rendered rows to make the scrollbar and
     * viewport appear correctly. <P> When the <code>virtualScrolling</code> system is active, the last scroll position scrolls
     * the last record to the top of the viewport, leaving blank space underneath. This is a necessary and unavoidable
     * consequence of mapping the position of the scrollbar thumb to an unknown amount of remaining space without being able to
     * know the total scrollable area in advance (since record heights vary). <P> virtualScrolling is switched on automatically
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is false and also when
     * using the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents subsystem}, as
     * recordComponents expand the rows that contain them. This flag should be manually enabled when calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent addEmbeddedComponent()} if embedded components can cause
     * record sizes to expand beyond specified cellHeight. <P> virtualScrolling is also automatically enabled when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true to handle the fact that expanded
     * rows may render at variable heights.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param virtualScrolling New virtualScrolling value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordComponentHeight
     */
    public void setVirtualScrolling(Boolean virtualScrolling)  throws IllegalStateException {
        setAttribute("virtualScrolling", virtualScrolling, false);
    }

    /**
     * When incremental rendering is switched on and there are variable record heights, the virtual scrolling mechanism manages
     * the differences in scroll height calculations due to the unknown sizes of un-rendered rows to make the scrollbar and
     * viewport appear correctly. <P> When the <code>virtualScrolling</code> system is active, the last scroll position scrolls
     * the last record to the top of the viewport, leaving blank space underneath. This is a necessary and unavoidable
     * consequence of mapping the position of the scrollbar thumb to an unknown amount of remaining space without being able to
     * know the total scrollable area in advance (since record heights vary). <P> virtualScrolling is switched on automatically
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is false and also when
     * using the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents subsystem}, as
     * recordComponents expand the rows that contain them. This flag should be manually enabled when calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent addEmbeddedComponent()} if embedded components can cause
     * record sizes to expand beyond specified cellHeight. <P> virtualScrolling is also automatically enabled when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true to handle the fact that expanded
     * rows may render at variable heights.
     *
     * @return Current virtualScrolling value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight
     */
    public Boolean getVirtualScrolling()  {
        return getAttributeAsBoolean("virtualScrolling");
    }
    

    /**
     * If this is an editable listGrid, this property determines whether the user will be able to dismiss the edit form, or
     * navigate to another cell while the save is in process (before the asynchronous server response returns).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param waitForSave New waitForSave value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setWaitForSave(Boolean waitForSave) {
        setAttribute("waitForSave", waitForSave, true);
    }

    /**
     * If this is an editable listGrid, this property determines whether the user will be able to dismiss the edit form, or
     * navigate to another cell while the save is in process (before the asynchronous server response returns).
     *
     * @return Current waitForSave value. Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getWaitForSave()  {
        Boolean result = getAttributeAsBoolean("waitForSave");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true, when the user clicks
     * the remove icon for some record, should we show a warning message (defined as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemovalMessage warnOnRemovalMessage}) and allow the user to cancel
     * removal?
     *
     * @param warnOnRemoval New warnOnRemoval value. Default value is false
     */
    public void setWarnOnRemoval(Boolean warnOnRemoval) {
        setAttribute("warnOnRemoval", warnOnRemoval, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true, when the user clicks
     * the remove icon for some record, should we show a warning message (defined as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemovalMessage warnOnRemovalMessage}) and allow the user to cancel
     * removal?
     *
     * @return Current warnOnRemoval value. Default value is false
     */
    public Boolean getWarnOnRemoval()  {
        Boolean result = getAttributeAsBoolean("warnOnRemoval");
        return result == null ? false : result;
    }
    

    /**
     * Warning message to show the user on a click on the 'remove' icon if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval} is true.
     *
     * @param warnOnRemovalMessage New warnOnRemovalMessage value. Default value is "Are you sure you want to delete this record?"
     */
    public void setWarnOnRemovalMessage(String warnOnRemovalMessage) {
        setAttribute("warnOnRemovalMessage", warnOnRemovalMessage, true);
    }

    /**
     * Warning message to show the user on a click on the 'remove' icon if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval} is true.
     *
     * @return Current warnOnRemovalMessage value. Default value is "Are you sure you want to delete this record?"
     */
    public String getWarnOnRemovalMessage()  {
        return getAttributeAsString("warnOnRemovalMessage");
    }
    

    /**
     * If a field has {@link com.smartgwt.client.widgets.grid.ListGridField#getDisplayField ListGridField.displayField}
     * specified and has no {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource}, this field will display the value from the <code>displayField</code> of each record by
     * default (for more on this behavior see {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource}). <P> If such a field is editable, changing the edit value for the field on some record,
     * without updating the edit value for the associated display field on the same record would mean the user would continue
     * to see the unchanged display field value. Developers can resolve this situation by programmatically setting an edit
     * value for the display field as well as the data field, or avoid it by specifying an optionDataSource and ensuring {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchDisplayMap autoFetchDisplayMap} is true, or setting an explicit
     * valueMap for the field. <P> By default, when the edit value on a field with a specified displayField and no
     * optionDataSource is set, we log a warning to notify the developer. This warning may be disabled by setting
     * <code>warnOnUnmappedValueFieldChange</code> to <code>false</code>. <P> Note: There are actually a couple of cases in
     * which the system will automatically derive a new display-field value and apply it to the record: <ol><li>If the edit
     * value was changed by a user actually editing the record (rather than a programmatic call to setEditValue()), and the
     * edit-item had a valueMap or optionDataSource set, we automatically pick up the display value from that item and store it
     * as an edit-value for the displayField of the record</li>     <li>If the listGrid has a loaded record in its data set
     * whose valueField value matches the edit value for the valueField, we automatically apply the displayField value from
     * that record as an edit value for the displayField on the newly edited record.</li></ol> In either case, the display
     * value for the record is updated automatically (and the warning would not be logged).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param warnOnUnmappedValueFieldChange New warnOnUnmappedValueFieldChange value. Default value is true
     */
    public void setWarnOnUnmappedValueFieldChange(Boolean warnOnUnmappedValueFieldChange) {
        setAttribute("warnOnUnmappedValueFieldChange", warnOnUnmappedValueFieldChange, true);
    }

    /**
     * If a field has {@link com.smartgwt.client.widgets.grid.ListGridField#getDisplayField ListGridField.displayField}
     * specified and has no {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource}, this field will display the value from the <code>displayField</code> of each record by
     * default (for more on this behavior see {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     * ListGridField.optionDataSource}). <P> If such a field is editable, changing the edit value for the field on some record,
     * without updating the edit value for the associated display field on the same record would mean the user would continue
     * to see the unchanged display field value. Developers can resolve this situation by programmatically setting an edit
     * value for the display field as well as the data field, or avoid it by specifying an optionDataSource and ensuring {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchDisplayMap autoFetchDisplayMap} is true, or setting an explicit
     * valueMap for the field. <P> By default, when the edit value on a field with a specified displayField and no
     * optionDataSource is set, we log a warning to notify the developer. This warning may be disabled by setting
     * <code>warnOnUnmappedValueFieldChange</code> to <code>false</code>. <P> Note: There are actually a couple of cases in
     * which the system will automatically derive a new display-field value and apply it to the record: <ol><li>If the edit
     * value was changed by a user actually editing the record (rather than a programmatic call to setEditValue()), and the
     * edit-item had a valueMap or optionDataSource set, we automatically pick up the display value from that item and store it
     * as an edit-value for the displayField of the record</li>     <li>If the listGrid has a loaded record in its data set
     * whose valueField value matches the edit value for the valueField, we automatically apply the displayField value from
     * that record as an edit value for the displayField on the newly edited record.</li></ol> In either case, the display
     * value for the record is updated automatically (and the warning would not be logged).
     *
     * @return Current warnOnUnmappedValueFieldChange value. Default value is true
     */
    public Boolean getWarnOnUnmappedValueFieldChange()  {
        Boolean result = getAttributeAsBoolean("warnOnUnmappedValueFieldChange");
        return result == null ? true : result;
    }
    

    /**
     * Should content within cells be allowed to wrap? <P> Even if content is allowed to wrap, if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is set, the content will be clipped
     * off at the cell boundary.  Either set a larger, fixed {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight
     * cellHeight} to reveal more content, or set {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} to false to allow auto-sizing.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param wrapCells New wrapCells value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public void setWrapCells(Boolean wrapCells) {
        setAttribute("wrapCells", wrapCells, true);
    }

    /**
     * Should content within cells be allowed to wrap? <P> Even if content is allowed to wrap, if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is set, the content will be clipped
     * off at the cell boundary.  Either set a larger, fixed {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight
     * cellHeight} to reveal more content, or set {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} to false to allow auto-sizing.
     *
     * @return Current wrapCells value. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public Boolean getWrapCells()  {
        Boolean result = getAttributeAsBoolean("wrapCells");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.HeaderSpan#getWrap HeaderSpan.wrap} is not explicitly set, should fields
     * wrap?  If autofitting, see the docs on that property for the details of how the minimum width for a field is determined.
     *
     * @param wrapHeaderSpanTitles New wrapHeaderSpanTitles value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setMinFieldWidth
     */
    public void setWrapHeaderSpanTitles(Boolean wrapHeaderSpanTitles)  throws IllegalStateException {
        setAttribute("wrapHeaderSpanTitles", wrapHeaderSpanTitles, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.HeaderSpan#getWrap HeaderSpan.wrap} is not explicitly set, should fields
     * wrap?  If autofitting, see the docs on that property for the details of how the minimum width for a field is determined.
     *
     * @return Current wrapHeaderSpanTitles value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth
     */
    public Boolean getWrapHeaderSpanTitles()  {
        return getAttributeAsBoolean("wrapHeaderSpanTitles");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap ListGridField.wrap} is not explicitly set, should
     * fields wrap?  If autofitting, see the docs on that property for the details of how the minimum width for a field is
     * determined.
     *
     * @param wrapHeaderTitles New wrapHeaderTitles value. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setMinFieldWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderBaseStyle
     */
    public void setWrapHeaderTitles(Boolean wrapHeaderTitles)  throws IllegalStateException {
        setAttribute("wrapHeaderTitles", wrapHeaderTitles, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap ListGridField.wrap} is not explicitly set, should
     * fields wrap?  If autofitting, see the docs on that property for the details of how the minimum width for a field is
     * determined.
     *
     * @return Current wrapHeaderTitles value. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle
     */
    public Boolean getWrapHeaderTitles()  {
        return getAttributeAsBoolean("wrapHeaderTitles");
    }
    

    // ********************* Methods ***********************
	/**
     * Perform a DataSource "add" operation to add new records to this component's DataSource.
     * @param newRecord new record
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_add" target="examples">Databound add Example</a>
     */
    public native void addData(Record newRecord) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "addData", "Record");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addData(newRecord.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    /**
     * @see ListGrid#addData
     */
    public void addData(Record newRecord, DSCallback callback){
        addData(newRecord, callback, null);
    }

	/**
     * Perform a DataSource "add" operation to add new records to this component's DataSource.
     * @param newRecord new record
     * @param callback method to call on operation completion
     * @param requestProperties additional properties to set on the DSRequest                                          that will be issued
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_add" target="examples">Databound add Example</a>
     */
    public native void addData(Record newRecord, DSCallback callback, DSRequest requestProperties) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "addData", "Record,DSCallback,DSRequest");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addData(newRecord.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Attaches the component to the provided record. If <code>position</code> is specified as <code>"within"</code> {@link
     * com.smartgwt.client.widgets.Canvas#getSnapTo Canvas.snapTo} and {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft Canvas.snapOffsetLeft}, {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetTop Canvas.snapOffsetTop} may be set to specify where the component will
     * render within the cell or record. If unset, for components embedded within a record we will default to embedding at the
     * top/left coordinate, and for components embedded within a cell, we will respect the align / valign properties for the
     * cell in question. Any percentage sizing will be interpreted as percentage of row size. <P> Otherwise it will appear to
     * be embedded within the record, underneath the field values. <P> Embedded components become children of the grid and will
     * stay attached to a record through scrolling, sorting and other operations that cause records to shift position. <P> If
     * <code>position</code> is set to <code>"expand"</code>, embedded components may offer a resize interface, eg, by setting
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getCanDragResize canDragResize}:true, and the grid will react
     * accordingly, growing or shrinking the record to match the embedded component's new extents. <P> Embedded components can
     * be explicitly removed with {@link com.smartgwt.client.widgets.grid.ListGrid#removeEmbeddedComponent
     * removeEmbeddedComponent()}. <P> If a record is removed from the dataset or is replaced in the dataset, for example, it
     * is eliminated through filtering (removes record) or is successfully edited in a databound grid (replaces record), the
     * component is cleared but not logically removed from the grid. It is the responsibility of code that sets up the embedded
     * component to remove it if the record is removed from the dataSet. <P> When embedding components will result in variable
     * height records, you should switch on {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling
     * virtualScrolling}.
     * @param component component to embed
     * @param record record to attach the component to
     */
    public native void addEmbeddedComponent(Canvas component, ListGridRecord record) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "addEmbeddedComponent", "Canvas,ListGridRecord");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addEmbeddedComponent(component == null ? null : component.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), record.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    /**
     * @see ListGrid#addEmbeddedComponent
     */
    public void addEmbeddedComponent(Canvas component, ListGridRecord record, Integer rowNum){
        addEmbeddedComponent(component, record, rowNum, (Integer) null, null);
    }

    /**
     * @see ListGrid#addEmbeddedComponent
     */
    public void addEmbeddedComponent(Canvas component, ListGridRecord record, Integer rowNum, Integer colNum){
        addEmbeddedComponent(component, record, rowNum, colNum, null);
    }

	/**
     * Attaches the component to the provided record. If <code>position</code> is specified as <code>"within"</code> {@link
     * com.smartgwt.client.widgets.Canvas#getSnapTo Canvas.snapTo} and {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft Canvas.snapOffsetLeft}, {@link
     * com.smartgwt.client.widgets.Canvas#getSnapOffsetTop Canvas.snapOffsetTop} may be set to specify where the component will
     * render within the cell or record. If unset, for components embedded within a record we will default to embedding at the
     * top/left coordinate, and for components embedded within a cell, we will respect the align / valign properties for the
     * cell in question. Any percentage sizing will be interpreted as percentage of row size. <P> Otherwise it will appear to
     * be embedded within the record, underneath the field values. <P> Embedded components become children of the grid and will
     * stay attached to a record through scrolling, sorting and other operations that cause records to shift position. <P> If
     * <code>position</code> is set to <code>"expand"</code>, embedded components may offer a resize interface, eg, by setting
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getCanDragResize canDragResize}:true, and the grid will react
     * accordingly, growing or shrinking the record to match the embedded component's new extents. <P> Embedded components can
     * be explicitly removed with {@link com.smartgwt.client.widgets.grid.ListGrid#removeEmbeddedComponent
     * removeEmbeddedComponent()}. <P> If a record is removed from the dataset or is replaced in the dataset, for example, it
     * is eliminated through filtering (removes record) or is successfully edited in a databound grid (replaces record), the
     * component is cleared but not logically removed from the grid. It is the responsibility of code that sets up the embedded
     * component to remove it if the record is removed from the dataSet. <P> When embedding components will result in variable
     * height records, you should switch on {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling
     * virtualScrolling}.
     * @param component component to embed
     * @param record record to attach the component to
     * @param rowNum rowNum of the record to attach the component to
     * @param colNum colNum in which to embed the component
     * @param position positioning with respect to the record or cell (Defaults to "expand").
     */
    public native void addEmbeddedComponent(Canvas component, ListGridRecord record, Integer rowNum, Integer colNum, EmbeddedPosition position) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "addEmbeddedComponent", "Canvas,ListGridRecord,Integer,Integer,EmbeddedPosition");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addEmbeddedComponent(component == null ? null : component.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum == null ? null : rowNum.@java.lang.Integer::intValue()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()(), position == null ? null : position.@com.smartgwt.client.types.EmbeddedPosition::getValue()());
    }-*/;
	
	/**
     * Adds another {@link com.smartgwt.client.data.SortSpecifier} to this grid's sort configuration and resorts.
     * @param sortSpecifier A SortSpecifier object indicating an additional field    and direction to sort by
     */
    public native void addSort(SortSpecifier sortSpecifier) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "addSort", "SortSpecifier");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addSort(sortSpecifier.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

	/**
     * Applies a set of Records containing coordinate-based data as returned by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectedCellData getSelectedCellData()} and applies the data at the current
     * selection. <P> For consistency with Excel, given a record in the cellData, after the data value with the most negative
     * column index is found, the rest of the values in the record are applied contiguously to the right of it, using the
     * positional data for ordering only. <P> Will only modify cells in the grid which are editable, and changes will be
     * applied as editValues, exactly as though the user had typed the values in (see {@link com.smartgwt.client.docs.Editing
     * Grid Editing Overview}). <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#applyRecordData
     * applyRecordData()}.
     * @param cellData list of Records as described above
     */
    public native void applyCellData(RecordList cellData) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applyCellData", "RecordList");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.applyCellData(cellData == null ? null : cellData.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
    }-*/;

	/**
     * Applies a list of Records as changes to the current selection. <P> Values found in each of the passed records will be
     * applied to the same-named fields in the Records starting from the top-left of the current selection, in order. <P> Will
     * only modify cells in the grid which are editable, and changes will be applied as editValues, exactly as though the user
     * had typed the values in (see {@link com.smartgwt.client.docs.Editing Grid Editing Overview}). <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyCellData applyCellData()}.
     * @param recordData list of Records as described above
     */
    public native void applyRecordData(RecordList recordData) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applyRecordData", "RecordList");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.applyRecordData(recordData == null ? null : recordData.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
    }-*/;

	/**
     * Sort the grid's data to reflect the parameter sortSpecifiers. <p> <b>NOTE:</b> This method is primarily used by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()}; it is not intended  to be called by user code, unless you
     * are implementing a custom  {@link com.smartgwt.client.widgets.grid.ListGrid#addSetSortHandler setSortHandler}).  For the
     * normal use case, calling this  method directly will fail to execute vital pre-steps.  If you are not implementing a
     * custom handler as described above, do not call this method directly - call <code>setSort()</code>  instead.
     * @param sortSpecifiers Array of {@link com.smartgwt.client.data.SortSpecifier} objects
     */
    public native void applySortToData(SortSpecifier... sortSpecifiers) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applySortToData", "SortSpecifier...");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.applySortToData(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(sortSpecifiers));
    }-*/;

	/**
     * Show a dialog to configure the sorting of multiple fields on this component.  Calls through to {@link
     * com.smartgwt.client.widgets.MultiSortDialog#askForSort MultiSortDialog.askForSort()}, passing this component as the
     * fieldSource and the current {@link com.smartgwt.client.widgets.DataBoundComponent#getSort sort-specification} if there
     * is one. <P> The generated multiSortDialog can be customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMultiSortDialogDefaults multiSortDialogDefaults},  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMultiSortDialogProperties multiSortDialogProperties}.
     */
    public native void askForSort() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "askForSort", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.askForSort();
    }-*/;

	/**
     * Programmatically cause a field to auto-fit horizontally to it's contents or title. <P> Does not establish permanent
     * auto-fitting - use {@link com.smartgwt.client.widgets.grid.ListGrid#setAutoFitWidth setAutoFitWidth()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setAutoFitFieldWidths setAutoFitFieldWidths()} to do so. <P> Note that unlike
     * the ongoing autoFit set up by {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}
     * or {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}, any specified
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width} will not be taken as a minimum width
     * - the field may shrink below the current specified width when this method is run.  However, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getMinWidth ListGridField.minWidth} will be respected. <P> As with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, the auto-fit sizing is determined
     * via the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}.
     * @param fieldName 
     *
     * @return new width in pixels
     */
    public native int autoFitField(String fieldName) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "autoFitField", "String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.autoFitField(fieldName);
        return ret;
    }-*/;

	/**
     * Perform a one-time horizontal auto-fit of the fields passed. Fields will be sized to match their contents or title (as
     * specified in {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}) Does not
     * establish permanent auto-fitting - use {@link com.smartgwt.client.widgets.grid.ListGrid#setAutoFitWidth
     * setAutoFitWidth()} to do so. <P> Note that unlike the ongoing autoFit set up by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}, any specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width} will not be taken as a minimum width - the
     * field(s) may shrink below the current specified width when this method is run.  However, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getMinWidth ListGridField.minWidth} will be respected.
     */
    public native void autoFitFields() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "autoFitFields", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.autoFitFields();
    }-*/;

	/**
     * Perform a one-time horizontal auto-fit of the fields passed. Fields will be sized to match their contents or title (as
     * specified in {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}) Does not
     * establish permanent auto-fitting - use {@link com.smartgwt.client.widgets.grid.ListGrid#setAutoFitWidth
     * setAutoFitWidth()} to do so. <P> Note that unlike the ongoing autoFit set up by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth ListGridField.autoFitWidth}, any specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWidth ListGridField.width} will not be taken as a minimum width - the
     * field(s) may shrink below the current specified width when this method is run.  However, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getMinWidth ListGridField.minWidth} will be respected.
     * @param fields Array of fields to auto fit. If this parameter  is not passed, autoFitting will occur on all visible fields.
     */
    public native void autoFitFields(ListGridField... fields) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "autoFitFields", "ListGridField...");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.autoFitFields(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(fields));
    }-*/;
	
	/**
     * Cancel the current edit without saving.
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void cancelEditing() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cancelEditing", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.cancelEditing();
    }-*/;

	/**
     * Can this cell be edited?
     *  <P>
     *  The default implementation of <code>canEditCell()</code> respects the various property
     *  settings affecting editability:
     *  <ul><li>{@link com.smartgwt.client.widgets.grid.ListGridField#getCanEdit field.canEdit} can be set to disable editing
     *           for a field</li>
     * <li>If the grid is bound to a dataSource, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEditFieldAttribute
     * canEditFieldAttribute} value on the
     *          dataSource field may enable / disable editing</li>
     *  <li>a record with the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty recordEditProperty} set to
     *          false is not editable</li>
     *      <li>disabled records are not editable</li>
     *  </ul>
     *  You can override this method to control editability on a cell-by-cell basis.  For example,
     *  if you had a grid that allows editing of "orders", and you had a field "shipDate" that is
     *  normally editable, but should not be editable if the order is already "complete", you might
     *  implement <code>canEditCell()</code> as follows:
     *  <P>
     *  
     *  <pre>
     *     public boolean canEditCell(int rowNum, int colNum) {
     *       Record record = this.getRecord(rowNum);
     *       String fieldName = this.getFieldName(colNum);
     *       if (fieldName.equals("shipDate") && record.getAttribute("orderStatus").equals("complete") {
     *         return false;
     *       }
     *       // use default rules for all other fields
     *       return super.canEditCell(rowNum, colNum);
     *     };
     *  </pre>    
     *  <P>
     *  Notes on providing custom implementations:
     *  <ul>
     *  <li> In order to allow complete control over editing, <code>canEditCell()</code> is called
     *  very frequently.  If you see delays on row to row navigation, check that your implementation
     *  is efficient
     *  <li> If you change the editability of a cell on the fly, for example, during
     * {@link com.smartgwt.client.widgets.grid.ListGrid#addEditorExitHandler ListGrid.editorExit()} on another cell, call
     * refreshCell() to show or hide the editor
     *  <li> If this ListGrid allows new records to be created, <code>canEditCell()</code> may be
     *  called when there is no record available, in which case getRecord() will return null.  The
     * values input so far by the user are available via {@link com.smartgwt.client.widgets.grid.ListGrid#getEditValues
     * getEditValues()}.
     *  </ul>
     *  <p>
     *  <b>Note: This is an override point.</b>
     * 
     * 
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     *
     * @return Whether to allow editing this cell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native boolean canEditCell(int rowNum, int colNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "canEditCell", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__canEditCell(rowNum, colNum);
        return ret == null ? false : ret;
    }-*/;

	/**
     * Indicates whether a given record or rowNum can be expanded.  The default implementation checks the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and <code>record[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecordProperty canExpandRecordProperty}]</code>. <P> Override this
     * method for more specific control over individual record expansion. <P> <b>Note:</b> Rows with no underlying record in
     * the data array - for example newly added edit rows that have not yet been saved - cannot be expanded.
     * @param record record to work with
     * @param rowNum rowNum of the record to work with
     *
     * @return true if the record can be expanded
     */
    public native boolean canExpandRecord(ListGridRecord record, int rowNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "canExpandRecord", "ListGridRecord,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__canExpandRecord(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum);
        if(ret == null || ret === undefined) { return false; }
        return ret == null ? false : ret;
    }-*/;

	/**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is set to <code>true</code> then,
     * whenever an end-user or programmatic cell-selection is attempted, this method is called for  each cell in the selection.
     * If it returns false, the cell will not be selected.
     * @param rowNum rowNum being selected
     * @param colNum colNum being selected
     *
     * @return return false to disallow selection
     */
    public native boolean canSelectCell(int rowNum, int colNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "canSelectCell", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__canSelectCell(rowNum, colNum);
        return ret == null ? false : ret;
    }-*/;

    /**
     * Add a cellSaved handler.
     * <p>
     * Fires after user edits have been successfully saved to the server, only for cells where the value was actually modified.
     * <p> If you want immediate notification of a changes <b>before</b> changes has been saved to the server, implement {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addChangeHandler field.change()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addChangedHandler field.changed()} instead. <P> You can alternatively use
     * {@link com.smartgwt.client.widgets.grid.ListGridField#cellChanged ListGridField.cellChanged()} to get notification only
     * of saved changes for a specific field.  If both a listGridField and the containing listGrid have a handler for this
     * event, only the handler defined on the field is called.
     *
     * @param handler the cellSaved handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellSavedHandler(com.smartgwt.client.widgets.grid.events.CellSavedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellSavedEvent.getType()) == 0) setupCellSavedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellSavedEvent.getType());
    }

    private native void setupCellSavedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellChanged = $entry(function(){
            var param = {"_this": this, "record" : arguments[0], "newValue" : arguments[1], "oldValue" : arguments[2], "rowNum" : arguments[3], "colNum" : arguments[4], "grid" : arguments[5]};
            var event = @com.smartgwt.client.widgets.grid.events.CellSavedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellSavedEvent()();
            if (hasDefaultHandler) this.Super("cellChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellChanged"));
            obj.addProperties({cellChanged:  cellChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellChanged"));
            obj.cellChanged =  cellChanged             ;
        }
    }-*/;

    private void handleTearDownCellSavedEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellSavedEvent.getType()) == 0) tearDownCellSavedEvent();
    }

    private native void tearDownCellSavedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellChanged")) delete obj.cellChanged;
    }-*/;

    /**
     * Add a cellClick handler.
     * <p>
     * Called when a cell receives a click event. <P> Note that returning false from this method will not prevent any specified
     * {@link com.smartgwt.client.widgets.grid.ListGrid#rowClick ListGrid.rowClick()} handler from firing.
     *
     * @param handler the cellClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellClickHandler(com.smartgwt.client.widgets.grid.events.CellClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellClickEvent.getType()) == 0) setupCellClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellClickEvent.getType());
    }

    private native void setupCellClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellClickEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellClick"));
            obj.addProperties({cellClick: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellClick"));
            obj.cellClick = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellClick", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellClickEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellClickEvent.getType()) == 0) tearDownCellClickEvent();
    }

    private native void tearDownCellClickEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellClick")) delete obj.cellClick;
    }-*/;

    /**
     * Add a cellContextClick handler.
     * <p>
     * Called when a cell receives a contextclick event.
     *
     * @param handler the cellContextClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellContextClickHandler(com.smartgwt.client.widgets.grid.events.CellContextClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellContextClickEvent.getType()) == 0) setupCellContextClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellContextClickEvent.getType());
    }

    private native void setupCellContextClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellContextClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellContextClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellContextClickEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellContextClick"));
            obj.addProperties({cellContextClick: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellContextClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellContextClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellContextClick"));
            obj.cellContextClick = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellContextClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellContextClick", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellContextClickEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellContextClickEvent.getType()) == 0) tearDownCellContextClickEvent();
    }

    private native void tearDownCellContextClickEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellContextClick")) delete obj.cellContextClick;
    }-*/;

    /**
     * Add a cellDoubleClick handler.
     * <p>
     * Called when a cell receives a double click event.
     *
     * @param handler the cellDoubleClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellDoubleClickHandler(com.smartgwt.client.widgets.grid.events.CellDoubleClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent.getType()) == 0) setupCellDoubleClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent.getType());
    }

    private native void setupCellDoubleClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellDoubleClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellDoubleClickEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellDoubleClick"));
            obj.addProperties({cellDoubleClick: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellDoubleClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellDoubleClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellDoubleClick"));
            obj.cellDoubleClick = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellDoubleClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellDoubleClick", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellDoubleClickEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent.getType()) == 0) tearDownCellDoubleClickEvent();
    }

    private native void tearDownCellDoubleClickEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellDoubleClick")) delete obj.cellDoubleClick;
    }-*/;

    /**
     * Add a cellErrorIconHover handler.
     * <p>
     * Optional stringMethod to fire when the user hovers over the error icon of a cell with  validation errors.  The default
     * behavior is to show a hover canvas containing the validation error message text. Call {@link
     * com.smartgwt.client.widgets.grid.events.CellErrorIconHoverEvent#cancel()} from within {@link
     * com.smartgwt.client.widgets.grid.events.CellErrorIconHoverHandler#onCellErrorIconHover} to suppress this default
     * behavior.
     *
     * @param handler the cellErrorIconHover handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellErrorIconHoverHandler(com.smartgwt.client.widgets.grid.events.CellErrorIconHoverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellErrorIconHoverEvent.getType()) == 0) setupCellErrorIconHoverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellErrorIconHoverEvent.getType());
    }

    private native void setupCellErrorIconHoverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellErrorIconHover = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellErrorIconHoverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellErrorIconHoverEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellErrorIconHover"));
            obj.addProperties({cellErrorIconHover: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellErrorIconHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellErrorIconHover", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellErrorIconHover"));
            obj.cellErrorIconHover = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellErrorIconHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellErrorIconHover", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellErrorIconHoverEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellErrorIconHoverEvent.getType()) == 0) tearDownCellErrorIconHoverEvent();
    }

    private native void tearDownCellErrorIconHoverEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellErrorIconHover")) delete obj.cellErrorIconHover;
    }-*/;

    /**
     * Add a cellErrorIconOut handler.
     * <p>
     * Optional stringMethod to fire when the mouse moves off the error icon of a cell with  validation errors.
     *
     * @param handler the cellErrorIconOut handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellErrorIconOutHandler(com.smartgwt.client.widgets.grid.events.CellErrorIconOutHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellErrorIconOutEvent.getType()) == 0) setupCellErrorIconOutEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellErrorIconOutEvent.getType());
    }

    private native void setupCellErrorIconOutEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellErrorIconOut = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellErrorIconOutEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellErrorIconOutEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellErrorIconOut"));
            obj.addProperties({cellErrorIconOut: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellErrorIconOut(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellErrorIconOut", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellErrorIconOut"));
            obj.cellErrorIconOut = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellErrorIconOut(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellErrorIconOut", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellErrorIconOutEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellErrorIconOutEvent.getType()) == 0) tearDownCellErrorIconOutEvent();
    }

    private native void tearDownCellErrorIconOutEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellErrorIconOut")) delete obj.cellErrorIconOut;
    }-*/;

    /**
     * Add a cellErrorIconOver handler.
     * <p>
     * Optional stringMethod to fire when the mouse moves over the error icon of a cell with  validation errors.
     *
     * @param handler the cellErrorIconOver handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellErrorIconOverHandler(com.smartgwt.client.widgets.grid.events.CellErrorIconOverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellErrorIconOverEvent.getType()) == 0) setupCellErrorIconOverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellErrorIconOverEvent.getType());
    }

    private native void setupCellErrorIconOverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellErrorIconOver = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellErrorIconOverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellErrorIconOverEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellErrorIconOver"));
            obj.addProperties({cellErrorIconOver: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellErrorIconOver(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellErrorIconOver", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellErrorIconOver"));
            obj.cellErrorIconOver = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellErrorIconOver(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellErrorIconOver", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellErrorIconOverEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellErrorIconOverEvent.getType()) == 0) tearDownCellErrorIconOverEvent();
    }

    private native void tearDownCellErrorIconOverEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellErrorIconOver")) delete obj.cellErrorIconOver;
    }-*/;

	/**
     * If this listGrid can be edited, this method will return true if the cell passed in has been edited, but the edits have
     * not yet been saved to the ListGrid's data object.
     * @param rowNum index of row to check for changes
     * @param colNum index of the col to check for changes
     *
     * @return returns true if the cell has unsaved edits
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native Boolean cellHasChanges(int rowNum, int colNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cellHasChanges", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellHasChanges(rowNum, colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Given a rowNum and a colNum or fieldName, determine whether we currently have stored validation errors for the
     * record/field in question.
     * @param rowNum index of row to check for validation errors
     * @param fieldID name of field, or index of column to check for validation                                      errors
     *
     * @return true if we have validation errors for the row/col in question
     * @see com.smartgwt.client.widgets.grid.ListGrid#hasErrors
     * @see com.smartgwt.client.widgets.grid.ListGrid#rowHasErrors
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native Boolean cellHasErrors(int rowNum, String fieldID) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cellHasErrors", "int,String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellHasErrors(rowNum, fieldID);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

    /**
     * Add a cellHover handler.
     * <p>
     * Called when the mouse hovers over a cell if this.canHover is true.   Returning false will suppress the hover text from
     * being shown if this.showHover is true.
     *
     * @param handler the cellHover handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellHoverHandler(com.smartgwt.client.widgets.grid.events.CellHoverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellHoverEvent.getType()) == 0) setupCellHoverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellHoverEvent.getType());
    }

    private native void setupCellHoverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellHover = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellHoverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellHoverEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellHover"));
            obj.addProperties({cellHover: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellHover", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellHover"));
            obj.cellHover = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellHover", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellHoverEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellHoverEvent.getType()) == 0) tearDownCellHoverEvent();
    }

    private native void tearDownCellHoverEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellHover")) delete obj.cellHover;
    }-*/;

    /**
     * Add a cellMouseDown handler.
     * <p>
     * Called when a cell receives a mousedown event.
     *
     * @param handler the cellMouseDown handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellMouseDownHandler(com.smartgwt.client.widgets.grid.events.CellMouseDownHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellMouseDownEvent.getType()) == 0) setupCellMouseDownEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellMouseDownEvent.getType());
    }

    private native void setupCellMouseDownEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellMouseDown = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellMouseDownEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellMouseDownEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellMouseDown"));
            obj.addProperties({cellMouseDown: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseDown(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseDown", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellMouseDown"));
            obj.cellMouseDown = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseDown(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseDown", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellMouseDownEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellMouseDownEvent.getType()) == 0) tearDownCellMouseDownEvent();
    }

    private native void tearDownCellMouseDownEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellMouseDown")) delete obj.cellMouseDown;
    }-*/;

    /**
     * Add a cellMouseUp handler.
     * <p>
     * Called when a cell receives a mouseup event.
     *
     * @param handler the cellMouseUp handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellMouseUpHandler(com.smartgwt.client.widgets.grid.events.CellMouseUpHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellMouseUpEvent.getType()) == 0) setupCellMouseUpEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellMouseUpEvent.getType());
    }

    private native void setupCellMouseUpEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellMouseUp = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellMouseUpEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellMouseUpEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellMouseUp"));
            obj.addProperties({cellMouseUp: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseUp(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseUp", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellMouseUp"));
            obj.cellMouseUp = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseUp(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseUp", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellMouseUpEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellMouseUpEvent.getType()) == 0) tearDownCellMouseUpEvent();
    }

    private native void tearDownCellMouseUpEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellMouseUp")) delete obj.cellMouseUp;
    }-*/;

    /**
     * Add a cellOut handler.
     * <p>
     * Called when the mouse pointer leaves a cell
     *
     * @param handler the cellOut handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellOutHandler(com.smartgwt.client.widgets.grid.events.CellOutHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellOutEvent.getType()) == 0) setupCellOutEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellOutEvent.getType());
    }

    private native void setupCellOutEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellOut = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellOutEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellOutEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellOut"));
            obj.addProperties({cellOut: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOut(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOut", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellOut"));
            obj.cellOut = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOut(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOut", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellOutEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellOutEvent.getType()) == 0) tearDownCellOutEvent();
    }

    private native void tearDownCellOutEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellOut")) delete obj.cellOut;
    }-*/;

    /**
     * Add a cellOver handler.
     * <p>
     * Called when the mouse pointer enters a cell
     *
     * @param handler the cellOver handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellOverHandler(com.smartgwt.client.widgets.grid.events.CellOverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellOverEvent.getType()) == 0) setupCellOverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellOverEvent.getType());
    }

    private native void setupCellOverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellOver = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellOverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellOverEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellOver"));
            obj.addProperties({cellOver: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOver(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOver", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellOver"));
            obj.cellOver = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOver(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOver", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellOverEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellOverEvent.getType()) == 0) tearDownCellOverEvent();
    }

    private native void tearDownCellOverEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellOver")) delete obj.cellOver;
    }-*/;

    /**
     * Add a cellSelectionChanged handler.
     * <p>
     * Called when (cell-based) selection changes within this grid.
     *
     * @param handler the cellSelectionChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellSelectionChangedHandler(com.smartgwt.client.widgets.grid.events.CellSelectionChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent.getType()) == 0) setupCellSelectionChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent.getType());
    }

    private native void setupCellSelectionChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellSelectionChanged = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellSelectionChangedEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellSelectionChanged"));
            obj.addProperties({cellSelectionChanged: 
                function () {
                    var param = {"_this": this, "cellList" : arguments[0]};
                    var ret = cellSelectionChanged(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellSelectionChanged", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellSelectionChanged"));
            obj.cellSelectionChanged = 
                function () {
                    var param = {"_this": this, "cellList" : arguments[0]};
                    var ret = cellSelectionChanged(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellSelectionChanged", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellSelectionChangedEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent.getType()) == 0) tearDownCellSelectionChangedEvent();
    }

    private native void tearDownCellSelectionChangedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellSelectionChanged")) delete obj.cellSelectionChanged;
    }-*/;

    /**
     * Add a cellValueHover handler.
     * <p>
     * Optional stringMethod to fire when the user hovers over a cell and the value is clipped. If
     * this.showClippedValuesOnHover is true, the default behavior is to show a hover canvas containing the HTML returned by
     * cellValueHoverHTML(). Call {@link com.smartgwt.client.widgets.grid.events.CellValueHoverEvent#cancel()} from within
     * {@link com.smartgwt.client.widgets.grid.events.CellValueHoverHandler#onCellValueHover} to suppress this default
     * behavior.
     *
     * @param handler the cellValueHover handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellValueHoverHandler(com.smartgwt.client.widgets.grid.events.CellValueHoverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellValueHoverEvent.getType()) == 0) setupCellValueHoverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellValueHoverEvent.getType());
    }

    private native void setupCellValueHoverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellValueHover = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellValueHoverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownCellValueHoverEvent()();
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellValueHover"));
            obj.addProperties({cellValueHover: 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellValueHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellValueHover", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellValueHover"));
            obj.cellValueHover = 
                function () {
                    var param = {"_this": this, "record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellValueHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellValueHover", arguments);
                    }
                    return ret;
                }
            ;
        }
    }-*/;

    private void handleTearDownCellValueHoverEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.CellValueHoverEvent.getType()) == 0) tearDownCellValueHoverEvent();
    }

    private native void tearDownCellValueHoverEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("cellValueHover")) delete obj.cellValueHover;
    }-*/;

	/**
     * Returns the HTML that is displayed by the default cellValueHover handler. Return null or an empty string to cancel the
     * hover. <p>Use <code>setCellValueHoverFormatter()</code> to provide a custom implementation.
     * @param record cell record as returned by getCellRecord()
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     * @param defaultHTML the HTML that would have been displayed by default.
     * See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     *
     * @return HTML to be displayed in the hover. If null or an empty string, then the hover is canceled.
     * See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     * @see com.smartgwt.client.widgets.grid.events.CellValueHoverEvent
     */
    public native String cellValueHoverHTML(ListGridRecord record, int rowNum, int colNum, String defaultHTML) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cellValueHoverHTML", "ListGridRecord,int,int,String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellValueHoverHTML(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum, defaultHTML);
        return ret;
    }-*/;

	/**
     * Is the value in a given cell clipped?
     * @param rowNum row number of the cell
     * @param colNum column number of the cell
     *
     * @return null if there is no cell at the given row, column; otherwise, whether the value in the specified cell is clipped.
     * @see com.smartgwt.client.widgets.grid.events.CellValueHoverEvent
     */
    public native Boolean cellValueIsClipped(int rowNum, int colNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "cellValueIsClipped", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellValueIsClipped(rowNum, colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Chart the data in this listGrid as a multi-series chart. <P> Each row provides a series of data.  Each series of data is
     * labeled by a value from one column, called the <code>labelField</code>. <P> For example, cell values are sales figures,
     * and fields are "Product", "August", "September", "October".  In this case each row gives a series: sales figures for
     * each of 3 months.  The <code>labelField</code> in this case is the "Product" field, meaning each row represents sales
     * figures for each of 3 months for a particular product.  This dataset can be charted via any multi-series chart: stacked
     * or clustered bar or column chart, line chart with multiple lines, or area chart (stacked lines). <P> By default, all
     * visible fields other than the label field are assumed to be labels for series values, but an explicit list of fields can
     * be provided as <code>dataFields</code>. <P> By default, all data is charted if all data is loaded, otherwise, data
     * visible in the viewport is charted.  An explicit set of rows can be provided via <code>dataRows</code>.
     * @param labelField name of the field
     *
     * @return created Chart instance
     * @see <a href="http://www.smartclient.com/smartgwtee/showcase/#gridCharting" target="examples">Grid Charting Example</a>
     */
    public native FacetChart chartData(String labelField) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "chartData", "String");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.chartData(labelField);
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * @see ListGrid#chartData
     */
    public FacetChart chartData(String labelField, String[] dataFields){
        return chartData(labelField, dataFields, null, null, false);
    }

    /**
     * @see ListGrid#chartData
     */
    public FacetChart chartData(String labelField, String[] dataFields, ListGridRecord... dataRows){
        return chartData(labelField, dataFields, dataRows, null, false);
    }

    /**
     * @see ListGrid#chartData
     */
    public FacetChart chartData(String labelField, String[] dataFields, ListGridRecord[] dataRows, FacetChart chartProperties){
        return chartData(labelField, dataFields, dataRows, chartProperties, false);
    }

	/**
     * Chart the data in this listGrid as a multi-series chart. <P> Each row provides a series of data.  Each series of data is
     * labeled by a value from one column, called the <code>labelField</code>. <P> For example, cell values are sales figures,
     * and fields are "Product", "August", "September", "October".  In this case each row gives a series: sales figures for
     * each of 3 months.  The <code>labelField</code> in this case is the "Product" field, meaning each row represents sales
     * figures for each of 3 months for a particular product.  This dataset can be charted via any multi-series chart: stacked
     * or clustered bar or column chart, line chart with multiple lines, or area chart (stacked lines). <P> By default, all
     * visible fields other than the label field are assumed to be labels for series values, but an explicit list of fields can
     * be provided as <code>dataFields</code>. <P> By default, all data is charted if all data is loaded, otherwise, data
     * visible in the viewport is charted.  An explicit set of rows can be provided via <code>dataRows</code>.
     * @param labelField name of the field
     * @param dataFields optional list of fields to use as labels.  By      default, all fields are used.
     * @param dataRows set of records to chart.  Can be obtained by eg      {@link com.smartgwt.client.data.ResultSet#getRange
     * grid.data.getRange()}.
     * @param chartProperties properties to pass to the created chart
     * @param labelFieldFirst if true, use the labelField as the "first" set of labels,      for example, as the bar labels in a stacked bar chart,
     * whereas the second set of labels      would appear as the legend.
     *
     * @return created Chart instance
     * @see <a href="http://www.smartclient.com/smartgwtee/showcase/#gridCharting" target="examples">Grid Charting Example</a>
     */
    public native FacetChart chartData(String labelField, String[] dataFields, ListGridRecord[] dataRows, FacetChart chartProperties, boolean labelFieldFirst) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "chartData", "String,String[],ListGridRecord[],FacetChart,boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.chartData(labelField, @com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(dataFields), @com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(dataRows), chartProperties == null ? null : chartProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), labelFieldFirst);
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Clear the current criteria used to filter data.
     * @see com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_filter" target="examples">Databound filter Example</a>
     */
    public native void clearCriteria() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearCriteria", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearCriteria();
    }-*/;

    /**
     * @see ListGrid#clearCriteria
     */
    public void clearCriteria(DSCallback callback){
        clearCriteria(callback, null);
    }

	/**
     * Clear the current criteria used to filter data.
     * @param callback callback to invoke on completion
     * @param requestProperties additional properties to set on the DSRequest                                            that will be issued
     * @see com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_filter" target="examples">Databound filter Example</a>
     */
    public native void clearCriteria(DSCallback callback, DSRequest requestProperties) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearCriteria", "DSCallback,DSRequest");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearCriteria(
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Clears any validation errors for some cell.
     * @param rowNum row index of cell to add validation error for
     * @param fieldName col index or field name of cell to add validation error for
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFieldError
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native void clearFieldError(int rowNum, int fieldName) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearFieldError", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearFieldError(rowNum, fieldName);
    }-*/;

	/**
     * Clear any stored validation errors for some row
     * @param rowNum index of row to clear validation error for
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRowErrors
     * @see com.smartgwt.client.docs.Validation Validation overview and related methods
     */
    public native void clearRowErrors(int rowNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearRowErrors", "int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearRowErrors(rowNum);
    }-*/;

	/**
     * This method clears any existing sort on this grid by calling {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort()} with a null parameter.  The internal list of {@link com.smartgwt.client.data.SortSpecifier}s is removed and
     * the grid is unsorted.
     */
    public native void clearSort() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearSort", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearSort();
    }-*/;

	/**
     * Closes the node represented by the "record" parameter, if it is a folder and is not already closed.  This method only
     * applies to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} ListGrids.
     * @param record node to close
     *
     * @return true if the node was closed, false if it was not (either because it is not                   a folder, or because it was
     * already closed)
     */
    public native boolean closeGroup(Record record) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "closeGroup", "Record");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.closeGroup(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret == null ? false : ret;
    }-*/;

	/**
     * Collapses a given {@link com.smartgwt.client.widgets.grid.ListGridRecord record} which has been previously expanded
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord expandRecord()}. <P> Depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponentPoolingMode pooling mode}, this method may automatically
     * destroy expansionComponents.  By default, components created automatically by the ListGrid will be auto-destroyed.  This
     * behavior can be changed by setting a different pooling mode. <P> Note that components created via an override to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent getExpansionComponent()} will <b><i>not</i></b> be
     * auto-destroyed - developers should override <code>collapseRecord</code> to take care of clean-up for such components.
     * @param record record to collapse
     */
    public native void collapseRecord(ListGridRecord record) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "collapseRecord", "ListGridRecord");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.collapseRecord(record.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

	/**
     * Collapses the passed list of expanded {@link com.smartgwt.client.widgets.grid.ListGridRecord records}.  Calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#collapseRecord collapseRecord} for each passed record, but only marks the grid
     * for redraw once, after all records have been collapsed.
     * @param records records to collapse
     */
    public native void collapseRecords(ListGridRecord... records) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "collapseRecords", "ListGridRecord...");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.collapseRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;

	/**
     * Open a MultiGroupDialog to configure the fields used for grouping.
     */
    public native void configureGrouping() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "configureGrouping", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.configureGrouping();
    }-*/;

	/**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this method
     * is called to create per-row or per-cell embedded components to display in the grid. <p> The colNum parameter is
     * applicable only when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <p> If this row should not have a <code>recordComponent</code>, return null. <p>
     * This method should create and return a new component for the record passed in every time it is called and never return
     * the same Canvas instance twice.  To re-use components with different rows, set {@link
     * com.smartgwt.client.types.RecordComponentPoolingMode} to "recycle".  In this mode, in addition to implementing this
     * method, developers should also implement {@link com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     * updateRecordComponent()} which allows already created components to be altered for re-use in new records. See the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} overview for more information.
     * @param record record to create a component for
     * @param colNum cell to which the component applies
     *
     * @return return the component to embed in the passed record
     */
    protected native Canvas createRecordComponent(ListGridRecord record, Integer colNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "createRecordComponent", "ListGridRecord,Integer");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__createRecordComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * Add a dataArrived handler.
     * <p>
     * Notification method fired when new data arrives from the server to be displayed in this ListGrid, (for example in
     * response to the user scrolling a new set of rows into view). Only applies to databound listGrids where the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getData data} attribute is a {@link com.smartgwt.client.data.ResultSet}. This
     * ResultSet may have been created manually and applied to the grid via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData ListGrid.setData()} or may have been created and automatically
     * assigned if {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} was used to populate the
     * grid.  This method is fired directly in response to {@link com.smartgwt.client.data.ResultSet#addDataArrivedHandler
     * dataArrived()} firing on the data object. <P> Note that <code>dataArrived()</code>, unlike {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addDataChangedHandler ListGrid.dataChanged()}, only fires in limited
     * circumstances - when data for a {@link com.smartgwt.client.data.ResultSet} arrives from the server due to a fetch or
     * cache invalidation, or as a result of filtering.  If you want to catch all data changes, you should instead react to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#addDataChangedHandler ListGrid.dataChanged()}.
     *
     * @param handler the dataArrived handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addDataArrivedHandler(com.smartgwt.client.widgets.grid.events.DataArrivedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.DataArrivedEvent.getType()) == 0) setupDataArrivedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.DataArrivedEvent.getType());
    }

    private native void setupDataArrivedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var dataArrived = $entry(function(){
            var param = {"_this": this, "startRow" : arguments[0], "endRow" : arguments[1]};
            var event = @com.smartgwt.client.widgets.grid.events.DataArrivedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownDataArrivedEvent()();
            if (hasDefaultHandler) this.Super("dataArrived", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("dataArrived"));
            obj.addProperties({dataArrived:  dataArrived              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("dataArrived"));
            obj.dataArrived =  dataArrived             ;
        }
    }-*/;

    private void handleTearDownDataArrivedEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.DataArrivedEvent.getType()) == 0) tearDownDataArrivedEvent();
    }

    private native void tearDownDataArrivedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("dataArrived")) delete obj.dataArrived;
    }-*/;

    /**
     * Add a dataChanged handler.
     * <p>
     * Notification method fired when the ListGrid's data changes, for any reason. <P>  Examples of why data changed might
     * be:<ul> <li> a call to {@link com.smartgwt.client.widgets.grid.ListGrid#addData ListGrid.addData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateData ListGrid.updateData()}, or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData ListGrid.removeData()} <li> {@link
     * com.smartgwt.client.data.DataSource} updates from the server for {@link com.smartgwt.client.data.ResultSet} data
     * (triggered by record editing, etc.) <li> fetches arriving back from the server for {@link
     * com.smartgwt.client.data.ResultSet} data <li> changes to array data if made through APIs such as  Array.set(), 
     * Array.add(), etc. <li> cache invalidation <li> filtering </ul> Calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData ListGrid.setData()} doesn't call this notification directly, but it
     * may fire if one of the above listed events is triggered (e.g. a server fetch for  {@link
     * com.smartgwt.client.data.ResultSet} data). <P> Note that the <code>operationType</code> parameter is optional and will
     * be passed and contain the operation (e.g. "update") if this notification was triggered by a fetch, an {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData ListGrid.addData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateData ListGrid.updateData()}, or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeData ListGrid.removeData()}, or a {@link
     * com.smartgwt.client.data.DataSource} update for {@link com.smartgwt.client.data.ResultSet} data (the first three reasons
     * listed above) but otherwise will be null.
     *
     * @param handler the dataChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addDataChangedHandler(com.smartgwt.client.widgets.grid.events.DataChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.DataChangedEvent.getType()) == 0) setupDataChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.DataChangedEvent.getType());
    }

    private native void setupDataChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var dataChanged = $entry(function(){
            var param = {"_this": this, "operationType" : arguments[0]};
            var event = @com.smartgwt.client.widgets.grid.events.DataChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownDataChangedEvent()();
            if (hasDefaultHandler) this.Super("dataChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("dataChanged"));
            obj.addProperties({dataChanged:  dataChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("dataChanged"));
            obj.dataChanged =  dataChanged             ;
        }
    }-*/;

    private void handleTearDownDataChangedEvent() {
        if (getHandlerCount(com.smartgwt.client.widgets.grid.events.DataChangedEvent.getType()) == 0) tearDownDataChangedEvent();
    }

    private native void tearDownDataChangedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        }
        if (obj && obj.hasOwnProperty("dataChanged")) delete obj.dataChanged;
    }-*/;

	/**
     * Deselect a contiguous range of records by index. <P> This is a synonym for <code>selectRange(startRow, endRow,
     * false);</code>
     * @param startRow start of selection range
     * @param endRow end of selection range (non-inclusive)
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public native void deselectRange(int startRow, int endRow) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "deselectRange", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.deselectRange(startRow, endRow);
    }-*/;

	/**
     * Cancel outstanding edits, discarding edit values, and hiding editors for the record[s] passed in if appropriate. <P> If
     * no rows are passed in, all outstanding edit values will be dropped.  This will <b>not</b> automatically end editing;
     * call {@link com.smartgwt.client.widgets.grid.ListGrid#endEditing endEditing()} <b>before</b> calling discardAllEdits()
     * if you also want to end editing. <P> Note that this also clears the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of any records that have been marked as
     * removed.
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardAllEdits() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "discardAllEdits", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardAllEdits();
    }-*/;

    /**
     * @see ListGrid#discardAllEdits
     */
    public void discardAllEdits(int[] rows){
        discardAllEdits(rows, false);
    }

	/**
     * Cancel outstanding edits, discarding edit values, and hiding editors for the record[s] passed in if appropriate. <P> If
     * no rows are passed in, all outstanding edit values will be dropped.  This will <b>not</b> automatically end editing;
     * call {@link com.smartgwt.client.widgets.grid.ListGrid#endEditing endEditing()} <b>before</b> calling discardAllEdits()
     * if you also want to end editing. <P> Note that this also clears the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of any records that have been marked as
     * removed.
     * @param rows allows you to specify which row(s) to drop edits for
     * @param dontHideEditor By default this method will hide the editor if                              it is currently showing for any row in the
     * grid. Passing in                              this parameter will leave the editor visible (and just reset              
     *                the edit values underneath the editor).
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardAllEdits(int[] rows, boolean dontHideEditor) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "discardAllEdits", "int[],boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardAllEdits(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([I)(rows), dontHideEditor);
    }-*/;
	
	/**
     * Cancel outstanding edits for the specified rows, discarding edit values, and hiding editors if appropriate. <P> Note
     * that if this method is called on a new edit row (created via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditingNew startEditingNew()} for example), which has not yet been saved,
     * this method will remove the row entirely. <P> Also note that this method will clear the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of records that have been marked as removed.
     * @param rowNum Row to cancel
     * @param colNum Column to cancel. Note that this parameter is ignored in ListGrids but                        may be required in
     * subclasses of ListGrid where each cell represents                        one record in the data set (EG CubeGrid)
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardEdits(int rowNum, int colNum) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "discardEdits", "int,int");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardEdits(rowNum, colNum);
    }-*/;

	/**
     * Cancel outstanding edits for the specified rows, discarding edit values, and hiding editors if appropriate. <P> Note
     * that if this method is called on a new edit row (created via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditingNew startEditingNew()} for example), which has not yet been saved,
     * this method will remove the row entirely. <P> Also note that this method will clear the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of records that have been marked as removed.
     * @param rowNum Row to cancel
     * @param colNum Column to cancel. Note that this parameter is ignored in ListGrids but                        may be required in
     * subclasses of ListGrid where each cell represents                        one record in the data set (EG CubeGrid)
     * @param dontHideEditor By default this method will hide the editor if                              it is currently showing for the row in
     * question. Passing in                              this parameter will leave the editor visible (and just reset          
     *                    the edit values underneath the editor).
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardEdits(int rowNum, int colNum, Boolean dontHideEditor) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "discardEdits", "int,int,Boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardEdits(rowNum, colNum, dontHideEditor == null ? null : dontHideEditor.@java.lang.Boolean::booleanValue()());
    }-*/;
	
	/**
     * Modify the grid UI to reflect the parameter sortSpecifiers.  For a single sortSpecifier,  this consists of marking the
     * field with a directional arrow in its header button (if it  visible). <P> If multiple fields are sorted, those that are
     * visible show a directional icon and a small {@link com.smartgwt.client.widgets.grid.ListGrid#getSortNumeralStyle
     * sort-numeral} indicating that field's index in the sort  configuration. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSort addSort()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#toggleSort toggleSort()} APIs for information on making changes to the current
     * sort configuration. <p> <b>NOTE:</b> This method is primarily used by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort setSort()}; it is not intended  to be called by user code, unless you
     * are implementing a custom  {@link com.smartgwt.client.widgets.grid.ListGrid#addSetSortHandler setSortHandler}).  For the
     * normal use case, calling this  method directly will fail to execute vital pre-steps.  If you are not implementing a
     * custom handler as described above, do not call this method directly - call <code>setSort()</code>  instead.
     * @param sortSpecifiers Array of {@link com.smartgwt.client.data.SortSpecifier} objects
     */
    public native void displaySort(SortSpecifier... sortSpecifiers) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "displaySort", "SortSpecifier...");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.displaySort(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(sortSpecifiers));
    }-*/;

    /**
     * Add a drawAreaChanged handler.
     * <p>
     * Notification method that fires when the drawArea changes due to scrolling.  Receives the previous drawArea co-ordinates
     * as parameters.  Call {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawArea ListGrid.getDrawArea()} to get the new
     * drawArea co-ordinates. <P> Note that if this grid is showing any {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, they will not be included in the
     * <code>oldStartCol</code>, <code>oldEndCol</code> range reported by this method. Frozen fields are assumed never to be
     * scrolled out of view.
     *
     * @param handler the drawAreaChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addDrawAreaChangedHandler(com.smartgwt.client.widgets.grid.events.DrawAreaChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.DrawAreaChangedEvent.getType()) == 0) setupDrawAreaChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.DrawAreaChangedEvent.getType());
    }

    private native void setupDrawAreaChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var drawAreaChanged = $entry(function(){
            var param = {"_this": this, "oldStartRow" : arguments[0], "oldEndRow" : arguments[1], "oldStartCol" : arguments[2], "oldEndCol" : arguments[3]};
            var event = @com.smartgwt.client.widgets.grid.events.DrawAreaChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            selfJ.@com.smartgwt.client.widgets.grid.ListGrid::handleTearDownDrawAreaChangedEvent()();
            if (hasDefaultHandler) this.Super("drawAreaChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("drawAreaChanged"));
            obj.addProperties({drawAreaChanged:  drawAreaChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();