/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SeleneseRunnerProperties;
import com.isomorphic.webdriver.SeleneseTestCaseParser;
import com.isomorphic.webdriver.SmartClientChromeDriver;
import com.isomorphic.webdriver.SmartClientFirefoxDriver;
import com.isomorphic.webdriver.SmartClientIEDriver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SeleneseRunner {
    private static final String SOURCE_OUT_LABEL = "*** Generating WebDriver Java to: ";
    private static final String CAPABILITIES_IN_LABEL = "*** Setting driver capabilities from properties file: ";

    public static void main(String[] args) throws ParserException, IOException {
        boolean allPassed = true;
        boolean quiet = false;
        boolean debug = false;
        String baseUrl = null;
        PrintStream sourceOut = null;
        SeleneseRunnerProperties driverProps = null;
        LinkedList<String> testFiles = new LinkedList<String>();
        Class browserDriver = SmartClientFirefoxDriver.class;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-ff".equals(arg) || "-firefox".equals(arg)) {
                browserDriver = SmartClientFirefoxDriver.class;
                continue;
            }
            if ("-ie".equals(arg) || "-internetexplorer".equals(arg)) {
                browserDriver = SmartClientIEDriver.class;
                continue;
            }
            if ("-ch".equals(arg) || "-chrome".equals(arg)) {
                browserDriver = SmartClientChromeDriver.class;
                continue;
            }
            if ("-d".equals(arg) || "-debug".equals(arg)) {
                debug = true;
                continue;
            }
            if ("-q".equals(arg) || "-quiet".equals(arg)) {
                quiet = true;
                continue;
            }
            if ("-p".equals(arg)) {
                if (++i >= args.length) {
                    SeleneseRunner.usageError();
                    continue;
                }
                try {
                    arg = args[i];
                    driverProps = new SeleneseRunnerProperties(arg);
                    if (quiet) continue;
                    System.out.println(CAPABILITIES_IN_LABEL + arg);
                }
                catch (FileNotFoundException e) {
                    System.err.println("!!! Config file not found: " + arg + "\n");
                    SeleneseRunner.usageError();
                }
                continue;
            }
            if ("-s".equals(arg)) {
                String sourceOutBanner = SOURCE_OUT_LABEL;
                if (++i >= args.length) {
                    SeleneseRunner.usageError();
                    continue;
                }
                arg = args[i];
                if ("-".equals(arg)) {
                    sourceOut = System.out;
                    sourceOutBanner = sourceOutBanner + "STDOUT";
                } else {
                    sourceOut = new PrintStream(arg);
                    sourceOutBanner = sourceOutBanner + arg;
                }
                if (quiet) continue;
                System.out.println(sourceOutBanner);
                continue;
            }
            testFiles.add(arg);
        }
        if (testFiles.size() < 1) {
            SeleneseRunner.usageError();
        } else {
            Pattern urlPattern = Pattern.compile("(https?|ftp):.*");
            Matcher urlMatcher = urlPattern.matcher((CharSequence)testFiles.get(0));
            if (urlMatcher.matches()) {
                baseUrl = (String)testFiles.remove(0);
                if (!quiet) {
                    System.out.println("*** Using baseUrl: " + baseUrl);
                }
            } else if (debug) {
                debug = false;
                System.err.println("!!! No browser will be opened - ignoring debug option");
            }
        }
        if (baseUrl == null && sourceOut == null) {
            SeleneseRunner.usageError();
        }
        String action = baseUrl != null ? "translation & execution" : "translation";
        for (String fileName : testFiles) {
            if (!quiet) {
                System.out.println("*** Beginning " + action + " of " + fileName);
            }
            String content = SeleneseRunner.getTestContent(fileName);
            if (sourceOut != null) {
                sourceOut.println("@Test\npublic void " + SeleneseRunner.getTestName(fileName) + "() {");
            }
            boolean passed = SeleneseRunner.parseEntry(browserDriver, driverProps, baseUrl, content, sourceOut, debug);
            if (!quiet) {
                System.out.println("*** Finished " + fileName + " with status: " + (passed ? "PASS" : "FAIL"));
            }
            if (sourceOut != null) {
                sourceOut.println("}\n");
            }
            allPassed &= passed;
        }
        System.exit(allPassed ? 0 : -1);
    }

    private static String getTestContent(String fileName) throws IOException {
        String line;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            System.err.println("!!! File not found: " + fileName + "\n");
            SeleneseRunner.usageError();
        }
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    private static String getTestName(String fileName) {
        int indexOf = fileName.indexOf(".rctest.html");
        if (indexOf < 0) {
            SeleneseRunner.usageError();
        }
        String baseName = fileName.substring(0, indexOf);
        return baseName.replace("-", "_");
    }

    private static void usageError() {
        System.err.println("Usage: [-ff|-ie|-ch] [-d|-debug] [-q|-quiet] [-p <configFile>] [-s <sourceFile>] [<baseUrl>] <testFile>...");
        System.err.println(" -ff | -ie | -ch to specify the browser to be used. Default is FireFox");
        System.err.println(" -d | -debug outputs actions being executed and inserts a 5 second delay between each");
        System.err.println(" -q | -quiet means that results are not reported. Exit status of 0 implies all successful");
        System.err.println(" -s <sourceFile> : approximate java code for JUnit type testing is produced");
        System.err.println("");
        System.err.println("Note that baseUrl must be provided if you want the script to execute, and that it's required");
        System.err.println("if you don't provide the sourceFile argument, since otherwise SeleneseRunner will have ");
        System.err.println("nothing to do.  Test files must adhere to the standard naming pattern [Test Name].rctest.html");
        System.exit(1);
    }

    private static boolean parseEntry(SeleneseTestCaseParser visitor, String content) throws ParserException {
        Parser parser = new Parser(new Lexer(new Page(content, "UTF-8")));
        parser.visitAllNodesWith((NodeVisitor)visitor);
        return visitor.getResult();
    }

    private static boolean parseEntry(Class browserDriver, SeleneseRunnerProperties driverProps, String baseUrl, String content, PrintStream sourceOut, boolean debug) throws ParserException {
        SeleneseTestCaseParser visitor = new SeleneseTestCaseParser(browserDriver, driverProps, baseUrl, sourceOut, debug);
        return SeleneseRunner.parseEntry(visitor, content);
    }

    private static boolean parseEntry(Class browserDriver, DesiredCapabilities capabilities, String baseUrl, String content, PrintStream sourceOut, boolean debug) throws ParserException {
        SeleneseTestCaseParser visitor = new SeleneseTestCaseParser(browserDriver, capabilities, baseUrl, sourceOut, debug);
        return SeleneseRunner.parseEntry(visitor, content);
    }

    public static boolean executeSelenese(String baseUrl, String content, Class driverClass) throws ParserException {
        if (driverClass == null) {
            driverClass = SmartClientFirefoxDriver.class;
        }
        return SeleneseRunner.parseEntry(driverClass, (DesiredCapabilities)null, baseUrl, content, null, false);
    }

    public static boolean executeSelenese(String baseUrl, String content) throws ParserException {
        return SeleneseRunner.executeSelenese(baseUrl, content, null);
    }

    public static boolean executeSelenese(String baseUrl, String testFile, Class driverClass, DesiredCapabilities capabilities) throws ParserException, IOException {
        if (driverClass == null) {
            driverClass = SmartClientFirefoxDriver.class;
        }
        return SeleneseRunner.parseEntry(driverClass, capabilities, baseUrl, SeleneseRunner.getTestContent(testFile), null, false);
    }

    public static final class Entry {
        protected String description;
        protected int count;
        protected String title;
    }
}

